/**@author Chris Bobo -=BOBO GAMES=-
 * copyright 1999 all rights reserved -=BOBO GAMES=-
 * thsi is an applet that demonstrates the usage of queues to 
 * find the shortest path between two pts in a wire routing situation
 * @version 1.0
 */
import java.io.*;
import java.applet.Applet;
import java.applet.*;
import java.awt.*;
import java.awt.Toolkit;
import java.awt.event.*;
import java.*;

public class wire_routing extends Applet implements Runnable {
	// critical values for GUI and animation
	public final static int _boardSize		= 19,
						    _boardX			= 20,
						    _boardY			= 20,
							_sqrSize		= 20,
							_noButton		= 0,
							_startButton	= 1,
							_finishButton	= 2,
							_wallButton		= 3,
							_buttonX		= 20,
							_buttonY		= 410,
							_buttonHeight	= 25,
							_buttonWidth	= 80,
							_messagesX		= 420;

	// stuff to create doublebuffer
	Image buffer;
	Graphics bufferGraphics;
	Dimension bufferSize;
		
	Font f = new Font("TimesRoman", Font.PLAIN, 12);
		
	int startX = -1, startY = -1,
		finishX = -1, finishY = -1;
	int mouseX = 0, mouseY = 0;
	int active_button = 0;
	int numOfWalls = 0;
	int pathLength = 0;
	boolean gridClear = true;
	boolean clearWalls = false;
	boolean gridLabeled = false;
	boolean retracingPath = false;
	boolean pause = false;
	boolean pathDone = false;
	boolean labelingGrid = false;
	boolean pathFound = false;
	Image startTile, finishTile, wallTile, floorTile, pathTile;
	Image boboGames, createMaze;
	String message1 = "", message2 = "";
	Button startButton, finishButton, wallButton, labelMazeButton, clearGridButton,
		   constructPathButton, pauseButton, continueButton, clearPathButton,
		   speedUpButton, speedDownButton, presetGridButton;
	Scrollbar speedBar;
	Choice premadeBoards = new Choice();
	Image board[][] = new Image[_boardSize][_boardSize];
	int grid[][] = new int[_boardSize][_boardSize];
	int frameRate = 10; 

	Thread animate;
	Graphics graphics;
	Toolkit toolkit;
	
	final int NumOfNbrs = 4;	// neighbors of a grid position
	int hereX = 0, hereY = 0;
	int nbrX = 0, nbrY = 0;
	LinkedQueue q = new LinkedQueue();

	int offsetX[] = new int[4];
	int offsetY[] = new int[4];
	
	int counter = 0;
	
	// premade boards
	static char backtrack[][] =   { {'S','O','O','O','O','O','O','O','O','O','O','O','O','#','O','O','0'}, 
				 			        {'O','#','O','O','O','#','O','O','O','#','O','O','O','O','#','O','O'},
						            {'O','O','#','O','O','#','#','#','#','O','#','O','O','O','O','#','O'},
								    {'O','O','O','#','O','O','O','O','O','O','O','#','O','O','O','O','O'},
								    {'O','O','O','O','#','O','O','O','#','O','O','#','#','O','#','O','#'},
								    {'O','#','#','#','#','#','O','O','#','#','O','#','#','O','O','#','#'},
								    {'O','#','O','O','#','#','#','O','O','#','#','#','O','O','O','O','#'},
								    {'O','#','O','O','O','#','#','#','O','O','#','#','O','O','O','O','O'},
								    {'O','O','O','O','O','O','O','#','#','O','#','#','O','#','#','O','O'},
								    {'O','#','#','#','#','#','#','#','#','O','#','O','O','O','#','O','#'},
								    {'O','O','O','#','O','O','O','O','O','O','O','O','O','O','#','#','O'},
								    {'O','O','O','#','O','O','#','#','#','#','#','O','O','O','#','#','O'},
								    {'O','#','#','#','O','O','O','O','O','O','O','#','O','#','#','O','O'},
								    {'O','#','#','O','O','O','O','O','O','#','#','O','O','#','O','O','O'},
								    {'O','#','O','O','O','O','O','#','#','O','O','O','#','O','O','#','#'},
								    {'O','O','O','O','#','O','O','#','O','O','O','O','#','O','O','O','O'},
								    {'O','O','O','O','#','O','O','#','O','O','O','O','O','O','O','#','F'} };

	static char spiral[][] =      { {'O','O','O','O','O','O','O','O','O','O','O','O','O','O','O','O','O'}, 
								    {'O','#','#','#','#','#','#','#','#','#','#','#','#','#','#','#','O'},
								    {'O','O','O','O','O','O','O','O','O','O','O','O','O','O','O','#','O'},
								    {'O','O','#','#','#','#','#','#','#','#','#','#','#','#','O','#','O'},
								    {'O','O','#','O','O','O','O','O','O','O','O','O','O','#','O','#','O'},
								    {'O','O','#','O','#','#','#','#','#','#','#','#','O','#','O','#','O'},
								    {'O','O','#','O','#','O','O','O','O','O','O','#','O','#','O','#','O'},
								    {'O','O','#','O','#','O','#','#','#','#','O','#','O','#','O','#','O'},
								    {'O','O','#','O','#','O','#','O','S','#','O','#','O','#','O','#','O'},
								    {'O','O','#','O','#','O','#','O','#','#','O','#','O','#','O','#','O'},
								    {'O','O','#','O','#','O','#','O','O','O','O','#','O','#','O','#','O'},
								    {'O','O','#','O','#','O','#','#','#','#','#','#','O','#','O','#','O'},
								    {'O','O','#','O','#','O','O','O','O','O','O','O','O','#','O','#','O'},
								    {'O','O','#','O','#','#','#','#','#','#','#','#','#','#','O','#','O'},
								    {'O','O','#','O','O','O','O','O','O','O','O','O','O','O','O','#','O'},
								    {'O','O','#','#','#','#','#','#','#','#','#','#','#','#','#','#','O'},
								    {'F','O','O','O','O','O','O','O','O','O','O','O','O','O','O','O','O'} };

	static char noPath[][] =      { {'O','#','O','O','O','#','O','O','O','#','#','O','O','O','O','O','#'}, 
								    {'O','#','O','O','O','#','O','O','O','#','O','O','O','O','O','#','#'},
								    {'O','#','O','#','O','#','#','#','O','O','O','O','O','O','#','#','#'},
								    {'O','#','S','#','O','#','O','#','O','O','#','O','O','#','#','O','O'},
								    {'O','#','#','#','O','#','O','#','O','#','#','O','O','O','#','O','O'},
								    {'O','#','#','#','O','#','#','#','O','#','#','O','O','#','#','O','O'},
								    {'O','O','O','O','O','#','O','O','O','O','#','O','O','#','#','O','O'},
								    {'#','O','O','O','O','#','O','O','O','O','O','#','#','#','O','O','O'},
								    {'#','O','O','O','O','#','O','#','#','O','#','O','#','O','O','F','O'},
								    {'O','O','#','#','#','#','O','#','#','O','#','O','O','O','O','O','O'},
								    {'O','O','#','O','O','O','O','O','O','O','O','#','O','O','O','O','O'},
								    {'O','#','#','O','#','O','O','O','O','#','O','#','O','O','#','#','O'},
								    {'O','O','O','O','#','O','O','O','O','#','#','O','O','O','O','#','#'},
								    {'O','#','#','#','#','O','O','O','#','O','O','O','O','O','O','O','#'},
								    {'O','O','0','#','O','O','O','O','O','#','O','O','O','#','#','#','O'},
								    {'O','O','0','#','O','#','O','O','O','#','#','O','O','#','O','O','O'},
								    {'#','#','O','O','O','#','#','O','#','#','#','#','O','#','O','O','O'} };
	
// I N I T A I L I Z E   A P P L E T///////////////////////////////// 	 
	public void init() {
		startTile	= this.getImage(this.getCodeBase(), "start.gif");
		waitForImage(this, startTile);
		finishTile	= this.getImage(this.getCodeBase(), "finish.gif");
		waitForImage(this, finishTile);
		wallTile	= this.getImage(this.getCodeBase(), "raised_tile.gif");
		waitForImage(this, wallTile);
		floorTile	= this.getImage(this.getCodeBase(), "floor.gif");
		waitForImage(this, floorTile);
		pathTile	= this.getImage(this.getCodeBase(), "path_tile.gif");
		waitForImage(this, pathTile);
		boboGames	= this.getImage(this.getCodeBase(), "bobogames2.gif");
		waitForImage(this, boboGames);
		createMaze	= this.getImage(this.getCodeBase(), "createmaze.gif");
		waitForImage(this, createMaze);

		// set up doublebuffer
		bufferSize = this.getSize();
		buffer = this.createImage(bufferSize.width, bufferSize.height);
		bufferGraphics = buffer.getGraphics();
		
		graphics = getGraphics();
		
		toolkit = this.getToolkit();

		this.setFont(f);
		bufferGraphics.setFont(f);
		
		offsetX[0] = 0;		offsetY[0] = 1;		// right
		offsetX[1] = 1;		offsetY[1] = 0;		// down
		offsetX[2] = 0;		offsetY[2] = -1;	// left
		offsetX[3] = -1;	offsetY[3] = 0;		// up
	
		// setlayout manager to null
		// all objects must be placed manually
		setLayout(null);
		
		startButton = new Button("place start");
		startButton.setBounds(_buttonX, _buttonY, _buttonWidth, _buttonHeight);
		add(startButton);
		startButton.addMouseListener(new MouseAdapter() {
			public void mousePressed(MouseEvent e) {
				message1 = message2 = "";
				if(labelingGrid || retracingPath || pathDone || gridLabeled) {
					toolkit.beep();
					message1 = "Cannot place start at this time...";
				}
				else {
					active_button = _startButton;
				}
			}
		});
		finishButton = new Button("place finish");
		finishButton.setBounds(_buttonX + _buttonWidth + 5, _buttonY, _buttonWidth, _buttonHeight);
		add(finishButton);
		finishButton.addMouseListener(new MouseAdapter() {
			public void mousePressed(MouseEvent e) {
				message1 = message2 = "";	// clear messages
				if(labelingGrid || retracingPath || pathDone || gridLabeled) {
					// busy doing something else
					toolkit.beep();
					message1 = "Cannot place finish at this time...";
				}
				else {
					active_button = _finishButton;
				}
			}
		});
		wallButton = new Button("place blockage");
		wallButton.setBounds(_buttonX + _buttonWidth*2 + 10, _buttonY, _buttonWidth, _buttonHeight);
		add(wallButton);
		wallButton.addMouseListener(new MouseAdapter() {
			public void mousePressed(MouseEvent e) {
				message1 = message2 = "";	// clear messages
				if(labelingGrid || retracingPath || pathDone || gridLabeled) {
					// busy doing something else
					toolkit.beep();
					message1 = "Cannot place blockage at this time...";
				}
				else {
					active_button = _wallButton;
				}
			}
		});
		labelMazeButton = new Button("label grid");
		labelMazeButton.setBounds(_buttonX + _buttonWidth*3 + 15, _buttonY, _buttonWidth, _buttonHeight);
		add(labelMazeButton);
		labelMazeButton.addMouseListener(new MouseAdapter() {
			public void mousePressed(MouseEvent e) {
				message1 = message2 = "";	// clear messages
				if(labelingGrid) {	// grid is already begin labeled
					toolkit.beep();
					message1 = "Grid is currently being labeled...";
				}// end if
				else {
					if(gridLabeled && pathFound) {// grid has laready been labeled
						toolkit.beep();
						message1 = "Grid is already labeled, now \"retrace path\"...";
					}// end if
					else if(gridLabeled && !pathFound) {// grid ahs laready been labeled
						toolkit.beep();
						message1 = "Grid is already labeled, no path exists...";
					}// end else if
				}// end else

				if(startX > 0 && finishX > 0) {// both start and finish have been placed
					if(!labelingGrid && !pathDone && !gridLabeled) {
						InitLabelGrid();
						labelingGrid = true;
						message1 = "To pause labeling, press pause...";
					}
				}
				else {// start and/or finish have not been placed
					toolkit.beep();
					message1 = "!!! You must first place start and finish !!!"; 
				}// end else
			}// end mousePressed
		});
		constructPathButton = new Button("retrace path");
		constructPathButton.setBounds(_buttonX, _buttonY+30, _buttonWidth, _buttonHeight);
		add(constructPathButton);
		constructPathButton.addMouseListener(new MouseAdapter() {
			public void mousePressed(MouseEvent e) { 
				message1 = message2 = "";	// clear messages
				if(gridLabeled && !pathFound && pathDone) {
					toolkit.beep();
					message1 = "No path exists...";
				}
				else if(gridLabeled && pathDone) {
					toolkit.beep();
					message1 = "Path has already been retraced...";
				}
				else if(gridLabeled && retracingPath) {
					toolkit.beep();
					message1 = "Path is currently being retraced...";
				}
				if(!retracingPath && !pathDone) {
					if(InitRetracePath()) { retracingPath = true; }
				}// end if
			}// end mousedPressed
		});
		pauseButton = new Button("pause");
		pauseButton.setBounds(_buttonX + _buttonWidth*1 + 5, _buttonY+30, _buttonWidth, _buttonHeight);
		add(pauseButton);
		pauseButton.addMouseListener(new MouseAdapter() {
			public void mousePressed(MouseEvent e) { 
				message1 = "";	// clear messages
				if(labelingGrid || retracingPath) { 
					// remove the pause button and replace it with a continue button
					remove(pauseButton);
					add(continueButton);
					pause = true;
					message1 = "To continue, press continue...";
				}
				else {// there is no need to pause the applet now
					toolkit.beep(); 
					message1 = "Cannot pause now...";
				}
			}
		});
		continueButton = new Button("continue");
		continueButton.setBounds(_buttonX + _buttonWidth*1 + 5, _buttonY+30, _buttonWidth, _buttonHeight);
		continueButton.addMouseListener(new MouseAdapter() {
			public void mousePressed(MouseEvent e) { 
				message1 = "";	// clear messages
				// remove the continue button and replce it with a pause button
				active_button = _noButton;
				remove(continueButton);
				add(pauseButton);
				pause = false;
			}
		});
		clearPathButton = new Button("clear path");
		clearPathButton.setBounds(_buttonX + _buttonWidth*2 + 10, _buttonY+30, _buttonWidth, _buttonHeight);
		add(clearPathButton);
		clearPathButton.addMouseListener(new MouseAdapter() {
			public void mousePressed(MouseEvent e) { ClearPath(); }
		});
		clearGridButton = new Button("clear grid");
		clearGridButton.setBounds(_buttonX + _buttonWidth*3 + 15, _buttonY+30, _buttonWidth, _buttonHeight);
		add(clearGridButton);
		clearGridButton.addMouseListener(new MouseAdapter() {
			public void mousePressed(MouseEvent e) { ClearGrid(); }
		});
		//speed bar
		speedBar = new Scrollbar(Scrollbar.HORIZONTAL, 100, 0, 1, 30);
		speedBar.setBounds(_buttonX + _buttonWidth*4 + 20, _buttonY + 10,
						   _buttonWidth + 20, _buttonHeight - 10);
		add(speedBar);
		speedBar.setValue(10);
		speedBar.addAdjustmentListener(new AdjustmentListener() {
			public void adjustmentValueChanged(AdjustmentEvent e) {
				frameRate = e.getValue();
			}
		});		
		
		//premadeBoards choice
		premadeBoards.add("choose a grid");
		premadeBoards.add("Backtrack");
		premadeBoards.add("Spiral");
		premadeBoards.add("No Path");
		premadeBoards.setBounds(_buttonX + _buttonWidth*4 + 20, _buttonY+30,
								_buttonWidth + 20, _buttonHeight);
		add(premadeBoards);
		premadeBoards.addItemListener(new ItemListener() {
			public void itemStateChanged(ItemEvent e) {
				int selection = 0;
				selection = premadeBoards.getSelectedIndex();
				if(selection == 0) ClearGrid();
				else if(selection == 1) PresetGrid(backtrack);
				else if(selection == 2) PresetGrid(spiral);
				else if(selection == 3) PresetGrid(noPath);
			}
		});

		// init grid
		ClearGrid();
		
// M O U S E   D R A G G E D/////////////////////////////////////////
		this.addMouseMotionListener(new MouseMotionAdapter() {
			public void mouseDragged(MouseEvent e) {
				if(gridClear && !gridLabeled) {
					// translate the mousePos into (x,y) coordinates for the board
					mouseX = ((e.getX() - _boardX) / _sqrSize);
					mouseY = ((e.getY() - _boardY) / _sqrSize);
					if(WithinBoard()) {
						switch(active_button) {
							case _startButton: {// add/move the start tile
								if(startX > 0)
									board[startX][startY] = floorTile;
								startX = mouseX; startY = mouseY;						
								board[mouseX][mouseY] = startTile;
								grid[mouseX][mouseY] = 0;
								break;}
							case _finishButton: {// add/move the finish tile
								if(finishX > 0)
									board[finishX][finishY] = floorTile;
								finishX = mouseX; finishY = mouseY;						
								board[finishX][finishY] = finishTile;
								grid[mouseX][mouseY] = 0;
								break;}
							case _wallButton: {
								if(!clearWalls) {// add a wall tile
									if(grid[mouseX][mouseY] == 0) numOfWalls++;
									if(mouseX == startX && mouseY == startY)
										startX = startY = -1;
									if(mouseX == finishX && mouseY == finishY)
										finishX = finishY = -1;
									board[mouseX][mouseY] = wallTile;
									grid[mouseX][mouseY] = 1;}
								else {// remove a wall tile
									if(grid[mouseX][mouseY] == 1) numOfWalls--;
									if(mouseX == startX && mouseY == startY) break;
									if(mouseX == finishX && mouseY == finishY) break;
									board[mouseX][mouseY] = floorTile;
									grid[mouseX][mouseY] = 0;}
								break; }
							default: break;
						}// end switch
					}// end if
				}// end if(gridClear)
			}// end mousePressed
		});
		
// M O U S E   P R E S S E D/////////////////////////////////////////		
		this.addMouseListener(new MouseAdapter() {
			public void mousePressed(MouseEvent e) {
				if(gridClear && !gridLabeled) {
					// translate mousePos into (x,y) coordinates for the board
					mouseX = ((e.getX() - _boardX) / _sqrSize);
					mouseY = ((e.getY() - _boardY) / _sqrSize);
					if(WithinBoard()) {
						message1 = message2 = "";	// clear messages
						switch(active_button) {
							case _startButton: {// add/move start tile
								if(startX > 0)
									board[startX][startY] = floorTile;
								startX = mouseX; startY = mouseY;						
								board[mouseX][mouseY] = startTile;
								grid[mouseX][mouseY] = 0;
								break;
							}
							case _finishButton: {// add/move finish tile
								if(finishX > 0)
									board[finishX][finishY] = floorTile;
								finishX = mouseX; finishY = mouseY;						
								board[finishX][finishY] = finishTile;
								grid[mouseX][mouseY] = 0;
								break;
							}
							case _wallButton: {
								if(board[mouseX][mouseY] != wallTile) clearWalls = false;
								else clearWalls = true;
								if(!clearWalls) {// add a wall tile
									if(grid[mouseX][mouseY] == 0) numOfWalls++;
									if(mouseX == startX && mouseY == startY)
										startX = startY = -1;
									if(mouseX == finishX && mouseY == finishY)
										finishX = finishY = -1;
									board[mouseX][mouseY] = wallTile;
									grid[mouseX][mouseY] = 1;}
								else {// remove a wall tile
									if(grid[mouseX][mouseY] == 1) numOfWalls--;
									if(mouseX == startX && mouseY == startY) break;
									if(mouseX == finishX && mouseY == finishY) break;
									board[mouseX][mouseY] = floorTile;
									grid[mouseX][mouseY] = 0;}
								break; }
							default: break;
						}// end switch
					}// end if
				}// end if(gridClear)
			}// end mousePressed
		});
	} // end init()
	
// W I T H I N   B O A R D///////////////////////////////////////////	
	public boolean WithinBoard() {
		// checks if acitve_button is valid
		// and if mouse is on board
		if(mouseX > 0 && mouseX < _boardSize - 1 &&
		   mouseY > 0 && mouseY < _boardSize - 1 ) // tile is inside of board
			return true;
		
		// tile not inside board, give appropriate error below
		if(active_button == _wallButton && (mouseX < 0 || mouseX > (_boardSize - 1) ||
		   mouseY < 0 || mouseY > (_boardSize - 1)) ) {
				toolkit.beep();
				message1 = "Walls must be placed inside board...";
		}
		if(active_button == _startButton) {
			toolkit.beep();
			message1 = "Start must be placed inside board...";
		}
		if(active_button == _finishButton) {
			toolkit.beep();
			message1 = "Finish must be placed inside board...";
		}
		return false;
	}

// C L E A R   M A Z E///////////////////////////////////////////////	
	public void ClearGrid() {// clear board
		for(int i = 0; i < _boardSize; i++) {
			for(int j = 0; j < _boardSize; j++) {
				if(i == 0 || i == _boardSize-1) 
					{ board[j][i] = wallTile; grid[j][i] = 1; }
				else if(j == 0 || j == _boardSize-1) 
					{ board[j][i] = wallTile; grid[j][i] = 1; }
				else { board[j][i] = floorTile; grid[j][i] = 0; }
			}
		}

		// if continue button is showing replace it with pause button
		if(continueButton.isShowing()) {
			this.remove(continueButton);
			this.add(pauseButton);
		}
		
		// reset all of these values
		startX = startY = finishX = finishY = -1;
		active_button = numOfWalls = pathLength = 0;
		gridClear = true;
		pause = retracingPath = false;
		labelingGrid = gridLabeled = pathDone = false;
		message1 = message2 = "";
	}// end ClearGrid()
	
// C L E A R   P A T H///////////////////////////////////////////////
	public void ClearPath() {// clears path but leaves the all tiles in place
		for(int i = 1; i < _boardSize; i++) {
			for(int j = 1; j < _boardSize; j++) {
				if(board[j][i] != wallTile) { 
					board[j][i] = floorTile;
					grid[j][i] = 0;
				}// end if 
			}// end for(j)
		}// end for(i)
		board[startX][startY] = startTile;
		board[finishX][finishY] = finishTile;
		
		if(continueButton.isShowing()) {
			this.remove(continueButton);
			this.add(pauseButton);
		}
		
		// reset these values
		active_button = pathLength = 0;
		gridClear = true;
		pause = retracingPath = false;
		labelingGrid = gridLabeled = pathDone = false;
		message1 = message2 = "";
	}// end ClearPath()
	
// I N I T   F I N D   P A T H///////////////////////////////////////
	public boolean InitLabelGrid() {
		if(gridLabeled) return true;
		gridClear = false;
		while(!q.isEmpty()) { q.remove(); }
		hereX = startX;
		hereY = startY;
		grid[hereX][hereY] = 2;
		return true;
	}
	
// L A B E L  M A Z E////////////////////////////////////////////////
	public boolean LabelGrid() {
		if(!gridLabeled) {
			for(int i = 0; i < NumOfNbrs; i++) {				
				nbrX = hereX + offsetX[i];
				nbrY = hereY + offsetY[i];
				if(grid[nbrX][nbrY] == 0) {
					grid[nbrX][nbrY] = grid[hereX][hereY] + 1;
					if((nbrX == finishX) && (nbrY == finishY)) break;
					q.put(nbrX);
					q.put(nbrY);
				}// end if
			}// end for
		
			if( (nbrX == finishX) && (nbrY == finishY) ) {
				pathFound = gridLabeled = true;
				labelingGrid = false;
				toolkit.beep();
				message1 = ("Path Found... Now \"retrace path\" ");
				pathLength = grid[finishX][finishY] - 2;
				return true;
			}// end if
			else if(q.isEmpty()) { 
				labelingGrid = pathFound = false; 
				pathDone = gridLabeled = true;
				toolkit.beep();
				message1 = ("No Path Exists...");
				return false;
			}// end else if
			else { hereX = q.remove(); hereY = q.remove(); }
		}// end if(!gridLabeled)
	return true;
	}// end LabelMaze
	
// I N I T   R E T R A C E   P A T H/////////////////////////////////
	public boolean InitRetracePath() {
		if(startX < 0 || finishX < 0) {
			toolkit.beep();
			message1 = "!!! You must first place start and finish !!!";
			return false;
		}// end if

		if(!gridLabeled) {
			toolkit.beep();
			message1 = "!!! You must first label the grid !!!";
			return false;
		}

//		pathLength = grid[finishX][finishY] - 2;
		// trace backwards from finish
		hereX = finishX;
		hereY = finishY;
		counter = pathLength;
		return true;
	}// end InitRetracePath()
		
// R E T R A C E  P A T H ///////////////////////////////////////////
	public void RetracePath() {
		// find predecessor position(MazeSqr)
		for(int i = 0; i < NumOfNbrs; i++) {
			nbrY = hereY + offsetY[i];
			nbrX = hereX + offsetX[i];
			if(nbrX < 0 || nbrY < 0) break;
			if(grid[nbrX][nbrY] == counter+1) break;
		}
		if(board[nbrX][nbrY] == startTile) {
			retracingPath = false;
			pathDone = true;
		}
		else {
			board[nbrX][nbrY] = pathTile;
			hereX = nbrX; hereY = nbrY;		// move to predecessor
			counter--;
		}
	}// end of RetracePath()

// P A I N T/////////////////////////////////////////////////////////	
	public void paint(Graphics g) {
		bufferGraphics.setColor(Color.black);
		bufferGraphics.fillRect(0, 0, bufferSize.width, bufferSize.height);
		bufferGraphics.setColor(Color.white);
		
		int temp; // used to correctly space number on board
		// paint board in here
		for(int i = 0; i < _boardSize; i++) {
			for(int j = 0; j < _boardSize; j++) {
				bufferGraphics.drawImage(board[j][i], (_boardX + j*_sqrSize),
										(_boardY + i*_sqrSize), this);
				temp = grid[j][i] - 2;
				if(temp > 0) {
					if(temp < 10)
					bufferGraphics.drawString(""+(grid[j][i] - 2), (_boardX + 7 + j*_sqrSize),
											 (_boardY + 15 + i*_sqrSize));
					else if(temp < 100)
					bufferGraphics.drawString(""+(grid[j][i] - 2), (_boardX + 4 + j*_sqrSize),
											 (_boardY + 15 + i*_sqrSize));
					else
					bufferGraphics.drawString(""+(grid[j][i] - 2), (_boardX + j*_sqrSize),
											 (_boardY + 15 + i*_sqrSize));
				}
			}
		}
		
		if(finishX > 0)
		bufferGraphics.drawImage(board[finishX][finishY], (_boardX + finishX*_sqrSize),
								(_boardY + finishY*_sqrSize), this);
		bufferGraphics.drawImage(createMaze, 415, 10, this);
		bufferGraphics.drawImage(boboGames, 500, 445, this);
		
		if(pathLength == 0)
			bufferGraphics.drawString("pathLength = 0", _messagesX, 80);
		else
			bufferGraphics.drawString("pathLength = " +(pathLength - 1), _messagesX, 80);
		bufferGraphics.drawString("Start = (" +startX+ "," +startY+ ")", _messagesX, 100);
		bufferGraphics.drawString("Finish = (" +finishX+ "," +finishY+ ")", _messagesX, 120);
		bufferGraphics.drawString("Number of walls = " +numOfWalls, _messagesX, 140);
		bufferGraphics.drawString("Speed = " +frameRate+ " frames/sec", _messagesX, 160);
		bufferGraphics.drawString("s  p  e  e  d", _buttonX + _buttonWidth*4 + 45, _buttonY + 5); 
		
		bufferGraphics.setColor(Color.yellow);
		bufferGraphics.drawString(message1, _messagesX, 180);
		bufferGraphics.drawString(message2, _messagesX, 200);
		if(pathDone)
			bufferGraphics.drawString("!!! Clear path or grid to continue !!!",
									  _messagesX, 220);
		
		bufferGraphics.setColor(Color.white);
		bufferGraphics.drawString("             Instructions", _messagesX, 240);
		bufferGraphics.drawString("             ---------------", _messagesX, 245);
		bufferGraphics.drawString("2) \"place start\" and \"place finish\" ", _messagesX, 260);
		bufferGraphics.drawString("3) \"place blockages\" as you wish", _messagesX, 275);
		bufferGraphics.drawString("4) \"label grid\" ", _messagesX, 290);
		bufferGraphics.drawString("5) \"retrace path\" ", _messagesX, 305);
		bufferGraphics.drawString("6) \"clear path\" or \"clear grid\" and repeat", _messagesX, 320);
		bufferGraphics.drawString("NOTE: instead of making a grid ", _messagesX, 335);
		bufferGraphics.drawString("              you can use a \"premade grid\"", _messagesX, 350);
		
		g.drawImage(buffer, 0, 0, this);
	}
	
// U P D A T E///////////////////////////////////////////////////////	
	public void update(Graphics g) { paint(g); }

// R U N/////////////////////////////////////////////////////////////
	public void run() {
		Thread thisThread = Thread.currentThread();
		long start = 0, sleep = 0;
		while(true) {
			start = System.currentTimeMillis();
			if(!pause) {
				if(!pathDone) {
					if (labelingGrid) {
						LabelGrid();
					}					
					if (retracingPath) {
						RetracePath(); 
					}
				}
			}// end if(!pause)
			
			// no filcker but bad animation
			repaint();
			
			sleep = frameRate - (int)(System.currentTimeMillis() - start);
			if(sleep <= 0) sleep = 1;	// never divide by zero
			sleep = 1000 / sleep;
			start = System.currentTimeMillis();
			try { thisThread.sleep(sleep); }
			catch (InterruptedException e) {}
			System.out.println("time = " +(System.currentTimeMillis() - start) );
		}
	}
	public void start() {
		if(animate == null)
			animate = new Thread(this);		
			animate.start();
	}
	public void stop() {
		animate = null;
	}

// W A I T   F O R   I M A G E///////////////////////////////////////	
    public static void waitForImage(Component component, Image image) {
        MediaTracker tracker = new MediaTracker(component);
        try {
            tracker.addImage(image, 0);
            tracker.waitForID(0);
        }
        catch(InterruptedException e) { e.printStackTrace(); }
    }
	
// P R E S E T   G R I D/////////////////////////////////////////////
	public void PresetGrid(char preset_grid[][]) {
		ClearGrid();
		for(int i = 1; i < _boardSize - 1; i++) {
			for(int j = 1; j < _boardSize - 1; j++) {
				switch (preset_grid[j-1][i-1]) {
					case 'S': {
								  startX = i;
								  startY = j;
								  board[i][j] = startTile;
								  grid[i][j] = 0;
								  break;
							  }
					case 'F': {
								  finishX = i;
								  finishY = j;
								  board[i][j] = finishTile;
								  grid[i][j] = 0;
								  break;
							  }
					case 'O': {
								  board[i][j] = floorTile;
								  grid[i][j] = 0;
								  break;
							  }
					case '#': {
								  board[i][j] = wallTile;
								  grid[i][j] = 1;
								  numOfWalls++;
								  break;
							  }
					default : break;
				}// end switch
			}// end for j
		}// end for i
	}// end PresetGrid

}// end wires class