/**@author Chris Bobo -=BOBO GAMES=-
 * copyright 1999 all rights reserved -=BOBO GAMES=-
 * this is an applet that demonstrates the usage of 
 * stacks to find a path through a maze
 * @version 1.0
 */

import java.io.*;
import java.applet.Applet;
import java.awt.Graphics;
import java.applet.*;
import java.applet.AudioClip;
import java.awt.*;
import java.awt.Toolkit;
import java.awt.event.*;
import java.util.*;

public class Maze extends Applet implements Runnable {
	
	// critical values for GUI and animation
	public final static int _boardSize		= 19,
						    _boardX			= 20,
						    _boardY			= 20,
							_sqrSize		= 20,
							_wallButton		= 1,
							_noButton		= 2,
							_buttonX		= 43,
							_buttonY		= 415,
							_buttonHeight	= 25,
							_buttonWidth	= 80,
							_messageX		= 420,
							_legendY		= 255,
							_legendSize		= 25,
							_legendTextY	= _legendY + 15,
							_instructionsY	= 165;

	// doublebuffer
	Image buffer;
	Graphics bufferGraphics;
	Dimension bufferSize;

	Font f = new Font("TimesRoman", Font.PLAIN, 12);
		
	int startX = 1, startY = 1,
		finishX = (_boardSize - 2),
		finishY = (_boardSize - 2);
	int mouseX = 0, mouseY = 0;
	int active_button = 0;
	int numOfWalls = 0;
	int pathLength = 0;
	
	boolean mazeClear = true;
	boolean clearWalls = false;
	boolean pathConstructed = false;
	boolean findingPath = false;	
	boolean pathDone = false;
	boolean pathFound = false;
	boolean pause = false;
	
	Thread animate;
	int currLabel = 0;
	int r = 0, c = 0;
	int LastOption = 3;
	int option = 0;
	int frameRate = 10;
	Point next;
	Point mouseGifPos = new Point(1,1);
	Stack path = new Stack();
	Image startTile, finishTile, wallTile, floorTile;
	Image boboGames, createMaze, visitedTile, unUsableTile;
	Image [] mouseGif = new Image[4];
	String message1 = "";
	// GUI components
	Button wallButton, findPathButton, clearMazeButton, 
		   pauseButton, continueButton, clearPathButton;
	Scrollbar speedBar;
	Choice premadeBoards = new Choice();					  
	Image [][] board = new Image[_boardSize][_boardSize];
	int [][] maze = new int[_boardSize][_boardSize];
	Graphics graphics;
	Toolkit toolkit;
	
    // initialize offsets
    Point [] offset = new Point [4];
    Point here = new Point(1, 1);
	
	int [] mouseDir = new int[(_boardSize * _boardSize) * 2];
	int animationCnt = 0;
	
	// premade boards
	static char backtrack[][] =   { {'S','O','O','O','O','O','O','#','O','O','O','O','O','#','O','O','#'}, 
				 			        {'O','O','O','O','O','#','O','O','O','#','O','O','O','#','#','O','O'},
						            {'O','O','#','O','O','#','#','#','#','O','#','O','O','O','O','#','O'},
								    {'O','O','O','#','O','O','O','O','O','O','O','#','O','O','O','O','#'},
								    {'O','O','O','O','#','O','O','#','#','O','O','O','#','O','#','O','O'},
								    {'O','#','#','#','#','#','O','O','#','O','O','#','O','O','O','#','O'},
								    {'O','#','O','O','#','O','O','O','O','#','O','#','O','O','O','O','#'},
								    {'O','#','O','O','O','#','#','O','O','O','#','#','O','O','O','O','O'},
								    {'O','O','O','O','O','O','O','#','O','O','#','#','O','#','O','O','O'},
								    {'O','#','#','#','#','#','#','#','#','#','O','O','O','O','#','O','#'},
								    {'O','O','O','#','O','O','O','O','O','#','O','O','O','O','#','O','O'},
								    {'O','O','O','#','O','O','#','#','#','#','#','O','O','O','O','#','O'},
								    {'O','#','#','#','O','O','O','O','O','O','O','#','O','O','#','O','O'},
								    {'O','O','#','O','O','O','O','O','O','#','#','O','O','#','O','O','O'},
								    {'O','#','O','O','O','O','O','#','#','O','O','O','#','O','O','#','#'},
								    {'O','O','O','O','#','O','O','#','O','O','O','O','#','O','O','O','O'},
								    {'O','O','O','O','#','O','O','#','O','O','O','O','O','O','O','#','F'} };

	static char spiral[][] =      { {'S','O','O','O','O','O','#','O','O','O','O','O','O','O','O','O','O'}, 
								    {'#','O','#','#','#','O','#','O','#','O','#','#','#','O','O','#','O'},
								    {'O','O','O','O','#','O','O','O','#','O','O','O','#','O','O','#','O'},
								    {'#','O','#','#','#','#','#','#','#','#','#','#','#','#','#','#','O'},
								    {'O','O','#','O','O','O','O','O','O','O','O','O','O','#','O','#','O'},
								    {'O','#','#','O','#','#','#','#','#','#','#','#','O','#','O','O','O'},
								    {'O','O','#','O','#','O','O','O','O','O','O','#','O','#','#','#','O'},
								    {'#','O','#','O','#','O','#','#','#','#','O','#','O','#','O','O','O'},
								    {'O','O','#','O','#','O','#','O','O','#','O','#','O','#','#','O','O'},
								    {'O','#','#','O','#','O','#','O','#','#','O','#','O','#','O','O','O'},
								    {'O','O','#','O','#','O','#','O','O','O','O','#','O','#','O','#','O'},
								    {'#','O','#','O','#','O','#','#','#','#','#','#','O','#','O','#','O'},
								    {'O','O','#','O','#','O','O','O','O','O','O','O','O','O','O','#','#'},
								    {'O','#','#','O','#','O','O','O','O','O','O','O','O','#','O','O','O'},
								    {'O','O','#','O','#','#','#','#','#','#','#','#','#','#','#','#','#'},
								    {'#','O','#','O','O','O','O','#','O','O','O','#','O','O','O','#','O'},
								    {'O','O','#','O','O','#','O','O','O','#','O','O','O','#','O','O','F'} };

	static char noPath[][] =      { {'S','#','O','O','O','#','O','O','O','#','#','O','O','O','O','O','#'}, 
								    {'O','#','O','O','O','#','O','O','O','#','O','O','O','O','O','#','O'},
								    {'O','#','O','#','O','#','#','O','O','O','#','O','O','O','#','O','O'},
								    {'O','#','O','#','O','#','O','#','O','O','O','#','O','#','O','O','O'},
								    {'O','#','#','#','O','#','O','#','O','#','O','O','O','O','#','O','O'},
								    {'O','#','#','#','O','#','O','#','O','#','#','O','O','O','#','O','#'},
								    {'O','O','O','O','O','#','#','O','O','O','#','O','O','#','O','O','#'},
								    {'#','O','O','O','O','#','O','O','O','O','O','#','#','#','O','O','#'},
								    {'#','O','O','O','O','#','O','O','O','#','#','O','#','O','O','#','#'},
								    {'O','O','#','#','#','#','O','O','O','O','#','O','O','O','O','O','O'},
								    {'O','O','#','O','O','O','O','O','O','O','O','#','O','O','O','O','O'},
								    {'O','#','#','O','#','O','O','O','O','#','O','#','O','O','#','O','O'},
								    {'O','O','O','O','#','O','O','O','O','#','#','O','O','O','O','#','O'},
								    {'O','#','#','#','#','O','O','O','#','O','O','O','O','O','O','O','#'},
								    {'O','O','0','#','O','O','O','O','O','#','O','O','O','O','#','#','O'},
								    {'O','O','0','#','O','#','O','O','O','O','#','O','O','#','O','O','O'},
								    {'O','#','O','O','O','#','#','O','O','O','O','#','O','O','O','O','F'} };

// I N I T A I L I Z E   A P P L E T///////////////////////////////// 	 
	public void init() {
		// load images
		startTile	= this.getImage(this.getCodeBase(), "start.gif");
		waitForImage(this, startTile);
		finishTile	= this.getImage(this.getCodeBase(), "finish.gif");
		waitForImage(this, finishTile);
		wallTile	= this.getImage(this.getCodeBase(), "raised_tile.gif");
		waitForImage(this, wallTile);
		floorTile	= this.getImage(this.getCodeBase(), "floor.gif");
		waitForImage(this, floorTile);
		visitedTile	= this.getImage(this.getCodeBase(), "visited.gif");
		waitForImage(this, visitedTile);
		unUsableTile= this.getImage(this.getCodeBase(), "unusable.gif");
		waitForImage(this, unUsableTile);
		boboGames	= this.getImage(this.getCodeBase(), "bobogames2.gif");
		waitForImage(this, boboGames);
		createMaze	= this.getImage(this.getCodeBase(), "createmaze.gif");
		waitForImage(this, createMaze);
		mouseGif[0]	= this.getImage(this.getCodeBase(), "mouse_right.gif");
		waitForImage(this, mouseGif[0]);
		mouseGif[1]	= this.getImage(this.getCodeBase(), "mouse_down.gif");
		waitForImage(this, mouseGif[1]);
		mouseGif[2]	= this.getImage(this.getCodeBase(), "mouse_left.gif");
		waitForImage(this, mouseGif[2]);
		mouseGif[3]	= this.getImage(this.getCodeBase(), "mouse_up.gif");
		waitForImage(this, mouseGif[3]);
		
		// set up doublebuffer
		bufferSize = this.getSize();
		buffer = this.createImage(bufferSize.width, bufferSize.height);
		bufferGraphics = buffer.getGraphics();
		
		// used for direct all to paint()
		graphics = this.getGraphics();
		
		// set the font
		this.setFont(f);
		bufferGraphics.setFont(f);
	
		// get systemToolkit
		toolkit = this.getToolkit();
		
		// init array
		for(int i  = 0; i < ( (_boardSize - 2) * (_boardSize - 2) ); i++)
			mouseDir[i] = 0;
		
		// set offsets
		offset[0] = new Point(1, 0);   // right
		offset[1] = new Point(0, 1);   // down
		offset[2] = new Point(-1, 0);  // left
		offset[3] = new Point(0, -1);  // up

		// setlayout manager to null
		// all objects must be placed manually
		setLayout(null);
		
		wallButton = new Button("place walls");
		wallButton.setBounds(_buttonX, _buttonY, _buttonWidth, _buttonHeight);
		add(wallButton);
		wallButton.addMouseListener(new MouseAdapter() {
			public void mousePressed(MouseEvent e) {
				message1 = "";
				if(findingPath || pathDone) { 
					toolkit.beep(); 
					message1 = "Cannot place walls now...";
				}
				if(active_button != _wallButton)
					active_button = _wallButton;
				else active_button = _noButton;
			}
		});
		findPathButton = new Button("find path");
		findPathButton.setBounds(_buttonX + _buttonWidth + 5, _buttonY,
								 _buttonWidth, _buttonHeight);
		add(findPathButton);
		findPathButton.addMouseListener(new MouseAdapter() {
			public void mousePressed(MouseEvent e) {
				message1 = "";
				active_button = _noButton;
				animationCnt = 0;
				mouseDir[0] = 1;
				if(findingPath) { 
					toolkit.beep();
					message1 = "Currently finding path...";
				}
				if(pathDone) {
					toolkit.beep();
					if(pathFound) message1 = "Path already found...";
					else message1 = "No path exists...";
				}
				if(!findingPath) {
					FindPath();	// initailizes FindPath();
					mazeClear = false;
					findingPath = true;
					message1 = "To pause path construction press pause...";
				}
			}
		});
		pauseButton = new Button("pause");
		pauseButton.setBounds(_buttonX + _buttonWidth*2 + 10, _buttonY,
							  _buttonWidth, _buttonHeight);
		add(pauseButton);
		pauseButton.addMouseListener(new MouseAdapter() {
			public void mousePressed(MouseEvent e) { 
				message1 = "";
				if(pathDone || !findingPath) { 
					toolkit.beep(); 
					message1 = "Cannot pause now...";
				}
				else {
					remove(pauseButton);
					add(continueButton);
					pause = true;
				}
			}
		});
		continueButton = new Button("continue");
		continueButton.setBounds(_buttonX + _buttonWidth*2 + 10, _buttonY, 
								 _buttonWidth, _buttonHeight);
		continueButton.addMouseListener(new MouseAdapter() {
			public void mousePressed(MouseEvent e) { 
				message1 = "";
				active_button = _noButton;
				if(pathDone || !findingPath) { 
					toolkit.beep(); 
					message1 = "Cannot pause now...";
				}
				else {
					remove(continueButton);
					add(pauseButton);
					pause = false;
				}
			}
		});
		clearPathButton = new Button("clear path");
		clearPathButton.setBounds(_buttonX, _buttonY + 30, _buttonWidth,
								  _buttonHeight);
		add(clearPathButton);
		clearPathButton.addMouseListener(new MouseAdapter() {
			public void mousePressed(MouseEvent e) { 
				active_button = _noButton;
				ClearPath();
			}
		});
		clearMazeButton = new Button("clear maze");
		clearMazeButton.setBounds(_buttonX + _buttonWidth + 5, _buttonY + 30,
						   _buttonWidth, _buttonHeight);
		add(clearMazeButton);
		clearMazeButton.addMouseListener(new MouseAdapter() {
			public void mousePressed(MouseEvent e) { 
				active_button = _noButton;
				ClearMaze(); 
			}
		});
		speedBar = new Scrollbar(Scrollbar.HORIZONTAL, 100, 0, 1, 30);
		speedBar.setBounds(_buttonX + _buttonWidth*3 + 15, _buttonY + 10, 
						   _buttonWidth, _buttonHeight - 10);
		add(speedBar);
		speedBar.setValue(10);
		speedBar.addAdjustmentListener(new AdjustmentListener() {
			public void adjustmentValueChanged(AdjustmentEvent e) {
				frameRate = e.getValue();
			}
		});		
		
		// premadeBoards choice
		premadeBoards.add("choose a maze");
		premadeBoards.add("Random");
		premadeBoards.add("Spiral");
		premadeBoards.add("No Path");
		premadeBoards.setBounds(_buttonX + _buttonWidth*2 + 10, 
								_buttonY+30, _buttonWidth*2 + 5, _buttonHeight);
		add(premadeBoards);
		premadeBoards.addItemListener(new ItemListener() {
			public void itemStateChanged(ItemEvent e) {
				int selection = 0;
				selection = premadeBoards.getSelectedIndex();
				if(selection == 0) ClearMaze();
				else if(selection == 1) PresetGrid(backtrack);
				else if(selection == 2) PresetGrid(spiral);
				else if(selection == 3) PresetGrid(noPath);
			}
		});

		// initailize maze
		ClearMaze();
		
// M O U S E   D R A G G E D/////////////////////////////////////////
		this.addMouseMotionListener(new MouseMotionAdapter() {
			public void mouseDragged(MouseEvent e) {
				if(mazeClear) {
					mouseX = ((e.getX() - _boardX) / _sqrSize);
					mouseY = ((e.getY() - _boardY) / _sqrSize);
					if(WithinBoard()) {
						if(active_button == _wallButton) {
							message1 = "";
							if(!clearWalls) {
								if(maze[mouseX][mouseY] == 0) numOfWalls++;
								board[mouseX][mouseY] = wallTile;
								maze[mouseX][mouseY] = 1;}
							else {
								if(maze[mouseX][mouseY] == 1) numOfWalls--;
								board[mouseX][mouseY] = floorTile;
								maze[mouseX][mouseY] = 0;}
						}// end if
					}// end if(active_button)
				}// end if(mazeClear)
			}// end mouseDragged
		});
		
// M O U S E   P R E S S E D/////////////////////////////////////////		
		this.addMouseListener(new MouseAdapter() {
			public void mousePressed(MouseEvent e) {
				if(mazeClear) {
					mouseX = ((e.getX() - _boardX) / _sqrSize);
					mouseY = ((e.getY() - _boardY) / _sqrSize);
					if(WithinBoard()) {
						if(active_button == _wallButton) {
							message1 = "";
							// clear or place walls?
							if(maze[mouseX][mouseY] == 0) {
								clearWalls = false;
								numOfWalls++;
								board[mouseX][mouseY] = wallTile;
								maze[mouseX][mouseY] = 1;
							}
							else {
								if(maze[mouseX][mouseY] == 1) {
									clearWalls = true;
									numOfWalls--;
									board[mouseX][mouseY] = floorTile;
									maze[mouseX][mouseY] = 0;
								}
							}
						}// end if(active_button)
					}// end if
				}// end if(mazeClear)
			}// end mousePressed
		});
	} // end init()
	
// W I T H I N   B O A R D///////////////////////////////////////////	
	public boolean WithinBoard() {
		// checks if acitve_button is valid
		// and if mouse is on board
		if(mouseX > 0 && mouseX < _boardSize - 1 &&
		   mouseY > 0 && mouseY < _boardSize - 1 &&
		   ( !( (mouseX == startX && mouseY == startY) || 
			    (mouseX == finishY && mouseY == finishY) )) )
			return true;
		if(active_button == _wallButton && (mouseX < 0 || 
		   mouseX > (_boardSize - 1) || mouseY < 0 || mouseY > (_boardSize - 1)) ) {
			toolkit.beep();
			message1 = "Walls must be placed inside board";
		}
		return false;
	}

// C L E A R   M A Z E///////////////////////////////////////////////	
	public void ClearMaze() {
		// re-initailize maze
		for(int i = 0; i < _boardSize; i++) {
			for(int j = 0; j < _boardSize; j++) {
				if(i == 0 || i == _boardSize-1) 
					{ board[j][i] = wallTile; maze[j][i] = 1; }
				else if(j == 0 || j == _boardSize-1) 
					{ board[j][i] = wallTile; maze[j][i] = 1; }
				else { board[j][i] = floorTile; maze[j][i] = 0; }
			}
		}
		board[startX][startY] = startTile;
		board[finishX][finishY] = finishTile;
		numOfWalls = pathLength = 0;
		if(continueButton.isShowing()) {
			this.remove(continueButton);
			this.add(pauseButton);
		}
		mazeClear = true;
		pause = pathFound = pathDone = findingPath = false;
		active_button = _noButton;
		here = new Point(1, 1);
		message1 = "";
		currLabel = 2;
		path.push(here);
		maze[1][1] = 1;
		animationCnt = 0;
	}// end ClearMaze()
	
// C L E A R   P A T H///////////////////////////////////////////////
	public void ClearPath() {
		numOfWalls = pathLength = 0;
		for(int i = 1; i < (_boardSize - 1); i++) {
			for(int j = 1; j < (_boardSize - 1); j++) {
				if(board[j][i] != wallTile) {
					maze[j][i] = 0;
					board[j][i] = floorTile;
				}// end if
				else numOfWalls++;
			}// end for
		}// end for
		board[startX][startY] = startTile;
		board[finishX][finishY] = finishTile;
		if(continueButton.isShowing()) {
			this.remove(continueButton);
			this.add(pauseButton);
		}
		mazeClear = true;
		pause = pathFound = pathDone = findingPath = false;
		active_button = _noButton;
		here = new Point(1, 1);
		message1 = "";
		currLabel = 2;
		path.push(here);
		maze[1][1] = 1;
	}// end ClearPath()
	
// F I N D    P A T H////////////////////////////////////////////////	
	public boolean FindPath() {
		animationCnt++;
		option = 0; // next move
		Point tempPoint = new Point(0, 0);
 	  
		// search for a path
		if (here.x != finishX || here.y != finishY)
		{// not at exit
			// find a neighbor to move to
			// won't compile without explicit initialization
			r = c = 0;   // row and column of neighbor
			while (option <= LastOption)
			{
				r = here.x + offset[option].x;
				c = here.y + offset[option].y;
				if (maze[r][c] == 0) {
					mouseDir[animationCnt] = option;
					break;
				}
				option++; // next option
			}
			
			// was a neighbor found?
			if (option <= LastOption)  // yes
			{// move to maze[r][c]
				here = new Point(r, c);
				// set to 1 to prevent revisit
				maze[r][c] = -1;
				option = 0;
				if ( !((r == startX && c == startY) ||
					 (r == finishX && c == finishY)) ) {
					board[r][c] = visitedTile;
					maze[r][c] = pathLength = currLabel;
					mouseGifPos.x = r + 1;
					mouseGifPos.y = c + 1;
					currLabel++;
					path.push(here);
				}
			}
			else
			{// no neighbor to move to, back up
				if (path.empty()) {// no place to backup to
					pathDone = true;
					message1 = "No path found...";
					toolkit.beep();
					return false;
				}
				next = (Point) path.peek();
				if ( !((next.x == startX && next.y == startY) ||
						(next.x == finishX && next.y == finishY)) ) {
					// we have come to a dead end are attemptimg to back out
					if(!openNeighbor(next)) {
						// we will make this square unuseable and continue to back up
						currLabel--;
						pathLength = currLabel;
						board[next.x][next.y] = unUsableTile;
						mouseGifPos.x = next.x + 1;
						mouseGifPos.y = next.y + 1;
						// mouseDir should be towards the tile we just stepped onto
						if(here.x == next.x - 1) { mouseDir[animationCnt] = 0; }		// right
						else if(here.y == next.y - 1) { mouseDir[animationCnt] = 1; }	// down
						else if(here.x == next.x + 1) { mouseDir[animationCnt] = 2; }	// left
						else if(here.y == next.y + 1) { mouseDir[animationCnt] = 3; }	// up
						maze[next.x][next.y] = -1;
						next = (Point) path.pop();
					}
					else {
						// we have found another a sqaure with an open neighbor
						if (next.x == here.x)
							option = 2 + next.y - here.y;
						else option = 3 + next.x - here.x;		
						if(option == 4) mouseDir[animationCnt] = 0;			// right
						else if(option == 3) mouseDir[animationCnt] = 1;	// down
						else if(option == 2) mouseDir[animationCnt] = 2;	// left
						else if(option == 1) mouseDir[animationCnt] = 3;	// up 
						mouseGifPos.y = next.y + 1;
						mouseGifPos.x = next.x + 1;
					}// end else
				}// end if
				here = next;
			}// end else
			tempPoint = (Point) path.peek();
			if( !(openNeighbor(tempPoint)) && 
				(tempPoint.x == startX && tempPoint.y == startY) ) {
				pathDone = true;
				if(pathLength != 0) pathLength = 0;
				message1 = "No path found...";
				toolkit.beep();
				return false;
			}
		}// end if(at finish)   
		else {
 			pathDone = true;
			pathFound = true;
			toolkit.beep();
			message1 = "Path found...";
		}// end else
		return true;  // at exit
	}
   
// H A S   N O   O P E N   N E I G H B O R S/////////////////////////
	public boolean openNeighbor(Point here) {
		int x = 0, y = 0, i = 0;
		for(i = 0; i < 4; i++) {
			x = here.x + offset[i].x;
            y = here.y + offset[i].y;
			if (maze[x][y] == 0) break;
        }
		
		if(i < 4) return true;
		return false;
	}
	
// P A I N T/////////////////////////////////////////////////////////	
	public void paint(Graphics g) {
		bufferGraphics.setColor(Color.black);
		bufferGraphics.fillRect(0, 0, bufferSize.width, bufferSize.height);
		bufferGraphics.setColor(Color.blue);
		
		int temp; // used to correctly space numbers on board
		// paint board in here
		for(int i = 0; i < _boardSize; i++) {
			for(int j = 0; j < _boardSize; j++) {
				bufferGraphics.drawImage(board[j][i], (_boardX + j*_sqrSize),
										(_boardY + i*_sqrSize), this);
				temp = maze[j][i];
				if(temp > 1) {
					if(temp < 11)
					bufferGraphics.drawString(""+(maze[j][i] - 1), (_boardX + 7 + j*_sqrSize),
											 (_boardY + 15 + i*_sqrSize));
					else if(temp < 101)
					bufferGraphics.drawString(""+(maze[j][i] - 1), (_boardX + 4 + j*_sqrSize),
											 (_boardY + 15 + i*_sqrSize));
					else
					bufferGraphics.drawString(""+(maze[j][i] - 1), (_boardX + j*_sqrSize),
											 (_boardY + 15 + i*_sqrSize));
				}
			}
		}
		if(pathDone)
			bufferGraphics.drawImage(mouseGif[mouseDir[animationCnt - 1]], mouseGifPos.x * _sqrSize, 
									 mouseGifPos.y * _sqrSize, this);
		else if(findingPath)
			bufferGraphics.drawImage(mouseGif[mouseDir[animationCnt]], mouseGifPos.x * _sqrSize, 
									 mouseGifPos.y * _sqrSize, this);
		
		bufferGraphics.setColor(Color.white);
		
		bufferGraphics.drawImage(createMaze, 415, 10, this);
		bufferGraphics.drawImage(boboGames, 500, 455, this);

		if(pathLength == 0)
			bufferGraphics.drawString("pathLength = 0", _messageX, 75);
		else bufferGraphics.drawString("pathLength = " +(pathLength - 1), _messageX, 75);
		bufferGraphics.drawString("Number of walls = " +numOfWalls, _messageX, 90);
		bufferGraphics.drawString("Speed = " +frameRate+ " frames/sec", _messageX, 105);
		bufferGraphics.drawString("s  p  e  e  d", _buttonX + _buttonWidth*3 + 30, _buttonY + 5);

		bufferGraphics.drawImage(startTile, _messageX, _legendY, this);
		bufferGraphics.drawString("start tile", _messageX + 30, _legendTextY);
		bufferGraphics.drawImage(finishTile, _messageX, _legendY + _legendSize, this);
		bufferGraphics.drawString("finish tile", _messageX + 30, _legendTextY + _legendSize);
		bufferGraphics.drawImage(wallTile, _messageX, _legendY + _legendSize*2, this);
		bufferGraphics.drawString("wall tile", _messageX + 30, _legendTextY + _legendSize*2);
		bufferGraphics.drawImage(visitedTile, _messageX, _legendY + _legendSize*3, this);
		bufferGraphics.drawString("path tile", _messageX + 30, _legendTextY + _legendSize*3);
		bufferGraphics.drawImage(unUsableTile, _messageX, _legendY + _legendSize*4, this);
		bufferGraphics.drawString("blocked tile", _messageX + 30, _legendTextY + _legendSize*4);

		bufferGraphics.drawString("         Instructions", _messageX, _instructionsY);
		bufferGraphics.drawString("         ---------------", _messageX, _instructionsY + 5);
		bufferGraphics.drawString("1) \"place walls\" as you wish", _messageX, _instructionsY + 20);
		bufferGraphics.drawString("2) \"find path\" ", _messageX, _instructionsY + 35);
		bufferGraphics.drawString("3) \"clear maze\" or \"clear path\" and repeat", _messageX, _instructionsY + 50);
		bufferGraphics.drawString("NOTE: instead of making a maze ", _messageX, _instructionsY + 65);
		bufferGraphics.drawString("              you can use a \"premade maze\"", _messageX, _instructionsY + 80);

		
		bufferGraphics.setColor(Color.yellow);
		bufferGraphics.drawString(message1, _messageX, 120);
		if(pathDone)
			bufferGraphics.drawString("!!! Clear maze or path to continue !!!",
									  _messageX, 140);
		g.drawImage(buffer, 0, 0, this);
	}
	
// U P D A T E///////////////////////////////////////////////////////	
	public void update(Graphics g) { paint(g); }

// R U N ////////////////////////////////////////////////////////////	
	public void run() {
		Thread thisThread = Thread.currentThread();
		long start = 0, sleep = 0;
		while(true) {
			start = System.currentTimeMillis();
			if(!pause) {
				if(!pathDone) {
					if(findingPath) FindPath();
				}
			}// end if(!pause)
			
			// doesn't flicker but animation is not as good
			repaint();

			// sync repaints() to 30fps
			sleep = frameRate - (int)(System.currentTimeMillis() - start);
			if(sleep <= 0) sleep = 1;	// never divide by zero
			sleep = 1000 / sleep;
			try { thisThread.sleep(sleep); }
			catch (InterruptedException e) {}
		}
	}
	public void start() {
		if(animate == null)
			animate = new Thread(this);		
		animate.start();
	}
	public void stop() {
			animate = null;
	}
	
// W A I T   F O R   I M A G E///////////////////////////////////////	
    public static void waitForImage(Component component, Image image) {
        MediaTracker tracker = new MediaTracker(component);
        try {
			// wait for image before starting applet
            tracker.addImage(image, 0);
            tracker.waitForID(0);
        }
        catch(InterruptedException e) { e.printStackTrace(); }
    }

// P R E S E T   G R I D/////////////////////////////////////////////
	public void PresetGrid(char preset_grid[][]) {
		ClearMaze();
		for(int i = 1; i < _boardSize - 1; i++) {
			for(int j = 1; j < _boardSize - 1; j++) {
				switch (preset_grid[j-1][i-1]) {
					case 'S': {
								  startX = i;
								  startY = j;
								  board[i][j] = startTile;
								  maze[i][j] = 0;
								  break;
							  }
					case 'F': {
								  finishX = i;
								  finishY = j;
								  board[i][j] = finishTile;
								  maze[i][j] = 0;
								  break;
							  }
					case 'O': {
								  board[i][j] = floorTile;
								  maze[i][j] = 0;
								  break;
							  }
					case '#': {
								  board[i][j] = wallTile;
								  maze[i][j] = 1;
								  numOfWalls++;
								  break;
							  }
					default : break;
				}// end switch
			}// end for j
		}// end for i
	}// end PresetGrid
}// end maze class