/**author Chris Bobo -=BOBO GAMES=-
 * copyright 1999 all rights reserved -=BOBO GAMES=-
 * this is an applet which allows users to ineract 
 * with and see the workings of an InsertionSort
 * version 1.0
 */
import java.applet.*;
import java.awt.event.*;
import java.io.*;
import java.awt.*;
import java.awt.Toolkit;
import java.util.*;
import gjt.ThreeDRectangle;

class InsertionSortArray {
	int data,
		state,
		x,
		y;
	
	// constructors
	InsertionSortArray(){}
	
	InsertionSortArray(InsertionSortArray a) {
		this.data = a.data;
		this.state = a.state;
		this.x = a.x;
		this.y = a.y;
	}
	
	InsertionSortArray(int data, int state, int x, int y) {
		this.data = data;
		this.state = state;
		this.x = x;
		this.y = y;
	}
	
	public void reset() {
		this.data = 0;
		this.state = 0;
	}

	// draws the array[i] into the graphics object g
	// does not draw index
	public void draw(Graphics g, Applet a, Image blackContainer, Image yellowContainer, Image redContainer) {
		if(this.state == 0)
			g.drawImage(blackContainer, x, y, a);
		else if(this.state == 1)
			g.drawImage(yellowContainer, x, y, a);
		else if(this.state == 2)
			g.drawImage(redContainer, x, y, a);

		if(this.data < 10) 
			g.drawString("" +this.data, x + 10, y + 25);
		else g.drawString("" +this.data, x + 7, y + 25);
	}
	
	// draws the array[i] into the graphics object g
	// draws index
	public void draw(Graphics g, Applet a, int index, Image blackContainer, 
					 Image yellowContainer, Image redContainer) {
		Color oldColor = g.getColor();
		if(this.state == 0)
			g.drawImage(blackContainer, x, y, a);
		else if(this.state == 1)
			g.drawImage(yellowContainer, x, y, a);
		else if(this.state == 2)
			g.drawImage(redContainer, x, y, a);

		// draw data for each element and the index
		if(this.data < 10) 
			g.drawString("" +this.data, x + 10, y + 25);
		else g.drawString("" +this.data, x + 7, y + 25);
		g.setColor(Color.black);
		g.drawString("" +index, x + 10, y + 45);
		g.setColor(oldColor);
	}
}// end class InsertionSortArray
		
	

public class InsertionSort extends Applet implements Runnable 
{
	// critical values for GUI and animation
	final int _minValue			= 0,
			  _maxValue			= 99,
			  _buttonX			= 20,
			  _buttonY			= 70,
			  _wideButton		= 100,
			  _buttonHeight		= 23,
			  _buttonHSpacer	= _buttonHeight + 10,
			  _buttonWSpacer	= _wideButton + 10,
			  _displayX			= 260,
			  _displayY			= _buttonY,
			  _displayWidth		= 390,
			  _displayHeight	= 150,
			  _messageWidth		= _displayWidth,
			  _messageHeight	= 80,
			  _messageX			= _displayX,
			  _messageY			= _displayY + _displayHeight + 10,
			  _speedBarX		= _buttonX,
			  _speedBarY		= _messageY + _messageHeight - 15,
			  _speedBarWidth	= _wideButton * 2,
			  _arrayX			= _displayX + 20,
			  _arrayY			= _displayY + 20,
			  _boxSize			= 35,
			  _arraySize		= 10,
			  _animMessageX		= 360,
			  _animMessageY		= _displayY + 120,
			  _programNameX		= 120,
			  _programNameY		= 10,
			  _black			= 0,
			  _yellow			= 1,
			  _red				= 2;
			  
	
	// doublebuffer
	Image buffer;
	Graphics bufferGraphics;
	Dimension bufferSize;
	
	// images
	Image boboGames, programName, container, redContainer, yellowContainer;
	
	// interface peices
	TextField manualValueField, manualIndexField;
	TextArea messageCenter;
	Button manualButton, randomButton, sortButton, resetButton, removeButton, 
		   pauseButton, continueButton;
	Scrollbar speedBar;
	ThreeDRectangle displayRect;
	
	// animation thread
	Thread animation;
	
	// let's us use system dependant properties
	Toolkit toolkit;
	
	// applet size on screen
	Dimension appletSize;
	
	// set font so applet has the same look on different systems
	Font f = new Font("TimesRoman", Font.PLAIN, 12);
	
	int frameRate = 1;	// animation spped
	boolean buttonActive = false;
	
	// has user paused the applet?
	boolean pause = false;
	
	boolean doneSorting = false;
	boolean sorting = false;	
	
	int arraySize = 0;
	int shiftCursor = 0;
	int sortCnt = 0;
	int sortCursor = 0;
	int sortState = 2;
	String sortMsg = new String();
		
	InsertionSortArray [] array;
	InsertionSortArray temp = new InsertionSortArray(0, _black, 280, 160);
			
	public void init() {
		setLayout(null);
		
		// set up doublebuffer
		// make buffer size fo updatable screen portion
		bufferSize = this.getSize();
		buffer = this.createImage(bufferSize.width, bufferSize.height);
		bufferGraphics = buffer.getGraphics();
		
		// load images for applet
		boboGames	= this.getImage(this.getCodeBase(), "bgGif.gif");
		waitForImage(this, boboGames);
		programName	= this.getImage(this.getCodeBase(), "program_name.gif");
		waitForImage(this, programName);
		container	= this.getImage(this.getCodeBase(), "container.gif");
		waitForImage(this, container);
		yellowContainer	= this.getImage(this.getCodeBase(), "y_container.gif");
		waitForImage(this, yellowContainer);
		redContainer	= this.getImage(this.getCodeBase(), "r_container.gif");
		waitForImage(this, redContainer);

		// get applet size on window
		appletSize = this.getSize();
		
		// get a system Toolkit
		toolkit = this.getToolkit();
		
		// set fonts
		this.setFont(f);
		bufferGraphics.setFont(f);

		array = new InsertionSortArray[_arraySize];
		InsertionSortArray a = new InsertionSortArray(0, 0, 0, 0);
		for(int i = 0; i < _arraySize; i++) {
			a.x = _displayX + 20 + (i * _boxSize);
			a.y = _displayY + 30;
			array[i] = new InsertionSortArray(a);
		}
		
		manualButton = new Button("manual placement");
		manualButton.setBounds(_buttonX, _buttonY, _wideButton, _buttonHeight);
		add(manualButton);
		manualButton.addMouseListener(new MouseAdapter() {
			public void mousePressed(MouseEvent e) {
				ManuallyFillContainers();
			}
		});

		manualValueField = new TextField();
		manualValueField.setBounds(_buttonX + _wideButton + 10, _buttonY, _wideButton/2, _buttonHeight);
		add(manualValueField);

		manualIndexField = new TextField();
		manualIndexField.setBounds( (int)(_buttonX + _wideButton * 1.5 + 20), _buttonY, _wideButton/2, _buttonHeight);
		add(manualIndexField);

		
		randomButton = new Button("random placement");
		randomButton.setBounds(_buttonX, _buttonY + _buttonHSpacer, _wideButton, _buttonHeight);
		add(randomButton);
		randomButton.addMouseListener(new MouseAdapter() {
			public void mousePressed(MouseEvent e) {
				if(!buttonActive) {
					buttonActive = true;
					Reset();
					RandomlyFillContainers();
				}
			}
		});
		
		sortButton = new Button("sort");
		sortButton.setBounds(_buttonX, _buttonY + _buttonHSpacer * 2, _wideButton, _buttonHeight);
		add(sortButton);
		sortButton.addMouseListener(new MouseAdapter() {
			public void mousePressed(MouseEvent e) {
				if(!buttonActive) {
					buttonActive = true;
					sorting = true;
					sortCursor = 0;
					sortCnt = 1;
				}					
				else {
					toolkit.beep();
					if(doneSorting)
						messageCenter.append("Done sorting train cars, hit reset to try again.\n");
					else
						messageCenter.append("You must press continue before you can move the next car.\n");
				}// end else
			}
		});

		// reset button
		resetButton = new Button("reset");
		resetButton.setBounds(_buttonX, _buttonY + _buttonHSpacer * 3, _wideButton, _buttonHeight);
		add(resetButton);
		resetButton.addMouseListener(new MouseAdapter() {
			public void mousePressed(MouseEvent e) { 
				Reset(); 
			}
		});
		
		// pause button
		pauseButton = new Button("pause");
		pauseButton.setBounds(_buttonX, _buttonY + _buttonHSpacer * 4,
							  _wideButton, _buttonHeight);
		add(pauseButton);
		pauseButton.addMouseListener(new MouseAdapter() {
			public void mousePressed(MouseEvent e) { 
				if(!buttonActive) {
					buttonActive = true;
					remove(pauseButton);
					add(continueButton);
					pause = true;
				}
				else messageCenter.append("Cannot pause now.\n");
			}
		});

		// continue button
		continueButton = new Button("continue");
		continueButton.setBounds(_buttonX, _buttonY + _buttonHSpacer * 4,
								 _wideButton, _buttonHeight);
		continueButton.addMouseListener(new MouseAdapter() {
			public void mousePressed(MouseEvent e) { 
				remove(continueButton);
				add(pauseButton);
				pause = false;
			}
		});

		// speedbar
		speedBar = new Scrollbar(Scrollbar.HORIZONTAL, 100, 0, 1, 60);
		speedBar.setBounds(_buttonX, _speedBarY, _speedBarWidth, 13);
		add(speedBar);
		speedBar.setValue(frameRate);
		speedBar.addAdjustmentListener(new AdjustmentListener() {
			public void adjustmentValueChanged(AdjustmentEvent e) {
				frameRate = e.getValue();
			}
		});
		
		// message center
		messageCenter = new TextArea();
		messageCenter.setBounds(_messageX, _messageY, _messageWidth, _messageHeight);
		messageCenter.setEditable(true);
		messageCenter.append("All messages will appear here...\n");
		add(messageCenter);
		
		Reset();

	}// end init	
	
// P A I N T/////////////////////////////////////////////////////////	
	public void paint(Graphics g) {
		// fill the screen with black
		FillScreen(this.getSize(), bufferGraphics, Color.black);
		
		// create display area
		FillArea(_displayX + 2, _displayY + 2, _displayWidth - 3, _displayHeight - 3, 
				 bufferGraphics, Color.white);
		bufferGraphics.setColor(Color.gray);
		bufferGraphics.draw3DRect(_displayX, _displayY, _displayWidth, _displayHeight, false);
		
		// display program name and bobo games logo
		bufferGraphics.drawImage(boboGames, appletSize.width - 110, appletSize.height - 25, this);
		bufferGraphics.drawImage(programName, _programNameX, _programNameY, this);
		
		bufferGraphics.setColor(Color.white);
		//display animation speed
		bufferGraphics.drawString("Speed = " +(float)frameRate/2+ " frames/sec", _speedBarX + 50,
								  _messageY + _messageHeight - _buttonHeight);
		
		// draw text under manual placement fields
		bufferGraphics.drawString("value",  _buttonX + _wideButton + 17, _buttonY + 34);
		bufferGraphics.drawString("index",  (int)(_buttonX + _wideButton * 1.5 + 32),_buttonY + 34);
		
		// draw array and insert this data (box)
		for(int i = 0; i < _arraySize; i++)
			array[i].draw(bufferGraphics, this, i, container, yellowContainer, redContainer);
		temp.draw(bufferGraphics, this, container, yellowContainer, redContainer);
		bufferGraphics.setColor(Color.black);
		bufferGraphics.drawString("Insert This", temp.x - 8, temp.y + 45);
		bufferGraphics.drawString(sortMsg, _animMessageX, _animMessageY);
		
		// draw the buffer to the screen
		g.drawImage(buffer, 0, 0, this);
}	
	
// U P D A T E///////////////////////////////////////////////////////	
	public void update(Graphics g) { paint(g); }

// R U N/////////////////////////////////////////////////////////////	
	public void run() {
		Thread thisThread = Thread.currentThread();
		long start = 0, sleep = 0;
		while(true) {
			start = System.currentTimeMillis();
			buttonActive = false;
			if(!pause) {
				// if sorting then call sort for another animation step
				if(sorting)
					Sort();
			}
			repaint();	// repaint the screen
			// sync repaints() from 1 - 30 fps
			sleep = frameRate - (int)(System.currentTimeMillis() - start);
			if(sleep <= 0) sleep = 1;	// never divide by zero
			sleep = 2000 / sleep;
			try { thisThread.sleep(sleep); }
			catch (InterruptedException e) {}
		}
	}
	
// S T A R T/////////////////////////////////////////////////////////	
	public void start() {
		if(animation == null)
			animation = new Thread(this);		
			animation.start();
	}
	
// S T O P///////////////////////////////////////////////////////////	
	public void stop() {
		animation = null;
	}

// W A I T   F O R   I M A G E///////////////////////////////////////	
    public static void waitForImage(Component component, Image image) {
        MediaTracker tracker = new MediaTracker(component);
        try {
			// wait for the image to be loaded before starting the applet
            tracker.addImage(image, 0);
            tracker.waitForID(0);
        }
        catch(InterruptedException e) { e.printStackTrace(); }
    }
	
// F I L L   S R E E N///////////////////////////////////////////////
	/**fill the screen(g refers to) with the specified color*/
	public void FillScreen(Dimension size, Graphics g, Color color) {
		Color old_color = g.getColor();
		g.setColor(color);
		g.fillRect(0, 0, size.width, size.height);
		g.setColor(old_color);
	}
	
// F I L L   A R E A/////////////////////////////////////////////////
	/**fill an area(g refers to) with the specified color*/
	public void FillArea(int x, int y, int _x, int _y, Graphics g, Color color) {
		Color old_color = g.getColor();
		g.setColor(color);
		g.fillRect(x, y, _x, _y);
		g.setColor(old_color);
	}
		
// ValidateText//////////////////////////////////////////////////////
	public int ValidateText(TextField field, int lowValue, int highValue, int listSize, 
							boolean invalidIfEmpty, String str) {
		// if text is valid assign it the correct value
		// else assign it the value of -1
		int fieldValue = -1;
		try {
			fieldValue = Integer.parseInt(field.getText());
		}
		catch (NumberFormatException e) {
			field.selectAll();
			fieldValue = -1;		// not valid
			toolkit.beep();
		}
		if(invalidIfEmpty) {
			if(listSize == 0) {
				fieldValue = -1;
				toolkit.beep();
				messageCenter.append("The " +str+ " " +field.getText()+ " is not valid because the list is currently empty\n");
			}
			else if(fieldValue < lowValue || fieldValue > highValue) {
				fieldValue = -1;		// not valid
				toolkit.beep();
				messageCenter.append("The " +str+ " " +field.getText()+ " is not valid\n");
				messageCenter.append("The " +str+ " must be an integer between " +lowValue + " and " +highValue+ "\n");			
			}
		}
		else if(fieldValue < lowValue || fieldValue > highValue) {
			fieldValue = -1;		// not valid
			toolkit.beep();
			messageCenter.append("The " +str+ " " +field.getText()+ " is not valid\n");
			messageCenter.append("The " +str+ " must be an integer between " +lowValue + " and " +highValue+ "\n");
		}
		return fieldValue;
	}

// RandomlyFillContainers()//////////////////////////////////////////////
	public void RandomlyFillContainers() {
		Random random = new Random(System.currentTimeMillis());
		int randNum = 0;
		// randomly places cars onto input track
		for(int i = 0; i < _arraySize; i++) {
			randNum = (random.nextInt() % 100);
			if(randNum < 0) randNum *= -1;
			array[i].data = randNum;
		}// end for
		arraySize = 10;
	}	
	
// ManuallyFillContainers()///////////////////////////////////////////////
	public void ManuallyFillContainers() {
		int value = ValidateText(manualValueField, _minValue, _maxValue, 0, false, "value");
		int index = ValidateText(manualIndexField, _minValue, max(arraySize, 9), 0, false, "index");
		if(value >= 0 && index >= 0) {// value is valid
			if(index == arraySize) arraySize++;
			array[index].data = value;
		}
	}
	
	
// Done()////////////////////////////////////////////////////////////
	public void Done() {
		messageCenter.append("The array has been succesfully sorted.\n");
	}

// min///////////////////////////////////////////////////////////////////////	
	public int min(int x, int min) {
		if(x < min) return min;
		else return x;
	}		   

// max///////////////////////////////////////////////////////////////////////	
	public int max(int x, int max) {
		if(x > max) return max;
		else return x;
	}		   
	
// Reset()///////////////////////////////////////////////////////////
	public void Reset() {
		sortCnt = 1;
		sortCursor = 0;
		shiftCursor = 0;
		sortState = 2;
		
		sorting = false;
		
		//reset array
		for(int i = 0; i < _arraySize; i++) 
			array[i].reset();
		
		// reset the copy
		temp.reset();
	}
	
// Sort()////////////////////////////////////////////////////////////
	public void Sort() {
		// states of insertion sort *state machine*
		// thee are 17 states to the machine

		switch (sortState) {
		case 2:	{	if(sortCursor >= sortCnt) {
						sortState = 16;
						sortMsg = "The data in array[" +sortCnt+ "] does not need to be moved.";
					}
					else {
						array[sortCnt].state = _red;
						temp.state = _red;
						sortMsg = "Copying data in array[ " +sortCnt+ "] into copy.";
						sortState = 3;
					}
					break; 
				}
		case 3:	{	temp.data = array[sortCnt].data;
					sortState = 4;
					break; 
				}
		case 4:	{	array[sortCnt].state = _black;
					temp.state = _black;
					sortState = 5;
					break; 
				}
		case 5:	{	if(sortCursor > sortCnt - 1) {
						array[sortCursor].state = _black;
						sortState = 16;
						sortMsg = "The data in array[" +sortCnt+ "] does not need to be moved.";
					}
					else {
						array[sortCursor].state = _yellow;
						temp.state = _yellow;
						sortMsg = "Comparing array[ "+sortCursor+ "] with copy";
						sortState = 6;
					}
					break; 
				}
		case 6:	{	if(temp.data < array[sortCursor].data) {// begin shifting
						array[sortCursor].state = _black;
						sortState = 7;
					}
					else {
						array[sortCursor].state = _black;
						array[sortCursor + 1].state = _yellow;
						sortCursor++;
						sortMsg = "Comparing array[ "+sortCursor+ "] with copy";
						sortState = 5;
					}
					break; 
				}
		case 7:	{	array[sortCursor].state = _black;
					temp.state = _black;
					sortState = 8;
					sortMsg = "Begin shifting elements, to make room for insertion.";
					shiftCursor = sortCnt -1;
					break; 
				}
		case 8:	{	// begin shifting sequence
					array[shiftCursor].state = _yellow;
					array[shiftCursor + 1].state = _yellow;
					sortMsg = "Shifting...";
					sortState = 9;
					break; 
				}
		case 9:	{	// shift array[shiftCursor] 1 space to the right
					array[shiftCursor + 1].data = array[shiftCursor].data;
					if(shiftCursor - 1 < sortCursor)
						shiftCursor--;
					sortState = 11;
					break; 
				}
				// sortState 10 removed
		case 11:{	if(shiftCursor < sortCursor) {
						array[shiftCursor + 1].state = _black;
						array[shiftCursor + 2].state = _black;
						sortState = 12;	//prepare to insert the data
						sortMsg = "Done shifting...";
					}
					else {
						array[shiftCursor + 1].state = _black;
						array[shiftCursor - 1].state = _yellow;
						shiftCursor--;
						sortState = 8;
					}
					break; 
				}
		case 12:{	array[sortCursor].state = _red;
					temp.state = _red;
					sortMsg = "Inserting the copy...";
					sortState = 14;
					break; 
				}
				// sortState 13 removed
		case 14:{	array[sortCursor].data = temp.data;
					sortMsg = "The element has been inserted.";
					array[sortCursor].state = _black;
					temp.state = _black;
					sortState = 16;
					break;
				}
				// sortState 15 removed					
		case 16:{	if(++sortCnt >= arraySize) {
						doneSorting = true;
						Done();
						sorting = false;
						sortState = 17;
					}
					else {
						sortCursor = 0;
						sortState = 2;
					}
					break;						
				}
		case 17:{	// done sorting
					toolkit.beep();
					sorting = false;
					break;
				}
		default:{	break; }
		}// end switch
	}
}// end InsertionSort class
