/**@author Chris Bobo -=BOBO GAMES=-
 * copyright 1999 all rights reserved -=BOBO GAMES=-
 * this applet demonstrates the workings of a linked stack
 * @version 1.0
 */

import java.applet.*;
import java.awt.event.*;
import java.io.*;
import java.awt.*;
import java.awt.Toolkit;
import java.util.*;


public class LinkedStack extends Applet implements Runnable 
{
	// critical vlaues for GUI and animation
	final int		_buttonHeight	= 23,
					_buttonX		= 20,
					_buttonY		= 80,
					_wideButton		= 100,
					_narrowButton	= 70,
					_buttonSpacer	= _buttonHeight + 10,
					_displayX		= 180,
					_displayY		= 20,
					_displayWidth	= 260,
					_displayHeight	= 300,
					_messageWidth	= _displayWidth,
					_messageHeight	= 100,
					_messageY		= _displayY + _displayHeight + 15,
					_stackX			= 270,
					_stackY			= 285,
					_layerHeight	= 25,
					_layerWidth		= 60,
					_highValue		= 999;
									 
	
	
	// doublebuffer
	Image buffer;
	Graphics bufferGraphics;
	Dimension bufferSize;
	
	// animation thread
	Thread animation;
	
	// let's us use system dependant properties
	Toolkit toolkit;
	
	// applet size on screen
	Dimension appletSize;
	
	// set font so applet has the same look on different systems
	Font f = new Font("TimesRoman", Font.PLAIN, 12);
	
	// GUI components
	Button isEmptyButton, isFullButton, topButton, addButton, deleteButton;
	
	TextArea messageCenter;
	
	TextField addField;
	
	Image bgGif, layerGif, nullGif, stackGif, topGif, bottomLayerGif;
	
	int frameRate = 33;
	boolean pause = false;
	
	final int MaxStackSize = 10;
	int addFieldTF = 0;

	boboStack stack = new boboStack();
	int [] stackValues = new int[MaxStackSize];
				
	public void init() {
		setLayout(null);
		
		// set up doublebuffer
		// make buffer size fo updatable screen portion
		bufferSize = this.getSize();
		buffer = this.createImage(bufferSize.width, bufferSize.height);
		bufferGraphics = buffer.getGraphics();
		
		// load images for applet
		bgGif	= this.getImage(this.getCodeBase(), "bgGif.gif");
		waitForImage(this, bgGif);
		stackGif	= this.getImage(this.getCodeBase(), "stackGif.gif");
		waitForImage(this, stackGif);
		layerGif	= this.getImage(this.getCodeBase(), "layer.gif");
		waitForImage(this, layerGif);
		nullGif	= this.getImage(this.getCodeBase(), "null.gif");
		waitForImage(this, nullGif);
		topGif	= this.getImage(this.getCodeBase(), "topGif.gif");
		waitForImage(this, topGif);
		bottomLayerGif	= this.getImage(this.getCodeBase(), "bottom_layer.gif");
		waitForImage(this, bottomLayerGif);

		// get applet size on window
		appletSize = this.getSize();
		
		// get a system Toolkit
		toolkit = this.getToolkit();
		
		// set fonts
		this.setFont(f);
		bufferGraphics.setFont(f);
	
		// initailize stack values
		for(int i = 0; i < MaxStackSize; i++) stackValues[i] = 0;
				
		// isEmptyButton
		isEmptyButton = new Button("empty");
		isEmptyButton.setBounds(_buttonX, _buttonY, _narrowButton, _buttonHeight);
		add(isEmptyButton);
		isEmptyButton.addMouseListener(new MouseAdapter() {
			public void mousePressed(MouseEvent e) { IsEmpty(); }
		});

		// topButton
		topButton = new Button("peek");
		topButton.setBounds(_buttonX, _buttonY + _buttonSpacer,
							_narrowButton, _buttonHeight);
		add(topButton);
		topButton.addMouseListener(new MouseAdapter() {
			public void mousePressed(MouseEvent e) { Top(); }
		});
		
		// addButton
		addButton = new Button("push");
		addButton.setBounds(_buttonX, _buttonY + _buttonSpacer * 2,
							_narrowButton, _buttonHeight);
		add(addButton);
		addButton.addMouseListener(new MouseAdapter() {
			public void mousePressed(MouseEvent e) { 
				addFieldTF = ValidateText(addField, 0, _highValue, MaxStackSize, false, "element");
				if(addFieldTF != -1) Add(); 
			}
		});
		
		addField = new TextField("0");
		addField.setBounds(_buttonX + _narrowButton + 10, _buttonY + _buttonSpacer * 2,
							_narrowButton, _buttonHeight);
		add(addField);

		// deleteButton
		deleteButton = new Button("pop");
		deleteButton.setBounds(_buttonX, _buttonY + _buttonSpacer * 3,
							   _narrowButton, _buttonHeight);
		add(deleteButton);
		deleteButton.addMouseListener(new MouseAdapter() {
			public void mousePressed(MouseEvent e) { Delete(); }
		});
		
		
		// message center
		messageCenter = new TextArea();
		messageCenter.setBounds(_displayX, _messageY, _messageWidth, _messageHeight);
		messageCenter.setEditable(true);
		messageCenter.append("All messages will appear here...\n");
		add(messageCenter);
	}// end init	
	
// P A I N T/////////////////////////////////////////////////////////	
	public void paint(Graphics g) {
		// fill screen with black
		FillScreen(this.getSize(), bufferGraphics, Color.black);

		// create display area
		FillArea(_displayX + 2, _displayY + 2, _displayWidth - 3, _displayHeight - 3, 
				 bufferGraphics, Color.white);
		bufferGraphics.setColor(Color.gray);
		bufferGraphics.draw3DRect(_displayX, _displayY, _displayWidth, _displayHeight, false);
		
		// draw titles
		bufferGraphics.drawImage(bgGif, appletSize.width - 110, appletSize.height - 25, this);
		bufferGraphics.drawImage(stackGif, 10, 10, this);
		
		bufferGraphics.setColor(Color.white);
		// draw the stack
		if(stack.size() >= 1) {
			bufferGraphics.drawImage(bottomLayerGif, _stackX, _stackY, this);
			bufferGraphics.drawString(""+stackValues[0], _stackX + 27, _stackY + 15); 
		}
		for(int i  = 1; i < stack.size(); i++) {
			bufferGraphics.drawImage(layerGif, _stackX, _stackY - (_layerHeight * i), this);
			bufferGraphics.drawString(""+stackValues[i], _stackX + 27,
									  _stackY - (_layerHeight * i) + 15); 
		}
		if(stack.isEmpty()) {
			bufferGraphics.drawImage(topGif, _stackX + _layerWidth + 10, _stackY, this);
			bufferGraphics.drawImage(nullGif, _stackX, _stackY, this);
		}
		else
			bufferGraphics.drawImage(topGif, _stackX + (_layerWidth + 10), 
									 _stackY - (_layerHeight * (stack.size() - 1)), this);
		
		// draw buffer onto screen
		g.drawImage(buffer, 0, 0, this);
}	
	
// U P D A T E///////////////////////////////////////////////////////	
	public void update(Graphics g) { paint(g); }

// R U N/////////////////////////////////////////////////////////////	
	public void run() {
		Thread thisThread = Thread.currentThread();
		long start = 0, sleep = 0;
		while(true) {
			start = System.currentTimeMillis();
			if(!pause) {
			}
			repaint();	// repaint
			// sync repaints() to 30 fps
			sleep = frameRate - (int)(System.currentTimeMillis() - start);
			if(sleep <= 0) sleep = 1;	// never divide by zero
			sleep = 1000 / sleep;
			try { thisThread.sleep(sleep); }
			catch (InterruptedException e) {}
		}
	}
	
// S T A R T/////////////////////////////////////////////////////////	
	public void start() {
		if(animation == null)
			animation = new Thread(this);		
			animation.start();
	}
	
// S T O P///////////////////////////////////////////////////////////	
	public void stop() {
		animation = null;
	}

// W A I T   F O R   I M A G E///////////////////////////////////////	
    public static void waitForImage(Component component, Image image) {
        MediaTracker tracker = new MediaTracker(component);
        try {
			// wait for image to load before starting applet
            tracker.addImage(image, 0);
            tracker.waitForID(0);
        }
        catch(InterruptedException e) { e.printStackTrace(); }
    }
	
// F I L L   S R E E N///////////////////////////////////////////////
	/**fill the screen(g refers to) with the specified color*/
	public void FillScreen(Dimension size, Graphics g, Color color) {
		Color old_color = g.getColor();
		g.setColor(color);
		g.fillRect(0, 0, size.width, size.height);
		g.setColor(old_color);
	}
	
// F I L L   A R E A/////////////////////////////////////////////////
	/**fill an area(g refers to) with the specified color*/
	public void FillArea(int x, int y, int width, int height, Graphics g, Color color) {
		Color old_color = g.getColor();
		g.setColor(color);
		g.fillRect(x, y, width, height);
		g.setColor(old_color);
	}
		
// ValidateText//////////////////////////////////////////////////////
	public int ValidateText(TextField field, int lowValue, int highValue, int listSize, 
							boolean invalidIfEmpty, String str) {
		// if text is valid assign it the field value 
		// else assign it the value -1
		int fieldValue = -1;
		try {
			fieldValue = Integer.parseInt(field.getText());
		}
		catch (NumberFormatException e) {
			fieldValue = -1;		// not valid
			toolkit.beep();
			messageCenter.append("The " +str+ " " +field.getText()+ " is not valid\n");
			messageCenter.append("The " +str+ " must be an integer between " +lowValue + " and " +highValue+ "\n");
		}
		if(invalidIfEmpty) {
			if(listSize == 0) {
				fieldValue = -1;
				toolkit.beep();
				messageCenter.append("The " +str+ " " +field.getText()+ " is not valid because the list is currently empty\n");
			}
		}
		else if(fieldValue < lowValue || fieldValue > highValue) {
			fieldValue = -1;		// not valid
			toolkit.beep();
			messageCenter.append("The " +str+ " " +field.getText()+ " is not valid\n");
			messageCenter.append("The " +str+ " must be an integer between " +lowValue + " and " +highValue+ "\n");
		}
		return fieldValue;
	}

// IsFull////////////////////////////////////////////////////////////
	public void IsFull() {
		messageCenter.append("isFull = " +(stack.size() == MaxStackSize)+ "\n");
	}
	
// IsEmpty///////////////////////////////////////////////////////////
	public void IsEmpty() {
		messageCenter.append("Empty = " +(stack.size() == 0)+ "\n");
	}
	
// Top///////////////////////////////////////////////////////////////
	public void Top() {
		messageCenter.append("" +stack.peek()+ " is on the top of the stack\n");
	}
	
// Add///////////////////////////////////////////////////////////////
	public void Add() {
		if(stack.size() == MaxStackSize) {
			messageCenter.append("For demonstrations stack size is limited to 10\n");
		}
		else {// more room on stack
			if(!(addFieldTF < 0 || addFieldTF > _highValue)) {// valid textfield
				stackValues[stack.size()] = addFieldTF;
				stack.push(addFieldTF);			
				messageCenter.append("" +addFieldTF+ " has been added to the top of the stack\n");
			}
			else {
				messageCenter.append("The element " +addFieldTF+ " must be a number between 0 and " +_highValue+ "\n");
			}
		}
	}
	
// Delete////////////////////////////////////////////////////////////
	public void Delete() {
		if(stack.isEmpty()) {
			messageCenter.append("The stack is empty\n");
		}
		else {
			int x = stack.pop();
			messageCenter.append("" +x+ " has been removed from the top of the stack\n");
		}					  
	}
	
}// end LinkedStack class
	
	
	
	
	
