/**@author Chris Bobo -=BOBO GAMES=-
 * copyright 1999 all rights reserved -=BOBO GAMES=-
 * this applet demonstrates the workings of an array queue
 * @version 1.0
 */
import java.applet.*;
import java.awt.event.*;
import java.io.*;
import java.awt.*;
import java.awt.Toolkit;


// B O X   C L A S S/////////////////////////////////////////////////
class Box {
	int x,
		y,
		index,
		state,			// 0 == !showing, 1 = showing w/out value, 2 = showing w/ value
		infoX,
		infoY,
		value;
	
	// constructor
	Box(int x, int y, int index, int state, int infoX, int infoY) { 
		this.x = x;
		this.y = y;
		this.state = state;
		this.infoX = infoX;
		this.infoY = infoY;
		this.value = 0;		// default value
	}
	
	// draw the box into the buffer
	public void draw(Graphics graphics, Applet applet, int index, int listSize, Image fullBox, Image emptyBox) {
		Color old_color = graphics.getColor();
		if(this.state == 1 || this.state == 2) {// 1 == _visible, 2 == _full
			if(this.state == 1)			
				graphics.drawImage(emptyBox, this.x, this.y, applet);
			else {
				graphics.drawImage(fullBox, this.x, this.y, applet);
				graphics.setColor(Color.white);
				if(this.value  <= 9)
					graphics.drawString("" +this.value, this.infoX + 6, this.infoY);
				else if(this.value <= 99)
					graphics.drawString("" +this.value, this.infoX + 3, this.infoY);
				// used if highNum is above 99 and below 1000
//				else graphics.drawString("" +this.value, this.infoX, this.infoY);
			}// end else
		}
		graphics.setColor(old_color);
	}// end public void draw()
}

public class ArrayQueue extends Applet implements Runnable 
{
	// critical values for GUI and animation
	final int _optionX		= 20,
			 _optionY		= 50,
			 _buttonY		= _optionY + 5,
			 _buttonHeight	= 23,
			 _buttonSpacer	= _buttonHeight + 15,
			 _wideButton	= 100,
			 _narrowButton	= 70,
			 _5filler		= 5,
			 _10filler		= 10,
			 _titleX		= 200,
			 _border		= 10,
			 _displayX		= _optionX + 220 + _10filler,
			 _displayY		= _10filler * 2,
			 _displayWidth	= 345,
			 _displayHeight	= 240,
			 _displayBarX	= _displayX + _displayWidth,
			 _displayBarY	= _displayY,
			 _listX			= _displayX + 20,
			 _listY			= _displayY + 20,
			 _boxWidth		= 30,
			 _boxHeight		= 25,
			 _messageWidth	= _displayWidth,
			 _messageHeight = 150,
			 _messageY		= _displayY + _displayHeight + _10filler + _5filler,
			 _notVisible	= 0,	// state of box
			 _visible		= 1,	// state of box
			 _full			= 2,	// state of box
			 _noButton		= 0,
			 _isEmpty		= 1,
			 _remove		= 2,
			 _put			= 3,
			 _getFront		= 4,
			 _getRear		= 5,
			 _maxListSize	= 39;
	
	// doublebuffer
	Image buffer;
	Graphics bufferGraphics;
	Dimension bufferSize;
	
	// images
	Image boboGames, queue, fullBox, emptyBox, frontGif, rearGif, front_rearGif;
	
	// interface peices
	TextField putField;
	TextArea messageCenter;
	Button emptyButton, getFrontButton, getRearButton, 
		   putButton, removeButton;
	Scrollbar speedBar;

	
	// animation thread
	Thread animation;
	
	// let's us use system dependant properties
	Toolkit toolkit;
	
	// applet size on screen
	Dimension appletSize;
	
	// box info
	Box [][] box;
	
	// set font so applet has the same look on different systems
	Font f = new Font("TimesRoman", Font.PLAIN, 12);
	
	// used to get location in Box matrix
	Point loc = new Point(0,0);
	
	int frameRate = 10;	// animation speed
	int active_button = _noButton;
	
	// track front and rear pointers of queue
	int front = 0, 
		rear = 0;
	
	int listSize = 0,
		currMaxListSize = 10;
	
	
	// used for text fields
	int element_putTF = 0;
	
	// range fo valid values for text fields
	int	lowNum = 0,
		highNum = 99;

	public void init() {
		setLayout(null);
		
		// set up doublebuffer
		// make buffer size fo updatable screen portion
		bufferSize = this.getSize();
		buffer = this.createImage(bufferSize.width, bufferSize.height);
		bufferGraphics = buffer.getGraphics();
		
		// load images for applet
		boboGames	= this.getImage(this.getCodeBase(), "bg.gif");
		waitForImage(this, boboGames);
		queue	= this.getImage(this.getCodeBase(), "llist.gif");
		waitForImage(this, queue);
		fullBox	= this.getImage(this.getCodeBase(), "full_llbox.gif");
		waitForImage(this, fullBox);
		emptyBox	= this.getImage(this.getCodeBase(), "empty_llbox.gif");
		waitForImage(this, emptyBox);
		frontGif	= this.getImage(this.getCodeBase(), "front.gif");
		waitForImage(this, frontGif);
		rearGif	= this.getImage(this.getCodeBase(), "rear.gif");
		waitForImage(this, rearGif);
		front_rearGif	= this.getImage(this.getCodeBase(), "front_and_rear.gif");
		waitForImage(this, front_rearGif);

		for(int i = 0; i < 10; i++) box = new Box [i][];		

		box = new Box [10][4];
		// allocate/initailize box info storage
		int x = 0, y = 0, index = 0, indexX = 0, 
			indexY = 0, infoX = 0, infoY = 0, state = 0;
		for(int i = 0; i < 4; i ++) {	
			for(int j = 0; j < 10; j++) {
				if(i == 0 && j < currMaxListSize) state = _visible;
				else state = _notVisible;
				x = _displayX + 20 + j * _boxWidth;
				y = _displayY + 20 + (i * 55);
				infoX = x + 6;
				infoY = y + 17;				
				index = j + (10 * i);
				box[j][i] = new Box(x, y, index, state, infoX, infoY);
			}// end for
		}// end for

		// get applet size on window
		appletSize = this.getSize();
		
		// get a system Toolkit
		toolkit = this.getToolkit();
		
		// set fonts
		this.setFont(f);
		bufferGraphics.setFont(f);
		
		// empty
		emptyButton = new Button("isEmpty");
		emptyButton.setBounds(_optionX, _buttonY, _wideButton, _buttonHeight);
		add(emptyButton);
		emptyButton.addMouseListener(new MouseAdapter() {
			public void mousePressed(MouseEvent e) { 
				if(active_button == _noButton)
					active_button = _isEmpty;
					showIsEmpty(); 
			}
		});

		// getFront
		getFrontButton = new Button("getFrontElement");
		getFrontButton.setBounds(_optionX, _buttonY + _buttonSpacer, _wideButton, _buttonHeight);
		add(getFrontButton);
		getFrontButton.addMouseListener(new MouseAdapter() {
			public void mousePressed(MouseEvent e) { 
				if(active_button == _noButton) {
					if(IsEmpty()) messageCenter.append("The list is empty\n");
					else {
						active_button = _getFront;
						int tempFront = front;
						if(tempFront == 39) tempFront = 0;
						else tempFront = ++tempFront % 40;
						getMatrixPos(tempFront, loc);
						messageCenter.append("The element in the front of the queue is " +box[loc.x][loc.y].value+ "\n");
					}
				}// end if
			}
		});

		// getRear
		getRearButton = new Button("getRearElement");
		getRearButton.setBounds(_optionX, _buttonY + (_buttonSpacer * 2), _wideButton, _buttonHeight);
		add(getRearButton);
		getRearButton.addMouseListener(new MouseAdapter() {
			public void mousePressed(MouseEvent e) {
				if(active_button == _noButton) {
					if(IsEmpty()) messageCenter.append("The list is empty\n");
					else {
						active_button = _getRear;
						getMatrixPos(rear, loc);
						messageCenter.append("The element in the rear of the queue is " +box[loc.x][loc.y].value+ "\n");
					}
				}// end if
			}
		});
		
		// insert
		putButton = new Button("put");
		putButton.setBounds(_optionX, _buttonY + (_buttonSpacer * 3), _wideButton, _buttonHeight);
		add(putButton);
		putButton.addMouseListener(new MouseAdapter() {
			public void mousePressed(MouseEvent e) {
				if(active_button == _noButton) {
					active_button = _put;
					if(listSize < _maxListSize) {
						// there is more room in the list
						element_putTF = ValidateText(putField, lowNum, highNum, listSize, false, "element");
						if(element_putTF == -1) {// putField is invalid
							messageCenter.append("The element must be an integer between " +lowNum+ " and "+highNum+ "\n");
						}// end if
						else {
							if(listSize + 2 > currMaxListSize)  {// putField is valid
								messageCenter.append("Queue size being doubled\n");
								if(currMaxListSize == 10) {
									RearrangeArray();
									for(int i = 0 ; i < 10; i++) 
										box[i][1].state = 1;
									currMaxListSize = 20;
								}// end if
								else if (currMaxListSize == 20) {
									RearrangeArray();
									for(int i = 0; i < 10; i++) {
										box[i][2].state = _visible;
										box[i][3].state = _visible;
									}// end for
									currMaxListSize = 40;
								}// end else if
							}// end if
							rear = ++rear % currMaxListSize;
							getMatrixPos(rear, loc);
							box[loc.x][loc.y].value = element_putTF;
							box[loc.x][loc.y].state = _full;
							listSize++;
						}// end else
					}// end if
					else {// list is already full 
						messageCenter.append("for demonstration purposes the list size is limited to " +_maxListSize+ "\n");
					}
				}// end if
			}// end mousePressed()
		});

		putField = new TextField("0");
		putField.setBounds(_optionX + _wideButton + 10, _buttonY + (_buttonSpacer * 3), _wideButton, _buttonHeight);
		add(putField);

		// remove
		removeButton = new Button("remove");
		removeButton.setBounds(_optionX, _buttonY + (_buttonSpacer * 4), _wideButton, _buttonHeight);
		add(removeButton);
		removeButton.addMouseListener(new MouseAdapter() {
			public void mousePressed(MouseEvent e) {
				if(active_button == _noButton){
					active_button = _remove;
					if(listSize > 0) {
						front = ++front % currMaxListSize;
						getMatrixPos(front, loc);
						box[loc.x][loc.y].state = _visible;
						listSize--;
					}// end if
					else {
						toolkit.beep();
						messageCenter.append("The list is empty there is nothing to remove\n");
					}// end else
				}// end if
			}
		});
		
		// message center
		messageCenter = new TextArea();
		messageCenter.setBounds(_displayX, _messageY, _messageWidth, _messageHeight);
		messageCenter.setEditable(true);
		messageCenter.append("All messages will appear here...\n");
		add(messageCenter);

	}// end init	
	
// P A I N T/////////////////////////////////////////////////////////	
	public void paint(Graphics g) {
		// fill screen with black
		FillScreen(this.getSize(), bufferGraphics, Color.black);
		
		// create display area
		FillArea(_displayX + 2, _displayY + 2, _displayWidth - 3, _displayHeight - 3, 
				 bufferGraphics, Color.white);
		bufferGraphics.setColor(Color.gray);
		bufferGraphics.draw3DRect(_displayX, _displayY, _displayWidth, _displayHeight, false);
		
		bufferGraphics.drawImage(boboGames, appletSize.width - 110, appletSize.height - 25, this);
		bufferGraphics.drawImage(queue, 10, 10, this);
		
		bufferGraphics.setColor(Color.white);
		bufferGraphics.drawString("e  l  e  m  e  n  t", _optionX + _wideButton + 20,
								  _buttonY + (_buttonSpacer * 3) + 35);
		
		bufferGraphics.setColor(Color.black);
		
		// draw the boxes into the buffer
		for(int i = 0; i < 4; i++) {
			for(int j = 0; j < 10; j++) {
				box[j][i].draw(bufferGraphics, this, (j + (10 * i)), listSize, fullBox, emptyBox);
			}// end for
		}// end for
		
		// shows front and rear pointer locations
		if(front == rear) {
			getMatrixPos(rear, loc);
			bufferGraphics.drawImage(front_rearGif, box[loc.x][loc.y].x - 5, box[loc.x][loc.y].y + _boxHeight, this);
		}// end if
		else {			
			getMatrixPos(rear, loc);
			bufferGraphics.drawImage(rearGif, box[loc.x][loc.y].x - 5, box[loc.x][loc.y].y + _boxHeight, this);
			getMatrixPos(front, loc);
			bufferGraphics.drawImage(frontGif, box[loc.x][loc.y].x - 5, box[loc.x][loc.y].y + _boxHeight, this);
		}// end else
		
		// draw the buffer to the screen
		g.drawImage(buffer, 0, 0, this);
}	
	
// U P D A T E///////////////////////////////////////////////////////	
	public void update(Graphics g) { paint(g); }

// R U N/////////////////////////////////////////////////////////////	
	public void run() {
		Thread thisThread = Thread.currentThread();
		long start = 0, sleep = 0;
		while(true) {
			start = System.currentTimeMillis();
			repaint();	// repaint the screen
			
			// test only
			if(active_button == _put) {
				// wait here so i can check variables
				int w = 0;
			}
			
			// only 1 button can be pressed during each cycle
			active_button = _noButton;
			// sync repaints() from 1 - 30 fps
			sleep = frameRate - (int)(System.currentTimeMillis() - start);
			if(sleep <= 0) sleep = 1;	// never divide by zero
			sleep = 1000 / sleep;
			try { thisThread.sleep(sleep); }
			catch (InterruptedException e) {}
		}
	}
	
// S T A R T/////////////////////////////////////////////////////////	
	public void start() {
		if(animation == null)
			animation = new Thread(this);		
			animation.start();
	}
	
// S T O P///////////////////////////////////////////////////////////	
	public void stop() {
		animation = null;
	}

// W A I T   F O R   I M A G E///////////////////////////////////////	
    public static void waitForImage(Component component, Image image) {
        MediaTracker tracker = new MediaTracker(component);
        try {
			// wait for image to load before starting applet
            tracker.addImage(image, 0);
            tracker.waitForID(0);
        }
        catch(InterruptedException e) { e.printStackTrace(); }
    }
	
// F I L L   S R E E N///////////////////////////////////////////////
	/**fill the screen(g refers to) with the specified color*/
	public void FillScreen(Dimension size, Graphics g, Color color) {
		Color old_color = g.getColor();
		g.setColor(color);
		g.fillRect(0, 0, size.width, size.height);
		g.setColor(old_color);
	}
	
// F I L L   A R E A/////////////////////////////////////////////////
	/**fill an area(g refers to) with the specified color*/
	public void FillArea(int x, int y, int _x, int _y, Graphics g, Color color) {
		Color old_color = g.getColor();
		g.setColor(color);
		g.fillRect(x, y, _x, _y);
		g.setColor(old_color);
	}

// RearrangeArray()//////////////////////////////////////////////////
	public void RearrangeArray() {
		// make a copy of the array
		int [] array = new int[currMaxListSize];
		for(int i  = 0; i < currMaxListSize; i++) {
			getMatrixPos(i, loc);
			array[i] = box[loc.x][loc.y].value;
		}
		
		// now rearrange array into the original
		int cnt = 1;
		for(int i = front + 1; i != front; i = ++i % currMaxListSize, cnt++) {
			getMatrixPos(cnt, loc);
			box[loc.x][loc.y].value = array[i];
			box[loc.x][loc.y].state = _full;
		}
		getMatrixPos(0, loc);
		box[loc.x][loc.y].state = _visible;
		front = 0;
		rear = currMaxListSize - 1;
	}
	
// showIsEmpty///////////////////////////////////////////////////////
	public void showIsEmpty() {
		messageCenter.append("isEmpty = " +IsEmpty()+ "\n");
	}
	
// IsEmpty///////////////////////////////////////////////////////////
	public boolean IsEmpty() {
		return (front == rear);
	}
	
// Remove()//////////////////////////////////////////////////////
	public void Remove() {
	}// end Remove()
	
// Insert()/////////////////////////////////////////////
	public void Insert() {
	}
	
// getMatrixPos//////////////////////////////////////////////////////
	public void getMatrixPos(int cnt, Point pt){
		pt.y = cnt / 10;
		pt.x = cnt % 10;
	}
		
// ValidateText//////////////////////////////////////////////////////
	public int ValidateText(TextField field, int lowValue, int highValue, int listSize, 
							boolean invalidIfEmpty, String str) {
		// if value in field is valid assing it hte value
		// else assing it the value of -1
		int fieldValue = -1;
		try {
			fieldValue = Integer.parseInt(field.getText());
		}
		catch (NumberFormatException e) {
			field.selectAll();
			fieldValue = -1;		// not valid
			toolkit.beep();
		}
		if(invalidIfEmpty) {
			if(listSize == 0) {
				fieldValue = -1;
				toolkit.beep();
				messageCenter.append("The " +str+ " " +field.getText()+ " is not valid because the list is currently empty\n");
			}
			else if(fieldValue < lowValue || fieldValue > highValue) {
				fieldValue = -1;		// not valid
				toolkit.beep();
				messageCenter.append("The " +str+ " " +field.getText()+ " is not valid\n");
				messageCenter.append("The " +str+ " must be an integer between " +lowValue + " and " +highValue+ "\n");			
			}
		}
		else if(fieldValue < lowValue || fieldValue > highValue) {
			fieldValue = -1;		// not valid
			toolkit.beep();
			messageCenter.append("The " +str+ " " +field.getText()+ " is not valid\n");
			messageCenter.append("The " +str+ " must be an integer between " +lowValue + " and " +highValue+ "\n");
		}
		return fieldValue;
	}

}// end ArrayQueue class