// Emacs: -*- C++ -*-

//
//	Copyright 1993, Center for Computer Vision and Visualization,
//	University of Florida.  All rights reserved.
//

static char copyright[] = "Copyright 1993, Center for Computer Vision and Visualization,\nUniversity of Florida.  All rights reserved.\n";

#include "ClosurePS.h"
#include "IntPoint.h"
#include "FloatPoint.h"
#include "ValueSet.h"
#include "IntPointSet.h"
#include "PSIter.h"

template <class P>
class empty_ps:public IA_ClosurePS<P> {
  public:
    IA_ClosurePS<P> *clone_self() const;
    int contains(const P &ip) const;
    empty_ps(unsigned dim) :IA_ClosurePS<P>(dim) {};
};

template <class P>
IA_ClosurePS<P> *empty_ps<P>::clone_self() const
{
    return new empty_ps<P>(dimen);
}

template <class P>
int empty_ps<P>::contains(const P &) const
{
    return 0;
}

empty_ps<IA_Point<int> >	tempI(2);
empty_ps<IA_FloatPoint>	tempF(2);

void exercise(const IA_IntPointSet &ps)
{
    IA_PSIter<IA_IntPoint>	iter1,
				iter2(ps);
    IA_PSIter<IA_IntPoint>	iter3(iter1);

    iter1 = iter2;
    iter3 = iter2.domain();

    IA_IntPoint ip;
    if (iter1(ip))
	iter1.reset();
}

typedef IA_PSIter<IA_FloatPoint> IA_FPSIter;

void exercise(const IA_FloatPointSet &ps)
{
    IA_FPSIter	iter1,
	iter2(ps);
    IA_FPSIter	iter3(iter1);

    iter1 = iter2;
    iter3 = iter2.domain();

    IA_FloatPoint ip;
    if (iter1(ip))
	iter1.reset();
}


// placate the stupid ptlink

IA_ValueSet<IA_FloatPoint>::IA_ValueSet(IA_FloatPoint) { }

IA_ValueSet<IA_FloatPoint>::IA_ValueSet(const IA_FloatPoint*, unsigned) { }


int IA_ValueSet<IA_FloatPoint>::contains(IA_FloatPoint) const {
  return 0;
}


ostream &operator<<(ostream &o, const IA_Point<int>&) {
  return o;
}

ostream &operator<<(ostream &o, const IA_ValueSet<IA_FloatPoint>&) {
  return o;
};


//
//
//

int pointcmp(const IA_Point<int>&, const IA_Point<int>&) {
  return 0;
}
int pointcmp(const IA_Point<double>&, const IA_Point<double>&) {
  return 0;
}

IA_Point<double>::IA_Point(const IA_Point<double>&) { }
IA_Point<double>& IA_Point<double>::operator= (const IA_Point<double>&) { return *this; }

IA_Point<int> IA_Point<int>:: operator+(const IA_Point<int>&) const { return IA_Point<int>(); }
IA_Point<int> IA_Point<int>:: operator-(const IA_Point<int>&) const { return IA_Point<int>(); }
int IA_Point<int>::operator==(const IA_Point<int>&) const { return 0; }
int IA_Point<int>::operator<=(const IA_Point<int>&) const { return 0; }

IA_Point<int> inf(const IA_Point<int>&, const IA_Point<int>&) { return IA_Point<int>(); }
IA_Point<int> sup(const IA_Point<int>&, const IA_Point<int>&) { return IA_Point<int>(); }
IA_Point<int>::IA_Point(const IA_Point<int>&) { }
IA_Point<int>& IA_Point<int>::operator= (const IA_Point<int>&) { return *this; }

IA_Point<int> cdr(const IA_Point<int>&, int) { return IA_Point<int>(); }
IA_Point<int>::IA_Point(int*, unsigned, int) {}
IA_Point<int> concat(int, const IA_Point<int>&) { return IA_Point<int>(); }

IA_Point<int> IA_Point<int>::derange(unsigned, unsigned) const {
    return IA_Point<int>();
}

void ia_throw(IA::Error, char*, int) { }

