// Emacs: -*- C++ -*-

//
//	Copyright 1993, Center for Computer Vision and Visualization,
//	University of Florida.  All rights reserved.
//


// 
// $Log:	PredicatePS.h,v $
// Revision 1.3  93/05/26  16:51:44  thoth
// Copyright Notices
// 
// Revision 1.2  93/02/12  16:28:00  thoth
// more IA_ prefixes.
// 
// Revision 1.1  93/01/20  11:37:06  thoth
// Initial revision
// 
//

#ifndef PredicatePS_h_
#define PredicatePS_h_

#include "BasePS.h"

template <class P>
struct IA_PSPred: public IA_BasePS<P> {
private:
    static char type_;
public:
    IA_PSPred(unsigned dim)
    : IA_BasePS<P>(dim) {}
    virtual IA_PSPred<P> *clone_self() const=0;

    int equal(IA_BasePS<P>*other) const {
	return other->type()==this->type() &&
	    this == (IA_PSPred<P>*)other;
    }
    unsigned hash_self(unsigned mod) const {
	return mod-1;
    }
    static IA_PointSetType s_type() { return &type_; }
    IA_PointSetType type() const { return &type_; }

    // this must be defined by the user
    // int contains (const P &ip) const;

    int extensivep() const { return 0; }
    void output(ostream&, unsigned=0) const;
};

#endif
