// Emacs: -*- C++ -*-

//
//	Copyright 1993, Center for Computer Vision and Visualization,
//	University of Florida.  All rights reserved.
//

// 
// $Log: BaseIPSIter.c,v $
// Revision 1.1  1993/09/15  12:38:15  thoth
// Initial revision
//

#include "BaseIPSIter.h"

template <class P>
IA_BasePSIter<P>::IA_BasePSIter(IA_BasePS<P> *x)
     :domain(x)
{
  domain->enref();
}

template <class P>
IA_BasePSIter<P>:: IA_BasePSIter(const IA_BasePSIter<P> & psi) {
  domain = psi.domain;
  domain->enref();
}
template <class P>
IA_BasePSIter<P>:: ~IA_BasePSIter() {
    if (domain->unref() <= 0)
	delete domain;
}

template <class P>
IA_BasePSIter<P>& IA_BasePSIter<P>:: operator=(const IA_BasePSIter<P> &arg) {
    IA_BasePS<P>	*temp = arg.domain;
    temp->enref();
    if (domain->unref() <=0)
	delete domain;
    domain = temp;
    return *this;
}
