// Emacs: -*- C++ -*-

//
//	Copyright 1993, Center for Computer Vision and Visualization,
//	University of Florida.  All rights reserved.
//

static char VectorDIVIterrcsid[] = "$Id: VectorDIVIter.c,v 1.5 93/05/27 11:28:35 thoth Exp $";

// $Log:	VectorDIVIter.c,v $
// Revision 1.5  93/05/27  11:28:35  thoth
// Copyright Notices
// 
// Revision 1.4  93/04/17  18:45:17  thoth
// Iterator support is no longer based on a switch statement.  We now
// use a virtual method.  The user can now provide faster iterators.
// 
// Revision 1.3  93/02/20  12:43:37  thoth
// There are now two sorts of BaseDIIters.
// 
// Revision 1.2  93/01/19  14:56:45  jnw
// Modified to support IA_ naming convention
// 
// Revision 1.1  92/11/12  17:02:04  jnw
// Initial revision
// 
// Revision 1.1  92/10/05  11:46:12  jnw
// Initial revision
// 

#include "VectorDIVIter.h"

template <class T>
IA_VectorDIVIter<T>::IA_VectorDIVIter(const IA_VectorDI<T> *img)
: IA_BaseDIVIter<T>(img)
{
    this->num_left = this->domain->domain().card();
    this->index = 0;
}

template <class T>
IA_VectorDIVIter<T>::IA_VectorDIVIter(const IA_VectorDIVIter<T> &iter)
: IA_BaseDIVIter<T>(iter.domain)
{
    this->num_left = iter.num_left;
    this->index = iter.index;
}

template <class T>
int IA_VectorDIVIter<T>::next(T& pixel_value)
{
    if (this->num_left > 0) {
	pixel_value = this->vdip()->vec[this->index++];
	this->num_left--;
	return 1;
    } else {
	return 0;
    }
}
