// Emacs: -*- C++ -*-

//
//	Copyright 1993, Center for Computer Vision and Visualization,
//	University of Florida.  All rights reserved.
//


// $Log:	VectorDIPIter.h,v $
// Revision 1.6  93/05/27  11:22:47  thoth
// Copyright Notices
// 
// Revision 1.5  93/04/17  18:45:16  thoth
// Iterator support is no longer based on a switch statement.  We now
// use a virtual method.  The user can now provide faster iterators.
// 
// Revision 1.4  93/02/20  12:43:35  thoth
// There are now two sorts of BaseDIIters.
// 
// Revision 1.3  93/01/19  14:56:44  jnw
// Modified to support IA_ naming convention
// 
// Revision 1.2  92/11/12  17:04:30  jnw
// Modified to match new pixel/value iter style
// 
// Revision 1.1  92/10/05  11:46:10  jnw
// Initial revision
// 

#ifndef VectorDIPIter_h_
#define VectorDIPIter_h_

#include <stdlib.h>
#include "IPSIter.h"
#include "BaseDIIter.h"
#include "VectorDI.h"

template <class T>
class IA_VectorDIPIter: public IA_BaseDIPIter<T> {
protected:
    // index stores the index of the current point within the value vector
    int index;

    // vdip points at the base image over which we're iterating.
    IA_VectorDI<T> *vdip() const { return (IA_VectorDI<T> *)domain; }

    // psiter is an iterator over bdip's PointSet.
    IA_IPSIter psiter;

public:

    IA_VectorDIPIter(const IA_VectorDI<T> *);
    IA_VectorDIPIter(const IA_VectorDIPIter&);

    ~IA_VectorDIPIter() {}

    IA_BaseDIPIter<T> * clone_self() { return new IA_VectorDIPIter(*this); }

    int next(IA_IntPoint&, T&);

    void reset() { psiter.reset(); this->index = 0;}

    IA_BaseDI<T> *domain_() const { return this->domain; }
};

#endif
