// Emacs -*- C++ -*-

// Machine generated include file, do not modify.


// 	Copyright 1993, Center for Computer Vision and Visualization,
// 	University of Florida.  All rights reserved.


//  $Log:	uchar-operations.desc,v $
//  Revision 1.3  93/05/27  11:41:17  thoth
//  Copyright Notices
//  
//  Revision 1.2  93/05/18  21:45:40  thoth
//  New reductions to bring ucharDI up to speed.
//  
//  Revision 1.1  93/03/18  11:25:21  thoth
//  Initial revision
//  
//////////////////////////////////////////////////////////////////////
//
// Begin operation support routines for :
// binary pointwise commutative operator+ I(u_char) I(u_char) I(u_char)
//
static IA_UcharDiscreteImage
vec_vec_bo_operatorIAOPpl(const IA_VectorDI<u_char> *lhs,const IA_VectorDI<u_char> *rhs)
{
    const IA_IntPointSet domain = lhs->domain();
    const unsigned sz = domain.card();
    u_char *const vec = new u_char[sz];

    {
	u_char *ds = vec;
	const u_char *ls = lhs->vec;
	const u_char *rs = rhs->vec;
	for (unsigned i=0; i<sz; i++) {
	    *(ds++) = ( (*(ls++)) + (*(rs++)) );
	}
    }
    return IA_UcharDiscreteImage(domain, vec, sz, 1);
}

#ifndef vec_scalar_u_char_u_char_u_char_operatorIAOPpl
#define vec_scalar_u_char_u_char_u_char_operatorIAOPpl
static IA_UcharDiscreteImage
vec_scalar_bo_operatorIAOPpl(const IA_VectorDI<u_char> *lhs,u_char rhs)
{
    const IA_IntPointSet domain = lhs->domain();
    const unsigned sz = domain.card();
    u_char *const vec = new u_char[sz];

    {
	u_char *ds = vec;
	const u_char *ls = lhs->vec;
	for (unsigned i=0; i<sz; i++) {
	    *(ds++) = ( (*(ls++)) + (rhs) );
	}
    }
    return IA_UcharDiscreteImage(domain, vec, sz, 1);
}
#endif // vec_scalar_u_char_u_char_u_char_operatorIAOPpl

static IA_UcharDiscreteImage
vec_iter_bo_operatorIAOPpl(const IA_VectorDI<u_char> *lhs,IA_UcharDiscreteImage rhs)
{
    const IA_IntPointSet domain = lhs->domain();
    const unsigned sz = domain.card();
    u_char *const vec = new u_char[sz];

    {
	u_char *ds = vec;
	const u_char *ls = lhs->vec;
	u_char rtmp;
	IA_DIVIter<u_char>	riter(rhs);
	for (unsigned i=0; i<sz; i++) {
	    riter(rtmp);
	    *(ds++) = ( (*(ls++)) + (rtmp) );
	}
    }
    return IA_UcharDiscreteImage(domain, vec, sz, 1);
}

// scalar-scalar operation is trivial

#ifndef scalar_iter_u_char_u_char_u_char_operatorIAOPpl
#define scalar_iter_u_char_u_char_u_char_operatorIAOPpl
static IA_UcharDiscreteImage
scalar_iter_bo_operatorIAOPpl(u_char lhs,IA_UcharDiscreteImage rhs)
{
    const IA_IntPointSet domain = rhs.domain();
    const unsigned sz = domain.card();
    u_char *const vec = new u_char[sz];

    {
	u_char *ds = vec;
	u_char rtmp;
	IA_DIVIter<u_char>	riter(rhs);
	for (unsigned i=0; i<sz; i++) {
	    riter(rtmp);
	    *(ds++) = ( (lhs) + (rtmp) );
	}
    }
    return IA_UcharDiscreteImage(domain, vec, sz, 1);
}
#endif // scalar_iter_u_char_u_char_u_char_operatorIAOPpl

static IA_UcharDiscreteImage
iter_iter_bo_operatorIAOPpl(IA_UcharDiscreteImage lhs,IA_UcharDiscreteImage rhs)
{
    const IA_IntPointSet domain = lhs.domain();
    const unsigned sz = domain.card();
    u_char *const vec = new u_char[sz];

    {
	u_char *ds = vec;
	u_char ltmp;
	IA_DIVIter<u_char>	liter(lhs);
	u_char rtmp;
	IA_DIVIter<u_char>	riter(rhs);
	for (unsigned i=0; i<sz; i++) {
	    liter(ltmp);
	    riter(rtmp);
	    *(ds++) = ( (ltmp) + (rtmp) );
	}
    }
    return IA_UcharDiscreteImage(domain, vec, sz, 1);
}

IA_UcharDiscreteImage
operator+ ( const IA_UcharDiscreteImage &lhs,
	      const IA_UcharDiscreteImage &rhs)
{
    if (lhs.domain() != rhs.domain()) {
	static IA_UcharDiscreteImage	rval;
	ia_throw( IA::PSET_MISMATCH, __FILE__,__LINE__);
	return rval;
    }

    if (lhs.type() == IA_VectorDI<u_char>::s_type()) {
	if (rhs.type() == IA_VectorDI<u_char>::s_type()) {
	    return vec_vec_bo_operatorIAOPpl((IA_VectorDI<u_char> *)lhs.bdip,(IA_VectorDI<u_char> *)rhs.bdip);
	} else if (rhs.type() == IA_ConstDI<u_char>::s_type()) {
	    return vec_scalar_bo_operatorIAOPpl((IA_VectorDI<u_char> *)lhs.bdip,((IA_ConstDI<u_char> *)rhs.bdip)->value);
	} else {
	    return vec_iter_bo_operatorIAOPpl((IA_VectorDI<u_char> *)lhs.bdip,rhs);
	}
    } else if (lhs.type() == IA_ConstDI<u_char>::s_type()) {
	if (rhs.type() == IA_VectorDI<u_char>::s_type()) {
	    return vec_scalar_bo_operatorIAOPpl((IA_VectorDI<u_char> *)rhs.bdip,((IA_ConstDI<u_char> *)lhs.bdip)->value);
	} else if (rhs.type() == IA_ConstDI<u_char>::s_type()) {
	    return IA_UcharDiscreteImage (lhs.domain(), (((IA_ConstDI<u_char> *)lhs.bdip)->value) + (((IA_ConstDI<u_char> *)rhs.bdip)->value));
	} else {
	    return scalar_iter_bo_operatorIAOPpl(((IA_ConstDI<u_char> *)lhs.bdip)->value,rhs);
	}
    } else {
	if (rhs.type() == IA_VectorDI<u_char>::s_type()) {
	    return vec_iter_bo_operatorIAOPpl((IA_VectorDI<u_char> *)rhs.bdip,lhs);
	} else if (rhs.type() == IA_ConstDI<u_char>::s_type()) {
	    return scalar_iter_bo_operatorIAOPpl(((IA_ConstDI<u_char> *)rhs.bdip)->value,lhs);
	} else {
	    return iter_iter_bo_operatorIAOPpl(lhs,rhs);
	}
    }
}

//////////////////////////////////////////////////////////////////////
//
// Begin operation support routines for :
// binary pointwise commutative operator+ I(u_char) int I(u_char)
//
#ifndef vec_scalar_u_char_u_char_int_operatorIAOPpl
#define vec_scalar_u_char_u_char_int_operatorIAOPpl
static IA_UcharDiscreteImage
vec_scalar_bo_operatorIAOPpl(const IA_VectorDI<u_char> *lhs,int rhs)
{
    const IA_IntPointSet domain = lhs->domain();
    const unsigned sz = domain.card();
    u_char *const vec = new u_char[sz];

    {
	u_char *ds = vec;
	const u_char *ls = lhs->vec;
	for (unsigned i=0; i<sz; i++) {
	    *(ds++) = ( (*(ls++)) + (rhs) );
	}
    }
    return IA_UcharDiscreteImage(domain, vec, sz, 1);
}
#endif // vec_scalar_u_char_u_char_int_operatorIAOPpl

// scalar-scalar operation is trivial

#ifndef iter_scalar_u_char_u_char_int_operatorIAOPpl
#define iter_scalar_u_char_u_char_int_operatorIAOPpl
static IA_UcharDiscreteImage
iter_scalar_bo_operatorIAOPpl(IA_UcharDiscreteImage lhs,int rhs)
{
    const IA_IntPointSet domain = lhs.domain();
    const unsigned sz = domain.card();
    u_char *const vec = new u_char[sz];

    {
	u_char *ds = vec;
	u_char ltmp;
	IA_DIVIter<u_char>	liter(lhs);
	for (unsigned i=0; i<sz; i++) {
	    liter(ltmp);
	    *(ds++) = ( (ltmp) + (rhs) );
	}
    }
    return IA_UcharDiscreteImage(domain, vec, sz, 1);
}
#endif // iter_scalar_u_char_u_char_int_operatorIAOPpl

IA_UcharDiscreteImage
operator+ ( const IA_UcharDiscreteImage &lhs, int rhs)
{
    if (lhs.type() == IA_VectorDI<u_char>::s_type()) {
	return vec_scalar_bo_operatorIAOPpl((IA_VectorDI<u_char> *)lhs.bdip,rhs);
    } else if (lhs.type() == IA_ConstDI<u_char>::s_type()) {
	return IA_UcharDiscreteImage (lhs.domain(), (((IA_ConstDI<u_char> *)lhs.bdip)->value) + (rhs));
    } else {
	return iter_scalar_bo_operatorIAOPpl(lhs,rhs);
    }
}

//////////////////////////////////////////////////////////////////////
//
// Begin operation support routines for :
// pointwise operator+= I(u_char) I(u_char)
//
// There are none (it's inline)

//////////////////////////////////////////////////////////////////////
//
// Begin operation support routines for :
// pointwise operator+= I(u_char) int
//
// There are none (it's inline)

//////////////////////////////////////////////////////////////////////
//
// Begin operation support routines for :
// binary pointwise non-commutative operator- I(u_char) I(u_char) I(u_char)
//
static IA_UcharDiscreteImage
vec_vec_bo_operatorIAOPmn(const IA_VectorDI<u_char> *lhs,const IA_VectorDI<u_char> *rhs)
{
    const IA_IntPointSet domain = lhs->domain();
    const unsigned sz = domain.card();
    u_char *const vec = new u_char[sz];

    {
	u_char *ds = vec;
	const u_char *ls = lhs->vec;
	const u_char *rs = rhs->vec;
	for (unsigned i=0; i<sz; i++) {
	    *(ds++) = ( (*(ls++)) - (*(rs++)) );
	}
    }
    return IA_UcharDiscreteImage(domain, vec, sz, 1);
}

#ifndef vec_scalar_u_char_u_char_u_char_operatorIAOPmn
#define vec_scalar_u_char_u_char_u_char_operatorIAOPmn
static IA_UcharDiscreteImage
vec_scalar_bo_operatorIAOPmn(const IA_VectorDI<u_char> *lhs,u_char rhs)
{
    const IA_IntPointSet domain = lhs->domain();
    const unsigned sz = domain.card();
    u_char *const vec = new u_char[sz];

    {
	u_char *ds = vec;
	const u_char *ls = lhs->vec;
	for (unsigned i=0; i<sz; i++) {
	    *(ds++) = ( (*(ls++)) - (rhs) );
	}
    }
    return IA_UcharDiscreteImage(domain, vec, sz, 1);
}
#endif // vec_scalar_u_char_u_char_u_char_operatorIAOPmn

static IA_UcharDiscreteImage
vec_iter_bo_operatorIAOPmn(const IA_VectorDI<u_char> *lhs,IA_UcharDiscreteImage rhs)
{
    const IA_IntPointSet domain = lhs->domain();
    const unsigned sz = domain.card();
    u_char *const vec = new u_char[sz];

    {
	u_char *ds = vec;
	const u_char *ls = lhs->vec;
	u_char rtmp;
	IA_DIVIter<u_char>	riter(rhs);
	for (unsigned i=0; i<sz; i++) {
	    riter(rtmp);
	    *(ds++) = ( (*(ls++)) - (rtmp) );
	}
    }
    return IA_UcharDiscreteImage(domain, vec, sz, 1);
}

#ifndef scalar_vec_u_char_u_char_u_char_operatorIAOPmn
#define scalar_vec_u_char_u_char_u_char_operatorIAOPmn
static IA_UcharDiscreteImage
scalar_vec_bo_operatorIAOPmn(u_char lhs,const IA_VectorDI<u_char> *rhs)
{
    const IA_IntPointSet domain = rhs->domain();
    const unsigned sz = domain.card();
    u_char *const vec = new u_char[sz];

    {
	u_char *ds = vec;
	const u_char *rs = rhs->vec;
	for (unsigned i=0; i<sz; i++) {
	    *(ds++) = ( (lhs) - (*(rs++)) );
	}
    }
    return IA_UcharDiscreteImage(domain, vec, sz, 1);
}
#endif // scalar_vec_u_char_u_char_u_char_operatorIAOPmn

// scalar-scalar operation is trivial

#ifndef scalar_iter_u_char_u_char_u_char_operatorIAOPmn
#define scalar_iter_u_char_u_char_u_char_operatorIAOPmn
static IA_UcharDiscreteImage
scalar_iter_bo_operatorIAOPmn(u_char lhs,IA_UcharDiscreteImage rhs)
{
    const IA_IntPointSet domain = rhs.domain();
    const unsigned sz = domain.card();
    u_char *const vec = new u_char[sz];

    {
	u_char *ds = vec;
	u_char rtmp;
	IA_DIVIter<u_char>	riter(rhs);
	for (unsigned i=0; i<sz; i++) {
	    riter(rtmp);
	    *(ds++) = ( (lhs) - (rtmp) );
	}
    }
    return IA_UcharDiscreteImage(domain, vec, sz, 1);
}
#endif // scalar_iter_u_char_u_char_u_char_operatorIAOPmn

static IA_UcharDiscreteImage
iter_vec_bo_operatorIAOPmn(IA_UcharDiscreteImage lhs,const IA_VectorDI<u_char> *rhs)
{
    const IA_IntPointSet domain = lhs.domain();
    const unsigned sz = domain.card();
    u_char *const vec = new u_char[sz];

    {
	u_char *ds = vec;
	u_char ltmp;
	IA_DIVIter<u_char>	liter(lhs);
	const u_char *rs = rhs->vec;
	for (unsigned i=0; i<sz; i++) {
	    liter(ltmp);
	    *(ds++) = ( (ltmp) - (*(rs++)) );
	}
    }
    return IA_UcharDiscreteImage(domain, vec, sz, 1);
}

#ifndef iter_scalar_u_char_u_char_u_char_operatorIAOPmn
#define iter_scalar_u_char_u_char_u_char_operatorIAOPmn
static IA_UcharDiscreteImage
iter_scalar_bo_operatorIAOPmn(IA_UcharDiscreteImage lhs,u_char rhs)
{
    const IA_IntPointSet domain = lhs.domain();
    const unsigned sz = domain.card();
    u_char *const vec = new u_char[sz];

    {
	u_char *ds = vec;
	u_char ltmp;
	IA_DIVIter<u_char>	liter(lhs);
	for (unsigned i=0; i<sz; i++) {
	    liter(ltmp);
	    *(ds++) = ( (ltmp) - (rhs) );
	}
    }
    return IA_UcharDiscreteImage(domain, vec, sz, 1);
}
#endif // iter_scalar_u_char_u_char_u_char_operatorIAOPmn

static IA_UcharDiscreteImage
iter_iter_bo_operatorIAOPmn(IA_UcharDiscreteImage lhs,IA_UcharDiscreteImage rhs)
{
    const IA_IntPointSet domain = lhs.domain();
    const unsigned sz = domain.card();
    u_char *const vec = new u_char[sz];

    {
	u_char *ds = vec;
	u_char ltmp;
	IA_DIVIter<u_char>	liter(lhs);
	u_char rtmp;
	IA_DIVIter<u_char>	riter(rhs);
	for (unsigned i=0; i<sz; i++) {
	    liter(ltmp);
	    riter(rtmp);
	    *(ds++) = ( (ltmp) - (rtmp) );
	}
    }
    return IA_UcharDiscreteImage(domain, vec, sz, 1);
}

IA_UcharDiscreteImage
operator- ( const IA_UcharDiscreteImage &lhs,
	      const IA_UcharDiscreteImage &rhs)
{
    if (lhs.domain() != rhs.domain()) {
	static IA_UcharDiscreteImage	rval;
	ia_throw( IA::PSET_MISMATCH, __FILE__,__LINE__);
	return rval;
    }

    if (lhs.type() == IA_VectorDI<u_char>::s_type()) {
	if (rhs.type() == IA_VectorDI<u_char>::s_type()) {
	    return vec_vec_bo_operatorIAOPmn((IA_VectorDI<u_char> *)lhs.bdip,(IA_VectorDI<u_char> *)rhs.bdip);
	} else if (rhs.type() == IA_ConstDI<u_char>::s_type()) {
	    return vec_scalar_bo_operatorIAOPmn((IA_VectorDI<u_char> *)lhs.bdip,((IA_ConstDI<u_char> *)rhs.bdip)->value);
	} else {
	    return vec_iter_bo_operatorIAOPmn((IA_VectorDI<u_char> *)lhs.bdip,rhs);
	}
    } else if (lhs.type() == IA_ConstDI<u_char>::s_type()) {
	if (rhs.type() == IA_VectorDI<u_char>::s_type()) {
	    return scalar_vec_bo_operatorIAOPmn(((IA_ConstDI<u_char> *)lhs.bdip)->value,(IA_VectorDI<u_char> *)rhs.bdip);
	} else if (rhs.type() == IA_ConstDI<u_char>::s_type()) {
	    return IA_UcharDiscreteImage (lhs.domain(), (((IA_ConstDI<u_char> *)lhs.bdip)->value) - (((IA_ConstDI<u_char> *)rhs.bdip)->value));
	} else {
	    return scalar_iter_bo_operatorIAOPmn(((IA_ConstDI<u_char> *)lhs.bdip)->value,rhs);
	}
    } else {
	if (rhs.type() == IA_VectorDI<u_char>::s_type()) {
	    return iter_vec_bo_operatorIAOPmn(lhs,(IA_VectorDI<u_char> *)rhs.bdip);
	} else if (rhs.type() == IA_ConstDI<u_char>::s_type()) {
	    return iter_scalar_bo_operatorIAOPmn(lhs,((IA_ConstDI<u_char> *)rhs.bdip)->value);
	} else {
	    return iter_iter_bo_operatorIAOPmn(lhs,rhs);
	}
    }
}

//////////////////////////////////////////////////////////////////////
//
// Begin operation support routines for :
// binary pointwise non-commutative operator- I(u_char) int I(u_char)
//
#ifndef vec_scalar_u_char_u_char_int_operatorIAOPmn
#define vec_scalar_u_char_u_char_int_operatorIAOPmn
static IA_UcharDiscreteImage
vec_scalar_bo_operatorIAOPmn(const IA_VectorDI<u_char> *lhs,int rhs)
{
    const IA_IntPointSet domain = lhs->domain();
    const unsigned sz = domain.card();
    u_char *const vec = new u_char[sz];

    {
	u_char *ds = vec;
	const u_char *ls = lhs->vec;
	for (unsigned i=0; i<sz; i++) {
	    *(ds++) = ( (*(ls++)) - (rhs) );
	}
    }
    return IA_UcharDiscreteImage(domain, vec, sz, 1);
}
#endif // vec_scalar_u_char_u_char_int_operatorIAOPmn

// scalar-scalar operation is trivial

#ifndef iter_scalar_u_char_u_char_int_operatorIAOPmn
#define iter_scalar_u_char_u_char_int_operatorIAOPmn
static IA_UcharDiscreteImage
iter_scalar_bo_operatorIAOPmn(IA_UcharDiscreteImage lhs,int rhs)
{
    const IA_IntPointSet domain = lhs.domain();
    const unsigned sz = domain.card();
    u_char *const vec = new u_char[sz];

    {
	u_char *ds = vec;
	u_char ltmp;
	IA_DIVIter<u_char>	liter(lhs);
	for (unsigned i=0; i<sz; i++) {
	    liter(ltmp);
	    *(ds++) = ( (ltmp) - (rhs) );
	}
    }
    return IA_UcharDiscreteImage(domain, vec, sz, 1);
}
#endif // iter_scalar_u_char_u_char_int_operatorIAOPmn

IA_UcharDiscreteImage
operator- ( const IA_UcharDiscreteImage &lhs, int rhs)
{
    if (lhs.type() == IA_VectorDI<u_char>::s_type()) {
	return vec_scalar_bo_operatorIAOPmn((IA_VectorDI<u_char> *)lhs.bdip,rhs);
    } else if (lhs.type() == IA_ConstDI<u_char>::s_type()) {
	return IA_UcharDiscreteImage (lhs.domain(), (((IA_ConstDI<u_char> *)lhs.bdip)->value) - (rhs));
    } else {
	return iter_scalar_bo_operatorIAOPmn(lhs,rhs);
    }
}

//////////////////////////////////////////////////////////////////////
//
// Begin operation support routines for :
// binary pointwise non-commutative operator- int I(u_char) I(u_char)
//
#ifndef scalar_vec_u_char_int_u_char_operatorIAOPmn
#define scalar_vec_u_char_int_u_char_operatorIAOPmn
static IA_UcharDiscreteImage
scalar_vec_bo_operatorIAOPmn(int lhs,const IA_VectorDI<u_char> *rhs)
{
    const IA_IntPointSet domain = rhs->domain();
    const unsigned sz = domain.card();
    u_char *const vec = new u_char[sz];

    {
	u_char *ds = vec;
	const u_char *rs = rhs->vec;
	for (unsigned i=0; i<sz; i++) {
	    *(ds++) = ( (lhs) - (*(rs++)) );
	}
    }
    return IA_UcharDiscreteImage(domain, vec, sz, 1);
}
#endif // scalar_vec_u_char_int_u_char_operatorIAOPmn

// scalar-scalar operation is trivial

#ifndef scalar_iter_u_char_int_u_char_operatorIAOPmn
#define scalar_iter_u_char_int_u_char_operatorIAOPmn
static IA_UcharDiscreteImage
scalar_iter_bo_operatorIAOPmn(int lhs,IA_UcharDiscreteImage rhs)
{
    const IA_IntPointSet domain = rhs.domain();
    const unsigned sz = domain.card();
    u_char *const vec = new u_char[sz];

    {
	u_char *ds = vec;
	u_char rtmp;
	IA_DIVIter<u_char>	riter(rhs);
	for (unsigned i=0; i<sz; i++) {
	    riter(rtmp);
	    *(ds++) = ( (lhs) - (rtmp) );
	}
    }
    return IA_UcharDiscreteImage(domain, vec, sz, 1);
}
#endif // scalar_iter_u_char_int_u_char_operatorIAOPmn

IA_UcharDiscreteImage
operator- (int lhs, const IA_UcharDiscreteImage &rhs)
{
    if (rhs.type() == IA_VectorDI<u_char>::s_type()) {
	return scalar_vec_bo_operatorIAOPmn(lhs,(IA_VectorDI<u_char> *)rhs.bdip);
    } else if (rhs.type() == IA_ConstDI<u_char>::s_type()) {
	return IA_UcharDiscreteImage (rhs.domain(), (lhs) - (((IA_ConstDI<u_char> *)rhs.bdip)->value));
    } else {
	return scalar_iter_bo_operatorIAOPmn(lhs,rhs);
    }
}

//////////////////////////////////////////////////////////////////////
//
// Begin operation support routines for :
// unary pointwise operator- I(u_char) I(u_char)
//
// Emacs: -*- C++ -*-

//
//	Copyright 1993, Center for Computer Vision and Visualization,
//	University of Florida.  All rights reserved.
//


//
// $Log:	unary-op.templ,v $
// Revision 1.2  93/05/27  11:49:04  thoth
// Copyright Notices
// 
// Revision 1.1  93/03/10  13:50:00  thoth
// Initial revision
// 

#ifndef vec_scalar_u_char_u_char_operatorIAOPmn
#define vec_scalar_u_char_u_char_operatorIAOPmn
static IA_UcharDiscreteImage
vec_uo_operatorIAOPmn(const IA_VectorDI<u_char> *lhs)
{
    const IA_IntPointSet domain = lhs->domain();
    const unsigned sz = domain.card();
    u_char *const vec = new u_char[sz];

    {
	u_char *ds = vec;
	const u_char *ls = lhs->vec;
	for (unsigned i=0; i<sz; i++) {
	    *(ds++) = -(*(ls++));
	}
    }
    return IA_UcharDiscreteImage(domain, vec, sz, 1);
}
#endif // vec_scalar_u_char_u_char_operatorIAOPmn

// scalar-scalar operation is trivial

#ifndef iter_scalar_u_char_u_char_operatorIAOPmn
#define iter_scalar_u_char_u_char_operatorIAOPmn
static IA_UcharDiscreteImage
iter_uo_operatorIAOPmn(IA_UcharDiscreteImage lhs)
{
    const IA_IntPointSet domain = lhs.domain();
    const unsigned sz = domain.card();
    u_char *const vec = new u_char[sz];

    {
	u_char *ds = vec;
	u_char ltmp;
	IA_DIVIter<u_char>	liter(lhs);
	for (unsigned i=0; i<sz; i++) {
	    liter(ltmp);
	    *(ds++) = -(ltmp);
	}
    }
    return IA_UcharDiscreteImage(domain, vec, sz, 1);
}
#endif // iter_scalar_u_char_u_char_operatorIAOPmn

IA_UcharDiscreteImage
operator- ( const IA_UcharDiscreteImage &arg)
{
    if (arg.type() == IA_VectorDI<u_char>::s_type()) {
	return vec_uo_operatorIAOPmn((IA_VectorDI<u_char> *)arg.bdip);
    } else if (arg.type() == IA_ConstDI<u_char>::s_type()) {
	return IA_UcharDiscreteImage (arg.domain(), -(((IA_ConstDI<u_char> *)arg.bdip)->value));
    } else {
	return iter_uo_operatorIAOPmn(arg);
    }
}

//////////////////////////////////////////////////////////////////////
//
// Begin operation support routines for :
// pointwise operator-= I(u_char) I(u_char)
//
// There are none (it's inline)

//////////////////////////////////////////////////////////////////////
//
// Begin operation support routines for :
// pointwise operator-= I(u_char) int
//
// There are none (it's inline)

//////////////////////////////////////////////////////////////////////
//
// Begin operation support routines for :
// binary pointwise commutative operator* I(u_char) I(u_char) I(u_char)
//
static IA_UcharDiscreteImage
vec_vec_bo_operatorIAOPmu(const IA_VectorDI<u_char> *lhs,const IA_VectorDI<u_char> *rhs)
{
    const IA_IntPointSet domain = lhs->domain();
    const unsigned sz = domain.card();
    u_char *const vec = new u_char[sz];

    {
	u_char *ds = vec;
	const u_char *ls = lhs->vec;
	const u_char *rs = rhs->vec;
	for (unsigned i=0; i<sz; i++) {
	    *(ds++) = ( (*(ls++)) * (*(rs++)) );
	}
    }
    return IA_UcharDiscreteImage(domain, vec, sz, 1);
}

#ifndef vec_scalar_u_char_u_char_u_char_operatorIAOPmu
#define vec_scalar_u_char_u_char_u_char_operatorIAOPmu
static IA_UcharDiscreteImage
vec_scalar_bo_operatorIAOPmu(const IA_VectorDI<u_char> *lhs,u_char rhs)
{
    const IA_IntPointSet domain = lhs->domain();
    const unsigned sz = domain.card();
    u_char *const vec = new u_char[sz];

    {
	u_char *ds = vec;
	const u_char *ls = lhs->vec;
	for (unsigned i=0; i<sz; i++) {
	    *(ds++) = ( (*(ls++)) * (rhs) );
	}
    }
    return IA_UcharDiscreteImage(domain, vec, sz, 1);
}
#endif // vec_scalar_u_char_u_char_u_char_operatorIAOPmu

static IA_UcharDiscreteImage
vec_iter_bo_operatorIAOPmu(const IA_VectorDI<u_char> *lhs,IA_UcharDiscreteImage rhs)
{
    const IA_IntPointSet domain = lhs->domain();
    const unsigned sz = domain.card();
    u_char *const vec = new u_char[sz];

    {
	u_char *ds = vec;
	const u_char *ls = lhs->vec;
	u_char rtmp;
	IA_DIVIter<u_char>	riter(rhs);
	for (unsigned i=0; i<sz; i++) {
	    riter(rtmp);
	    *(ds++) = ( (*(ls++)) * (rtmp) );
	}
    }
    return IA_UcharDiscreteImage(domain, vec, sz, 1);
}

// scalar-scalar operation is trivial

#ifndef scalar_iter_u_char_u_char_u_char_operatorIAOPmu
#define scalar_iter_u_char_u_char_u_char_operatorIAOPmu
static IA_UcharDiscreteImage
scalar_iter_bo_operatorIAOPmu(u_char lhs,IA_UcharDiscreteImage rhs)
{
    const IA_IntPointSet domain = rhs.domain();
    const unsigned sz = domain.card();
    u_char *const vec = new u_char[sz];

    {
	u_char *ds = vec;
	u_char rtmp;
	IA_DIVIter<u_char>	riter(rhs);
	for (unsigned i=0; i<sz; i++) {
	    riter(rtmp);
	    *(ds++) = ( (lhs) * (rtmp) );
	}
    }
    return IA_UcharDiscreteImage(domain, vec, sz, 1);
}
#endif // scalar_iter_u_char_u_char_u_char_operatorIAOPmu

static IA_UcharDiscreteImage
iter_iter_bo_operatorIAOPmu(IA_UcharDiscreteImage lhs,IA_UcharDiscreteImage rhs)
{
    const IA_IntPointSet domain = lhs.domain();
    const unsigned sz = domain.card();
    u_char *const vec = new u_char[sz];

    {
	u_char *ds = vec;
	u_char ltmp;
	IA_DIVIter<u_char>	liter(lhs);
	u_char rtmp;
	IA_DIVIter<u_char>	riter(rhs);
	for (unsigned i=0; i<sz; i++) {
	    liter(ltmp);
	    riter(rtmp);
	    *(ds++) = ( (ltmp) * (rtmp) );
	}
    }
    return IA_UcharDiscreteImage(domain, vec, sz, 1);
}

IA_UcharDiscreteImage
operator* ( const IA_UcharDiscreteImage &lhs,
	      const IA_UcharDiscreteImage &rhs)
{
    if (lhs.domain() != rhs.domain()) {
	static IA_UcharDiscreteImage	rval;
	ia_throw( IA::PSET_MISMATCH, __FILE__,__LINE__);
	return rval;
    }

    if (lhs.type() == IA_VectorDI<u_char>::s_type()) {
	if (rhs.type() == IA_VectorDI<u_char>::s_type()) {
	    return vec_vec_bo_operatorIAOPmu((IA_VectorDI<u_char> *)lhs.bdip,(IA_VectorDI<u_char> *)rhs.bdip);
	} else if (rhs.type() == IA_ConstDI<u_char>::s_type()) {
	    return vec_scalar_bo_operatorIAOPmu((IA_VectorDI<u_char> *)lhs.bdip,((IA_ConstDI<u_char> *)rhs.bdip)->value);
	} else {
	    return vec_iter_bo_operatorIAOPmu((IA_VectorDI<u_char> *)lhs.bdip,rhs);
	}
    } else if (lhs.type() == IA_ConstDI<u_char>::s_type()) {
	if (rhs.type() == IA_VectorDI<u_char>::s_type()) {
	    return vec_scalar_bo_operatorIAOPmu((IA_VectorDI<u_char> *)rhs.bdip,((IA_ConstDI<u_char> *)lhs.bdip)->value);
	} else if (rhs.type() == IA_ConstDI<u_char>::s_type()) {
	    return IA_UcharDiscreteImage (lhs.domain(), (((IA_ConstDI<u_char> *)lhs.bdip)->value) * (((IA_ConstDI<u_char> *)rhs.bdip)->value));
	} else {
	    return scalar_iter_bo_operatorIAOPmu(((IA_ConstDI<u_char> *)lhs.bdip)->value,rhs);
	}
    } else {
	if (rhs.type() == IA_VectorDI<u_char>::s_type()) {
	    return vec_iter_bo_operatorIAOPmu((IA_VectorDI<u_char> *)rhs.bdip,lhs);
	} else if (rhs.type() == IA_ConstDI<u_char>::s_type()) {
	    return scalar_iter_bo_operatorIAOPmu(((IA_ConstDI<u_char> *)rhs.bdip)->value,lhs);
	} else {
	    return iter_iter_bo_operatorIAOPmu(lhs,rhs);
	}
    }
}

//////////////////////////////////////////////////////////////////////
//
// Begin operation support routines for :
// binary pointwise commutative operator* I(u_char) int I(u_char)
//
#ifndef vec_scalar_u_char_u_char_int_operatorIAOPmu
#define vec_scalar_u_char_u_char_int_operatorIAOPmu
static IA_UcharDiscreteImage
vec_scalar_bo_operatorIAOPmu(const IA_VectorDI<u_char> *lhs,int rhs)
{
    const IA_IntPointSet domain = lhs->domain();
    const unsigned sz = domain.card();
    u_char *const vec = new u_char[sz];

    {
	u_char *ds = vec;
	const u_char *ls = lhs->vec;
	for (unsigned i=0; i<sz; i++) {
	    *(ds++) = ( (*(ls++)) * (rhs) );
	}
    }
    return IA_UcharDiscreteImage(domain, vec, sz, 1);
}
#endif // vec_scalar_u_char_u_char_int_operatorIAOPmu

// scalar-scalar operation is trivial

#ifndef iter_scalar_u_char_u_char_int_operatorIAOPmu
#define iter_scalar_u_char_u_char_int_operatorIAOPmu
static IA_UcharDiscreteImage
iter_scalar_bo_operatorIAOPmu(IA_UcharDiscreteImage lhs,int rhs)
{
    const IA_IntPointSet domain = lhs.domain();
    const unsigned sz = domain.card();
    u_char *const vec = new u_char[sz];

    {
	u_char *ds = vec;
	u_char ltmp;
	IA_DIVIter<u_char>	liter(lhs);
	for (unsigned i=0; i<sz; i++) {
	    liter(ltmp);
	    *(ds++) = ( (ltmp) * (rhs) );
	}
    }
    return IA_UcharDiscreteImage(domain, vec, sz, 1);
}
#endif // iter_scalar_u_char_u_char_int_operatorIAOPmu

IA_UcharDiscreteImage
operator* ( const IA_UcharDiscreteImage &lhs, int rhs)
{
    if (lhs.type() == IA_VectorDI<u_char>::s_type()) {
	return vec_scalar_bo_operatorIAOPmu((IA_VectorDI<u_char> *)lhs.bdip,rhs);
    } else if (lhs.type() == IA_ConstDI<u_char>::s_type()) {
	return IA_UcharDiscreteImage (lhs.domain(), (((IA_ConstDI<u_char> *)lhs.bdip)->value) * (rhs));
    } else {
	return iter_scalar_bo_operatorIAOPmu(lhs,rhs);
    }
}

//////////////////////////////////////////////////////////////////////
//
// Begin operation support routines for :
// pointwise operator*= I(u_char) I(u_char)
//
// There are none (it's inline)

//////////////////////////////////////////////////////////////////////
//
// Begin operation support routines for :
// pointwise operator*= I(u_char) int
//
// There are none (it's inline)

//////////////////////////////////////////////////////////////////////
//
// Begin operation support routines for :
// binary pointwise non-commutative operator/ I(u_char) I(u_char) I(u_char)
//
static IA_UcharDiscreteImage
vec_vec_bo_operatorIAOPdv(const IA_VectorDI<u_char> *lhs,const IA_VectorDI<u_char> *rhs)
{
    const IA_IntPointSet domain = lhs->domain();
    const unsigned sz = domain.card();
    u_char *const vec = new u_char[sz];

    {
	u_char *ds = vec;
	const u_char *ls = lhs->vec;
	const u_char *rs = rhs->vec;
	for (unsigned i=0; i<sz; i++) {
	    *(ds++) = ( (*(ls++)) / (*(rs++)) );
	}
    }
    return IA_UcharDiscreteImage(domain, vec, sz, 1);
}

#ifndef vec_scalar_u_char_u_char_u_char_operatorIAOPdv
#define vec_scalar_u_char_u_char_u_char_operatorIAOPdv
static IA_UcharDiscreteImage
vec_scalar_bo_operatorIAOPdv(const IA_VectorDI<u_char> *lhs,u_char rhs)
{
    const IA_IntPointSet domain = lhs->domain();
    const unsigned sz = domain.card();
    u_char *const vec = new u_char[sz];

    {
	u_char *ds = vec;
	const u_char *ls = lhs->vec;
	for (unsigned i=0; i<sz; i++) {
	    *(ds++) = ( (*(ls++)) / (rhs) );
	}
    }
    return IA_UcharDiscreteImage(domain, vec, sz, 1);
}
#endif // vec_scalar_u_char_u_char_u_char_operatorIAOPdv

static IA_UcharDiscreteImage
vec_iter_bo_operatorIAOPdv(const IA_VectorDI<u_char> *lhs,IA_UcharDiscreteImage rhs)
{
    const IA_IntPointSet domain = lhs->domain();
    const unsigned sz = domain.card();
    u_char *const vec = new u_char[sz];

    {
	u_char *ds = vec;
	const u_char *ls = lhs->vec;
	u_char rtmp;
	IA_DIVIter<u_char>	riter(rhs);
	for (unsigned i=0; i<sz; i++) {
	    riter(rtmp);
	    *(ds++) = ( (*(ls++)) / (rtmp) );
	}
    }
    return IA_UcharDiscreteImage(domain, vec, sz, 1);
}

#ifndef scalar_vec_u_char_u_char_u_char_operatorIAOPdv
#define scalar_vec_u_char_u_char_u_char_operatorIAOPdv
static IA_UcharDiscreteImage
scalar_vec_bo_operatorIAOPdv(u_char lhs,const IA_VectorDI<u_char> *rhs)
{
    const IA_IntPointSet domain = rhs->domain();
    const unsigned sz = domain.card();
    u_char *const vec = new u_char[sz];

    {
	u_char *ds = vec;
	const u_char *rs = rhs->vec;
	for (unsigned i=0; i<sz; i++) {
	    *(ds++) = ( (lhs) / (*(rs++)) );
	}
    }
    return IA_UcharDiscreteImage(domain, vec, sz, 1);
}
#endif // scalar_vec_u_char_u_char_u_char_operatorIAOPdv

// scalar-scalar operation is trivial

#ifndef scalar_iter_u_char_u_char_u_char_operatorIAOPdv
#define scalar_iter_u_char_u_char_u_char_operatorIAOPdv
static IA_UcharDiscreteImage
scalar_iter_bo_operatorIAOPdv(u_char lhs,IA_UcharDiscreteImage rhs)
{
    const IA_IntPointSet domain = rhs.domain();
    const unsigned sz = domain.card();
    u_char *const vec = new u_char[sz];

    {
	u_char *ds = vec;
	u_char rtmp;
	IA_DIVIter<u_char>	riter(rhs);
	for (unsigned i=0; i<sz; i++) {
	    riter(rtmp);
	    *(ds++) = ( (lhs) / (rtmp) );
	}
    }
    return IA_UcharDiscreteImage(domain, vec, sz, 1);
}
#endif // scalar_iter_u_char_u_char_u_char_operatorIAOPdv

static IA_UcharDiscreteImage
iter_vec_bo_operatorIAOPdv(IA_UcharDiscreteImage lhs,const IA_VectorDI<u_char> *rhs)
{
    const IA_IntPointSet domain = lhs.domain();
    const unsigned sz = domain.card();
    u_char *const vec = new u_char[sz];

    {
	u_char *ds = vec;
	u_char ltmp;
	IA_DIVIter<u_char>	liter(lhs);
	const u_char *rs = rhs->vec;
	for (unsigned i=0; i<sz; i++) {
	    liter(ltmp);
	    *(ds++) = ( (ltmp) / (*(rs++)) );
	}
    }
    return IA_UcharDiscreteImage(domain, vec, sz, 1);
}

#ifndef iter_scalar_u_char_u_char_u_char_operatorIAOPdv
#define iter_scalar_u_char_u_char_u_char_operatorIAOPdv
static IA_UcharDiscreteImage
iter_scalar_bo_operatorIAOPdv(IA_UcharDiscreteImage lhs,u_char rhs)
{
    const IA_IntPointSet domain = lhs.domain();
    const unsigned sz = domain.card();
    u_char *const vec = new u_char[sz];

    {
	u_char *ds = vec;
	u_char ltmp;
	IA_DIVIter<u_char>	liter(lhs);
	for (unsigned i=0; i<sz; i++) {
	    liter(ltmp);
	    *(ds++) = ( (ltmp) / (rhs) );
	}
    }
    return IA_UcharDiscreteImage(domain, vec, sz, 1);
}
#endif // iter_scalar_u_char_u_char_u_char_operatorIAOPdv

static IA_UcharDiscreteImage
iter_iter_bo_operatorIAOPdv(IA_UcharDiscreteImage lhs,IA_UcharDiscreteImage rhs)
{
    const IA_IntPointSet domain = lhs.domain();
    const unsigned sz = domain.card();
    u_char *const vec = new u_char[sz];

    {
	u_char *ds = vec;
	u_char ltmp;
	IA_DIVIter<u_char>	liter(lhs);
	u_char rtmp;
	IA_DIVIter<u_char>	riter(rhs);
	for (unsigned i=0; i<sz; i++) {
	    liter(ltmp);
	    riter(rtmp);
	    *(ds++) = ( (ltmp) / (rtmp) );
	}
    }
    return IA_UcharDiscreteImage(domain, vec, sz, 1);
}

IA_UcharDiscreteImage
operator/ ( const IA_UcharDiscreteImage &lhs,
	      const IA_UcharDiscreteImage &rhs)
{
    if (lhs.domain() != rhs.domain()) {
	static IA_UcharDiscreteImage	rval;
	ia_throw( IA::PSET_MISMATCH, __FILE__,__LINE__);
	return rval;
    }

    if (lhs.type() == IA_VectorDI<u_char>::s_type()) {
	if (rhs.type() == IA_VectorDI<u_char>::s_type()) {
	    return vec_vec_bo_operatorIAOPdv((IA_VectorDI<u_char> *)lhs.bdip,(IA_VectorDI<u_char> *)rhs.bdip);
	} else if (rhs.type() == IA_ConstDI<u_char>::s_type()) {
	    return vec_scalar_bo_operatorIAOPdv((IA_VectorDI<u_char> *)lhs.bdip,((IA_ConstDI<u_char> *)rhs.bdip)->value);
	} else {
	    return vec_iter_bo_operatorIAOPdv((IA_VectorDI<u_char> *)lhs.bdip,rhs);
	}
    } else if (lhs.type() == IA_ConstDI<u_char>::s_type()) {
	if (rhs.type() == IA_VectorDI<u_char>::s_type()) {
	    return scalar_vec_bo_operatorIAOPdv(((IA_ConstDI<u_char> *)lhs.bdip)->value,(IA_VectorDI<u_char> *)rhs.bdip);
	} else if (rhs.type() == IA_ConstDI<u_char>::s_type()) {
	    return IA_UcharDiscreteImage (lhs.domain(), (((IA_ConstDI<u_char> *)lhs.bdip)->value) / (((IA_ConstDI<u_char> *)rhs.bdip)->value));
	} else {
	    return scalar_iter_bo_operatorIAOPdv(((IA_ConstDI<u_char> *)lhs.bdip)->value,rhs);
	}
    } else {
	if (rhs.type() == IA_VectorDI<u_char>::s_type()) {
	    return iter_vec_bo_operatorIAOPdv(lhs,(IA_VectorDI<u_char> *)rhs.bdip);
	} else if (rhs.type() == IA_ConstDI<u_char>::s_type()) {
	    return iter_scalar_bo_operatorIAOPdv(lhs,((IA_ConstDI<u_char> *)rhs.bdip)->value);
	} else {
	    return iter_iter_bo_operatorIAOPdv(lhs,rhs);
	}
    }
}

//////////////////////////////////////////////////////////////////////
//
// Begin operation support routines for :
// binary pointwise non-commutative operator/ I(u_char) int I(u_char)
//
#ifndef vec_scalar_u_char_u_char_int_operatorIAOPdv
#define vec_scalar_u_char_u_char_int_operatorIAOPdv
static IA_UcharDiscreteImage
vec_scalar_bo_operatorIAOPdv(const IA_VectorDI<u_char> *lhs,int rhs)
{
    const IA_IntPointSet domain = lhs->domain();
    const unsigned sz = domain.card();
    u_char *const vec = new u_char[sz];

    {
	u_char *ds = vec;
	const u_char *ls = lhs->vec;
	for (unsigned i=0; i<sz; i++) {
	    *(ds++) = ( (*(ls++)) / (rhs) );
	}
    }
    return IA_UcharDiscreteImage(domain, vec, sz, 1);
}
#endif // vec_scalar_u_char_u_char_int_operatorIAOPdv

// scalar-scalar operation is trivial

#ifndef iter_scalar_u_char_u_char_int_operatorIAOPdv
#define iter_scalar_u_char_u_char_int_operatorIAOPdv
static IA_UcharDiscreteImage
iter_scalar_bo_operatorIAOPdv(IA_UcharDiscreteImage lhs,int rhs)
{
    const IA_IntPointSet domain = lhs.domain();
    const unsigned sz = domain.card();
    u_char *const vec = new u_char[sz];

    {
	u_char *ds = vec;
	u_char ltmp;
	IA_DIVIter<u_char>	liter(lhs);
	for (unsigned i=0; i<sz; i++) {
	    liter(ltmp);
	    *(ds++) = ( (ltmp) / (rhs) );
	}
    }
    return IA_UcharDiscreteImage(domain, vec, sz, 1);
}
#endif // iter_scalar_u_char_u_char_int_operatorIAOPdv

IA_UcharDiscreteImage
operator/ ( const IA_UcharDiscreteImage &lhs, int rhs)
{
    if (lhs.type() == IA_VectorDI<u_char>::s_type()) {
	return vec_scalar_bo_operatorIAOPdv((IA_VectorDI<u_char> *)lhs.bdip,rhs);
    } else if (lhs.type() == IA_ConstDI<u_char>::s_type()) {
	return IA_UcharDiscreteImage (lhs.domain(), (((IA_ConstDI<u_char> *)lhs.bdip)->value) / (rhs));
    } else {
	return iter_scalar_bo_operatorIAOPdv(lhs,rhs);
    }
}

//////////////////////////////////////////////////////////////////////
//
// Begin operation support routines for :
// binary pointwise non-commutative operator/ int I(u_char) I(u_char)
//
#ifndef scalar_vec_u_char_int_u_char_operatorIAOPdv
#define scalar_vec_u_char_int_u_char_operatorIAOPdv
static IA_UcharDiscreteImage
scalar_vec_bo_operatorIAOPdv(int lhs,const IA_VectorDI<u_char> *rhs)
{
    const IA_IntPointSet domain = rhs->domain();
    const unsigned sz = domain.card();
    u_char *const vec = new u_char[sz];

    {
	u_char *ds = vec;
	const u_char *rs = rhs->vec;
	for (unsigned i=0; i<sz; i++) {
	    *(ds++) = ( (lhs) / (*(rs++)) );
	}
    }
    return IA_UcharDiscreteImage(domain, vec, sz, 1);
}
#endif // scalar_vec_u_char_int_u_char_operatorIAOPdv

// scalar-scalar operation is trivial

#ifndef scalar_iter_u_char_int_u_char_operatorIAOPdv
#define scalar_iter_u_char_int_u_char_operatorIAOPdv
static IA_UcharDiscreteImage
scalar_iter_bo_operatorIAOPdv(int lhs,IA_UcharDiscreteImage rhs)
{
    const IA_IntPointSet domain = rhs.domain();
    const unsigned sz = domain.card();
    u_char *const vec = new u_char[sz];

    {
	u_char *ds = vec;
	u_char rtmp;
	IA_DIVIter<u_char>	riter(rhs);
	for (unsigned i=0; i<sz; i++) {
	    riter(rtmp);
	    *(ds++) = ( (lhs) / (rtmp) );
	}
    }
    return IA_UcharDiscreteImage(domain, vec, sz, 1);
}
#endif // scalar_iter_u_char_int_u_char_operatorIAOPdv

IA_UcharDiscreteImage
operator/ (int lhs, const IA_UcharDiscreteImage &rhs)
{
    if (rhs.type() == IA_VectorDI<u_char>::s_type()) {
	return scalar_vec_bo_operatorIAOPdv(lhs,(IA_VectorDI<u_char> *)rhs.bdip);
    } else if (rhs.type() == IA_ConstDI<u_char>::s_type()) {
	return IA_UcharDiscreteImage (rhs.domain(), (lhs) / (((IA_ConstDI<u_char> *)rhs.bdip)->value));
    } else {
	return scalar_iter_bo_operatorIAOPdv(lhs,rhs);
    }
}

//////////////////////////////////////////////////////////////////////
//
// Begin operation support routines for :
// pointwise operator/= I(u_char) I(u_char)
//
// There are none (it's inline)

//////////////////////////////////////////////////////////////////////
//
// Begin operation support routines for :
// pointwise operator/= I(u_char) int
//
// There are none (it's inline)

//////////////////////////////////////////////////////////////////////
//
// Begin operation support routines for :
// binary pointwise non-commutative operator% I(u_char) I(u_char) I(u_char)
//
static IA_UcharDiscreteImage
vec_vec_bo_operatorIAOPmd(const IA_VectorDI<u_char> *lhs,const IA_VectorDI<u_char> *rhs)
{
    const IA_IntPointSet domain = lhs->domain();
    const unsigned sz = domain.card();
    u_char *const vec = new u_char[sz];

    {
	u_char *ds = vec;
	const u_char *ls = lhs->vec;
	const u_char *rs = rhs->vec;
	for (unsigned i=0; i<sz; i++) {
	    *(ds++) = ( (*(ls++)) % (*(rs++)) );
	}
    }
    return IA_UcharDiscreteImage(domain, vec, sz, 1);
}

#ifndef vec_scalar_u_char_u_char_u_char_operatorIAOPmd
#define vec_scalar_u_char_u_char_u_char_operatorIAOPmd
static IA_UcharDiscreteImage
vec_scalar_bo_operatorIAOPmd(const IA_VectorDI<u_char> *lhs,u_char rhs)
{
    const IA_IntPointSet domain = lhs->domain();
    const unsigned sz = domain.card();
    u_char *const vec = new u_char[sz];

    {
	u_char *ds = vec;
	const u_char *ls = lhs->vec;
	for (unsigned i=0; i<sz; i++) {
	    *(ds++) = ( (*(ls++)) % (rhs) );
	}
    }
    return IA_UcharDiscreteImage(domain, vec, sz, 1);
}
#endif // vec_scalar_u_char_u_char_u_char_operatorIAOPmd

static IA_UcharDiscreteImage
vec_iter_bo_operatorIAOPmd(const IA_VectorDI<u_char> *lhs,IA_UcharDiscreteImage rhs)
{
    const IA_IntPointSet domain = lhs->domain();
    const unsigned sz = domain.card();
    u_char *const vec = new u_char[sz];

    {
	u_char *ds = vec;
	const u_char *ls = lhs->vec;
	u_char rtmp;
	IA_DIVIter<u_char>	riter(rhs);
	for (unsigned i=0; i<sz; i++) {
	    riter(rtmp);
	    *(ds++) = ( (*(ls++)) % (rtmp) );
	}
    }
    return IA_UcharDiscreteImage(domain, vec, sz, 1);
}

#ifndef scalar_vec_u_char_u_char_u_char_operatorIAOPmd
#define scalar_vec_u_char_u_char_u_char_operatorIAOPmd
static IA_UcharDiscreteImage
scalar_vec_bo_operatorIAOPmd(u_char lhs,const IA_VectorDI<u_char> *rhs)
{
    const IA_IntPointSet domain = rhs->domain();
    const unsigned sz = domain.card();
    u_char *const vec = new u_char[sz];

    {
	u_char *ds = vec;
	const u_char *rs = rhs->vec;
	for (unsigned i=0; i<sz; i++) {
	    *(ds++) = ( (lhs) % (*(rs++)) );
	}
    }
    return IA_UcharDiscreteImage(domain, vec, sz, 1);
}
#endif // scalar_vec_u_char_u_char_u_char_operatorIAOPmd

// scalar-scalar operation is trivial

#ifndef scalar_iter_u_char_u_char_u_char_operatorIAOPmd
#define scalar_iter_u_char_u_char_u_char_operatorIAOPmd
static IA_UcharDiscreteImage
scalar_iter_bo_operatorIAOPmd(u_char lhs,IA_UcharDiscreteImage rhs)
{
    const IA_IntPointSet domain = rhs.domain();
    const unsigned sz = domain.card();
    u_char *const vec = new u_char[sz];

    {
	u_char *ds = vec;
	u_char rtmp;
	IA_DIVIter<u_char>	riter(rhs);
	for (unsigned i=0; i<sz; i++) {
	    riter(rtmp);
	    *(ds++) = ( (lhs) % (rtmp) );
	}
    }
    return IA_UcharDiscreteImage(domain, vec, sz, 1);
}
#endif // scalar_iter_u_char_u_char_u_char_operatorIAOPmd

static IA_UcharDiscreteImage
iter_vec_bo_operatorIAOPmd(IA_UcharDiscreteImage lhs,const IA_VectorDI<u_char> *rhs)
{
    const IA_IntPointSet domain = lhs.domain();
    const unsigned sz = domain.card();
    u_char *const vec = new u_char[sz];

    {
	u_char *ds = vec;
	u_char ltmp;
	IA_DIVIter<u_char>	liter(lhs);
	const u_char *rs = rhs->vec;
	for (unsigned i=0; i<sz; i++) {
	    liter(ltmp);
	    *(ds++) = ( (ltmp) % (*(rs++)) );
	}
    }
    return IA_UcharDiscreteImage(domain, vec, sz, 1);
}

#ifndef iter_scalar_u_char_u_char_u_char_operatorIAOPmd
#define iter_scalar_u_char_u_char_u_char_operatorIAOPmd
static IA_UcharDiscreteImage
iter_scalar_bo_operatorIAOPmd(IA_UcharDiscreteImage lhs,u_char rhs)
{
    const IA_IntPointSet domain = lhs.domain();
    const unsigned sz = domain.card();
    u_char *const vec = new u_char[sz];

    {
	u_char *ds = vec;
	u_char ltmp;
	IA_DIVIter<u_char>	liter(lhs);
	for (unsigned i=0; i<sz; i++) {
	    liter(ltmp);
	    *(ds++) = ( (ltmp) % (rhs) );
	}
    }
    return IA_UcharDiscreteImage(domain, vec, sz, 1);
}
#endif // iter_scalar_u_char_u_char_u_char_operatorIAOPmd

static IA_UcharDiscreteImage
iter_iter_bo_operatorIAOPmd(IA_UcharDiscreteImage lhs,IA_UcharDiscreteImage rhs)
{
    const IA_IntPointSet domain = lhs.domain();
    const unsigned sz = domain.card();
    u_char *const vec = new u_char[sz];

    {
	u_char *ds = vec;
	u_char ltmp;
	IA_DIVIter<u_char>	liter(lhs);
	u_char rtmp;
	IA_DIVIter<u_char>	riter(rhs);
	for (unsigned i=0; i<sz; i++) {
	    liter(ltmp);
	    riter(rtmp);
	    *(ds++) = ( (ltmp) % (rtmp) );
	}
    }
    return IA_UcharDiscreteImage(domain, vec, sz, 1);
}

IA_UcharDiscreteImage
operator% ( const IA_UcharDiscreteImage &lhs,
	      const IA_UcharDiscreteImage &rhs)
{
    if (lhs.domain() != rhs.domain()) {
	static IA_UcharDiscreteImage	rval;
	ia_throw( IA::PSET_MISMATCH, __FILE__,__LINE__);
	return rval;
    }

    if (lhs.type() == IA_VectorDI<u_char>::s_type()) {
	if (rhs.type() == IA_VectorDI<u_char>::s_type()) {
	    return vec_vec_bo_operatorIAOPmd((IA_VectorDI<u_char> *)lhs.bdip,(IA_VectorDI<u_char> *)rhs.bdip);
	} else if (rhs.type() == IA_ConstDI<u_char>::s_type()) {
	    return vec_scalar_bo_operatorIAOPmd((IA_VectorDI<u_char> *)lhs.bdip,((IA_ConstDI<u_char> *)rhs.bdip)->value);
	} else {
	    return vec_iter_bo_operatorIAOPmd((IA_VectorDI<u_char> *)lhs.bdip,rhs);
	}
    } else if (lhs.type() == IA_ConstDI<u_char>::s_type()) {
	if (rhs.type() == IA_VectorDI<u_char>::s_type()) {
	    return scalar_vec_bo_operatorIAOPmd(((IA_ConstDI<u_char> *)lhs.bdip)->value,(IA_VectorDI<u_char> *)rhs.bdip);
	} else if (rhs.type() == IA_ConstDI<u_char>::s_type()) {
	    return IA_UcharDiscreteImage (lhs.domain(), (((IA_ConstDI<u_char> *)lhs.bdip)->value) % (((IA_ConstDI<u_char> *)rhs.bdip)->value));
	} else {
	    return scalar_iter_bo_operatorIAOPmd(((IA_ConstDI<u_char> *)lhs.bdip)->value,rhs);
	}
    } else {
	if (rhs.type() == IA_VectorDI<u_char>::s_type()) {
	    return iter_vec_bo_operatorIAOPmd(lhs,(IA_VectorDI<u_char> *)rhs.bdip);
	} else if (rhs.type() == IA_ConstDI<u_char>::s_type()) {
	    return iter_scalar_bo_operatorIAOPmd(lhs,((IA_ConstDI<u_char> *)rhs.bdip)->value);
	} else {
	    return iter_iter_bo_operatorIAOPmd(lhs,rhs);
	}
    }
}

//////////////////////////////////////////////////////////////////////
//
// Begin operation support routines for :
// binary pointwise non-commutative operator% I(u_char) int I(u_char)
//
#ifndef vec_scalar_u_char_u_char_int_operatorIAOPmd
#define vec_scalar_u_char_u_char_int_operatorIAOPmd
static IA_UcharDiscreteImage
vec_scalar_bo_operatorIAOPmd(const IA_VectorDI<u_char> *lhs,int rhs)
{
    const IA_IntPointSet domain = lhs->domain();
    const unsigned sz = domain.card();
    u_char *const vec = new u_char[sz];

    {
	u_char *ds = vec;
	const u_char *ls = lhs->vec;
	for (unsigned i=0; i<sz; i++) {
	    *(ds++) = ( (*(ls++)) % (rhs) );
	}
    }
    return IA_UcharDiscreteImage(domain, vec, sz, 1);
}
#endif // vec_scalar_u_char_u_char_int_operatorIAOPmd

// scalar-scalar operation is trivial

#ifndef iter_scalar_u_char_u_char_int_operatorIAOPmd
#define iter_scalar_u_char_u_char_int_operatorIAOPmd
static IA_UcharDiscreteImage
iter_scalar_bo_operatorIAOPmd(IA_UcharDiscreteImage lhs,int rhs)
{
    const IA_IntPointSet domain = lhs.domain();
    const unsigned sz = domain.card();
    u_char *const vec = new u_char[sz];

    {
	u_char *ds = vec;
	u_char ltmp;
	IA_DIVIter<u_char>	liter(lhs);
	for (unsigned i=0; i<sz; i++) {
	    liter(ltmp);
	    *(ds++) = ( (ltmp) % (rhs) );
	}
    }
    return IA_UcharDiscreteImage(domain, vec, sz, 1);
}
#endif // iter_scalar_u_char_u_char_int_operatorIAOPmd

IA_UcharDiscreteImage
operator% ( const IA_UcharDiscreteImage &lhs, int rhs)
{
    if (lhs.type() == IA_VectorDI<u_char>::s_type()) {
	return vec_scalar_bo_operatorIAOPmd((IA_VectorDI<u_char> *)lhs.bdip,rhs);
    } else if (lhs.type() == IA_ConstDI<u_char>::s_type()) {
	return IA_UcharDiscreteImage (lhs.domain(), (((IA_ConstDI<u_char> *)lhs.bdip)->value) % (rhs));
    } else {
	return iter_scalar_bo_operatorIAOPmd(lhs,rhs);
    }
}

//////////////////////////////////////////////////////////////////////
//
// Begin operation support routines for :
// binary pointwise non-commutative operator% int I(u_char) I(u_char)
//
#ifndef scalar_vec_u_char_int_u_char_operatorIAOPmd
#define scalar_vec_u_char_int_u_char_operatorIAOPmd
static IA_UcharDiscreteImage
scalar_vec_bo_operatorIAOPmd(int lhs,const IA_VectorDI<u_char> *rhs)
{
    const IA_IntPointSet domain = rhs->domain();
    const unsigned sz = domain.card();
    u_char *const vec = new u_char[sz];

    {
	u_char *ds = vec;
	const u_char *rs = rhs->vec;
	for (unsigned i=0; i<sz; i++) {
	    *(ds++) = ( (lhs) % (*(rs++)) );
	}
    }
    return IA_UcharDiscreteImage(domain, vec, sz, 1);
}
#endif // scalar_vec_u_char_int_u_char_operatorIAOPmd

// scalar-scalar operation is trivial

#ifndef scalar_iter_u_char_int_u_char_operatorIAOPmd
#define scalar_iter_u_char_int_u_char_operatorIAOPmd
static IA_UcharDiscreteImage
scalar_iter_bo_operatorIAOPmd(int lhs,IA_UcharDiscreteImage rhs)
{
    const IA_IntPointSet domain = rhs.domain();
    const unsigned sz = domain.card();
    u_char *const vec = new u_char[sz];

    {
	u_char *ds = vec;
	u_char rtmp;
	IA_DIVIter<u_char>	riter(rhs);
	for (unsigned i=0; i<sz; i++) {
	    riter(rtmp);
	    *(ds++) = ( (lhs) % (rtmp) );
	}
    }
    return IA_UcharDiscreteImage(domain, vec, sz, 1);
}
#endif // scalar_iter_u_char_int_u_char_operatorIAOPmd

IA_UcharDiscreteImage
operator% (int lhs, const IA_UcharDiscreteImage &rhs)
{
    if (rhs.type() == IA_VectorDI<u_char>::s_type()) {
	return scalar_vec_bo_operatorIAOPmd(lhs,(IA_VectorDI<u_char> *)rhs.bdip);
    } else if (rhs.type() == IA_ConstDI<u_char>::s_type()) {
	return IA_UcharDiscreteImage (rhs.domain(), (lhs) % (((IA_ConstDI<u_char> *)rhs.bdip)->value));
    } else {
	return scalar_iter_bo_operatorIAOPmd(lhs,rhs);
    }
}

//////////////////////////////////////////////////////////////////////
//
// Begin operation support routines for :
// pointwise operator%= I(u_char) I(u_char)
//
// There are none (it's inline)

//////////////////////////////////////////////////////////////////////
//
// Begin operation support routines for :
// pointwise operator%= I(u_char) int
//
// There are none (it's inline)

//////////////////////////////////////////////////////////////////////
//
// Begin operation support routines for :
// binary pointwise commutative operator& I(u_char) I(u_char) I(u_char)
//
static IA_UcharDiscreteImage
vec_vec_bo_operatorIAOPba(const IA_VectorDI<u_char> *lhs,const IA_VectorDI<u_char> *rhs)
{
    const IA_IntPointSet domain = lhs->domain();
    const unsigned sz = domain.card();
    u_char *const vec = new u_char[sz];

    {
	u_char *ds = vec;
	const u_char *ls = lhs->vec;
	const u_char *rs = rhs->vec;
	for (unsigned i=0; i<sz; i++) {
	    *(ds++) = ( (*(ls++)) & (*(rs++)) );
	}
    }
    return IA_UcharDiscreteImage(domain, vec, sz, 1);
}

#ifndef vec_scalar_u_char_u_char_u_char_operatorIAOPba
#define vec_scalar_u_char_u_char_u_char_operatorIAOPba
static IA_UcharDiscreteImage
vec_scalar_bo_operatorIAOPba(const IA_VectorDI<u_char> *lhs,u_char rhs)
{
    const IA_IntPointSet domain = lhs->domain();
    const unsigned sz = domain.card();
    u_char *const vec = new u_char[sz];

    {
	u_char *ds = vec;
	const u_char *ls = lhs->vec;
	for (unsigned i=0; i<sz; i++) {
	    *(ds++) = ( (*(ls++)) & (rhs) );
	}
    }
    return IA_UcharDiscreteImage(domain, vec, sz, 1);
}
#endif // vec_scalar_u_char_u_char_u_char_operatorIAOPba

static IA_UcharDiscreteImage
vec_iter_bo_operatorIAOPba(const IA_VectorDI<u_char> *lhs,IA_UcharDiscreteImage rhs)
{
    const IA_IntPointSet domain = lhs->domain();
    const unsigned sz = domain.card();
    u_char *const vec = new u_char[sz];

    {
	u_char *ds = vec;
	const u_char *ls = lhs->vec;
	u_char rtmp;
	IA_DIVIter<u_char>	riter(rhs);
	for (unsigned i=0; i<sz; i++) {
	    riter(rtmp);
	    *(ds++) = ( (*(ls++)) & (rtmp) );
	}
    }
    return IA_UcharDiscreteImage(domain, vec, sz, 1);
}

// scalar-scalar operation is trivial

#ifndef scalar_iter_u_char_u_char_u_char_operatorIAOPba
#define scalar_iter_u_char_u_char_u_char_operatorIAOPba
static IA_UcharDiscreteImage
scalar_iter_bo_operatorIAOPba(u_char lhs,IA_UcharDiscreteImage rhs)
{
    const IA_IntPointSet domain = rhs.domain();
    const unsigned sz = domain.card();
    u_char *const vec = new u_char[sz];

    {
	u_char *ds = vec;
	u_char rtmp;
	IA_DIVIter<u_char>	riter(rhs);
	for (unsigned i=0; i<sz; i++) {
	    riter(rtmp);
	    *(ds++) = ( (lhs) & (rtmp) );
	}
    }
    return IA_UcharDiscreteImage(domain, vec, sz, 1);
}
#endif // scalar_iter_u_char_u_char_u_char_operatorIAOPba

static IA_UcharDiscreteImage
iter_iter_bo_operatorIAOPba(IA_UcharDiscreteImage lhs,IA_UcharDiscreteImage rhs)
{
    const IA_IntPointSet domain = lhs.domain();
    const unsigned sz = domain.card();
    u_char *const vec = new u_char[sz];

    {
	u_char *ds = vec;
	u_char ltmp;
	IA_DIVIter<u_char>	liter(lhs);
	u_char rtmp;
	IA_DIVIter<u_char>	riter(rhs);
	for (unsigned i=0; i<sz; i++) {
	    liter(ltmp);
	    riter(rtmp);
	    *(ds++) = ( (ltmp) & (rtmp) );
	}
    }
    return IA_UcharDiscreteImage(domain, vec, sz, 1);
}

IA_UcharDiscreteImage
operator& ( const IA_UcharDiscreteImage &lhs,
	      const IA_UcharDiscreteImage &rhs)
{
    if (lhs.domain() != rhs.domain()) {
	static IA_UcharDiscreteImage	rval;
	ia_throw( IA::PSET_MISMATCH, __FILE__,__LINE__);
	return rval;
    }

    if (lhs.type() == IA_VectorDI<u_char>::s_type()) {
	if (rhs.type() == IA_VectorDI<u_char>::s_type()) {
	    return vec_vec_bo_operatorIAOPba((IA_VectorDI<u_char> *)lhs.bdip,(IA_VectorDI<u_char> *)rhs.bdip);
	} else if (rhs.type() == IA_ConstDI<u_char>::s_type()) {
	    return vec_scalar_bo_operatorIAOPba((IA_VectorDI<u_char> *)lhs.bdip,((IA_ConstDI<u_char> *)rhs.bdip)->value);
	} else {
	    return vec_iter_bo_operatorIAOPba((IA_VectorDI<u_char> *)lhs.bdip,rhs);
	}
    } else if (lhs.type() == IA_ConstDI<u_char>::s_type()) {
	if (rhs.type() == IA_VectorDI<u_char>::s_type()) {
	    return vec_scalar_bo_operatorIAOPba((IA_VectorDI<u_char> *)rhs.bdip,((IA_ConstDI<u_char> *)lhs.bdip)->value);
	} else if (rhs.type() == IA_ConstDI<u_char>::s_type()) {
	    return IA_UcharDiscreteImage (lhs.domain(), (((IA_ConstDI<u_char> *)lhs.bdip)->value) & (((IA_ConstDI<u_char> *)rhs.bdip)->value));
	} else {
	    return scalar_iter_bo_operatorIAOPba(((IA_ConstDI<u_char> *)lhs.bdip)->value,rhs);
	}
    } else {
	if (rhs.type() == IA_VectorDI<u_char>::s_type()) {
	    return vec_iter_bo_operatorIAOPba((IA_VectorDI<u_char> *)rhs.bdip,lhs);
	} else if (rhs.type() == IA_ConstDI<u_char>::s_type()) {
	    return scalar_iter_bo_operatorIAOPba(((IA_ConstDI<u_char> *)rhs.bdip)->value,lhs);
	} else {
	    return iter_iter_bo_operatorIAOPba(lhs,rhs);
	}
    }
}

//////////////////////////////////////////////////////////////////////
//
// Begin operation support routines for :
// binary pointwise commutative operator& I(u_char) int I(u_char)
//
#ifndef vec_scalar_u_char_u_char_int_operatorIAOPba
#define vec_scalar_u_char_u_char_int_operatorIAOPba
static IA_UcharDiscreteImage
vec_scalar_bo_operatorIAOPba(const IA_VectorDI<u_char> *lhs,int rhs)
{
    const IA_IntPointSet domain = lhs->domain();
    const unsigned sz = domain.card();
    u_char *const vec = new u_char[sz];

    {
	u_char *ds = vec;
	const u_char *ls = lhs->vec;
	for (unsigned i=0; i<sz; i++) {
	    *(ds++) = ( (*(ls++)) & (rhs) );
	}
    }
    return IA_UcharDiscreteImage(domain, vec, sz, 1);
}
#endif // vec_scalar_u_char_u_char_int_operatorIAOPba

// scalar-scalar operation is trivial

#ifndef iter_scalar_u_char_u_char_int_operatorIAOPba
#define iter_scalar_u_char_u_char_int_operatorIAOPba
static IA_UcharDiscreteImage
iter_scalar_bo_operatorIAOPba(IA_UcharDiscreteImage lhs,int rhs)
{
    const IA_IntPointSet domain = lhs.domain();
    const unsigned sz = domain.card();
    u_char *const vec = new u_char[sz];

    {
	u_char *ds = vec;
	u_char ltmp;
	IA_DIVIter<u_char>	liter(lhs);
	for (unsigned i=0; i<sz; i++) {
	    liter(ltmp);
	    *(ds++) = ( (ltmp) & (rhs) );
	}
    }
    return IA_UcharDiscreteImage(domain, vec, sz, 1);
}
#endif // iter_scalar_u_char_u_char_int_operatorIAOPba

IA_UcharDiscreteImage
operator& ( const IA_UcharDiscreteImage &lhs, int rhs)
{
    if (lhs.type() == IA_VectorDI<u_char>::s_type()) {
	return vec_scalar_bo_operatorIAOPba((IA_VectorDI<u_char> *)lhs.bdip,rhs);
    } else if (lhs.type() == IA_ConstDI<u_char>::s_type()) {
	return IA_UcharDiscreteImage (lhs.domain(), (((IA_ConstDI<u_char> *)lhs.bdip)->value) & (rhs));
    } else {
	return iter_scalar_bo_operatorIAOPba(lhs,rhs);
    }
}

//////////////////////////////////////////////////////////////////////
//
// Begin operation support routines for :
// pointwise operator&= I(u_char) I(u_char)
//
// There are none (it's inline)

//////////////////////////////////////////////////////////////////////
//
// Begin operation support routines for :
// pointwise operator&= I(u_char) int
//
// There are none (it's inline)

//////////////////////////////////////////////////////////////////////
//
// Begin operation support routines for :
// binary pointwise commutative operator| I(u_char) I(u_char) I(u_char)
//
static IA_UcharDiscreteImage
vec_vec_bo_operatorIAOPbo(const IA_VectorDI<u_char> *lhs,const IA_VectorDI<u_char> *rhs)
{
    const IA_IntPointSet domain = lhs->domain();
    const unsigned sz = domain.card();
    u_char *const vec = new u_char[sz];

    {
	u_char *ds = vec;
	const u_char *ls = lhs->vec;
	const u_char *rs = rhs->vec;
	for (unsigned i=0; i<sz; i++) {
	    *(ds++) = ( (*(ls++)) | (*(rs++)) );
	}
    }
    return IA_UcharDiscreteImage(domain, vec, sz, 1);
}

#ifndef vec_scalar_u_char_u_char_u_char_operatorIAOPbo
#define vec_scalar_u_char_u_char_u_char_operatorIAOPbo
static IA_UcharDiscreteImage
vec_scalar_bo_operatorIAOPbo(const IA_VectorDI<u_char> *lhs,u_char rhs)
{
    const IA_IntPointSet domain = lhs->domain();
    const unsigned sz = domain.card();
    u_char *const vec = new u_char[sz];

    {
	u_char *ds = vec;
	const u_char *ls = lhs->vec;
	for (unsigned i=0; i<sz; i++) {
	    *(ds++) = ( (*(ls++)) | (rhs) );
	}
    }
    return IA_UcharDiscreteImage(domain, vec, sz, 1);
}
#endif // vec_scalar_u_char_u_char_u_char_operatorIAOPbo

static IA_UcharDiscreteImage
vec_iter_bo_operatorIAOPbo(const IA_VectorDI<u_char> *lhs,IA_UcharDiscreteImage rhs)
{
    const IA_IntPointSet domain = lhs->domain();
    const unsigned sz = domain.card();
    u_char *const vec = new u_char[sz];

    {
	u_char *ds = vec;
	const u_char *ls = lhs->vec;
	u_char rtmp;
	IA_DIVIter<u_char>	riter(rhs);
	for (unsigned i=0; i<sz; i++) {
	    riter(rtmp);
	    *(ds++) = ( (*(ls++)) | (rtmp) );
	}
    }
    return IA_UcharDiscreteImage(domain, vec, sz, 1);
}

// scalar-scalar operation is trivial

#ifndef scalar_iter_u_char_u_char_u_char_operatorIAOPbo
#define scalar_iter_u_char_u_char_u_char_operatorIAOPbo
static IA_UcharDiscreteImage
scalar_iter_bo_operatorIAOPbo(u_char lhs,IA_UcharDiscreteImage rhs)
{
    const IA_IntPointSet domain = rhs.domain();
    const unsigned sz = domain.card();
    u_char *const vec = new u_char[sz];

    {
	u_char *ds = vec;
	u_char rtmp;
	IA_DIVIter<u_char>	riter(rhs);
	for (unsigned i=0; i<sz; i++) {
	    riter(rtmp);
	    *(ds++) = ( (lhs) | (rtmp) );
	}
    }
    return IA_UcharDiscreteImage(domain, vec, sz, 1);
}
#endif // scalar_iter_u_char_u_char_u_char_operatorIAOPbo

static IA_UcharDiscreteImage
iter_iter_bo_operatorIAOPbo(IA_UcharDiscreteImage lhs,IA_UcharDiscreteImage rhs)
{
    const IA_IntPointSet domain = lhs.domain();
    const unsigned sz = domain.card();
    u_char *const vec = new u_char[sz];

    {
	u_char *ds = vec;
	u_char ltmp;
	IA_DIVIter<u_char>	liter(lhs);
	u_char rtmp;
	IA_DIVIter<u_char>	riter(rhs);
	for (unsigned i=0; i<sz; i++) {
	    liter(ltmp);
	    riter(rtmp);
	    *(ds++) = ( (ltmp) | (rtmp) );
	}
    }
    return IA_UcharDiscreteImage(domain, vec, sz, 1);
}

IA_UcharDiscreteImage
operator| ( const IA_UcharDiscreteImage &lhs,
	      const IA_UcharDiscreteImage &rhs)
{
    if (lhs.domain() != rhs.domain()) {
	static IA_UcharDiscreteImage	rval;
	ia_throw( IA::PSET_MISMATCH, __FILE__,__LINE__);
	return rval;
    }

    if (lhs.type() == IA_VectorDI<u_char>::s_type()) {
	if (rhs.type() == IA_VectorDI<u_char>::s_type()) {
	    return vec_vec_bo_operatorIAOPbo((IA_VectorDI<u_char> *)lhs.bdip,(IA_VectorDI<u_char> *)rhs.bdip);
	} else if (rhs.type() == IA_ConstDI<u_char>::s_type()) {
	    return vec_scalar_bo_operatorIAOPbo((IA_VectorDI<u_char> *)lhs.bdip,((IA_ConstDI<u_char> *)rhs.bdip)->value);
	} else {
	    return vec_iter_bo_operatorIAOPbo((IA_VectorDI<u_char> *)lhs.bdip,rhs);
	}
    } else if (lhs.type() == IA_ConstDI<u_char>::s_type()) {
	if (rhs.type() == IA_VectorDI<u_char>::s_type()) {
	    return vec_scalar_bo_operatorIAOPbo((IA_VectorDI<u_char> *)rhs.bdip,((IA_ConstDI<u_char> *)lhs.bdip)->value);
	} else if (rhs.type() == IA_ConstDI<u_char>::s_type()) {
	    return IA_UcharDiscreteImage (lhs.domain(), (((IA_ConstDI<u_char> *)lhs.bdip)->value) | (((IA_ConstDI<u_char> *)rhs.bdip)->value));
	} else {
	    return scalar_iter_bo_operatorIAOPbo(((IA_ConstDI<u_char> *)lhs.bdip)->value,rhs);
	}
    } else {
	if (rhs.type() == IA_VectorDI<u_char>::s_type()) {
	    return vec_iter_bo_operatorIAOPbo((IA_VectorDI<u_char> *)rhs.bdip,lhs);
	} else if (rhs.type() == IA_ConstDI<u_char>::s_type()) {
	    return scalar_iter_bo_operatorIAOPbo(((IA_ConstDI<u_char> *)rhs.bdip)->value,lhs);
	} else {
	    return iter_iter_bo_operatorIAOPbo(lhs,rhs);
	}
    }
}

//////////////////////////////////////////////////////////////////////
//
// Begin operation support routines for :
// binary pointwise commutative operator| I(u_char) int I(u_char)
//
#ifndef vec_scalar_u_char_u_char_int_operatorIAOPbo
#define vec_scalar_u_char_u_char_int_operatorIAOPbo
static IA_UcharDiscreteImage
vec_scalar_bo_operatorIAOPbo(const IA_VectorDI<u_char> *lhs,int rhs)
{
    const IA_IntPointSet domain = lhs->domain();
    const unsigned sz = domain.card();
    u_char *const vec = new u_char[sz];

    {
	u_char *ds = vec;
	const u_char *ls = lhs->vec;
	for (unsigned i=0; i<sz; i++) {
	    *(ds++) = ( (*(ls++)) | (rhs) );
	}
    }
    return IA_UcharDiscreteImage(domain, vec, sz, 1);
}
#endif // vec_scalar_u_char_u_char_int_operatorIAOPbo

// scalar-scalar operation is trivial

#ifndef iter_scalar_u_char_u_char_int_operatorIAOPbo
#define iter_scalar_u_char_u_char_int_operatorIAOPbo
static IA_UcharDiscreteImage
iter_scalar_bo_operatorIAOPbo(IA_UcharDiscreteImage lhs,int rhs)
{
    const IA_IntPointSet domain = lhs.domain();
    const unsigned sz = domain.card();
    u_char *const vec = new u_char[sz];

    {
	u_char *ds = vec;
	u_char ltmp;
	IA_DIVIter<u_char>	liter(lhs);
	for (unsigned i=0; i<sz; i++) {
	    liter(ltmp);
	    *(ds++) = ( (ltmp) | (rhs) );
	}
    }
    return IA_UcharDiscreteImage(domain, vec, sz, 1);
}
#endif // iter_scalar_u_char_u_char_int_operatorIAOPbo

IA_UcharDiscreteImage
operator| ( const IA_UcharDiscreteImage &lhs, int rhs)
{
    if (lhs.type() == IA_VectorDI<u_char>::s_type()) {
	return vec_scalar_bo_operatorIAOPbo((IA_VectorDI<u_char> *)lhs.bdip,rhs);
    } else if (lhs.type() == IA_ConstDI<u_char>::s_type()) {
	return IA_UcharDiscreteImage (lhs.domain(), (((IA_ConstDI<u_char> *)lhs.bdip)->value) | (rhs));
    } else {
	return iter_scalar_bo_operatorIAOPbo(lhs,rhs);
    }
}

//////////////////////////////////////////////////////////////////////
//
// Begin operation support routines for :
// pointwise operator|= I(u_char) I(u_char)
//
// There are none (it's inline)

//////////////////////////////////////////////////////////////////////
//
// Begin operation support routines for :
// pointwise operator|= I(u_char) int
//
// There are none (it's inline)

//////////////////////////////////////////////////////////////////////
//
// Begin operation support routines for :
// binary pointwise commutative operator^ I(u_char) I(u_char) I(u_char)
//
static IA_UcharDiscreteImage
vec_vec_bo_operatorIAOPbx(const IA_VectorDI<u_char> *lhs,const IA_VectorDI<u_char> *rhs)
{
    const IA_IntPointSet domain = lhs->domain();
    const unsigned sz = domain.card();
    u_char *const vec = new u_char[sz];

    {
	u_char *ds = vec;
	const u_char *ls = lhs->vec;
	const u_char *rs = rhs->vec;
	for (unsigned i=0; i<sz; i++) {
	    *(ds++) = ( (*(ls++)) ^ (*(rs++)) );
	}
    }
    return IA_UcharDiscreteImage(domain, vec, sz, 1);
}

#ifndef vec_scalar_u_char_u_char_u_char_operatorIAOPbx
#define vec_scalar_u_char_u_char_u_char_operatorIAOPbx
static IA_UcharDiscreteImage
vec_scalar_bo_operatorIAOPbx(const IA_VectorDI<u_char> *lhs,u_char rhs)
{
    const IA_IntPointSet domain = lhs->domain();
    const unsigned sz = domain.card();
    u_char *const vec = new u_char[sz];

    {
	u_char *ds = vec;
	const u_char *ls = lhs->vec;
	for (unsigned i=0; i<sz; i++) {
	    *(ds++) = ( (*(ls++)) ^ (rhs) );
	}
    }
    return IA_UcharDiscreteImage(domain, vec, sz, 1);
}
#endif // vec_scalar_u_char_u_char_u_char_operatorIAOPbx

static IA_UcharDiscreteImage
vec_iter_bo_operatorIAOPbx(const IA_VectorDI<u_char> *lhs,IA_UcharDiscreteImage rhs)
{
    const IA_IntPointSet domain = lhs->domain();
    const unsigned sz = domain.card();
    u_char *const vec = new u_char[sz];

    {
	u_char *ds = vec;
	const u_char *ls = lhs->vec;
	u_char rtmp;
	IA_DIVIter<u_char>	riter(rhs);
	for (unsigned i=0; i<sz; i++) {
	    riter(rtmp);
	    *(ds++) = ( (*(ls++)) ^ (rtmp) );
	}
    }
    return IA_UcharDiscreteImage(domain, vec, sz, 1);
}

// scalar-scalar operation is trivial

#ifndef scalar_iter_u_char_u_char_u_char_operatorIAOPbx
#define scalar_iter_u_char_u_char_u_char_operatorIAOPbx
static IA_UcharDiscreteImage
scalar_iter_bo_operatorIAOPbx(u_char lhs,IA_UcharDiscreteImage rhs)
{
    const IA_IntPointSet domain = rhs.domain();
    const unsigned sz = domain.card();
    u_char *const vec = new u_char[sz];

    {
	u_char *ds = vec;
	u_char rtmp;
	IA_DIVIter<u_char>	riter(rhs);
	for (unsigned i=0; i<sz; i++) {
	    riter(rtmp);
	    *(ds++) = ( (lhs) ^ (rtmp) );
	}
    }
    return IA_UcharDiscreteImage(domain, vec, sz, 1);
}
#endif // scalar_iter_u_char_u_char_u_char_operatorIAOPbx

static IA_UcharDiscreteImage
iter_iter_bo_operatorIAOPbx(IA_UcharDiscreteImage lhs,IA_UcharDiscreteImage rhs)
{
    const IA_IntPointSet domain = lhs.domain();
    const unsigned sz = domain.card();
    u_char *const vec = new u_char[sz];

    {
	u_char *ds = vec;
	u_char ltmp;
	IA_DIVIter<u_char>	liter(lhs);
	u_char rtmp;
	IA_DIVIter<u_char>	riter(rhs);
	for (unsigned i=0; i<sz; i++) {
	    liter(ltmp);
	    riter(rtmp);
	    *(ds++) = ( (ltmp) ^ (rtmp) );
	}
    }
    return IA_UcharDiscreteImage(domain, vec, sz, 1);
}

IA_UcharDiscreteImage
operator^ ( const IA_UcharDiscreteImage &lhs,
	      const IA_UcharDiscreteImage &rhs)
{
    if (lhs.domain() != rhs.domain()) {
	static IA_UcharDiscreteImage	rval;
	ia_throw( IA::PSET_MISMATCH, __FILE__,__LINE__);
	return rval;
    }

    if (lhs.type() == IA_VectorDI<u_char>::s_type()) {
	if (rhs.type() == IA_VectorDI<u_char>::s_type()) {
	    return vec_vec_bo_operatorIAOPbx((IA_VectorDI<u_char> *)lhs.bdip,(IA_VectorDI<u_char> *)rhs.bdip);
	} else if (rhs.type() == IA_ConstDI<u_char>::s_type()) {
	    return vec_scalar_bo_operatorIAOPbx((IA_VectorDI<u_char> *)lhs.bdip,((IA_ConstDI<u_char> *)rhs.bdip)->value);
	} else {
	    return vec_iter_bo_operatorIAOPbx((IA_VectorDI<u_char> *)lhs.bdip,rhs);
	}
    } else if (lhs.type() == IA_ConstDI<u_char>::s_type()) {
	if (rhs.type() == IA_VectorDI<u_char>::s_type()) {
	    return vec_scalar_bo_operatorIAOPbx((IA_VectorDI<u_char> *)rhs.bdip,((IA_ConstDI<u_char> *)lhs.bdip)->value);
	} else if (rhs.type() == IA_ConstDI<u_char>::s_type()) {
	    return IA_UcharDiscreteImage (lhs.domain(), (((IA_ConstDI<u_char> *)lhs.bdip)->value) ^ (((IA_ConstDI<u_char> *)rhs.bdip)->value));
	} else {
	    return scalar_iter_bo_operatorIAOPbx(((IA_ConstDI<u_char> *)lhs.bdip)->value,rhs);
	}
    } else {
	if (rhs.type() == IA_VectorDI<u_char>::s_type()) {
	    return vec_iter_bo_operatorIAOPbx((IA_VectorDI<u_char> *)rhs.bdip,lhs);
	} else if (rhs.type() == IA_ConstDI<u_char>::s_type()) {
	    return scalar_iter_bo_operatorIAOPbx(((IA_ConstDI<u_char> *)rhs.bdip)->value,lhs);
	} else {
	    return iter_iter_bo_operatorIAOPbx(lhs,rhs);
	}
    }
}

//////////////////////////////////////////////////////////////////////
//
// Begin operation support routines for :
// binary pointwise commutative operator^ I(u_char) int I(u_char)
//
#ifndef vec_scalar_u_char_u_char_int_operatorIAOPbx
#define vec_scalar_u_char_u_char_int_operatorIAOPbx
static IA_UcharDiscreteImage
vec_scalar_bo_operatorIAOPbx(const IA_VectorDI<u_char> *lhs,int rhs)
{
    const IA_IntPointSet domain = lhs->domain();
    const unsigned sz = domain.card();
    u_char *const vec = new u_char[sz];

    {
	u_char *ds = vec;
	const u_char *ls = lhs->vec;
	for (unsigned i=0; i<sz; i++) {
	    *(ds++) = ( (*(ls++)) ^ (rhs) );
	}
    }
    return IA_UcharDiscreteImage(domain, vec, sz, 1);
}
#endif // vec_scalar_u_char_u_char_int_operatorIAOPbx

// scalar-scalar operation is trivial

#ifndef iter_scalar_u_char_u_char_int_operatorIAOPbx
#define iter_scalar_u_char_u_char_int_operatorIAOPbx
static IA_UcharDiscreteImage
iter_scalar_bo_operatorIAOPbx(IA_UcharDiscreteImage lhs,int rhs)
{
    const IA_IntPointSet domain = lhs.domain();
    const unsigned sz = domain.card();
    u_char *const vec = new u_char[sz];

    {
	u_char *ds = vec;
	u_char ltmp;
	IA_DIVIter<u_char>	liter(lhs);
	for (unsigned i=0; i<sz; i++) {
	    liter(ltmp);
	    *(ds++) = ( (ltmp) ^ (rhs) );
	}
    }
    return IA_UcharDiscreteImage(domain, vec, sz, 1);
}
#endif // iter_scalar_u_char_u_char_int_operatorIAOPbx

IA_UcharDiscreteImage
operator^ ( const IA_UcharDiscreteImage &lhs, int rhs)
{
    if (lhs.type() == IA_VectorDI<u_char>::s_type()) {
	return vec_scalar_bo_operatorIAOPbx((IA_VectorDI<u_char> *)lhs.bdip,rhs);
    } else if (lhs.type() == IA_ConstDI<u_char>::s_type()) {
	return IA_UcharDiscreteImage (lhs.domain(), (((IA_ConstDI<u_char> *)lhs.bdip)->value) ^ (rhs));
    } else {
	return iter_scalar_bo_operatorIAOPbx(lhs,rhs);
    }
}

//////////////////////////////////////////////////////////////////////
//
// Begin operation support routines for :
// pointwise operator^= I(u_char) I(u_char)
//
// There are none (it's inline)

//////////////////////////////////////////////////////////////////////
//
// Begin operation support routines for :
// pointwise operator^= I(u_char) int
//
// There are none (it's inline)

//////////////////////////////////////////////////////////////////////
//
// Begin operation support routines for :
// binary pointwise commutative operator<< I(u_char) I(u_char) I(u_char)
//
static IA_UcharDiscreteImage
vec_vec_bo_operatorIAOPls(const IA_VectorDI<u_char> *lhs,const IA_VectorDI<u_char> *rhs)
{
    const IA_IntPointSet domain = lhs->domain();
    const unsigned sz = domain.card();
    u_char *const vec = new u_char[sz];

    {
	u_char *ds = vec;
	const u_char *ls = lhs->vec;
	const u_char *rs = rhs->vec;
	for (unsigned i=0; i<sz; i++) {
	    *(ds++) = ( (*(ls++)) << (*(rs++)) );
	}
    }
    return IA_UcharDiscreteImage(domain, vec, sz, 1);
}

#ifndef vec_scalar_u_char_u_char_u_char_operatorIAOPls
#define vec_scalar_u_char_u_char_u_char_operatorIAOPls
static IA_UcharDiscreteImage
vec_scalar_bo_operatorIAOPls(const IA_VectorDI<u_char> *lhs,u_char rhs)
{
    const IA_IntPointSet domain = lhs->domain();
    const unsigned sz = domain.card();
    u_char *const vec = new u_char[sz];

    {
	u_char *ds = vec;
	const u_char *ls = lhs->vec;
	for (unsigned i=0; i<sz; i++) {
	    *(ds++) = ( (*(ls++)) << (rhs) );
	}
    }
    return IA_UcharDiscreteImage(domain, vec, sz, 1);
}
#endif // vec_scalar_u_char_u_char_u_char_operatorIAOPls

static IA_UcharDiscreteImage
vec_iter_bo_operatorIAOPls(const IA_VectorDI<u_char> *lhs,IA_UcharDiscreteImage rhs)
{
    const IA_IntPointSet domain = lhs->domain();
    const unsigned sz = domain.card();
    u_char *const vec = new u_char[sz];

    {
	u_char *ds = vec;
	const u_char *ls = lhs->vec;
	u_char rtmp;
	IA_DIVIter<u_char>	riter(rhs);
	for (unsigned i=0; i<sz; i++) {
	    riter(rtmp);
	    *(ds++) = ( (*(ls++)) << (rtmp) );
	}
    }
    return IA_UcharDiscreteImage(domain, vec, sz, 1);
}

// scalar-scalar operation is trivial

#ifndef scalar_iter_u_char_u_char_u_char_operatorIAOPls
#define scalar_iter_u_char_u_char_u_char_operatorIAOPls
static IA_UcharDiscreteImage
scalar_iter_bo_operatorIAOPls(u_char lhs,IA_UcharDiscreteImage rhs)
{
    const IA_IntPointSet domain = rhs.domain();
    const unsigned sz = domain.card();
    u_char *const vec = new u_char[sz];

    {
	u_char *ds = vec;
	u_char rtmp;
	IA_DIVIter<u_char>	riter(rhs);
	for (unsigned i=0; i<sz; i++) {
	    riter(rtmp);
	    *(ds++) = ( (lhs) << (rtmp) );
	}
    }
    return IA_UcharDiscreteImage(domain, vec, sz, 1);
}
#endif // scalar_iter_u_char_u_char_u_char_operatorIAOPls

static IA_UcharDiscreteImage
iter_iter_bo_operatorIAOPls(IA_UcharDiscreteImage lhs,IA_UcharDiscreteImage rhs)
{
    const IA_IntPointSet domain = lhs.domain();
    const unsigned sz = domain.card();
    u_char *const vec = new u_char[sz];

    {
	u_char *ds = vec;
	u_char ltmp;
	IA_DIVIter<u_char>	liter(lhs);
	u_char rtmp;
	IA_DIVIter<u_char>	riter(rhs);
	for (unsigned i=0; i<sz; i++) {
	    liter(ltmp);
	    riter(rtmp);
	    *(ds++) = ( (ltmp) << (rtmp) );
	}
    }
    return IA_UcharDiscreteImage(domain, vec, sz, 1);
}

IA_UcharDiscreteImage
operator<< ( const IA_UcharDiscreteImage &lhs,
	      const IA_UcharDiscreteImage &rhs)
{
    if (lhs.domain() != rhs.domain()) {
	static IA_UcharDiscreteImage	rval;
	ia_throw( IA::PSET_MISMATCH, __FILE__,__LINE__);
	return rval;
    }

    if (lhs.type() == IA_VectorDI<u_char>::s_type()) {
	if (rhs.type() == IA_VectorDI<u_char>::s_type()) {
	    return vec_vec_bo_operatorIAOPls((IA_VectorDI<u_char> *)lhs.bdip,(IA_VectorDI<u_char> *)rhs.bdip);
	} else if (rhs.type() == IA_ConstDI<u_char>::s_type()) {
	    return vec_scalar_bo_operatorIAOPls((IA_VectorDI<u_char> *)lhs.bdip,((IA_ConstDI<u_char> *)rhs.bdip)->value);
	} else {
	    return vec_iter_bo_operatorIAOPls((IA_VectorDI<u_char> *)lhs.bdip,rhs);
	}
    } else if (lhs.type() == IA_ConstDI<u_char>::s_type()) {
	if (rhs.type() == IA_VectorDI<u_char>::s_type()) {
	    return vec_scalar_bo_operatorIAOPls((IA_VectorDI<u_char> *)rhs.bdip,((IA_ConstDI<u_char> *)lhs.bdip)->value);
	} else if (rhs.type() == IA_ConstDI<u_char>::s_type()) {
	    return IA_UcharDiscreteImage (lhs.domain(), (((IA_ConstDI<u_char> *)lhs.bdip)->value) << (((IA_ConstDI<u_char> *)rhs.bdip)->value));
	} else {
	    return scalar_iter_bo_operatorIAOPls(((IA_ConstDI<u_char> *)lhs.bdip)->value,rhs);
	}
    } else {
	if (rhs.type() == IA_VectorDI<u_char>::s_type()) {
	    return vec_iter_bo_operatorIAOPls((IA_VectorDI<u_char> *)rhs.bdip,lhs);
	} else if (rhs.type() == IA_ConstDI<u_char>::s_type()) {
	    return scalar_iter_bo_operatorIAOPls(((IA_ConstDI<u_char> *)rhs.bdip)->value,lhs);
	} else {
	    return iter_iter_bo_operatorIAOPls(lhs,rhs);
	}
    }
}

//////////////////////////////////////////////////////////////////////
//
// Begin operation support routines for :
// binary pointwise commutative operator<< I(u_char) int I(u_char)
//
#ifndef vec_scalar_u_char_u_char_int_operatorIAOPls
#define vec_scalar_u_char_u_char_int_operatorIAOPls
static IA_UcharDiscreteImage
vec_scalar_bo_operatorIAOPls(const IA_VectorDI<u_char> *lhs,int rhs)
{
    const IA_IntPointSet domain = lhs->domain();
    const unsigned sz = domain.card();
    u_char *const vec = new u_char[sz];

    {
	u_char *ds = vec;
	const u_char *ls = lhs->vec;
	for (unsigned i=0; i<sz; i++) {
	    *(ds++) = ( (*(ls++)) << (rhs) );
	}
    }
    return IA_UcharDiscreteImage(domain, vec, sz, 1);
}
#endif // vec_scalar_u_char_u_char_int_operatorIAOPls

// scalar-scalar operation is trivial

#ifndef iter_scalar_u_char_u_char_int_operatorIAOPls
#define iter_scalar_u_char_u_char_int_operatorIAOPls
static IA_UcharDiscreteImage
iter_scalar_bo_operatorIAOPls(IA_UcharDiscreteImage lhs,int rhs)
{
    const IA_IntPointSet domain = lhs.domain();
    const unsigned sz = domain.card();
    u_char *const vec = new u_char[sz];

    {
	u_char *ds = vec;
	u_char ltmp;
	IA_DIVIter<u_char>	liter(lhs);
	for (unsigned i=0; i<sz; i++) {
	    liter(ltmp);
	    *(ds++) = ( (ltmp) << (rhs) );
	}
    }
    return IA_UcharDiscreteImage(domain, vec, sz, 1);
}
#endif // iter_scalar_u_char_u_char_int_operatorIAOPls

IA_UcharDiscreteImage
operator<< ( const IA_UcharDiscreteImage &lhs, int rhs)
{
    if (lhs.type() == IA_VectorDI<u_char>::s_type()) {
	return vec_scalar_bo_operatorIAOPls((IA_VectorDI<u_char> *)lhs.bdip,rhs);
    } else if (lhs.type() == IA_ConstDI<u_char>::s_type()) {
	return IA_UcharDiscreteImage (lhs.domain(), (((IA_ConstDI<u_char> *)lhs.bdip)->value) << (rhs));
    } else {
	return iter_scalar_bo_operatorIAOPls(lhs,rhs);
    }
}

//////////////////////////////////////////////////////////////////////
//
// Begin operation support routines for :
// pointwise operator<<= I(u_char) I(u_char)
//
// There are none (it's inline)

//////////////////////////////////////////////////////////////////////
//
// Begin operation support routines for :
// pointwise operator<<= I(u_char) int
//
// There are none (it's inline)

//////////////////////////////////////////////////////////////////////
//
// Begin operation support routines for :
// binary pointwise commutative operator>> I(u_char) I(u_char) I(u_char)
//
static IA_UcharDiscreteImage
vec_vec_bo_operatorIAOPrs(const IA_VectorDI<u_char> *lhs,const IA_VectorDI<u_char> *rhs)
{
    const IA_IntPointSet domain = lhs->domain();
    const unsigned sz = domain.card();
    u_char *const vec = new u_char[sz];

    {
	u_char *ds = vec;
	const u_char *ls = lhs->vec;
	const u_char *rs = rhs->vec;
	for (unsigned i=0; i<sz; i++) {
	    *(ds++) = ( (*(ls++)) >> (*(rs++)) );
	}
    }
    return IA_UcharDiscreteImage(domain, vec, sz, 1);
}

#ifndef vec_scalar_u_char_u_char_u_char_operatorIAOPrs
#define vec_scalar_u_char_u_char_u_char_operatorIAOPrs
static IA_UcharDiscreteImage
vec_scalar_bo_operatorIAOPrs(const IA_VectorDI<u_char> *lhs,u_char rhs)
{
    const IA_IntPointSet domain = lhs->domain();
    const unsigned sz = domain.card();
    u_char *const vec = new u_char[sz];

    {
	u_char *ds = vec;
	const u_char *ls = lhs->vec;
	for (unsigned i=0; i<sz; i++) {
	    *(ds++) = ( (*(ls++)) >> (rhs) );
	}
    }
    return IA_UcharDiscreteImage(domain, vec, sz, 1);
}
#endif // vec_scalar_u_char_u_char_u_char_operatorIAOPrs

static IA_UcharDiscreteImage
vec_iter_bo_operatorIAOPrs(const IA_VectorDI<u_char> *lhs,IA_UcharDiscreteImage rhs)
{
    const IA_IntPointSet domain = lhs->domain();
    const unsigned sz = domain.card();
    u_char *const vec = new u_char[sz];

    {
	u_char *ds = vec;
	const u_char *ls = lhs->vec;
	u_char rtmp;
	IA_DIVIter<u_char>	riter(rhs);
	for (unsigned i=0; i<sz; i++) {
	    riter(rtmp);
	    *(ds++) = ( (*(ls++)) >> (rtmp) );
	}
    }
    return IA_UcharDiscreteImage(domain, vec, sz, 1);
}

// scalar-scalar operation is trivial

#ifndef scalar_iter_u_char_u_char_u_char_operatorIAOPrs
#define scalar_iter_u_char_u_char_u_char_operatorIAOPrs
static IA_UcharDiscreteImage
scalar_iter_bo_operatorIAOPrs(u_char lhs,IA_UcharDiscreteImage rhs)
{
    const IA_IntPointSet domain = rhs.domain();
    const unsigned sz = domain.card();
    u_char *const vec = new u_char[sz];

    {
	u_char *ds = vec;
	u_char rtmp;
	IA_DIVIter<u_char>	riter(rhs);
	for (unsigned i=0; i<sz; i++) {
	    riter(rtmp);
	    *(ds++) = ( (lhs) >> (rtmp) );
	}
    }
    return IA_UcharDiscreteImage(domain, vec, sz, 1);
}
#endif // scalar_iter_u_char_u_char_u_char_operatorIAOPrs

static IA_UcharDiscreteImage
iter_iter_bo_operatorIAOPrs(IA_UcharDiscreteImage lhs,IA_UcharDiscreteImage rhs)
{
    const IA_IntPointSet domain = lhs.domain();
    const unsigned sz = domain.card();
    u_char *const vec = new u_char[sz];

    {
	u_char *ds = vec;
	u_char ltmp;
	IA_DIVIter<u_char>	liter(lhs);
	u_char rtmp;
	IA_DIVIter<u_char>	riter(rhs);
	for (unsigned i=0; i<sz; i++) {
	    liter(ltmp);
	    riter(rtmp);
	    *(ds++) = ( (ltmp) >> (rtmp) );
	}
    }
    return IA_UcharDiscreteImage(domain, vec, sz, 1);
}

IA_UcharDiscreteImage
operator>> ( const IA_UcharDiscreteImage &lhs,
	      const IA_UcharDiscreteImage &rhs)
{
    if (lhs.domain() != rhs.domain()) {
	static IA_UcharDiscreteImage	rval;
	ia_throw( IA::PSET_MISMATCH, __FILE__,__LINE__);
	return rval;
    }

    if (lhs.type() == IA_VectorDI<u_char>::s_type()) {
	if (rhs.type() == IA_VectorDI<u_char>::s_type()) {
	    return vec_vec_bo_operatorIAOPrs((IA_VectorDI<u_char> *)lhs.bdip,(IA_VectorDI<u_char> *)rhs.bdip);
	} else if (rhs.type() == IA_ConstDI<u_char>::s_type()) {
	    return vec_scalar_bo_operatorIAOPrs((IA_VectorDI<u_char> *)lhs.bdip,((IA_ConstDI<u_char> *)rhs.bdip)->value);
	} else {
	    return vec_iter_bo_operatorIAOPrs((IA_VectorDI<u_char> *)lhs.bdip,rhs);
	}
    } else if (lhs.type() == IA_ConstDI<u_char>::s_type()) {
	if (rhs.type() == IA_VectorDI<u_char>::s_type()) {
	    return vec_scalar_bo_operatorIAOPrs((IA_VectorDI<u_char> *)rhs.bdip,((IA_ConstDI<u_char> *)lhs.bdip)->value);
	} else if (rhs.type() == IA_ConstDI<u_char>::s_type()) {
	    return IA_UcharDiscreteImage (lhs.domain(), (((IA_ConstDI<u_char> *)lhs.bdip)->value) >> (((IA_ConstDI<u_char> *)rhs.bdip)->value));
	} else {
	    return scalar_iter_bo_operatorIAOPrs(((IA_ConstDI<u_char> *)lhs.bdip)->value,rhs);
	}
    } else {
	if (rhs.type() == IA_VectorDI<u_char>::s_type()) {
	    return vec_iter_bo_operatorIAOPrs((IA_VectorDI<u_char> *)rhs.bdip,lhs);
	} else if (rhs.type() == IA_ConstDI<u_char>::s_type()) {
	    return scalar_iter_bo_operatorIAOPrs(((IA_ConstDI<u_char> *)rhs.bdip)->value,lhs);
	} else {
	    return iter_iter_bo_operatorIAOPrs(lhs,rhs);
	}
    }
}

//////////////////////////////////////////////////////////////////////
//
// Begin operation support routines for :
// binary pointwise commutative operator>> I(u_char) int I(u_char)
//
#ifndef vec_scalar_u_char_u_char_int_operatorIAOPrs
#define vec_scalar_u_char_u_char_int_operatorIAOPrs
static IA_UcharDiscreteImage
vec_scalar_bo_operatorIAOPrs(const IA_VectorDI<u_char> *lhs,int rhs)
{
    const IA_IntPointSet domain = lhs->domain();
    const unsigned sz = domain.card();
    u_char *const vec = new u_char[sz];

    {
	u_char *ds = vec;
	const u_char *ls = lhs->vec;
	for (unsigned i=0; i<sz; i++) {
	    *(ds++) = ( (*(ls++)) >> (rhs) );
	}
    }
    return IA_UcharDiscreteImage(domain, vec, sz, 1);
}
#endif // vec_scalar_u_char_u_char_int_operatorIAOPrs

// scalar-scalar operation is trivial

#ifndef iter_scalar_u_char_u_char_int_operatorIAOPrs
#define iter_scalar_u_char_u_char_int_operatorIAOPrs
static IA_UcharDiscreteImage
iter_scalar_bo_operatorIAOPrs(IA_UcharDiscreteImage lhs,int rhs)
{
    const IA_IntPointSet domain = lhs.domain();
    const unsigned sz = domain.card();
    u_char *const vec = new u_char[sz];

    {
	u_char *ds = vec;
	u_char ltmp;
	IA_DIVIter<u_char>	liter(lhs);
	for (unsigned i=0; i<sz; i++) {
	    liter(ltmp);
	    *(ds++) = ( (ltmp) >> (rhs) );
	}
    }
    return IA_UcharDiscreteImage(domain, vec, sz, 1);
}
#endif // iter_scalar_u_char_u_char_int_operatorIAOPrs

IA_UcharDiscreteImage
operator>> ( const IA_UcharDiscreteImage &lhs, int rhs)
{
    if (lhs.type() == IA_VectorDI<u_char>::s_type()) {
	return vec_scalar_bo_operatorIAOPrs((IA_VectorDI<u_char> *)lhs.bdip,rhs);
    } else if (lhs.type() == IA_ConstDI<u_char>::s_type()) {
	return IA_UcharDiscreteImage (lhs.domain(), (((IA_ConstDI<u_char> *)lhs.bdip)->value) >> (rhs));
    } else {
	return iter_scalar_bo_operatorIAOPrs(lhs,rhs);
    }
}

//////////////////////////////////////////////////////////////////////
//
// Begin operation support routines for :
// pointwise operator>>= I(u_char) I(u_char)
//
// There are none (it's inline)

//////////////////////////////////////////////////////////////////////
//
// Begin operation support routines for :
// pointwise operator>>= I(u_char) int
//
// There are none (it's inline)

//////////////////////////////////////////////////////////////////////
//
// Begin operation support routines for :
// unary pointwise operator~ I(u_char) I(u_char)
//
// Emacs: -*- C++ -*-

//
//	Copyright 1993, Center for Computer Vision and Visualization,
//	University of Florida.  All rights reserved.
//


//
// $Log:	unary-op.templ,v $
// Revision 1.2  93/05/27  11:49:04  thoth
// Copyright Notices
// 
// Revision 1.1  93/03/10  13:50:00  thoth
// Initial revision
// 

#ifndef vec_scalar_u_char_u_char_operatorIAOPbn
#define vec_scalar_u_char_u_char_operatorIAOPbn
static IA_UcharDiscreteImage
vec_uo_operatorIAOPbn(const IA_VectorDI<u_char> *lhs)
{
    const IA_IntPointSet domain = lhs->domain();
    const unsigned sz = domain.card();
    u_char *const vec = new u_char[sz];

    {
	u_char *ds = vec;
	const u_char *ls = lhs->vec;
	for (unsigned i=0; i<sz; i++) {
	    *(ds++) = ~(*(ls++));
	}
    }
    return IA_UcharDiscreteImage(domain, vec, sz, 1);
}
#endif // vec_scalar_u_char_u_char_operatorIAOPbn

// scalar-scalar operation is trivial

#ifndef iter_scalar_u_char_u_char_operatorIAOPbn
#define iter_scalar_u_char_u_char_operatorIAOPbn
static IA_UcharDiscreteImage
iter_uo_operatorIAOPbn(IA_UcharDiscreteImage lhs)
{
    const IA_IntPointSet domain = lhs.domain();
    const unsigned sz = domain.card();
    u_char *const vec = new u_char[sz];

    {
	u_char *ds = vec;
	u_char ltmp;
	IA_DIVIter<u_char>	liter(lhs);
	for (unsigned i=0; i<sz; i++) {
	    liter(ltmp);
	    *(ds++) = ~(ltmp);
	}
    }
    return IA_UcharDiscreteImage(domain, vec, sz, 1);
}
#endif // iter_scalar_u_char_u_char_operatorIAOPbn

IA_UcharDiscreteImage
operator~ ( const IA_UcharDiscreteImage &arg)
{
    if (arg.type() == IA_VectorDI<u_char>::s_type()) {
	return vec_uo_operatorIAOPbn((IA_VectorDI<u_char> *)arg.bdip);
    } else if (arg.type() == IA_ConstDI<u_char>::s_type()) {
	return IA_UcharDiscreteImage (arg.domain(), ~(((IA_ConstDI<u_char> *)arg.bdip)->value));
    } else {
	return iter_uo_operatorIAOPbn(arg);
    }
}

//////////////////////////////////////////////////////////////////////
//
// Begin operation support routines for :
// binary pointwise commutative operator&& I(u_char) I(u_char) I(u_char)
//
static IA_UcharDiscreteImage
vec_vec_bo_operatorIAOPla(const IA_VectorDI<u_char> *lhs,const IA_VectorDI<u_char> *rhs)
{
    const IA_IntPointSet domain = lhs->domain();
    const unsigned sz = domain.card();
    u_char *const vec = new u_char[sz];

    {
	u_char *ds = vec;
	const u_char *ls = lhs->vec;
	const u_char *rs = rhs->vec;
	for (unsigned i=0; i<sz; i++) {
	    *(ds++) = ( (*(ls++)) && (*(rs++)) );
	}
    }
    return IA_UcharDiscreteImage(domain, vec, sz, 1);
}

#ifndef vec_scalar_u_char_u_char_u_char_operatorIAOPla
#define vec_scalar_u_char_u_char_u_char_operatorIAOPla
static IA_UcharDiscreteImage
vec_scalar_bo_operatorIAOPla(const IA_VectorDI<u_char> *lhs,u_char rhs)
{
    const IA_IntPointSet domain = lhs->domain();
    const unsigned sz = domain.card();
    u_char *const vec = new u_char[sz];

    {
	u_char *ds = vec;
	const u_char *ls = lhs->vec;
	for (unsigned i=0; i<sz; i++) {
	    *(ds++) = ( (*(ls++)) && (rhs) );
	}
    }
    return IA_UcharDiscreteImage(domain, vec, sz, 1);
}
#endif // vec_scalar_u_char_u_char_u_char_operatorIAOPla

static IA_UcharDiscreteImage
vec_iter_bo_operatorIAOPla(const IA_VectorDI<u_char> *lhs,IA_UcharDiscreteImage rhs)
{
    const IA_IntPointSet domain = lhs->domain();
    const unsigned sz = domain.card();
    u_char *const vec = new u_char[sz];

    {
	u_char *ds = vec;
	const u_char *ls = lhs->vec;
	u_char rtmp;
	IA_DIVIter<u_char>	riter(rhs);
	for (unsigned i=0; i<sz; i++) {
	    riter(rtmp);
	    *(ds++) = ( (*(ls++)) && (rtmp) );
	}
    }
    return IA_UcharDiscreteImage(domain, vec, sz, 1);
}

// scalar-scalar operation is trivial

#ifndef scalar_iter_u_char_u_char_u_char_operatorIAOPla
#define scalar_iter_u_char_u_char_u_char_operatorIAOPla
static IA_UcharDiscreteImage
scalar_iter_bo_operatorIAOPla(u_char lhs,IA_UcharDiscreteImage rhs)
{
    const IA_IntPointSet domain = rhs.domain();
    const unsigned sz = domain.card();
    u_char *const vec = new u_char[sz];

    {
	u_char *ds = vec;
	u_char rtmp;
	IA_DIVIter<u_char>	riter(rhs);
	for (unsigned i=0; i<sz; i++) {
	    riter(rtmp);
	    *(ds++) = ( (lhs) && (rtmp) );
	}
    }
    return IA_UcharDiscreteImage(domain, vec, sz, 1);
}
#endif // scalar_iter_u_char_u_char_u_char_operatorIAOPla

static IA_UcharDiscreteImage
iter_iter_bo_operatorIAOPla(IA_UcharDiscreteImage lhs,IA_UcharDiscreteImage rhs)
{
    const IA_IntPointSet domain = lhs.domain();
    const unsigned sz = domain.card();
    u_char *const vec = new u_char[sz];

    {
	u_char *ds = vec;
	u_char ltmp;
	IA_DIVIter<u_char>	liter(lhs);
	u_char rtmp;
	IA_DIVIter<u_char>	riter(rhs);
	for (unsigned i=0; i<sz; i++) {
	    liter(ltmp);
	    riter(rtmp);
	    *(ds++) = ( (ltmp) && (rtmp) );
	}
    }
    return IA_UcharDiscreteImage(domain, vec, sz, 1);
}

IA_UcharDiscreteImage
operator&& ( const IA_UcharDiscreteImage &lhs,
	      const IA_UcharDiscreteImage &rhs)
{
    if (lhs.domain() != rhs.domain()) {
	static IA_UcharDiscreteImage	rval;
	ia_throw( IA::PSET_MISMATCH, __FILE__,__LINE__);
	return rval;
    }

    if (lhs.type() == IA_VectorDI<u_char>::s_type()) {
	if (rhs.type() == IA_VectorDI<u_char>::s_type()) {
	    return vec_vec_bo_operatorIAOPla((IA_VectorDI<u_char> *)lhs.bdip,(IA_VectorDI<u_char> *)rhs.bdip);
	} else if (rhs.type() == IA_ConstDI<u_char>::s_type()) {
	    return vec_scalar_bo_operatorIAOPla((IA_VectorDI<u_char> *)lhs.bdip,((IA_ConstDI<u_char> *)rhs.bdip)->value);
	} else {
	    return vec_iter_bo_operatorIAOPla((IA_VectorDI<u_char> *)lhs.bdip,rhs);
	}
    } else if (lhs.type() == IA_ConstDI<u_char>::s_type()) {
	if (rhs.type() == IA_VectorDI<u_char>::s_type()) {
	    return vec_scalar_bo_operatorIAOPla((IA_VectorDI<u_char> *)rhs.bdip,((IA_ConstDI<u_char> *)lhs.bdip)->value);
	} else if (rhs.type() == IA_ConstDI<u_char>::s_type()) {
	    return IA_UcharDiscreteImage (lhs.domain(), (((IA_ConstDI<u_char> *)lhs.bdip)->value) && (((IA_ConstDI<u_char> *)rhs.bdip)->value));
	} else {
	    return scalar_iter_bo_operatorIAOPla(((IA_ConstDI<u_char> *)lhs.bdip)->value,rhs);
	}
    } else {
	if (rhs.type() == IA_VectorDI<u_char>::s_type()) {
	    return vec_iter_bo_operatorIAOPla((IA_VectorDI<u_char> *)rhs.bdip,lhs);
	} else if (rhs.type() == IA_ConstDI<u_char>::s_type()) {
	    return scalar_iter_bo_operatorIAOPla(((IA_ConstDI<u_char> *)rhs.bdip)->value,lhs);
	} else {
	    return iter_iter_bo_operatorIAOPla(lhs,rhs);
	}
    }
}

//////////////////////////////////////////////////////////////////////
//
// Begin operation support routines for :
// binary pointwise commutative operator&& I(u_char) int I(u_char)
//
#ifndef vec_scalar_u_char_u_char_int_operatorIAOPla
#define vec_scalar_u_char_u_char_int_operatorIAOPla
static IA_UcharDiscreteImage
vec_scalar_bo_operatorIAOPla(const IA_VectorDI<u_char> *lhs,int rhs)
{
    const IA_IntPointSet domain = lhs->domain();
    const unsigned sz = domain.card();
    u_char *const vec = new u_char[sz];

    {
	u_char *ds = vec;
	const u_char *ls = lhs->vec;
	for (unsigned i=0; i<sz; i++) {
	    *(ds++) = ( (*(ls++)) && (rhs) );
	}
    }
    return IA_UcharDiscreteImage(domain, vec, sz, 1);
}
#endif // vec_scalar_u_char_u_char_int_operatorIAOPla

// scalar-scalar operation is trivial

#ifndef iter_scalar_u_char_u_char_int_operatorIAOPla
#define iter_scalar_u_char_u_char_int_operatorIAOPla
static IA_UcharDiscreteImage
iter_scalar_bo_operatorIAOPla(IA_UcharDiscreteImage lhs,int rhs)
{
    const IA_IntPointSet domain = lhs.domain();
    const unsigned sz = domain.card();
    u_char *const vec = new u_char[sz];

    {
	u_char *ds = vec;
	u_char ltmp;
	IA_DIVIter<u_char>	liter(lhs);
	for (unsigned i=0; i<sz; i++) {
	    liter(ltmp);
	    *(ds++) = ( (ltmp) && (rhs) );
	}
    }
    return IA_UcharDiscreteImage(domain, vec, sz, 1);
}
#endif // iter_scalar_u_char_u_char_int_operatorIAOPla

IA_UcharDiscreteImage
operator&& ( const IA_UcharDiscreteImage &lhs, int rhs)
{
    if (lhs.type() == IA_VectorDI<u_char>::s_type()) {
	return vec_scalar_bo_operatorIAOPla((IA_VectorDI<u_char> *)lhs.bdip,rhs);
    } else if (lhs.type() == IA_ConstDI<u_char>::s_type()) {
	return IA_UcharDiscreteImage (lhs.domain(), (((IA_ConstDI<u_char> *)lhs.bdip)->value) && (rhs));
    } else {
	return iter_scalar_bo_operatorIAOPla(lhs,rhs);
    }
}

//////////////////////////////////////////////////////////////////////
//
// Begin operation support routines for :
// binary pointwise commutative operator|| I(u_char) I(u_char) I(u_char)
//
static IA_UcharDiscreteImage
vec_vec_bo_operatorIAOPlo(const IA_VectorDI<u_char> *lhs,const IA_VectorDI<u_char> *rhs)
{
    const IA_IntPointSet domain = lhs->domain();
    const unsigned sz = domain.card();
    u_char *const vec = new u_char[sz];

    {
	u_char *ds = vec;
	const u_char *ls = lhs->vec;
	const u_char *rs = rhs->vec;
	for (unsigned i=0; i<sz; i++) {
	    *(ds++) = ( (*(ls++)) || (*(rs++)) );
	}
    }
    return IA_UcharDiscreteImage(domain, vec, sz, 1);
}

#ifndef vec_scalar_u_char_u_char_u_char_operatorIAOPlo
#define vec_scalar_u_char_u_char_u_char_operatorIAOPlo
static IA_UcharDiscreteImage
vec_scalar_bo_operatorIAOPlo(const IA_VectorDI<u_char> *lhs,u_char rhs)
{
    const IA_IntPointSet domain = lhs->domain();
    const unsigned sz = domain.card();
    u_char *const vec = new u_char[sz];

    {
	u_char *ds = vec;
	const u_char *ls = lhs->vec;
	for (unsigned i=0; i<sz; i++) {
	    *(ds++) = ( (*(ls++)) || (rhs) );
	}
    }
    return IA_UcharDiscreteImage(domain, vec, sz, 1);
}
#endif // vec_scalar_u_char_u_char_u_char_operatorIAOPlo

static IA_UcharDiscreteImage
vec_iter_bo_operatorIAOPlo(const IA_VectorDI<u_char> *lhs,IA_UcharDiscreteImage rhs)
{
    const IA_IntPointSet domain = lhs->domain();
    const unsigned sz = domain.card();
    u_char *const vec = new u_char[sz];

    {
	u_char *ds = vec;
	const u_char *ls = lhs->vec;
	u_char rtmp;
	IA_DIVIter<u_char>	riter(rhs);
	for (unsigned i=0; i<sz; i++) {
	    riter(rtmp);
	    *(ds++) = ( (*(ls++)) || (rtmp) );
	}
    }
    return IA_UcharDiscreteImage(domain, vec, sz, 1);
}

// scalar-scalar operation is trivial

#ifndef scalar_iter_u_char_u_char_u_char_operatorIAOPlo
#define scalar_iter_u_char_u_char_u_char_operatorIAOPlo
static IA_UcharDiscreteImage
scalar_iter_bo_operatorIAOPlo(u_char lhs,IA_UcharDiscreteImage rhs)
{
    const IA_IntPointSet domain = rhs.domain();
    const unsigned sz = domain.card();
    u_char *const vec = new u_char[sz];

    {
	u_char *ds = vec;
	u_char rtmp;
	IA_DIVIter<u_char>	riter(rhs);
	for (unsigned i=0; i<sz; i++) {
	    riter(rtmp);
	    *(ds++) = ( (lhs) || (rtmp) );
	}
    }
    return IA_UcharDiscreteImage(domain, vec, sz, 1);
}
#endif // scalar_iter_u_char_u_char_u_char_operatorIAOPlo

static IA_UcharDiscreteImage
iter_iter_bo_operatorIAOPlo(IA_UcharDiscreteImage lhs,IA_UcharDiscreteImage rhs)
{
    const IA_IntPointSet domain = lhs.domain();
    const unsigned sz = domain.card();
    u_char *const vec = new u_char[sz];

    {
	u_char *ds = vec;
	u_char ltmp;
	IA_DIVIter<u_char>	liter(lhs);
	u_char rtmp;
	IA_DIVIter<u_char>	riter(rhs);
	for (unsigned i=0; i<sz; i++) {
	    liter(ltmp);
	    riter(rtmp);
	    *(ds++) = ( (ltmp) || (rtmp) );
	}
    }
    return IA_UcharDiscreteImage(domain, vec, sz, 1);
}

IA_UcharDiscreteImage
operator|| ( const IA_UcharDiscreteImage &lhs,
	      const IA_UcharDiscreteImage &rhs)
{
    if (lhs.domain() != rhs.domain()) {
	static IA_UcharDiscreteImage	rval;
	ia_throw( IA::PSET_MISMATCH, __FILE__,__LINE__);
	return rval;
    }

    if (lhs.type() == IA_VectorDI<u_char>::s_type()) {
	if (rhs.type() == IA_VectorDI<u_char>::s_type()) {
	    return vec_vec_bo_operatorIAOPlo((IA_VectorDI<u_char> *)lhs.bdip,(IA_VectorDI<u_char> *)rhs.bdip);
	} else if (rhs.type() == IA_ConstDI<u_char>::s_type()) {
	    return vec_scalar_bo_operatorIAOPlo((IA_VectorDI<u_char> *)lhs.bdip,((IA_ConstDI<u_char> *)rhs.bdip)->value);
	} else {
	    return vec_iter_bo_operatorIAOPlo((IA_VectorDI<u_char> *)lhs.bdip,rhs);
	}
    } else if (lhs.type() == IA_ConstDI<u_char>::s_type()) {
	if (rhs.type() == IA_VectorDI<u_char>::s_type()) {
	    return vec_scalar_bo_operatorIAOPlo((IA_VectorDI<u_char> *)rhs.bdip,((IA_ConstDI<u_char> *)lhs.bdip)->value);
	} else if (rhs.type() == IA_ConstDI<u_char>::s_type()) {
	    return IA_UcharDiscreteImage (lhs.domain(), (((IA_ConstDI<u_char> *)lhs.bdip)->value) || (((IA_ConstDI<u_char> *)rhs.bdip)->value));
	} else {
	    return scalar_iter_bo_operatorIAOPlo(((IA_ConstDI<u_char> *)lhs.bdip)->value,rhs);
	}
    } else {
	if (rhs.type() == IA_VectorDI<u_char>::s_type()) {
	    return vec_iter_bo_operatorIAOPlo((IA_VectorDI<u_char> *)rhs.bdip,lhs);
	} else if (rhs.type() == IA_ConstDI<u_char>::s_type()) {
	    return scalar_iter_bo_operatorIAOPlo(((IA_ConstDI<u_char> *)rhs.bdip)->value,lhs);
	} else {
	    return iter_iter_bo_operatorIAOPlo(lhs,rhs);
	}
    }
}

//////////////////////////////////////////////////////////////////////
//
// Begin operation support routines for :
// binary pointwise commutative operator|| I(u_char) int I(u_char)
//
#ifndef vec_scalar_u_char_u_char_int_operatorIAOPlo
#define vec_scalar_u_char_u_char_int_operatorIAOPlo
static IA_UcharDiscreteImage
vec_scalar_bo_operatorIAOPlo(const IA_VectorDI<u_char> *lhs,int rhs)
{
    const IA_IntPointSet domain = lhs->domain();
    const unsigned sz = domain.card();
    u_char *const vec = new u_char[sz];

    {
	u_char *ds = vec;
	const u_char *ls = lhs->vec;
	for (unsigned i=0; i<sz; i++) {
	    *(ds++) = ( (*(ls++)) || (rhs) );
	}
    }
    return IA_UcharDiscreteImage(domain, vec, sz, 1);
}
#endif // vec_scalar_u_char_u_char_int_operatorIAOPlo

// scalar-scalar operation is trivial

#ifndef iter_scalar_u_char_u_char_int_operatorIAOPlo
#define iter_scalar_u_char_u_char_int_operatorIAOPlo
static IA_UcharDiscreteImage
iter_scalar_bo_operatorIAOPlo(IA_UcharDiscreteImage lhs,int rhs)
{
    const IA_IntPointSet domain = lhs.domain();
    const unsigned sz = domain.card();
    u_char *const vec = new u_char[sz];

    {
	u_char *ds = vec;
	u_char ltmp;
	IA_DIVIter<u_char>	liter(lhs);
	for (unsigned i=0; i<sz; i++) {
	    liter(ltmp);
	    *(ds++) = ( (ltmp) || (rhs) );
	}
    }
    return IA_UcharDiscreteImage(domain, vec, sz, 1);
}
#endif // iter_scalar_u_char_u_char_int_operatorIAOPlo

IA_UcharDiscreteImage
operator|| ( const IA_UcharDiscreteImage &lhs, int rhs)
{
    if (lhs.type() == IA_VectorDI<u_char>::s_type()) {
	return vec_scalar_bo_operatorIAOPlo((IA_VectorDI<u_char> *)lhs.bdip,rhs);
    } else if (lhs.type() == IA_ConstDI<u_char>::s_type()) {
	return IA_UcharDiscreteImage (lhs.domain(), (((IA_ConstDI<u_char> *)lhs.bdip)->value) || (rhs));
    } else {
	return iter_scalar_bo_operatorIAOPlo(lhs,rhs);
    }
}

//////////////////////////////////////////////////////////////////////
//
// Begin operation support routines for :
// unary pointwise operator! I(u_char) I(u_char)
//
// Emacs: -*- C++ -*-

//
//	Copyright 1993, Center for Computer Vision and Visualization,
//	University of Florida.  All rights reserved.
//


//
// $Log:	unary-op.templ,v $
// Revision 1.2  93/05/27  11:49:04  thoth
// Copyright Notices
// 
// Revision 1.1  93/03/10  13:50:00  thoth
// Initial revision
// 

#ifndef vec_scalar_u_char_u_char_operatorIAOPno
#define vec_scalar_u_char_u_char_operatorIAOPno
static IA_UcharDiscreteImage
vec_uo_operatorIAOPno(const IA_VectorDI<u_char> *lhs)
{
    const IA_IntPointSet domain = lhs->domain();
    const unsigned sz = domain.card();
    u_char *const vec = new u_char[sz];

    {
	u_char *ds = vec;
	const u_char *ls = lhs->vec;
	for (unsigned i=0; i<sz; i++) {
	    *(ds++) = !(*(ls++));
	}
    }
    return IA_UcharDiscreteImage(domain, vec, sz, 1);
}
#endif // vec_scalar_u_char_u_char_operatorIAOPno

// scalar-scalar operation is trivial

#ifndef iter_scalar_u_char_u_char_operatorIAOPno
#define iter_scalar_u_char_u_char_operatorIAOPno
static IA_UcharDiscreteImage
iter_uo_operatorIAOPno(IA_UcharDiscreteImage lhs)
{
    const IA_IntPointSet domain = lhs.domain();
    const unsigned sz = domain.card();
    u_char *const vec = new u_char[sz];

    {
	u_char *ds = vec;
	u_char ltmp;
	IA_DIVIter<u_char>	liter(lhs);
	for (unsigned i=0; i<sz; i++) {
	    liter(ltmp);
	    *(ds++) = !(ltmp);
	}
    }
    return IA_UcharDiscreteImage(domain, vec, sz, 1);
}
#endif // iter_scalar_u_char_u_char_operatorIAOPno

IA_UcharDiscreteImage
operator! ( const IA_UcharDiscreteImage &arg)
{
    if (arg.type() == IA_VectorDI<u_char>::s_type()) {
	return vec_uo_operatorIAOPno((IA_VectorDI<u_char> *)arg.bdip);
    } else if (arg.type() == IA_ConstDI<u_char>::s_type()) {
	return IA_UcharDiscreteImage (arg.domain(), !(((IA_ConstDI<u_char> *)arg.bdip)->value));
    } else {
	return iter_uo_operatorIAOPno(arg);
    }
}

//////////////////////////////////////////////////////////////////////
//
// Begin operation support routines for :
// binary strictrel non-commutative operator< I(u_char) I(u_char) int
//
int vec_vec_bo_operatorIAOPlt(const IA_VectorDI<u_char> *lhs,const IA_VectorDI<u_char> *rhs)
{
    const IA_IntPointSet domain = lhs->domain();
    const unsigned sz = domain.card();
    int *const vec = new int[sz];

    {
	int *ds = vec;
	const u_char *ls = lhs->vec;
	const u_char *rs = rhs->vec;
	for (unsigned i=0; i<sz; i++) {
	    if (!( (*(ls++)) < (*(rs++)) ))
		return 0;
	}
    }
    return 1;
}

#ifndef vec_scalar_int_u_char_u_char_operatorIAOPlt
#define vec_scalar_int_u_char_u_char_operatorIAOPlt
int vec_scalar_bo_operatorIAOPlt(const IA_VectorDI<u_char> *lhs,u_char rhs)
{
    const IA_IntPointSet domain = lhs->domain();
    const unsigned sz = domain.card();
    int *const vec = new int[sz];

    {
	int *ds = vec;
	const u_char *ls = lhs->vec;
	for (unsigned i=0; i<sz; i++) {
	    if (!( (*(ls++)) < (rhs) ))
		return 0;
	}
    }
    return 1;
}
#endif // vec_scalar_int_u_char_u_char_operatorIAOPlt

int vec_iter_bo_operatorIAOPlt(const IA_VectorDI<u_char> *lhs,IA_UcharDiscreteImage rhs)
{
    const IA_IntPointSet domain = lhs->domain();
    const unsigned sz = domain.card();
    int *const vec = new int[sz];

    {
	int *ds = vec;
	const u_char *ls = lhs->vec;
	u_char rtmp;
	IA_DIVIter<u_char>	riter(rhs);
	for (unsigned i=0; i<sz; i++) {
	    riter(rtmp);
	    if (!( (*(ls++)) < (rtmp) ))
		return 0;
	}
    }
    return 1;
}

#ifndef scalar_vec_int_u_char_u_char_operatorIAOPlt
#define scalar_vec_int_u_char_u_char_operatorIAOPlt
int scalar_vec_bo_operatorIAOPlt(u_char lhs,const IA_VectorDI<u_char> *rhs)
{
    const IA_IntPointSet domain = rhs->domain();
    const unsigned sz = domain.card();
    int *const vec = new int[sz];

    {
	int *ds = vec;
	const u_char *rs = rhs->vec;
	for (unsigned i=0; i<sz; i++) {
	    if (!( (lhs) < (*(rs++)) ))
		return 0;
	}
    }
    return 1;
}
#endif // scalar_vec_int_u_char_u_char_operatorIAOPlt

// scalar-scalar operation is trivial

#ifndef scalar_iter_int_u_char_u_char_operatorIAOPlt
#define scalar_iter_int_u_char_u_char_operatorIAOPlt
int scalar_iter_bo_operatorIAOPlt(u_char lhs,IA_UcharDiscreteImage rhs)
{
    const IA_IntPointSet domain = rhs.domain();
    const unsigned sz = domain.card();
    int *const vec = new int[sz];

    {
	int *ds = vec;
	u_char rtmp;
	IA_DIVIter<u_char>	riter(rhs);
	for (unsigned i=0; i<sz; i++) {
	    riter(rtmp);
	    if (!( (lhs) < (rtmp) ))
		return 0;
	}
    }
    return 1;
}
#endif // scalar_iter_int_u_char_u_char_operatorIAOPlt

int iter_vec_bo_operatorIAOPlt(IA_UcharDiscreteImage lhs,const IA_VectorDI<u_char> *rhs)
{
    const IA_IntPointSet domain = lhs.domain();
    const unsigned sz = domain.card();
    int *const vec = new int[sz];

    {
	int *ds = vec;
	u_char ltmp;
	IA_DIVIter<u_char>	liter(lhs);
	const u_char *rs = rhs->vec;
	for (unsigned i=0; i<sz; i++) {
	    liter(ltmp);
	    if (!( (ltmp) < (*(rs++)) ))
		return 0;
	}
    }
    return 1;
}

#ifndef iter_scalar_int_u_char_u_char_operatorIAOPlt
#define iter_scalar_int_u_char_u_char_operatorIAOPlt
int iter_scalar_bo_operatorIAOPlt(IA_UcharDiscreteImage lhs,u_char rhs)
{
    const IA_IntPointSet domain = lhs.domain();
    const unsigned sz = domain.card();
    int *const vec = new int[sz];

    {
	int *ds = vec;
	u_char ltmp;
	IA_DIVIter<u_char>	liter(lhs);
	for (unsigned i=0; i<sz; i++) {
	    liter(ltmp);
	    if (!( (ltmp) < (rhs) ))
		return 0;
	}
    }
    return 1;
}
#endif // iter_scalar_int_u_char_u_char_operatorIAOPlt

int iter_iter_bo_operatorIAOPlt(IA_UcharDiscreteImage lhs,IA_UcharDiscreteImage rhs)
{
    const IA_IntPointSet domain = lhs.domain();
    const unsigned sz = domain.card();
    int *const vec = new int[sz];

    {
	int *ds = vec;
	u_char ltmp;
	IA_DIVIter<u_char>	liter(lhs);
	u_char rtmp;
	IA_DIVIter<u_char>	riter(rhs);
	for (unsigned i=0; i<sz; i++) {
	    liter(ltmp);
	    riter(rtmp);
	    if (!( (ltmp) < (rtmp) ))
		return 0;
	}
    }
    return 1;
}

int operator< ( const IA_UcharDiscreteImage &lhs,
	      const IA_UcharDiscreteImage &rhs)
{
    if (lhs.domain() != rhs.domain()) {
	static int	rval;
	ia_throw( IA::PSET_MISMATCH, __FILE__,__LINE__);
	return rval;
    }

    if (lhs.type() == IA_VectorDI<u_char>::s_type()) {
	if (rhs.type() == IA_VectorDI<u_char>::s_type()) {
	    return vec_vec_bo_operatorIAOPlt((IA_VectorDI<u_char> *)lhs.bdip,(IA_VectorDI<u_char> *)rhs.bdip);
	} else if (rhs.type() == IA_ConstDI<u_char>::s_type()) {
	    return vec_scalar_bo_operatorIAOPlt((IA_VectorDI<u_char> *)lhs.bdip,((IA_ConstDI<u_char> *)rhs.bdip)->value);
	} else {
	    return vec_iter_bo_operatorIAOPlt((IA_VectorDI<u_char> *)lhs.bdip,rhs);
	}
    } else if (lhs.type() == IA_ConstDI<u_char>::s_type()) {
	if (rhs.type() == IA_VectorDI<u_char>::s_type()) {
	    return scalar_vec_bo_operatorIAOPlt(((IA_ConstDI<u_char> *)lhs.bdip)->value,(IA_VectorDI<u_char> *)rhs.bdip);
	} else if (rhs.type() == IA_ConstDI<u_char>::s_type()) {
	    return (((IA_ConstDI<u_char> *)lhs.bdip)->value) < (((IA_ConstDI<u_char> *)rhs.bdip)->value);
	} else {
	    return scalar_iter_bo_operatorIAOPlt(((IA_ConstDI<u_char> *)lhs.bdip)->value,rhs);
	}
    } else {
	if (rhs.type() == IA_VectorDI<u_char>::s_type()) {
	    return iter_vec_bo_operatorIAOPlt(lhs,(IA_VectorDI<u_char> *)rhs.bdip);
	} else if (rhs.type() == IA_ConstDI<u_char>::s_type()) {
	    return iter_scalar_bo_operatorIAOPlt(lhs,((IA_ConstDI<u_char> *)rhs.bdip)->value);
	} else {
	    return iter_iter_bo_operatorIAOPlt(lhs,rhs);
	}
    }
}

//////////////////////////////////////////////////////////////////////
//
// Begin operation support routines for :
// binary strictrel non-commutative operator< I(u_char) int int
//
#ifndef vec_scalar_int_u_char_int_operatorIAOPlt
#define vec_scalar_int_u_char_int_operatorIAOPlt
int vec_scalar_bo_operatorIAOPlt(const IA_VectorDI<u_char> *lhs,int rhs)
{
    const IA_IntPointSet domain = lhs->domain();
    const unsigned sz = domain.card();
    int *const vec = new int[sz];

    {
	int *ds = vec;
	const u_char *ls = lhs->vec;
	for (unsigned i=0; i<sz; i++) {
	    if (!( (*(ls++)) < (rhs) ))
		return 0;
	}
    }
    return 1;
}
#endif // vec_scalar_int_u_char_int_operatorIAOPlt

// scalar-scalar operation is trivial

#ifndef iter_scalar_int_u_char_int_operatorIAOPlt
#define iter_scalar_int_u_char_int_operatorIAOPlt
int iter_scalar_bo_operatorIAOPlt(IA_UcharDiscreteImage lhs,int rhs)
{
    const IA_IntPointSet domain = lhs.domain();
    const unsigned sz = domain.card();
    int *const vec = new int[sz];

    {
	int *ds = vec;
	u_char ltmp;
	IA_DIVIter<u_char>	liter(lhs);
	for (unsigned i=0; i<sz; i++) {
	    liter(ltmp);
	    if (!( (ltmp) < (rhs) ))
		return 0;
	}
    }
    return 1;
}
#endif // iter_scalar_int_u_char_int_operatorIAOPlt

int operator< ( const IA_UcharDiscreteImage &lhs, int rhs)
{
    if (lhs.type() == IA_VectorDI<u_char>::s_type()) {
	return vec_scalar_bo_operatorIAOPlt((IA_VectorDI<u_char> *)lhs.bdip,rhs);
    } else if (lhs.type() == IA_ConstDI<u_char>::s_type()) {
	return (((IA_ConstDI<u_char> *)lhs.bdip)->value) < (rhs);
    } else {
	return iter_scalar_bo_operatorIAOPlt(lhs,rhs);
    }
}

//////////////////////////////////////////////////////////////////////
//
// Begin operation support routines for :
// binary strictrel non-commutative operator< int I(u_char) int
//
#ifndef scalar_vec_int_int_u_char_operatorIAOPlt
#define scalar_vec_int_int_u_char_operatorIAOPlt
int scalar_vec_bo_operatorIAOPlt(int lhs,const IA_VectorDI<u_char> *rhs)
{
    const IA_IntPointSet domain = rhs->domain();
    const unsigned sz = domain.card();
    int *const vec = new int[sz];

    {
	int *ds = vec;
	const u_char *rs = rhs->vec;
	for (unsigned i=0; i<sz; i++) {
	    if (!( (lhs) < (*(rs++)) ))
		return 0;
	}
    }
    return 1;
}
#endif // scalar_vec_int_int_u_char_operatorIAOPlt

// scalar-scalar operation is trivial

#ifndef scalar_iter_int_int_u_char_operatorIAOPlt
#define scalar_iter_int_int_u_char_operatorIAOPlt
int scalar_iter_bo_operatorIAOPlt(int lhs,IA_UcharDiscreteImage rhs)
{
    const IA_IntPointSet domain = rhs.domain();
    const unsigned sz = domain.card();
    int *const vec = new int[sz];

    {
	int *ds = vec;
	u_char rtmp;
	IA_DIVIter<u_char>	riter(rhs);
	for (unsigned i=0; i<sz; i++) {
	    riter(rtmp);
	    if (!( (lhs) < (rtmp) ))
		return 0;
	}
    }
    return 1;
}
#endif // scalar_iter_int_int_u_char_operatorIAOPlt

int operator< (int lhs, const IA_UcharDiscreteImage &rhs)
{
    if (rhs.type() == IA_VectorDI<u_char>::s_type()) {
	return scalar_vec_bo_operatorIAOPlt(lhs,(IA_VectorDI<u_char> *)rhs.bdip);
    } else if (rhs.type() == IA_ConstDI<u_char>::s_type()) {
	return (lhs) < (((IA_ConstDI<u_char> *)rhs.bdip)->value);
    } else {
	return scalar_iter_bo_operatorIAOPlt(lhs,rhs);
    }
}

//////////////////////////////////////////////////////////////////////
//
// Begin operation support routines for :
// binary strictrel non-commutative operator<= I(u_char) I(u_char) int
//
int vec_vec_bo_operatorIAOPle(const IA_VectorDI<u_char> *lhs,const IA_VectorDI<u_char> *rhs)
{
    const IA_IntPointSet domain = lhs->domain();
    const unsigned sz = domain.card();
    int *const vec = new int[sz];

    {
	int *ds = vec;
	const u_char *ls = lhs->vec;
	const u_char *rs = rhs->vec;
	for (unsigned i=0; i<sz; i++) {
	    if (!( (*(ls++)) <= (*(rs++)) ))
		return 0;
	}
    }
    return 1;
}

#ifndef vec_scalar_int_u_char_u_char_operatorIAOPle
#define vec_scalar_int_u_char_u_char_operatorIAOPle
int vec_scalar_bo_operatorIAOPle(const IA_VectorDI<u_char> *lhs,u_char rhs)
{
    const IA_IntPointSet domain = lhs->domain();
    const unsigned sz = domain.card();
    int *const vec = new int[sz];

    {
	int *ds = vec;
	const u_char *ls = lhs->vec;
	for (unsigned i=0; i<sz; i++) {
	    if (!( (*(ls++)) <= (rhs) ))
		return 0;
	}
    }
    return 1;
}
#endif // vec_scalar_int_u_char_u_char_operatorIAOPle

int vec_iter_bo_operatorIAOPle(const IA_VectorDI<u_char> *lhs,IA_UcharDiscreteImage rhs)
{
    const IA_IntPointSet domain = lhs->domain();
    const unsigned sz = domain.card();
    int *const vec = new int[sz];

    {
	int *ds = vec;
	const u_char *ls = lhs->vec;
	u_char rtmp;
	IA_DIVIter<u_char>	riter(rhs);
	for (unsigned i=0; i<sz; i++) {
	    riter(rtmp);
	    if (!( (*(ls++)) <= (rtmp) ))
		return 0;
	}
    }
    return 1;
}

#ifndef scalar_vec_int_u_char_u_char_operatorIAOPle
#define scalar_vec_int_u_char_u_char_operatorIAOPle
int scalar_vec_bo_operatorIAOPle(u_char lhs,const IA_VectorDI<u_char> *rhs)
{
    const IA_IntPointSet domain = rhs->domain();
    const unsigned sz = domain.card();
    int *const vec = new int[sz];

    {
	int *ds = vec;
	const u_char *rs = rhs->vec;
	for (unsigned i=0; i<sz; i++) {
	    if (!( (lhs) <= (*(rs++)) ))
		return 0;
	}
    }
    return 1;
}
#endif // scalar_vec_int_u_char_u_char_operatorIAOPle

// scalar-scalar operation is trivial

#ifndef scalar_iter_int_u_char_u_char_operatorIAOPle
#define scalar_iter_int_u_char_u_char_operatorIAOPle
int scalar_iter_bo_operatorIAOPle(u_char lhs,IA_UcharDiscreteImage rhs)
{
    const IA_IntPointSet domain = rhs.domain();
    const unsigned sz = domain.card();
    int *const vec = new int[sz];

    {
	int *ds = vec;
	u_char rtmp;
	IA_DIVIter<u_char>	riter(rhs);
	for (unsigned i=0; i<sz; i++) {
	    riter(rtmp);
	    if (!( (lhs) <= (rtmp) ))
		return 0;
	}
    }
    return 1;
}
#endif // scalar_iter_int_u_char_u_char_operatorIAOPle

int iter_vec_bo_operatorIAOPle(IA_UcharDiscreteImage lhs,const IA_VectorDI<u_char> *rhs)
{
    const IA_IntPointSet domain = lhs.domain();
    const unsigned sz = domain.card();
    int *const vec = new int[sz];

    {
	int *ds = vec;
	u_char ltmp;
	IA_DIVIter<u_char>	liter(lhs);
	const u_char *rs = rhs->vec;
	for (unsigned i=0; i<sz; i++) {
	    liter(ltmp);
	    if (!( (ltmp) <= (*(rs++)) ))
		return 0;
	}
    }
    return 1;
}

#ifndef iter_scalar_int_u_char_u_char_operatorIAOPle
#define iter_scalar_int_u_char_u_char_operatorIAOPle
int iter_scalar_bo_operatorIAOPle(IA_UcharDiscreteImage lhs,u_char rhs)
{
    const IA_IntPointSet domain = lhs.domain();
    const unsigned sz = domain.card();
    int *const vec = new int[sz];

    {
	int *ds = vec;
	u_char ltmp;
	IA_DIVIter<u_char>	liter(lhs);
	for (unsigned i=0; i<sz; i++) {
	    liter(ltmp);
	    if (!( (ltmp) <= (rhs) ))
		return 0;
	}
    }
    return 1;
}
#endif // iter_scalar_int_u_char_u_char_operatorIAOPle

int iter_iter_bo_operatorIAOPle(IA_UcharDiscreteImage lhs,IA_UcharDiscreteImage rhs)
{
    const IA_IntPointSet domain = lhs.domain();
    const unsigned sz = domain.card();
    int *const vec = new int[sz];

    {
	int *ds = vec;
	u_char ltmp;
	IA_DIVIter<u_char>	liter(lhs);
	u_char rtmp;
	IA_DIVIter<u_char>	riter(rhs);
	for (unsigned i=0; i<sz; i++) {
	    liter(ltmp);
	    riter(rtmp);
	    if (!( (ltmp) <= (rtmp) ))
		return 0;
	}
    }
    return 1;
}

int operator<= ( const IA_UcharDiscreteImage &lhs,
	      const IA_UcharDiscreteImage &rhs)
{
    if (lhs.domain() != rhs.domain()) {
	static int	rval;
	ia_throw( IA::PSET_MISMATCH, __FILE__,__LINE__);
	return rval;
    }

    if (lhs.type() == IA_VectorDI<u_char>::s_type()) {
	if (rhs.type() == IA_VectorDI<u_char>::s_type()) {
	    return vec_vec_bo_operatorIAOPle((IA_VectorDI<u_char> *)lhs.bdip,(IA_VectorDI<u_char> *)rhs.bdip);
	} else if (rhs.type() == IA_ConstDI<u_char>::s_type()) {
	    return vec_scalar_bo_operatorIAOPle((IA_VectorDI<u_char> *)lhs.bdip,((IA_ConstDI<u_char> *)rhs.bdip)->value);
	} else {
	    return vec_iter_bo_operatorIAOPle((IA_VectorDI<u_char> *)lhs.bdip,rhs);
	}
    } else if (lhs.type() == IA_ConstDI<u_char>::s_type()) {
	if (rhs.type() == IA_VectorDI<u_char>::s_type()) {
	    return scalar_vec_bo_operatorIAOPle(((IA_ConstDI<u_char> *)lhs.bdip)->value,(IA_VectorDI<u_char> *)rhs.bdip);
	} else if (rhs.type() == IA_ConstDI<u_char>::s_type()) {
	    return (((IA_ConstDI<u_char> *)lhs.bdip)->value) <= (((IA_ConstDI<u_char> *)rhs.bdip)->value);
	} else {
	    return scalar_iter_bo_operatorIAOPle(((IA_ConstDI<u_char> *)lhs.bdip)->value,rhs);
	}
    } else {
	if (rhs.type() == IA_VectorDI<u_char>::s_type()) {
	    return iter_vec_bo_operatorIAOPle(lhs,(IA_VectorDI<u_char> *)rhs.bdip);
	} else if (rhs.type() == IA_ConstDI<u_char>::s_type()) {
	    return iter_scalar_bo_operatorIAOPle(lhs,((IA_ConstDI<u_char> *)rhs.bdip)->value);
	} else {
	    return iter_iter_bo_operatorIAOPle(lhs,rhs);
	}
    }
}

//////////////////////////////////////////////////////////////////////
//
// Begin operation support routines for :
// binary strictrel non-commutative operator<= I(u_char) int int
//
#ifndef vec_scalar_int_u_char_int_operatorIAOPle
#define vec_scalar_int_u_char_int_operatorIAOPle
int vec_scalar_bo_operatorIAOPle(const IA_VectorDI<u_char> *lhs,int rhs)
{
    const IA_IntPointSet domain = lhs->domain();
    const unsigned sz = domain.card();
    int *const vec = new int[sz];

    {
	int *ds = vec;
	const u_char *ls = lhs->vec;
	for (unsigned i=0; i<sz; i++) {
	    if (!( (*(ls++)) <= (rhs) ))
		return 0;
	}
    }
    return 1;
}
#endif // vec_scalar_int_u_char_int_operatorIAOPle

// scalar-scalar operation is trivial

#ifndef iter_scalar_int_u_char_int_operatorIAOPle
#define iter_scalar_int_u_char_int_operatorIAOPle
int iter_scalar_bo_operatorIAOPle(IA_UcharDiscreteImage lhs,int rhs)
{
    const IA_IntPointSet domain = lhs.domain();
    const unsigned sz = domain.card();
    int *const vec = new int[sz];

    {
	int *ds = vec;
	u_char ltmp;
	IA_DIVIter<u_char>	liter(lhs);
	for (unsigned i=0; i<sz; i++) {
	    liter(ltmp);
	    if (!( (ltmp) <= (rhs) ))
		return 0;
	}
    }
    return 1;
}
#endif // iter_scalar_int_u_char_int_operatorIAOPle

int operator<= ( const IA_UcharDiscreteImage &lhs, int rhs)
{
    if (lhs.type() == IA_VectorDI<u_char>::s_type()) {
	return vec_scalar_bo_operatorIAOPle((IA_VectorDI<u_char> *)lhs.bdip,rhs);
    } else if (lhs.type() == IA_ConstDI<u_char>::s_type()) {
	return (((IA_ConstDI<u_char> *)lhs.bdip)->value) <= (rhs);
    } else {
	return iter_scalar_bo_operatorIAOPle(lhs,rhs);
    }
}

//////////////////////////////////////////////////////////////////////
//
// Begin operation support routines for :
// binary strictrel non-commutative operator<= int I(u_char) int
//
#ifndef scalar_vec_int_int_u_char_operatorIAOPle
#define scalar_vec_int_int_u_char_operatorIAOPle
int scalar_vec_bo_operatorIAOPle(int lhs,const IA_VectorDI<u_char> *rhs)
{
    const IA_IntPointSet domain = rhs->domain();
    const unsigned sz = domain.card();
    int *const vec = new int[sz];

    {
	int *ds = vec;
	const u_char *rs = rhs->vec;
	for (unsigned i=0; i<sz; i++) {
	    if (!( (lhs) <= (*(rs++)) ))
		return 0;
	}
    }
    return 1;
}
#endif // scalar_vec_int_int_u_char_operatorIAOPle

// scalar-scalar operation is trivial

#ifndef scalar_iter_int_int_u_char_operatorIAOPle
#define scalar_iter_int_int_u_char_operatorIAOPle
int scalar_iter_bo_operatorIAOPle(int lhs,IA_UcharDiscreteImage rhs)
{
    const IA_IntPointSet domain = rhs.domain();
    const unsigned sz = domain.card();
    int *const vec = new int[sz];

    {
	int *ds = vec;
	u_char rtmp;
	IA_DIVIter<u_char>	riter(rhs);
	for (unsigned i=0; i<sz; i++) {
	    riter(rtmp);
	    if (!( (lhs) <= (rtmp) ))
		return 0;
	}
    }
    return 1;
}
#endif // scalar_iter_int_int_u_char_operatorIAOPle

int operator<= (int lhs, const IA_UcharDiscreteImage &rhs)
{
    if (rhs.type() == IA_VectorDI<u_char>::s_type()) {
	return scalar_vec_bo_operatorIAOPle(lhs,(IA_VectorDI<u_char> *)rhs.bdip);
    } else if (rhs.type() == IA_ConstDI<u_char>::s_type()) {
	return (lhs) <= (((IA_ConstDI<u_char> *)rhs.bdip)->value);
    } else {
	return scalar_iter_bo_operatorIAOPle(lhs,rhs);
    }
}

//////////////////////////////////////////////////////////////////////
//
// Begin operation support routines for :
// binary strictrel commutative operator== I(u_char) I(u_char) int
//
int vec_vec_bo_operatorIAOPeq(const IA_VectorDI<u_char> *lhs,const IA_VectorDI<u_char> *rhs)
{
    const IA_IntPointSet domain = lhs->domain();
    const unsigned sz = domain.card();
    int *const vec = new int[sz];

    {
	int *ds = vec;
	const u_char *ls = lhs->vec;
	const u_char *rs = rhs->vec;
	for (unsigned i=0; i<sz; i++) {
	    if (!( (*(ls++)) == (*(rs++)) ))
		return 0;
	}
    }
    return 1;
}

#ifndef vec_scalar_int_u_char_u_char_operatorIAOPeq
#define vec_scalar_int_u_char_u_char_operatorIAOPeq
int vec_scalar_bo_operatorIAOPeq(const IA_VectorDI<u_char> *lhs,u_char rhs)
{
    const IA_IntPointSet domain = lhs->domain();
    const unsigned sz = domain.card();
    int *const vec = new int[sz];

    {
	int *ds = vec;
	const u_char *ls = lhs->vec;
	for (unsigned i=0; i<sz; i++) {
	    if (!( (*(ls++)) == (rhs) ))
		return 0;
	}
    }
    return 1;
}
#endif // vec_scalar_int_u_char_u_char_operatorIAOPeq

int vec_iter_bo_operatorIAOPeq(const IA_VectorDI<u_char> *lhs,IA_UcharDiscreteImage rhs)
{
    const IA_IntPointSet domain = lhs->domain();
    const unsigned sz = domain.card();
    int *const vec = new int[sz];

    {
	int *ds = vec;
	const u_char *ls = lhs->vec;
	u_char rtmp;
	IA_DIVIter<u_char>	riter(rhs);
	for (unsigned i=0; i<sz; i++) {
	    riter(rtmp);
	    if (!( (*(ls++)) == (rtmp) ))
		return 0;
	}
    }
    return 1;
}

// scalar-scalar operation is trivial

#ifndef scalar_iter_int_u_char_u_char_operatorIAOPeq
#define scalar_iter_int_u_char_u_char_operatorIAOPeq
int scalar_iter_bo_operatorIAOPeq(u_char lhs,IA_UcharDiscreteImage rhs)
{
    const IA_IntPointSet domain = rhs.domain();
    const unsigned sz = domain.card();
    int *const vec = new int[sz];

    {
	int *ds = vec;
	u_char rtmp;
	IA_DIVIter<u_char>	riter(rhs);
	for (unsigned i=0; i<sz; i++) {
	    riter(rtmp);
	    if (!( (lhs) == (rtmp) ))
		return 0;
	}
    }
    return 1;
}
#endif // scalar_iter_int_u_char_u_char_operatorIAOPeq

int iter_iter_bo_operatorIAOPeq(IA_UcharDiscreteImage lhs,IA_UcharDiscreteImage rhs)
{
    const IA_IntPointSet domain = lhs.domain();
    const unsigned sz = domain.card();
    int *const vec = new int[sz];

    {
	int *ds = vec;
	u_char ltmp;
	IA_DIVIter<u_char>	liter(lhs);
	u_char rtmp;
	IA_DIVIter<u_char>	riter(rhs);
	for (unsigned i=0; i<sz; i++) {
	    liter(ltmp);
	    riter(rtmp);
	    if (!( (ltmp) == (rtmp) ))
		return 0;
	}
    }
    return 1;
}

int operator== ( const IA_UcharDiscreteImage &lhs,
	      const IA_UcharDiscreteImage &rhs)
{
    if (lhs.domain() != rhs.domain()) {
	static int	rval;
	ia_throw( IA::PSET_MISMATCH, __FILE__,__LINE__);
	return rval;
    }

    if (lhs.type() == IA_VectorDI<u_char>::s_type()) {
	if (rhs.type() == IA_VectorDI<u_char>::s_type()) {
	    return vec_vec_bo_operatorIAOPeq((IA_VectorDI<u_char> *)lhs.bdip,(IA_VectorDI<u_char> *)rhs.bdip);
	} else if (rhs.type() == IA_ConstDI<u_char>::s_type()) {
	    return vec_scalar_bo_operatorIAOPeq((IA_VectorDI<u_char> *)lhs.bdip,((IA_ConstDI<u_char> *)rhs.bdip)->value);
	} else {
	    return vec_iter_bo_operatorIAOPeq((IA_VectorDI<u_char> *)lhs.bdip,rhs);
	}
    } else if (lhs.type() == IA_ConstDI<u_char>::s_type()) {
	if (rhs.type() == IA_VectorDI<u_char>::s_type()) {
	    return vec_scalar_bo_operatorIAOPeq((IA_VectorDI<u_char> *)rhs.bdip,((IA_ConstDI<u_char> *)lhs.bdip)->value);
	} else if (rhs.type() == IA_ConstDI<u_char>::s_type()) {
	    return (((IA_ConstDI<u_char> *)lhs.bdip)->value) == (((IA_ConstDI<u_char> *)rhs.bdip)->value);
	} else {
	    return scalar_iter_bo_operatorIAOPeq(((IA_ConstDI<u_char> *)lhs.bdip)->value,rhs);
	}
    } else {
	if (rhs.type() == IA_VectorDI<u_char>::s_type()) {
	    return vec_iter_bo_operatorIAOPeq((IA_VectorDI<u_char> *)rhs.bdip,lhs);
	} else if (rhs.type() == IA_ConstDI<u_char>::s_type()) {
	    return scalar_iter_bo_operatorIAOPeq(((IA_ConstDI<u_char> *)rhs.bdip)->value,lhs);
	} else {
	    return iter_iter_bo_operatorIAOPeq(lhs,rhs);
	}
    }
}

//////////////////////////////////////////////////////////////////////
//
// Begin operation support routines for :
// binary strictrel commutative operator== I(u_char) int int
//
#ifndef vec_scalar_int_u_char_int_operatorIAOPeq
#define vec_scalar_int_u_char_int_operatorIAOPeq
int vec_scalar_bo_operatorIAOPeq(const IA_VectorDI<u_char> *lhs,int rhs)
{
    const IA_IntPointSet domain = lhs->domain();
    const unsigned sz = domain.card();
    int *const vec = new int[sz];

    {
	int *ds = vec;
	const u_char *ls = lhs->vec;
	for (unsigned i=0; i<sz; i++) {
	    if (!( (*(ls++)) == (rhs) ))
		return 0;
	}
    }
    return 1;
}
#endif // vec_scalar_int_u_char_int_operatorIAOPeq

// scalar-scalar operation is trivial

#ifndef iter_scalar_int_u_char_int_operatorIAOPeq
#define iter_scalar_int_u_char_int_operatorIAOPeq
int iter_scalar_bo_operatorIAOPeq(IA_UcharDiscreteImage lhs,int rhs)
{
    const IA_IntPointSet domain = lhs.domain();
    const unsigned sz = domain.card();
    int *const vec = new int[sz];

    {
	int *ds = vec;
	u_char ltmp;
	IA_DIVIter<u_char>	liter(lhs);
	for (unsigned i=0; i<sz; i++) {
	    liter(ltmp);
	    if (!( (ltmp) == (rhs) ))
		return 0;
	}
    }
    return 1;
}
#endif // iter_scalar_int_u_char_int_operatorIAOPeq

int operator== ( const IA_UcharDiscreteImage &lhs, int rhs)
{
    if (lhs.type() == IA_VectorDI<u_char>::s_type()) {
	return vec_scalar_bo_operatorIAOPeq((IA_VectorDI<u_char> *)lhs.bdip,rhs);
    } else if (lhs.type() == IA_ConstDI<u_char>::s_type()) {
	return (((IA_ConstDI<u_char> *)lhs.bdip)->value) == (rhs);
    } else {
	return iter_scalar_bo_operatorIAOPeq(lhs,rhs);
    }
}

//////////////////////////////////////////////////////////////////////
//
// Begin operation support routines for :
// binary strictrel commutative strict_ne subop=operator!= I(u_char) I(u_char) int
//
int vec_vec_bo_strict_ne(const IA_VectorDI<u_char> *lhs,const IA_VectorDI<u_char> *rhs)
{
    const IA_IntPointSet domain = lhs->domain();
    const unsigned sz = domain.card();
    int *const vec = new int[sz];

    {
	int *ds = vec;
	const u_char *ls = lhs->vec;
	const u_char *rs = rhs->vec;
	for (unsigned i=0; i<sz; i++) {
	    if (!( (*(ls++)) != (*(rs++)) ))
		return 0;
	}
    }
    return 1;
}

#ifndef vec_scalar_int_u_char_u_char_strict_ne
#define vec_scalar_int_u_char_u_char_strict_ne
int vec_scalar_bo_strict_ne(const IA_VectorDI<u_char> *lhs,u_char rhs)
{
    const IA_IntPointSet domain = lhs->domain();
    const unsigned sz = domain.card();
    int *const vec = new int[sz];

    {
	int *ds = vec;
	const u_char *ls = lhs->vec;
	for (unsigned i=0; i<sz; i++) {
	    if (!( (*(ls++)) != (rhs) ))
		return 0;
	}
    }
    return 1;
}
#endif // vec_scalar_int_u_char_u_char_strict_ne

int vec_iter_bo_strict_ne(const IA_VectorDI<u_char> *lhs,IA_UcharDiscreteImage rhs)
{
    const IA_IntPointSet domain = lhs->domain();
    const unsigned sz = domain.card();
    int *const vec = new int[sz];

    {
	int *ds = vec;
	const u_char *ls = lhs->vec;
	u_char rtmp;
	IA_DIVIter<u_char>	riter(rhs);
	for (unsigned i=0; i<sz; i++) {
	    riter(rtmp);
	    if (!( (*(ls++)) != (rtmp) ))
		return 0;
	}
    }
    return 1;
}

// scalar-scalar operation is trivial

#ifndef scalar_iter_int_u_char_u_char_strict_ne
#define scalar_iter_int_u_char_u_char_strict_ne
int scalar_iter_bo_strict_ne(u_char lhs,IA_UcharDiscreteImage rhs)
{
    const IA_IntPointSet domain = rhs.domain();
    const unsigned sz = domain.card();
    int *const vec = new int[sz];

    {
	int *ds = vec;
	u_char rtmp;
	IA_DIVIter<u_char>	riter(rhs);
	for (unsigned i=0; i<sz; i++) {
	    riter(rtmp);
	    if (!( (lhs) != (rtmp) ))
		return 0;
	}
    }
    return 1;
}
#endif // scalar_iter_int_u_char_u_char_strict_ne

int iter_iter_bo_strict_ne(IA_UcharDiscreteImage lhs,IA_UcharDiscreteImage rhs)
{
    const IA_IntPointSet domain = lhs.domain();
    const unsigned sz = domain.card();
    int *const vec = new int[sz];

    {
	int *ds = vec;
	u_char ltmp;
	IA_DIVIter<u_char>	liter(lhs);
	u_char rtmp;
	IA_DIVIter<u_char>	riter(rhs);
	for (unsigned i=0; i<sz; i++) {
	    liter(ltmp);
	    riter(rtmp);
	    if (!( (ltmp) != (rtmp) ))
		return 0;
	}
    }
    return 1;
}

int strict_ne ( const IA_UcharDiscreteImage &lhs,
	      const IA_UcharDiscreteImage &rhs)
{
    if (lhs.domain() != rhs.domain()) {
	static int	rval;
	ia_throw( IA::PSET_MISMATCH, __FILE__,__LINE__);
	return rval;
    }

    if (lhs.type() == IA_VectorDI<u_char>::s_type()) {
	if (rhs.type() == IA_VectorDI<u_char>::s_type()) {
	    return vec_vec_bo_strict_ne((IA_VectorDI<u_char> *)lhs.bdip,(IA_VectorDI<u_char> *)rhs.bdip);
	} else if (rhs.type() == IA_ConstDI<u_char>::s_type()) {
	    return vec_scalar_bo_strict_ne((IA_VectorDI<u_char> *)lhs.bdip,((IA_ConstDI<u_char> *)rhs.bdip)->value);
	} else {
	    return vec_iter_bo_strict_ne((IA_VectorDI<u_char> *)lhs.bdip,rhs);
	}
    } else if (lhs.type() == IA_ConstDI<u_char>::s_type()) {
	if (rhs.type() == IA_VectorDI<u_char>::s_type()) {
	    return vec_scalar_bo_strict_ne((IA_VectorDI<u_char> *)rhs.bdip,((IA_ConstDI<u_char> *)lhs.bdip)->value);
	} else if (rhs.type() == IA_ConstDI<u_char>::s_type()) {
	    return (((IA_ConstDI<u_char> *)lhs.bdip)->value) != (((IA_ConstDI<u_char> *)rhs.bdip)->value);
	} else {
	    return scalar_iter_bo_strict_ne(((IA_ConstDI<u_char> *)lhs.bdip)->value,rhs);
	}
    } else {
	if (rhs.type() == IA_VectorDI<u_char>::s_type()) {
	    return vec_iter_bo_strict_ne((IA_VectorDI<u_char> *)rhs.bdip,lhs);
	} else if (rhs.type() == IA_ConstDI<u_char>::s_type()) {
	    return scalar_iter_bo_strict_ne(((IA_ConstDI<u_char> *)rhs.bdip)->value,lhs);
	} else {
	    return iter_iter_bo_strict_ne(lhs,rhs);
	}
    }
}

//////////////////////////////////////////////////////////////////////
//
// Begin operation support routines for :
// binary strictrel commutative strict_ne subop=operator!= I(u_char) int int
//
#ifndef vec_scalar_int_u_char_int_strict_ne
#define vec_scalar_int_u_char_int_strict_ne
int vec_scalar_bo_strict_ne(const IA_VectorDI<u_char> *lhs,int rhs)
{
    const IA_IntPointSet domain = lhs->domain();
    const unsigned sz = domain.card();
    int *const vec = new int[sz];

    {
	int *ds = vec;
	const u_char *ls = lhs->vec;
	for (unsigned i=0; i<sz; i++) {
	    if (!( (*(ls++)) != (rhs) ))
		return 0;
	}
    }
    return 1;
}
#endif // vec_scalar_int_u_char_int_strict_ne

// scalar-scalar operation is trivial

#ifndef iter_scalar_int_u_char_int_strict_ne
#define iter_scalar_int_u_char_int_strict_ne
int iter_scalar_bo_strict_ne(IA_UcharDiscreteImage lhs,int rhs)
{
    const IA_IntPointSet domain = lhs.domain();
    const unsigned sz = domain.card();
    int *const vec = new int[sz];

    {
	int *ds = vec;
	u_char ltmp;
	IA_DIVIter<u_char>	liter(lhs);
	for (unsigned i=0; i<sz; i++) {
	    liter(ltmp);
	    if (!( (ltmp) != (rhs) ))
		return 0;
	}
    }
    return 1;
}
#endif // iter_scalar_int_u_char_int_strict_ne

int strict_ne ( const IA_UcharDiscreteImage &lhs, int rhs)
{
    if (lhs.type() == IA_VectorDI<u_char>::s_type()) {
	return vec_scalar_bo_strict_ne((IA_VectorDI<u_char> *)lhs.bdip,rhs);
    } else if (lhs.type() == IA_ConstDI<u_char>::s_type()) {
	return (((IA_ConstDI<u_char> *)lhs.bdip)->value) != (rhs);
    } else {
	return iter_scalar_bo_strict_ne(lhs,rhs);
    }
}

//////////////////////////////////////////////////////////////////////
//
// Begin operation support routines for :
// binary strictrel non-commutative operator>= I(u_char) I(u_char) int
//
int vec_vec_bo_operatorIAOPge(const IA_VectorDI<u_char> *lhs,const IA_VectorDI<u_char> *rhs)
{
    const IA_IntPointSet domain = lhs->domain();
    const unsigned sz = domain.card();
    int *const vec = new int[sz];

    {
	int *ds = vec;
	const u_char *ls = lhs->vec;
	const u_char *rs = rhs->vec;
	for (unsigned i=0; i<sz; i++) {
	    if (!( (*(ls++)) >= (*(rs++)) ))
		return 0;
	}
    }
    return 1;
}

#ifndef vec_scalar_int_u_char_u_char_operatorIAOPge
#define vec_scalar_int_u_char_u_char_operatorIAOPge
int vec_scalar_bo_operatorIAOPge(const IA_VectorDI<u_char> *lhs,u_char rhs)
{
    const IA_IntPointSet domain = lhs->domain();
    const unsigned sz = domain.card();
    int *const vec = new int[sz];

    {
	int *ds = vec;
	const u_char *ls = lhs->vec;
	for (unsigned i=0; i<sz; i++) {
	    if (!( (*(ls++)) >= (rhs) ))
		return 0;
	}
    }
    return 1;
}
#endif // vec_scalar_int_u_char_u_char_operatorIAOPge

int vec_iter_bo_operatorIAOPge(const IA_VectorDI<u_char> *lhs,IA_UcharDiscreteImage rhs)
{
    const IA_IntPointSet domain = lhs->domain();
    const unsigned sz = domain.card();
    int *const vec = new int[sz];

    {
	int *ds = vec;
	const u_char *ls = lhs->vec;
	u_char rtmp;
	IA_DIVIter<u_char>	riter(rhs);
	for (unsigned i=0; i<sz; i++) {
	    riter(rtmp);
	    if (!( (*(ls++)) >= (rtmp) ))
		return 0;
	}
    }
    return 1;
}

#ifndef scalar_vec_int_u_char_u_char_operatorIAOPge
#define scalar_vec_int_u_char_u_char_operatorIAOPge
int scalar_vec_bo_operatorIAOPge(u_char lhs,const IA_VectorDI<u_char> *rhs)
{
    const IA_IntPointSet domain = rhs->domain();
    const unsigned sz = domain.card();
    int *const vec = new int[sz];

    {
	int *ds = vec;
	const u_char *rs = rhs->vec;
	for (unsigned i=0; i<sz; i++) {
	    if (!( (lhs) >= (*(rs++)) ))
		return 0;
	}
    }
    return 1;
}
#endif // scalar_vec_int_u_char_u_char_operatorIAOPge

// scalar-scalar operation is trivial

#ifndef scalar_iter_int_u_char_u_char_operatorIAOPge
#define scalar_iter_int_u_char_u_char_operatorIAOPge
int scalar_iter_bo_operatorIAOPge(u_char lhs,IA_UcharDiscreteImage rhs)
{
    const IA_IntPointSet domain = rhs.domain();
    const unsigned sz = domain.card();
    int *const vec = new int[sz];

    {
	int *ds = vec;
	u_char rtmp;
	IA_DIVIter<u_char>	riter(rhs);
	for (unsigned i=0; i<sz; i++) {
	    riter(rtmp);
	    if (!( (lhs) >= (rtmp) ))
		return 0;
	}
    }
    return 1;
}
#endif // scalar_iter_int_u_char_u_char_operatorIAOPge

int iter_vec_bo_operatorIAOPge(IA_UcharDiscreteImage lhs,const IA_VectorDI<u_char> *rhs)
{
    const IA_IntPointSet domain = lhs.domain();
    const unsigned sz = domain.card();
    int *const vec = new int[sz];

    {
	int *ds = vec;
	u_char ltmp;
	IA_DIVIter<u_char>	liter(lhs);
	const u_char *rs = rhs->vec;
	for (unsigned i=0; i<sz; i++) {
	    liter(ltmp);
	    if (!( (ltmp) >= (*(rs++)) ))
		return 0;
	}
    }
    return 1;
}

#ifndef iter_scalar_int_u_char_u_char_operatorIAOPge
#define iter_scalar_int_u_char_u_char_operatorIAOPge
int iter_scalar_bo_operatorIAOPge(IA_UcharDiscreteImage lhs,u_char rhs)
{
    const IA_IntPointSet domain = lhs.domain();
    const unsigned sz = domain.card();
    int *const vec = new int[sz];

    {
	int *ds = vec;
	u_char ltmp;
	IA_DIVIter<u_char>	liter(lhs);
	for (unsigned i=0; i<sz; i++) {
	    liter(ltmp);
	    if (!( (ltmp) >= (rhs) ))
		return 0;
	}
    }
    return 1;
}
#endif // iter_scalar_int_u_char_u_char_operatorIAOPge

int iter_iter_bo_operatorIAOPge(IA_UcharDiscreteImage lhs,IA_UcharDiscreteImage rhs)
{
    const IA_IntPointSet domain = lhs.domain();
    const unsigned sz = domain.card();
    int *const vec = new int[sz];

    {
	int *ds = vec;
	u_char ltmp;
	IA_DIVIter<u_char>	liter(lhs);
	u_char rtmp;
	IA_DIVIter<u_char>	riter(rhs);
	for (unsigned i=0; i<sz; i++) {
	    liter(ltmp);
	    riter(rtmp);
	    if (!( (ltmp) >= (rtmp) ))
		return 0;
	}
    }
    return 1;
}

int operator>= ( const IA_UcharDiscreteImage &lhs,
	      const IA_UcharDiscreteImage &rhs)
{
    if (lhs.domain() != rhs.domain()) {
	static int	rval;
	ia_throw( IA::PSET_MISMATCH, __FILE__,__LINE__);
	return rval;
    }

    if (lhs.type() == IA_VectorDI<u_char>::s_type()) {
	if (rhs.type() == IA_VectorDI<u_char>::s_type()) {
	    return vec_vec_bo_operatorIAOPge((IA_VectorDI<u_char> *)lhs.bdip,(IA_VectorDI<u_char> *)rhs.bdip);
	} else if (rhs.type() == IA_ConstDI<u_char>::s_type()) {
	    return vec_scalar_bo_operatorIAOPge((IA_VectorDI<u_char> *)lhs.bdip,((IA_ConstDI<u_char> *)rhs.bdip)->value);
	} else {
	    return vec_iter_bo_operatorIAOPge((IA_VectorDI<u_char> *)lhs.bdip,rhs);
	}
    } else if (lhs.type() == IA_ConstDI<u_char>::s_type()) {
	if (rhs.type() == IA_VectorDI<u_char>::s_type()) {
	    return scalar_vec_bo_operatorIAOPge(((IA_ConstDI<u_char> *)lhs.bdip)->value,(IA_VectorDI<u_char> *)rhs.bdip);
	} else if (rhs.type() == IA_ConstDI<u_char>::s_type()) {
	    return (((IA_ConstDI<u_char> *)lhs.bdip)->value) >= (((IA_ConstDI<u_char> *)rhs.bdip)->value);
	} else {
	    return scalar_iter_bo_operatorIAOPge(((IA_ConstDI<u_char> *)lhs.bdip)->value,rhs);
	}
    } else {
	if (rhs.type() == IA_VectorDI<u_char>::s_type()) {
	    return iter_vec_bo_operatorIAOPge(lhs,(IA_VectorDI<u_char> *)rhs.bdip);
	} else if (rhs.type() == IA_ConstDI<u_char>::s_type()) {
	    return iter_scalar_bo_operatorIAOPge(lhs,((IA_ConstDI<u_char> *)rhs.bdip)->value);
	} else {
	    return iter_iter_bo_operatorIAOPge(lhs,rhs);
	}
    }
}

//////////////////////////////////////////////////////////////////////
//
// Begin operation support routines for :
// binary strictrel non-commutative operator>= I(u_char) int int
//
#ifndef vec_scalar_int_u_char_int_operatorIAOPge
#define vec_scalar_int_u_char_int_operatorIAOPge
int vec_scalar_bo_operatorIAOPge(const IA_VectorDI<u_char> *lhs,int rhs)
{
    const IA_IntPointSet domain = lhs->domain();
    const unsigned sz = domain.card();
    int *const vec = new int[sz];

    {
	int *ds = vec;
	const u_char *ls = lhs->vec;
	for (unsigned i=0; i<sz; i++) {
	    if (!( (*(ls++)) >= (rhs) ))
		return 0;
	}
    }
    return 1;
}
#endif // vec_scalar_int_u_char_int_operatorIAOPge

// scalar-scalar operation is trivial

#ifndef iter_scalar_int_u_char_int_operatorIAOPge
#define iter_scalar_int_u_char_int_operatorIAOPge
int iter_scalar_bo_operatorIAOPge(IA_UcharDiscreteImage lhs,int rhs)
{
    const IA_IntPointSet domain = lhs.domain();
    const unsigned sz = domain.card();
    int *const vec = new int[sz];

    {
	int *ds = vec;
	u_char ltmp;
	IA_DIVIter<u_char>	liter(lhs);
	for (unsigned i=0; i<sz; i++) {
	    liter(ltmp);
	    if (!( (ltmp) >= (rhs) ))
		return 0;
	}
    }
    return 1;
}
#endif // iter_scalar_int_u_char_int_operatorIAOPge

int operator>= ( const IA_UcharDiscreteImage &lhs, int rhs)
{
    if (lhs.type() == IA_VectorDI<u_char>::s_type()) {
	return vec_scalar_bo_operatorIAOPge((IA_VectorDI<u_char> *)lhs.bdip,rhs);
    } else if (lhs.type() == IA_ConstDI<u_char>::s_type()) {
	return (((IA_ConstDI<u_char> *)lhs.bdip)->value) >= (rhs);
    } else {
	return iter_scalar_bo_operatorIAOPge(lhs,rhs);
    }
}

//////////////////////////////////////////////////////////////////////
//
// Begin operation support routines for :
// binary strictrel non-commutative operator>= int I(u_char) int
//
#ifndef scalar_vec_int_int_u_char_operatorIAOPge
#define scalar_vec_int_int_u_char_operatorIAOPge
int scalar_vec_bo_operatorIAOPge(int lhs,const IA_VectorDI<u_char> *rhs)
{
    const IA_IntPointSet domain = rhs->domain();
    const unsigned sz = domain.card();
    int *const vec = new int[sz];

    {
	int *ds = vec;
	const u_char *rs = rhs->vec;
	for (unsigned i=0; i<sz; i++) {
	    if (!( (lhs) >= (*(rs++)) ))
		return 0;
	}
    }
    return 1;
}
#endif // scalar_vec_int_int_u_char_operatorIAOPge

// scalar-scalar operation is trivial

#ifndef scalar_iter_int_int_u_char_operatorIAOPge
#define scalar_iter_int_int_u_char_operatorIAOPge
int scalar_iter_bo_operatorIAOPge(int lhs,IA_UcharDiscreteImage rhs)
{
    const IA_IntPointSet domain = rhs.domain();
    const unsigned sz = domain.card();
    int *const vec = new int[sz];

    {
	int *ds = vec;
	u_char rtmp;
	IA_DIVIter<u_char>	riter(rhs);
	for (unsigned i=0; i<sz; i++) {
	    riter(rtmp);
	    if (!( (lhs) >= (rtmp) ))
		return 0;
	}
    }
    return 1;
}
#endif // scalar_iter_int_int_u_char_operatorIAOPge

int operator>= (int lhs, const IA_UcharDiscreteImage &rhs)
{
    if (rhs.type() == IA_VectorDI<u_char>::s_type()) {
	return scalar_vec_bo_operatorIAOPge(lhs,(IA_VectorDI<u_char> *)rhs.bdip);
    } else if (rhs.type() == IA_ConstDI<u_char>::s_type()) {
	return (lhs) >= (((IA_ConstDI<u_char> *)rhs.bdip)->value);
    } else {
	return scalar_iter_bo_operatorIAOPge(lhs,rhs);
    }
}

//////////////////////////////////////////////////////////////////////
//
// Begin operation support routines for :
// binary strictrel non-commutative operator> I(u_char) I(u_char) int
//
int vec_vec_bo_operatorIAOPgt(const IA_VectorDI<u_char> *lhs,const IA_VectorDI<u_char> *rhs)
{
    const IA_IntPointSet domain = lhs->domain();
    const unsigned sz = domain.card();
    int *const vec = new int[sz];

    {
	int *ds = vec;
	const u_char *ls = lhs->vec;
	const u_char *rs = rhs->vec;
	for (unsigned i=0; i<sz; i++) {
	    if (!( (*(ls++)) > (*(rs++)) ))
		return 0;
	}
    }
    return 1;
}

#ifndef vec_scalar_int_u_char_u_char_operatorIAOPgt
#define vec_scalar_int_u_char_u_char_operatorIAOPgt
int vec_scalar_bo_operatorIAOPgt(const IA_VectorDI<u_char> *lhs,u_char rhs)
{
    const IA_IntPointSet domain = lhs->domain();
    const unsigned sz = domain.card();
    int *const vec = new int[sz];

    {
	int *ds = vec;
	const u_char *ls = lhs->vec;
	for (unsigned i=0; i<sz; i++) {
	    if (!( (*(ls++)) > (rhs) ))
		return 0;
	}
    }
    return 1;
}
#endif // vec_scalar_int_u_char_u_char_operatorIAOPgt

int vec_iter_bo_operatorIAOPgt(const IA_VectorDI<u_char> *lhs,IA_UcharDiscreteImage rhs)
{
    const IA_IntPointSet domain = lhs->domain();
    const unsigned sz = domain.card();
    int *const vec = new int[sz];

    {
	int *ds = vec;
	const u_char *ls = lhs->vec;
	u_char rtmp;
	IA_DIVIter<u_char>	riter(rhs);
	for (unsigned i=0; i<sz; i++) {
	    riter(rtmp);
	    if (!( (*(ls++)) > (rtmp) ))
		return 0;
	}
    }
    return 1;
}

#ifndef scalar_vec_int_u_char_u_char_operatorIAOPgt
#define scalar_vec_int_u_char_u_char_operatorIAOPgt
int scalar_vec_bo_operatorIAOPgt(u_char lhs,const IA_VectorDI<u_char> *rhs)
{
    const IA_IntPointSet domain = rhs->domain();
    const unsigned sz = domain.card();
    int *const vec = new int[sz];

    {
	int *ds = vec;
	const u_char *rs = rhs->vec;
	for (unsigned i=0; i<sz; i++) {
	    if (!( (lhs) > (*(rs++)) ))
		return 0;
	}
    }
    return 1;
}
#endif // scalar_vec_int_u_char_u_char_operatorIAOPgt

// scalar-scalar operation is trivial

#ifndef scalar_iter_int_u_char_u_char_operatorIAOPgt
#define scalar_iter_int_u_char_u_char_operatorIAOPgt
int scalar_iter_bo_operatorIAOPgt(u_char lhs,IA_UcharDiscreteImage rhs)
{
    const IA_IntPointSet domain = rhs.domain();
    const unsigned sz = domain.card();
    int *const vec = new int[sz];

    {
	int *ds = vec;
	u_char rtmp;
	IA_DIVIter<u_char>	riter(rhs);
	for (unsigned i=0; i<sz; i++) {
	    riter(rtmp);
	    if (!( (lhs) > (rtmp) ))
		return 0;
	}
    }
    return 1;
}
#endif // scalar_iter_int_u_char_u_char_operatorIAOPgt

int iter_vec_bo_operatorIAOPgt(IA_UcharDiscreteImage lhs,const IA_VectorDI<u_char> *rhs)
{
    const IA_IntPointSet domain = lhs.domain();
    const unsigned sz = domain.card();
    int *const vec = new int[sz];

    {
	int *ds = vec;
	u_char ltmp;
	IA_DIVIter<u_char>	liter(lhs);
	const u_char *rs = rhs->vec;
	for (unsigned i=0; i<sz; i++) {
	    liter(ltmp);
	    if (!( (ltmp) > (*(rs++)) ))
		return 0;
	}
    }
    return 1;
}

#ifndef iter_scalar_int_u_char_u_char_operatorIAOPgt
#define iter_scalar_int_u_char_u_char_operatorIAOPgt
int iter_scalar_bo_operatorIAOPgt(IA_UcharDiscreteImage lhs,u_char rhs)
{
    const IA_IntPointSet domain = lhs.domain();
    const unsigned sz = domain.card();
    int *const vec = new int[sz];

    {
	int *ds = vec;
	u_char ltmp;
	IA_DIVIter<u_char>	liter(lhs);
	for (unsigned i=0; i<sz; i++) {
	    liter(ltmp);
	    if (!( (ltmp) > (rhs) ))
		return 0;
	}
    }
    return 1;
}
#endif // iter_scalar_int_u_char_u_char_operatorIAOPgt

int iter_iter_bo_operatorIAOPgt(IA_UcharDiscreteImage lhs,IA_UcharDiscreteImage rhs)
{
    const IA_IntPointSet domain = lhs.domain();
    const unsigned sz = domain.card();
    int *const vec = new int[sz];

    {
	int *ds = vec;
	u_char ltmp;
	IA_DIVIter<u_char>	liter(lhs);
	u_char rtmp;
	IA_DIVIter<u_char>	riter(rhs);
	for (unsigned i=0; i<sz; i++) {
	    liter(ltmp);
	    riter(rtmp);
	    if (!( (ltmp) > (rtmp) ))
		return 0;
	}
    }
    return 1;
}

int operator> ( const IA_UcharDiscreteImage &lhs,
	      const IA_UcharDiscreteImage &rhs)
{
    if (lhs.domain() != rhs.domain()) {
	static int	rval;
	ia_throw( IA::PSET_MISMATCH, __FILE__,__LINE__);
	return rval;
    }

    if (lhs.type() == IA_VectorDI<u_char>::s_type()) {
	if (rhs.type() == IA_VectorDI<u_char>::s_type()) {
	    return vec_vec_bo_operatorIAOPgt((IA_VectorDI<u_char> *)lhs.bdip,(IA_VectorDI<u_char> *)rhs.bdip);
	} else if (rhs.type() == IA_ConstDI<u_char>::s_type()) {
	    return vec_scalar_bo_operatorIAOPgt((IA_VectorDI<u_char> *)lhs.bdip,((IA_ConstDI<u_char> *)rhs.bdip)->value);
	} else {
	    return vec_iter_bo_operatorIAOPgt((IA_VectorDI<u_char> *)lhs.bdip,rhs);
	}
    } else if (lhs.type() == IA_ConstDI<u_char>::s_type()) {
	if (rhs.type() == IA_VectorDI<u_char>::s_type()) {
	    return scalar_vec_bo_operatorIAOPgt(((IA_ConstDI<u_char> *)lhs.bdip)->value,(IA_VectorDI<u_char> *)rhs.bdip);
	} else if (rhs.type() == IA_ConstDI<u_char>::s_type()) {
	    return (((IA_ConstDI<u_char> *)lhs.bdip)->value) > (((IA_ConstDI<u_char> *)rhs.bdip)->value);
	} else {
	    return scalar_iter_bo_operatorIAOPgt(((IA_ConstDI<u_char> *)lhs.bdip)->value,rhs);
	}
    } else {
	if (rhs.type() == IA_VectorDI<u_char>::s_type()) {
	    return iter_vec_bo_operatorIAOPgt(lhs,(IA_VectorDI<u_char> *)rhs.bdip);
	} else if (rhs.type() == IA_ConstDI<u_char>::s_type()) {
	    return iter_scalar_bo_operatorIAOPgt(lhs,((IA_ConstDI<u_char> *)rhs.bdip)->value);
	} else {
	    return iter_iter_bo_operatorIAOPgt(lhs,rhs);
	}
    }
}

//////////////////////////////////////////////////////////////////////
//
// Begin operation support routines for :
// binary strictrel non-commutative operator> I(u_char) int int
//
#ifndef vec_scalar_int_u_char_int_operatorIAOPgt
#define vec_scalar_int_u_char_int_operatorIAOPgt
int vec_scalar_bo_operatorIAOPgt(const IA_VectorDI<u_char> *lhs,int rhs)
{
    const IA_IntPointSet domain = lhs->domain();
    const unsigned sz = domain.card();
    int *const vec = new int[sz];

    {
	int *ds = vec;
	const u_char *ls = lhs->vec;
	for (unsigned i=0; i<sz; i++) {
	    if (!( (*(ls++)) > (rhs) ))
		return 0;
	}
    }
    return 1;
}
#endif // vec_scalar_int_u_char_int_operatorIAOPgt

// scalar-scalar operation is trivial

#ifndef iter_scalar_int_u_char_int_operatorIAOPgt
#define iter_scalar_int_u_char_int_operatorIAOPgt
int iter_scalar_bo_operatorIAOPgt(IA_UcharDiscreteImage lhs,int rhs)
{
    const IA_IntPointSet domain = lhs.domain();
    const unsigned sz = domain.card();
    int *const vec = new int[sz];

    {
	int *ds = vec;
	u_char ltmp;
	IA_DIVIter<u_char>	liter(lhs);
	for (unsigned i=0; i<sz; i++) {
	    liter(ltmp);
	    if (!( (ltmp) > (rhs) ))
		return 0;
	}
    }
    return 1;
}
#endif // iter_scalar_int_u_char_int_operatorIAOPgt

int operator> ( const IA_UcharDiscreteImage &lhs, int rhs)
{
    if (lhs.type() == IA_VectorDI<u_char>::s_type()) {
	return vec_scalar_bo_operatorIAOPgt((IA_VectorDI<u_char> *)lhs.bdip,rhs);
    } else if (lhs.type() == IA_ConstDI<u_char>::s_type()) {
	return (((IA_ConstDI<u_char> *)lhs.bdip)->value) > (rhs);
    } else {
	return iter_scalar_bo_operatorIAOPgt(lhs,rhs);
    }
}

//////////////////////////////////////////////////////////////////////
//
// Begin operation support routines for :
// binary strictrel non-commutative operator> int I(u_char) int
//
#ifndef scalar_vec_int_int_u_char_operatorIAOPgt
#define scalar_vec_int_int_u_char_operatorIAOPgt
int scalar_vec_bo_operatorIAOPgt(int lhs,const IA_VectorDI<u_char> *rhs)
{
    const IA_IntPointSet domain = rhs->domain();
    const unsigned sz = domain.card();
    int *const vec = new int[sz];

    {
	int *ds = vec;
	const u_char *rs = rhs->vec;
	for (unsigned i=0; i<sz; i++) {
	    if (!( (lhs) > (*(rs++)) ))
		return 0;
	}
    }
    return 1;
}
#endif // scalar_vec_int_int_u_char_operatorIAOPgt

// scalar-scalar operation is trivial

#ifndef scalar_iter_int_int_u_char_operatorIAOPgt
#define scalar_iter_int_int_u_char_operatorIAOPgt
int scalar_iter_bo_operatorIAOPgt(int lhs,IA_UcharDiscreteImage rhs)
{
    const IA_IntPointSet domain = rhs.domain();
    const unsigned sz = domain.card();
    int *const vec = new int[sz];

    {
	int *ds = vec;
	u_char rtmp;
	IA_DIVIter<u_char>	riter(rhs);
	for (unsigned i=0; i<sz; i++) {
	    riter(rtmp);
	    if (!( (lhs) > (rtmp) ))
		return 0;
	}
    }
    return 1;
}
#endif // scalar_iter_int_int_u_char_operatorIAOPgt

int operator> (int lhs, const IA_UcharDiscreteImage &rhs)
{
    if (rhs.type() == IA_VectorDI<u_char>::s_type()) {
	return scalar_vec_bo_operatorIAOPgt(lhs,(IA_VectorDI<u_char> *)rhs.bdip);
    } else if (rhs.type() == IA_ConstDI<u_char>::s_type()) {
	return (lhs) > (((IA_ConstDI<u_char> *)rhs.bdip)->value);
    } else {
	return scalar_iter_bo_operatorIAOPgt(lhs,rhs);
    }
}

//////////////////////////////////////////////////////////////////////
//
// Begin operation support routines for :
// binary pointwise non-commutative pwise_lt subop=operator< I(u_char) I(u_char) I(u_char)
//
static IA_UcharDiscreteImage
vec_vec_bo_pwise_lt(const IA_VectorDI<u_char> *lhs,const IA_VectorDI<u_char> *rhs)
{
    const IA_IntPointSet domain = lhs->domain();
    const unsigned sz = domain.card();
    u_char *const vec = new u_char[sz];

    {
	u_char *ds = vec;
	const u_char *ls = lhs->vec;
	const u_char *rs = rhs->vec;
	for (unsigned i=0; i<sz; i++) {
	    *(ds++) = ( (*(ls++)) < (*(rs++)) );
	}
    }
    return IA_UcharDiscreteImage(domain, vec, sz, 1);
}

#ifndef vec_scalar_u_char_u_char_u_char_pwise_lt
#define vec_scalar_u_char_u_char_u_char_pwise_lt
static IA_UcharDiscreteImage
vec_scalar_bo_pwise_lt(const IA_VectorDI<u_char> *lhs,u_char rhs)
{
    const IA_IntPointSet domain = lhs->domain();
    const unsigned sz = domain.card();
    u_char *const vec = new u_char[sz];

    {
	u_char *ds = vec;
	const u_char *ls = lhs->vec;
	for (unsigned i=0; i<sz; i++) {
	    *(ds++) = ( (*(ls++)) < (rhs) );
	}
    }
    return IA_UcharDiscreteImage(domain, vec, sz, 1);
}
#endif // vec_scalar_u_char_u_char_u_char_pwise_lt

static IA_UcharDiscreteImage
vec_iter_bo_pwise_lt(const IA_VectorDI<u_char> *lhs,IA_UcharDiscreteImage rhs)
{
    const IA_IntPointSet domain = lhs->domain();
    const unsigned sz = domain.card();
    u_char *const vec = new u_char[sz];

    {
	u_char *ds = vec;
	const u_char *ls = lhs->vec;
	u_char rtmp;
	IA_DIVIter<u_char>	riter(rhs);
	for (unsigned i=0; i<sz; i++) {
	    riter(rtmp);
	    *(ds++) = ( (*(ls++)) < (rtmp) );
	}
    }
    return IA_UcharDiscreteImage(domain, vec, sz, 1);
}

#ifndef scalar_vec_u_char_u_char_u_char_pwise_lt
#define scalar_vec_u_char_u_char_u_char_pwise_lt
static IA_UcharDiscreteImage
scalar_vec_bo_pwise_lt(u_char lhs,const IA_VectorDI<u_char> *rhs)
{
    const IA_IntPointSet domain = rhs->domain();
    const unsigned sz = domain.card();
    u_char *const vec = new u_char[sz];

    {
	u_char *ds = vec;
	const u_char *rs = rhs->vec;
	for (unsigned i=0; i<sz; i++) {
	    *(ds++) = ( (lhs) < (*(rs++)) );
	}
    }
    return IA_UcharDiscreteImage(domain, vec, sz, 1);
}
#endif // scalar_vec_u_char_u_char_u_char_pwise_lt

// scalar-scalar operation is trivial

#ifndef scalar_iter_u_char_u_char_u_char_pwise_lt
#define scalar_iter_u_char_u_char_u_char_pwise_lt
static IA_UcharDiscreteImage
scalar_iter_bo_pwise_lt(u_char lhs,IA_UcharDiscreteImage rhs)
{
    const IA_IntPointSet domain = rhs.domain();
    const unsigned sz = domain.card();
    u_char *const vec = new u_char[sz];

    {
	u_char *ds = vec;
	u_char rtmp;
	IA_DIVIter<u_char>	riter(rhs);
	for (unsigned i=0; i<sz; i++) {
	    riter(rtmp);
	    *(ds++) = ( (lhs) < (rtmp) );
	}
    }
    return IA_UcharDiscreteImage(domain, vec, sz, 1);
}
#endif // scalar_iter_u_char_u_char_u_char_pwise_lt

static IA_UcharDiscreteImage
iter_vec_bo_pwise_lt(IA_UcharDiscreteImage lhs,const IA_VectorDI<u_char> *rhs)
{
    const IA_IntPointSet domain = lhs.domain();
    const unsigned sz = domain.card();
    u_char *const vec = new u_char[sz];

    {
	u_char *ds = vec;
	u_char ltmp;
	IA_DIVIter<u_char>	liter(lhs);
	const u_char *rs = rhs->vec;
	for (unsigned i=0; i<sz; i++) {
	    liter(ltmp);
	    *(ds++) = ( (ltmp) < (*(rs++)) );
	}
    }
    return IA_UcharDiscreteImage(domain, vec, sz, 1);
}

#ifndef iter_scalar_u_char_u_char_u_char_pwise_lt
#define iter_scalar_u_char_u_char_u_char_pwise_lt
static IA_UcharDiscreteImage
iter_scalar_bo_pwise_lt(IA_UcharDiscreteImage lhs,u_char rhs)
{
    const IA_IntPointSet domain = lhs.domain();
    const unsigned sz = domain.card();
    u_char *const vec = new u_char[sz];

    {
	u_char *ds = vec;
	u_char ltmp;
	IA_DIVIter<u_char>	liter(lhs);
	for (unsigned i=0; i<sz; i++) {
	    liter(ltmp);
	    *(ds++) = ( (ltmp) < (rhs) );
	}
    }
    return IA_UcharDiscreteImage(domain, vec, sz, 1);
}
#endif // iter_scalar_u_char_u_char_u_char_pwise_lt

static IA_UcharDiscreteImage
iter_iter_bo_pwise_lt(IA_UcharDiscreteImage lhs,IA_UcharDiscreteImage rhs)
{
    const IA_IntPointSet domain = lhs.domain();
    const unsigned sz = domain.card();
    u_char *const vec = new u_char[sz];

    {
	u_char *ds = vec;
	u_char ltmp;
	IA_DIVIter<u_char>	liter(lhs);
	u_char rtmp;
	IA_DIVIter<u_char>	riter(rhs);
	for (unsigned i=0; i<sz; i++) {
	    liter(ltmp);
	    riter(rtmp);
	    *(ds++) = ( (ltmp) < (rtmp) );
	}
    }
    return IA_UcharDiscreteImage(domain, vec, sz, 1);
}

IA_UcharDiscreteImage
pwise_lt ( const IA_UcharDiscreteImage &lhs,
	      const IA_UcharDiscreteImage &rhs)
{
    if (lhs.domain() != rhs.domain()) {
	static IA_UcharDiscreteImage	rval;
	ia_throw( IA::PSET_MISMATCH, __FILE__,__LINE__);
	return rval;
    }

    if (lhs.type() == IA_VectorDI<u_char>::s_type()) {
	if (rhs.type() == IA_VectorDI<u_char>::s_type()) {
	    return vec_vec_bo_pwise_lt((IA_VectorDI<u_char> *)lhs.bdip,(IA_VectorDI<u_char> *)rhs.bdip);
	} else if (rhs.type() == IA_ConstDI<u_char>::s_type()) {
	    return vec_scalar_bo_pwise_lt((IA_VectorDI<u_char> *)lhs.bdip,((IA_ConstDI<u_char> *)rhs.bdip)->value);
	} else {
	    return vec_iter_bo_pwise_lt((IA_VectorDI<u_char> *)lhs.bdip,rhs);
	}
    } else if (lhs.type() == IA_ConstDI<u_char>::s_type()) {
	if (rhs.type() == IA_VectorDI<u_char>::s_type()) {
	    return scalar_vec_bo_pwise_lt(((IA_ConstDI<u_char> *)lhs.bdip)->value,(IA_VectorDI<u_char> *)rhs.bdip);
	} else if (rhs.type() == IA_ConstDI<u_char>::s_type()) {
	    return IA_UcharDiscreteImage (lhs.domain(), (((IA_ConstDI<u_char> *)lhs.bdip)->value) < (((IA_ConstDI<u_char> *)rhs.bdip)->value));
	} else {
	    return scalar_iter_bo_pwise_lt(((IA_ConstDI<u_char> *)lhs.bdip)->value,rhs);
	}
    } else {
	if (rhs.type() == IA_VectorDI<u_char>::s_type()) {
	    return iter_vec_bo_pwise_lt(lhs,(IA_VectorDI<u_char> *)rhs.bdip);
	} else if (rhs.type() == IA_ConstDI<u_char>::s_type()) {
	    return iter_scalar_bo_pwise_lt(lhs,((IA_ConstDI<u_char> *)rhs.bdip)->value);
	} else {
	    return iter_iter_bo_pwise_lt(lhs,rhs);
	}
    }
}

//////////////////////////////////////////////////////////////////////
//
// Begin operation support routines for :
// binary pointwise non-commutative pwise_lt subop=operator< I(u_char) int I(u_char)
//
#ifndef vec_scalar_u_char_u_char_int_pwise_lt
#define vec_scalar_u_char_u_char_int_pwise_lt
static IA_UcharDiscreteImage
vec_scalar_bo_pwise_lt(const IA_VectorDI<u_char> *lhs,int rhs)
{
    const IA_IntPointSet domain = lhs->domain();
    const unsigned sz = domain.card();
    u_char *const vec = new u_char[sz];

    {
	u_char *ds = vec;
	const u_char *ls = lhs->vec;
	for (unsigned i=0; i<sz; i++) {
	    *(ds++) = ( (*(ls++)) < (rhs) );
	}
    }
    return IA_UcharDiscreteImage(domain, vec, sz, 1);
}
#endif // vec_scalar_u_char_u_char_int_pwise_lt

// scalar-scalar operation is trivial

#ifndef iter_scalar_u_char_u_char_int_pwise_lt
#define iter_scalar_u_char_u_char_int_pwise_lt
static IA_UcharDiscreteImage
iter_scalar_bo_pwise_lt(IA_UcharDiscreteImage lhs,int rhs)
{
    const IA_IntPointSet domain = lhs.domain();
    const unsigned sz = domain.card();
    u_char *const vec = new u_char[sz];

    {
	u_char *ds = vec;
	u_char ltmp;
	IA_DIVIter<u_char>	liter(lhs);
	for (unsigned i=0; i<sz; i++) {
	    liter(ltmp);
	    *(ds++) = ( (ltmp) < (rhs) );
	}
    }
    return IA_UcharDiscreteImage(domain, vec, sz, 1);
}
#endif // iter_scalar_u_char_u_char_int_pwise_lt

IA_UcharDiscreteImage
pwise_lt ( const IA_UcharDiscreteImage &lhs, int rhs)
{
    if (lhs.type() == IA_VectorDI<u_char>::s_type()) {
	return vec_scalar_bo_pwise_lt((IA_VectorDI<u_char> *)lhs.bdip,rhs);
    } else if (lhs.type() == IA_ConstDI<u_char>::s_type()) {
	return IA_UcharDiscreteImage (lhs.domain(), (((IA_ConstDI<u_char> *)lhs.bdip)->value) < (rhs));
    } else {
	return iter_scalar_bo_pwise_lt(lhs,rhs);
    }
}

//////////////////////////////////////////////////////////////////////
//
// Begin operation support routines for :
// binary pointwise non-commutative pwise_lt subop=operator< int I(u_char) I(u_char)
//
#ifndef scalar_vec_u_char_int_u_char_pwise_lt
#define scalar_vec_u_char_int_u_char_pwise_lt
static IA_UcharDiscreteImage
scalar_vec_bo_pwise_lt(int lhs,const IA_VectorDI<u_char> *rhs)
{
    const IA_IntPointSet domain = rhs->domain();
    const unsigned sz = domain.card();
    u_char *const vec = new u_char[sz];

    {
	u_char *ds = vec;
	const u_char *rs = rhs->vec;
	for (unsigned i=0; i<sz; i++) {
	    *(ds++) = ( (lhs) < (*(rs++)) );
	}
    }
    return IA_UcharDiscreteImage(domain, vec, sz, 1);
}
#endif // scalar_vec_u_char_int_u_char_pwise_lt

// scalar-scalar operation is trivial

#ifndef scalar_iter_u_char_int_u_char_pwise_lt
#define scalar_iter_u_char_int_u_char_pwise_lt
static IA_UcharDiscreteImage
scalar_iter_bo_pwise_lt(int lhs,IA_UcharDiscreteImage rhs)
{
    const IA_IntPointSet domain = rhs.domain();
    const unsigned sz = domain.card();
    u_char *const vec = new u_char[sz];

    {
	u_char *ds = vec;
	u_char rtmp;
	IA_DIVIter<u_char>	riter(rhs);
	for (unsigned i=0; i<sz; i++) {
	    riter(rtmp);
	    *(ds++) = ( (lhs) < (rtmp) );
	}
    }
    return IA_UcharDiscreteImage(domain, vec, sz, 1);
}
#endif // scalar_iter_u_char_int_u_char_pwise_lt

IA_UcharDiscreteImage
pwise_lt (int lhs, const IA_UcharDiscreteImage &rhs)
{
    if (rhs.type() == IA_VectorDI<u_char>::s_type()) {
	return scalar_vec_bo_pwise_lt(lhs,(IA_VectorDI<u_char> *)rhs.bdip);
    } else if (rhs.type() == IA_ConstDI<u_char>::s_type()) {
	return IA_UcharDiscreteImage (rhs.domain(), (lhs) < (((IA_ConstDI<u_char> *)rhs.bdip)->value));
    } else {
	return scalar_iter_bo_pwise_lt(lhs,rhs);
    }
}

//////////////////////////////////////////////////////////////////////
//
// Begin operation support routines for :
// binary pointwise non-commutative pwise_le subop=operator<= I(u_char) I(u_char) I(u_char)
//
static IA_UcharDiscreteImage
vec_vec_bo_pwise_le(const IA_VectorDI<u_char> *lhs,const IA_VectorDI<u_char> *rhs)
{
    const IA_IntPointSet domain = lhs->domain();
    const unsigned sz = domain.card();
    u_char *const vec = new u_char[sz];

    {
	u_char *ds = vec;
	const u_char *ls = lhs->vec;
	const u_char *rs = rhs->vec;
	for (unsigned i=0; i<sz; i++) {
	    *(ds++) = ( (*(ls++)) <= (*(rs++)) );
	}
    }
    return IA_UcharDiscreteImage(domain, vec, sz, 1);
}

#ifndef vec_scalar_u_char_u_char_u_char_pwise_le
#define vec_scalar_u_char_u_char_u_char_pwise_le
static IA_UcharDiscreteImage
vec_scalar_bo_pwise_le(const IA_VectorDI<u_char> *lhs,u_char rhs)
{
    const IA_IntPointSet domain = lhs->domain();
    const unsigned sz = domain.card();
    u_char *const vec = new u_char[sz];

    {
	u_char *ds = vec;
	const u_char *ls = lhs->vec;
	for (unsigned i=0; i<sz; i++) {
	    *(ds++) = ( (*(ls++)) <= (rhs) );
	}
    }
    return IA_UcharDiscreteImage(domain, vec, sz, 1);
}
#endif // vec_scalar_u_char_u_char_u_char_pwise_le

static IA_UcharDiscreteImage
vec_iter_bo_pwise_le(const IA_VectorDI<u_char> *lhs,IA_UcharDiscreteImage rhs)
{
    const IA_IntPointSet domain = lhs->domain();
    const unsigned sz = domain.card();
    u_char *const vec = new u_char[sz];

    {
	u_char *ds = vec;
	const u_char *ls = lhs->vec;
	u_char rtmp;
	IA_DIVIter<u_char>	riter(rhs);
	for (unsigned i=0; i<sz; i++) {
	    riter(rtmp);
	    *(ds++) = ( (*(ls++)) <= (rtmp) );
	}
    }
    return IA_UcharDiscreteImage(domain, vec, sz, 1);
}

#ifndef scalar_vec_u_char_u_char_u_char_pwise_le
#define scalar_vec_u_char_u_char_u_char_pwise_le
static IA_UcharDiscreteImage
scalar_vec_bo_pwise_le(u_char lhs,const IA_VectorDI<u_char> *rhs)
{
    const IA_IntPointSet domain = rhs->domain();
    const unsigned sz = domain.card();
    u_char *const vec = new u_char[sz];

    {
	u_char *ds = vec;
	const u_char *rs = rhs->vec;
	for (unsigned i=0; i<sz; i++) {
	    *(ds++) = ( (lhs) <= (*(rs++)) );
	}
    }
    return IA_UcharDiscreteImage(domain, vec, sz, 1);
}
#endif // scalar_vec_u_char_u_char_u_char_pwise_le

// scalar-scalar operation is trivial

#ifndef scalar_iter_u_char_u_char_u_char_pwise_le
#define scalar_iter_u_char_u_char_u_char_pwise_le
static IA_UcharDiscreteImage
scalar_iter_bo_pwise_le(u_char lhs,IA_UcharDiscreteImage rhs)
{
    const IA_IntPointSet domain = rhs.domain();
    const unsigned sz = domain.card();
    u_char *const vec = new u_char[sz];

    {
	u_char *ds = vec;
	u_char rtmp;
	IA_DIVIter<u_char>	riter(rhs);
	for (unsigned i=0; i<sz; i++) {
	    riter(rtmp);
	    *(ds++) = ( (lhs) <= (rtmp) );
	}
    }
    return IA_UcharDiscreteImage(domain, vec, sz, 1);
}
#endif // scalar_iter_u_char_u_char_u_char_pwise_le

static IA_UcharDiscreteImage
iter_vec_bo_pwise_le(IA_UcharDiscreteImage lhs,const IA_VectorDI<u_char> *rhs)
{
    const IA_IntPointSet domain = lhs.domain();
    const unsigned sz = domain.card();
    u_char *const vec = new u_char[sz];

    {
	u_char *ds = vec;
	u_char ltmp;
	IA_DIVIter<u_char>	liter(lhs);
	const u_char *rs = rhs->vec;
	for (unsigned i=0; i<sz; i++) {
	    liter(ltmp);
	    *(ds++) = ( (ltmp) <= (*(rs++)) );
	}
    }
    return IA_UcharDiscreteImage(domain, vec, sz, 1);
}

#ifndef iter_scalar_u_char_u_char_u_char_pwise_le
#define iter_scalar_u_char_u_char_u_char_pwise_le
static IA_UcharDiscreteImage
iter_scalar_bo_pwise_le(IA_UcharDiscreteImage lhs,u_char rhs)
{
    const IA_IntPointSet domain = lhs.domain();
    const unsigned sz = domain.card();
    u_char *const vec = new u_char[sz];

    {
	u_char *ds = vec;
	u_char ltmp;
	IA_DIVIter<u_char>	liter(lhs);
	for (unsigned i=0; i<sz; i++) {
	    liter(ltmp);
	    *(ds++) = ( (ltmp) <= (rhs) );
	}
    }
    return IA_UcharDiscreteImage(domain, vec, sz, 1);
}
#endif // iter_scalar_u_char_u_char_u_char_pwise_le

static IA_UcharDiscreteImage
iter_iter_bo_pwise_le(IA_UcharDiscreteImage lhs,IA_UcharDiscreteImage rhs)
{
    const IA_IntPointSet domain = lhs.domain();
    const unsigned sz = domain.card();
    u_char *const vec = new u_char[sz];

    {
	u_char *ds = vec;
	u_char ltmp;
	IA_DIVIter<u_char>	liter(lhs);
	u_char rtmp;
	IA_DIVIter<u_char>	riter(rhs);
	for (unsigned i=0; i<sz; i++) {
	    liter(ltmp);
	    riter(rtmp);
	    *(ds++) = ( (ltmp) <= (rtmp) );
	}
    }
    return IA_UcharDiscreteImage(domain, vec, sz, 1);
}

IA_UcharDiscreteImage
pwise_le ( const IA_UcharDiscreteImage &lhs,
	      const IA_UcharDiscreteImage &rhs)
{
    if (lhs.domain() != rhs.domain()) {
	static IA_UcharDiscreteImage	rval;
	ia_throw( IA::PSET_MISMATCH, __FILE__,__LINE__);
	return rval;
    }

    if (lhs.type() == IA_VectorDI<u_char>::s_type()) {
	if (rhs.type() == IA_VectorDI<u_char>::s_type()) {
	    return vec_vec_bo_pwise_le((IA_VectorDI<u_char> *)lhs.bdip,(IA_VectorDI<u_char> *)rhs.bdip);
	} else if (rhs.type() == IA_ConstDI<u_char>::s_type()) {
	    return vec_scalar_bo_pwise_le((IA_VectorDI<u_char> *)lhs.bdip,((IA_ConstDI<u_char> *)rhs.bdip)->value);
	} else {
	    return vec_iter_bo_pwise_le((IA_VectorDI<u_char> *)lhs.bdip,rhs);
	}
    } else if (lhs.type() == IA_ConstDI<u_char>::s_type()) {
	if (rhs.type() == IA_VectorDI<u_char>::s_type()) {
	    return scalar_vec_bo_pwise_le(((IA_ConstDI<u_char> *)lhs.bdip)->value,(IA_VectorDI<u_char> *)rhs.bdip);
	} else if (rhs.type() == IA_ConstDI<u_char>::s_type()) {
	    return IA_UcharDiscreteImage (lhs.domain(), (((IA_ConstDI<u_char> *)lhs.bdip)->value) <= (((IA_ConstDI<u_char> *)rhs.bdip)->value));
	} else {
	    return scalar_iter_bo_pwise_le(((IA_ConstDI<u_char> *)lhs.bdip)->value,rhs);
	}
    } else {
	if (rhs.type() == IA_VectorDI<u_char>::s_type()) {
	    return iter_vec_bo_pwise_le(lhs,(IA_VectorDI<u_char> *)rhs.bdip);
	} else if (rhs.type() == IA_ConstDI<u_char>::s_type()) {
	    return iter_scalar_bo_pwise_le(lhs,((IA_ConstDI<u_char> *)rhs.bdip)->value);
	} else {
	    return iter_iter_bo_pwise_le(lhs,rhs);
	}
    }
}

//////////////////////////////////////////////////////////////////////
//
// Begin operation support routines for :
// binary pointwise non-commutative pwise_le subop=operator<= I(u_char) int I(u_char)
//
#ifndef vec_scalar_u_char_u_char_int_pwise_le
#define vec_scalar_u_char_u_char_int_pwise_le
static IA_UcharDiscreteImage
vec_scalar_bo_pwise_le(const IA_VectorDI<u_char> *lhs,int rhs)
{
    const IA_IntPointSet domain = lhs->domain();
    const unsigned sz = domain.card();
    u_char *const vec = new u_char[sz];

    {
	u_char *ds = vec;
	const u_char *ls = lhs->vec;
	for (unsigned i=0; i<sz; i++) {
	    *(ds++) = ( (*(ls++)) <= (rhs) );
	}
    }
    return IA_UcharDiscreteImage(domain, vec, sz, 1);
}
#endif // vec_scalar_u_char_u_char_int_pwise_le

// scalar-scalar operation is trivial

#ifndef iter_scalar_u_char_u_char_int_pwise_le
#define iter_scalar_u_char_u_char_int_pwise_le
static IA_UcharDiscreteImage
iter_scalar_bo_pwise_le(IA_UcharDiscreteImage lhs,int rhs)
{
    const IA_IntPointSet domain = lhs.domain();
    const unsigned sz = domain.card();
    u_char *const vec = new u_char[sz];

    {
	u_char *ds = vec;
	u_char ltmp;
	IA_DIVIter<u_char>	liter(lhs);
	for (unsigned i=0; i<sz; i++) {
	    liter(ltmp);
	    *(ds++) = ( (ltmp) <= (rhs) );
	}
    }
    return IA_UcharDiscreteImage(domain, vec, sz, 1);
}
#endif // iter_scalar_u_char_u_char_int_pwise_le

IA_UcharDiscreteImage
pwise_le ( const IA_UcharDiscreteImage &lhs, int rhs)
{
    if (lhs.type() == IA_VectorDI<u_char>::s_type()) {
	return vec_scalar_bo_pwise_le((IA_VectorDI<u_char> *)lhs.bdip,rhs);
    } else if (lhs.type() == IA_ConstDI<u_char>::s_type()) {
	return IA_UcharDiscreteImage (lhs.domain(), (((IA_ConstDI<u_char> *)lhs.bdip)->value) <= (rhs));
    } else {
	return iter_scalar_bo_pwise_le(lhs,rhs);
    }
}

//////////////////////////////////////////////////////////////////////
//
// Begin operation support routines for :
// binary pointwise non-commutative pwise_le subop=operator<= int I(u_char) I(u_char)
//
#ifndef scalar_vec_u_char_int_u_char_pwise_le
#define scalar_vec_u_char_int_u_char_pwise_le
static IA_UcharDiscreteImage
scalar_vec_bo_pwise_le(int lhs,const IA_VectorDI<u_char> *rhs)
{
    const IA_IntPointSet domain = rhs->domain();
    const unsigned sz = domain.card();
    u_char *const vec = new u_char[sz];

    {
	u_char *ds = vec;
	const u_char *rs = rhs->vec;
	for (unsigned i=0; i<sz; i++) {
	    *(ds++) = ( (lhs) <= (*(rs++)) );
	}
    }
    return IA_UcharDiscreteImage(domain, vec, sz, 1);
}
#endif // scalar_vec_u_char_int_u_char_pwise_le

// scalar-scalar operation is trivial

#ifndef scalar_iter_u_char_int_u_char_pwise_le
#define scalar_iter_u_char_int_u_char_pwise_le
static IA_UcharDiscreteImage
scalar_iter_bo_pwise_le(int lhs,IA_UcharDiscreteImage rhs)
{
    const IA_IntPointSet domain = rhs.domain();
    const unsigned sz = domain.card();
    u_char *const vec = new u_char[sz];

    {
	u_char *ds = vec;
	u_char rtmp;
	IA_DIVIter<u_char>	riter(rhs);
	for (unsigned i=0; i<sz; i++) {
	    riter(rtmp);
	    *(ds++) = ( (lhs) <= (rtmp) );
	}
    }
    return IA_UcharDiscreteImage(domain, vec, sz, 1);
}
#endif // scalar_iter_u_char_int_u_char_pwise_le

IA_UcharDiscreteImage
pwise_le (int lhs, const IA_UcharDiscreteImage &rhs)
{
    if (rhs.type() == IA_VectorDI<u_char>::s_type()) {
	return scalar_vec_bo_pwise_le(lhs,(IA_VectorDI<u_char> *)rhs.bdip);
    } else if (rhs.type() == IA_ConstDI<u_char>::s_type()) {
	return IA_UcharDiscreteImage (rhs.domain(), (lhs) <= (((IA_ConstDI<u_char> *)rhs.bdip)->value));
    } else {
	return scalar_iter_bo_pwise_le(lhs,rhs);
    }
}

//////////////////////////////////////////////////////////////////////
//
// Begin operation support routines for :
// binary pointwise commutative pwise_eq subop=operator== I(u_char) I(u_char) I(u_char)
//
static IA_UcharDiscreteImage
vec_vec_bo_pwise_eq(const IA_VectorDI<u_char> *lhs,const IA_VectorDI<u_char> *rhs)
{
    const IA_IntPointSet domain = lhs->domain();
    const unsigned sz = domain.card();
    u_char *const vec = new u_char[sz];

    {
	u_char *ds = vec;
	const u_char *ls = lhs->vec;
	const u_char *rs = rhs->vec;
	for (unsigned i=0; i<sz; i++) {
	    *(ds++) = ( (*(ls++)) == (*(rs++)) );
	}
    }
    return IA_UcharDiscreteImage(domain, vec, sz, 1);
}

#ifndef vec_scalar_u_char_u_char_u_char_pwise_eq
#define vec_scalar_u_char_u_char_u_char_pwise_eq
static IA_UcharDiscreteImage
vec_scalar_bo_pwise_eq(const IA_VectorDI<u_char> *lhs,u_char rhs)
{
    const IA_IntPointSet domain = lhs->domain();
    const unsigned sz = domain.card();
    u_char *const vec = new u_char[sz];

    {
	u_char *ds = vec;
	const u_char *ls = lhs->vec;
	for (unsigned i=0; i<sz; i++) {
	    *(ds++) = ( (*(ls++)) == (rhs) );
	}
    }
    return IA_UcharDiscreteImage(domain, vec, sz, 1);
}
#endif // vec_scalar_u_char_u_char_u_char_pwise_eq

static IA_UcharDiscreteImage
vec_iter_bo_pwise_eq(const IA_VectorDI<u_char> *lhs,IA_UcharDiscreteImage rhs)
{
    const IA_IntPointSet domain = lhs->domain();
    const unsigned sz = domain.card();
    u_char *const vec = new u_char[sz];

    {
	u_char *ds = vec;
	const u_char *ls = lhs->vec;
	u_char rtmp;
	IA_DIVIter<u_char>	riter(rhs);
	for (unsigned i=0; i<sz; i++) {
	    riter(rtmp);
	    *(ds++) = ( (*(ls++)) == (rtmp) );
	}
    }
    return IA_UcharDiscreteImage(domain, vec, sz, 1);
}

// scalar-scalar operation is trivial

#ifndef scalar_iter_u_char_u_char_u_char_pwise_eq
#define scalar_iter_u_char_u_char_u_char_pwise_eq
static IA_UcharDiscreteImage
scalar_iter_bo_pwise_eq(u_char lhs,IA_UcharDiscreteImage rhs)
{
    const IA_IntPointSet domain = rhs.domain();
    const unsigned sz = domain.card();
    u_char *const vec = new u_char[sz];

    {
	u_char *ds = vec;
	u_char rtmp;
	IA_DIVIter<u_char>	riter(rhs);
	for (unsigned i=0; i<sz; i++) {
	    riter(rtmp);
	    *(ds++) = ( (lhs) == (rtmp) );
	}
    }
    return IA_UcharDiscreteImage(domain, vec, sz, 1);
}
#endif // scalar_iter_u_char_u_char_u_char_pwise_eq

static IA_UcharDiscreteImage
iter_iter_bo_pwise_eq(IA_UcharDiscreteImage lhs,IA_UcharDiscreteImage rhs)
{
    const IA_IntPointSet domain = lhs.domain();
    const unsigned sz = domain.card();
    u_char *const vec = new u_char[sz];

    {
	u_char *ds = vec;
	u_char ltmp;
	IA_DIVIter<u_char>	liter(lhs);
	u_char rtmp;
	IA_DIVIter<u_char>	riter(rhs);
	for (unsigned i=0; i<sz; i++) {
	    liter(ltmp);
	    riter(rtmp);
	    *(ds++) = ( (ltmp) == (rtmp) );
	}
    }
    return IA_UcharDiscreteImage(domain, vec, sz, 1);
}

IA_UcharDiscreteImage
pwise_eq ( const IA_UcharDiscreteImage &lhs,
	      const IA_UcharDiscreteImage &rhs)
{
    if (lhs.domain() != rhs.domain()) {
	static IA_UcharDiscreteImage	rval;
	ia_throw( IA::PSET_MISMATCH, __FILE__,__LINE__);
	return rval;
    }

    if (lhs.type() == IA_VectorDI<u_char>::s_type()) {
	if (rhs.type() == IA_VectorDI<u_char>::s_type()) {
	    return vec_vec_bo_pwise_eq((IA_VectorDI<u_char> *)lhs.bdip,(IA_VectorDI<u_char> *)rhs.bdip);
	} else if (rhs.type() == IA_ConstDI<u_char>::s_type()) {
	    return vec_scalar_bo_pwise_eq((IA_VectorDI<u_char> *)lhs.bdip,((IA_ConstDI<u_char> *)rhs.bdip)->value);
	} else {
	    return vec_iter_bo_pwise_eq((IA_VectorDI<u_char> *)lhs.bdip,rhs);
	}
    } else if (lhs.type() == IA_ConstDI<u_char>::s_type()) {
	if (rhs.type() == IA_VectorDI<u_char>::s_type()) {
	    return vec_scalar_bo_pwise_eq((IA_VectorDI<u_char> *)rhs.bdip,((IA_ConstDI<u_char> *)lhs.bdip)->value);
	} else if (rhs.type() == IA_ConstDI<u_char>::s_type()) {
	    return IA_UcharDiscreteImage (lhs.domain(), (((IA_ConstDI<u_char> *)lhs.bdip)->value) == (((IA_ConstDI<u_char> *)rhs.bdip)->value));
	} else {
	    return scalar_iter_bo_pwise_eq(((IA_ConstDI<u_char> *)lhs.bdip)->value,rhs);
	}
    } else {
	if (rhs.type() == IA_VectorDI<u_char>::s_type()) {
	    return vec_iter_bo_pwise_eq((IA_VectorDI<u_char> *)rhs.bdip,lhs);
	} else if (rhs.type() == IA_ConstDI<u_char>::s_type()) {
	    return scalar_iter_bo_pwise_eq(((IA_ConstDI<u_char> *)rhs.bdip)->value,lhs);
	} else {
	    return iter_iter_bo_pwise_eq(lhs,rhs);
	}
    }
}

//////////////////////////////////////////////////////////////////////
//
// Begin operation support routines for :
// binary pointwise commutative pwise_eq subop=operator== I(u_char) int I(u_char)
//
#ifndef vec_scalar_u_char_u_char_int_pwise_eq
#define vec_scalar_u_char_u_char_int_pwise_eq
static IA_UcharDiscreteImage
vec_scalar_bo_pwise_eq(const IA_VectorDI<u_char> *lhs,int rhs)
{
    const IA_IntPointSet domain = lhs->domain();
    const unsigned sz = domain.card();
    u_char *const vec = new u_char[sz];

    {
	u_char *ds = vec;
	const u_char *ls = lhs->vec;
	for (unsigned i=0; i<sz; i++) {
	    *(ds++) = ( (*(ls++)) == (rhs) );
	}
    }
    return IA_UcharDiscreteImage(domain, vec, sz, 1);
}
#endif // vec_scalar_u_char_u_char_int_pwise_eq

// scalar-scalar operation is trivial

#ifndef iter_scalar_u_char_u_char_int_pwise_eq
#define iter_scalar_u_char_u_char_int_pwise_eq
static IA_UcharDiscreteImage
iter_scalar_bo_pwise_eq(IA_UcharDiscreteImage lhs,int rhs)
{
    const IA_IntPointSet domain = lhs.domain();
    const unsigned sz = domain.card();
    u_char *const vec = new u_char[sz];

    {
	u_char *ds = vec;
	u_char ltmp;
	IA_DIVIter<u_char>	liter(lhs);
	for (unsigned i=0; i<sz; i++) {
	    liter(ltmp);
	    *(ds++) = ( (ltmp) == (rhs) );
	}
    }
    return IA_UcharDiscreteImage(domain, vec, sz, 1);
}
#endif // iter_scalar_u_char_u_char_int_pwise_eq

IA_UcharDiscreteImage
pwise_eq ( const IA_UcharDiscreteImage &lhs, int rhs)
{
    if (lhs.type() == IA_VectorDI<u_char>::s_type()) {
	return vec_scalar_bo_pwise_eq((IA_VectorDI<u_char> *)lhs.bdip,rhs);
    } else if (lhs.type() == IA_ConstDI<u_char>::s_type()) {
	return IA_UcharDiscreteImage (lhs.domain(), (((IA_ConstDI<u_char> *)lhs.bdip)->value) == (rhs));
    } else {
	return iter_scalar_bo_pwise_eq(lhs,rhs);
    }
}

//////////////////////////////////////////////////////////////////////
//
// Begin operation support routines for :
// binary pointwise commutative pwise_ne subop=operator!= I(u_char) I(u_char) I(u_char)
//
static IA_UcharDiscreteImage
vec_vec_bo_pwise_ne(const IA_VectorDI<u_char> *lhs,const IA_VectorDI<u_char> *rhs)
{
    const IA_IntPointSet domain = lhs->domain();
    const unsigned sz = domain.card();
    u_char *const vec = new u_char[sz];

    {
	u_char *ds = vec;
	const u_char *ls = lhs->vec;
	const u_char *rs = rhs->vec;
	for (unsigned i=0; i<sz; i++) {
	    *(ds++) = ( (*(ls++)) != (*(rs++)) );
	}
    }
    return IA_UcharDiscreteImage(domain, vec, sz, 1);
}

#ifndef vec_scalar_u_char_u_char_u_char_pwise_ne
#define vec_scalar_u_char_u_char_u_char_pwise_ne
static IA_UcharDiscreteImage
vec_scalar_bo_pwise_ne(const IA_VectorDI<u_char> *lhs,u_char rhs)
{
    const IA_IntPointSet domain = lhs->domain();
    const unsigned sz = domain.card();
    u_char *const vec = new u_char[sz];

    {
	u_char *ds = vec;
	const u_char *ls = lhs->vec;
	for (unsigned i=0; i<sz; i++) {
	    *(ds++) = ( (*(ls++)) != (rhs) );
	}
    }
    return IA_UcharDiscreteImage(domain, vec, sz, 1);
}
#endif // vec_scalar_u_char_u_char_u_char_pwise_ne

static IA_UcharDiscreteImage
vec_iter_bo_pwise_ne(const IA_VectorDI<u_char> *lhs,IA_UcharDiscreteImage rhs)
{
    const IA_IntPointSet domain = lhs->domain();
    const unsigned sz = domain.card();
    u_char *const vec = new u_char[sz];

    {
	u_char *ds = vec;
	const u_char *ls = lhs->vec;
	u_char rtmp;
	IA_DIVIter<u_char>	riter(rhs);
	for (unsigned i=0; i<sz; i++) {
	    riter(rtmp);
	    *(ds++) = ( (*(ls++)) != (rtmp) );
	}
    }
    return IA_UcharDiscreteImage(domain, vec, sz, 1);
}

// scalar-scalar operation is trivial

#ifndef scalar_iter_u_char_u_char_u_char_pwise_ne
#define scalar_iter_u_char_u_char_u_char_pwise_ne
static IA_UcharDiscreteImage
scalar_iter_bo_pwise_ne(u_char lhs,IA_UcharDiscreteImage rhs)
{
    const IA_IntPointSet domain = rhs.domain();
    const unsigned sz = domain.card();
    u_char *const vec = new u_char[sz];

    {
	u_char *ds = vec;
	u_char rtmp;
	IA_DIVIter<u_char>	riter(rhs);
	for (unsigned i=0; i<sz; i++) {
	    riter(rtmp);
	    *(ds++) = ( (lhs) != (rtmp) );
	}
    }
    return IA_UcharDiscreteImage(domain, vec, sz, 1);
}
#endif // scalar_iter_u_char_u_char_u_char_pwise_ne

static IA_UcharDiscreteImage
iter_iter_bo_pwise_ne(IA_UcharDiscreteImage lhs,IA_UcharDiscreteImage rhs)
{
    const IA_IntPointSet domain = lhs.domain();
    const unsigned sz = domain.card();
    u_char *const vec = new u_char[sz];

    {
	u_char *ds = vec;
	u_char ltmp;
	IA_DIVIter<u_char>	liter(lhs);
	u_char rtmp;
	IA_DIVIter<u_char>	riter(rhs);
	for (unsigned i=0; i<sz; i++) {
	    liter(ltmp);
	    riter(rtmp);
	    *(ds++) = ( (ltmp) != (rtmp) );
	}
    }
    return IA_UcharDiscreteImage(domain, vec, sz, 1);
}

IA_UcharDiscreteImage
pwise_ne ( const IA_UcharDiscreteImage &lhs,
	      const IA_UcharDiscreteImage &rhs)
{
    if (lhs.domain() != rhs.domain()) {
	static IA_UcharDiscreteImage	rval;
	ia_throw( IA::PSET_MISMATCH, __FILE__,__LINE__);
	return rval;
    }

    if (lhs.type() == IA_VectorDI<u_char>::s_type()) {
	if (rhs.type() == IA_VectorDI<u_char>::s_type()) {
	    return vec_vec_bo_pwise_ne((IA_VectorDI<u_char> *)lhs.bdip,(IA_VectorDI<u_char> *)rhs.bdip);
	} else if (rhs.type() == IA_ConstDI<u_char>::s_type()) {
	    return vec_scalar_bo_pwise_ne((IA_VectorDI<u_char> *)lhs.bdip,((IA_ConstDI<u_char> *)rhs.bdip)->value);
	} else {
	    return vec_iter_bo_pwise_ne((IA_VectorDI<u_char> *)lhs.bdip,rhs);
	}
    } else if (lhs.type() == IA_ConstDI<u_char>::s_type()) {
	if (rhs.type() == IA_VectorDI<u_char>::s_type()) {
	    return vec_scalar_bo_pwise_ne((IA_VectorDI<u_char> *)rhs.bdip,((IA_ConstDI<u_char> *)lhs.bdip)->value);
	} else if (rhs.type() == IA_ConstDI<u_char>::s_type()) {
	    return IA_UcharDiscreteImage (lhs.domain(), (((IA_ConstDI<u_char> *)lhs.bdip)->value) != (((IA_ConstDI<u_char> *)rhs.bdip)->value));
	} else {
	    return scalar_iter_bo_pwise_ne(((IA_ConstDI<u_char> *)lhs.bdip)->value,rhs);
	}
    } else {
	if (rhs.type() == IA_VectorDI<u_char>::s_type()) {
	    return vec_iter_bo_pwise_ne((IA_VectorDI<u_char> *)rhs.bdip,lhs);
	} else if (rhs.type() == IA_ConstDI<u_char>::s_type()) {
	    return scalar_iter_bo_pwise_ne(((IA_ConstDI<u_char> *)rhs.bdip)->value,lhs);
	} else {
	    return iter_iter_bo_pwise_ne(lhs,rhs);
	}
    }
}

//////////////////////////////////////////////////////////////////////
//
// Begin operation support routines for :
// binary pointwise commutative pwise_ne subop=operator!= I(u_char) int I(u_char)
//
#ifndef vec_scalar_u_char_u_char_int_pwise_ne
#define vec_scalar_u_char_u_char_int_pwise_ne
static IA_UcharDiscreteImage
vec_scalar_bo_pwise_ne(const IA_VectorDI<u_char> *lhs,int rhs)
{
    const IA_IntPointSet domain = lhs->domain();
    const unsigned sz = domain.card();
    u_char *const vec = new u_char[sz];

    {
	u_char *ds = vec;
	const u_char *ls = lhs->vec;
	for (unsigned i=0; i<sz; i++) {
	    *(ds++) = ( (*(ls++)) != (rhs) );
	}
    }
    return IA_UcharDiscreteImage(domain, vec, sz, 1);
}
#endif // vec_scalar_u_char_u_char_int_pwise_ne

// scalar-scalar operation is trivial

#ifndef iter_scalar_u_char_u_char_int_pwise_ne
#define iter_scalar_u_char_u_char_int_pwise_ne
static IA_UcharDiscreteImage
iter_scalar_bo_pwise_ne(IA_UcharDiscreteImage lhs,int rhs)
{
    const IA_IntPointSet domain = lhs.domain();
    const unsigned sz = domain.card();
    u_char *const vec = new u_char[sz];

    {
	u_char *ds = vec;
	u_char ltmp;
	IA_DIVIter<u_char>	liter(lhs);
	for (unsigned i=0; i<sz; i++) {
	    liter(ltmp);
	    *(ds++) = ( (ltmp) != (rhs) );
	}
    }
    return IA_UcharDiscreteImage(domain, vec, sz, 1);
}
#endif // iter_scalar_u_char_u_char_int_pwise_ne

IA_UcharDiscreteImage
pwise_ne ( const IA_UcharDiscreteImage &lhs, int rhs)
{
    if (lhs.type() == IA_VectorDI<u_char>::s_type()) {
	return vec_scalar_bo_pwise_ne((IA_VectorDI<u_char> *)lhs.bdip,rhs);
    } else if (lhs.type() == IA_ConstDI<u_char>::s_type()) {
	return IA_UcharDiscreteImage (lhs.domain(), (((IA_ConstDI<u_char> *)lhs.bdip)->value) != (rhs));
    } else {
	return iter_scalar_bo_pwise_ne(lhs,rhs);
    }
}

//////////////////////////////////////////////////////////////////////
//
// Begin operation support routines for :
// binary pointwise non-commutative pwise_ge subop=operator>= I(u_char) I(u_char) I(u_char)
//
static IA_UcharDiscreteImage
vec_vec_bo_pwise_ge(const IA_VectorDI<u_char> *lhs,const IA_VectorDI<u_char> *rhs)
{
    const IA_IntPointSet domain = lhs->domain();
    const unsigned sz = domain.card();
    u_char *const vec = new u_char[sz];

    {
	u_char *ds = vec;
	const u_char *ls = lhs->vec;
	const u_char *rs = rhs->vec;
	for (unsigned i=0; i<sz; i++) {
	    *(ds++) = ( (*(ls++)) >= (*(rs++)) );
	}
    }
    return IA_UcharDiscreteImage(domain, vec, sz, 1);
}

#ifndef vec_scalar_u_char_u_char_u_char_pwise_ge
#define vec_scalar_u_char_u_char_u_char_pwise_ge
static IA_UcharDiscreteImage
vec_scalar_bo_pwise_ge(const IA_VectorDI<u_char> *lhs,u_char rhs)
{
    const IA_IntPointSet domain = lhs->domain();
    const unsigned sz = domain.card();
    u_char *const vec = new u_char[sz];

    {
	u_char *ds = vec;
	const u_char *ls = lhs->vec;
	for (unsigned i=0; i<sz; i++) {
	    *(ds++) = ( (*(ls++)) >= (rhs) );
	}
    }
    return IA_UcharDiscreteImage(domain, vec, sz, 1);
}
#endif // vec_scalar_u_char_u_char_u_char_pwise_ge

static IA_UcharDiscreteImage
vec_iter_bo_pwise_ge(const IA_VectorDI<u_char> *lhs,IA_UcharDiscreteImage rhs)
{
    const IA_IntPointSet domain = lhs->domain();
    const unsigned sz = domain.card();
    u_char *const vec = new u_char[sz];

    {
	u_char *ds = vec;
	const u_char *ls = lhs->vec;
	u_char rtmp;
	IA_DIVIter<u_char>	riter(rhs);
	for (unsigned i=0; i<sz; i++) {
	    riter(rtmp);
	    *(ds++) = ( (*(ls++)) >= (rtmp) );
	}
    }
    return IA_UcharDiscreteImage(domain, vec, sz, 1);
}

#ifndef scalar_vec_u_char_u_char_u_char_pwise_ge
#define scalar_vec_u_char_u_char_u_char_pwise_ge
static IA_UcharDiscreteImage
scalar_vec_bo_pwise_ge(u_char lhs,const IA_VectorDI<u_char> *rhs)
{
    const IA_IntPointSet domain = rhs->domain();
    const unsigned sz = domain.card();
    u_char *const vec = new u_char[sz];

    {
	u_char *ds = vec;
	const u_char *rs = rhs->vec;
	for (unsigned i=0; i<sz; i++) {
	    *(ds++) = ( (lhs) >= (*(rs++)) );
	}
    }
    return IA_UcharDiscreteImage(domain, vec, sz, 1);
}
#endif // scalar_vec_u_char_u_char_u_char_pwise_ge

// scalar-scalar operation is trivial

#ifndef scalar_iter_u_char_u_char_u_char_pwise_ge
#define scalar_iter_u_char_u_char_u_char_pwise_ge
static IA_UcharDiscreteImage
scalar_iter_bo_pwise_ge(u_char lhs,IA_UcharDiscreteImage rhs)
{
    const IA_IntPointSet domain = rhs.domain();
    const unsigned sz = domain.card();
    u_char *const vec = new u_char[sz];

    {
	u_char *ds = vec;
	u_char rtmp;
	IA_DIVIter<u_char>	riter(rhs);
	for (unsigned i=0; i<sz; i++) {
	    riter(rtmp);
	    *(ds++) = ( (lhs) >= (rtmp) );
	}
    }
    return IA_UcharDiscreteImage(domain, vec, sz, 1);
}
#endif // scalar_iter_u_char_u_char_u_char_pwise_ge

static IA_UcharDiscreteImage
iter_vec_bo_pwise_ge(IA_UcharDiscreteImage lhs,const IA_VectorDI<u_char> *rhs)
{
    const IA_IntPointSet domain = lhs.domain();
    const unsigned sz = domain.card();
    u_char *const vec = new u_char[sz];

    {
	u_char *ds = vec;
	u_char ltmp;
	IA_DIVIter<u_char>	liter(lhs);
	const u_char *rs = rhs->vec;
	for (unsigned i=0; i<sz; i++) {
	    liter(ltmp);
	    *(ds++) = ( (ltmp) >= (*(rs++)) );
	}
    }
    return IA_UcharDiscreteImage(domain, vec, sz, 1);
}

#ifndef iter_scalar_u_char_u_char_u_char_pwise_ge
#define iter_scalar_u_char_u_char_u_char_pwise_ge
static IA_UcharDiscreteImage
iter_scalar_bo_pwise_ge(IA_UcharDiscreteImage lhs,u_char rhs)
{
    const IA_IntPointSet domain = lhs.domain();
    const unsigned sz = domain.card();
    u_char *const vec = new u_char[sz];

    {
	u_char *ds = vec;
	u_char ltmp;
	IA_DIVIter<u_char>	liter(lhs);
	for (unsigned i=0; i<sz; i++) {
	    liter(ltmp);
	    *(ds++) = ( (ltmp) >= (rhs) );
	}
    }
    return IA_UcharDiscreteImage(domain, vec, sz, 1);
}
#endif // iter_scalar_u_char_u_char_u_char_pwise_ge

static IA_UcharDiscreteImage
iter_iter_bo_pwise_ge(IA_UcharDiscreteImage lhs,IA_UcharDiscreteImage rhs)
{
    const IA_IntPointSet domain = lhs.domain();
    const unsigned sz = domain.card();
    u_char *const vec = new u_char[sz];

    {
	u_char *ds = vec;
	u_char ltmp;
	IA_DIVIter<u_char>	liter(lhs);
	u_char rtmp;
	IA_DIVIter<u_char>	riter(rhs);
	for (unsigned i=0; i<sz; i++) {
	    liter(ltmp);
	    riter(rtmp);
	    *(ds++) = ( (ltmp) >= (rtmp) );
	}
    }
    return IA_UcharDiscreteImage(domain, vec, sz, 1);
}

IA_UcharDiscreteImage
pwise_ge ( const IA_UcharDiscreteImage &lhs,
	      const IA_UcharDiscreteImage &rhs)
{
    if (lhs.domain() != rhs.domain()) {
	static IA_UcharDiscreteImage	rval;
	ia_throw( IA::PSET_MISMATCH, __FILE__,__LINE__);
	return rval;
    }

    if (lhs.type() == IA_VectorDI<u_char>::s_type()) {
	if (rhs.type() == IA_VectorDI<u_char>::s_type()) {
	    return vec_vec_bo_pwise_ge((IA_VectorDI<u_char> *)lhs.bdip,(IA_VectorDI<u_char> *)rhs.bdip);
	} else if (rhs.type() == IA_ConstDI<u_char>::s_type()) {
	    return vec_scalar_bo_pwise_ge((IA_VectorDI<u_char> *)lhs.bdip,((IA_ConstDI<u_char> *)rhs.bdip)->value);
	} else {
	    return vec_iter_bo_pwise_ge((IA_VectorDI<u_char> *)lhs.bdip,rhs);
	}
    } else if (lhs.type() == IA_ConstDI<u_char>::s_type()) {
	if (rhs.type() == IA_VectorDI<u_char>::s_type()) {
	    return scalar_vec_bo_pwise_ge(((IA_ConstDI<u_char> *)lhs.bdip)->value,(IA_VectorDI<u_char> *)rhs.bdip);
	} else if (rhs.type() == IA_ConstDI<u_char>::s_type()) {
	    return IA_UcharDiscreteImage (lhs.domain(), (((IA_ConstDI<u_char> *)lhs.bdip)->value) >= (((IA_ConstDI<u_char> *)rhs.bdip)->value));
	} else {
	    return scalar_iter_bo_pwise_ge(((IA_ConstDI<u_char> *)lhs.bdip)->value,rhs);
	}
    } else {
	if (rhs.type() == IA_VectorDI<u_char>::s_type()) {
	    return iter_vec_bo_pwise_ge(lhs,(IA_VectorDI<u_char> *)rhs.bdip);
	} else if (rhs.type() == IA_ConstDI<u_char>::s_type()) {
	    return iter_scalar_bo_pwise_ge(lhs,((IA_ConstDI<u_char> *)rhs.bdip)->value);
	} else {
	    return iter_iter_bo_pwise_ge(lhs,rhs);
	}
    }
}

//////////////////////////////////////////////////////////////////////
//
// Begin operation support routines for :
// binary pointwise non-commutative pwise_ge subop=operator>= I(u_char) int I(u_char)
//
#ifndef vec_scalar_u_char_u_char_int_pwise_ge
#define vec_scalar_u_char_u_char_int_pwise_ge
static IA_UcharDiscreteImage
vec_scalar_bo_pwise_ge(const IA_VectorDI<u_char> *lhs,int rhs)
{
    const IA_IntPointSet domain = lhs->domain();
    const unsigned sz = domain.card();
    u_char *const vec = new u_char[sz];

    {
	u_char *ds = vec;
	const u_char *ls = lhs->vec;
	for (unsigned i=0; i<sz; i++) {
	    *(ds++) = ( (*(ls++)) >= (rhs) );
	}
    }
    return IA_UcharDiscreteImage(domain, vec, sz, 1);
}
#endif // vec_scalar_u_char_u_char_int_pwise_ge

// scalar-scalar operation is trivial

#ifndef iter_scalar_u_char_u_char_int_pwise_ge
#define iter_scalar_u_char_u_char_int_pwise_ge
static IA_UcharDiscreteImage
iter_scalar_bo_pwise_ge(IA_UcharDiscreteImage lhs,int rhs)
{
    const IA_IntPointSet domain = lhs.domain();
    const unsigned sz = domain.card();
    u_char *const vec = new u_char[sz];

    {
	u_char *ds = vec;
	u_char ltmp;
	IA_DIVIter<u_char>	liter(lhs);
	for (unsigned i=0; i<sz; i++) {
	    liter(ltmp);
	    *(ds++) = ( (ltmp) >= (rhs) );
	}
    }
    return IA_UcharDiscreteImage(domain, vec, sz, 1);
}
#endif // iter_scalar_u_char_u_char_int_pwise_ge

IA_UcharDiscreteImage
pwise_ge ( const IA_UcharDiscreteImage &lhs, int rhs)
{
    if (lhs.type() == IA_VectorDI<u_char>::s_type()) {
	return vec_scalar_bo_pwise_ge((IA_VectorDI<u_char> *)lhs.bdip,rhs);
    } else if (lhs.type() == IA_ConstDI<u_char>::s_type()) {
	return IA_UcharDiscreteImage (lhs.domain(), (((IA_ConstDI<u_char> *)lhs.bdip)->value) >= (rhs));
    } else {
	return iter_scalar_bo_pwise_ge(lhs,rhs);
    }
}

//////////////////////////////////////////////////////////////////////
//
// Begin operation support routines for :
// binary pointwise non-commutative pwise_ge subop=operator>= int I(u_char) I(u_char)
//
#ifndef scalar_vec_u_char_int_u_char_pwise_ge
#define scalar_vec_u_char_int_u_char_pwise_ge
static IA_UcharDiscreteImage
scalar_vec_bo_pwise_ge(int lhs,const IA_VectorDI<u_char> *rhs)
{
    const IA_IntPointSet domain = rhs->domain();
    const unsigned sz = domain.card();
    u_char *const vec = new u_char[sz];

    {
	u_char *ds = vec;
	const u_char *rs = rhs->vec;
	for (unsigned i=0; i<sz; i++) {
	    *(ds++) = ( (lhs) >= (*(rs++)) );
	}
    }
    return IA_UcharDiscreteImage(domain, vec, sz, 1);
}
#endif // scalar_vec_u_char_int_u_char_pwise_ge

// scalar-scalar operation is trivial

#ifndef scalar_iter_u_char_int_u_char_pwise_ge
#define scalar_iter_u_char_int_u_char_pwise_ge
static IA_UcharDiscreteImage
scalar_iter_bo_pwise_ge(int lhs,IA_UcharDiscreteImage rhs)
{
    const IA_IntPointSet domain = rhs.domain();
    const unsigned sz = domain.card();
    u_char *const vec = new u_char[sz];

    {
	u_char *ds = vec;
	u_char rtmp;
	IA_DIVIter<u_char>	riter(rhs);
	for (unsigned i=0; i<sz; i++) {
	    riter(rtmp);
	    *(ds++) = ( (lhs) >= (rtmp) );
	}
    }
    return IA_UcharDiscreteImage(domain, vec, sz, 1);
}
#endif // scalar_iter_u_char_int_u_char_pwise_ge

IA_UcharDiscreteImage
pwise_ge (int lhs, const IA_UcharDiscreteImage &rhs)
{
    if (rhs.type() == IA_VectorDI<u_char>::s_type()) {
	return scalar_vec_bo_pwise_ge(lhs,(IA_VectorDI<u_char> *)rhs.bdip);
    } else if (rhs.type() == IA_ConstDI<u_char>::s_type()) {
	return IA_UcharDiscreteImage (rhs.domain(), (lhs) >= (((IA_ConstDI<u_char> *)rhs.bdip)->value));
    } else {
	return scalar_iter_bo_pwise_ge(lhs,rhs);
    }
}

//////////////////////////////////////////////////////////////////////
//
// Begin operation support routines for :
// binary pointwise non-commutative pwise_gt subop=operator> I(u_char) I(u_char) I(u_char)
//
static IA_UcharDiscreteImage
vec_vec_bo_pwise_gt(const IA_VectorDI<u_char> *lhs,const IA_VectorDI<u_char> *rhs)
{
    const IA_IntPointSet domain = lhs->domain();
    const unsigned sz = domain.card();
    u_char *const vec = new u_char[sz];

    {
	u_char *ds = vec;
	const u_char *ls = lhs->vec;
	const u_char *rs = rhs->vec;
	for (unsigned i=0; i<sz; i++) {
	    *(ds++) = ( (*(ls++)) > (*(rs++)) );
	}
    }
    return IA_UcharDiscreteImage(domain, vec, sz, 1);
}

#ifndef vec_scalar_u_char_u_char_u_char_pwise_gt
#define vec_scalar_u_char_u_char_u_char_pwise_gt
static IA_UcharDiscreteImage
vec_scalar_bo_pwise_gt(const IA_VectorDI<u_char> *lhs,u_char rhs)
{
    const IA_IntPointSet domain = lhs->domain();
    const unsigned sz = domain.card();
    u_char *const vec = new u_char[sz];

    {
	u_char *ds = vec;
	const u_char *ls = lhs->vec;
	for (unsigned i=0; i<sz; i++) {
	    *(ds++) = ( (*(ls++)) > (rhs) );
	}
    }
    return IA_UcharDiscreteImage(domain, vec, sz, 1);
}
#endif // vec_scalar_u_char_u_char_u_char_pwise_gt

static IA_UcharDiscreteImage
vec_iter_bo_pwise_gt(const IA_VectorDI<u_char> *lhs,IA_UcharDiscreteImage rhs)
{
    const IA_IntPointSet domain = lhs->domain();
    const unsigned sz = domain.card();
    u_char *const vec = new u_char[sz];

    {
	u_char *ds = vec;
	const u_char *ls = lhs->vec;
	u_char rtmp;
	IA_DIVIter<u_char>	riter(rhs);
	for (unsigned i=0; i<sz; i++) {
	    riter(rtmp);
	    *(ds++) = ( (*(ls++)) > (rtmp) );
	}
    }
    return IA_UcharDiscreteImage(domain, vec, sz, 1);
}

#ifndef scalar_vec_u_char_u_char_u_char_pwise_gt
#define scalar_vec_u_char_u_char_u_char_pwise_gt
static IA_UcharDiscreteImage
scalar_vec_bo_pwise_gt(u_char lhs,const IA_VectorDI<u_char> *rhs)
{
    const IA_IntPointSet domain = rhs->domain();
    const unsigned sz = domain.card();
    u_char *const vec = new u_char[sz];

    {
	u_char *ds = vec;
	const u_char *rs = rhs->vec;
	for (unsigned i=0; i<sz; i++) {
	    *(ds++) = ( (lhs) > (*(rs++)) );
	}
    }
    return IA_UcharDiscreteImage(domain, vec, sz, 1);
}
#endif // scalar_vec_u_char_u_char_u_char_pwise_gt

// scalar-scalar operation is trivial

#ifndef scalar_iter_u_char_u_char_u_char_pwise_gt
#define scalar_iter_u_char_u_char_u_char_pwise_gt
static IA_UcharDiscreteImage
scalar_iter_bo_pwise_gt(u_char lhs,IA_UcharDiscreteImage rhs)
{
    const IA_IntPointSet domain = rhs.domain();
    const unsigned sz = domain.card();
    u_char *const vec = new u_char[sz];

    {
	u_char *ds = vec;
	u_char rtmp;
	IA_DIVIter<u_char>	riter(rhs);
	for (unsigned i=0; i<sz; i++) {
	    riter(rtmp);
	    *(ds++) = ( (lhs) > (rtmp) );
	}
    }
    return IA_UcharDiscreteImage(domain, vec, sz, 1);
}
#endif // scalar_iter_u_char_u_char_u_char_pwise_gt

static IA_UcharDiscreteImage
iter_vec_bo_pwise_gt(IA_UcharDiscreteImage lhs,const IA_VectorDI<u_char> *rhs)
{
    const IA_IntPointSet domain = lhs.domain();
    const unsigned sz = domain.card();
    u_char *const vec = new u_char[sz];

    {
	u_char *ds = vec;
	u_char ltmp;
	IA_DIVIter<u_char>	liter(lhs);
	const u_char *rs = rhs->vec;
	for (unsigned i=0; i<sz; i++) {
	    liter(ltmp);
	    *(ds++) = ( (ltmp) > (*(rs++)) );
	}
    }
    return IA_UcharDiscreteImage(domain, vec, sz, 1);
}

#ifndef iter_scalar_u_char_u_char_u_char_pwise_gt
#define iter_scalar_u_char_u_char_u_char_pwise_gt
static IA_UcharDiscreteImage
iter_scalar_bo_pwise_gt(IA_UcharDiscreteImage lhs,u_char rhs)
{
    const IA_IntPointSet domain = lhs.domain();
    const unsigned sz = domain.card();
    u_char *const vec = new u_char[sz];

    {
	u_char *ds = vec;
	u_char ltmp;
	IA_DIVIter<u_char>	liter(lhs);
	for (unsigned i=0; i<sz; i++) {
	    liter(ltmp);
	    *(ds++) = ( (ltmp) > (rhs) );
	}
    }
    return IA_UcharDiscreteImage(domain, vec, sz, 1);
}
#endif // iter_scalar_u_char_u_char_u_char_pwise_gt

static IA_UcharDiscreteImage
iter_iter_bo_pwise_gt(IA_UcharDiscreteImage lhs,IA_UcharDiscreteImage rhs)
{
    const IA_IntPointSet domain = lhs.domain();
    const unsigned sz = domain.card();
    u_char *const vec = new u_char[sz];

    {
	u_char *ds = vec;
	u_char ltmp;
	IA_DIVIter<u_char>	liter(lhs);
	u_char rtmp;
	IA_DIVIter<u_char>	riter(rhs);
	for (unsigned i=0; i<sz; i++) {
	    liter(ltmp);
	    riter(rtmp);
	    *(ds++) = ( (ltmp) > (rtmp) );
	}
    }
    return IA_UcharDiscreteImage(domain, vec, sz, 1);
}

IA_UcharDiscreteImage
pwise_gt ( const IA_UcharDiscreteImage &lhs,
	      const IA_UcharDiscreteImage &rhs)
{
    if (lhs.domain() != rhs.domain()) {
	static IA_UcharDiscreteImage	rval;
	ia_throw( IA::PSET_MISMATCH, __FILE__,__LINE__);
	return rval;
    }

    if (lhs.type() == IA_VectorDI<u_char>::s_type()) {
	if (rhs.type() == IA_VectorDI<u_char>::s_type()) {
	    return vec_vec_bo_pwise_gt((IA_VectorDI<u_char> *)lhs.bdip,(IA_VectorDI<u_char> *)rhs.bdip);
	} else if (rhs.type() == IA_ConstDI<u_char>::s_type()) {
	    return vec_scalar_bo_pwise_gt((IA_VectorDI<u_char> *)lhs.bdip,((IA_ConstDI<u_char> *)rhs.bdip)->value);
	} else {
	    return vec_iter_bo_pwise_gt((IA_VectorDI<u_char> *)lhs.bdip,rhs);
	}
    } else if (lhs.type() == IA_ConstDI<u_char>::s_type()) {
	if (rhs.type() == IA_VectorDI<u_char>::s_type()) {
	    return scalar_vec_bo_pwise_gt(((IA_ConstDI<u_char> *)lhs.bdip)->value,(IA_VectorDI<u_char> *)rhs.bdip);
	} else if (rhs.type() == IA_ConstDI<u_char>::s_type()) {
	    return IA_UcharDiscreteImage (lhs.domain(), (((IA_ConstDI<u_char> *)lhs.bdip)->value) > (((IA_ConstDI<u_char> *)rhs.bdip)->value));
	} else {
	    return scalar_iter_bo_pwise_gt(((IA_ConstDI<u_char> *)lhs.bdip)->value,rhs);
	}
    } else {
	if (rhs.type() == IA_VectorDI<u_char>::s_type()) {
	    return iter_vec_bo_pwise_gt(lhs,(IA_VectorDI<u_char> *)rhs.bdip);
	} else if (rhs.type() == IA_ConstDI<u_char>::s_type()) {
	    return iter_scalar_bo_pwise_gt(lhs,((IA_ConstDI<u_char> *)rhs.bdip)->value);
	} else {
	    return iter_iter_bo_pwise_gt(lhs,rhs);
	}
    }
}

//////////////////////////////////////////////////////////////////////
//
// Begin operation support routines for :
// binary pointwise non-commutative pwise_gt subop=operator> I(u_char) int I(u_char)
//
#ifndef vec_scalar_u_char_u_char_int_pwise_gt
#define vec_scalar_u_char_u_char_int_pwise_gt
static IA_UcharDiscreteImage
vec_scalar_bo_pwise_gt(const IA_VectorDI<u_char> *lhs,int rhs)
{
    const IA_IntPointSet domain = lhs->domain();
    const unsigned sz = domain.card();
    u_char *const vec = new u_char[sz];

    {
	u_char *ds = vec;
	const u_char *ls = lhs->vec;
	for (unsigned i=0; i<sz; i++) {
	    *(ds++) = ( (*(ls++)) > (rhs) );
	}
    }
    return IA_UcharDiscreteImage(domain, vec, sz, 1);
}
#endif // vec_scalar_u_char_u_char_int_pwise_gt

// scalar-scalar operation is trivial

#ifndef iter_scalar_u_char_u_char_int_pwise_gt
#define iter_scalar_u_char_u_char_int_pwise_gt
static IA_UcharDiscreteImage
iter_scalar_bo_pwise_gt(IA_UcharDiscreteImage lhs,int rhs)
{
    const IA_IntPointSet domain = lhs.domain();
    const unsigned sz = domain.card();
    u_char *const vec = new u_char[sz];

    {
	u_char *ds = vec;
	u_char ltmp;
	IA_DIVIter<u_char>	liter(lhs);
	for (unsigned i=0; i<sz; i++) {
	    liter(ltmp);
	    *(ds++) = ( (ltmp) > (rhs) );
	}
    }
    return IA_UcharDiscreteImage(domain, vec, sz, 1);
}
#endif // iter_scalar_u_char_u_char_int_pwise_gt

IA_UcharDiscreteImage
pwise_gt ( const IA_UcharDiscreteImage &lhs, int rhs)
{
    if (lhs.type() == IA_VectorDI<u_char>::s_type()) {
	return vec_scalar_bo_pwise_gt((IA_VectorDI<u_char> *)lhs.bdip,rhs);
    } else if (lhs.type() == IA_ConstDI<u_char>::s_type()) {
	return IA_UcharDiscreteImage (lhs.domain(), (((IA_ConstDI<u_char> *)lhs.bdip)->value) > (rhs));
    } else {
	return iter_scalar_bo_pwise_gt(lhs,rhs);
    }
}

//////////////////////////////////////////////////////////////////////
//
// Begin operation support routines for :
// binary pointwise non-commutative pwise_gt subop=operator> int I(u_char) I(u_char)
//
#ifndef scalar_vec_u_char_int_u_char_pwise_gt
#define scalar_vec_u_char_int_u_char_pwise_gt
static IA_UcharDiscreteImage
scalar_vec_bo_pwise_gt(int lhs,const IA_VectorDI<u_char> *rhs)
{
    const IA_IntPointSet domain = rhs->domain();
    const unsigned sz = domain.card();
    u_char *const vec = new u_char[sz];

    {
	u_char *ds = vec;
	const u_char *rs = rhs->vec;
	for (unsigned i=0; i<sz; i++) {
	    *(ds++) = ( (lhs) > (*(rs++)) );
	}
    }
    return IA_UcharDiscreteImage(domain, vec, sz, 1);
}
#endif // scalar_vec_u_char_int_u_char_pwise_gt

// scalar-scalar operation is trivial

#ifndef scalar_iter_u_char_int_u_char_pwise_gt
#define scalar_iter_u_char_int_u_char_pwise_gt
static IA_UcharDiscreteImage
scalar_iter_bo_pwise_gt(int lhs,IA_UcharDiscreteImage rhs)
{
    const IA_IntPointSet domain = rhs.domain();
    const unsigned sz = domain.card();
    u_char *const vec = new u_char[sz];

    {
	u_char *ds = vec;
	u_char rtmp;
	IA_DIVIter<u_char>	riter(rhs);
	for (unsigned i=0; i<sz; i++) {
	    riter(rtmp);
	    *(ds++) = ( (lhs) > (rtmp) );
	}
    }
    return IA_UcharDiscreteImage(domain, vec, sz, 1);
}
#endif // scalar_iter_u_char_int_u_char_pwise_gt

IA_UcharDiscreteImage
pwise_gt (int lhs, const IA_UcharDiscreteImage &rhs)
{
    if (rhs.type() == IA_VectorDI<u_char>::s_type()) {
	return scalar_vec_bo_pwise_gt(lhs,(IA_VectorDI<u_char> *)rhs.bdip);
    } else if (rhs.type() == IA_ConstDI<u_char>::s_type()) {
	return IA_UcharDiscreteImage (rhs.domain(), (lhs) > (((IA_ConstDI<u_char> *)rhs.bdip)->value));
    } else {
	return scalar_iter_bo_pwise_gt(lhs,rhs);
    }
}

//////////////////////////////////////////////////////////////////////
//
// Begin operation support routines for :
// reduction reduce_plus subop=operator+ int I(u_char)
//
// Emacs: -*- C++ -*-

//
//	Copyright 1993, Center for Computer Vision and Visualization,
//	University of Florida.  All rights reserved.
//


//
// $Log:	reduce_op_nz,v $
// Revision 1.3  93/05/27  11:49:00  thoth
// Copyright Notices
// 
// Revision 1.2  93/04/08  13:23:45  thoth
// const_reduce can be overridden in the including file.
// 
// Revision 1.1  93/03/10  13:49:34  thoth
// Initial revision
// 

static int vec_reduce_reduce_plus(const IA_VectorDI<u_char> *arg)
{
    const u_char *ls = arg->vec;

    int	rval=*(ls++);

    const unsigned sz = arg->domain().card();
    for (unsigned i=1; i<sz; i++) {
	rval = ( (rval) +  (*(ls++)));
    }

    return rval;
}

#ifndef const_reduce_int_u_char_reduce_plus
#define const_reduce_int_u_char_reduce_plus
static int const_reduce_reduce_plus(unsigned sz, u_char arg)
{
    int	rval=arg;
    for (unsigned i=1; i<sz; i++) {
	rval = ( (rval) + arg);
    }
    return rval;
}
#endif

static int iter_reduce_reduce_plus(const IA_UcharDiscreteImage &arg)
{
    IA_DIVIter<u_char>	iter(arg);

    u_char	temp;
    iter(temp);

    int	rval=temp;

    while(iter(temp)) {
	rval = ( (rval) +  temp);
    }

    return rval;
}

int reduce_plus ( const IA_UcharDiscreteImage &arg)
{
    if (arg.domain().card()==0)
	abort(); // XXX unfinished code

    if (arg.type() == IA_VectorDI<u_char>::s_type()) {
	return vec_reduce_reduce_plus((IA_VectorDI<u_char> *)arg.bdip);
    } else if (arg.type() == IA_ConstDI<u_char>::s_type()) {
	return const_reduce_reduce_plus(arg.domain().card(),
				   ((IA_ConstDI<u_char> *)arg.bdip)->value);
    } else {
	return iter_reduce_reduce_plus(arg);
    }
}

//////////////////////////////////////////////////////////////////////
//
// Begin operation support routines for :
// reduction max subop=max int I(u_char)
//
// Emacs: -*- C++ -*-

//
//	Copyright 1993, Center for Computer Vision and Visualization,
//	University of Florida.  All rights reserved.
//


//
// $Log:	reduce_fn_nz,v $
// Revision 1.2  93/05/27  11:49:03  thoth
// Copyright Notices
// 
// Revision 1.1  93/03/10  13:49:13  thoth
// Initial revision
// 

static int vec_reduce_max(const IA_VectorDI<u_char> *arg)
{
    const u_char *ls = arg->vec;

    int	rval=*(ls++);

    const unsigned sz = arg->domain().card();
    for (unsigned i=1; i<sz; i++) {
	rval = max( rval, (*(ls++)));
    }

    return rval;
}

#ifndef const_reduce_int_u_char_max
#define const_reduce_int_u_char_max
static int const_reduce_max(unsigned sz, u_char arg)
{
    int	rval=arg;
    for (unsigned i=1; i<sz; i++) {
	rval = max(rval, arg);
    }
    return rval;
}
#endif

static int iter_reduce_max(const IA_UcharDiscreteImage &arg)
{
    IA_DIVIter<u_char>	iter(arg);

    u_char	temp;
    iter(temp);

    int	rval=temp;

    while(iter(temp)) {
	rval = max(rval, temp);
    }

    return rval;
}

int max ( const IA_UcharDiscreteImage &arg)
{
    if (arg.domain().card()==0)
	abort(); // XXX unfinished code

    if (arg.type() == IA_VectorDI<u_char>::s_type()) {
	return vec_reduce_max((IA_VectorDI<u_char> *)arg.bdip);
    } else if (arg.type() == IA_ConstDI<u_char>::s_type()) {
	return const_reduce_max(arg.domain().card(),
				   ((IA_ConstDI<u_char> *)arg.bdip)->value);
    } else {
	return iter_reduce_max(arg);
    }
}

//////////////////////////////////////////////////////////////////////
//
// Begin operation support routines for :
// reduction min subop=min int I(u_char)
//
// Emacs: -*- C++ -*-

//
//	Copyright 1993, Center for Computer Vision and Visualization,
//	University of Florida.  All rights reserved.
//


//
// $Log:	reduce_fn_nz,v $
// Revision 1.2  93/05/27  11:49:03  thoth
// Copyright Notices
// 
// Revision 1.1  93/03/10  13:49:13  thoth
// Initial revision
// 

static int vec_reduce_min(const IA_VectorDI<u_char> *arg)
{
    const u_char *ls = arg->vec;

    int	rval=*(ls++);

    const unsigned sz = arg->domain().card();
    for (unsigned i=1; i<sz; i++) {
	rval = min( rval, (*(ls++)));
    }

    return rval;
}

#ifndef const_reduce_int_u_char_min
#define const_reduce_int_u_char_min
static int const_reduce_min(unsigned sz, u_char arg)
{
    int	rval=arg;
    for (unsigned i=1; i<sz; i++) {
	rval = min(rval, arg);
    }
    return rval;
}
#endif

static int iter_reduce_min(const IA_UcharDiscreteImage &arg)
{
    IA_DIVIter<u_char>	iter(arg);

    u_char	temp;
    iter(temp);

    int	rval=temp;

    while(iter(temp)) {
	rval = min(rval, temp);
    }

    return rval;
}

int min ( const IA_UcharDiscreteImage &arg)
{
    if (arg.domain().card()==0)
	abort(); // XXX unfinished code

    if (arg.type() == IA_VectorDI<u_char>::s_type()) {
	return vec_reduce_min((IA_VectorDI<u_char> *)arg.bdip);
    } else if (arg.type() == IA_ConstDI<u_char>::s_type()) {
	return const_reduce_min(arg.domain().card(),
				   ((IA_ConstDI<u_char> *)arg.bdip)->value);
    } else {
	return iter_reduce_min(arg);
    }
}

