// Emacs -*- C++ -*-

// Machine generated include file, do not modify.


// 	Copyright 1993, Center for Computer Vision and Visualization,
// 	University of Florida.  All rights reserved.

//  Integer operations for the Int Discrete Image
//////////////////////////////////////////////////////////////////////
//
// Begin operation support routines for :
// conversion I(int) I(u_char)
//
// Emacs: -*- C++ -*-

//
//	Copyright 1993, Center for Computer Vision and Visualization,
//	University of Florida.  All rights reserved.
//


//
// $Log:	conversion.templ,v $
// Revision 1.2  93/05/27  11:49:02  thoth
// Copyright Notices
// 
// Revision 1.1  93/03/18  11:18:33  thoth
// Initial revision
// 

IA_IntDiscreteImage::
	IA_IntDiscreteImage(const IA_DiscreteImage<u_char> &arg)
{
    IA_IntPointSet	domain = arg.domain();
    // if the domain isn\'t extensive, we need a lazy conversion image...
    const unsigned	sz = domain.card();
    int * const	vec = new int[sz];
    {
	int	*scan = vec;
	IA_DIVIter<u_char>	iter(arg);
	u_char	temp;
	while (iter(temp)) {
	    *(scan++) = temp;
	}
    }
    set_and_reference_image(new IA_VectorDI<int>(domain, vec, sz, 1));
}

//////////////////////////////////////////////////////////////////////
//
// Begin operation support routines for :
// unary pointwise to_uchar subop=u_char I(u_char) I(int)
//
// Emacs: -*- C++ -*-

//
//	Copyright 1993, Center for Computer Vision and Visualization,
//	University of Florida.  All rights reserved.
//


//
// $Log:	unary-op.templ,v $
// Revision 1.2  93/05/27  11:49:04  thoth
// Copyright Notices
// 
// Revision 1.1  93/03/10  13:50:00  thoth
// Initial revision
// 

#ifndef vec_scalar_u_char_int_to_uchar
#define vec_scalar_u_char_int_to_uchar
static IA_DiscreteImage<u_char>
vec_uo_to_uchar(const IA_VectorDI<int> *lhs)
{
    const IA_IntPointSet domain = lhs->domain();
    const unsigned sz = domain.card();
    u_char *const vec = new u_char[sz];

    {
	u_char *ds = vec;
	const int *ls = lhs->vec;
	for (unsigned i=0; i<sz; i++) {
	    *(ds++) = u_char(*(ls++));
	}
    }
    return IA_DiscreteImage<u_char>(domain, vec, sz, 1);
}
#endif // vec_scalar_u_char_int_to_uchar

// scalar-scalar operation is trivial

#ifndef iter_scalar_u_char_int_to_uchar
#define iter_scalar_u_char_int_to_uchar
static IA_DiscreteImage<u_char>
iter_uo_to_uchar(IA_IntDiscreteImage lhs)
{
    const IA_IntPointSet domain = lhs.domain();
    const unsigned sz = domain.card();
    u_char *const vec = new u_char[sz];

    {
	u_char *ds = vec;
	int ltmp;
	IA_DIVIter<int>	liter(lhs);
	for (unsigned i=0; i<sz; i++) {
	    liter(ltmp);
	    *(ds++) = u_char(ltmp);
	}
    }
    return IA_DiscreteImage<u_char>(domain, vec, sz, 1);
}
#endif // iter_scalar_u_char_int_to_uchar

IA_DiscreteImage<u_char>
to_uchar ( const IA_IntDiscreteImage &arg)
{
    if (arg.type() == IA_VectorDI<int>::s_type()) {
	return vec_uo_to_uchar((IA_VectorDI<int> *)arg.bdip);
    } else if (arg.type() == IA_ConstDI<int>::s_type()) {
	return IA_DiscreteImage<u_char> (arg.domain(), u_char(((IA_ConstDI<int> *)arg.bdip)->value));
    } else {
	return iter_uo_to_uchar(arg);
    }
}

//////////////////////////////////////////////////////////////////////
//
// Begin operation support routines for :
// binary pointwise commutative operator+ I(int) I(int) I(int)
//
static IA_IntDiscreteImage
vec_vec_bo_operatorIAOPpl(const IA_VectorDI<int> *lhs,const IA_VectorDI<int> *rhs)
{
    const IA_IntPointSet domain = lhs->domain();
    const unsigned sz = domain.card();
    int *const vec = new int[sz];

    {
	int *ds = vec;
	const int *ls = lhs->vec;
	const int *rs = rhs->vec;
	for (unsigned i=0; i<sz; i++) {
	    *(ds++) = ( (*(ls++)) + (*(rs++)) );
	}
    }
    return IA_IntDiscreteImage(domain, vec, sz, 1);
}

#ifndef vec_scalar_int_int_int_operatorIAOPpl
#define vec_scalar_int_int_int_operatorIAOPpl
static IA_IntDiscreteImage
vec_scalar_bo_operatorIAOPpl(const IA_VectorDI<int> *lhs,int rhs)
{
    const IA_IntPointSet domain = lhs->domain();
    const unsigned sz = domain.card();
    int *const vec = new int[sz];

    {
	int *ds = vec;
	const int *ls = lhs->vec;
	for (unsigned i=0; i<sz; i++) {
	    *(ds++) = ( (*(ls++)) + (rhs) );
	}
    }
    return IA_IntDiscreteImage(domain, vec, sz, 1);
}
#endif // vec_scalar_int_int_int_operatorIAOPpl

static IA_IntDiscreteImage
vec_iter_bo_operatorIAOPpl(const IA_VectorDI<int> *lhs,IA_IntDiscreteImage rhs)
{
    const IA_IntPointSet domain = lhs->domain();
    const unsigned sz = domain.card();
    int *const vec = new int[sz];

    {
	int *ds = vec;
	const int *ls = lhs->vec;
	int rtmp;
	IA_DIVIter<int>	riter(rhs);
	for (unsigned i=0; i<sz; i++) {
	    riter(rtmp);
	    *(ds++) = ( (*(ls++)) + (rtmp) );
	}
    }
    return IA_IntDiscreteImage(domain, vec, sz, 1);
}

// scalar-scalar operation is trivial

#ifndef scalar_iter_int_int_int_operatorIAOPpl
#define scalar_iter_int_int_int_operatorIAOPpl
static IA_IntDiscreteImage
scalar_iter_bo_operatorIAOPpl(int lhs,IA_IntDiscreteImage rhs)
{
    const IA_IntPointSet domain = rhs.domain();
    const unsigned sz = domain.card();
    int *const vec = new int[sz];

    {
	int *ds = vec;
	int rtmp;
	IA_DIVIter<int>	riter(rhs);
	for (unsigned i=0; i<sz; i++) {
	    riter(rtmp);
	    *(ds++) = ( (lhs) + (rtmp) );
	}
    }
    return IA_IntDiscreteImage(domain, vec, sz, 1);
}
#endif // scalar_iter_int_int_int_operatorIAOPpl

static IA_IntDiscreteImage
iter_iter_bo_operatorIAOPpl(IA_IntDiscreteImage lhs,IA_IntDiscreteImage rhs)
{
    const IA_IntPointSet domain = lhs.domain();
    const unsigned sz = domain.card();
    int *const vec = new int[sz];

    {
	int *ds = vec;
	int ltmp;
	IA_DIVIter<int>	liter(lhs);
	int rtmp;
	IA_DIVIter<int>	riter(rhs);
	for (unsigned i=0; i<sz; i++) {
	    liter(ltmp);
	    riter(rtmp);
	    *(ds++) = ( (ltmp) + (rtmp) );
	}
    }
    return IA_IntDiscreteImage(domain, vec, sz, 1);
}

IA_IntDiscreteImage
operator+ ( const IA_IntDiscreteImage &lhs,
	      const IA_IntDiscreteImage &rhs)
{
    if (lhs.domain() != rhs.domain()) {
	static IA_IntDiscreteImage	rval;
	ia_throw( IA::PSET_MISMATCH, __FILE__,__LINE__);
	return rval;
    }

    if (lhs.type() == IA_VectorDI<int>::s_type()) {
	if (rhs.type() == IA_VectorDI<int>::s_type()) {
	    return vec_vec_bo_operatorIAOPpl((IA_VectorDI<int> *)lhs.bdip,(IA_VectorDI<int> *)rhs.bdip);
	} else if (rhs.type() == IA_ConstDI<int>::s_type()) {
	    return vec_scalar_bo_operatorIAOPpl((IA_VectorDI<int> *)lhs.bdip,((IA_ConstDI<int> *)rhs.bdip)->value);
	} else {
	    return vec_iter_bo_operatorIAOPpl((IA_VectorDI<int> *)lhs.bdip,rhs);
	}
    } else if (lhs.type() == IA_ConstDI<int>::s_type()) {
	if (rhs.type() == IA_VectorDI<int>::s_type()) {
	    return vec_scalar_bo_operatorIAOPpl((IA_VectorDI<int> *)rhs.bdip,((IA_ConstDI<int> *)lhs.bdip)->value);
	} else if (rhs.type() == IA_ConstDI<int>::s_type()) {
	    return IA_IntDiscreteImage (lhs.domain(), (((IA_ConstDI<int> *)lhs.bdip)->value) + (((IA_ConstDI<int> *)rhs.bdip)->value));
	} else {
	    return scalar_iter_bo_operatorIAOPpl(((IA_ConstDI<int> *)lhs.bdip)->value,rhs);
	}
    } else {
	if (rhs.type() == IA_VectorDI<int>::s_type()) {
	    return vec_iter_bo_operatorIAOPpl((IA_VectorDI<int> *)rhs.bdip,lhs);
	} else if (rhs.type() == IA_ConstDI<int>::s_type()) {
	    return scalar_iter_bo_operatorIAOPpl(((IA_ConstDI<int> *)rhs.bdip)->value,lhs);
	} else {
	    return iter_iter_bo_operatorIAOPpl(lhs,rhs);
	}
    }
}

//////////////////////////////////////////////////////////////////////
//
// Begin operation support routines for :
// binary pointwise commutative operator+ I(int) int I(int)
//
#ifndef vec_scalar_int_int_int_operatorIAOPpl
#define vec_scalar_int_int_int_operatorIAOPpl
static IA_IntDiscreteImage
vec_scalar_bo_operatorIAOPpl(const IA_VectorDI<int> *lhs,int rhs)
{
    const IA_IntPointSet domain = lhs->domain();
    const unsigned sz = domain.card();
    int *const vec = new int[sz];

    {
	int *ds = vec;
	const int *ls = lhs->vec;
	for (unsigned i=0; i<sz; i++) {
	    *(ds++) = ( (*(ls++)) + (rhs) );
	}
    }
    return IA_IntDiscreteImage(domain, vec, sz, 1);
}
#endif // vec_scalar_int_int_int_operatorIAOPpl

// scalar-scalar operation is trivial

#ifndef scalar_iter_int_int_int_operatorIAOPpl
#define scalar_iter_int_int_int_operatorIAOPpl
static IA_IntDiscreteImage
scalar_iter_bo_operatorIAOPpl(int lhs,IA_IntDiscreteImage rhs)
{
    const IA_IntPointSet domain = rhs.domain();
    const unsigned sz = domain.card();
    int *const vec = new int[sz];

    {
	int *ds = vec;
	int rtmp;
	IA_DIVIter<int>	riter(rhs);
	for (unsigned i=0; i<sz; i++) {
	    riter(rtmp);
	    *(ds++) = ( (lhs) + (rtmp) );
	}
    }
    return IA_IntDiscreteImage(domain, vec, sz, 1);
}
#endif // scalar_iter_int_int_int_operatorIAOPpl

IA_IntDiscreteImage
operator+ ( const IA_IntDiscreteImage &lhs, int rhs)
{
    if (lhs.type() == IA_VectorDI<int>::s_type()) {
	return vec_scalar_bo_operatorIAOPpl((IA_VectorDI<int> *)lhs.bdip,rhs);
    } else if (lhs.type() == IA_ConstDI<int>::s_type()) {
	return IA_IntDiscreteImage (lhs.domain(), (((IA_ConstDI<int> *)lhs.bdip)->value) + (rhs));
    } else {
	return scalar_iter_bo_operatorIAOPpl(rhs,lhs);
    }
}

//////////////////////////////////////////////////////////////////////
//
// Begin operation support routines for :
// pointwise operator+= I(int) I(int)
//
// There are none (it's inline)

//////////////////////////////////////////////////////////////////////
//
// Begin operation support routines for :
// pointwise operator+= I(int) int
//
// There are none (it's inline)

//////////////////////////////////////////////////////////////////////
//
// Begin operation support routines for :
// binary pointwise non-commutative operator- I(int) I(int) I(int)
//
static IA_IntDiscreteImage
vec_vec_bo_operatorIAOPmn(const IA_VectorDI<int> *lhs,const IA_VectorDI<int> *rhs)
{
    const IA_IntPointSet domain = lhs->domain();
    const unsigned sz = domain.card();
    int *const vec = new int[sz];

    {
	int *ds = vec;
	const int *ls = lhs->vec;
	const int *rs = rhs->vec;
	for (unsigned i=0; i<sz; i++) {
	    *(ds++) = ( (*(ls++)) - (*(rs++)) );
	}
    }
    return IA_IntDiscreteImage(domain, vec, sz, 1);
}

#ifndef vec_scalar_int_int_int_operatorIAOPmn
#define vec_scalar_int_int_int_operatorIAOPmn
static IA_IntDiscreteImage
vec_scalar_bo_operatorIAOPmn(const IA_VectorDI<int> *lhs,int rhs)
{
    const IA_IntPointSet domain = lhs->domain();
    const unsigned sz = domain.card();
    int *const vec = new int[sz];

    {
	int *ds = vec;
	const int *ls = lhs->vec;
	for (unsigned i=0; i<sz; i++) {
	    *(ds++) = ( (*(ls++)) - (rhs) );
	}
    }
    return IA_IntDiscreteImage(domain, vec, sz, 1);
}
#endif // vec_scalar_int_int_int_operatorIAOPmn

static IA_IntDiscreteImage
vec_iter_bo_operatorIAOPmn(const IA_VectorDI<int> *lhs,IA_IntDiscreteImage rhs)
{
    const IA_IntPointSet domain = lhs->domain();
    const unsigned sz = domain.card();
    int *const vec = new int[sz];

    {
	int *ds = vec;
	const int *ls = lhs->vec;
	int rtmp;
	IA_DIVIter<int>	riter(rhs);
	for (unsigned i=0; i<sz; i++) {
	    riter(rtmp);
	    *(ds++) = ( (*(ls++)) - (rtmp) );
	}
    }
    return IA_IntDiscreteImage(domain, vec, sz, 1);
}

#ifndef scalar_vec_int_int_int_operatorIAOPmn
#define scalar_vec_int_int_int_operatorIAOPmn
static IA_IntDiscreteImage
scalar_vec_bo_operatorIAOPmn(int lhs,const IA_VectorDI<int> *rhs)
{
    const IA_IntPointSet domain = rhs->domain();
    const unsigned sz = domain.card();
    int *const vec = new int[sz];

    {
	int *ds = vec;
	const int *rs = rhs->vec;
	for (unsigned i=0; i<sz; i++) {
	    *(ds++) = ( (lhs) - (*(rs++)) );
	}
    }
    return IA_IntDiscreteImage(domain, vec, sz, 1);
}
#endif // scalar_vec_int_int_int_operatorIAOPmn

// scalar-scalar operation is trivial

#ifndef scalar_iter_int_int_int_operatorIAOPmn
#define scalar_iter_int_int_int_operatorIAOPmn
static IA_IntDiscreteImage
scalar_iter_bo_operatorIAOPmn(int lhs,IA_IntDiscreteImage rhs)
{
    const IA_IntPointSet domain = rhs.domain();
    const unsigned sz = domain.card();
    int *const vec = new int[sz];

    {
	int *ds = vec;
	int rtmp;
	IA_DIVIter<int>	riter(rhs);
	for (unsigned i=0; i<sz; i++) {
	    riter(rtmp);
	    *(ds++) = ( (lhs) - (rtmp) );
	}
    }
    return IA_IntDiscreteImage(domain, vec, sz, 1);
}
#endif // scalar_iter_int_int_int_operatorIAOPmn

static IA_IntDiscreteImage
iter_vec_bo_operatorIAOPmn(IA_IntDiscreteImage lhs,const IA_VectorDI<int> *rhs)
{
    const IA_IntPointSet domain = lhs.domain();
    const unsigned sz = domain.card();
    int *const vec = new int[sz];

    {
	int *ds = vec;
	int ltmp;
	IA_DIVIter<int>	liter(lhs);
	const int *rs = rhs->vec;
	for (unsigned i=0; i<sz; i++) {
	    liter(ltmp);
	    *(ds++) = ( (ltmp) - (*(rs++)) );
	}
    }
    return IA_IntDiscreteImage(domain, vec, sz, 1);
}

#ifndef iter_scalar_int_int_int_operatorIAOPmn
#define iter_scalar_int_int_int_operatorIAOPmn
static IA_IntDiscreteImage
iter_scalar_bo_operatorIAOPmn(IA_IntDiscreteImage lhs,int rhs)
{
    const IA_IntPointSet domain = lhs.domain();
    const unsigned sz = domain.card();
    int *const vec = new int[sz];

    {
	int *ds = vec;
	int ltmp;
	IA_DIVIter<int>	liter(lhs);
	for (unsigned i=0; i<sz; i++) {
	    liter(ltmp);
	    *(ds++) = ( (ltmp) - (rhs) );
	}
    }
    return IA_IntDiscreteImage(domain, vec, sz, 1);
}
#endif // iter_scalar_int_int_int_operatorIAOPmn

static IA_IntDiscreteImage
iter_iter_bo_operatorIAOPmn(IA_IntDiscreteImage lhs,IA_IntDiscreteImage rhs)
{
    const IA_IntPointSet domain = lhs.domain();
    const unsigned sz = domain.card();
    int *const vec = new int[sz];

    {
	int *ds = vec;
	int ltmp;
	IA_DIVIter<int>	liter(lhs);
	int rtmp;
	IA_DIVIter<int>	riter(rhs);
	for (unsigned i=0; i<sz; i++) {
	    liter(ltmp);
	    riter(rtmp);
	    *(ds++) = ( (ltmp) - (rtmp) );
	}
    }
    return IA_IntDiscreteImage(domain, vec, sz, 1);
}

IA_IntDiscreteImage
operator- ( const IA_IntDiscreteImage &lhs,
	      const IA_IntDiscreteImage &rhs)
{
    if (lhs.domain() != rhs.domain()) {
	static IA_IntDiscreteImage	rval;
	ia_throw( IA::PSET_MISMATCH, __FILE__,__LINE__);
	return rval;
    }

    if (lhs.type() == IA_VectorDI<int>::s_type()) {
	if (rhs.type() == IA_VectorDI<int>::s_type()) {
	    return vec_vec_bo_operatorIAOPmn((IA_VectorDI<int> *)lhs.bdip,(IA_VectorDI<int> *)rhs.bdip);
	} else if (rhs.type() == IA_ConstDI<int>::s_type()) {
	    return vec_scalar_bo_operatorIAOPmn((IA_VectorDI<int> *)lhs.bdip,((IA_ConstDI<int> *)rhs.bdip)->value);
	} else {
	    return vec_iter_bo_operatorIAOPmn((IA_VectorDI<int> *)lhs.bdip,rhs);
	}
    } else if (lhs.type() == IA_ConstDI<int>::s_type()) {
	if (rhs.type() == IA_VectorDI<int>::s_type()) {
	    return scalar_vec_bo_operatorIAOPmn(((IA_ConstDI<int> *)lhs.bdip)->value,(IA_VectorDI<int> *)rhs.bdip);
	} else if (rhs.type() == IA_ConstDI<int>::s_type()) {
	    return IA_IntDiscreteImage (lhs.domain(), (((IA_ConstDI<int> *)lhs.bdip)->value) - (((IA_ConstDI<int> *)rhs.bdip)->value));
	} else {
	    return scalar_iter_bo_operatorIAOPmn(((IA_ConstDI<int> *)lhs.bdip)->value,rhs);
	}
    } else {
	if (rhs.type() == IA_VectorDI<int>::s_type()) {
	    return iter_vec_bo_operatorIAOPmn(lhs,(IA_VectorDI<int> *)rhs.bdip);
	} else if (rhs.type() == IA_ConstDI<int>::s_type()) {
	    return iter_scalar_bo_operatorIAOPmn(lhs,((IA_ConstDI<int> *)rhs.bdip)->value);
	} else {
	    return iter_iter_bo_operatorIAOPmn(lhs,rhs);
	}
    }
}

//////////////////////////////////////////////////////////////////////
//
// Begin operation support routines for :
// binary pointwise non-commutative operator- I(int) int I(int)
//
#ifndef vec_scalar_int_int_int_operatorIAOPmn
#define vec_scalar_int_int_int_operatorIAOPmn
static IA_IntDiscreteImage
vec_scalar_bo_operatorIAOPmn(const IA_VectorDI<int> *lhs,int rhs)
{
    const IA_IntPointSet domain = lhs->domain();
    const unsigned sz = domain.card();
    int *const vec = new int[sz];

    {
	int *ds = vec;
	const int *ls = lhs->vec;
	for (unsigned i=0; i<sz; i++) {
	    *(ds++) = ( (*(ls++)) - (rhs) );
	}
    }
    return IA_IntDiscreteImage(domain, vec, sz, 1);
}
#endif // vec_scalar_int_int_int_operatorIAOPmn

// scalar-scalar operation is trivial

#ifndef iter_scalar_int_int_int_operatorIAOPmn
#define iter_scalar_int_int_int_operatorIAOPmn
static IA_IntDiscreteImage
iter_scalar_bo_operatorIAOPmn(IA_IntDiscreteImage lhs,int rhs)
{
    const IA_IntPointSet domain = lhs.domain();
    const unsigned sz = domain.card();
    int *const vec = new int[sz];

    {
	int *ds = vec;
	int ltmp;
	IA_DIVIter<int>	liter(lhs);
	for (unsigned i=0; i<sz; i++) {
	    liter(ltmp);
	    *(ds++) = ( (ltmp) - (rhs) );
	}
    }
    return IA_IntDiscreteImage(domain, vec, sz, 1);
}
#endif // iter_scalar_int_int_int_operatorIAOPmn

IA_IntDiscreteImage
operator- ( const IA_IntDiscreteImage &lhs, int rhs)
{
    if (lhs.type() == IA_VectorDI<int>::s_type()) {
	return vec_scalar_bo_operatorIAOPmn((IA_VectorDI<int> *)lhs.bdip,rhs);
    } else if (lhs.type() == IA_ConstDI<int>::s_type()) {
	return IA_IntDiscreteImage (lhs.domain(), (((IA_ConstDI<int> *)lhs.bdip)->value) - (rhs));
    } else {
	return iter_scalar_bo_operatorIAOPmn(lhs,rhs);
    }
}

//////////////////////////////////////////////////////////////////////
//
// Begin operation support routines for :
// binary pointwise non-commutative operator- int I(int) I(int)
//
#ifndef scalar_vec_int_int_int_operatorIAOPmn
#define scalar_vec_int_int_int_operatorIAOPmn
static IA_IntDiscreteImage
scalar_vec_bo_operatorIAOPmn(int lhs,const IA_VectorDI<int> *rhs)
{
    const IA_IntPointSet domain = rhs->domain();
    const unsigned sz = domain.card();
    int *const vec = new int[sz];

    {
	int *ds = vec;
	const int *rs = rhs->vec;
	for (unsigned i=0; i<sz; i++) {
	    *(ds++) = ( (lhs) - (*(rs++)) );
	}
    }
    return IA_IntDiscreteImage(domain, vec, sz, 1);
}
#endif // scalar_vec_int_int_int_operatorIAOPmn

// scalar-scalar operation is trivial

#ifndef scalar_iter_int_int_int_operatorIAOPmn
#define scalar_iter_int_int_int_operatorIAOPmn
static IA_IntDiscreteImage
scalar_iter_bo_operatorIAOPmn(int lhs,IA_IntDiscreteImage rhs)
{
    const IA_IntPointSet domain = rhs.domain();
    const unsigned sz = domain.card();
    int *const vec = new int[sz];

    {
	int *ds = vec;
	int rtmp;
	IA_DIVIter<int>	riter(rhs);
	for (unsigned i=0; i<sz; i++) {
	    riter(rtmp);
	    *(ds++) = ( (lhs) - (rtmp) );
	}
    }
    return IA_IntDiscreteImage(domain, vec, sz, 1);
}
#endif // scalar_iter_int_int_int_operatorIAOPmn

IA_IntDiscreteImage
operator- (int lhs, const IA_IntDiscreteImage &rhs)
{
    if (rhs.type() == IA_VectorDI<int>::s_type()) {
	return scalar_vec_bo_operatorIAOPmn(lhs,(IA_VectorDI<int> *)rhs.bdip);
    } else if (rhs.type() == IA_ConstDI<int>::s_type()) {
	return IA_IntDiscreteImage (rhs.domain(), (lhs) - (((IA_ConstDI<int> *)rhs.bdip)->value));
    } else {
	return scalar_iter_bo_operatorIAOPmn(lhs,rhs);
    }
}

//////////////////////////////////////////////////////////////////////
//
// Begin operation support routines for :
// unary pointwise operator- I(int) I(int)
//
// Emacs: -*- C++ -*-

//
//	Copyright 1993, Center for Computer Vision and Visualization,
//	University of Florida.  All rights reserved.
//


//
// $Log:	unary-op.templ,v $
// Revision 1.2  93/05/27  11:49:04  thoth
// Copyright Notices
// 
// Revision 1.1  93/03/10  13:50:00  thoth
// Initial revision
// 

#ifndef vec_scalar_int_int_operatorIAOPmn
#define vec_scalar_int_int_operatorIAOPmn
static IA_IntDiscreteImage
vec_uo_operatorIAOPmn(const IA_VectorDI<int> *lhs)
{
    const IA_IntPointSet domain = lhs->domain();
    const unsigned sz = domain.card();
    int *const vec = new int[sz];

    {
	int *ds = vec;
	const int *ls = lhs->vec;
	for (unsigned i=0; i<sz; i++) {
	    *(ds++) = -(*(ls++));
	}
    }
    return IA_IntDiscreteImage(domain, vec, sz, 1);
}
#endif // vec_scalar_int_int_operatorIAOPmn

// scalar-scalar operation is trivial

#ifndef iter_scalar_int_int_operatorIAOPmn
#define iter_scalar_int_int_operatorIAOPmn
static IA_IntDiscreteImage
iter_uo_operatorIAOPmn(IA_IntDiscreteImage lhs)
{
    const IA_IntPointSet domain = lhs.domain();
    const unsigned sz = domain.card();
    int *const vec = new int[sz];

    {
	int *ds = vec;
	int ltmp;
	IA_DIVIter<int>	liter(lhs);
	for (unsigned i=0; i<sz; i++) {
	    liter(ltmp);
	    *(ds++) = -(ltmp);
	}
    }
    return IA_IntDiscreteImage(domain, vec, sz, 1);
}
#endif // iter_scalar_int_int_operatorIAOPmn

IA_IntDiscreteImage
operator- ( const IA_IntDiscreteImage &arg)
{
    if (arg.type() == IA_VectorDI<int>::s_type()) {
	return vec_uo_operatorIAOPmn((IA_VectorDI<int> *)arg.bdip);
    } else if (arg.type() == IA_ConstDI<int>::s_type()) {
	return IA_IntDiscreteImage (arg.domain(), -(((IA_ConstDI<int> *)arg.bdip)->value));
    } else {
	return iter_uo_operatorIAOPmn(arg);
    }
}

//////////////////////////////////////////////////////////////////////
//
// Begin operation support routines for :
// pointwise operator-= I(int) I(int)
//
// There are none (it's inline)

//////////////////////////////////////////////////////////////////////
//
// Begin operation support routines for :
// pointwise operator-= I(int) int
//
// There are none (it's inline)

//////////////////////////////////////////////////////////////////////
//
// Begin operation support routines for :
// binary pointwise commutative operator* I(int) I(int) I(int)
//
static IA_IntDiscreteImage
vec_vec_bo_operatorIAOPmu(const IA_VectorDI<int> *lhs,const IA_VectorDI<int> *rhs)
{
    const IA_IntPointSet domain = lhs->domain();
    const unsigned sz = domain.card();
    int *const vec = new int[sz];

    {
	int *ds = vec;
	const int *ls = lhs->vec;
	const int *rs = rhs->vec;
	for (unsigned i=0; i<sz; i++) {
	    *(ds++) = ( (*(ls++)) * (*(rs++)) );
	}
    }
    return IA_IntDiscreteImage(domain, vec, sz, 1);
}

#ifndef vec_scalar_int_int_int_operatorIAOPmu
#define vec_scalar_int_int_int_operatorIAOPmu
static IA_IntDiscreteImage
vec_scalar_bo_operatorIAOPmu(const IA_VectorDI<int> *lhs,int rhs)
{
    const IA_IntPointSet domain = lhs->domain();
    const unsigned sz = domain.card();
    int *const vec = new int[sz];

    {
	int *ds = vec;
	const int *ls = lhs->vec;
	for (unsigned i=0; i<sz; i++) {
	    *(ds++) = ( (*(ls++)) * (rhs) );
	}
    }
    return IA_IntDiscreteImage(domain, vec, sz, 1);
}
#endif // vec_scalar_int_int_int_operatorIAOPmu

static IA_IntDiscreteImage
vec_iter_bo_operatorIAOPmu(const IA_VectorDI<int> *lhs,IA_IntDiscreteImage rhs)
{
    const IA_IntPointSet domain = lhs->domain();
    const unsigned sz = domain.card();
    int *const vec = new int[sz];

    {
	int *ds = vec;
	const int *ls = lhs->vec;
	int rtmp;
	IA_DIVIter<int>	riter(rhs);
	for (unsigned i=0; i<sz; i++) {
	    riter(rtmp);
	    *(ds++) = ( (*(ls++)) * (rtmp) );
	}
    }
    return IA_IntDiscreteImage(domain, vec, sz, 1);
}

// scalar-scalar operation is trivial

#ifndef scalar_iter_int_int_int_operatorIAOPmu
#define scalar_iter_int_int_int_operatorIAOPmu
static IA_IntDiscreteImage
scalar_iter_bo_operatorIAOPmu(int lhs,IA_IntDiscreteImage rhs)
{
    const IA_IntPointSet domain = rhs.domain();
    const unsigned sz = domain.card();
    int *const vec = new int[sz];

    {
	int *ds = vec;
	int rtmp;
	IA_DIVIter<int>	riter(rhs);
	for (unsigned i=0; i<sz; i++) {
	    riter(rtmp);
	    *(ds++) = ( (lhs) * (rtmp) );
	}
    }
    return IA_IntDiscreteImage(domain, vec, sz, 1);
}
#endif // scalar_iter_int_int_int_operatorIAOPmu

static IA_IntDiscreteImage
iter_iter_bo_operatorIAOPmu(IA_IntDiscreteImage lhs,IA_IntDiscreteImage rhs)
{
    const IA_IntPointSet domain = lhs.domain();
    const unsigned sz = domain.card();
    int *const vec = new int[sz];

    {
	int *ds = vec;
	int ltmp;
	IA_DIVIter<int>	liter(lhs);
	int rtmp;
	IA_DIVIter<int>	riter(rhs);
	for (unsigned i=0; i<sz; i++) {
	    liter(ltmp);
	    riter(rtmp);
	    *(ds++) = ( (ltmp) * (rtmp) );
	}
    }
    return IA_IntDiscreteImage(domain, vec, sz, 1);
}

IA_IntDiscreteImage
operator* ( const IA_IntDiscreteImage &lhs,
	      const IA_IntDiscreteImage &rhs)
{
    if (lhs.domain() != rhs.domain()) {
	static IA_IntDiscreteImage	rval;
	ia_throw( IA::PSET_MISMATCH, __FILE__,__LINE__);
	return rval;
    }

    if (lhs.type() == IA_VectorDI<int>::s_type()) {
	if (rhs.type() == IA_VectorDI<int>::s_type()) {
	    return vec_vec_bo_operatorIAOPmu((IA_VectorDI<int> *)lhs.bdip,(IA_VectorDI<int> *)rhs.bdip);
	} else if (rhs.type() == IA_ConstDI<int>::s_type()) {
	    return vec_scalar_bo_operatorIAOPmu((IA_VectorDI<int> *)lhs.bdip,((IA_ConstDI<int> *)rhs.bdip)->value);
	} else {
	    return vec_iter_bo_operatorIAOPmu((IA_VectorDI<int> *)lhs.bdip,rhs);
	}
    } else if (lhs.type() == IA_ConstDI<int>::s_type()) {
	if (rhs.type() == IA_VectorDI<int>::s_type()) {
	    return vec_scalar_bo_operatorIAOPmu((IA_VectorDI<int> *)rhs.bdip,((IA_ConstDI<int> *)lhs.bdip)->value);
	} else if (rhs.type() == IA_ConstDI<int>::s_type()) {
	    return IA_IntDiscreteImage (lhs.domain(), (((IA_ConstDI<int> *)lhs.bdip)->value) * (((IA_ConstDI<int> *)rhs.bdip)->value));
	} else {
	    return scalar_iter_bo_operatorIAOPmu(((IA_ConstDI<int> *)lhs.bdip)->value,rhs);
	}
    } else {
	if (rhs.type() == IA_VectorDI<int>::s_type()) {
	    return vec_iter_bo_operatorIAOPmu((IA_VectorDI<int> *)rhs.bdip,lhs);
	} else if (rhs.type() == IA_ConstDI<int>::s_type()) {
	    return scalar_iter_bo_operatorIAOPmu(((IA_ConstDI<int> *)rhs.bdip)->value,lhs);
	} else {
	    return iter_iter_bo_operatorIAOPmu(lhs,rhs);
	}
    }
}

//////////////////////////////////////////////////////////////////////
//
// Begin operation support routines for :
// binary pointwise commutative operator* I(int) int I(int)
//
#ifndef vec_scalar_int_int_int_operatorIAOPmu
#define vec_scalar_int_int_int_operatorIAOPmu
static IA_IntDiscreteImage
vec_scalar_bo_operatorIAOPmu(const IA_VectorDI<int> *lhs,int rhs)
{
    const IA_IntPointSet domain = lhs->domain();
    const unsigned sz = domain.card();
    int *const vec = new int[sz];

    {
	int *ds = vec;
	const int *ls = lhs->vec;
	for (unsigned i=0; i<sz; i++) {
	    *(ds++) = ( (*(ls++)) * (rhs) );
	}
    }
    return IA_IntDiscreteImage(domain, vec, sz, 1);
}
#endif // vec_scalar_int_int_int_operatorIAOPmu

// scalar-scalar operation is trivial

#ifndef scalar_iter_int_int_int_operatorIAOPmu
#define scalar_iter_int_int_int_operatorIAOPmu
static IA_IntDiscreteImage
scalar_iter_bo_operatorIAOPmu(int lhs,IA_IntDiscreteImage rhs)
{
    const IA_IntPointSet domain = rhs.domain();
    const unsigned sz = domain.card();
    int *const vec = new int[sz];

    {
	int *ds = vec;
	int rtmp;
	IA_DIVIter<int>	riter(rhs);
	for (unsigned i=0; i<sz; i++) {
	    riter(rtmp);
	    *(ds++) = ( (lhs) * (rtmp) );
	}
    }
    return IA_IntDiscreteImage(domain, vec, sz, 1);
}
#endif // scalar_iter_int_int_int_operatorIAOPmu

IA_IntDiscreteImage
operator* ( const IA_IntDiscreteImage &lhs, int rhs)
{
    if (lhs.type() == IA_VectorDI<int>::s_type()) {
	return vec_scalar_bo_operatorIAOPmu((IA_VectorDI<int> *)lhs.bdip,rhs);
    } else if (lhs.type() == IA_ConstDI<int>::s_type()) {
	return IA_IntDiscreteImage (lhs.domain(), (((IA_ConstDI<int> *)lhs.bdip)->value) * (rhs));
    } else {
	return scalar_iter_bo_operatorIAOPmu(rhs,lhs);
    }
}

//////////////////////////////////////////////////////////////////////
//
// Begin operation support routines for :
// pointwise operator*= I(int) I(int)
//
// There are none (it's inline)

//////////////////////////////////////////////////////////////////////
//
// Begin operation support routines for :
// pointwise operator*= I(int) int
//
// There are none (it's inline)

//////////////////////////////////////////////////////////////////////
//
// Begin operation support routines for :
// binary pointwise non-commutative operator/ I(int) I(int) I(int)
//
static IA_IntDiscreteImage
vec_vec_bo_operatorIAOPdv(const IA_VectorDI<int> *lhs,const IA_VectorDI<int> *rhs)
{
    const IA_IntPointSet domain = lhs->domain();
    const unsigned sz = domain.card();
    int *const vec = new int[sz];

    {
	int *ds = vec;
	const int *ls = lhs->vec;
	const int *rs = rhs->vec;
	for (unsigned i=0; i<sz; i++) {
	    *(ds++) = ( (*(ls++)) / (*(rs++)) );
	}
    }
    return IA_IntDiscreteImage(domain, vec, sz, 1);
}

#ifndef vec_scalar_int_int_int_operatorIAOPdv
#define vec_scalar_int_int_int_operatorIAOPdv
static IA_IntDiscreteImage
vec_scalar_bo_operatorIAOPdv(const IA_VectorDI<int> *lhs,int rhs)
{
    const IA_IntPointSet domain = lhs->domain();
    const unsigned sz = domain.card();
    int *const vec = new int[sz];

    {
	int *ds = vec;
	const int *ls = lhs->vec;
	for (unsigned i=0; i<sz; i++) {
	    *(ds++) = ( (*(ls++)) / (rhs) );
	}
    }
    return IA_IntDiscreteImage(domain, vec, sz, 1);
}
#endif // vec_scalar_int_int_int_operatorIAOPdv

static IA_IntDiscreteImage
vec_iter_bo_operatorIAOPdv(const IA_VectorDI<int> *lhs,IA_IntDiscreteImage rhs)
{
    const IA_IntPointSet domain = lhs->domain();
    const unsigned sz = domain.card();
    int *const vec = new int[sz];

    {
	int *ds = vec;
	const int *ls = lhs->vec;
	int rtmp;
	IA_DIVIter<int>	riter(rhs);
	for (unsigned i=0; i<sz; i++) {
	    riter(rtmp);
	    *(ds++) = ( (*(ls++)) / (rtmp) );
	}
    }
    return IA_IntDiscreteImage(domain, vec, sz, 1);
}

#ifndef scalar_vec_int_int_int_operatorIAOPdv
#define scalar_vec_int_int_int_operatorIAOPdv
static IA_IntDiscreteImage
scalar_vec_bo_operatorIAOPdv(int lhs,const IA_VectorDI<int> *rhs)
{
    const IA_IntPointSet domain = rhs->domain();
    const unsigned sz = domain.card();
    int *const vec = new int[sz];

    {
	int *ds = vec;
	const int *rs = rhs->vec;
	for (unsigned i=0; i<sz; i++) {
	    *(ds++) = ( (lhs) / (*(rs++)) );
	}
    }
    return IA_IntDiscreteImage(domain, vec, sz, 1);
}
#endif // scalar_vec_int_int_int_operatorIAOPdv

// scalar-scalar operation is trivial

#ifndef scalar_iter_int_int_int_operatorIAOPdv
#define scalar_iter_int_int_int_operatorIAOPdv
static IA_IntDiscreteImage
scalar_iter_bo_operatorIAOPdv(int lhs,IA_IntDiscreteImage rhs)
{
    const IA_IntPointSet domain = rhs.domain();
    const unsigned sz = domain.card();
    int *const vec = new int[sz];

    {
	int *ds = vec;
	int rtmp;
	IA_DIVIter<int>	riter(rhs);
	for (unsigned i=0; i<sz; i++) {
	    riter(rtmp);
	    *(ds++) = ( (lhs) / (rtmp) );
	}
    }
    return IA_IntDiscreteImage(domain, vec, sz, 1);
}
#endif // scalar_iter_int_int_int_operatorIAOPdv

static IA_IntDiscreteImage
iter_vec_bo_operatorIAOPdv(IA_IntDiscreteImage lhs,const IA_VectorDI<int> *rhs)
{
    const IA_IntPointSet domain = lhs.domain();
    const unsigned sz = domain.card();
    int *const vec = new int[sz];

    {
	int *ds = vec;
	int ltmp;
	IA_DIVIter<int>	liter(lhs);
	const int *rs = rhs->vec;
	for (unsigned i=0; i<sz; i++) {
	    liter(ltmp);
	    *(ds++) = ( (ltmp) / (*(rs++)) );
	}
    }
    return IA_IntDiscreteImage(domain, vec, sz, 1);
}

#ifndef iter_scalar_int_int_int_operatorIAOPdv
#define iter_scalar_int_int_int_operatorIAOPdv
static IA_IntDiscreteImage
iter_scalar_bo_operatorIAOPdv(IA_IntDiscreteImage lhs,int rhs)
{
    const IA_IntPointSet domain = lhs.domain();
    const unsigned sz = domain.card();
    int *const vec = new int[sz];

    {
	int *ds = vec;
	int ltmp;
	IA_DIVIter<int>	liter(lhs);
	for (unsigned i=0; i<sz; i++) {
	    liter(ltmp);
	    *(ds++) = ( (ltmp) / (rhs) );
	}
    }
    return IA_IntDiscreteImage(domain, vec, sz, 1);
}
#endif // iter_scalar_int_int_int_operatorIAOPdv

static IA_IntDiscreteImage
iter_iter_bo_operatorIAOPdv(IA_IntDiscreteImage lhs,IA_IntDiscreteImage rhs)
{
    const IA_IntPointSet domain = lhs.domain();
    const unsigned sz = domain.card();
    int *const vec = new int[sz];

    {
	int *ds = vec;
	int ltmp;
	IA_DIVIter<int>	liter(lhs);
	int rtmp;
	IA_DIVIter<int>	riter(rhs);
	for (unsigned i=0; i<sz; i++) {
	    liter(ltmp);
	    riter(rtmp);
	    *(ds++) = ( (ltmp) / (rtmp) );
	}
    }
    return IA_IntDiscreteImage(domain, vec, sz, 1);
}

IA_IntDiscreteImage
operator/ ( const IA_IntDiscreteImage &lhs,
	      const IA_IntDiscreteImage &rhs)
{
    if (lhs.domain() != rhs.domain()) {
	static IA_IntDiscreteImage	rval;
	ia_throw( IA::PSET_MISMATCH, __FILE__,__LINE__);
	return rval;
    }

    if (lhs.type() == IA_VectorDI<int>::s_type()) {
	if (rhs.type() == IA_VectorDI<int>::s_type()) {
	    return vec_vec_bo_operatorIAOPdv((IA_VectorDI<int> *)lhs.bdip,(IA_VectorDI<int> *)rhs.bdip);
	} else if (rhs.type() == IA_ConstDI<int>::s_type()) {
	    return vec_scalar_bo_operatorIAOPdv((IA_VectorDI<int> *)lhs.bdip,((IA_ConstDI<int> *)rhs.bdip)->value);
	} else {
	    return vec_iter_bo_operatorIAOPdv((IA_VectorDI<int> *)lhs.bdip,rhs);
	}
    } else if (lhs.type() == IA_ConstDI<int>::s_type()) {
	if (rhs.type() == IA_VectorDI<int>::s_type()) {
	    return scalar_vec_bo_operatorIAOPdv(((IA_ConstDI<int> *)lhs.bdip)->value,(IA_VectorDI<int> *)rhs.bdip);
	} else if (rhs.type() == IA_ConstDI<int>::s_type()) {
	    return IA_IntDiscreteImage (lhs.domain(), (((IA_ConstDI<int> *)lhs.bdip)->value) / (((IA_ConstDI<int> *)rhs.bdip)->value));
	} else {
	    return scalar_iter_bo_operatorIAOPdv(((IA_ConstDI<int> *)lhs.bdip)->value,rhs);
	}
    } else {
	if (rhs.type() == IA_VectorDI<int>::s_type()) {
	    return iter_vec_bo_operatorIAOPdv(lhs,(IA_VectorDI<int> *)rhs.bdip);
	} else if (rhs.type() == IA_ConstDI<int>::s_type()) {
	    return iter_scalar_bo_operatorIAOPdv(lhs,((IA_ConstDI<int> *)rhs.bdip)->value);
	} else {
	    return iter_iter_bo_operatorIAOPdv(lhs,rhs);
	}
    }
}

//////////////////////////////////////////////////////////////////////
//
// Begin operation support routines for :
// binary pointwise non-commutative operator/ I(int) int I(int)
//
#ifndef vec_scalar_int_int_int_operatorIAOPdv
#define vec_scalar_int_int_int_operatorIAOPdv
static IA_IntDiscreteImage
vec_scalar_bo_operatorIAOPdv(const IA_VectorDI<int> *lhs,int rhs)
{
    const IA_IntPointSet domain = lhs->domain();
    const unsigned sz = domain.card();
    int *const vec = new int[sz];

    {
	int *ds = vec;
	const int *ls = lhs->vec;
	for (unsigned i=0; i<sz; i++) {
	    *(ds++) = ( (*(ls++)) / (rhs) );
	}
    }
    return IA_IntDiscreteImage(domain, vec, sz, 1);
}
#endif // vec_scalar_int_int_int_operatorIAOPdv

// scalar-scalar operation is trivial

#ifndef iter_scalar_int_int_int_operatorIAOPdv
#define iter_scalar_int_int_int_operatorIAOPdv
static IA_IntDiscreteImage
iter_scalar_bo_operatorIAOPdv(IA_IntDiscreteImage lhs,int rhs)
{
    const IA_IntPointSet domain = lhs.domain();
    const unsigned sz = domain.card();
    int *const vec = new int[sz];

    {
	int *ds = vec;
	int ltmp;
	IA_DIVIter<int>	liter(lhs);
	for (unsigned i=0; i<sz; i++) {
	    liter(ltmp);
	    *(ds++) = ( (ltmp) / (rhs) );
	}
    }
    return IA_IntDiscreteImage(domain, vec, sz, 1);
}
#endif // iter_scalar_int_int_int_operatorIAOPdv

IA_IntDiscreteImage
operator/ ( const IA_IntDiscreteImage &lhs, int rhs)
{
    if (lhs.type() == IA_VectorDI<int>::s_type()) {
	return vec_scalar_bo_operatorIAOPdv((IA_VectorDI<int> *)lhs.bdip,rhs);
    } else if (lhs.type() == IA_ConstDI<int>::s_type()) {
	return IA_IntDiscreteImage (lhs.domain(), (((IA_ConstDI<int> *)lhs.bdip)->value) / (rhs));
    } else {
	return iter_scalar_bo_operatorIAOPdv(lhs,rhs);
    }
}

//////////////////////////////////////////////////////////////////////
//
// Begin operation support routines for :
// binary pointwise non-commutative operator/ int I(int) I(int)
//
#ifndef scalar_vec_int_int_int_operatorIAOPdv
#define scalar_vec_int_int_int_operatorIAOPdv
static IA_IntDiscreteImage
scalar_vec_bo_operatorIAOPdv(int lhs,const IA_VectorDI<int> *rhs)
{
    const IA_IntPointSet domain = rhs->domain();
    const unsigned sz = domain.card();
    int *const vec = new int[sz];

    {
	int *ds = vec;
	const int *rs = rhs->vec;
	for (unsigned i=0; i<sz; i++) {
	    *(ds++) = ( (lhs) / (*(rs++)) );
	}
    }
    return IA_IntDiscreteImage(domain, vec, sz, 1);
}
#endif // scalar_vec_int_int_int_operatorIAOPdv

// scalar-scalar operation is trivial

#ifndef scalar_iter_int_int_int_operatorIAOPdv
#define scalar_iter_int_int_int_operatorIAOPdv
static IA_IntDiscreteImage
scalar_iter_bo_operatorIAOPdv(int lhs,IA_IntDiscreteImage rhs)
{
    const IA_IntPointSet domain = rhs.domain();
    const unsigned sz = domain.card();
    int *const vec = new int[sz];

    {
	int *ds = vec;
	int rtmp;
	IA_DIVIter<int>	riter(rhs);
	for (unsigned i=0; i<sz; i++) {
	    riter(rtmp);
	    *(ds++) = ( (lhs) / (rtmp) );
	}
    }
    return IA_IntDiscreteImage(domain, vec, sz, 1);
}
#endif // scalar_iter_int_int_int_operatorIAOPdv

IA_IntDiscreteImage
operator/ (int lhs, const IA_IntDiscreteImage &rhs)
{
    if (rhs.type() == IA_VectorDI<int>::s_type()) {
	return scalar_vec_bo_operatorIAOPdv(lhs,(IA_VectorDI<int> *)rhs.bdip);
    } else if (rhs.type() == IA_ConstDI<int>::s_type()) {
	return IA_IntDiscreteImage (rhs.domain(), (lhs) / (((IA_ConstDI<int> *)rhs.bdip)->value));
    } else {
	return scalar_iter_bo_operatorIAOPdv(lhs,rhs);
    }
}

//////////////////////////////////////////////////////////////////////
//
// Begin operation support routines for :
// pointwise operator/= I(int) I(int)
//
// There are none (it's inline)

//////////////////////////////////////////////////////////////////////
//
// Begin operation support routines for :
// pointwise operator/= I(int) int
//
// There are none (it's inline)

//////////////////////////////////////////////////////////////////////
//
// Begin operation support routines for :
// binary pointwise non-commutative operator% I(int) I(int) I(int)
//
static IA_IntDiscreteImage
vec_vec_bo_operatorIAOPmd(const IA_VectorDI<int> *lhs,const IA_VectorDI<int> *rhs)
{
    const IA_IntPointSet domain = lhs->domain();
    const unsigned sz = domain.card();
    int *const vec = new int[sz];

    {
	int *ds = vec;
	const int *ls = lhs->vec;
	const int *rs = rhs->vec;
	for (unsigned i=0; i<sz; i++) {
	    *(ds++) = ( (*(ls++)) % (*(rs++)) );
	}
    }
    return IA_IntDiscreteImage(domain, vec, sz, 1);
}

#ifndef vec_scalar_int_int_int_operatorIAOPmd
#define vec_scalar_int_int_int_operatorIAOPmd
static IA_IntDiscreteImage
vec_scalar_bo_operatorIAOPmd(const IA_VectorDI<int> *lhs,int rhs)
{
    const IA_IntPointSet domain = lhs->domain();
    const unsigned sz = domain.card();
    int *const vec = new int[sz];

    {
	int *ds = vec;
	const int *ls = lhs->vec;
	for (unsigned i=0; i<sz; i++) {
	    *(ds++) = ( (*(ls++)) % (rhs) );
	}
    }
    return IA_IntDiscreteImage(domain, vec, sz, 1);
}
#endif // vec_scalar_int_int_int_operatorIAOPmd

static IA_IntDiscreteImage
vec_iter_bo_operatorIAOPmd(const IA_VectorDI<int> *lhs,IA_IntDiscreteImage rhs)
{
    const IA_IntPointSet domain = lhs->domain();
    const unsigned sz = domain.card();
    int *const vec = new int[sz];

    {
	int *ds = vec;
	const int *ls = lhs->vec;
	int rtmp;
	IA_DIVIter<int>	riter(rhs);
	for (unsigned i=0; i<sz; i++) {
	    riter(rtmp);
	    *(ds++) = ( (*(ls++)) % (rtmp) );
	}
    }
    return IA_IntDiscreteImage(domain, vec, sz, 1);
}

#ifndef scalar_vec_int_int_int_operatorIAOPmd
#define scalar_vec_int_int_int_operatorIAOPmd
static IA_IntDiscreteImage
scalar_vec_bo_operatorIAOPmd(int lhs,const IA_VectorDI<int> *rhs)
{
    const IA_IntPointSet domain = rhs->domain();
    const unsigned sz = domain.card();
    int *const vec = new int[sz];

    {
	int *ds = vec;
	const int *rs = rhs->vec;
	for (unsigned i=0; i<sz; i++) {
	    *(ds++) = ( (lhs) % (*(rs++)) );
	}
    }
    return IA_IntDiscreteImage(domain, vec, sz, 1);
}
#endif // scalar_vec_int_int_int_operatorIAOPmd

// scalar-scalar operation is trivial

#ifndef scalar_iter_int_int_int_operatorIAOPmd
#define scalar_iter_int_int_int_operatorIAOPmd
static IA_IntDiscreteImage
scalar_iter_bo_operatorIAOPmd(int lhs,IA_IntDiscreteImage rhs)
{
    const IA_IntPointSet domain = rhs.domain();
    const unsigned sz = domain.card();
    int *const vec = new int[sz];

    {
	int *ds = vec;
	int rtmp;
	IA_DIVIter<int>	riter(rhs);
	for (unsigned i=0; i<sz; i++) {
	    riter(rtmp);
	    *(ds++) = ( (lhs) % (rtmp) );
	}
    }
    return IA_IntDiscreteImage(domain, vec, sz, 1);
}
#endif // scalar_iter_int_int_int_operatorIAOPmd

static IA_IntDiscreteImage
iter_vec_bo_operatorIAOPmd(IA_IntDiscreteImage lhs,const IA_VectorDI<int> *rhs)
{
    const IA_IntPointSet domain = lhs.domain();
    const unsigned sz = domain.card();
    int *const vec = new int[sz];

    {
	int *ds = vec;
	int ltmp;
	IA_DIVIter<int>	liter(lhs);
	const int *rs = rhs->vec;
	for (unsigned i=0; i<sz; i++) {
	    liter(ltmp);
	    *(ds++) = ( (ltmp) % (*(rs++)) );
	}
    }
    return IA_IntDiscreteImage(domain, vec, sz, 1);
}

#ifndef iter_scalar_int_int_int_operatorIAOPmd
#define iter_scalar_int_int_int_operatorIAOPmd
static IA_IntDiscreteImage
iter_scalar_bo_operatorIAOPmd(IA_IntDiscreteImage lhs,int rhs)
{
    const IA_IntPointSet domain = lhs.domain();
    const unsigned sz = domain.card();
    int *const vec = new int[sz];

    {
	int *ds = vec;
	int ltmp;
	IA_DIVIter<int>	liter(lhs);
	for (unsigned i=0; i<sz; i++) {
	    liter(ltmp);
	    *(ds++) = ( (ltmp) % (rhs) );
	}
    }
    return IA_IntDiscreteImage(domain, vec, sz, 1);
}
#endif // iter_scalar_int_int_int_operatorIAOPmd

static IA_IntDiscreteImage
iter_iter_bo_operatorIAOPmd(IA_IntDiscreteImage lhs,IA_IntDiscreteImage rhs)
{
    const IA_IntPointSet domain = lhs.domain();
    const unsigned sz = domain.card();
    int *const vec = new int[sz];

    {
	int *ds = vec;
	int ltmp;
	IA_DIVIter<int>	liter(lhs);
	int rtmp;
	IA_DIVIter<int>	riter(rhs);
	for (unsigned i=0; i<sz; i++) {
	    liter(ltmp);
	    riter(rtmp);
	    *(ds++) = ( (ltmp) % (rtmp) );
	}
    }
    return IA_IntDiscreteImage(domain, vec, sz, 1);
}

IA_IntDiscreteImage
operator% ( const IA_IntDiscreteImage &lhs,
	      const IA_IntDiscreteImage &rhs)
{
    if (lhs.domain() != rhs.domain()) {
	static IA_IntDiscreteImage	rval;
	ia_throw( IA::PSET_MISMATCH, __FILE__,__LINE__);
	return rval;
    }

    if (lhs.type() == IA_VectorDI<int>::s_type()) {
	if (rhs.type() == IA_VectorDI<int>::s_type()) {
	    return vec_vec_bo_operatorIAOPmd((IA_VectorDI<int> *)lhs.bdip,(IA_VectorDI<int> *)rhs.bdip);
	} else if (rhs.type() == IA_ConstDI<int>::s_type()) {
	    return vec_scalar_bo_operatorIAOPmd((IA_VectorDI<int> *)lhs.bdip,((IA_ConstDI<int> *)rhs.bdip)->value);
	} else {
	    return vec_iter_bo_operatorIAOPmd((IA_VectorDI<int> *)lhs.bdip,rhs);
	}
    } else if (lhs.type() == IA_ConstDI<int>::s_type()) {
	if (rhs.type() == IA_VectorDI<int>::s_type()) {
	    return scalar_vec_bo_operatorIAOPmd(((IA_ConstDI<int> *)lhs.bdip)->value,(IA_VectorDI<int> *)rhs.bdip);
	} else if (rhs.type() == IA_ConstDI<int>::s_type()) {
	    return IA_IntDiscreteImage (lhs.domain(), (((IA_ConstDI<int> *)lhs.bdip)->value) % (((IA_ConstDI<int> *)rhs.bdip)->value));
	} else {
	    return scalar_iter_bo_operatorIAOPmd(((IA_ConstDI<int> *)lhs.bdip)->value,rhs);
	}
    } else {
	if (rhs.type() == IA_VectorDI<int>::s_type()) {
	    return iter_vec_bo_operatorIAOPmd(lhs,(IA_VectorDI<int> *)rhs.bdip);
	} else if (rhs.type() == IA_ConstDI<int>::s_type()) {
	    return iter_scalar_bo_operatorIAOPmd(lhs,((IA_ConstDI<int> *)rhs.bdip)->value);
	} else {
	    return iter_iter_bo_operatorIAOPmd(lhs,rhs);
	}
    }
}

//////////////////////////////////////////////////////////////////////
//
// Begin operation support routines for :
// binary pointwise non-commutative operator% I(int) int I(int)
//
#ifndef vec_scalar_int_int_int_operatorIAOPmd
#define vec_scalar_int_int_int_operatorIAOPmd
static IA_IntDiscreteImage
vec_scalar_bo_operatorIAOPmd(const IA_VectorDI<int> *lhs,int rhs)
{
    const IA_IntPointSet domain = lhs->domain();
    const unsigned sz = domain.card();
    int *const vec = new int[sz];

    {
	int *ds = vec;
	const int *ls = lhs->vec;
	for (unsigned i=0; i<sz; i++) {
	    *(ds++) = ( (*(ls++)) % (rhs) );
	}
    }
    return IA_IntDiscreteImage(domain, vec, sz, 1);
}
#endif // vec_scalar_int_int_int_operatorIAOPmd

// scalar-scalar operation is trivial

#ifndef iter_scalar_int_int_int_operatorIAOPmd
#define iter_scalar_int_int_int_operatorIAOPmd
static IA_IntDiscreteImage
iter_scalar_bo_operatorIAOPmd(IA_IntDiscreteImage lhs,int rhs)
{
    const IA_IntPointSet domain = lhs.domain();
    const unsigned sz = domain.card();
    int *const vec = new int[sz];

    {
	int *ds = vec;
	int ltmp;
	IA_DIVIter<int>	liter(lhs);
	for (unsigned i=0; i<sz; i++) {
	    liter(ltmp);
	    *(ds++) = ( (ltmp) % (rhs) );
	}
    }
    return IA_IntDiscreteImage(domain, vec, sz, 1);
}
#endif // iter_scalar_int_int_int_operatorIAOPmd

IA_IntDiscreteImage
operator% ( const IA_IntDiscreteImage &lhs, int rhs)
{
    if (lhs.type() == IA_VectorDI<int>::s_type()) {
	return vec_scalar_bo_operatorIAOPmd((IA_VectorDI<int> *)lhs.bdip,rhs);
    } else if (lhs.type() == IA_ConstDI<int>::s_type()) {
	return IA_IntDiscreteImage (lhs.domain(), (((IA_ConstDI<int> *)lhs.bdip)->value) % (rhs));
    } else {
	return iter_scalar_bo_operatorIAOPmd(lhs,rhs);
    }
}

//////////////////////////////////////////////////////////////////////
//
// Begin operation support routines for :
// binary pointwise non-commutative operator% int I(int) I(int)
//
#ifndef scalar_vec_int_int_int_operatorIAOPmd
#define scalar_vec_int_int_int_operatorIAOPmd
static IA_IntDiscreteImage
scalar_vec_bo_operatorIAOPmd(int lhs,const IA_VectorDI<int> *rhs)
{
    const IA_IntPointSet domain = rhs->domain();
    const unsigned sz = domain.card();
    int *const vec = new int[sz];

    {
	int *ds = vec;
	const int *rs = rhs->vec;
	for (unsigned i=0; i<sz; i++) {
	    *(ds++) = ( (lhs) % (*(rs++)) );
	}
    }
    return IA_IntDiscreteImage(domain, vec, sz, 1);
}
#endif // scalar_vec_int_int_int_operatorIAOPmd

// scalar-scalar operation is trivial

#ifndef scalar_iter_int_int_int_operatorIAOPmd
#define scalar_iter_int_int_int_operatorIAOPmd
static IA_IntDiscreteImage
scalar_iter_bo_operatorIAOPmd(int lhs,IA_IntDiscreteImage rhs)
{
    const IA_IntPointSet domain = rhs.domain();
    const unsigned sz = domain.card();
    int *const vec = new int[sz];

    {
	int *ds = vec;
	int rtmp;
	IA_DIVIter<int>	riter(rhs);
	for (unsigned i=0; i<sz; i++) {
	    riter(rtmp);
	    *(ds++) = ( (lhs) % (rtmp) );
	}
    }
    return IA_IntDiscreteImage(domain, vec, sz, 1);
}
#endif // scalar_iter_int_int_int_operatorIAOPmd

IA_IntDiscreteImage
operator% (int lhs, const IA_IntDiscreteImage &rhs)
{
    if (rhs.type() == IA_VectorDI<int>::s_type()) {
	return scalar_vec_bo_operatorIAOPmd(lhs,(IA_VectorDI<int> *)rhs.bdip);
    } else if (rhs.type() == IA_ConstDI<int>::s_type()) {
	return IA_IntDiscreteImage (rhs.domain(), (lhs) % (((IA_ConstDI<int> *)rhs.bdip)->value));
    } else {
	return scalar_iter_bo_operatorIAOPmd(lhs,rhs);
    }
}

//////////////////////////////////////////////////////////////////////
//
// Begin operation support routines for :
// pointwise operator%= I(int) I(int)
//
// There are none (it's inline)

//////////////////////////////////////////////////////////////////////
//
// Begin operation support routines for :
// pointwise operator%= I(int) int
//
// There are none (it's inline)

//////////////////////////////////////////////////////////////////////
//
// Begin operation support routines for :
// binary pointwise commutative operator& I(int) I(int) I(int)
//
static IA_IntDiscreteImage
vec_vec_bo_operatorIAOPba(const IA_VectorDI<int> *lhs,const IA_VectorDI<int> *rhs)
{
    const IA_IntPointSet domain = lhs->domain();
    const unsigned sz = domain.card();
    int *const vec = new int[sz];

    {
	int *ds = vec;
	const int *ls = lhs->vec;
	const int *rs = rhs->vec;
	for (unsigned i=0; i<sz; i++) {
	    *(ds++) = ( (*(ls++)) & (*(rs++)) );
	}
    }
    return IA_IntDiscreteImage(domain, vec, sz, 1);
}

#ifndef vec_scalar_int_int_int_operatorIAOPba
#define vec_scalar_int_int_int_operatorIAOPba
static IA_IntDiscreteImage
vec_scalar_bo_operatorIAOPba(const IA_VectorDI<int> *lhs,int rhs)
{
    const IA_IntPointSet domain = lhs->domain();
    const unsigned sz = domain.card();
    int *const vec = new int[sz];

    {
	int *ds = vec;
	const int *ls = lhs->vec;
	for (unsigned i=0; i<sz; i++) {
	    *(ds++) = ( (*(ls++)) & (rhs) );
	}
    }
    return IA_IntDiscreteImage(domain, vec, sz, 1);
}
#endif // vec_scalar_int_int_int_operatorIAOPba

static IA_IntDiscreteImage
vec_iter_bo_operatorIAOPba(const IA_VectorDI<int> *lhs,IA_IntDiscreteImage rhs)
{
    const IA_IntPointSet domain = lhs->domain();
    const unsigned sz = domain.card();
    int *const vec = new int[sz];

    {
	int *ds = vec;
	const int *ls = lhs->vec;
	int rtmp;
	IA_DIVIter<int>	riter(rhs);
	for (unsigned i=0; i<sz; i++) {
	    riter(rtmp);
	    *(ds++) = ( (*(ls++)) & (rtmp) );
	}
    }
    return IA_IntDiscreteImage(domain, vec, sz, 1);
}

// scalar-scalar operation is trivial

#ifndef scalar_iter_int_int_int_operatorIAOPba
#define scalar_iter_int_int_int_operatorIAOPba
static IA_IntDiscreteImage
scalar_iter_bo_operatorIAOPba(int lhs,IA_IntDiscreteImage rhs)
{
    const IA_IntPointSet domain = rhs.domain();
    const unsigned sz = domain.card();
    int *const vec = new int[sz];

    {
	int *ds = vec;
	int rtmp;
	IA_DIVIter<int>	riter(rhs);
	for (unsigned i=0; i<sz; i++) {
	    riter(rtmp);
	    *(ds++) = ( (lhs) & (rtmp) );
	}
    }
    return IA_IntDiscreteImage(domain, vec, sz, 1);
}
#endif // scalar_iter_int_int_int_operatorIAOPba

static IA_IntDiscreteImage
iter_iter_bo_operatorIAOPba(IA_IntDiscreteImage lhs,IA_IntDiscreteImage rhs)
{
    const IA_IntPointSet domain = lhs.domain();
    const unsigned sz = domain.card();
    int *const vec = new int[sz];

    {
	int *ds = vec;
	int ltmp;
	IA_DIVIter<int>	liter(lhs);
	int rtmp;
	IA_DIVIter<int>	riter(rhs);
	for (unsigned i=0; i<sz; i++) {
	    liter(ltmp);
	    riter(rtmp);
	    *(ds++) = ( (ltmp) & (rtmp) );
	}
    }
    return IA_IntDiscreteImage(domain, vec, sz, 1);
}

IA_IntDiscreteImage
operator& ( const IA_IntDiscreteImage &lhs,
	      const IA_IntDiscreteImage &rhs)
{
    if (lhs.domain() != rhs.domain()) {
	static IA_IntDiscreteImage	rval;
	ia_throw( IA::PSET_MISMATCH, __FILE__,__LINE__);
	return rval;
    }

    if (lhs.type() == IA_VectorDI<int>::s_type()) {
	if (rhs.type() == IA_VectorDI<int>::s_type()) {
	    return vec_vec_bo_operatorIAOPba((IA_VectorDI<int> *)lhs.bdip,(IA_VectorDI<int> *)rhs.bdip);
	} else if (rhs.type() == IA_ConstDI<int>::s_type()) {
	    return vec_scalar_bo_operatorIAOPba((IA_VectorDI<int> *)lhs.bdip,((IA_ConstDI<int> *)rhs.bdip)->value);
	} else {
	    return vec_iter_bo_operatorIAOPba((IA_VectorDI<int> *)lhs.bdip,rhs);
	}
    } else if (lhs.type() == IA_ConstDI<int>::s_type()) {
	if (rhs.type() == IA_VectorDI<int>::s_type()) {
	    return vec_scalar_bo_operatorIAOPba((IA_VectorDI<int> *)rhs.bdip,((IA_ConstDI<int> *)lhs.bdip)->value);
	} else if (rhs.type() == IA_ConstDI<int>::s_type()) {
	    return IA_IntDiscreteImage (lhs.domain(), (((IA_ConstDI<int> *)lhs.bdip)->value) & (((IA_ConstDI<int> *)rhs.bdip)->value));
	} else {
	    return scalar_iter_bo_operatorIAOPba(((IA_ConstDI<int> *)lhs.bdip)->value,rhs);
	}
    } else {
	if (rhs.type() == IA_VectorDI<int>::s_type()) {
	    return vec_iter_bo_operatorIAOPba((IA_VectorDI<int> *)rhs.bdip,lhs);
	} else if (rhs.type() == IA_ConstDI<int>::s_type()) {
	    return scalar_iter_bo_operatorIAOPba(((IA_ConstDI<int> *)rhs.bdip)->value,lhs);
	} else {
	    return iter_iter_bo_operatorIAOPba(lhs,rhs);
	}
    }
}

//////////////////////////////////////////////////////////////////////
//
// Begin operation support routines for :
// binary pointwise commutative operator& I(int) int I(int)
//
#ifndef vec_scalar_int_int_int_operatorIAOPba
#define vec_scalar_int_int_int_operatorIAOPba
static IA_IntDiscreteImage
vec_scalar_bo_operatorIAOPba(const IA_VectorDI<int> *lhs,int rhs)
{
    const IA_IntPointSet domain = lhs->domain();
    const unsigned sz = domain.card();
    int *const vec = new int[sz];

    {
	int *ds = vec;
	const int *ls = lhs->vec;
	for (unsigned i=0; i<sz; i++) {
	    *(ds++) = ( (*(ls++)) & (rhs) );
	}
    }
    return IA_IntDiscreteImage(domain, vec, sz, 1);
}
#endif // vec_scalar_int_int_int_operatorIAOPba

// scalar-scalar operation is trivial

#ifndef scalar_iter_int_int_int_operatorIAOPba
#define scalar_iter_int_int_int_operatorIAOPba
static IA_IntDiscreteImage
scalar_iter_bo_operatorIAOPba(int lhs,IA_IntDiscreteImage rhs)
{
    const IA_IntPointSet domain = rhs.domain();
    const unsigned sz = domain.card();
    int *const vec = new int[sz];

    {
	int *ds = vec;
	int rtmp;
	IA_DIVIter<int>	riter(rhs);
	for (unsigned i=0; i<sz; i++) {
	    riter(rtmp);
	    *(ds++) = ( (lhs) & (rtmp) );
	}
    }
    return IA_IntDiscreteImage(domain, vec, sz, 1);
}
#endif // scalar_iter_int_int_int_operatorIAOPba

IA_IntDiscreteImage
operator& ( const IA_IntDiscreteImage &lhs, int rhs)
{
    if (lhs.type() == IA_VectorDI<int>::s_type()) {
	return vec_scalar_bo_operatorIAOPba((IA_VectorDI<int> *)lhs.bdip,rhs);
    } else if (lhs.type() == IA_ConstDI<int>::s_type()) {
	return IA_IntDiscreteImage (lhs.domain(), (((IA_ConstDI<int> *)lhs.bdip)->value) & (rhs));
    } else {
	return scalar_iter_bo_operatorIAOPba(rhs,lhs);
    }
}

//////////////////////////////////////////////////////////////////////
//
// Begin operation support routines for :
// pointwise operator&= I(int) I(int)
//
// There are none (it's inline)

//////////////////////////////////////////////////////////////////////
//
// Begin operation support routines for :
// pointwise operator&= I(int) int
//
// There are none (it's inline)

//////////////////////////////////////////////////////////////////////
//
// Begin operation support routines for :
// binary pointwise commutative operator| I(int) I(int) I(int)
//
static IA_IntDiscreteImage
vec_vec_bo_operatorIAOPbo(const IA_VectorDI<int> *lhs,const IA_VectorDI<int> *rhs)
{
    const IA_IntPointSet domain = lhs->domain();
    const unsigned sz = domain.card();
    int *const vec = new int[sz];

    {
	int *ds = vec;
	const int *ls = lhs->vec;
	const int *rs = rhs->vec;
	for (unsigned i=0; i<sz; i++) {
	    *(ds++) = ( (*(ls++)) | (*(rs++)) );
	}
    }
    return IA_IntDiscreteImage(domain, vec, sz, 1);
}

#ifndef vec_scalar_int_int_int_operatorIAOPbo
#define vec_scalar_int_int_int_operatorIAOPbo
static IA_IntDiscreteImage
vec_scalar_bo_operatorIAOPbo(const IA_VectorDI<int> *lhs,int rhs)
{
    const IA_IntPointSet domain = lhs->domain();
    const unsigned sz = domain.card();
    int *const vec = new int[sz];

    {
	int *ds = vec;
	const int *ls = lhs->vec;
	for (unsigned i=0; i<sz; i++) {
	    *(ds++) = ( (*(ls++)) | (rhs) );
	}
    }
    return IA_IntDiscreteImage(domain, vec, sz, 1);
}
#endif // vec_scalar_int_int_int_operatorIAOPbo

static IA_IntDiscreteImage
vec_iter_bo_operatorIAOPbo(const IA_VectorDI<int> *lhs,IA_IntDiscreteImage rhs)
{
    const IA_IntPointSet domain = lhs->domain();
    const unsigned sz = domain.card();
    int *const vec = new int[sz];

    {
	int *ds = vec;
	const int *ls = lhs->vec;
	int rtmp;
	IA_DIVIter<int>	riter(rhs);
	for (unsigned i=0; i<sz; i++) {
	    riter(rtmp);
	    *(ds++) = ( (*(ls++)) | (rtmp) );
	}
    }
    return IA_IntDiscreteImage(domain, vec, sz, 1);
}

// scalar-scalar operation is trivial

#ifndef scalar_iter_int_int_int_operatorIAOPbo
#define scalar_iter_int_int_int_operatorIAOPbo
static IA_IntDiscreteImage
scalar_iter_bo_operatorIAOPbo(int lhs,IA_IntDiscreteImage rhs)
{
    const IA_IntPointSet domain = rhs.domain();
    const unsigned sz = domain.card();
    int *const vec = new int[sz];

    {
	int *ds = vec;
	int rtmp;
	IA_DIVIter<int>	riter(rhs);
	for (unsigned i=0; i<sz; i++) {
	    riter(rtmp);
	    *(ds++) = ( (lhs) | (rtmp) );
	}
    }
    return IA_IntDiscreteImage(domain, vec, sz, 1);
}
#endif // scalar_iter_int_int_int_operatorIAOPbo

static IA_IntDiscreteImage
iter_iter_bo_operatorIAOPbo(IA_IntDiscreteImage lhs,IA_IntDiscreteImage rhs)
{
    const IA_IntPointSet domain = lhs.domain();
    const unsigned sz = domain.card();
    int *const vec = new int[sz];

    {
	int *ds = vec;
	int ltmp;
	IA_DIVIter<int>	liter(lhs);
	int rtmp;
	IA_DIVIter<int>	riter(rhs);
	for (unsigned i=0; i<sz; i++) {
	    liter(ltmp);
	    riter(rtmp);
	    *(ds++) = ( (ltmp) | (rtmp) );
	}
    }
    return IA_IntDiscreteImage(domain, vec, sz, 1);
}

IA_IntDiscreteImage
operator| ( const IA_IntDiscreteImage &lhs,
	      const IA_IntDiscreteImage &rhs)
{
    if (lhs.domain() != rhs.domain()) {
	static IA_IntDiscreteImage	rval;
	ia_throw( IA::PSET_MISMATCH, __FILE__,__LINE__);
	return rval;
    }

    if (lhs.type() == IA_VectorDI<int>::s_type()) {
	if (rhs.type() == IA_VectorDI<int>::s_type()) {
	    return vec_vec_bo_operatorIAOPbo((IA_VectorDI<int> *)lhs.bdip,(IA_VectorDI<int> *)rhs.bdip);
	} else if (rhs.type() == IA_ConstDI<int>::s_type()) {
	    return vec_scalar_bo_operatorIAOPbo((IA_VectorDI<int> *)lhs.bdip,((IA_ConstDI<int> *)rhs.bdip)->value);
	} else {
	    return vec_iter_bo_operatorIAOPbo((IA_VectorDI<int> *)lhs.bdip,rhs);
	}
    } else if (lhs.type() == IA_ConstDI<int>::s_type()) {
	if (rhs.type() == IA_VectorDI<int>::s_type()) {
	    return vec_scalar_bo_operatorIAOPbo((IA_VectorDI<int> *)rhs.bdip,((IA_ConstDI<int> *)lhs.bdip)->value);
	} else if (rhs.type() == IA_ConstDI<int>::s_type()) {
	    return IA_IntDiscreteImage (lhs.domain(), (((IA_ConstDI<int> *)lhs.bdip)->value) | (((IA_ConstDI<int> *)rhs.bdip)->value));
	} else {
	    return scalar_iter_bo_operatorIAOPbo(((IA_ConstDI<int> *)lhs.bdip)->value,rhs);
	}
    } else {
	if (rhs.type() == IA_VectorDI<int>::s_type()) {
	    return vec_iter_bo_operatorIAOPbo((IA_VectorDI<int> *)rhs.bdip,lhs);
	} else if (rhs.type() == IA_ConstDI<int>::s_type()) {
	    return scalar_iter_bo_operatorIAOPbo(((IA_ConstDI<int> *)rhs.bdip)->value,lhs);
	} else {
	    return iter_iter_bo_operatorIAOPbo(lhs,rhs);
	}
    }
}

//////////////////////////////////////////////////////////////////////
//
// Begin operation support routines for :
// binary pointwise commutative operator| I(int) int I(int)
//
#ifndef vec_scalar_int_int_int_operatorIAOPbo
#define vec_scalar_int_int_int_operatorIAOPbo
static IA_IntDiscreteImage
vec_scalar_bo_operatorIAOPbo(const IA_VectorDI<int> *lhs,int rhs)
{
    const IA_IntPointSet domain = lhs->domain();
    const unsigned sz = domain.card();
    int *const vec = new int[sz];

    {
	int *ds = vec;
	const int *ls = lhs->vec;
	for (unsigned i=0; i<sz; i++) {
	    *(ds++) = ( (*(ls++)) | (rhs) );
	}
    }
    return IA_IntDiscreteImage(domain, vec, sz, 1);
}
#endif // vec_scalar_int_int_int_operatorIAOPbo

// scalar-scalar operation is trivial

#ifndef scalar_iter_int_int_int_operatorIAOPbo
#define scalar_iter_int_int_int_operatorIAOPbo
static IA_IntDiscreteImage
scalar_iter_bo_operatorIAOPbo(int lhs,IA_IntDiscreteImage rhs)
{
    const IA_IntPointSet domain = rhs.domain();
    const unsigned sz = domain.card();
    int *const vec = new int[sz];

    {
	int *ds = vec;
	int rtmp;
	IA_DIVIter<int>	riter(rhs);
	for (unsigned i=0; i<sz; i++) {
	    riter(rtmp);
	    *(ds++) = ( (lhs) | (rtmp) );
	}
    }
    return IA_IntDiscreteImage(domain, vec, sz, 1);
}
#endif // scalar_iter_int_int_int_operatorIAOPbo

IA_IntDiscreteImage
operator| ( const IA_IntDiscreteImage &lhs, int rhs)
{
    if (lhs.type() == IA_VectorDI<int>::s_type()) {
	return vec_scalar_bo_operatorIAOPbo((IA_VectorDI<int> *)lhs.bdip,rhs);
    } else if (lhs.type() == IA_ConstDI<int>::s_type()) {
	return IA_IntDiscreteImage (lhs.domain(), (((IA_ConstDI<int> *)lhs.bdip)->value) | (rhs));
    } else {
	return scalar_iter_bo_operatorIAOPbo(rhs,lhs);
    }
}

//////////////////////////////////////////////////////////////////////
//
// Begin operation support routines for :
// pointwise operator|= I(int) I(int)
//
// There are none (it's inline)

//////////////////////////////////////////////////////////////////////
//
// Begin operation support routines for :
// pointwise operator|= I(int) int
//
// There are none (it's inline)

//////////////////////////////////////////////////////////////////////
//
// Begin operation support routines for :
// binary pointwise commutative operator^ I(int) I(int) I(int)
//
static IA_IntDiscreteImage
vec_vec_bo_operatorIAOPbx(const IA_VectorDI<int> *lhs,const IA_VectorDI<int> *rhs)
{
    const IA_IntPointSet domain = lhs->domain();
    const unsigned sz = domain.card();
    int *const vec = new int[sz];

    {
	int *ds = vec;
	const int *ls = lhs->vec;
	const int *rs = rhs->vec;
	for (unsigned i=0; i<sz; i++) {
	    *(ds++) = ( (*(ls++)) ^ (*(rs++)) );
	}
    }
    return IA_IntDiscreteImage(domain, vec, sz, 1);
}

#ifndef vec_scalar_int_int_int_operatorIAOPbx
#define vec_scalar_int_int_int_operatorIAOPbx
static IA_IntDiscreteImage
vec_scalar_bo_operatorIAOPbx(const IA_VectorDI<int> *lhs,int rhs)
{
    const IA_IntPointSet domain = lhs->domain();
    const unsigned sz = domain.card();
    int *const vec = new int[sz];

    {
	int *ds = vec;
	const int *ls = lhs->vec;
	for (unsigned i=0; i<sz; i++) {
	    *(ds++) = ( (*(ls++)) ^ (rhs) );
	}
    }
    return IA_IntDiscreteImage(domain, vec, sz, 1);
}
#endif // vec_scalar_int_int_int_operatorIAOPbx

static IA_IntDiscreteImage
vec_iter_bo_operatorIAOPbx(const IA_VectorDI<int> *lhs,IA_IntDiscreteImage rhs)
{
    const IA_IntPointSet domain = lhs->domain();
    const unsigned sz = domain.card();
    int *const vec = new int[sz];

    {
	int *ds = vec;
	const int *ls = lhs->vec;
	int rtmp;
	IA_DIVIter<int>	riter(rhs);
	for (unsigned i=0; i<sz; i++) {
	    riter(rtmp);
	    *(ds++) = ( (*(ls++)) ^ (rtmp) );
	}
    }
    return IA_IntDiscreteImage(domain, vec, sz, 1);
}

// scalar-scalar operation is trivial

#ifndef scalar_iter_int_int_int_operatorIAOPbx
#define scalar_iter_int_int_int_operatorIAOPbx
static IA_IntDiscreteImage
scalar_iter_bo_operatorIAOPbx(int lhs,IA_IntDiscreteImage rhs)
{
    const IA_IntPointSet domain = rhs.domain();
    const unsigned sz = domain.card();
    int *const vec = new int[sz];

    {
	int *ds = vec;
	int rtmp;
	IA_DIVIter<int>	riter(rhs);
	for (unsigned i=0; i<sz; i++) {
	    riter(rtmp);
	    *(ds++) = ( (lhs) ^ (rtmp) );
	}
    }
    return IA_IntDiscreteImage(domain, vec, sz, 1);
}
#endif // scalar_iter_int_int_int_operatorIAOPbx

static IA_IntDiscreteImage
iter_iter_bo_operatorIAOPbx(IA_IntDiscreteImage lhs,IA_IntDiscreteImage rhs)
{
    const IA_IntPointSet domain = lhs.domain();
    const unsigned sz = domain.card();
    int *const vec = new int[sz];

    {
	int *ds = vec;
	int ltmp;
	IA_DIVIter<int>	liter(lhs);
	int rtmp;
	IA_DIVIter<int>	riter(rhs);
	for (unsigned i=0; i<sz; i++) {
	    liter(ltmp);
	    riter(rtmp);
	    *(ds++) = ( (ltmp) ^ (rtmp) );
	}
    }
    return IA_IntDiscreteImage(domain, vec, sz, 1);
}

IA_IntDiscreteImage
operator^ ( const IA_IntDiscreteImage &lhs,
	      const IA_IntDiscreteImage &rhs)
{
    if (lhs.domain() != rhs.domain()) {
	static IA_IntDiscreteImage	rval;
	ia_throw( IA::PSET_MISMATCH, __FILE__,__LINE__);
	return rval;
    }

    if (lhs.type() == IA_VectorDI<int>::s_type()) {
	if (rhs.type() == IA_VectorDI<int>::s_type()) {
	    return vec_vec_bo_operatorIAOPbx((IA_VectorDI<int> *)lhs.bdip,(IA_VectorDI<int> *)rhs.bdip);
	} else if (rhs.type() == IA_ConstDI<int>::s_type()) {
	    return vec_scalar_bo_operatorIAOPbx((IA_VectorDI<int> *)lhs.bdip,((IA_ConstDI<int> *)rhs.bdip)->value);
	} else {
	    return vec_iter_bo_operatorIAOPbx((IA_VectorDI<int> *)lhs.bdip,rhs);
	}
    } else if (lhs.type() == IA_ConstDI<int>::s_type()) {
	if (rhs.type() == IA_VectorDI<int>::s_type()) {
	    return vec_scalar_bo_operatorIAOPbx((IA_VectorDI<int> *)rhs.bdip,((IA_ConstDI<int> *)lhs.bdip)->value);
	} else if (rhs.type() == IA_ConstDI<int>::s_type()) {
	    return IA_IntDiscreteImage (lhs.domain(), (((IA_ConstDI<int> *)lhs.bdip)->value) ^ (((IA_ConstDI<int> *)rhs.bdip)->value));
	} else {
	    return scalar_iter_bo_operatorIAOPbx(((IA_ConstDI<int> *)lhs.bdip)->value,rhs);
	}
    } else {
	if (rhs.type() == IA_VectorDI<int>::s_type()) {
	    return vec_iter_bo_operatorIAOPbx((IA_VectorDI<int> *)rhs.bdip,lhs);
	} else if (rhs.type() == IA_ConstDI<int>::s_type()) {
	    return scalar_iter_bo_operatorIAOPbx(((IA_ConstDI<int> *)rhs.bdip)->value,lhs);
	} else {
	    return iter_iter_bo_operatorIAOPbx(lhs,rhs);
	}
    }
}

//////////////////////////////////////////////////////////////////////
//
// Begin operation support routines for :
// binary pointwise commutative operator^ I(int) int I(int)
//
#ifndef vec_scalar_int_int_int_operatorIAOPbx
#define vec_scalar_int_int_int_operatorIAOPbx
static IA_IntDiscreteImage
vec_scalar_bo_operatorIAOPbx(const IA_VectorDI<int> *lhs,int rhs)
{
    const IA_IntPointSet domain = lhs->domain();
    const unsigned sz = domain.card();
    int *const vec = new int[sz];

    {
	int *ds = vec;
	const int *ls = lhs->vec;
	for (unsigned i=0; i<sz; i++) {
	    *(ds++) = ( (*(ls++)) ^ (rhs) );
	}
    }
    return IA_IntDiscreteImage(domain, vec, sz, 1);
}
#endif // vec_scalar_int_int_int_operatorIAOPbx

// scalar-scalar operation is trivial

#ifndef scalar_iter_int_int_int_operatorIAOPbx
#define scalar_iter_int_int_int_operatorIAOPbx
static IA_IntDiscreteImage
scalar_iter_bo_operatorIAOPbx(int lhs,IA_IntDiscreteImage rhs)
{
    const IA_IntPointSet domain = rhs.domain();
    const unsigned sz = domain.card();
    int *const vec = new int[sz];

    {
	int *ds = vec;
	int rtmp;
	IA_DIVIter<int>	riter(rhs);
	for (unsigned i=0; i<sz; i++) {
	    riter(rtmp);
	    *(ds++) = ( (lhs) ^ (rtmp) );
	}
    }
    return IA_IntDiscreteImage(domain, vec, sz, 1);
}
#endif // scalar_iter_int_int_int_operatorIAOPbx

IA_IntDiscreteImage
operator^ ( const IA_IntDiscreteImage &lhs, int rhs)
{
    if (lhs.type() == IA_VectorDI<int>::s_type()) {
	return vec_scalar_bo_operatorIAOPbx((IA_VectorDI<int> *)lhs.bdip,rhs);
    } else if (lhs.type() == IA_ConstDI<int>::s_type()) {
	return IA_IntDiscreteImage (lhs.domain(), (((IA_ConstDI<int> *)lhs.bdip)->value) ^ (rhs));
    } else {
	return scalar_iter_bo_operatorIAOPbx(rhs,lhs);
    }
}

//////////////////////////////////////////////////////////////////////
//
// Begin operation support routines for :
// pointwise operator^= I(int) I(int)
//
// There are none (it's inline)

//////////////////////////////////////////////////////////////////////
//
// Begin operation support routines for :
// pointwise operator^= I(int) int
//
// There are none (it's inline)

//////////////////////////////////////////////////////////////////////
//
// Begin operation support routines for :
// binary pointwise commutative operator<< I(int) I(int) I(int)
//
static IA_IntDiscreteImage
vec_vec_bo_operatorIAOPls(const IA_VectorDI<int> *lhs,const IA_VectorDI<int> *rhs)
{
    const IA_IntPointSet domain = lhs->domain();
    const unsigned sz = domain.card();
    int *const vec = new int[sz];

    {
	int *ds = vec;
	const int *ls = lhs->vec;
	const int *rs = rhs->vec;
	for (unsigned i=0; i<sz; i++) {
	    *(ds++) = ( (*(ls++)) << (*(rs++)) );
	}
    }
    return IA_IntDiscreteImage(domain, vec, sz, 1);
}

#ifndef vec_scalar_int_int_int_operatorIAOPls
#define vec_scalar_int_int_int_operatorIAOPls
static IA_IntDiscreteImage
vec_scalar_bo_operatorIAOPls(const IA_VectorDI<int> *lhs,int rhs)
{
    const IA_IntPointSet domain = lhs->domain();
    const unsigned sz = domain.card();
    int *const vec = new int[sz];

    {
	int *ds = vec;
	const int *ls = lhs->vec;
	for (unsigned i=0; i<sz; i++) {
	    *(ds++) = ( (*(ls++)) << (rhs) );
	}
    }
    return IA_IntDiscreteImage(domain, vec, sz, 1);
}
#endif // vec_scalar_int_int_int_operatorIAOPls

static IA_IntDiscreteImage
vec_iter_bo_operatorIAOPls(const IA_VectorDI<int> *lhs,IA_IntDiscreteImage rhs)
{
    const IA_IntPointSet domain = lhs->domain();
    const unsigned sz = domain.card();
    int *const vec = new int[sz];

    {
	int *ds = vec;
	const int *ls = lhs->vec;
	int rtmp;
	IA_DIVIter<int>	riter(rhs);
	for (unsigned i=0; i<sz; i++) {
	    riter(rtmp);
	    *(ds++) = ( (*(ls++)) << (rtmp) );
	}
    }
    return IA_IntDiscreteImage(domain, vec, sz, 1);
}

// scalar-scalar operation is trivial

#ifndef scalar_iter_int_int_int_operatorIAOPls
#define scalar_iter_int_int_int_operatorIAOPls
static IA_IntDiscreteImage
scalar_iter_bo_operatorIAOPls(int lhs,IA_IntDiscreteImage rhs)
{
    const IA_IntPointSet domain = rhs.domain();
    const unsigned sz = domain.card();
    int *const vec = new int[sz];

    {
	int *ds = vec;
	int rtmp;
	IA_DIVIter<int>	riter(rhs);
	for (unsigned i=0; i<sz; i++) {
	    riter(rtmp);
	    *(ds++) = ( (lhs) << (rtmp) );
	}
    }
    return IA_IntDiscreteImage(domain, vec, sz, 1);
}
#endif // scalar_iter_int_int_int_operatorIAOPls

static IA_IntDiscreteImage
iter_iter_bo_operatorIAOPls(IA_IntDiscreteImage lhs,IA_IntDiscreteImage rhs)
{
    const IA_IntPointSet domain = lhs.domain();
    const unsigned sz = domain.card();
    int *const vec = new int[sz];

    {
	int *ds = vec;
	int ltmp;
	IA_DIVIter<int>	liter(lhs);
	int rtmp;
	IA_DIVIter<int>	riter(rhs);
	for (unsigned i=0; i<sz; i++) {
	    liter(ltmp);
	    riter(rtmp);
	    *(ds++) = ( (ltmp) << (rtmp) );
	}
    }
    return IA_IntDiscreteImage(domain, vec, sz, 1);
}

IA_IntDiscreteImage
operator<< ( const IA_IntDiscreteImage &lhs,
	      const IA_IntDiscreteImage &rhs)
{
    if (lhs.domain() != rhs.domain()) {
	static IA_IntDiscreteImage	rval;
	ia_throw( IA::PSET_MISMATCH, __FILE__,__LINE__);
	return rval;
    }

    if (lhs.type() == IA_VectorDI<int>::s_type()) {
	if (rhs.type() == IA_VectorDI<int>::s_type()) {
	    return vec_vec_bo_operatorIAOPls((IA_VectorDI<int> *)lhs.bdip,(IA_VectorDI<int> *)rhs.bdip);
	} else if (rhs.type() == IA_ConstDI<int>::s_type()) {
	    return vec_scalar_bo_operatorIAOPls((IA_VectorDI<int> *)lhs.bdip,((IA_ConstDI<int> *)rhs.bdip)->value);
	} else {
	    return vec_iter_bo_operatorIAOPls((IA_VectorDI<int> *)lhs.bdip,rhs);
	}
    } else if (lhs.type() == IA_ConstDI<int>::s_type()) {
	if (rhs.type() == IA_VectorDI<int>::s_type()) {
	    return vec_scalar_bo_operatorIAOPls((IA_VectorDI<int> *)rhs.bdip,((IA_ConstDI<int> *)lhs.bdip)->value);
	} else if (rhs.type() == IA_ConstDI<int>::s_type()) {
	    return IA_IntDiscreteImage (lhs.domain(), (((IA_ConstDI<int> *)lhs.bdip)->value) << (((IA_ConstDI<int> *)rhs.bdip)->value));
	} else {
	    return scalar_iter_bo_operatorIAOPls(((IA_ConstDI<int> *)lhs.bdip)->value,rhs);
	}
    } else {
	if (rhs.type() == IA_VectorDI<int>::s_type()) {
	    return vec_iter_bo_operatorIAOPls((IA_VectorDI<int> *)rhs.bdip,lhs);
	} else if (rhs.type() == IA_ConstDI<int>::s_type()) {
	    return scalar_iter_bo_operatorIAOPls(((IA_ConstDI<int> *)rhs.bdip)->value,lhs);
	} else {
	    return iter_iter_bo_operatorIAOPls(lhs,rhs);
	}
    }
}

//////////////////////////////////////////////////////////////////////
//
// Begin operation support routines for :
// binary pointwise commutative operator<< I(int) int I(int)
//
#ifndef vec_scalar_int_int_int_operatorIAOPls
#define vec_scalar_int_int_int_operatorIAOPls
static IA_IntDiscreteImage
vec_scalar_bo_operatorIAOPls(const IA_VectorDI<int> *lhs,int rhs)
{
    const IA_IntPointSet domain = lhs->domain();
    const unsigned sz = domain.card();
    int *const vec = new int[sz];

    {
	int *ds = vec;
	const int *ls = lhs->vec;
	for (unsigned i=0; i<sz; i++) {
	    *(ds++) = ( (*(ls++)) << (rhs) );
	}
    }
    return IA_IntDiscreteImage(domain, vec, sz, 1);
}
#endif // vec_scalar_int_int_int_operatorIAOPls

// scalar-scalar operation is trivial

#ifndef scalar_iter_int_int_int_operatorIAOPls
#define scalar_iter_int_int_int_operatorIAOPls
static IA_IntDiscreteImage
scalar_iter_bo_operatorIAOPls(int lhs,IA_IntDiscreteImage rhs)
{
    const IA_IntPointSet domain = rhs.domain();
    const unsigned sz = domain.card();
    int *const vec = new int[sz];

    {
	int *ds = vec;
	int rtmp;
	IA_DIVIter<int>	riter(rhs);
	for (unsigned i=0; i<sz; i++) {
	    riter(rtmp);
	    *(ds++) = ( (lhs) << (rtmp) );
	}
    }
    return IA_IntDiscreteImage(domain, vec, sz, 1);
}
#endif // scalar_iter_int_int_int_operatorIAOPls

IA_IntDiscreteImage
operator<< ( const IA_IntDiscreteImage &lhs, int rhs)
{
    if (lhs.type() == IA_VectorDI<int>::s_type()) {
	return vec_scalar_bo_operatorIAOPls((IA_VectorDI<int> *)lhs.bdip,rhs);
    } else if (lhs.type() == IA_ConstDI<int>::s_type()) {
	return IA_IntDiscreteImage (lhs.domain(), (((IA_ConstDI<int> *)lhs.bdip)->value) << (rhs));
    } else {
	return scalar_iter_bo_operatorIAOPls(rhs,lhs);
    }
}

//////////////////////////////////////////////////////////////////////
//
// Begin operation support routines for :
// pointwise operator<<= I(int) I(int)
//
// There are none (it's inline)

//////////////////////////////////////////////////////////////////////
//
// Begin operation support routines for :
// pointwise operator<<= I(int) int
//
// There are none (it's inline)

//////////////////////////////////////////////////////////////////////
//
// Begin operation support routines for :
// binary pointwise commutative operator>> I(int) I(int) I(int)
//
static IA_IntDiscreteImage
vec_vec_bo_operatorIAOPrs(const IA_VectorDI<int> *lhs,const IA_VectorDI<int> *rhs)
{
    const IA_IntPointSet domain = lhs->domain();
    const unsigned sz = domain.card();
    int *const vec = new int[sz];

    {
	int *ds = vec;
	const int *ls = lhs->vec;
	const int *rs = rhs->vec;
	for (unsigned i=0; i<sz; i++) {
	    *(ds++) = ( (*(ls++)) >> (*(rs++)) );
	}
    }
    return IA_IntDiscreteImage(domain, vec, sz, 1);
}

#ifndef vec_scalar_int_int_int_operatorIAOPrs
#define vec_scalar_int_int_int_operatorIAOPrs
static IA_IntDiscreteImage
vec_scalar_bo_operatorIAOPrs(const IA_VectorDI<int> *lhs,int rhs)
{
    const IA_IntPointSet domain = lhs->domain();
    const unsigned sz = domain.card();
    int *const vec = new int[sz];

    {
	int *ds = vec;
	const int *ls = lhs->vec;
	for (unsigned i=0; i<sz; i++) {
	    *(ds++) = ( (*(ls++)) >> (rhs) );
	}
    }
    return IA_IntDiscreteImage(domain, vec, sz, 1);
}
#endif // vec_scalar_int_int_int_operatorIAOPrs

static IA_IntDiscreteImage
vec_iter_bo_operatorIAOPrs(const IA_VectorDI<int> *lhs,IA_IntDiscreteImage rhs)
{
    const IA_IntPointSet domain = lhs->domain();
    const unsigned sz = domain.card();
    int *const vec = new int[sz];

    {
	int *ds = vec;
	const int *ls = lhs->vec;
	int rtmp;
	IA_DIVIter<int>	riter(rhs);
	for (unsigned i=0; i<sz; i++) {
	    riter(rtmp);
	    *(ds++) = ( (*(ls++)) >> (rtmp) );
	}
    }
    return IA_IntDiscreteImage(domain, vec, sz, 1);
}

// scalar-scalar operation is trivial

#ifndef scalar_iter_int_int_int_operatorIAOPrs
#define scalar_iter_int_int_int_operatorIAOPrs
static IA_IntDiscreteImage
scalar_iter_bo_operatorIAOPrs(int lhs,IA_IntDiscreteImage rhs)
{
    const IA_IntPointSet domain = rhs.domain();
    const unsigned sz = domain.card();
    int *const vec = new int[sz];

    {
	int *ds = vec;
	int rtmp;
	IA_DIVIter<int>	riter(rhs);
	for (unsigned i=0; i<sz; i++) {
	    riter(rtmp);
	    *(ds++) = ( (lhs) >> (rtmp) );
	}
    }
    return IA_IntDiscreteImage(domain, vec, sz, 1);
}
#endif // scalar_iter_int_int_int_operatorIAOPrs

static IA_IntDiscreteImage
iter_iter_bo_operatorIAOPrs(IA_IntDiscreteImage lhs,IA_IntDiscreteImage rhs)
{
    const IA_IntPointSet domain = lhs.domain();
    const unsigned sz = domain.card();
    int *const vec = new int[sz];

    {
	int *ds = vec;
	int ltmp;
	IA_DIVIter<int>	liter(lhs);
	int rtmp;
	IA_DIVIter<int>	riter(rhs);
	for (unsigned i=0; i<sz; i++) {
	    liter(ltmp);
	    riter(rtmp);
	    *(ds++) = ( (ltmp) >> (rtmp) );
	}
    }
    return IA_IntDiscreteImage(domain, vec, sz, 1);
}

IA_IntDiscreteImage
operator>> ( const IA_IntDiscreteImage &lhs,
	      const IA_IntDiscreteImage &rhs)
{
    if (lhs.domain() != rhs.domain()) {
	static IA_IntDiscreteImage	rval;
	ia_throw( IA::PSET_MISMATCH, __FILE__,__LINE__);
	return rval;
    }

    if (lhs.type() == IA_VectorDI<int>::s_type()) {
	if (rhs.type() == IA_VectorDI<int>::s_type()) {
	    return vec_vec_bo_operatorIAOPrs((IA_VectorDI<int> *)lhs.bdip,(IA_VectorDI<int> *)rhs.bdip);
	} else if (rhs.type() == IA_ConstDI<int>::s_type()) {
	    return vec_scalar_bo_operatorIAOPrs((IA_VectorDI<int> *)lhs.bdip,((IA_ConstDI<int> *)rhs.bdip)->value);
	} else {
	    return vec_iter_bo_operatorIAOPrs((IA_VectorDI<int> *)lhs.bdip,rhs);
	}
    } else if (lhs.type() == IA_ConstDI<int>::s_type()) {
	if (rhs.type() == IA_VectorDI<int>::s_type()) {
	    return vec_scalar_bo_operatorIAOPrs((IA_VectorDI<int> *)rhs.bdip,((IA_ConstDI<int> *)lhs.bdip)->value);
	} else if (rhs.type() == IA_ConstDI<int>::s_type()) {
	    return IA_IntDiscreteImage (lhs.domain(), (((IA_ConstDI<int> *)lhs.bdip)->value) >> (((IA_ConstDI<int> *)rhs.bdip)->value));
	} else {
	    return scalar_iter_bo_operatorIAOPrs(((IA_ConstDI<int> *)lhs.bdip)->value,rhs);
	}
    } else {
	if (rhs.type() == IA_VectorDI<int>::s_type()) {
	    return vec_iter_bo_operatorIAOPrs((IA_VectorDI<int> *)rhs.bdip,lhs);
	} else if (rhs.type() == IA_ConstDI<int>::s_type()) {
	    return scalar_iter_bo_operatorIAOPrs(((IA_ConstDI<int> *)rhs.bdip)->value,lhs);
	} else {
	    return iter_iter_bo_operatorIAOPrs(lhs,rhs);
	}
    }
}

//////////////////////////////////////////////////////////////////////
//
// Begin operation support routines for :
// binary pointwise commutative operator>> I(int) int I(int)
//
#ifndef vec_scalar_int_int_int_operatorIAOPrs
#define vec_scalar_int_int_int_operatorIAOPrs
static IA_IntDiscreteImage
vec_scalar_bo_operatorIAOPrs(const IA_VectorDI<int> *lhs,int rhs)
{
    const IA_IntPointSet domain = lhs->domain();
    const unsigned sz = domain.card();
    int *const vec = new int[sz];

    {
	int *ds = vec;
	const int *ls = lhs->vec;
	for (unsigned i=0; i<sz; i++) {
	    *(ds++) = ( (*(ls++)) >> (rhs) );
	}
    }
    return IA_IntDiscreteImage(domain, vec, sz, 1);
}
#endif // vec_scalar_int_int_int_operatorIAOPrs

// scalar-scalar operation is trivial

#ifndef scalar_iter_int_int_int_operatorIAOPrs
#define scalar_iter_int_int_int_operatorIAOPrs
static IA_IntDiscreteImage
scalar_iter_bo_operatorIAOPrs(int lhs,IA_IntDiscreteImage rhs)
{
    const IA_IntPointSet domain = rhs.domain();
    const unsigned sz = domain.card();
    int *const vec = new int[sz];

    {
	int *ds = vec;
	int rtmp;
	IA_DIVIter<int>	riter(rhs);
	for (unsigned i=0; i<sz; i++) {
	    riter(rtmp);
	    *(ds++) = ( (lhs) >> (rtmp) );
	}
    }
    return IA_IntDiscreteImage(domain, vec, sz, 1);
}
#endif // scalar_iter_int_int_int_operatorIAOPrs

IA_IntDiscreteImage
operator>> ( const IA_IntDiscreteImage &lhs, int rhs)
{
    if (lhs.type() == IA_VectorDI<int>::s_type()) {
	return vec_scalar_bo_operatorIAOPrs((IA_VectorDI<int> *)lhs.bdip,rhs);
    } else if (lhs.type() == IA_ConstDI<int>::s_type()) {
	return IA_IntDiscreteImage (lhs.domain(), (((IA_ConstDI<int> *)lhs.bdip)->value) >> (rhs));
    } else {
	return scalar_iter_bo_operatorIAOPrs(rhs,lhs);
    }
}

//////////////////////////////////////////////////////////////////////
//
// Begin operation support routines for :
// pointwise operator>>= I(int) I(int)
//
// There are none (it's inline)

//////////////////////////////////////////////////////////////////////
//
// Begin operation support routines for :
// pointwise operator>>= I(int) int
//
// There are none (it's inline)

//////////////////////////////////////////////////////////////////////
//
// Begin operation support routines for :
// unary pointwise operator~ I(int) I(int)
//
// Emacs: -*- C++ -*-

//
//	Copyright 1993, Center for Computer Vision and Visualization,
//	University of Florida.  All rights reserved.
//


//
// $Log:	unary-op.templ,v $
// Revision 1.2  93/05/27  11:49:04  thoth
// Copyright Notices
// 
// Revision 1.1  93/03/10  13:50:00  thoth
// Initial revision
// 

#ifndef vec_scalar_int_int_operatorIAOPbn
#define vec_scalar_int_int_operatorIAOPbn
static IA_IntDiscreteImage
vec_uo_operatorIAOPbn(const IA_VectorDI<int> *lhs)
{
    const IA_IntPointSet domain = lhs->domain();
    const unsigned sz = domain.card();
    int *const vec = new int[sz];

    {
	int *ds = vec;
	const int *ls = lhs->vec;
	for (unsigned i=0; i<sz; i++) {
	    *(ds++) = ~(*(ls++));
	}
    }
    return IA_IntDiscreteImage(domain, vec, sz, 1);
}
#endif // vec_scalar_int_int_operatorIAOPbn

// scalar-scalar operation is trivial

#ifndef iter_scalar_int_int_operatorIAOPbn
#define iter_scalar_int_int_operatorIAOPbn
static IA_IntDiscreteImage
iter_uo_operatorIAOPbn(IA_IntDiscreteImage lhs)
{
    const IA_IntPointSet domain = lhs.domain();
    const unsigned sz = domain.card();
    int *const vec = new int[sz];

    {
	int *ds = vec;
	int ltmp;
	IA_DIVIter<int>	liter(lhs);
	for (unsigned i=0; i<sz; i++) {
	    liter(ltmp);
	    *(ds++) = ~(ltmp);
	}
    }
    return IA_IntDiscreteImage(domain, vec, sz, 1);
}
#endif // iter_scalar_int_int_operatorIAOPbn

IA_IntDiscreteImage
operator~ ( const IA_IntDiscreteImage &arg)
{
    if (arg.type() == IA_VectorDI<int>::s_type()) {
	return vec_uo_operatorIAOPbn((IA_VectorDI<int> *)arg.bdip);
    } else if (arg.type() == IA_ConstDI<int>::s_type()) {
	return IA_IntDiscreteImage (arg.domain(), ~(((IA_ConstDI<int> *)arg.bdip)->value));
    } else {
	return iter_uo_operatorIAOPbn(arg);
    }
}

//////////////////////////////////////////////////////////////////////
//
// Begin operation support routines for :
// binary pointwise commutative operator&& I(int) I(int) I(int)
//
static IA_IntDiscreteImage
vec_vec_bo_operatorIAOPla(const IA_VectorDI<int> *lhs,const IA_VectorDI<int> *rhs)
{
    const IA_IntPointSet domain = lhs->domain();
    const unsigned sz = domain.card();
    int *const vec = new int[sz];

    {
	int *ds = vec;
	const int *ls = lhs->vec;
	const int *rs = rhs->vec;
	for (unsigned i=0; i<sz; i++) {
	    *(ds++) = ( (*(ls++)) && (*(rs++)) );
	}
    }
    return IA_IntDiscreteImage(domain, vec, sz, 1);
}

#ifndef vec_scalar_int_int_int_operatorIAOPla
#define vec_scalar_int_int_int_operatorIAOPla
static IA_IntDiscreteImage
vec_scalar_bo_operatorIAOPla(const IA_VectorDI<int> *lhs,int rhs)
{
    const IA_IntPointSet domain = lhs->domain();
    const unsigned sz = domain.card();
    int *const vec = new int[sz];

    {
	int *ds = vec;
	const int *ls = lhs->vec;
	for (unsigned i=0; i<sz; i++) {
	    *(ds++) = ( (*(ls++)) && (rhs) );
	}
    }
    return IA_IntDiscreteImage(domain, vec, sz, 1);
}
#endif // vec_scalar_int_int_int_operatorIAOPla

static IA_IntDiscreteImage
vec_iter_bo_operatorIAOPla(const IA_VectorDI<int> *lhs,IA_IntDiscreteImage rhs)
{
    const IA_IntPointSet domain = lhs->domain();
    const unsigned sz = domain.card();
    int *const vec = new int[sz];

    {
	int *ds = vec;
	const int *ls = lhs->vec;
	int rtmp;
	IA_DIVIter<int>	riter(rhs);
	for (unsigned i=0; i<sz; i++) {
	    riter(rtmp);
	    *(ds++) = ( (*(ls++)) && (rtmp) );
	}
    }
    return IA_IntDiscreteImage(domain, vec, sz, 1);
}

// scalar-scalar operation is trivial

#ifndef scalar_iter_int_int_int_operatorIAOPla
#define scalar_iter_int_int_int_operatorIAOPla
static IA_IntDiscreteImage
scalar_iter_bo_operatorIAOPla(int lhs,IA_IntDiscreteImage rhs)
{
    const IA_IntPointSet domain = rhs.domain();
    const unsigned sz = domain.card();
    int *const vec = new int[sz];

    {
	int *ds = vec;
	int rtmp;
	IA_DIVIter<int>	riter(rhs);
	for (unsigned i=0; i<sz; i++) {
	    riter(rtmp);
	    *(ds++) = ( (lhs) && (rtmp) );
	}
    }
    return IA_IntDiscreteImage(domain, vec, sz, 1);
}
#endif // scalar_iter_int_int_int_operatorIAOPla

static IA_IntDiscreteImage
iter_iter_bo_operatorIAOPla(IA_IntDiscreteImage lhs,IA_IntDiscreteImage rhs)
{
    const IA_IntPointSet domain = lhs.domain();
    const unsigned sz = domain.card();
    int *const vec = new int[sz];

    {
	int *ds = vec;
	int ltmp;
	IA_DIVIter<int>	liter(lhs);
	int rtmp;
	IA_DIVIter<int>	riter(rhs);
	for (unsigned i=0; i<sz; i++) {
	    liter(ltmp);
	    riter(rtmp);
	    *(ds++) = ( (ltmp) && (rtmp) );
	}
    }
    return IA_IntDiscreteImage(domain, vec, sz, 1);
}

IA_IntDiscreteImage
operator&& ( const IA_IntDiscreteImage &lhs,
	      const IA_IntDiscreteImage &rhs)
{
    if (lhs.domain() != rhs.domain()) {
	static IA_IntDiscreteImage	rval;
	ia_throw( IA::PSET_MISMATCH, __FILE__,__LINE__);
	return rval;
    }

    if (lhs.type() == IA_VectorDI<int>::s_type()) {
	if (rhs.type() == IA_VectorDI<int>::s_type()) {
	    return vec_vec_bo_operatorIAOPla((IA_VectorDI<int> *)lhs.bdip,(IA_VectorDI<int> *)rhs.bdip);
	} else if (rhs.type() == IA_ConstDI<int>::s_type()) {
	    return vec_scalar_bo_operatorIAOPla((IA_VectorDI<int> *)lhs.bdip,((IA_ConstDI<int> *)rhs.bdip)->value);
	} else {
	    return vec_iter_bo_operatorIAOPla((IA_VectorDI<int> *)lhs.bdip,rhs);
	}
    } else if (lhs.type() == IA_ConstDI<int>::s_type()) {
	if (rhs.type() == IA_VectorDI<int>::s_type()) {
	    return vec_scalar_bo_operatorIAOPla((IA_VectorDI<int> *)rhs.bdip,((IA_ConstDI<int> *)lhs.bdip)->value);
	} else if (rhs.type() == IA_ConstDI<int>::s_type()) {
	    return IA_IntDiscreteImage (lhs.domain(), (((IA_ConstDI<int> *)lhs.bdip)->value) && (((IA_ConstDI<int> *)rhs.bdip)->value));
	} else {
	    return scalar_iter_bo_operatorIAOPla(((IA_ConstDI<int> *)lhs.bdip)->value,rhs);
	}
    } else {
	if (rhs.type() == IA_VectorDI<int>::s_type()) {
	    return vec_iter_bo_operatorIAOPla((IA_VectorDI<int> *)rhs.bdip,lhs);
	} else if (rhs.type() == IA_ConstDI<int>::s_type()) {
	    return scalar_iter_bo_operatorIAOPla(((IA_ConstDI<int> *)rhs.bdip)->value,lhs);
	} else {
	    return iter_iter_bo_operatorIAOPla(lhs,rhs);
	}
    }
}

//////////////////////////////////////////////////////////////////////
//
// Begin operation support routines for :
// binary pointwise commutative operator&& I(int) int I(int)
//
#ifndef vec_scalar_int_int_int_operatorIAOPla
#define vec_scalar_int_int_int_operatorIAOPla
static IA_IntDiscreteImage
vec_scalar_bo_operatorIAOPla(const IA_VectorDI<int> *lhs,int rhs)
{
    const IA_IntPointSet domain = lhs->domain();
    const unsigned sz = domain.card();
    int *const vec = new int[sz];

    {
	int *ds = vec;
	const int *ls = lhs->vec;
	for (unsigned i=0; i<sz; i++) {
	    *(ds++) = ( (*(ls++)) && (rhs) );
	}
    }
    return IA_IntDiscreteImage(domain, vec, sz, 1);
}
#endif // vec_scalar_int_int_int_operatorIAOPla

// scalar-scalar operation is trivial

#ifndef scalar_iter_int_int_int_operatorIAOPla
#define scalar_iter_int_int_int_operatorIAOPla
static IA_IntDiscreteImage
scalar_iter_bo_operatorIAOPla(int lhs,IA_IntDiscreteImage rhs)
{
    const IA_IntPointSet domain = rhs.domain();
    const unsigned sz = domain.card();
    int *const vec = new int[sz];

    {
	int *ds = vec;
	int rtmp;
	IA_DIVIter<int>	riter(rhs);
	for (unsigned i=0; i<sz; i++) {
	    riter(rtmp);
	    *(ds++) = ( (lhs) && (rtmp) );
	}
    }
    return IA_IntDiscreteImage(domain, vec, sz, 1);
}
#endif // scalar_iter_int_int_int_operatorIAOPla

IA_IntDiscreteImage
operator&& ( const IA_IntDiscreteImage &lhs, int rhs)
{
    if (lhs.type() == IA_VectorDI<int>::s_type()) {
	return vec_scalar_bo_operatorIAOPla((IA_VectorDI<int> *)lhs.bdip,rhs);
    } else if (lhs.type() == IA_ConstDI<int>::s_type()) {
	return IA_IntDiscreteImage (lhs.domain(), (((IA_ConstDI<int> *)lhs.bdip)->value) && (rhs));
    } else {
	return scalar_iter_bo_operatorIAOPla(rhs,lhs);
    }
}

//////////////////////////////////////////////////////////////////////
//
// Begin operation support routines for :
// binary pointwise commutative operator|| I(int) I(int) I(int)
//
static IA_IntDiscreteImage
vec_vec_bo_operatorIAOPlo(const IA_VectorDI<int> *lhs,const IA_VectorDI<int> *rhs)
{
    const IA_IntPointSet domain = lhs->domain();
    const unsigned sz = domain.card();
    int *const vec = new int[sz];

    {
	int *ds = vec;
	const int *ls = lhs->vec;
	const int *rs = rhs->vec;
	for (unsigned i=0; i<sz; i++) {
	    *(ds++) = ( (*(ls++)) || (*(rs++)) );
	}
    }
    return IA_IntDiscreteImage(domain, vec, sz, 1);
}

#ifndef vec_scalar_int_int_int_operatorIAOPlo
#define vec_scalar_int_int_int_operatorIAOPlo
static IA_IntDiscreteImage
vec_scalar_bo_operatorIAOPlo(const IA_VectorDI<int> *lhs,int rhs)
{
    const IA_IntPointSet domain = lhs->domain();
    const unsigned sz = domain.card();
    int *const vec = new int[sz];

    {
	int *ds = vec;
	const int *ls = lhs->vec;
	for (unsigned i=0; i<sz; i++) {
	    *(ds++) = ( (*(ls++)) || (rhs) );
	}
    }
    return IA_IntDiscreteImage(domain, vec, sz, 1);
}
#endif // vec_scalar_int_int_int_operatorIAOPlo

static IA_IntDiscreteImage
vec_iter_bo_operatorIAOPlo(const IA_VectorDI<int> *lhs,IA_IntDiscreteImage rhs)
{
    const IA_IntPointSet domain = lhs->domain();
    const unsigned sz = domain.card();
    int *const vec = new int[sz];

    {
	int *ds = vec;
	const int *ls = lhs->vec;
	int rtmp;
	IA_DIVIter<int>	riter(rhs);
	for (unsigned i=0; i<sz; i++) {
	    riter(rtmp);
	    *(ds++) = ( (*(ls++)) || (rtmp) );
	}
    }
    return IA_IntDiscreteImage(domain, vec, sz, 1);
}

// scalar-scalar operation is trivial

#ifndef scalar_iter_int_int_int_operatorIAOPlo
#define scalar_iter_int_int_int_operatorIAOPlo
static IA_IntDiscreteImage
scalar_iter_bo_operatorIAOPlo(int lhs,IA_IntDiscreteImage rhs)
{
    const IA_IntPointSet domain = rhs.domain();
    const unsigned sz = domain.card();
    int *const vec = new int[sz];

    {
	int *ds = vec;
	int rtmp;
	IA_DIVIter<int>	riter(rhs);
	for (unsigned i=0; i<sz; i++) {
	    riter(rtmp);
	    *(ds++) = ( (lhs) || (rtmp) );
	}
    }
    return IA_IntDiscreteImage(domain, vec, sz, 1);
}
#endif // scalar_iter_int_int_int_operatorIAOPlo

static IA_IntDiscreteImage
iter_iter_bo_operatorIAOPlo(IA_IntDiscreteImage lhs,IA_IntDiscreteImage rhs)
{
    const IA_IntPointSet domain = lhs.domain();
    const unsigned sz = domain.card();
    int *const vec = new int[sz];

    {
	int *ds = vec;
	int ltmp;
	IA_DIVIter<int>	liter(lhs);
	int rtmp;
	IA_DIVIter<int>	riter(rhs);
	for (unsigned i=0; i<sz; i++) {
	    liter(ltmp);
	    riter(rtmp);
	    *(ds++) = ( (ltmp) || (rtmp) );
	}
    }
    return IA_IntDiscreteImage(domain, vec, sz, 1);
}

IA_IntDiscreteImage
operator|| ( const IA_IntDiscreteImage &lhs,
	      const IA_IntDiscreteImage &rhs)
{
    if (lhs.domain() != rhs.domain()) {
	static IA_IntDiscreteImage	rval;
	ia_throw( IA::PSET_MISMATCH, __FILE__,__LINE__);
	return rval;
    }

    if (lhs.type() == IA_VectorDI<int>::s_type()) {
	if (rhs.type() == IA_VectorDI<int>::s_type()) {
	    return vec_vec_bo_operatorIAOPlo((IA_VectorDI<int> *)lhs.bdip,(IA_VectorDI<int> *)rhs.bdip);
	} else if (rhs.type() == IA_ConstDI<int>::s_type()) {
	    return vec_scalar_bo_operatorIAOPlo((IA_VectorDI<int> *)lhs.bdip,((IA_ConstDI<int> *)rhs.bdip)->value);
	} else {
	    return vec_iter_bo_operatorIAOPlo((IA_VectorDI<int> *)lhs.bdip,rhs);
	}
    } else if (lhs.type() == IA_ConstDI<int>::s_type()) {
	if (rhs.type() == IA_VectorDI<int>::s_type()) {
	    return vec_scalar_bo_operatorIAOPlo((IA_VectorDI<int> *)rhs.bdip,((IA_ConstDI<int> *)lhs.bdip)->value);
	} else if (rhs.type() == IA_ConstDI<int>::s_type()) {
	    return IA_IntDiscreteImage (lhs.domain(), (((IA_ConstDI<int> *)lhs.bdip)->value) || (((IA_ConstDI<int> *)rhs.bdip)->value));
	} else {
	    return scalar_iter_bo_operatorIAOPlo(((IA_ConstDI<int> *)lhs.bdip)->value,rhs);
	}
    } else {
	if (rhs.type() == IA_VectorDI<int>::s_type()) {
	    return vec_iter_bo_operatorIAOPlo((IA_VectorDI<int> *)rhs.bdip,lhs);
	} else if (rhs.type() == IA_ConstDI<int>::s_type()) {
	    return scalar_iter_bo_operatorIAOPlo(((IA_ConstDI<int> *)rhs.bdip)->value,lhs);
	} else {
	    return iter_iter_bo_operatorIAOPlo(lhs,rhs);
	}
    }
}

//////////////////////////////////////////////////////////////////////
//
// Begin operation support routines for :
// binary pointwise commutative operator|| I(int) int I(int)
//
#ifndef vec_scalar_int_int_int_operatorIAOPlo
#define vec_scalar_int_int_int_operatorIAOPlo
static IA_IntDiscreteImage
vec_scalar_bo_operatorIAOPlo(const IA_VectorDI<int> *lhs,int rhs)
{
    const IA_IntPointSet domain = lhs->domain();
    const unsigned sz = domain.card();
    int *const vec = new int[sz];

    {
	int *ds = vec;
	const int *ls = lhs->vec;
	for (unsigned i=0; i<sz; i++) {
	    *(ds++) = ( (*(ls++)) || (rhs) );
	}
    }
    return IA_IntDiscreteImage(domain, vec, sz, 1);
}
#endif // vec_scalar_int_int_int_operatorIAOPlo

// scalar-scalar operation is trivial

#ifndef scalar_iter_int_int_int_operatorIAOPlo
#define scalar_iter_int_int_int_operatorIAOPlo
static IA_IntDiscreteImage
scalar_iter_bo_operatorIAOPlo(int lhs,IA_IntDiscreteImage rhs)
{
    const IA_IntPointSet domain = rhs.domain();
    const unsigned sz = domain.card();
    int *const vec = new int[sz];

    {
	int *ds = vec;
	int rtmp;
	IA_DIVIter<int>	riter(rhs);
	for (unsigned i=0; i<sz; i++) {
	    riter(rtmp);
	    *(ds++) = ( (lhs) || (rtmp) );
	}
    }
    return IA_IntDiscreteImage(domain, vec, sz, 1);
}
#endif // scalar_iter_int_int_int_operatorIAOPlo

IA_IntDiscreteImage
operator|| ( const IA_IntDiscreteImage &lhs, int rhs)
{
    if (lhs.type() == IA_VectorDI<int>::s_type()) {
	return vec_scalar_bo_operatorIAOPlo((IA_VectorDI<int> *)lhs.bdip,rhs);
    } else if (lhs.type() == IA_ConstDI<int>::s_type()) {
	return IA_IntDiscreteImage (lhs.domain(), (((IA_ConstDI<int> *)lhs.bdip)->value) || (rhs));
    } else {
	return scalar_iter_bo_operatorIAOPlo(rhs,lhs);
    }
}

//////////////////////////////////////////////////////////////////////
//
// Begin operation support routines for :
// unary pointwise operator! I(int) I(int)
//
// Emacs: -*- C++ -*-

//
//	Copyright 1993, Center for Computer Vision and Visualization,
//	University of Florida.  All rights reserved.
//


//
// $Log:	unary-op.templ,v $
// Revision 1.2  93/05/27  11:49:04  thoth
// Copyright Notices
// 
// Revision 1.1  93/03/10  13:50:00  thoth
// Initial revision
// 

#ifndef vec_scalar_int_int_operatorIAOPno
#define vec_scalar_int_int_operatorIAOPno
static IA_IntDiscreteImage
vec_uo_operatorIAOPno(const IA_VectorDI<int> *lhs)
{
    const IA_IntPointSet domain = lhs->domain();
    const unsigned sz = domain.card();
    int *const vec = new int[sz];

    {
	int *ds = vec;
	const int *ls = lhs->vec;
	for (unsigned i=0; i<sz; i++) {
	    *(ds++) = !(*(ls++));
	}
    }
    return IA_IntDiscreteImage(domain, vec, sz, 1);
}
#endif // vec_scalar_int_int_operatorIAOPno

// scalar-scalar operation is trivial

#ifndef iter_scalar_int_int_operatorIAOPno
#define iter_scalar_int_int_operatorIAOPno
static IA_IntDiscreteImage
iter_uo_operatorIAOPno(IA_IntDiscreteImage lhs)
{
    const IA_IntPointSet domain = lhs.domain();
    const unsigned sz = domain.card();
    int *const vec = new int[sz];

    {
	int *ds = vec;
	int ltmp;
	IA_DIVIter<int>	liter(lhs);
	for (unsigned i=0; i<sz; i++) {
	    liter(ltmp);
	    *(ds++) = !(ltmp);
	}
    }
    return IA_IntDiscreteImage(domain, vec, sz, 1);
}
#endif // iter_scalar_int_int_operatorIAOPno

IA_IntDiscreteImage
operator! ( const IA_IntDiscreteImage &arg)
{
    if (arg.type() == IA_VectorDI<int>::s_type()) {
	return vec_uo_operatorIAOPno((IA_VectorDI<int> *)arg.bdip);
    } else if (arg.type() == IA_ConstDI<int>::s_type()) {
	return IA_IntDiscreteImage (arg.domain(), !(((IA_ConstDI<int> *)arg.bdip)->value));
    } else {
	return iter_uo_operatorIAOPno(arg);
    }
}

//////////////////////////////////////////////////////////////////////
//
// Begin operation support routines for :
// binary strictrel non-commutative operator< I(int) I(int) int
//
int vec_vec_bo_operatorIAOPlt(const IA_VectorDI<int> *lhs,const IA_VectorDI<int> *rhs)
{
    const IA_IntPointSet domain = lhs->domain();
    const unsigned sz = domain.card();
    int *const vec = new int[sz];

    {
	int *ds = vec;
	const int *ls = lhs->vec;
	const int *rs = rhs->vec;
	for (unsigned i=0; i<sz; i++) {
	    if (!( (*(ls++)) < (*(rs++)) ))
		return 0;
	}
    }
    return 1;
}

#ifndef vec_scalar_int_int_int_operatorIAOPlt
#define vec_scalar_int_int_int_operatorIAOPlt
int vec_scalar_bo_operatorIAOPlt(const IA_VectorDI<int> *lhs,int rhs)
{
    const IA_IntPointSet domain = lhs->domain();
    const unsigned sz = domain.card();
    int *const vec = new int[sz];

    {
	int *ds = vec;
	const int *ls = lhs->vec;
	for (unsigned i=0; i<sz; i++) {
	    if (!( (*(ls++)) < (rhs) ))
		return 0;
	}
    }
    return 1;
}
#endif // vec_scalar_int_int_int_operatorIAOPlt

int vec_iter_bo_operatorIAOPlt(const IA_VectorDI<int> *lhs,IA_IntDiscreteImage rhs)
{
    const IA_IntPointSet domain = lhs->domain();
    const unsigned sz = domain.card();
    int *const vec = new int[sz];

    {
	int *ds = vec;
	const int *ls = lhs->vec;
	int rtmp;
	IA_DIVIter<int>	riter(rhs);
	for (unsigned i=0; i<sz; i++) {
	    riter(rtmp);
	    if (!( (*(ls++)) < (rtmp) ))
		return 0;
	}
    }
    return 1;
}

#ifndef scalar_vec_int_int_int_operatorIAOPlt
#define scalar_vec_int_int_int_operatorIAOPlt
int scalar_vec_bo_operatorIAOPlt(int lhs,const IA_VectorDI<int> *rhs)
{
    const IA_IntPointSet domain = rhs->domain();
    const unsigned sz = domain.card();
    int *const vec = new int[sz];

    {
	int *ds = vec;
	const int *rs = rhs->vec;
	for (unsigned i=0; i<sz; i++) {
	    if (!( (lhs) < (*(rs++)) ))
		return 0;
	}
    }
    return 1;
}
#endif // scalar_vec_int_int_int_operatorIAOPlt

// scalar-scalar operation is trivial

#ifndef scalar_iter_int_int_int_operatorIAOPlt
#define scalar_iter_int_int_int_operatorIAOPlt
int scalar_iter_bo_operatorIAOPlt(int lhs,IA_IntDiscreteImage rhs)
{
    const IA_IntPointSet domain = rhs.domain();
    const unsigned sz = domain.card();
    int *const vec = new int[sz];

    {
	int *ds = vec;
	int rtmp;
	IA_DIVIter<int>	riter(rhs);
	for (unsigned i=0; i<sz; i++) {
	    riter(rtmp);
	    if (!( (lhs) < (rtmp) ))
		return 0;
	}
    }
    return 1;
}
#endif // scalar_iter_int_int_int_operatorIAOPlt

int iter_vec_bo_operatorIAOPlt(IA_IntDiscreteImage lhs,const IA_VectorDI<int> *rhs)
{
    const IA_IntPointSet domain = lhs.domain();
    const unsigned sz = domain.card();
    int *const vec = new int[sz];

    {
	int *ds = vec;
	int ltmp;
	IA_DIVIter<int>	liter(lhs);
	const int *rs = rhs->vec;
	for (unsigned i=0; i<sz; i++) {
	    liter(ltmp);
	    if (!( (ltmp) < (*(rs++)) ))
		return 0;
	}
    }
    return 1;
}

#ifndef iter_scalar_int_int_int_operatorIAOPlt
#define iter_scalar_int_int_int_operatorIAOPlt
int iter_scalar_bo_operatorIAOPlt(IA_IntDiscreteImage lhs,int rhs)
{
    const IA_IntPointSet domain = lhs.domain();
    const unsigned sz = domain.card();
    int *const vec = new int[sz];

    {
	int *ds = vec;
	int ltmp;
	IA_DIVIter<int>	liter(lhs);
	for (unsigned i=0; i<sz; i++) {
	    liter(ltmp);
	    if (!( (ltmp) < (rhs) ))
		return 0;
	}
    }
    return 1;
}
#endif // iter_scalar_int_int_int_operatorIAOPlt

int iter_iter_bo_operatorIAOPlt(IA_IntDiscreteImage lhs,IA_IntDiscreteImage rhs)
{
    const IA_IntPointSet domain = lhs.domain();
    const unsigned sz = domain.card();
    int *const vec = new int[sz];

    {
	int *ds = vec;
	int ltmp;
	IA_DIVIter<int>	liter(lhs);
	int rtmp;
	IA_DIVIter<int>	riter(rhs);
	for (unsigned i=0; i<sz; i++) {
	    liter(ltmp);
	    riter(rtmp);
	    if (!( (ltmp) < (rtmp) ))
		return 0;
	}
    }
    return 1;
}

int operator< ( const IA_IntDiscreteImage &lhs,
	      const IA_IntDiscreteImage &rhs)
{
    if (lhs.domain() != rhs.domain()) {
	static int	rval;
	ia_throw( IA::PSET_MISMATCH, __FILE__,__LINE__);
	return rval;
    }

    if (lhs.type() == IA_VectorDI<int>::s_type()) {
	if (rhs.type() == IA_VectorDI<int>::s_type()) {
	    return vec_vec_bo_operatorIAOPlt((IA_VectorDI<int> *)lhs.bdip,(IA_VectorDI<int> *)rhs.bdip);
	} else if (rhs.type() == IA_ConstDI<int>::s_type()) {
	    return vec_scalar_bo_operatorIAOPlt((IA_VectorDI<int> *)lhs.bdip,((IA_ConstDI<int> *)rhs.bdip)->value);
	} else {
	    return vec_iter_bo_operatorIAOPlt((IA_VectorDI<int> *)lhs.bdip,rhs);
	}
    } else if (lhs.type() == IA_ConstDI<int>::s_type()) {
	if (rhs.type() == IA_VectorDI<int>::s_type()) {
	    return scalar_vec_bo_operatorIAOPlt(((IA_ConstDI<int> *)lhs.bdip)->value,(IA_VectorDI<int> *)rhs.bdip);
	} else if (rhs.type() == IA_ConstDI<int>::s_type()) {
	    return (((IA_ConstDI<int> *)lhs.bdip)->value) < (((IA_ConstDI<int> *)rhs.bdip)->value);
	} else {
	    return scalar_iter_bo_operatorIAOPlt(((IA_ConstDI<int> *)lhs.bdip)->value,rhs);
	}
    } else {
	if (rhs.type() == IA_VectorDI<int>::s_type()) {
	    return iter_vec_bo_operatorIAOPlt(lhs,(IA_VectorDI<int> *)rhs.bdip);
	} else if (rhs.type() == IA_ConstDI<int>::s_type()) {
	    return iter_scalar_bo_operatorIAOPlt(lhs,((IA_ConstDI<int> *)rhs.bdip)->value);
	} else {
	    return iter_iter_bo_operatorIAOPlt(lhs,rhs);
	}
    }
}

//////////////////////////////////////////////////////////////////////
//
// Begin operation support routines for :
// binary strictrel non-commutative operator< I(int) int int
//
#ifndef vec_scalar_int_int_int_operatorIAOPlt
#define vec_scalar_int_int_int_operatorIAOPlt
int vec_scalar_bo_operatorIAOPlt(const IA_VectorDI<int> *lhs,int rhs)
{
    const IA_IntPointSet domain = lhs->domain();
    const unsigned sz = domain.card();
    int *const vec = new int[sz];

    {
	int *ds = vec;
	const int *ls = lhs->vec;
	for (unsigned i=0; i<sz; i++) {
	    if (!( (*(ls++)) < (rhs) ))
		return 0;
	}
    }
    return 1;
}
#endif // vec_scalar_int_int_int_operatorIAOPlt

// scalar-scalar operation is trivial

#ifndef iter_scalar_int_int_int_operatorIAOPlt
#define iter_scalar_int_int_int_operatorIAOPlt
int iter_scalar_bo_operatorIAOPlt(IA_IntDiscreteImage lhs,int rhs)
{
    const IA_IntPointSet domain = lhs.domain();
    const unsigned sz = domain.card();
    int *const vec = new int[sz];

    {
	int *ds = vec;
	int ltmp;
	IA_DIVIter<int>	liter(lhs);
	for (unsigned i=0; i<sz; i++) {
	    liter(ltmp);
	    if (!( (ltmp) < (rhs) ))
		return 0;
	}
    }
    return 1;
}
#endif // iter_scalar_int_int_int_operatorIAOPlt

int operator< ( const IA_IntDiscreteImage &lhs, int rhs)
{
    if (lhs.type() == IA_VectorDI<int>::s_type()) {
	return vec_scalar_bo_operatorIAOPlt((IA_VectorDI<int> *)lhs.bdip,rhs);
    } else if (lhs.type() == IA_ConstDI<int>::s_type()) {
	return (((IA_ConstDI<int> *)lhs.bdip)->value) < (rhs);
    } else {
	return iter_scalar_bo_operatorIAOPlt(lhs,rhs);
    }
}

//////////////////////////////////////////////////////////////////////
//
// Begin operation support routines for :
// binary strictrel non-commutative operator< int I(int) int
//
#ifndef scalar_vec_int_int_int_operatorIAOPlt
#define scalar_vec_int_int_int_operatorIAOPlt
int scalar_vec_bo_operatorIAOPlt(int lhs,const IA_VectorDI<int> *rhs)
{
    const IA_IntPointSet domain = rhs->domain();
    const unsigned sz = domain.card();
    int *const vec = new int[sz];

    {
	int *ds = vec;
	const int *rs = rhs->vec;
	for (unsigned i=0; i<sz; i++) {
	    if (!( (lhs) < (*(rs++)) ))
		return 0;
	}
    }
    return 1;
}
#endif // scalar_vec_int_int_int_operatorIAOPlt

// scalar-scalar operation is trivial

#ifndef scalar_iter_int_int_int_operatorIAOPlt
#define scalar_iter_int_int_int_operatorIAOPlt
int scalar_iter_bo_operatorIAOPlt(int lhs,IA_IntDiscreteImage rhs)
{
    const IA_IntPointSet domain = rhs.domain();
    const unsigned sz = domain.card();
    int *const vec = new int[sz];

    {
	int *ds = vec;
	int rtmp;
	IA_DIVIter<int>	riter(rhs);
	for (unsigned i=0; i<sz; i++) {
	    riter(rtmp);
	    if (!( (lhs) < (rtmp) ))
		return 0;
	}
    }
    return 1;
}
#endif // scalar_iter_int_int_int_operatorIAOPlt

int operator< (int lhs, const IA_IntDiscreteImage &rhs)
{
    if (rhs.type() == IA_VectorDI<int>::s_type()) {
	return scalar_vec_bo_operatorIAOPlt(lhs,(IA_VectorDI<int> *)rhs.bdip);
    } else if (rhs.type() == IA_ConstDI<int>::s_type()) {
	return (lhs) < (((IA_ConstDI<int> *)rhs.bdip)->value);
    } else {
	return scalar_iter_bo_operatorIAOPlt(lhs,rhs);
    }
}

//////////////////////////////////////////////////////////////////////
//
// Begin operation support routines for :
// binary strictrel non-commutative operator<= I(int) I(int) int
//
int vec_vec_bo_operatorIAOPle(const IA_VectorDI<int> *lhs,const IA_VectorDI<int> *rhs)
{
    const IA_IntPointSet domain = lhs->domain();
    const unsigned sz = domain.card();
    int *const vec = new int[sz];

    {
	int *ds = vec;
	const int *ls = lhs->vec;
	const int *rs = rhs->vec;
	for (unsigned i=0; i<sz; i++) {
	    if (!( (*(ls++)) <= (*(rs++)) ))
		return 0;
	}
    }
    return 1;
}

#ifndef vec_scalar_int_int_int_operatorIAOPle
#define vec_scalar_int_int_int_operatorIAOPle
int vec_scalar_bo_operatorIAOPle(const IA_VectorDI<int> *lhs,int rhs)
{
    const IA_IntPointSet domain = lhs->domain();
    const unsigned sz = domain.card();
    int *const vec = new int[sz];

    {
	int *ds = vec;
	const int *ls = lhs->vec;
	for (unsigned i=0; i<sz; i++) {
	    if (!( (*(ls++)) <= (rhs) ))
		return 0;
	}
    }
    return 1;
}
#endif // vec_scalar_int_int_int_operatorIAOPle

int vec_iter_bo_operatorIAOPle(const IA_VectorDI<int> *lhs,IA_IntDiscreteImage rhs)
{
    const IA_IntPointSet domain = lhs->domain();
    const unsigned sz = domain.card();
    int *const vec = new int[sz];

    {
	int *ds = vec;
	const int *ls = lhs->vec;
	int rtmp;
	IA_DIVIter<int>	riter(rhs);
	for (unsigned i=0; i<sz; i++) {
	    riter(rtmp);
	    if (!( (*(ls++)) <= (rtmp) ))
		return 0;
	}
    }
    return 1;
}

#ifndef scalar_vec_int_int_int_operatorIAOPle
#define scalar_vec_int_int_int_operatorIAOPle
int scalar_vec_bo_operatorIAOPle(int lhs,const IA_VectorDI<int> *rhs)
{
    const IA_IntPointSet domain = rhs->domain();
    const unsigned sz = domain.card();
    int *const vec = new int[sz];

    {
	int *ds = vec;
	const int *rs = rhs->vec;
	for (unsigned i=0; i<sz; i++) {
	    if (!( (lhs) <= (*(rs++)) ))
		return 0;
	}
    }
    return 1;
}
#endif // scalar_vec_int_int_int_operatorIAOPle

// scalar-scalar operation is trivial

#ifndef scalar_iter_int_int_int_operatorIAOPle
#define scalar_iter_int_int_int_operatorIAOPle
int scalar_iter_bo_operatorIAOPle(int lhs,IA_IntDiscreteImage rhs)
{
    const IA_IntPointSet domain = rhs.domain();
    const unsigned sz = domain.card();
    int *const vec = new int[sz];

    {
	int *ds = vec;
	int rtmp;
	IA_DIVIter<int>	riter(rhs);
	for (unsigned i=0; i<sz; i++) {
	    riter(rtmp);
	    if (!( (lhs) <= (rtmp) ))
		return 0;
	}
    }
    return 1;
}
#endif // scalar_iter_int_int_int_operatorIAOPle

int iter_vec_bo_operatorIAOPle(IA_IntDiscreteImage lhs,const IA_VectorDI<int> *rhs)
{
    const IA_IntPointSet domain = lhs.domain();
    const unsigned sz = domain.card();
    int *const vec = new int[sz];

    {
	int *ds = vec;
	int ltmp;
	IA_DIVIter<int>	liter(lhs);
	const int *rs = rhs->vec;
	for (unsigned i=0; i<sz; i++) {
	    liter(ltmp);
	    if (!( (ltmp) <= (*(rs++)) ))
		return 0;
	}
    }
    return 1;
}

#ifndef iter_scalar_int_int_int_operatorIAOPle
#define iter_scalar_int_int_int_operatorIAOPle
int iter_scalar_bo_operatorIAOPle(IA_IntDiscreteImage lhs,int rhs)
{
    const IA_IntPointSet domain = lhs.domain();
    const unsigned sz = domain.card();
    int *const vec = new int[sz];

    {
	int *ds = vec;
	int ltmp;
	IA_DIVIter<int>	liter(lhs);
	for (unsigned i=0; i<sz; i++) {
	    liter(ltmp);
	    if (!( (ltmp) <= (rhs) ))
		return 0;
	}
    }
    return 1;
}
#endif // iter_scalar_int_int_int_operatorIAOPle

int iter_iter_bo_operatorIAOPle(IA_IntDiscreteImage lhs,IA_IntDiscreteImage rhs)
{
    const IA_IntPointSet domain = lhs.domain();
    const unsigned sz = domain.card();
    int *const vec = new int[sz];

    {
	int *ds = vec;
	int ltmp;
	IA_DIVIter<int>	liter(lhs);
	int rtmp;
	IA_DIVIter<int>	riter(rhs);
	for (unsigned i=0; i<sz; i++) {
	    liter(ltmp);
	    riter(rtmp);
	    if (!( (ltmp) <= (rtmp) ))
		return 0;
	}
    }
    return 1;
}

int operator<= ( const IA_IntDiscreteImage &lhs,
	      const IA_IntDiscreteImage &rhs)
{
    if (lhs.domain() != rhs.domain()) {
	static int	rval;
	ia_throw( IA::PSET_MISMATCH, __FILE__,__LINE__);
	return rval;
    }

    if (lhs.type() == IA_VectorDI<int>::s_type()) {
	if (rhs.type() == IA_VectorDI<int>::s_type()) {
	    return vec_vec_bo_operatorIAOPle((IA_VectorDI<int> *)lhs.bdip,(IA_VectorDI<int> *)rhs.bdip);
	} else if (rhs.type() == IA_ConstDI<int>::s_type()) {
	    return vec_scalar_bo_operatorIAOPle((IA_VectorDI<int> *)lhs.bdip,((IA_ConstDI<int> *)rhs.bdip)->value);
	} else {
	    return vec_iter_bo_operatorIAOPle((IA_VectorDI<int> *)lhs.bdip,rhs);
	}
    } else if (lhs.type() == IA_ConstDI<int>::s_type()) {
	if (rhs.type() == IA_VectorDI<int>::s_type()) {
	    return scalar_vec_bo_operatorIAOPle(((IA_ConstDI<int> *)lhs.bdip)->value,(IA_VectorDI<int> *)rhs.bdip);
	} else if (rhs.type() == IA_ConstDI<int>::s_type()) {
	    return (((IA_ConstDI<int> *)lhs.bdip)->value) <= (((IA_ConstDI<int> *)rhs.bdip)->value);
	} else {
	    return scalar_iter_bo_operatorIAOPle(((IA_ConstDI<int> *)lhs.bdip)->value,rhs);
	}
    } else {
	if (rhs.type() == IA_VectorDI<int>::s_type()) {
	    return iter_vec_bo_operatorIAOPle(lhs,(IA_VectorDI<int> *)rhs.bdip);
	} else if (rhs.type() == IA_ConstDI<int>::s_type()) {
	    return iter_scalar_bo_operatorIAOPle(lhs,((IA_ConstDI<int> *)rhs.bdip)->value);
	} else {
	    return iter_iter_bo_operatorIAOPle(lhs,rhs);
	}
    }
}

//////////////////////////////////////////////////////////////////////
//
// Begin operation support routines for :
// binary strictrel non-commutative operator<= I(int) int int
//
#ifndef vec_scalar_int_int_int_operatorIAOPle
#define vec_scalar_int_int_int_operatorIAOPle
int vec_scalar_bo_operatorIAOPle(const IA_VectorDI<int> *lhs,int rhs)
{
    const IA_IntPointSet domain = lhs->domain();
    const unsigned sz = domain.card();
    int *const vec = new int[sz];

    {
	int *ds = vec;
	const int *ls = lhs->vec;
	for (unsigned i=0; i<sz; i++) {
	    if (!( (*(ls++)) <= (rhs) ))
		return 0;
	}
    }
    return 1;
}
#endif // vec_scalar_int_int_int_operatorIAOPle

// scalar-scalar operation is trivial

#ifndef iter_scalar_int_int_int_operatorIAOPle
#define iter_scalar_int_int_int_operatorIAOPle
int iter_scalar_bo_operatorIAOPle(IA_IntDiscreteImage lhs,int rhs)
{
    const IA_IntPointSet domain = lhs.domain();
    const unsigned sz = domain.card();
    int *const vec = new int[sz];

    {
	int *ds = vec;
	int ltmp;
	IA_DIVIter<int>	liter(lhs);
	for (unsigned i=0; i<sz; i++) {
	    liter(ltmp);
	    if (!( (ltmp) <= (rhs) ))
		return 0;
	}
    }
    return 1;
}
#endif // iter_scalar_int_int_int_operatorIAOPle

int operator<= ( const IA_IntDiscreteImage &lhs, int rhs)
{
    if (lhs.type() == IA_VectorDI<int>::s_type()) {
	return vec_scalar_bo_operatorIAOPle((IA_VectorDI<int> *)lhs.bdip,rhs);
    } else if (lhs.type() == IA_ConstDI<int>::s_type()) {
	return (((IA_ConstDI<int> *)lhs.bdip)->value) <= (rhs);
    } else {
	return iter_scalar_bo_operatorIAOPle(lhs,rhs);
    }
}

//////////////////////////////////////////////////////////////////////
//
// Begin operation support routines for :
// binary strictrel non-commutative operator<= int I(int) int
//
#ifndef scalar_vec_int_int_int_operatorIAOPle
#define scalar_vec_int_int_int_operatorIAOPle
int scalar_vec_bo_operatorIAOPle(int lhs,const IA_VectorDI<int> *rhs)
{
    const IA_IntPointSet domain = rhs->domain();
    const unsigned sz = domain.card();
    int *const vec = new int[sz];

    {
	int *ds = vec;
	const int *rs = rhs->vec;
	for (unsigned i=0; i<sz; i++) {
	    if (!( (lhs) <= (*(rs++)) ))
		return 0;
	}
    }
    return 1;
}
#endif // scalar_vec_int_int_int_operatorIAOPle

// scalar-scalar operation is trivial

#ifndef scalar_iter_int_int_int_operatorIAOPle
#define scalar_iter_int_int_int_operatorIAOPle
int scalar_iter_bo_operatorIAOPle(int lhs,IA_IntDiscreteImage rhs)
{
    const IA_IntPointSet domain = rhs.domain();
    const unsigned sz = domain.card();
    int *const vec = new int[sz];

    {
	int *ds = vec;
	int rtmp;
	IA_DIVIter<int>	riter(rhs);
	for (unsigned i=0; i<sz; i++) {
	    riter(rtmp);
	    if (!( (lhs) <= (rtmp) ))
		return 0;
	}
    }
    return 1;
}
#endif // scalar_iter_int_int_int_operatorIAOPle

int operator<= (int lhs, const IA_IntDiscreteImage &rhs)
{
    if (rhs.type() == IA_VectorDI<int>::s_type()) {
	return scalar_vec_bo_operatorIAOPle(lhs,(IA_VectorDI<int> *)rhs.bdip);
    } else if (rhs.type() == IA_ConstDI<int>::s_type()) {
	return (lhs) <= (((IA_ConstDI<int> *)rhs.bdip)->value);
    } else {
	return scalar_iter_bo_operatorIAOPle(lhs,rhs);
    }
}

//////////////////////////////////////////////////////////////////////
//
// Begin operation support routines for :
// binary strictrel commutative operator== I(int) I(int) int
//
int vec_vec_bo_operatorIAOPeq(const IA_VectorDI<int> *lhs,const IA_VectorDI<int> *rhs)
{
    const IA_IntPointSet domain = lhs->domain();
    const unsigned sz = domain.card();
    int *const vec = new int[sz];

    {
	int *ds = vec;
	const int *ls = lhs->vec;
	const int *rs = rhs->vec;
	for (unsigned i=0; i<sz; i++) {
	    if (!( (*(ls++)) == (*(rs++)) ))
		return 0;
	}
    }
    return 1;
}

#ifndef vec_scalar_int_int_int_operatorIAOPeq
#define vec_scalar_int_int_int_operatorIAOPeq
int vec_scalar_bo_operatorIAOPeq(const IA_VectorDI<int> *lhs,int rhs)
{
    const IA_IntPointSet domain = lhs->domain();
    const unsigned sz = domain.card();
    int *const vec = new int[sz];

    {
	int *ds = vec;
	const int *ls = lhs->vec;
	for (unsigned i=0; i<sz; i++) {
	    if (!( (*(ls++)) == (rhs) ))
		return 0;
	}
    }
    return 1;
}
#endif // vec_scalar_int_int_int_operatorIAOPeq

int vec_iter_bo_operatorIAOPeq(const IA_VectorDI<int> *lhs,IA_IntDiscreteImage rhs)
{
    const IA_IntPointSet domain = lhs->domain();
    const unsigned sz = domain.card();
    int *const vec = new int[sz];

    {
	int *ds = vec;
	const int *ls = lhs->vec;
	int rtmp;
	IA_DIVIter<int>	riter(rhs);
	for (unsigned i=0; i<sz; i++) {
	    riter(rtmp);
	    if (!( (*(ls++)) == (rtmp) ))
		return 0;
	}
    }
    return 1;
}

// scalar-scalar operation is trivial

#ifndef scalar_iter_int_int_int_operatorIAOPeq
#define scalar_iter_int_int_int_operatorIAOPeq
int scalar_iter_bo_operatorIAOPeq(int lhs,IA_IntDiscreteImage rhs)
{
    const IA_IntPointSet domain = rhs.domain();
    const unsigned sz = domain.card();
    int *const vec = new int[sz];

    {
	int *ds = vec;
	int rtmp;
	IA_DIVIter<int>	riter(rhs);
	for (unsigned i=0; i<sz; i++) {
	    riter(rtmp);
	    if (!( (lhs) == (rtmp) ))
		return 0;
	}
    }
    return 1;
}
#endif // scalar_iter_int_int_int_operatorIAOPeq

int iter_iter_bo_operatorIAOPeq(IA_IntDiscreteImage lhs,IA_IntDiscreteImage rhs)
{
    const IA_IntPointSet domain = lhs.domain();
    const unsigned sz = domain.card();
    int *const vec = new int[sz];

    {
	int *ds = vec;
	int ltmp;
	IA_DIVIter<int>	liter(lhs);
	int rtmp;
	IA_DIVIter<int>	riter(rhs);
	for (unsigned i=0; i<sz; i++) {
	    liter(ltmp);
	    riter(rtmp);
	    if (!( (ltmp) == (rtmp) ))
		return 0;
	}
    }
    return 1;
}

int operator== ( const IA_IntDiscreteImage &lhs,
	      const IA_IntDiscreteImage &rhs)
{
    if (lhs.domain() != rhs.domain()) {
	static int	rval;
	ia_throw( IA::PSET_MISMATCH, __FILE__,__LINE__);
	return rval;
    }

    if (lhs.type() == IA_VectorDI<int>::s_type()) {
	if (rhs.type() == IA_VectorDI<int>::s_type()) {
	    return vec_vec_bo_operatorIAOPeq((IA_VectorDI<int> *)lhs.bdip,(IA_VectorDI<int> *)rhs.bdip);
	} else if (rhs.type() == IA_ConstDI<int>::s_type()) {
	    return vec_scalar_bo_operatorIAOPeq((IA_VectorDI<int> *)lhs.bdip,((IA_ConstDI<int> *)rhs.bdip)->value);
	} else {
	    return vec_iter_bo_operatorIAOPeq((IA_VectorDI<int> *)lhs.bdip,rhs);
	}
    } else if (lhs.type() == IA_ConstDI<int>::s_type()) {
	if (rhs.type() == IA_VectorDI<int>::s_type()) {
	    return vec_scalar_bo_operatorIAOPeq((IA_VectorDI<int> *)rhs.bdip,((IA_ConstDI<int> *)lhs.bdip)->value);
	} else if (rhs.type() == IA_ConstDI<int>::s_type()) {
	    return (((IA_ConstDI<int> *)lhs.bdip)->value) == (((IA_ConstDI<int> *)rhs.bdip)->value);
	} else {
	    return scalar_iter_bo_operatorIAOPeq(((IA_ConstDI<int> *)lhs.bdip)->value,rhs);
	}
    } else {
	if (rhs.type() == IA_VectorDI<int>::s_type()) {
	    return vec_iter_bo_operatorIAOPeq((IA_VectorDI<int> *)rhs.bdip,lhs);
	} else if (rhs.type() == IA_ConstDI<int>::s_type()) {
	    return scalar_iter_bo_operatorIAOPeq(((IA_ConstDI<int> *)rhs.bdip)->value,lhs);
	} else {
	    return iter_iter_bo_operatorIAOPeq(lhs,rhs);
	}
    }
}

//////////////////////////////////////////////////////////////////////
//
// Begin operation support routines for :
// binary strictrel commutative operator== I(int) int int
//
#ifndef vec_scalar_int_int_int_operatorIAOPeq
#define vec_scalar_int_int_int_operatorIAOPeq
int vec_scalar_bo_operatorIAOPeq(const IA_VectorDI<int> *lhs,int rhs)
{
    const IA_IntPointSet domain = lhs->domain();
    const unsigned sz = domain.card();
    int *const vec = new int[sz];

    {
	int *ds = vec;
	const int *ls = lhs->vec;
	for (unsigned i=0; i<sz; i++) {
	    if (!( (*(ls++)) == (rhs) ))
		return 0;
	}
    }
    return 1;
}
#endif // vec_scalar_int_int_int_operatorIAOPeq

// scalar-scalar operation is trivial

#ifndef scalar_iter_int_int_int_operatorIAOPeq
#define scalar_iter_int_int_int_operatorIAOPeq
int scalar_iter_bo_operatorIAOPeq(int lhs,IA_IntDiscreteImage rhs)
{
    const IA_IntPointSet domain = rhs.domain();
    const unsigned sz = domain.card();
    int *const vec = new int[sz];

    {
	int *ds = vec;
	int rtmp;
	IA_DIVIter<int>	riter(rhs);
	for (unsigned i=0; i<sz; i++) {
	    riter(rtmp);
	    if (!( (lhs) == (rtmp) ))
		return 0;
	}
    }
    return 1;
}
#endif // scalar_iter_int_int_int_operatorIAOPeq

int operator== ( const IA_IntDiscreteImage &lhs, int rhs)
{
    if (lhs.type() == IA_VectorDI<int>::s_type()) {
	return vec_scalar_bo_operatorIAOPeq((IA_VectorDI<int> *)lhs.bdip,rhs);
    } else if (lhs.type() == IA_ConstDI<int>::s_type()) {
	return (((IA_ConstDI<int> *)lhs.bdip)->value) == (rhs);
    } else {
	return scalar_iter_bo_operatorIAOPeq(rhs,lhs);
    }
}

//////////////////////////////////////////////////////////////////////
//
// Begin operation support routines for :
// binary strictrel commutative strict_ne subop=operator!= I(int) I(int) int
//
int vec_vec_bo_strict_ne(const IA_VectorDI<int> *lhs,const IA_VectorDI<int> *rhs)
{
    const IA_IntPointSet domain = lhs->domain();
    const unsigned sz = domain.card();
    int *const vec = new int[sz];

    {
	int *ds = vec;
	const int *ls = lhs->vec;
	const int *rs = rhs->vec;
	for (unsigned i=0; i<sz; i++) {
	    if (!( (*(ls++)) != (*(rs++)) ))
		return 0;
	}
    }
    return 1;
}

#ifndef vec_scalar_int_int_int_strict_ne
#define vec_scalar_int_int_int_strict_ne
int vec_scalar_bo_strict_ne(const IA_VectorDI<int> *lhs,int rhs)
{
    const IA_IntPointSet domain = lhs->domain();
    const unsigned sz = domain.card();
    int *const vec = new int[sz];

    {
	int *ds = vec;
	const int *ls = lhs->vec;
	for (unsigned i=0; i<sz; i++) {
	    if (!( (*(ls++)) != (rhs) ))
		return 0;
	}
    }
    return 1;
}
#endif // vec_scalar_int_int_int_strict_ne

int vec_iter_bo_strict_ne(const IA_VectorDI<int> *lhs,IA_IntDiscreteImage rhs)
{
    const IA_IntPointSet domain = lhs->domain();
    const unsigned sz = domain.card();
    int *const vec = new int[sz];

    {
	int *ds = vec;
	const int *ls = lhs->vec;
	int rtmp;
	IA_DIVIter<int>	riter(rhs);
	for (unsigned i=0; i<sz; i++) {
	    riter(rtmp);
	    if (!( (*(ls++)) != (rtmp) ))
		return 0;
	}
    }
    return 1;
}

// scalar-scalar operation is trivial

#ifndef scalar_iter_int_int_int_strict_ne
#define scalar_iter_int_int_int_strict_ne
int scalar_iter_bo_strict_ne(int lhs,IA_IntDiscreteImage rhs)
{
    const IA_IntPointSet domain = rhs.domain();
    const unsigned sz = domain.card();
    int *const vec = new int[sz];

    {
	int *ds = vec;
	int rtmp;
	IA_DIVIter<int>	riter(rhs);
	for (unsigned i=0; i<sz; i++) {
	    riter(rtmp);
	    if (!( (lhs) != (rtmp) ))
		return 0;
	}
    }
    return 1;
}
#endif // scalar_iter_int_int_int_strict_ne

int iter_iter_bo_strict_ne(IA_IntDiscreteImage lhs,IA_IntDiscreteImage rhs)
{
    const IA_IntPointSet domain = lhs.domain();
    const unsigned sz = domain.card();
    int *const vec = new int[sz];

    {
	int *ds = vec;
	int ltmp;
	IA_DIVIter<int>	liter(lhs);
	int rtmp;
	IA_DIVIter<int>	riter(rhs);
	for (unsigned i=0; i<sz; i++) {
	    liter(ltmp);
	    riter(rtmp);
	    if (!( (ltmp) != (rtmp) ))
		return 0;
	}
    }
    return 1;
}

int strict_ne ( const IA_IntDiscreteImage &lhs,
	      const IA_IntDiscreteImage &rhs)
{
    if (lhs.domain() != rhs.domain()) {
	static int	rval;
	ia_throw( IA::PSET_MISMATCH, __FILE__,__LINE__);
	return rval;
    }

    if (lhs.type() == IA_VectorDI<int>::s_type()) {
	if (rhs.type() == IA_VectorDI<int>::s_type()) {
	    return vec_vec_bo_strict_ne((IA_VectorDI<int> *)lhs.bdip,(IA_VectorDI<int> *)rhs.bdip);
	} else if (rhs.type() == IA_ConstDI<int>::s_type()) {
	    return vec_scalar_bo_strict_ne((IA_VectorDI<int> *)lhs.bdip,((IA_ConstDI<int> *)rhs.bdip)->value);
	} else {
	    return vec_iter_bo_strict_ne((IA_VectorDI<int> *)lhs.bdip,rhs);
	}
    } else if (lhs.type() == IA_ConstDI<int>::s_type()) {
	if (rhs.type() == IA_VectorDI<int>::s_type()) {
	    return vec_scalar_bo_strict_ne((IA_VectorDI<int> *)rhs.bdip,((IA_ConstDI<int> *)lhs.bdip)->value);
	} else if (rhs.type() == IA_ConstDI<int>::s_type()) {
	    return (((IA_ConstDI<int> *)lhs.bdip)->value) != (((IA_ConstDI<int> *)rhs.bdip)->value);
	} else {
	    return scalar_iter_bo_strict_ne(((IA_ConstDI<int> *)lhs.bdip)->value,rhs);
	}
    } else {
	if (rhs.type() == IA_VectorDI<int>::s_type()) {
	    return vec_iter_bo_strict_ne((IA_VectorDI<int> *)rhs.bdip,lhs);
	} else if (rhs.type() == IA_ConstDI<int>::s_type()) {
	    return scalar_iter_bo_strict_ne(((IA_ConstDI<int> *)rhs.bdip)->value,lhs);
	} else {
	    return iter_iter_bo_strict_ne(lhs,rhs);
	}
    }
}

//////////////////////////////////////////////////////////////////////
//
// Begin operation support routines for :
// binary strictrel commutative strict_ne subop=operator!= I(int) int int
//
#ifndef vec_scalar_int_int_int_strict_ne
#define vec_scalar_int_int_int_strict_ne
int vec_scalar_bo_strict_ne(const IA_VectorDI<int> *lhs,int rhs)
{
    const IA_IntPointSet domain = lhs->domain();
    const unsigned sz = domain.card();
    int *const vec = new int[sz];

    {
	int *ds = vec;
	const int *ls = lhs->vec;
	for (unsigned i=0; i<sz; i++) {
	    if (!( (*(ls++)) != (rhs) ))
		return 0;
	}
    }
    return 1;
}
#endif // vec_scalar_int_int_int_strict_ne

// scalar-scalar operation is trivial

#ifndef scalar_iter_int_int_int_strict_ne
#define scalar_iter_int_int_int_strict_ne
int scalar_iter_bo_strict_ne(int lhs,IA_IntDiscreteImage rhs)
{
    const IA_IntPointSet domain = rhs.domain();
    const unsigned sz = domain.card();
    int *const vec = new int[sz];

    {
	int *ds = vec;
	int rtmp;
	IA_DIVIter<int>	riter(rhs);
	for (unsigned i=0; i<sz; i++) {
	    riter(rtmp);
	    if (!( (lhs) != (rtmp) ))
		return 0;
	}
    }
    return 1;
}
#endif // scalar_iter_int_int_int_strict_ne

int strict_ne ( const IA_IntDiscreteImage &lhs, int rhs)
{
    if (lhs.type() == IA_VectorDI<int>::s_type()) {
	return vec_scalar_bo_strict_ne((IA_VectorDI<int> *)lhs.bdip,rhs);
    } else if (lhs.type() == IA_ConstDI<int>::s_type()) {
	return (((IA_ConstDI<int> *)lhs.bdip)->value) != (rhs);
    } else {
	return scalar_iter_bo_strict_ne(rhs,lhs);
    }
}

//////////////////////////////////////////////////////////////////////
//
// Begin operation support routines for :
// binary strictrel non-commutative operator>= I(int) I(int) int
//
int vec_vec_bo_operatorIAOPge(const IA_VectorDI<int> *lhs,const IA_VectorDI<int> *rhs)
{
    const IA_IntPointSet domain = lhs->domain();
    const unsigned sz = domain.card();
    int *const vec = new int[sz];

    {
	int *ds = vec;
	const int *ls = lhs->vec;
	const int *rs = rhs->vec;
	for (unsigned i=0; i<sz; i++) {
	    if (!( (*(ls++)) >= (*(rs++)) ))
		return 0;
	}
    }
    return 1;
}

#ifndef vec_scalar_int_int_int_operatorIAOPge
#define vec_scalar_int_int_int_operatorIAOPge
int vec_scalar_bo_operatorIAOPge(const IA_VectorDI<int> *lhs,int rhs)
{
    const IA_IntPointSet domain = lhs->domain();
    const unsigned sz = domain.card();
    int *const vec = new int[sz];

    {
	int *ds = vec;
	const int *ls = lhs->vec;
	for (unsigned i=0; i<sz; i++) {
	    if (!( (*(ls++)) >= (rhs) ))
		return 0;
	}
    }
    return 1;
}
#endif // vec_scalar_int_int_int_operatorIAOPge

int vec_iter_bo_operatorIAOPge(const IA_VectorDI<int> *lhs,IA_IntDiscreteImage rhs)
{
    const IA_IntPointSet domain = lhs->domain();
    const unsigned sz = domain.card();
    int *const vec = new int[sz];

    {
	int *ds = vec;
	const int *ls = lhs->vec;
	int rtmp;
	IA_DIVIter<int>	riter(rhs);
	for (unsigned i=0; i<sz; i++) {
	    riter(rtmp);
	    if (!( (*(ls++)) >= (rtmp) ))
		return 0;
	}
    }
    return 1;
}

#ifndef scalar_vec_int_int_int_operatorIAOPge
#define scalar_vec_int_int_int_operatorIAOPge
int scalar_vec_bo_operatorIAOPge(int lhs,const IA_VectorDI<int> *rhs)
{
    const IA_IntPointSet domain = rhs->domain();
    const unsigned sz = domain.card();
    int *const vec = new int[sz];

    {
	int *ds = vec;
	const int *rs = rhs->vec;
	for (unsigned i=0; i<sz; i++) {
	    if (!( (lhs) >= (*(rs++)) ))
		return 0;
	}
    }
    return 1;
}
#endif // scalar_vec_int_int_int_operatorIAOPge

// scalar-scalar operation is trivial

#ifndef scalar_iter_int_int_int_operatorIAOPge
#define scalar_iter_int_int_int_operatorIAOPge
int scalar_iter_bo_operatorIAOPge(int lhs,IA_IntDiscreteImage rhs)
{
    const IA_IntPointSet domain = rhs.domain();
    const unsigned sz = domain.card();
    int *const vec = new int[sz];

    {
	int *ds = vec;
	int rtmp;
	IA_DIVIter<int>	riter(rhs);
	for (unsigned i=0; i<sz; i++) {
	    riter(rtmp);
	    if (!( (lhs) >= (rtmp) ))
		return 0;
	}
    }
    return 1;
}
#endif // scalar_iter_int_int_int_operatorIAOPge

int iter_vec_bo_operatorIAOPge(IA_IntDiscreteImage lhs,const IA_VectorDI<int> *rhs)
{
    const IA_IntPointSet domain = lhs.domain();
    const unsigned sz = domain.card();
    int *const vec = new int[sz];

    {
	int *ds = vec;
	int ltmp;
	IA_DIVIter<int>	liter(lhs);
	const int *rs = rhs->vec;
	for (unsigned i=0; i<sz; i++) {
	    liter(ltmp);
	    if (!( (ltmp) >= (*(rs++)) ))
		return 0;
	}
    }
    return 1;
}

#ifndef iter_scalar_int_int_int_operatorIAOPge
#define iter_scalar_int_int_int_operatorIAOPge
int iter_scalar_bo_operatorIAOPge(IA_IntDiscreteImage lhs,int rhs)
{
    const IA_IntPointSet domain = lhs.domain();
    const unsigned sz = domain.card();
    int *const vec = new int[sz];

    {
	int *ds = vec;
	int ltmp;
	IA_DIVIter<int>	liter(lhs);
	for (unsigned i=0; i<sz; i++) {
	    liter(ltmp);
	    if (!( (ltmp) >= (rhs) ))
		return 0;
	}
    }
    return 1;
}
#endif // iter_scalar_int_int_int_operatorIAOPge

int iter_iter_bo_operatorIAOPge(IA_IntDiscreteImage lhs,IA_IntDiscreteImage rhs)
{
    const IA_IntPointSet domain = lhs.domain();
    const unsigned sz = domain.card();
    int *const vec = new int[sz];

    {
	int *ds = vec;
	int ltmp;
	IA_DIVIter<int>	liter(lhs);
	int rtmp;
	IA_DIVIter<int>	riter(rhs);
	for (unsigned i=0; i<sz; i++) {
	    liter(ltmp);
	    riter(rtmp);
	    if (!( (ltmp) >= (rtmp) ))
		return 0;
	}
    }
    return 1;
}

int operator>= ( const IA_IntDiscreteImage &lhs,
	      const IA_IntDiscreteImage &rhs)
{
    if (lhs.domain() != rhs.domain()) {
	static int	rval;
	ia_throw( IA::PSET_MISMATCH, __FILE__,__LINE__);
	return rval;
    }

    if (lhs.type() == IA_VectorDI<int>::s_type()) {
	if (rhs.type() == IA_VectorDI<int>::s_type()) {
	    return vec_vec_bo_operatorIAOPge((IA_VectorDI<int> *)lhs.bdip,(IA_VectorDI<int> *)rhs.bdip);
	} else if (rhs.type() == IA_ConstDI<int>::s_type()) {
	    return vec_scalar_bo_operatorIAOPge((IA_VectorDI<int> *)lhs.bdip,((IA_ConstDI<int> *)rhs.bdip)->value);
	} else {
	    return vec_iter_bo_operatorIAOPge((IA_VectorDI<int> *)lhs.bdip,rhs);
	}
    } else if (lhs.type() == IA_ConstDI<int>::s_type()) {
	if (rhs.type() == IA_VectorDI<int>::s_type()) {
	    return scalar_vec_bo_operatorIAOPge(((IA_ConstDI<int> *)lhs.bdip)->value,(IA_VectorDI<int> *)rhs.bdip);
	} else if (rhs.type() == IA_ConstDI<int>::s_type()) {
	    return (((IA_ConstDI<int> *)lhs.bdip)->value) >= (((IA_ConstDI<int> *)rhs.bdip)->value);
	} else {
	    return scalar_iter_bo_operatorIAOPge(((IA_ConstDI<int> *)lhs.bdip)->value,rhs);
	}
    } else {
	if (rhs.type() == IA_VectorDI<int>::s_type()) {
	    return iter_vec_bo_operatorIAOPge(lhs,(IA_VectorDI<int> *)rhs.bdip);
	} else if (rhs.type() == IA_ConstDI<int>::s_type()) {
	    return iter_scalar_bo_operatorIAOPge(lhs,((IA_ConstDI<int> *)rhs.bdip)->value);
	} else {
	    return iter_iter_bo_operatorIAOPge(lhs,rhs);
	}
    }
}

//////////////////////////////////////////////////////////////////////
//
// Begin operation support routines for :
// binary strictrel non-commutative operator>= I(int) int int
//
#ifndef vec_scalar_int_int_int_operatorIAOPge
#define vec_scalar_int_int_int_operatorIAOPge
int vec_scalar_bo_operatorIAOPge(const IA_VectorDI<int> *lhs,int rhs)
{
    const IA_IntPointSet domain = lhs->domain();
    const unsigned sz = domain.card();
    int *const vec = new int[sz];

    {
	int *ds = vec;
	const int *ls = lhs->vec;
	for (unsigned i=0; i<sz; i++) {
	    if (!( (*(ls++)) >= (rhs) ))
		return 0;
	}
    }
    return 1;
}
#endif // vec_scalar_int_int_int_operatorIAOPge

// scalar-scalar operation is trivial

#ifndef iter_scalar_int_int_int_operatorIAOPge
#define iter_scalar_int_int_int_operatorIAOPge
int iter_scalar_bo_operatorIAOPge(IA_IntDiscreteImage lhs,int rhs)
{
    const IA_IntPointSet domain = lhs.domain();
    const unsigned sz = domain.card();
    int *const vec = new int[sz];

    {
	int *ds = vec;
	int ltmp;
	IA_DIVIter<int>	liter(lhs);
	for (unsigned i=0; i<sz; i++) {
	    liter(ltmp);
	    if (!( (ltmp) >= (rhs) ))
		return 0;
	}
    }
    return 1;
}
#endif // iter_scalar_int_int_int_operatorIAOPge

int operator>= ( const IA_IntDiscreteImage &lhs, int rhs)
{
    if (lhs.type() == IA_VectorDI<int>::s_type()) {
	return vec_scalar_bo_operatorIAOPge((IA_VectorDI<int> *)lhs.bdip,rhs);
    } else if (lhs.type() == IA_ConstDI<int>::s_type()) {
	return (((IA_ConstDI<int> *)lhs.bdip)->value) >= (rhs);
    } else {
	return iter_scalar_bo_operatorIAOPge(lhs,rhs);
    }
}

//////////////////////////////////////////////////////////////////////
//
// Begin operation support routines for :
// binary strictrel non-commutative operator>= int I(int) int
//
#ifndef scalar_vec_int_int_int_operatorIAOPge
#define scalar_vec_int_int_int_operatorIAOPge
int scalar_vec_bo_operatorIAOPge(int lhs,const IA_VectorDI<int> *rhs)
{
    const IA_IntPointSet domain = rhs->domain();
    const unsigned sz = domain.card();
    int *const vec = new int[sz];

    {
	int *ds = vec;
	const int *rs = rhs->vec;
	for (unsigned i=0; i<sz; i++) {
	    if (!( (lhs) >= (*(rs++)) ))
		return 0;
	}
    }
    return 1;
}
#endif // scalar_vec_int_int_int_operatorIAOPge

// scalar-scalar operation is trivial

#ifndef scalar_iter_int_int_int_operatorIAOPge
#define scalar_iter_int_int_int_operatorIAOPge
int scalar_iter_bo_operatorIAOPge(int lhs,IA_IntDiscreteImage rhs)
{
    const IA_IntPointSet domain = rhs.domain();
    const unsigned sz = domain.card();
    int *const vec = new int[sz];

    {
	int *ds = vec;
	int rtmp;
	IA_DIVIter<int>	riter(rhs);
	for (unsigned i=0; i<sz; i++) {
	    riter(rtmp);
	    if (!( (lhs) >= (rtmp) ))
		return 0;
	}
    }
    return 1;
}
#endif // scalar_iter_int_int_int_operatorIAOPge

int operator>= (int lhs, const IA_IntDiscreteImage &rhs)
{
    if (rhs.type() == IA_VectorDI<int>::s_type()) {
	return scalar_vec_bo_operatorIAOPge(lhs,(IA_VectorDI<int> *)rhs.bdip);
    } else if (rhs.type() == IA_ConstDI<int>::s_type()) {
	return (lhs) >= (((IA_ConstDI<int> *)rhs.bdip)->value);
    } else {
	return scalar_iter_bo_operatorIAOPge(lhs,rhs);
    }
}

//////////////////////////////////////////////////////////////////////
//
// Begin operation support routines for :
// binary strictrel non-commutative operator> I(int) I(int) int
//
int vec_vec_bo_operatorIAOPgt(const IA_VectorDI<int> *lhs,const IA_VectorDI<int> *rhs)
{
    const IA_IntPointSet domain = lhs->domain();
    const unsigned sz = domain.card();
    int *const vec = new int[sz];

    {
	int *ds = vec;
	const int *ls = lhs->vec;
	const int *rs = rhs->vec;
	for (unsigned i=0; i<sz; i++) {
	    if (!( (*(ls++)) > (*(rs++)) ))
		return 0;
	}
    }
    return 1;
}

#ifndef vec_scalar_int_int_int_operatorIAOPgt
#define vec_scalar_int_int_int_operatorIAOPgt
int vec_scalar_bo_operatorIAOPgt(const IA_VectorDI<int> *lhs,int rhs)
{
    const IA_IntPointSet domain = lhs->domain();
    const unsigned sz = domain.card();
    int *const vec = new int[sz];

    {
	int *ds = vec;
	const int *ls = lhs->vec;
	for (unsigned i=0; i<sz; i++) {
	    if (!( (*(ls++)) > (rhs) ))
		return 0;
	}
    }
    return 1;
}
#endif // vec_scalar_int_int_int_operatorIAOPgt

int vec_iter_bo_operatorIAOPgt(const IA_VectorDI<int> *lhs,IA_IntDiscreteImage rhs)
{
    const IA_IntPointSet domain = lhs->domain();
    const unsigned sz = domain.card();
    int *const vec = new int[sz];

    {
	int *ds = vec;
	const int *ls = lhs->vec;
	int rtmp;
	IA_DIVIter<int>	riter(rhs);
	for (unsigned i=0; i<sz; i++) {
	    riter(rtmp);
	    if (!( (*(ls++)) > (rtmp) ))
		return 0;
	}
    }
    return 1;
}

#ifndef scalar_vec_int_int_int_operatorIAOPgt
#define scalar_vec_int_int_int_operatorIAOPgt
int scalar_vec_bo_operatorIAOPgt(int lhs,const IA_VectorDI<int> *rhs)
{
    const IA_IntPointSet domain = rhs->domain();
    const unsigned sz = domain.card();
    int *const vec = new int[sz];

    {
	int *ds = vec;
	const int *rs = rhs->vec;
	for (unsigned i=0; i<sz; i++) {
	    if (!( (lhs) > (*(rs++)) ))
		return 0;
	}
    }
    return 1;
}
#endif // scalar_vec_int_int_int_operatorIAOPgt

// scalar-scalar operation is trivial

#ifndef scalar_iter_int_int_int_operatorIAOPgt
#define scalar_iter_int_int_int_operatorIAOPgt
int scalar_iter_bo_operatorIAOPgt(int lhs,IA_IntDiscreteImage rhs)
{
    const IA_IntPointSet domain = rhs.domain();
    const unsigned sz = domain.card();
    int *const vec = new int[sz];

    {
	int *ds = vec;
	int rtmp;
	IA_DIVIter<int>	riter(rhs);
	for (unsigned i=0; i<sz; i++) {
	    riter(rtmp);
	    if (!( (lhs) > (rtmp) ))
		return 0;
	}
    }
    return 1;
}
#endif // scalar_iter_int_int_int_operatorIAOPgt

int iter_vec_bo_operatorIAOPgt(IA_IntDiscreteImage lhs,const IA_VectorDI<int> *rhs)
{
    const IA_IntPointSet domain = lhs.domain();
    const unsigned sz = domain.card();
    int *const vec = new int[sz];

    {
	int *ds = vec;
	int ltmp;
	IA_DIVIter<int>	liter(lhs);
	const int *rs = rhs->vec;
	for (unsigned i=0; i<sz; i++) {
	    liter(ltmp);
	    if (!( (ltmp) > (*(rs++)) ))
		return 0;
	}
    }
    return 1;
}

#ifndef iter_scalar_int_int_int_operatorIAOPgt
#define iter_scalar_int_int_int_operatorIAOPgt
int iter_scalar_bo_operatorIAOPgt(IA_IntDiscreteImage lhs,int rhs)
{
    const IA_IntPointSet domain = lhs.domain();
    const unsigned sz = domain.card();
    int *const vec = new int[sz];

    {
	int *ds = vec;
	int ltmp;
	IA_DIVIter<int>	liter(lhs);
	for (unsigned i=0; i<sz; i++) {
	    liter(ltmp);
	    if (!( (ltmp) > (rhs) ))
		return 0;
	}
    }
    return 1;
}
#endif // iter_scalar_int_int_int_operatorIAOPgt

int iter_iter_bo_operatorIAOPgt(IA_IntDiscreteImage lhs,IA_IntDiscreteImage rhs)
{
    const IA_IntPointSet domain = lhs.domain();
    const unsigned sz = domain.card();
    int *const vec = new int[sz];

    {
	int *ds = vec;
	int ltmp;
	IA_DIVIter<int>	liter(lhs);
	int rtmp;
	IA_DIVIter<int>	riter(rhs);
	for (unsigned i=0; i<sz; i++) {
	    liter(ltmp);
	    riter(rtmp);
	    if (!( (ltmp) > (rtmp) ))
		return 0;
	}
    }
    return 1;
}

int operator> ( const IA_IntDiscreteImage &lhs,
	      const IA_IntDiscreteImage &rhs)
{
    if (lhs.domain() != rhs.domain()) {
	static int	rval;
	ia_throw( IA::PSET_MISMATCH, __FILE__,__LINE__);
	return rval;
    }

    if (lhs.type() == IA_VectorDI<int>::s_type()) {
	if (rhs.type() == IA_VectorDI<int>::s_type()) {
	    return vec_vec_bo_operatorIAOPgt((IA_VectorDI<int> *)lhs.bdip,(IA_VectorDI<int> *)rhs.bdip);
	} else if (rhs.type() == IA_ConstDI<int>::s_type()) {
	    return vec_scalar_bo_operatorIAOPgt((IA_VectorDI<int> *)lhs.bdip,((IA_ConstDI<int> *)rhs.bdip)->value);
	} else {
	    return vec_iter_bo_operatorIAOPgt((IA_VectorDI<int> *)lhs.bdip,rhs);
	}
    } else if (lhs.type() == IA_ConstDI<int>::s_type()) {
	if (rhs.type() == IA_VectorDI<int>::s_type()) {
	    return scalar_vec_bo_operatorIAOPgt(((IA_ConstDI<int> *)lhs.bdip)->value,(IA_VectorDI<int> *)rhs.bdip);
	} else if (rhs.type() == IA_ConstDI<int>::s_type()) {
	    return (((IA_ConstDI<int> *)lhs.bdip)->value) > (((IA_ConstDI<int> *)rhs.bdip)->value);
	} else {
	    return scalar_iter_bo_operatorIAOPgt(((IA_ConstDI<int> *)lhs.bdip)->value,rhs);
	}
    } else {
	if (rhs.type() == IA_VectorDI<int>::s_type()) {
	    return iter_vec_bo_operatorIAOPgt(lhs,(IA_VectorDI<int> *)rhs.bdip);
	} else if (rhs.type() == IA_ConstDI<int>::s_type()) {
	    return iter_scalar_bo_operatorIAOPgt(lhs,((IA_ConstDI<int> *)rhs.bdip)->value);
	} else {
	    return iter_iter_bo_operatorIAOPgt(lhs,rhs);
	}
    }
}

//////////////////////////////////////////////////////////////////////
//
// Begin operation support routines for :
// binary strictrel non-commutative operator> I(int) int int
//
#ifndef vec_scalar_int_int_int_operatorIAOPgt
#define vec_scalar_int_int_int_operatorIAOPgt
int vec_scalar_bo_operatorIAOPgt(const IA_VectorDI<int> *lhs,int rhs)
{
    const IA_IntPointSet domain = lhs->domain();
    const unsigned sz = domain.card();
    int *const vec = new int[sz];

    {
	int *ds = vec;
	const int *ls = lhs->vec;
	for (unsigned i=0; i<sz; i++) {
	    if (!( (*(ls++)) > (rhs) ))
		return 0;
	}
    }
    return 1;
}
#endif // vec_scalar_int_int_int_operatorIAOPgt

// scalar-scalar operation is trivial

#ifndef iter_scalar_int_int_int_operatorIAOPgt
#define iter_scalar_int_int_int_operatorIAOPgt
int iter_scalar_bo_operatorIAOPgt(IA_IntDiscreteImage lhs,int rhs)
{
    const IA_IntPointSet domain = lhs.domain();
    const unsigned sz = domain.card();
    int *const vec = new int[sz];

    {
	int *ds = vec;
	int ltmp;
	IA_DIVIter<int>	liter(lhs);
	for (unsigned i=0; i<sz; i++) {
	    liter(ltmp);
	    if (!( (ltmp) > (rhs) ))
		return 0;
	}
    }
    return 1;
}
#endif // iter_scalar_int_int_int_operatorIAOPgt

int operator> ( const IA_IntDiscreteImage &lhs, int rhs)
{
    if (lhs.type() == IA_VectorDI<int>::s_type()) {
	return vec_scalar_bo_operatorIAOPgt((IA_VectorDI<int> *)lhs.bdip,rhs);
    } else if (lhs.type() == IA_ConstDI<int>::s_type()) {
	return (((IA_ConstDI<int> *)lhs.bdip)->value) > (rhs);
    } else {
	return iter_scalar_bo_operatorIAOPgt(lhs,rhs);
    }
}

//////////////////////////////////////////////////////////////////////
//
// Begin operation support routines for :
// binary strictrel non-commutative operator> int I(int) int
//
#ifndef scalar_vec_int_int_int_operatorIAOPgt
#define scalar_vec_int_int_int_operatorIAOPgt
int scalar_vec_bo_operatorIAOPgt(int lhs,const IA_VectorDI<int> *rhs)
{
    const IA_IntPointSet domain = rhs->domain();
    const unsigned sz = domain.card();
    int *const vec = new int[sz];

    {
	int *ds = vec;
	const int *rs = rhs->vec;
	for (unsigned i=0; i<sz; i++) {
	    if (!( (lhs) > (*(rs++)) ))
		return 0;
	}
    }
    return 1;
}
#endif // scalar_vec_int_int_int_operatorIAOPgt

// scalar-scalar operation is trivial

#ifndef scalar_iter_int_int_int_operatorIAOPgt
#define scalar_iter_int_int_int_operatorIAOPgt
int scalar_iter_bo_operatorIAOPgt(int lhs,IA_IntDiscreteImage rhs)
{
    const IA_IntPointSet domain = rhs.domain();
    const unsigned sz = domain.card();
    int *const vec = new int[sz];

    {
	int *ds = vec;
	int rtmp;
	IA_DIVIter<int>	riter(rhs);
	for (unsigned i=0; i<sz; i++) {
	    riter(rtmp);
	    if (!( (lhs) > (rtmp) ))
		return 0;
	}
    }
    return 1;
}
#endif // scalar_iter_int_int_int_operatorIAOPgt

int operator> (int lhs, const IA_IntDiscreteImage &rhs)
{
    if (rhs.type() == IA_VectorDI<int>::s_type()) {
	return scalar_vec_bo_operatorIAOPgt(lhs,(IA_VectorDI<int> *)rhs.bdip);
    } else if (rhs.type() == IA_ConstDI<int>::s_type()) {
	return (lhs) > (((IA_ConstDI<int> *)rhs.bdip)->value);
    } else {
	return scalar_iter_bo_operatorIAOPgt(lhs,rhs);
    }
}

//////////////////////////////////////////////////////////////////////
//
// Begin operation support routines for :
// binary pointwise non-commutative pwise_lt subop=operator< I(int) I(int) I(int)
//
static IA_IntDiscreteImage
vec_vec_bo_pwise_lt(const IA_VectorDI<int> *lhs,const IA_VectorDI<int> *rhs)
{
    const IA_IntPointSet domain = lhs->domain();
    const unsigned sz = domain.card();
    int *const vec = new int[sz];

    {
	int *ds = vec;
	const int *ls = lhs->vec;
	const int *rs = rhs->vec;
	for (unsigned i=0; i<sz; i++) {
	    *(ds++) = ( (*(ls++)) < (*(rs++)) );
	}
    }
    return IA_IntDiscreteImage(domain, vec, sz, 1);
}

#ifndef vec_scalar_int_int_int_pwise_lt
#define vec_scalar_int_int_int_pwise_lt
static IA_IntDiscreteImage
vec_scalar_bo_pwise_lt(const IA_VectorDI<int> *lhs,int rhs)
{
    const IA_IntPointSet domain = lhs->domain();
    const unsigned sz = domain.card();
    int *const vec = new int[sz];

    {
	int *ds = vec;
	const int *ls = lhs->vec;
	for (unsigned i=0; i<sz; i++) {
	    *(ds++) = ( (*(ls++)) < (rhs) );
	}
    }
    return IA_IntDiscreteImage(domain, vec, sz, 1);
}
#endif // vec_scalar_int_int_int_pwise_lt

static IA_IntDiscreteImage
vec_iter_bo_pwise_lt(const IA_VectorDI<int> *lhs,IA_IntDiscreteImage rhs)
{
    const IA_IntPointSet domain = lhs->domain();
    const unsigned sz = domain.card();
    int *const vec = new int[sz];

    {
	int *ds = vec;
	const int *ls = lhs->vec;
	int rtmp;
	IA_DIVIter<int>	riter(rhs);
	for (unsigned i=0; i<sz; i++) {
	    riter(rtmp);
	    *(ds++) = ( (*(ls++)) < (rtmp) );
	}
    }
    return IA_IntDiscreteImage(domain, vec, sz, 1);
}

#ifndef scalar_vec_int_int_int_pwise_lt
#define scalar_vec_int_int_int_pwise_lt
static IA_IntDiscreteImage
scalar_vec_bo_pwise_lt(int lhs,const IA_VectorDI<int> *rhs)
{
    const IA_IntPointSet domain = rhs->domain();
    const unsigned sz = domain.card();
    int *const vec = new int[sz];

    {
	int *ds = vec;
	const int *rs = rhs->vec;
	for (unsigned i=0; i<sz; i++) {
	    *(ds++) = ( (lhs) < (*(rs++)) );
	}
    }
    return IA_IntDiscreteImage(domain, vec, sz, 1);
}
#endif // scalar_vec_int_int_int_pwise_lt

// scalar-scalar operation is trivial

#ifndef scalar_iter_int_int_int_pwise_lt
#define scalar_iter_int_int_int_pwise_lt
static IA_IntDiscreteImage
scalar_iter_bo_pwise_lt(int lhs,IA_IntDiscreteImage rhs)
{
    const IA_IntPointSet domain = rhs.domain();
    const unsigned sz = domain.card();
    int *const vec = new int[sz];

    {
	int *ds = vec;
	int rtmp;
	IA_DIVIter<int>	riter(rhs);
	for (unsigned i=0; i<sz; i++) {
	    riter(rtmp);
	    *(ds++) = ( (lhs) < (rtmp) );
	}
    }
    return IA_IntDiscreteImage(domain, vec, sz, 1);
}
#endif // scalar_iter_int_int_int_pwise_lt

static IA_IntDiscreteImage
iter_vec_bo_pwise_lt(IA_IntDiscreteImage lhs,const IA_VectorDI<int> *rhs)
{
    const IA_IntPointSet domain = lhs.domain();
    const unsigned sz = domain.card();
    int *const vec = new int[sz];

    {
	int *ds = vec;
	int ltmp;
	IA_DIVIter<int>	liter(lhs);
	const int *rs = rhs->vec;
	for (unsigned i=0; i<sz; i++) {
	    liter(ltmp);
	    *(ds++) = ( (ltmp) < (*(rs++)) );
	}
    }
    return IA_IntDiscreteImage(domain, vec, sz, 1);
}

#ifndef iter_scalar_int_int_int_pwise_lt
#define iter_scalar_int_int_int_pwise_lt
static IA_IntDiscreteImage
iter_scalar_bo_pwise_lt(IA_IntDiscreteImage lhs,int rhs)
{
    const IA_IntPointSet domain = lhs.domain();
    const unsigned sz = domain.card();
    int *const vec = new int[sz];

    {
	int *ds = vec;
	int ltmp;
	IA_DIVIter<int>	liter(lhs);
	for (unsigned i=0; i<sz; i++) {
	    liter(ltmp);
	    *(ds++) = ( (ltmp) < (rhs) );
	}
    }
    return IA_IntDiscreteImage(domain, vec, sz, 1);
}
#endif // iter_scalar_int_int_int_pwise_lt

static IA_IntDiscreteImage
iter_iter_bo_pwise_lt(IA_IntDiscreteImage lhs,IA_IntDiscreteImage rhs)
{
    const IA_IntPointSet domain = lhs.domain();
    const unsigned sz = domain.card();
    int *const vec = new int[sz];

    {
	int *ds = vec;
	int ltmp;
	IA_DIVIter<int>	liter(lhs);
	int rtmp;
	IA_DIVIter<int>	riter(rhs);
	for (unsigned i=0; i<sz; i++) {
	    liter(ltmp);
	    riter(rtmp);
	    *(ds++) = ( (ltmp) < (rtmp) );
	}
    }
    return IA_IntDiscreteImage(domain, vec, sz, 1);
}

IA_IntDiscreteImage
pwise_lt ( const IA_IntDiscreteImage &lhs,
	      const IA_IntDiscreteImage &rhs)
{
    if (lhs.domain() != rhs.domain()) {
	static IA_IntDiscreteImage	rval;
	ia_throw( IA::PSET_MISMATCH, __FILE__,__LINE__);
	return rval;
    }

    if (lhs.type() == IA_VectorDI<int>::s_type()) {
	if (rhs.type() == IA_VectorDI<int>::s_type()) {
	    return vec_vec_bo_pwise_lt((IA_VectorDI<int> *)lhs.bdip,(IA_VectorDI<int> *)rhs.bdip);
	} else if (rhs.type() == IA_ConstDI<int>::s_type()) {
	    return vec_scalar_bo_pwise_lt((IA_VectorDI<int> *)lhs.bdip,((IA_ConstDI<int> *)rhs.bdip)->value);
	} else {
	    return vec_iter_bo_pwise_lt((IA_VectorDI<int> *)lhs.bdip,rhs);
	}
    } else if (lhs.type() == IA_ConstDI<int>::s_type()) {
	if (rhs.type() == IA_VectorDI<int>::s_type()) {
	    return scalar_vec_bo_pwise_lt(((IA_ConstDI<int> *)lhs.bdip)->value,(IA_VectorDI<int> *)rhs.bdip);
	} else if (rhs.type() == IA_ConstDI<int>::s_type()) {
	    return IA_IntDiscreteImage (lhs.domain(), (((IA_ConstDI<int> *)lhs.bdip)->value) < (((IA_ConstDI<int> *)rhs.bdip)->value));
	} else {
	    return scalar_iter_bo_pwise_lt(((IA_ConstDI<int> *)lhs.bdip)->value,rhs);
	}
    } else {
	if (rhs.type() == IA_VectorDI<int>::s_type()) {
	    return iter_vec_bo_pwise_lt(lhs,(IA_VectorDI<int> *)rhs.bdip);
	} else if (rhs.type() == IA_ConstDI<int>::s_type()) {
	    return iter_scalar_bo_pwise_lt(lhs,((IA_ConstDI<int> *)rhs.bdip)->value);
	} else {
	    return iter_iter_bo_pwise_lt(lhs,rhs);
	}
    }
}

//////////////////////////////////////////////////////////////////////
//
// Begin operation support routines for :
// binary pointwise non-commutative pwise_lt subop=operator< I(int) int I(int)
//
#ifndef vec_scalar_int_int_int_pwise_lt
#define vec_scalar_int_int_int_pwise_lt
static IA_IntDiscreteImage
vec_scalar_bo_pwise_lt(const IA_VectorDI<int> *lhs,int rhs)
{
    const IA_IntPointSet domain = lhs->domain();
    const unsigned sz = domain.card();
    int *const vec = new int[sz];

    {
	int *ds = vec;
	const int *ls = lhs->vec;
	for (unsigned i=0; i<sz; i++) {
	    *(ds++) = ( (*(ls++)) < (rhs) );
	}
    }
    return IA_IntDiscreteImage(domain, vec, sz, 1);
}
#endif // vec_scalar_int_int_int_pwise_lt

// scalar-scalar operation is trivial

#ifndef iter_scalar_int_int_int_pwise_lt
#define iter_scalar_int_int_int_pwise_lt
static IA_IntDiscreteImage
iter_scalar_bo_pwise_lt(IA_IntDiscreteImage lhs,int rhs)
{
    const IA_IntPointSet domain = lhs.domain();
    const unsigned sz = domain.card();
    int *const vec = new int[sz];

    {
	int *ds = vec;
	int ltmp;
	IA_DIVIter<int>	liter(lhs);
	for (unsigned i=0; i<sz; i++) {
	    liter(ltmp);
	    *(ds++) = ( (ltmp) < (rhs) );
	}
    }
    return IA_IntDiscreteImage(domain, vec, sz, 1);
}
#endif // iter_scalar_int_int_int_pwise_lt

IA_IntDiscreteImage
pwise_lt ( const IA_IntDiscreteImage &lhs, int rhs)
{
    if (lhs.type() == IA_VectorDI<int>::s_type()) {
	return vec_scalar_bo_pwise_lt((IA_VectorDI<int> *)lhs.bdip,rhs);
    } else if (lhs.type() == IA_ConstDI<int>::s_type()) {
	return IA_IntDiscreteImage (lhs.domain(), (((IA_ConstDI<int> *)lhs.bdip)->value) < (rhs));
    } else {
	return iter_scalar_bo_pwise_lt(lhs,rhs);
    }
}

//////////////////////////////////////////////////////////////////////
//
// Begin operation support routines for :
// binary pointwise non-commutative pwise_lt subop=operator< int I(int) I(int)
//
#ifndef scalar_vec_int_int_int_pwise_lt
#define scalar_vec_int_int_int_pwise_lt
static IA_IntDiscreteImage
scalar_vec_bo_pwise_lt(int lhs,const IA_VectorDI<int> *rhs)
{
    const IA_IntPointSet domain = rhs->domain();
    const unsigned sz = domain.card();
    int *const vec = new int[sz];

    {
	int *ds = vec;
	const int *rs = rhs->vec;
	for (unsigned i=0; i<sz; i++) {
	    *(ds++) = ( (lhs) < (*(rs++)) );
	}
    }
    return IA_IntDiscreteImage(domain, vec, sz, 1);
}
#endif // scalar_vec_int_int_int_pwise_lt

// scalar-scalar operation is trivial

#ifndef scalar_iter_int_int_int_pwise_lt
#define scalar_iter_int_int_int_pwise_lt
static IA_IntDiscreteImage
scalar_iter_bo_pwise_lt(int lhs,IA_IntDiscreteImage rhs)
{
    const IA_IntPointSet domain = rhs.domain();
    const unsigned sz = domain.card();
    int *const vec = new int[sz];

    {
	int *ds = vec;
	int rtmp;
	IA_DIVIter<int>	riter(rhs);
	for (unsigned i=0; i<sz; i++) {
	    riter(rtmp);
	    *(ds++) = ( (lhs) < (rtmp) );
	}
    }
    return IA_IntDiscreteImage(domain, vec, sz, 1);
}
#endif // scalar_iter_int_int_int_pwise_lt

IA_IntDiscreteImage
pwise_lt (int lhs, const IA_IntDiscreteImage &rhs)
{
    if (rhs.type() == IA_VectorDI<int>::s_type()) {
	return scalar_vec_bo_pwise_lt(lhs,(IA_VectorDI<int> *)rhs.bdip);
    } else if (rhs.type() == IA_ConstDI<int>::s_type()) {
	return IA_IntDiscreteImage (rhs.domain(), (lhs) < (((IA_ConstDI<int> *)rhs.bdip)->value));
    } else {
	return scalar_iter_bo_pwise_lt(lhs,rhs);
    }
}

//////////////////////////////////////////////////////////////////////
//
// Begin operation support routines for :
// binary pointwise non-commutative pwise_le subop=operator<= I(int) I(int) I(int)
//
static IA_IntDiscreteImage
vec_vec_bo_pwise_le(const IA_VectorDI<int> *lhs,const IA_VectorDI<int> *rhs)
{
    const IA_IntPointSet domain = lhs->domain();
    const unsigned sz = domain.card();
    int *const vec = new int[sz];

    {
	int *ds = vec;
	const int *ls = lhs->vec;
	const int *rs = rhs->vec;
	for (unsigned i=0; i<sz; i++) {
	    *(ds++) = ( (*(ls++)) <= (*(rs++)) );
	}
    }
    return IA_IntDiscreteImage(domain, vec, sz, 1);
}

#ifndef vec_scalar_int_int_int_pwise_le
#define vec_scalar_int_int_int_pwise_le
static IA_IntDiscreteImage
vec_scalar_bo_pwise_le(const IA_VectorDI<int> *lhs,int rhs)
{
    const IA_IntPointSet domain = lhs->domain();
    const unsigned sz = domain.card();
    int *const vec = new int[sz];

    {
	int *ds = vec;
	const int *ls = lhs->vec;
	for (unsigned i=0; i<sz; i++) {
	    *(ds++) = ( (*(ls++)) <= (rhs) );
	}
    }
    return IA_IntDiscreteImage(domain, vec, sz, 1);
}
#endif // vec_scalar_int_int_int_pwise_le

static IA_IntDiscreteImage
vec_iter_bo_pwise_le(const IA_VectorDI<int> *lhs,IA_IntDiscreteImage rhs)
{
    const IA_IntPointSet domain = lhs->domain();
    const unsigned sz = domain.card();
    int *const vec = new int[sz];

    {
	int *ds = vec;
	const int *ls = lhs->vec;
	int rtmp;
	IA_DIVIter<int>	riter(rhs);
	for (unsigned i=0; i<sz; i++) {
	    riter(rtmp);
	    *(ds++) = ( (*(ls++)) <= (rtmp) );
	}
    }
    return IA_IntDiscreteImage(domain, vec, sz, 1);
}

#ifndef scalar_vec_int_int_int_pwise_le
#define scalar_vec_int_int_int_pwise_le
static IA_IntDiscreteImage
scalar_vec_bo_pwise_le(int lhs,const IA_VectorDI<int> *rhs)
{
    const IA_IntPointSet domain = rhs->domain();
    const unsigned sz = domain.card();
    int *const vec = new int[sz];

    {
	int *ds = vec;
	const int *rs = rhs->vec;
	for (unsigned i=0; i<sz; i++) {
	    *(ds++) = ( (lhs) <= (*(rs++)) );
	}
    }
    return IA_IntDiscreteImage(domain, vec, sz, 1);
}
#endif // scalar_vec_int_int_int_pwise_le

// scalar-scalar operation is trivial

#ifndef scalar_iter_int_int_int_pwise_le
#define scalar_iter_int_int_int_pwise_le
static IA_IntDiscreteImage
scalar_iter_bo_pwise_le(int lhs,IA_IntDiscreteImage rhs)
{
    const IA_IntPointSet domain = rhs.domain();
    const unsigned sz = domain.card();
    int *const vec = new int[sz];

    {
	int *ds = vec;
	int rtmp;
	IA_DIVIter<int>	riter(rhs);
	for (unsigned i=0; i<sz; i++) {
	    riter(rtmp);
	    *(ds++) = ( (lhs) <= (rtmp) );
	}
    }
    return IA_IntDiscreteImage(domain, vec, sz, 1);
}
#endif // scalar_iter_int_int_int_pwise_le

static IA_IntDiscreteImage
iter_vec_bo_pwise_le(IA_IntDiscreteImage lhs,const IA_VectorDI<int> *rhs)
{
    const IA_IntPointSet domain = lhs.domain();
    const unsigned sz = domain.card();
    int *const vec = new int[sz];

    {
	int *ds = vec;
	int ltmp;
	IA_DIVIter<int>	liter(lhs);
	const int *rs = rhs->vec;
	for (unsigned i=0; i<sz; i++) {
	    liter(ltmp);
	    *(ds++) = ( (ltmp) <= (*(rs++)) );
	}
    }
    return IA_IntDiscreteImage(domain, vec, sz, 1);
}

#ifndef iter_scalar_int_int_int_pwise_le
#define iter_scalar_int_int_int_pwise_le
static IA_IntDiscreteImage
iter_scalar_bo_pwise_le(IA_IntDiscreteImage lhs,int rhs)
{
    const IA_IntPointSet domain = lhs.domain();
    const unsigned sz = domain.card();
    int *const vec = new int[sz];

    {
	int *ds = vec;
	int ltmp;
	IA_DIVIter<int>	liter(lhs);
	for (unsigned i=0; i<sz; i++) {
	    liter(ltmp);
	    *(ds++) = ( (ltmp) <= (rhs) );
	}
    }
    return IA_IntDiscreteImage(domain, vec, sz, 1);
}
#endif // iter_scalar_int_int_int_pwise_le

static IA_IntDiscreteImage
iter_iter_bo_pwise_le(IA_IntDiscreteImage lhs,IA_IntDiscreteImage rhs)
{
    const IA_IntPointSet domain = lhs.domain();
    const unsigned sz = domain.card();
    int *const vec = new int[sz];

    {
	int *ds = vec;
	int ltmp;
	IA_DIVIter<int>	liter(lhs);
	int rtmp;
	IA_DIVIter<int>	riter(rhs);
	for (unsigned i=0; i<sz; i++) {
	    liter(ltmp);
	    riter(rtmp);
	    *(ds++) = ( (ltmp) <= (rtmp) );
	}
    }
    return IA_IntDiscreteImage(domain, vec, sz, 1);
}

IA_IntDiscreteImage
pwise_le ( const IA_IntDiscreteImage &lhs,
	      const IA_IntDiscreteImage &rhs)
{
    if (lhs.domain() != rhs.domain()) {
	static IA_IntDiscreteImage	rval;
	ia_throw( IA::PSET_MISMATCH, __FILE__,__LINE__);
	return rval;
    }

    if (lhs.type() == IA_VectorDI<int>::s_type()) {
	if (rhs.type() == IA_VectorDI<int>::s_type()) {
	    return vec_vec_bo_pwise_le((IA_VectorDI<int> *)lhs.bdip,(IA_VectorDI<int> *)rhs.bdip);
	} else if (rhs.type() == IA_ConstDI<int>::s_type()) {
	    return vec_scalar_bo_pwise_le((IA_VectorDI<int> *)lhs.bdip,((IA_ConstDI<int> *)rhs.bdip)->value);
	} else {
	    return vec_iter_bo_pwise_le((IA_VectorDI<int> *)lhs.bdip,rhs);
	}
    } else if (lhs.type() == IA_ConstDI<int>::s_type()) {
	if (rhs.type() == IA_VectorDI<int>::s_type()) {
	    return scalar_vec_bo_pwise_le(((IA_ConstDI<int> *)lhs.bdip)->value,(IA_VectorDI<int> *)rhs.bdip);
	} else if (rhs.type() == IA_ConstDI<int>::s_type()) {
	    return IA_IntDiscreteImage (lhs.domain(), (((IA_ConstDI<int> *)lhs.bdip)->value) <= (((IA_ConstDI<int> *)rhs.bdip)->value));
	} else {
	    return scalar_iter_bo_pwise_le(((IA_ConstDI<int> *)lhs.bdip)->value,rhs);
	}
    } else {
	if (rhs.type() == IA_VectorDI<int>::s_type()) {
	    return iter_vec_bo_pwise_le(lhs,(IA_VectorDI<int> *)rhs.bdip);
	} else if (rhs.type() == IA_ConstDI<int>::s_type()) {
	    return iter_scalar_bo_pwise_le(lhs,((IA_ConstDI<int> *)rhs.bdip)->value);
	} else {
	    return iter_iter_bo_pwise_le(lhs,rhs);
	}
    }
}

//////////////////////////////////////////////////////////////////////
//
// Begin operation support routines for :
// binary pointwise non-commutative pwise_le subop=operator<= I(int) int I(int)
//
#ifndef vec_scalar_int_int_int_pwise_le
#define vec_scalar_int_int_int_pwise_le
static IA_IntDiscreteImage
vec_scalar_bo_pwise_le(const IA_VectorDI<int> *lhs,int rhs)
{
    const IA_IntPointSet domain = lhs->domain();
    const unsigned sz = domain.card();
    int *const vec = new int[sz];

    {
	int *ds = vec;
	const int *ls = lhs->vec;
	for (unsigned i=0; i<sz; i++) {
	    *(ds++) = ( (*(ls++)) <= (rhs) );
	}
    }
    return IA_IntDiscreteImage(domain, vec, sz, 1);
}
#endif // vec_scalar_int_int_int_pwise_le

// scalar-scalar operation is trivial

#ifndef iter_scalar_int_int_int_pwise_le
#define iter_scalar_int_int_int_pwise_le
static IA_IntDiscreteImage
iter_scalar_bo_pwise_le(IA_IntDiscreteImage lhs,int rhs)
{
    const IA_IntPointSet domain = lhs.domain();
    const unsigned sz = domain.card();
    int *const vec = new int[sz];

    {
	int *ds = vec;
	int ltmp;
	IA_DIVIter<int>	liter(lhs);
	for (unsigned i=0; i<sz; i++) {
	    liter(ltmp);
	    *(ds++) = ( (ltmp) <= (rhs) );
	}
    }
    return IA_IntDiscreteImage(domain, vec, sz, 1);
}
#endif // iter_scalar_int_int_int_pwise_le

IA_IntDiscreteImage
pwise_le ( const IA_IntDiscreteImage &lhs, int rhs)
{
    if (lhs.type() == IA_VectorDI<int>::s_type()) {
	return vec_scalar_bo_pwise_le((IA_VectorDI<int> *)lhs.bdip,rhs);
    } else if (lhs.type() == IA_ConstDI<int>::s_type()) {
	return IA_IntDiscreteImage (lhs.domain(), (((IA_ConstDI<int> *)lhs.bdip)->value) <= (rhs));
    } else {
	return iter_scalar_bo_pwise_le(lhs,rhs);
    }
}

//////////////////////////////////////////////////////////////////////
//
// Begin operation support routines for :
// binary pointwise non-commutative pwise_le subop=operator<= int I(int) I(int)
//
#ifndef scalar_vec_int_int_int_pwise_le
#define scalar_vec_int_int_int_pwise_le
static IA_IntDiscreteImage
scalar_vec_bo_pwise_le(int lhs,const IA_VectorDI<int> *rhs)
{
    const IA_IntPointSet domain = rhs->domain();
    const unsigned sz = domain.card();
    int *const vec = new int[sz];

    {
	int *ds = vec;
	const int *rs = rhs->vec;
	for (unsigned i=0; i<sz; i++) {
	    *(ds++) = ( (lhs) <= (*(rs++)) );
	}
    }
    return IA_IntDiscreteImage(domain, vec, sz, 1);
}
#endif // scalar_vec_int_int_int_pwise_le

// scalar-scalar operation is trivial

#ifndef scalar_iter_int_int_int_pwise_le
#define scalar_iter_int_int_int_pwise_le
static IA_IntDiscreteImage
scalar_iter_bo_pwise_le(int lhs,IA_IntDiscreteImage rhs)
{
    const IA_IntPointSet domain = rhs.domain();
    const unsigned sz = domain.card();
    int *const vec = new int[sz];

    {
	int *ds = vec;
	int rtmp;
	IA_DIVIter<int>	riter(rhs);
	for (unsigned i=0; i<sz; i++) {
	    riter(rtmp);
	    *(ds++) = ( (lhs) <= (rtmp) );
	}
    }
    return IA_IntDiscreteImage(domain, vec, sz, 1);
}
#endif // scalar_iter_int_int_int_pwise_le

IA_IntDiscreteImage
pwise_le (int lhs, const IA_IntDiscreteImage &rhs)
{
    if (rhs.type() == IA_VectorDI<int>::s_type()) {
	return scalar_vec_bo_pwise_le(lhs,(IA_VectorDI<int> *)rhs.bdip);
    } else if (rhs.type() == IA_ConstDI<int>::s_type()) {
	return IA_IntDiscreteImage (rhs.domain(), (lhs) <= (((IA_ConstDI<int> *)rhs.bdip)->value));
    } else {
	return scalar_iter_bo_pwise_le(lhs,rhs);
    }
}

//////////////////////////////////////////////////////////////////////
//
// Begin operation support routines for :
// binary pointwise commutative pwise_eq subop=operator== I(int) I(int) I(int)
//
static IA_IntDiscreteImage
vec_vec_bo_pwise_eq(const IA_VectorDI<int> *lhs,const IA_VectorDI<int> *rhs)
{
    const IA_IntPointSet domain = lhs->domain();
    const unsigned sz = domain.card();
    int *const vec = new int[sz];

    {
	int *ds = vec;
	const int *ls = lhs->vec;
	const int *rs = rhs->vec;
	for (unsigned i=0; i<sz; i++) {
	    *(ds++) = ( (*(ls++)) == (*(rs++)) );
	}
    }
    return IA_IntDiscreteImage(domain, vec, sz, 1);
}

#ifndef vec_scalar_int_int_int_pwise_eq
#define vec_scalar_int_int_int_pwise_eq
static IA_IntDiscreteImage
vec_scalar_bo_pwise_eq(const IA_VectorDI<int> *lhs,int rhs)
{
    const IA_IntPointSet domain = lhs->domain();
    const unsigned sz = domain.card();
    int *const vec = new int[sz];

    {
	int *ds = vec;
	const int *ls = lhs->vec;
	for (unsigned i=0; i<sz; i++) {
	    *(ds++) = ( (*(ls++)) == (rhs) );
	}
    }
    return IA_IntDiscreteImage(domain, vec, sz, 1);
}
#endif // vec_scalar_int_int_int_pwise_eq

static IA_IntDiscreteImage
vec_iter_bo_pwise_eq(const IA_VectorDI<int> *lhs,IA_IntDiscreteImage rhs)
{
    const IA_IntPointSet domain = lhs->domain();
    const unsigned sz = domain.card();
    int *const vec = new int[sz];

    {
	int *ds = vec;
	const int *ls = lhs->vec;
	int rtmp;
	IA_DIVIter<int>	riter(rhs);
	for (unsigned i=0; i<sz; i++) {
	    riter(rtmp);
	    *(ds++) = ( (*(ls++)) == (rtmp) );
	}
    }
    return IA_IntDiscreteImage(domain, vec, sz, 1);
}

// scalar-scalar operation is trivial

#ifndef scalar_iter_int_int_int_pwise_eq
#define scalar_iter_int_int_int_pwise_eq
static IA_IntDiscreteImage
scalar_iter_bo_pwise_eq(int lhs,IA_IntDiscreteImage rhs)
{
    const IA_IntPointSet domain = rhs.domain();
    const unsigned sz = domain.card();
    int *const vec = new int[sz];

    {
	int *ds = vec;
	int rtmp;
	IA_DIVIter<int>	riter(rhs);
	for (unsigned i=0; i<sz; i++) {
	    riter(rtmp);
	    *(ds++) = ( (lhs) == (rtmp) );
	}
    }
    return IA_IntDiscreteImage(domain, vec, sz, 1);
}
#endif // scalar_iter_int_int_int_pwise_eq

static IA_IntDiscreteImage
iter_iter_bo_pwise_eq(IA_IntDiscreteImage lhs,IA_IntDiscreteImage rhs)
{
    const IA_IntPointSet domain = lhs.domain();
    const unsigned sz = domain.card();
    int *const vec = new int[sz];

    {
	int *ds = vec;
	int ltmp;
	IA_DIVIter<int>	liter(lhs);
	int rtmp;
	IA_DIVIter<int>	riter(rhs);
	for (unsigned i=0; i<sz; i++) {
	    liter(ltmp);
	    riter(rtmp);
	    *(ds++) = ( (ltmp) == (rtmp) );
	}
    }
    return IA_IntDiscreteImage(domain, vec, sz, 1);
}

IA_IntDiscreteImage
pwise_eq ( const IA_IntDiscreteImage &lhs,
	      const IA_IntDiscreteImage &rhs)
{
    if (lhs.domain() != rhs.domain()) {
	static IA_IntDiscreteImage	rval;
	ia_throw( IA::PSET_MISMATCH, __FILE__,__LINE__);
	return rval;
    }

    if (lhs.type() == IA_VectorDI<int>::s_type()) {
	if (rhs.type() == IA_VectorDI<int>::s_type()) {
	    return vec_vec_bo_pwise_eq((IA_VectorDI<int> *)lhs.bdip,(IA_VectorDI<int> *)rhs.bdip);
	} else if (rhs.type() == IA_ConstDI<int>::s_type()) {
	    return vec_scalar_bo_pwise_eq((IA_VectorDI<int> *)lhs.bdip,((IA_ConstDI<int> *)rhs.bdip)->value);
	} else {
	    return vec_iter_bo_pwise_eq((IA_VectorDI<int> *)lhs.bdip,rhs);
	}
    } else if (lhs.type() == IA_ConstDI<int>::s_type()) {
	if (rhs.type() == IA_VectorDI<int>::s_type()) {
	    return vec_scalar_bo_pwise_eq((IA_VectorDI<int> *)rhs.bdip,((IA_ConstDI<int> *)lhs.bdip)->value);
	} else if (rhs.type() == IA_ConstDI<int>::s_type()) {
	    return IA_IntDiscreteImage (lhs.domain(), (((IA_ConstDI<int> *)lhs.bdip)->value) == (((IA_ConstDI<int> *)rhs.bdip)->value));
	} else {
	    return scalar_iter_bo_pwise_eq(((IA_ConstDI<int> *)lhs.bdip)->value,rhs);
	}
    } else {
	if (rhs.type() == IA_VectorDI<int>::s_type()) {
	    return vec_iter_bo_pwise_eq((IA_VectorDI<int> *)rhs.bdip,lhs);
	} else if (rhs.type() == IA_ConstDI<int>::s_type()) {
	    return scalar_iter_bo_pwise_eq(((IA_ConstDI<int> *)rhs.bdip)->value,lhs);
	} else {
	    return iter_iter_bo_pwise_eq(lhs,rhs);
	}
    }
}

//////////////////////////////////////////////////////////////////////
//
// Begin operation support routines for :
// binary pointwise commutative pwise_eq subop=operator== I(int) int I(int)
//
#ifndef vec_scalar_int_int_int_pwise_eq
#define vec_scalar_int_int_int_pwise_eq
static IA_IntDiscreteImage
vec_scalar_bo_pwise_eq(const IA_VectorDI<int> *lhs,int rhs)
{
    const IA_IntPointSet domain = lhs->domain();
    const unsigned sz = domain.card();
    int *const vec = new int[sz];

    {
	int *ds = vec;
	const int *ls = lhs->vec;
	for (unsigned i=0; i<sz; i++) {
	    *(ds++) = ( (*(ls++)) == (rhs) );
	}
    }
    return IA_IntDiscreteImage(domain, vec, sz, 1);
}
#endif // vec_scalar_int_int_int_pwise_eq

// scalar-scalar operation is trivial

#ifndef scalar_iter_int_int_int_pwise_eq
#define scalar_iter_int_int_int_pwise_eq
static IA_IntDiscreteImage
scalar_iter_bo_pwise_eq(int lhs,IA_IntDiscreteImage rhs)
{
    const IA_IntPointSet domain = rhs.domain();
    const unsigned sz = domain.card();
    int *const vec = new int[sz];

    {
	int *ds = vec;
	int rtmp;
	IA_DIVIter<int>	riter(rhs);
	for (unsigned i=0; i<sz; i++) {
	    riter(rtmp);
	    *(ds++) = ( (lhs) == (rtmp) );
	}
    }
    return IA_IntDiscreteImage(domain, vec, sz, 1);
}
#endif // scalar_iter_int_int_int_pwise_eq

IA_IntDiscreteImage
pwise_eq ( const IA_IntDiscreteImage &lhs, int rhs)
{
    if (lhs.type() == IA_VectorDI<int>::s_type()) {
	return vec_scalar_bo_pwise_eq((IA_VectorDI<int> *)lhs.bdip,rhs);
    } else if (lhs.type() == IA_ConstDI<int>::s_type()) {
	return IA_IntDiscreteImage (lhs.domain(), (((IA_ConstDI<int> *)lhs.bdip)->value) == (rhs));
    } else {
	return scalar_iter_bo_pwise_eq(rhs,lhs);
    }
}

//////////////////////////////////////////////////////////////////////
//
// Begin operation support routines for :
// binary pointwise commutative pwise_ne subop=operator!= I(int) I(int) I(int)
//
static IA_IntDiscreteImage
vec_vec_bo_pwise_ne(const IA_VectorDI<int> *lhs,const IA_VectorDI<int> *rhs)
{
    const IA_IntPointSet domain = lhs->domain();
    const unsigned sz = domain.card();
    int *const vec = new int[sz];

    {
	int *ds = vec;
	const int *ls = lhs->vec;
	const int *rs = rhs->vec;
	for (unsigned i=0; i<sz; i++) {
	    *(ds++) = ( (*(ls++)) != (*(rs++)) );
	}
    }
    return IA_IntDiscreteImage(domain, vec, sz, 1);
}

#ifndef vec_scalar_int_int_int_pwise_ne
#define vec_scalar_int_int_int_pwise_ne
static IA_IntDiscreteImage
vec_scalar_bo_pwise_ne(const IA_VectorDI<int> *lhs,int rhs)
{
    const IA_IntPointSet domain = lhs->domain();
    const unsigned sz = domain.card();
    int *const vec = new int[sz];

    {
	int *ds = vec;
	const int *ls = lhs->vec;
	for (unsigned i=0; i<sz; i++) {
	    *(ds++) = ( (*(ls++)) != (rhs) );
	}
    }
    return IA_IntDiscreteImage(domain, vec, sz, 1);
}
#endif // vec_scalar_int_int_int_pwise_ne

static IA_IntDiscreteImage
vec_iter_bo_pwise_ne(const IA_VectorDI<int> *lhs,IA_IntDiscreteImage rhs)
{
    const IA_IntPointSet domain = lhs->domain();
    const unsigned sz = domain.card();
    int *const vec = new int[sz];

    {
	int *ds = vec;
	const int *ls = lhs->vec;
	int rtmp;
	IA_DIVIter<int>	riter(rhs);
	for (unsigned i=0; i<sz; i++) {
	    riter(rtmp);
	    *(ds++) = ( (*(ls++)) != (rtmp) );
	}
    }
    return IA_IntDiscreteImage(domain, vec, sz, 1);
}

// scalar-scalar operation is trivial

#ifndef scalar_iter_int_int_int_pwise_ne
#define scalar_iter_int_int_int_pwise_ne
static IA_IntDiscreteImage
scalar_iter_bo_pwise_ne(int lhs,IA_IntDiscreteImage rhs)
{
    const IA_IntPointSet domain = rhs.domain();
    const unsigned sz = domain.card();
    int *const vec = new int[sz];

    {
	int *ds = vec;
	int rtmp;
	IA_DIVIter<int>	riter(rhs);
	for (unsigned i=0; i<sz; i++) {
	    riter(rtmp);
	    *(ds++) = ( (lhs) != (rtmp) );
	}
    }
    return IA_IntDiscreteImage(domain, vec, sz, 1);
}
#endif // scalar_iter_int_int_int_pwise_ne

static IA_IntDiscreteImage
iter_iter_bo_pwise_ne(IA_IntDiscreteImage lhs,IA_IntDiscreteImage rhs)
{
    const IA_IntPointSet domain = lhs.domain();
    const unsigned sz = domain.card();
    int *const vec = new int[sz];

    {
	int *ds = vec;
	int ltmp;
	IA_DIVIter<int>	liter(lhs);
	int rtmp;
	IA_DIVIter<int>	riter(rhs);
	for (unsigned i=0; i<sz; i++) {
	    liter(ltmp);
	    riter(rtmp);
	    *(ds++) = ( (ltmp) != (rtmp) );
	}
    }
    return IA_IntDiscreteImage(domain, vec, sz, 1);
}

IA_IntDiscreteImage
pwise_ne ( const IA_IntDiscreteImage &lhs,
	      const IA_IntDiscreteImage &rhs)
{
    if (lhs.domain() != rhs.domain()) {
	static IA_IntDiscreteImage	rval;
	ia_throw( IA::PSET_MISMATCH, __FILE__,__LINE__);
	return rval;
    }

    if (lhs.type() == IA_VectorDI<int>::s_type()) {
	if (rhs.type() == IA_VectorDI<int>::s_type()) {
	    return vec_vec_bo_pwise_ne((IA_VectorDI<int> *)lhs.bdip,(IA_VectorDI<int> *)rhs.bdip);
	} else if (rhs.type() == IA_ConstDI<int>::s_type()) {
	    return vec_scalar_bo_pwise_ne((IA_VectorDI<int> *)lhs.bdip,((IA_ConstDI<int> *)rhs.bdip)->value);
	} else {
	    return vec_iter_bo_pwise_ne((IA_VectorDI<int> *)lhs.bdip,rhs);
	}
    } else if (lhs.type() == IA_ConstDI<int>::s_type()) {
	if (rhs.type() == IA_VectorDI<int>::s_type()) {
	    return vec_scalar_bo_pwise_ne((IA_VectorDI<int> *)rhs.bdip,((IA_ConstDI<int> *)lhs.bdip)->value);
	} else if (rhs.type() == IA_ConstDI<int>::s_type()) {
	    return IA_IntDiscreteImage (lhs.domain(), (((IA_ConstDI<int> *)lhs.bdip)->value) != (((IA_ConstDI<int> *)rhs.bdip)->value));
	} else {
	    return scalar_iter_bo_pwise_ne(((IA_ConstDI<int> *)lhs.bdip)->value,rhs);
	}
    } else {
	if (rhs.type() == IA_VectorDI<int>::s_type()) {
	    return vec_iter_bo_pwise_ne((IA_VectorDI<int> *)rhs.bdip,lhs);
	} else if (rhs.type() == IA_ConstDI<int>::s_type()) {
	    return scalar_iter_bo_pwise_ne(((IA_ConstDI<int> *)rhs.bdip)->value,lhs);
	} else {
	    return iter_iter_bo_pwise_ne(lhs,rhs);
	}
    }
}

//////////////////////////////////////////////////////////////////////
//
// Begin operation support routines for :
// binary pointwise commutative pwise_ne subop=operator!= I(int) int I(int)
//
#ifndef vec_scalar_int_int_int_pwise_ne
#define vec_scalar_int_int_int_pwise_ne
static IA_IntDiscreteImage
vec_scalar_bo_pwise_ne(const IA_VectorDI<int> *lhs,int rhs)
{
    const IA_IntPointSet domain = lhs->domain();
    const unsigned sz = domain.card();
    int *const vec = new int[sz];

    {
	int *ds = vec;
	const int *ls = lhs->vec;
	for (unsigned i=0; i<sz; i++) {
	    *(ds++) = ( (*(ls++)) != (rhs) );
	}
    }
    return IA_IntDiscreteImage(domain, vec, sz, 1);
}
#endif // vec_scalar_int_int_int_pwise_ne

// scalar-scalar operation is trivial

#ifndef scalar_iter_int_int_int_pwise_ne
#define scalar_iter_int_int_int_pwise_ne
static IA_IntDiscreteImage
scalar_iter_bo_pwise_ne(int lhs,IA_IntDiscreteImage rhs)
{
    const IA_IntPointSet domain = rhs.domain();
    const unsigned sz = domain.card();
    int *const vec = new int[sz];

    {
	int *ds = vec;
	int rtmp;
	IA_DIVIter<int>	riter(rhs);
	for (unsigned i=0; i<sz; i++) {
	    riter(rtmp);
	    *(ds++) = ( (lhs) != (rtmp) );
	}
    }
    return IA_IntDiscreteImage(domain, vec, sz, 1);
}
#endif // scalar_iter_int_int_int_pwise_ne

IA_IntDiscreteImage
pwise_ne ( const IA_IntDiscreteImage &lhs, int rhs)
{
    if (lhs.type() == IA_VectorDI<int>::s_type()) {
	return vec_scalar_bo_pwise_ne((IA_VectorDI<int> *)lhs.bdip,rhs);
    } else if (lhs.type() == IA_ConstDI<int>::s_type()) {
	return IA_IntDiscreteImage (lhs.domain(), (((IA_ConstDI<int> *)lhs.bdip)->value) != (rhs));
    } else {
	return scalar_iter_bo_pwise_ne(rhs,lhs);
    }
}

//////////////////////////////////////////////////////////////////////
//
// Begin operation support routines for :
// binary pointwise non-commutative pwise_ge subop=operator>= I(int) I(int) I(int)
//
static IA_IntDiscreteImage
vec_vec_bo_pwise_ge(const IA_VectorDI<int> *lhs,const IA_VectorDI<int> *rhs)
{
    const IA_IntPointSet domain = lhs->domain();
    const unsigned sz = domain.card();
    int *const vec = new int[sz];

    {
	int *ds = vec;
	const int *ls = lhs->vec;
	const int *rs = rhs->vec;
	for (unsigned i=0; i<sz; i++) {
	    *(ds++) = ( (*(ls++)) >= (*(rs++)) );
	}
    }
    return IA_IntDiscreteImage(domain, vec, sz, 1);
}

#ifndef vec_scalar_int_int_int_pwise_ge
#define vec_scalar_int_int_int_pwise_ge
static IA_IntDiscreteImage
vec_scalar_bo_pwise_ge(const IA_VectorDI<int> *lhs,int rhs)
{
    const IA_IntPointSet domain = lhs->domain();
    const unsigned sz = domain.card();
    int *const vec = new int[sz];

    {
	int *ds = vec;
	const int *ls = lhs->vec;
	for (unsigned i=0; i<sz; i++) {
	    *(ds++) = ( (*(ls++)) >= (rhs) );
	}
    }
    return IA_IntDiscreteImage(domain, vec, sz, 1);
}
#endif // vec_scalar_int_int_int_pwise_ge

static IA_IntDiscreteImage
vec_iter_bo_pwise_ge(const IA_VectorDI<int> *lhs,IA_IntDiscreteImage rhs)
{
    const IA_IntPointSet domain = lhs->domain();
    const unsigned sz = domain.card();
    int *const vec = new int[sz];

    {
	int *ds = vec;
	const int *ls = lhs->vec;
	int rtmp;
	IA_DIVIter<int>	riter(rhs);
	for (unsigned i=0; i<sz; i++) {
	    riter(rtmp);
	    *(ds++) = ( (*(ls++)) >= (rtmp) );
	}
    }
    return IA_IntDiscreteImage(domain, vec, sz, 1);
}

#ifndef scalar_vec_int_int_int_pwise_ge
#define scalar_vec_int_int_int_pwise_ge
static IA_IntDiscreteImage
scalar_vec_bo_pwise_ge(int lhs,const IA_VectorDI<int> *rhs)
{
    const IA_IntPointSet domain = rhs->domain();
    const unsigned sz = domain.card();
    int *const vec = new int[sz];

    {
	int *ds = vec;
	const int *rs = rhs->vec;
	for (unsigned i=0; i<sz; i++) {
	    *(ds++) = ( (lhs) >= (*(rs++)) );
	}
    }
    return IA_IntDiscreteImage(domain, vec, sz, 1);
}
#endif // scalar_vec_int_int_int_pwise_ge

// scalar-scalar operation is trivial

#ifndef scalar_iter_int_int_int_pwise_ge
#define scalar_iter_int_int_int_pwise_ge
static IA_IntDiscreteImage
scalar_iter_bo_pwise_ge(int lhs,IA_IntDiscreteImage rhs)
{
    const IA_IntPointSet domain = rhs.domain();
    const unsigned sz = domain.card();
    int *const vec = new int[sz];

    {
	int *ds = vec;
	int rtmp;
	IA_DIVIter<int>	riter(rhs);
	for (unsigned i=0; i<sz; i++) {
	    riter(rtmp);
	    *(ds++) = ( (lhs) >= (rtmp) );
	}
    }
    return IA_IntDiscreteImage(domain, vec, sz, 1);
}
#endif // scalar_iter_int_int_int_pwise_ge

static IA_IntDiscreteImage
iter_vec_bo_pwise_ge(IA_IntDiscreteImage lhs,const IA_VectorDI<int> *rhs)
{
    const IA_IntPointSet domain = lhs.domain();
    const unsigned sz = domain.card();
    int *const vec = new int[sz];

    {
	int *ds = vec;
	int ltmp;
	IA_DIVIter<int>	liter(lhs);
	const int *rs = rhs->vec;
	for (unsigned i=0; i<sz; i++) {
	    liter(ltmp);
	    *(ds++) = ( (ltmp) >= (*(rs++)) );
	}
    }
    return IA_IntDiscreteImage(domain, vec, sz, 1);
}

#ifndef iter_scalar_int_int_int_pwise_ge
#define iter_scalar_int_int_int_pwise_ge
static IA_IntDiscreteImage
iter_scalar_bo_pwise_ge(IA_IntDiscreteImage lhs,int rhs)
{
    const IA_IntPointSet domain = lhs.domain();
    const unsigned sz = domain.card();
    int *const vec = new int[sz];

    {
	int *ds = vec;
	int ltmp;
	IA_DIVIter<int>	liter(lhs);
	for (unsigned i=0; i<sz; i++) {
	    liter(ltmp);
	    *(ds++) = ( (ltmp) >= (rhs) );
	}
    }
    return IA_IntDiscreteImage(domain, vec, sz, 1);
}
#endif // iter_scalar_int_int_int_pwise_ge

static IA_IntDiscreteImage
iter_iter_bo_pwise_ge(IA_IntDiscreteImage lhs,IA_IntDiscreteImage rhs)
{
    const IA_IntPointSet domain = lhs.domain();
    const unsigned sz = domain.card();
    int *const vec = new int[sz];

    {
	int *ds = vec;
	int ltmp;
	IA_DIVIter<int>	liter(lhs);
	int rtmp;
	IA_DIVIter<int>	riter(rhs);
	for (unsigned i=0; i<sz; i++) {
	    liter(ltmp);
	    riter(rtmp);
	    *(ds++) = ( (ltmp) >= (rtmp) );
	}
    }
    return IA_IntDiscreteImage(domain, vec, sz, 1);
}

IA_IntDiscreteImage
pwise_ge ( const IA_IntDiscreteImage &lhs,
	      const IA_IntDiscreteImage &rhs)
{
    if (lhs.domain() != rhs.domain()) {
	static IA_IntDiscreteImage	rval;
	ia_throw( IA::PSET_MISMATCH, __FILE__,__LINE__);
	return rval;
    }

    if (lhs.type() == IA_VectorDI<int>::s_type()) {
	if (rhs.type() == IA_VectorDI<int>::s_type()) {
	    return vec_vec_bo_pwise_ge((IA_VectorDI<int> *)lhs.bdip,(IA_VectorDI<int> *)rhs.bdip);
	} else if (rhs.type() == IA_ConstDI<int>::s_type()) {
	    return vec_scalar_bo_pwise_ge((IA_VectorDI<int> *)lhs.bdip,((IA_ConstDI<int> *)rhs.bdip)->value);
	} else {
	    return vec_iter_bo_pwise_ge((IA_VectorDI<int> *)lhs.bdip,rhs);
	}
    } else if (lhs.type() == IA_ConstDI<int>::s_type()) {
	if (rhs.type() == IA_VectorDI<int>::s_type()) {
	    return scalar_vec_bo_pwise_ge(((IA_ConstDI<int> *)lhs.bdip)->value,(IA_VectorDI<int> *)rhs.bdip);
	} else if (rhs.type() == IA_ConstDI<int>::s_type()) {
	    return IA_IntDiscreteImage (lhs.domain(), (((IA_ConstDI<int> *)lhs.bdip)->value) >= (((IA_ConstDI<int> *)rhs.bdip)->value));
	} else {
	    return scalar_iter_bo_pwise_ge(((IA_ConstDI<int> *)lhs.bdip)->value,rhs);
	}
    } else {
	if (rhs.type() == IA_VectorDI<int>::s_type()) {
	    return iter_vec_bo_pwise_ge(lhs,(IA_VectorDI<int> *)rhs.bdip);
	} else if (rhs.type() == IA_ConstDI<int>::s_type()) {
	    return iter_scalar_bo_pwise_ge(lhs,((IA_ConstDI<int> *)rhs.bdip)->value);
	} else {
	    return iter_iter_bo_pwise_ge(lhs,rhs);
	}
    }
}

//////////////////////////////////////////////////////////////////////
//
// Begin operation support routines for :
// binary pointwise non-commutative pwise_ge subop=operator>= I(int) int I(int)
//
#ifndef vec_scalar_int_int_int_pwise_ge
#define vec_scalar_int_int_int_pwise_ge
static IA_IntDiscreteImage
vec_scalar_bo_pwise_ge(const IA_VectorDI<int> *lhs,int rhs)
{
    const IA_IntPointSet domain = lhs->domain();
    const unsigned sz = domain.card();
    int *const vec = new int[sz];

    {
	int *ds = vec;
	const int *ls = lhs->vec;
	for (unsigned i=0; i<sz; i++) {
	    *(ds++) = ( (*(ls++)) >= (rhs) );
	}
    }
    return IA_IntDiscreteImage(domain, vec, sz, 1);
}
#endif // vec_scalar_int_int_int_pwise_ge

// scalar-scalar operation is trivial

#ifndef iter_scalar_int_int_int_pwise_ge
#define iter_scalar_int_int_int_pwise_ge
static IA_IntDiscreteImage
iter_scalar_bo_pwise_ge(IA_IntDiscreteImage lhs,int rhs)
{
    const IA_IntPointSet domain = lhs.domain();
    const unsigned sz = domain.card();
    int *const vec = new int[sz];

    {
	int *ds = vec;
	int ltmp;
	IA_DIVIter<int>	liter(lhs);
	for (unsigned i=0; i<sz; i++) {
	    liter(ltmp);
	    *(ds++) = ( (ltmp) >= (rhs) );
	}
    }
    return IA_IntDiscreteImage(domain, vec, sz, 1);
}
#endif // iter_scalar_int_int_int_pwise_ge

IA_IntDiscreteImage
pwise_ge ( const IA_IntDiscreteImage &lhs, int rhs)
{
    if (lhs.type() == IA_VectorDI<int>::s_type()) {
	return vec_scalar_bo_pwise_ge((IA_VectorDI<int> *)lhs.bdip,rhs);
    } else if (lhs.type() == IA_ConstDI<int>::s_type()) {
	return IA_IntDiscreteImage (lhs.domain(), (((IA_ConstDI<int> *)lhs.bdip)->value) >= (rhs));
    } else {
	return iter_scalar_bo_pwise_ge(lhs,rhs);
    }
}

//////////////////////////////////////////////////////////////////////
//
// Begin operation support routines for :
// binary pointwise non-commutative pwise_ge subop=operator>= int I(int) I(int)
//
#ifndef scalar_vec_int_int_int_pwise_ge
#define scalar_vec_int_int_int_pwise_ge
static IA_IntDiscreteImage
scalar_vec_bo_pwise_ge(int lhs,const IA_VectorDI<int> *rhs)
{
    const IA_IntPointSet domain = rhs->domain();
    const unsigned sz = domain.card();
    int *const vec = new int[sz];

    {
	int *ds = vec;
	const int *rs = rhs->vec;
	for (unsigned i=0; i<sz; i++) {
	    *(ds++) = ( (lhs) >= (*(rs++)) );
	}
    }
    return IA_IntDiscreteImage(domain, vec, sz, 1);
}
#endif // scalar_vec_int_int_int_pwise_ge

// scalar-scalar operation is trivial

#ifndef scalar_iter_int_int_int_pwise_ge
#define scalar_iter_int_int_int_pwise_ge
static IA_IntDiscreteImage
scalar_iter_bo_pwise_ge(int lhs,IA_IntDiscreteImage rhs)
{
    const IA_IntPointSet domain = rhs.domain();
    const unsigned sz = domain.card();
    int *const vec = new int[sz];

    {
	int *ds = vec;
	int rtmp;
	IA_DIVIter<int>	riter(rhs);
	for (unsigned i=0; i<sz; i++) {
	    riter(rtmp);
	    *(ds++) = ( (lhs) >= (rtmp) );
	}
    }
    return IA_IntDiscreteImage(domain, vec, sz, 1);
}
#endif // scalar_iter_int_int_int_pwise_ge

IA_IntDiscreteImage
pwise_ge (int lhs, const IA_IntDiscreteImage &rhs)
{
    if (rhs.type() == IA_VectorDI<int>::s_type()) {
	return scalar_vec_bo_pwise_ge(lhs,(IA_VectorDI<int> *)rhs.bdip);
    } else if (rhs.type() == IA_ConstDI<int>::s_type()) {
	return IA_IntDiscreteImage (rhs.domain(), (lhs) >= (((IA_ConstDI<int> *)rhs.bdip)->value));
    } else {
	return scalar_iter_bo_pwise_ge(lhs,rhs);
    }
}

//////////////////////////////////////////////////////////////////////
//
// Begin operation support routines for :
// binary pointwise non-commutative pwise_gt subop=operator> I(int) I(int) I(int)
//
static IA_IntDiscreteImage
vec_vec_bo_pwise_gt(const IA_VectorDI<int> *lhs,const IA_VectorDI<int> *rhs)
{
    const IA_IntPointSet domain = lhs->domain();
    const unsigned sz = domain.card();
    int *const vec = new int[sz];

    {
	int *ds = vec;
	const int *ls = lhs->vec;
	const int *rs = rhs->vec;
	for (unsigned i=0; i<sz; i++) {
	    *(ds++) = ( (*(ls++)) > (*(rs++)) );
	}
    }
    return IA_IntDiscreteImage(domain, vec, sz, 1);
}

#ifndef vec_scalar_int_int_int_pwise_gt
#define vec_scalar_int_int_int_pwise_gt
static IA_IntDiscreteImage
vec_scalar_bo_pwise_gt(const IA_VectorDI<int> *lhs,int rhs)
{
    const IA_IntPointSet domain = lhs->domain();
    const unsigned sz = domain.card();
    int *const vec = new int[sz];

    {
	int *ds = vec;
	const int *ls = lhs->vec;
	for (unsigned i=0; i<sz; i++) {
	    *(ds++) = ( (*(ls++)) > (rhs) );
	}
    }
    return IA_IntDiscreteImage(domain, vec, sz, 1);
}
#endif // vec_scalar_int_int_int_pwise_gt

static IA_IntDiscreteImage
vec_iter_bo_pwise_gt(const IA_VectorDI<int> *lhs,IA_IntDiscreteImage rhs)
{
    const IA_IntPointSet domain = lhs->domain();
    const unsigned sz = domain.card();
    int *const vec = new int[sz];

    {
	int *ds = vec;
	const int *ls = lhs->vec;
	int rtmp;
	IA_DIVIter<int>	riter(rhs);
	for (unsigned i=0; i<sz; i++) {
	    riter(rtmp);
	    *(ds++) = ( (*(ls++)) > (rtmp) );
	}
    }
    return IA_IntDiscreteImage(domain, vec, sz, 1);
}

#ifndef scalar_vec_int_int_int_pwise_gt
#define scalar_vec_int_int_int_pwise_gt
static IA_IntDiscreteImage
scalar_vec_bo_pwise_gt(int lhs,const IA_VectorDI<int> *rhs)
{
    const IA_IntPointSet domain = rhs->domain();
    const unsigned sz = domain.card();
    int *const vec = new int[sz];

    {
	int *ds = vec;
	const int *rs = rhs->vec;
	for (unsigned i=0; i<sz; i++) {
	    *(ds++) = ( (lhs) > (*(rs++)) );
	}
    }
    return IA_IntDiscreteImage(domain, vec, sz, 1);
}
#endif // scalar_vec_int_int_int_pwise_gt

// scalar-scalar operation is trivial

#ifndef scalar_iter_int_int_int_pwise_gt
#define scalar_iter_int_int_int_pwise_gt
static IA_IntDiscreteImage
scalar_iter_bo_pwise_gt(int lhs,IA_IntDiscreteImage rhs)
{
    const IA_IntPointSet domain = rhs.domain();
    const unsigned sz = domain.card();
    int *const vec = new int[sz];

    {
	int *ds = vec;
	int rtmp;
	IA_DIVIter<int>	riter(rhs);
	for (unsigned i=0; i<sz; i++) {
	    riter(rtmp);
	    *(ds++) = ( (lhs) > (rtmp) );
	}
    }
    return IA_IntDiscreteImage(domain, vec, sz, 1);
}
#endif // scalar_iter_int_int_int_pwise_gt

static IA_IntDiscreteImage
iter_vec_bo_pwise_gt(IA_IntDiscreteImage lhs,const IA_VectorDI<int> *rhs)
{
    const IA_IntPointSet domain = lhs.domain();
    const unsigned sz = domain.card();
    int *const vec = new int[sz];

    {
	int *ds = vec;
	int ltmp;
	IA_DIVIter<int>	liter(lhs);
	const int *rs = rhs->vec;
	for (unsigned i=0; i<sz; i++) {
	    liter(ltmp);
	    *(ds++) = ( (ltmp) > (*(rs++)) );
	}
    }
    return IA_IntDiscreteImage(domain, vec, sz, 1);
}

#ifndef iter_scalar_int_int_int_pwise_gt
#define iter_scalar_int_int_int_pwise_gt
static IA_IntDiscreteImage
iter_scalar_bo_pwise_gt(IA_IntDiscreteImage lhs,int rhs)
{
    const IA_IntPointSet domain = lhs.domain();
    const unsigned sz = domain.card();
    int *const vec = new int[sz];

    {
	int *ds = vec;
	int ltmp;
	IA_DIVIter<int>	liter(lhs);
	for (unsigned i=0; i<sz; i++) {
	    liter(ltmp);
	    *(ds++) = ( (ltmp) > (rhs) );
	}
    }
    return IA_IntDiscreteImage(domain, vec, sz, 1);
}
#endif // iter_scalar_int_int_int_pwise_gt

static IA_IntDiscreteImage
iter_iter_bo_pwise_gt(IA_IntDiscreteImage lhs,IA_IntDiscreteImage rhs)
{
    const IA_IntPointSet domain = lhs.domain();
    const unsigned sz = domain.card();
    int *const vec = new int[sz];

    {
	int *ds = vec;
	int ltmp;
	IA_DIVIter<int>	liter(lhs);
	int rtmp;
	IA_DIVIter<int>	riter(rhs);
	for (unsigned i=0; i<sz; i++) {
	    liter(ltmp);
	    riter(rtmp);
	    *(ds++) = ( (ltmp) > (rtmp) );
	}
    }
    return IA_IntDiscreteImage(domain, vec, sz, 1);
}

IA_IntDiscreteImage
pwise_gt ( const IA_IntDiscreteImage &lhs,
	      const IA_IntDiscreteImage &rhs)
{
    if (lhs.domain() != rhs.domain()) {
	static IA_IntDiscreteImage	rval;
	ia_throw( IA::PSET_MISMATCH, __FILE__,__LINE__);
	return rval;
    }

    if (lhs.type() == IA_VectorDI<int>::s_type()) {
	if (rhs.type() == IA_VectorDI<int>::s_type()) {
	    return vec_vec_bo_pwise_gt((IA_VectorDI<int> *)lhs.bdip,(IA_VectorDI<int> *)rhs.bdip);
	} else if (rhs.type() == IA_ConstDI<int>::s_type()) {
	    return vec_scalar_bo_pwise_gt((IA_VectorDI<int> *)lhs.bdip,((IA_ConstDI<int> *)rhs.bdip)->value);
	} else {
	    return vec_iter_bo_pwise_gt((IA_VectorDI<int> *)lhs.bdip,rhs);
	}
    } else if (lhs.type() == IA_ConstDI<int>::s_type()) {
	if (rhs.type() == IA_VectorDI<int>::s_type()) {
	    return scalar_vec_bo_pwise_gt(((IA_ConstDI<int> *)lhs.bdip)->value,(IA_VectorDI<int> *)rhs.bdip);
	} else if (rhs.type() == IA_ConstDI<int>::s_type()) {
	    return IA_IntDiscreteImage (lhs.domain(), (((IA_ConstDI<int> *)lhs.bdip)->value) > (((IA_ConstDI<int> *)rhs.bdip)->value));
	} else {
	    return scalar_iter_bo_pwise_gt(((IA_ConstDI<int> *)lhs.bdip)->value,rhs);
	}
    } else {
	if (rhs.type() == IA_VectorDI<int>::s_type()) {
	    return iter_vec_bo_pwise_gt(lhs,(IA_VectorDI<int> *)rhs.bdip);
	} else if (rhs.type() == IA_ConstDI<int>::s_type()) {
	    return iter_scalar_bo_pwise_gt(lhs,((IA_ConstDI<int> *)rhs.bdip)->value);
	} else {
	    return iter_iter_bo_pwise_gt(lhs,rhs);
	}
    }
}

//////////////////////////////////////////////////////////////////////
//
// Begin operation support routines for :
// binary pointwise non-commutative pwise_gt subop=operator> I(int) int I(int)
//
#ifndef vec_scalar_int_int_int_pwise_gt
#define vec_scalar_int_int_int_pwise_gt
static IA_IntDiscreteImage
vec_scalar_bo_pwise_gt(const IA_VectorDI<int> *lhs,int rhs)
{
    const IA_IntPointSet domain = lhs->domain();
    const unsigned sz = domain.card();
    int *const vec = new int[sz];

    {
	int *ds = vec;
	const int *ls = lhs->vec;
	for (unsigned i=0; i<sz; i++) {
	    *(ds++) = ( (*(ls++)) > (rhs) );
	}
    }
    return IA_IntDiscreteImage(domain, vec, sz, 1);
}
#endif // vec_scalar_int_int_int_pwise_gt

// scalar-scalar operation is trivial

#ifndef iter_scalar_int_int_int_pwise_gt
#define iter_scalar_int_int_int_pwise_gt
static IA_IntDiscreteImage
iter_scalar_bo_pwise_gt(IA_IntDiscreteImage lhs,int rhs)
{
    const IA_IntPointSet domain = lhs.domain();
    const unsigned sz = domain.card();
    int *const vec = new int[sz];

    {
	int *ds = vec;
	int ltmp;
	IA_DIVIter<int>	liter(lhs);
	for (unsigned i=0; i<sz; i++) {
	    liter(ltmp);
	    *(ds++) = ( (ltmp) > (rhs) );
	}
    }
    return IA_IntDiscreteImage(domain, vec, sz, 1);
}
#endif // iter_scalar_int_int_int_pwise_gt

IA_IntDiscreteImage
pwise_gt ( const IA_IntDiscreteImage &lhs, int rhs)
{
    if (lhs.type() == IA_VectorDI<int>::s_type()) {
	return vec_scalar_bo_pwise_gt((IA_VectorDI<int> *)lhs.bdip,rhs);
    } else if (lhs.type() == IA_ConstDI<int>::s_type()) {
	return IA_IntDiscreteImage (lhs.domain(), (((IA_ConstDI<int> *)lhs.bdip)->value) > (rhs));
    } else {
	return iter_scalar_bo_pwise_gt(lhs,rhs);
    }
}

//////////////////////////////////////////////////////////////////////
//
// Begin operation support routines for :
// binary pointwise non-commutative pwise_gt subop=operator> int I(int) I(int)
//
#ifndef scalar_vec_int_int_int_pwise_gt
#define scalar_vec_int_int_int_pwise_gt
static IA_IntDiscreteImage
scalar_vec_bo_pwise_gt(int lhs,const IA_VectorDI<int> *rhs)
{
    const IA_IntPointSet domain = rhs->domain();
    const unsigned sz = domain.card();
    int *const vec = new int[sz];

    {
	int *ds = vec;
	const int *rs = rhs->vec;
	for (unsigned i=0; i<sz; i++) {
	    *(ds++) = ( (lhs) > (*(rs++)) );
	}
    }
    return IA_IntDiscreteImage(domain, vec, sz, 1);
}
#endif // scalar_vec_int_int_int_pwise_gt

// scalar-scalar operation is trivial

#ifndef scalar_iter_int_int_int_pwise_gt
#define scalar_iter_int_int_int_pwise_gt
static IA_IntDiscreteImage
scalar_iter_bo_pwise_gt(int lhs,IA_IntDiscreteImage rhs)
{
    const IA_IntPointSet domain = rhs.domain();
    const unsigned sz = domain.card();
    int *const vec = new int[sz];

    {
	int *ds = vec;
	int rtmp;
	IA_DIVIter<int>	riter(rhs);
	for (unsigned i=0; i<sz; i++) {
	    riter(rtmp);
	    *(ds++) = ( (lhs) > (rtmp) );
	}
    }
    return IA_IntDiscreteImage(domain, vec, sz, 1);
}
#endif // scalar_iter_int_int_int_pwise_gt

IA_IntDiscreteImage
pwise_gt (int lhs, const IA_IntDiscreteImage &rhs)
{
    if (rhs.type() == IA_VectorDI<int>::s_type()) {
	return scalar_vec_bo_pwise_gt(lhs,(IA_VectorDI<int> *)rhs.bdip);
    } else if (rhs.type() == IA_ConstDI<int>::s_type()) {
	return IA_IntDiscreteImage (rhs.domain(), (lhs) > (((IA_ConstDI<int> *)rhs.bdip)->value));
    } else {
	return scalar_iter_bo_pwise_gt(lhs,rhs);
    }
}

//////////////////////////////////////////////////////////////////////
//
// Begin operation support routines for :
// unary pointwise isqrt I(int) I(int)
//
// Emacs: -*- C++ -*-

//
//	Copyright 1993, Center for Computer Vision and Visualization,
//	University of Florida.  All rights reserved.
//


//
// $Log:	unary-op.templ,v $
// Revision 1.2  93/05/27  11:49:04  thoth
// Copyright Notices
// 
// Revision 1.1  93/03/10  13:50:00  thoth
// Initial revision
// 

#ifndef vec_scalar_int_int_isqrt
#define vec_scalar_int_int_isqrt
static IA_IntDiscreteImage
vec_uo_isqrt(const IA_VectorDI<int> *lhs)
{
    const IA_IntPointSet domain = lhs->domain();
    const unsigned sz = domain.card();
    int *const vec = new int[sz];

    {
	int *ds = vec;
	const int *ls = lhs->vec;
	for (unsigned i=0; i<sz; i++) {
	    *(ds++) = isqrt(*(ls++));
	}
    }
    return IA_IntDiscreteImage(domain, vec, sz, 1);
}
#endif // vec_scalar_int_int_isqrt

// scalar-scalar operation is trivial

#ifndef iter_scalar_int_int_isqrt
#define iter_scalar_int_int_isqrt
static IA_IntDiscreteImage
iter_uo_isqrt(IA_IntDiscreteImage lhs)
{
    const IA_IntPointSet domain = lhs.domain();
    const unsigned sz = domain.card();
    int *const vec = new int[sz];

    {
	int *ds = vec;
	int ltmp;
	IA_DIVIter<int>	liter(lhs);
	for (unsigned i=0; i<sz; i++) {
	    liter(ltmp);
	    *(ds++) = isqrt(ltmp);
	}
    }
    return IA_IntDiscreteImage(domain, vec, sz, 1);
}
#endif // iter_scalar_int_int_isqrt

IA_IntDiscreteImage
isqrt ( const IA_IntDiscreteImage &arg)
{
    if (arg.type() == IA_VectorDI<int>::s_type()) {
	return vec_uo_isqrt((IA_VectorDI<int> *)arg.bdip);
    } else if (arg.type() == IA_ConstDI<int>::s_type()) {
	return IA_IntDiscreteImage (arg.domain(), isqrt(((IA_ConstDI<int> *)arg.bdip)->value));
    } else {
	return iter_uo_isqrt(arg);
    }
}

//////////////////////////////////////////////////////////////////////
//
// Begin operation support routines for :
// unary pointwise sqr I(int) I(int)
//
// Emacs: -*- C++ -*-

//
//	Copyright 1993, Center for Computer Vision and Visualization,
//	University of Florida.  All rights reserved.
//


//
// $Log:	unary-op.templ,v $
// Revision 1.2  93/05/27  11:49:04  thoth
// Copyright Notices
// 
// Revision 1.1  93/03/10  13:50:00  thoth
// Initial revision
// 

#ifndef vec_scalar_int_int_sqr
#define vec_scalar_int_int_sqr
static IA_IntDiscreteImage
vec_uo_sqr(const IA_VectorDI<int> *lhs)
{
    const IA_IntPointSet domain = lhs->domain();
    const unsigned sz = domain.card();
    int *const vec = new int[sz];

    {
	int *ds = vec;
	const int *ls = lhs->vec;
	for (unsigned i=0; i<sz; i++) {
	    *(ds++) = sqr(*(ls++));
	}
    }
    return IA_IntDiscreteImage(domain, vec, sz, 1);
}
#endif // vec_scalar_int_int_sqr

// scalar-scalar operation is trivial

#ifndef iter_scalar_int_int_sqr
#define iter_scalar_int_int_sqr
static IA_IntDiscreteImage
iter_uo_sqr(IA_IntDiscreteImage lhs)
{
    const IA_IntPointSet domain = lhs.domain();
    const unsigned sz = domain.card();
    int *const vec = new int[sz];

    {
	int *ds = vec;
	int ltmp;
	IA_DIVIter<int>	liter(lhs);
	for (unsigned i=0; i<sz; i++) {
	    liter(ltmp);
	    *(ds++) = sqr(ltmp);
	}
    }
    return IA_IntDiscreteImage(domain, vec, sz, 1);
}
#endif // iter_scalar_int_int_sqr

IA_IntDiscreteImage
sqr ( const IA_IntDiscreteImage &arg)
{
    if (arg.type() == IA_VectorDI<int>::s_type()) {
	return vec_uo_sqr((IA_VectorDI<int> *)arg.bdip);
    } else if (arg.type() == IA_ConstDI<int>::s_type()) {
	return IA_IntDiscreteImage (arg.domain(), sqr(((IA_ConstDI<int> *)arg.bdip)->value));
    } else {
	return iter_uo_sqr(arg);
    }
}

//////////////////////////////////////////////////////////////////////
//
// Begin operation support routines for :
// binary pointwise commutative max I(int) I(int) I(int)
//
static IA_IntDiscreteImage
vec_vec_bo_max(const IA_VectorDI<int> *lhs,const IA_VectorDI<int> *rhs)
{
    const IA_IntPointSet domain = lhs->domain();
    const unsigned sz = domain.card();
    int *const vec = new int[sz];

    {
	int *ds = vec;
	const int *ls = lhs->vec;
	const int *rs = rhs->vec;
	for (unsigned i=0; i<sz; i++) {
	    *(ds++) = max(*(ls++), *(rs++));
	}
    }
    return IA_IntDiscreteImage(domain, vec, sz, 1);
}

#ifndef vec_scalar_int_int_int_max
#define vec_scalar_int_int_int_max
static IA_IntDiscreteImage
vec_scalar_bo_max(const IA_VectorDI<int> *lhs,int rhs)
{
    const IA_IntPointSet domain = lhs->domain();
    const unsigned sz = domain.card();
    int *const vec = new int[sz];

    {
	int *ds = vec;
	const int *ls = lhs->vec;
	for (unsigned i=0; i<sz; i++) {
	    *(ds++) = max(*(ls++), rhs);
	}
    }
    return IA_IntDiscreteImage(domain, vec, sz, 1);
}
#endif // vec_scalar_int_int_int_max

static IA_IntDiscreteImage
vec_iter_bo_max(const IA_VectorDI<int> *lhs,IA_IntDiscreteImage rhs)
{
    const IA_IntPointSet domain = lhs->domain();
    const unsigned sz = domain.card();
    int *const vec = new int[sz];

    {
	int *ds = vec;
	const int *ls = lhs->vec;
	int rtmp;
	IA_DIVIter<int>	riter(rhs);
	for (unsigned i=0; i<sz; i++) {
	    riter(rtmp);
	    *(ds++) = max(*(ls++), rtmp);
	}
    }
    return IA_IntDiscreteImage(domain, vec, sz, 1);
}

// scalar-scalar operation is trivial

#ifndef scalar_iter_int_int_int_max
#define scalar_iter_int_int_int_max
static IA_IntDiscreteImage
scalar_iter_bo_max(int lhs,IA_IntDiscreteImage rhs)
{
    const IA_IntPointSet domain = rhs.domain();
    const unsigned sz = domain.card();
    int *const vec = new int[sz];

    {
	int *ds = vec;
	int rtmp;
	IA_DIVIter<int>	riter(rhs);
	for (unsigned i=0; i<sz; i++) {
	    riter(rtmp);
	    *(ds++) = max(lhs, rtmp);
	}
    }
    return IA_IntDiscreteImage(domain, vec, sz, 1);
}
#endif // scalar_iter_int_int_int_max

static IA_IntDiscreteImage
iter_iter_bo_max(IA_IntDiscreteImage lhs,IA_IntDiscreteImage rhs)
{
    const IA_IntPointSet domain = lhs.domain();
    const unsigned sz = domain.card();
    int *const vec = new int[sz];

    {
	int *ds = vec;
	int ltmp;
	IA_DIVIter<int>	liter(lhs);
	int rtmp;
	IA_DIVIter<int>	riter(rhs);
	for (unsigned i=0; i<sz; i++) {
	    liter(ltmp);
	    riter(rtmp);
	    *(ds++) = max(ltmp, rtmp);
	}
    }
    return IA_IntDiscreteImage(domain, vec, sz, 1);
}

IA_IntDiscreteImage
max ( const IA_IntDiscreteImage &lhs,
	      const IA_IntDiscreteImage &rhs)
{
    if (lhs.domain() != rhs.domain()) {
	static IA_IntDiscreteImage	rval;
	ia_throw( IA::PSET_MISMATCH, __FILE__,__LINE__);
	return rval;
    }

    if (lhs.type() == IA_VectorDI<int>::s_type()) {
	if (rhs.type() == IA_VectorDI<int>::s_type()) {
	    return vec_vec_bo_max((IA_VectorDI<int> *)lhs.bdip,(IA_VectorDI<int> *)rhs.bdip);
	} else if (rhs.type() == IA_ConstDI<int>::s_type()) {
	    return vec_scalar_bo_max((IA_VectorDI<int> *)lhs.bdip,((IA_ConstDI<int> *)rhs.bdip)->value);
	} else {
	    return vec_iter_bo_max((IA_VectorDI<int> *)lhs.bdip,rhs);
	}
    } else if (lhs.type() == IA_ConstDI<int>::s_type()) {
	if (rhs.type() == IA_VectorDI<int>::s_type()) {
	    return vec_scalar_bo_max((IA_VectorDI<int> *)rhs.bdip,((IA_ConstDI<int> *)lhs.bdip)->value);
	} else if (rhs.type() == IA_ConstDI<int>::s_type()) {
	    return IA_IntDiscreteImage (lhs.domain(), max(((IA_ConstDI<int> *)lhs.bdip)->value, ((IA_ConstDI<int> *)rhs.bdip)->value));
	} else {
	    return scalar_iter_bo_max(((IA_ConstDI<int> *)lhs.bdip)->value,rhs);
	}
    } else {
	if (rhs.type() == IA_VectorDI<int>::s_type()) {
	    return vec_iter_bo_max((IA_VectorDI<int> *)rhs.bdip,lhs);
	} else if (rhs.type() == IA_ConstDI<int>::s_type()) {
	    return scalar_iter_bo_max(((IA_ConstDI<int> *)rhs.bdip)->value,lhs);
	} else {
	    return iter_iter_bo_max(lhs,rhs);
	}
    }
}

//////////////////////////////////////////////////////////////////////
//
// Begin operation support routines for :
// binary pointwise commutative max I(int) int I(int)
//
#ifndef vec_scalar_int_int_int_max
#define vec_scalar_int_int_int_max
static IA_IntDiscreteImage
vec_scalar_bo_max(const IA_VectorDI<int> *lhs,int rhs)
{
    const IA_IntPointSet domain = lhs->domain();
    const unsigned sz = domain.card();
    int *const vec = new int[sz];

    {
	int *ds = vec;
	const int *ls = lhs->vec;
	for (unsigned i=0; i<sz; i++) {
	    *(ds++) = max(*(ls++), rhs);
	}
    }
    return IA_IntDiscreteImage(domain, vec, sz, 1);
}
#endif // vec_scalar_int_int_int_max

// scalar-scalar operation is trivial

#ifndef scalar_iter_int_int_int_max
#define scalar_iter_int_int_int_max
static IA_IntDiscreteImage
scalar_iter_bo_max(int lhs,IA_IntDiscreteImage rhs)
{
    const IA_IntPointSet domain = rhs.domain();
    const unsigned sz = domain.card();
    int *const vec = new int[sz];

    {
	int *ds = vec;
	int rtmp;
	IA_DIVIter<int>	riter(rhs);
	for (unsigned i=0; i<sz; i++) {
	    riter(rtmp);
	    *(ds++) = max(lhs, rtmp);
	}
    }
    return IA_IntDiscreteImage(domain, vec, sz, 1);
}
#endif // scalar_iter_int_int_int_max

IA_IntDiscreteImage
max ( const IA_IntDiscreteImage &lhs, int rhs)
{
    if (lhs.type() == IA_VectorDI<int>::s_type()) {
	return vec_scalar_bo_max((IA_VectorDI<int> *)lhs.bdip,rhs);
    } else if (lhs.type() == IA_ConstDI<int>::s_type()) {
	return IA_IntDiscreteImage (lhs.domain(), max(((IA_ConstDI<int> *)lhs.bdip)->value, rhs));
    } else {
	return scalar_iter_bo_max(rhs,lhs);
    }
}

//////////////////////////////////////////////////////////////////////
//
// Begin operation support routines for :
// binary pointwise commutative min I(int) I(int) I(int)
//
static IA_IntDiscreteImage
vec_vec_bo_min(const IA_VectorDI<int> *lhs,const IA_VectorDI<int> *rhs)
{
    const IA_IntPointSet domain = lhs->domain();
    const unsigned sz = domain.card();
    int *const vec = new int[sz];

    {
	int *ds = vec;
	const int *ls = lhs->vec;
	const int *rs = rhs->vec;
	for (unsigned i=0; i<sz; i++) {
	    *(ds++) = min(*(ls++), *(rs++));
	}
    }
    return IA_IntDiscreteImage(domain, vec, sz, 1);
}

#ifndef vec_scalar_int_int_int_min
#define vec_scalar_int_int_int_min
static IA_IntDiscreteImage
vec_scalar_bo_min(const IA_VectorDI<int> *lhs,int rhs)
{
    const IA_IntPointSet domain = lhs->domain();
    const unsigned sz = domain.card();
    int *const vec = new int[sz];

    {
	int *ds = vec;
	const int *ls = lhs->vec;
	for (unsigned i=0; i<sz; i++) {
	    *(ds++) = min(*(ls++), rhs);
	}
    }
    return IA_IntDiscreteImage(domain, vec, sz, 1);
}
#endif // vec_scalar_int_int_int_min

static IA_IntDiscreteImage
vec_iter_bo_min(const IA_VectorDI<int> *lhs,IA_IntDiscreteImage rhs)
{
    const IA_IntPointSet domain = lhs->domain();
    const unsigned sz = domain.card();
    int *const vec = new int[sz];

    {
	int *ds = vec;
	const int *ls = lhs->vec;
	int rtmp;
	IA_DIVIter<int>	riter(rhs);
	for (unsigned i=0; i<sz; i++) {
	    riter(rtmp);
	    *(ds++) = min(*(ls++), rtmp);
	}
    }
    return IA_IntDiscreteImage(domain, vec, sz, 1);
}

// scalar-scalar operation is trivial

#ifndef scalar_iter_int_int_int_min
#define scalar_iter_int_int_int_min
static IA_IntDiscreteImage
scalar_iter_bo_min(int lhs,IA_IntDiscreteImage rhs)
{
    const IA_IntPointSet domain = rhs.domain();
    const unsigned sz = domain.card();
    int *const vec = new int[sz];

    {
	int *ds = vec;
	int rtmp;
	IA_DIVIter<int>	riter(rhs);
	for (unsigned i=0; i<sz; i++) {
	    riter(rtmp);
	    *(ds++) = min(lhs, rtmp);
	}
    }
    return IA_IntDiscreteImage(domain, vec, sz, 1);
}
#endif // scalar_iter_int_int_int_min

static IA_IntDiscreteImage
iter_iter_bo_min(IA_IntDiscreteImage lhs,IA_IntDiscreteImage rhs)
{
    const IA_IntPointSet domain = lhs.domain();
    const unsigned sz = domain.card();
    int *const vec = new int[sz];

    {
	int *ds = vec;
	int ltmp;
	IA_DIVIter<int>	liter(lhs);
	int rtmp;
	IA_DIVIter<int>	riter(rhs);
	for (unsigned i=0; i<sz; i++) {
	    liter(ltmp);
	    riter(rtmp);
	    *(ds++) = min(ltmp, rtmp);
	}
    }
    return IA_IntDiscreteImage(domain, vec, sz, 1);
}

IA_IntDiscreteImage
min ( const IA_IntDiscreteImage &lhs,
	      const IA_IntDiscreteImage &rhs)
{
    if (lhs.domain() != rhs.domain()) {
	static IA_IntDiscreteImage	rval;
	ia_throw( IA::PSET_MISMATCH, __FILE__,__LINE__);
	return rval;
    }

    if (lhs.type() == IA_VectorDI<int>::s_type()) {
	if (rhs.type() == IA_VectorDI<int>::s_type()) {
	    return vec_vec_bo_min((IA_VectorDI<int> *)lhs.bdip,(IA_VectorDI<int> *)rhs.bdip);
	} else if (rhs.type() == IA_ConstDI<int>::s_type()) {
	    return vec_scalar_bo_min((IA_VectorDI<int> *)lhs.bdip,((IA_ConstDI<int> *)rhs.bdip)->value);
	} else {
	    return vec_iter_bo_min((IA_VectorDI<int> *)lhs.bdip,rhs);
	}
    } else if (lhs.type() == IA_ConstDI<int>::s_type()) {
	if (rhs.type() == IA_VectorDI<int>::s_type()) {
	    return vec_scalar_bo_min((IA_VectorDI<int> *)rhs.bdip,((IA_ConstDI<int> *)lhs.bdip)->value);
	} else if (rhs.type() == IA_ConstDI<int>::s_type()) {
	    return IA_IntDiscreteImage (lhs.domain(), min(((IA_ConstDI<int> *)lhs.bdip)->value, ((IA_ConstDI<int> *)rhs.bdip)->value));
	} else {
	    return scalar_iter_bo_min(((IA_ConstDI<int> *)lhs.bdip)->value,rhs);
	}
    } else {
	if (rhs.type() == IA_VectorDI<int>::s_type()) {
	    return vec_iter_bo_min((IA_VectorDI<int> *)rhs.bdip,lhs);
	} else if (rhs.type() == IA_ConstDI<int>::s_type()) {
	    return scalar_iter_bo_min(((IA_ConstDI<int> *)rhs.bdip)->value,lhs);
	} else {
	    return iter_iter_bo_min(lhs,rhs);
	}
    }
}

//////////////////////////////////////////////////////////////////////
//
// Begin operation support routines for :
// binary pointwise commutative min I(int) int I(int)
//
#ifndef vec_scalar_int_int_int_min
#define vec_scalar_int_int_int_min
static IA_IntDiscreteImage
vec_scalar_bo_min(const IA_VectorDI<int> *lhs,int rhs)
{
    const IA_IntPointSet domain = lhs->domain();
    const unsigned sz = domain.card();
    int *const vec = new int[sz];

    {
	int *ds = vec;
	const int *ls = lhs->vec;
	for (unsigned i=0; i<sz; i++) {
	    *(ds++) = min(*(ls++), rhs);
	}
    }
    return IA_IntDiscreteImage(domain, vec, sz, 1);
}
#endif // vec_scalar_int_int_int_min

// scalar-scalar operation is trivial

#ifndef scalar_iter_int_int_int_min
#define scalar_iter_int_int_int_min
static IA_IntDiscreteImage
scalar_iter_bo_min(int lhs,IA_IntDiscreteImage rhs)
{
    const IA_IntPointSet domain = rhs.domain();
    const unsigned sz = domain.card();
    int *const vec = new int[sz];

    {
	int *ds = vec;
	int rtmp;
	IA_DIVIter<int>	riter(rhs);
	for (unsigned i=0; i<sz; i++) {
	    riter(rtmp);
	    *(ds++) = min(lhs, rtmp);
	}
    }
    return IA_IntDiscreteImage(domain, vec, sz, 1);
}
#endif // scalar_iter_int_int_int_min

IA_IntDiscreteImage
min ( const IA_IntDiscreteImage &lhs, int rhs)
{
    if (lhs.type() == IA_VectorDI<int>::s_type()) {
	return vec_scalar_bo_min((IA_VectorDI<int> *)lhs.bdip,rhs);
    } else if (lhs.type() == IA_ConstDI<int>::s_type()) {
	return IA_IntDiscreteImage (lhs.domain(), min(((IA_ConstDI<int> *)lhs.bdip)->value, rhs));
    } else {
	return scalar_iter_bo_min(rhs,lhs);
    }
}

//////////////////////////////////////////////////////////////////////
//
// Begin operation support routines for :
// reduction reduce_plus subop=operator+ int I(int)
//
// Emacs: -*- C++ -*-

//
//	Copyright 1993, Center for Computer Vision and Visualization,
//	University of Florida.  All rights reserved.
//


//
// $Log:	reduce_op_nz,v $
// Revision 1.3  93/05/27  11:49:00  thoth
// Copyright Notices
// 
// Revision 1.2  93/04/08  13:23:45  thoth
// const_reduce can be overridden in the including file.
// 
// Revision 1.1  93/03/10  13:49:34  thoth
// Initial revision
// 

static int vec_reduce_reduce_plus(const IA_VectorDI<int> *arg)
{
    const int *ls = arg->vec;

    int	rval=*(ls++);

    const unsigned sz = arg->domain().card();
    for (unsigned i=1; i<sz; i++) {
	rval = ( (rval) +  (*(ls++)));
    }

    return rval;
}

#ifndef const_reduce_int_int_reduce_plus
#define const_reduce_int_int_reduce_plus
static int const_reduce_reduce_plus(unsigned sz, int arg)
{
    int	rval=arg;
    for (unsigned i=1; i<sz; i++) {
	rval = ( (rval) + arg);
    }
    return rval;
}
#endif

static int iter_reduce_reduce_plus(const IA_IntDiscreteImage &arg)
{
    IA_DIVIter<int>	iter(arg);

    int	temp;
    iter(temp);

    int	rval=temp;

    while(iter(temp)) {
	rval = ( (rval) +  temp);
    }

    return rval;
}

int reduce_plus ( const IA_IntDiscreteImage &arg)
{
    if (arg.domain().card()==0)
	abort(); // XXX unfinished code

    if (arg.type() == IA_VectorDI<int>::s_type()) {
	return vec_reduce_reduce_plus((IA_VectorDI<int> *)arg.bdip);
    } else if (arg.type() == IA_ConstDI<int>::s_type()) {
	return const_reduce_reduce_plus(arg.domain().card(),
				   ((IA_ConstDI<int> *)arg.bdip)->value);
    } else {
	return iter_reduce_reduce_plus(arg);
    }
}

//////////////////////////////////////////////////////////////////////
//
// Begin operation support routines for :
// reduction max subop=max int I(int)
//
// Emacs: -*- C++ -*-

//
//	Copyright 1993, Center for Computer Vision and Visualization,
//	University of Florida.  All rights reserved.
//


//
// $Log:	reduce_fn_nz,v $
// Revision 1.2  93/05/27  11:49:03  thoth
// Copyright Notices
// 
// Revision 1.1  93/03/10  13:49:13  thoth
// Initial revision
// 

static int vec_reduce_max(const IA_VectorDI<int> *arg)
{
    const int *ls = arg->vec;

    int	rval=*(ls++);

    const unsigned sz = arg->domain().card();
    for (unsigned i=1; i<sz; i++) {
	rval = max( rval, (*(ls++)));
    }

    return rval;
}

#ifndef const_reduce_int_int_max
#define const_reduce_int_int_max
static int const_reduce_max(unsigned sz, int arg)
{
    int	rval=arg;
    for (unsigned i=1; i<sz; i++) {
	rval = max(rval, arg);
    }
    return rval;
}
#endif

static int iter_reduce_max(const IA_IntDiscreteImage &arg)
{
    IA_DIVIter<int>	iter(arg);

    int	temp;
    iter(temp);

    int	rval=temp;

    while(iter(temp)) {
	rval = max(rval, temp);
    }

    return rval;
}

int max ( const IA_IntDiscreteImage &arg)
{
    if (arg.domain().card()==0)
	abort(); // XXX unfinished code

    if (arg.type() == IA_VectorDI<int>::s_type()) {
	return vec_reduce_max((IA_VectorDI<int> *)arg.bdip);
    } else if (arg.type() == IA_ConstDI<int>::s_type()) {
	return const_reduce_max(arg.domain().card(),
				   ((IA_ConstDI<int> *)arg.bdip)->value);
    } else {
	return iter_reduce_max(arg);
    }
}

//////////////////////////////////////////////////////////////////////
//
// Begin operation support routines for :
// reduction min subop=min int I(int)
//
// Emacs: -*- C++ -*-

//
//	Copyright 1993, Center for Computer Vision and Visualization,
//	University of Florida.  All rights reserved.
//


//
// $Log:	reduce_fn_nz,v $
// Revision 1.2  93/05/27  11:49:03  thoth
// Copyright Notices
// 
// Revision 1.1  93/03/10  13:49:13  thoth
// Initial revision
// 

static int vec_reduce_min(const IA_VectorDI<int> *arg)
{
    const int *ls = arg->vec;

    int	rval=*(ls++);

    const unsigned sz = arg->domain().card();
    for (unsigned i=1; i<sz; i++) {
	rval = min( rval, (*(ls++)));
    }

    return rval;
}

#ifndef const_reduce_int_int_min
#define const_reduce_int_int_min
static int const_reduce_min(unsigned sz, int arg)
{
    int	rval=arg;
    for (unsigned i=1; i<sz; i++) {
	rval = min(rval, arg);
    }
    return rval;
}
#endif

static int iter_reduce_min(const IA_IntDiscreteImage &arg)
{
    IA_DIVIter<int>	iter(arg);

    int	temp;
    iter(temp);

    int	rval=temp;

    while(iter(temp)) {
	rval = min(rval, temp);
    }

    return rval;
}

int min ( const IA_IntDiscreteImage &arg)
{
    if (arg.domain().card()==0)
	abort(); // XXX unfinished code

    if (arg.type() == IA_VectorDI<int>::s_type()) {
	return vec_reduce_min((IA_VectorDI<int> *)arg.bdip);
    } else if (arg.type() == IA_ConstDI<int>::s_type()) {
	return const_reduce_min(arg.domain().card(),
				   ((IA_ConstDI<int> *)arg.bdip)->value);
    } else {
	return iter_reduce_min(arg);
    }
}

