// Emacs: -*- C++ -*-

//
//	Copyright 1993, Center for Computer Vision and Visualization,
//	University of Florida.  All rights reserved.
//


//
// $Log:	IntDDTempl.h,v $
// Revision 1.3  93/05/27  11:22:22  thoth
// Copyright Notices
// 
// Revision 1.2  93/05/26  17:01:55  thoth
// constructors that specify pointsets aren't supported right now.
// 
// Revision 1.1  93/03/18  11:04:14  thoth
// Initial revision
// 

#ifndef IntDDTempl_h_
#define IntDDTempl_h_

#include "DDTempl.h"
#include "IntDiscreteImage.h"

class IA_IntDDTemplate: public IA_DDTemplate<IA_IntDiscreteImage> {
  public:
    IA_IntDDTemplate(unsigned dim, const IA_IntDiscreteImage im)
    :IA_DDTemplate<IA_IntDiscreteImage>(IA_WhiteHole(dim), im) { }
//    IA_IntDDTemplate(const IA_IntPointSet &ps, const IA_IntDiscreteImage im)
//    :IA_DDTemplate<IA_IntDiscreteImage>(ps, im) { }

    IA_IntDDTemplate(const IA_OtherDT< IA_IntDiscreteImage > &o)
    :IA_DDTemplate<IA_IntDiscreteImage>(o) { }

//    IA_IntDDTemplate(const IA_IntPointSet &ps,
//		     IA_IntDiscreteImage (*f)(const IA_IntPoint&))
//    :IA_DDTemplate<IA_IntDiscreteImage>(ps, f) { }
    IA_IntDDTemplate(unsigned dim,
		     IA_IntDiscreteImage (*f)(const IA_IntPoint&))
    :IA_DDTemplate<IA_IntDiscreteImage>(IA_WhiteHole(dim), f) { }

#include	"IntConvolutions.h"
};

#endif
