// Emacs: -*- C++ -*-

//
//	Copyright 1993, Center for Computer Vision and Visualization,
//	University of Florida.  All rights reserved.
//

static char DIVIterrcsid[] = "$Id: DIVIter.c,v 1.8 93/05/27 11:28:20 thoth Exp $";

// 
// $Log:	DIVIter.c,v $
// Revision 1.8  93/05/27  11:28:20  thoth
// Copyright Notices
// 
// Revision 1.7  93/04/17  18:45:06  thoth
// Iterator support is no longer based on a switch statement.  We now
// use a virtual method.  The user can now provide faster iterators.
// 
// Revision 1.6  93/02/23  14:07:04  thoth
// We now have the OtherDI[VP]Iter.  All non-vector, non-const DIs will
// use this.  We may provide a way to override this in the future
// (virtual BaseDI[VP]Iter* BaseDI::iterator() const method?).
// 
// Revision 1.5  93/02/20  12:43:43  thoth
// There are now two sorts of BaseDIIters.
// 
// Revision 1.4  93/02/17  11:00:09  thoth
// fixed the make_x_iter invocations.
// 
// Revision 1.3  93/01/19  14:55:58  jnw
// Modified to support IA_ naming convention
// 
// Revision 1.2  92/11/14  09:39:00  jnw
// Modified to support new function image iterators
// 
// Revision 1.1  92/11/13  13:45:27  jnw
// Initial revision
// 
// Revision 1.1  92/10/05  11:46:31  jnw
// Initial revision
// 
//

#include "DIVIter.h"
#include "ConstDIVIter.h"
#include "VectorDIVIter.h"
#include "OtherDIIter.h"

template <class T>
class IA_errorDIVIter: public IA_BaseDIVIter<T> {
  public:
    IA_errorDIVIter() 
    :IA_BaseDIVIter<T>(0) {}

    virtual IA_BaseDIVIter<T> * clone_self() { 
	ia_throw( IA::IMAGE_REQUIRE_VALUE_ITER, __FILE__, __LINE__);
	return new IA_errorDIVIter;
    }

    virtual int next(T&) { 
	ia_throw( IA::IMAGE_REQUIRE_VALUE_ITER, __FILE__, __LINE__);
	return 0;
    }

    // this method resets the iterator to the beginning of the point set
    virtual void reset() { 
	ia_throw( IA::IMAGE_REQUIRE_VALUE_ITER, __FILE__, __LINE__);
    }

};

//
//
//

template <class T>
IA_DIVIter<T>::IA_DIVIter()
{
    iter = new IA_errorDIVIter<T>;
}

template <class T>
IA_DIVIter<T>& IA_DIVIter<T>::operator=(const IA_DiscreteImage<T> &image)
{
    delete this->iter;

    this->iter = image.bdip->value_iterator();

    return *this;
}

template <class T>
IA_DIVIter<T>& IA_DIVIter<T>::operator=(const IA_DIVIter<T> &x)
{
    if (x.iter==this->iter)
	return *this;

    delete this->iter;

    this->iter = x.iter->clone_self();

    return *this;
}
