#!/local/bin/perl

#
#	Copyright 1993, Center for Computer Vision and Visualization,
#	University of Florida.  All rights reserved.
#

#
# $Log: gen-conv-h.perl,v $
# Revision 1.6  1994/01/31  15:56:13  thoth
# removed cruft.
#
# Revision 1.5  1994/01/07  15:24:40  thoth
# Image class is now CoreImage and named image types are
# Image<P,T>.
#
# Revision 1.4  1993/12/29  17:33:18  thoth
# New operator scheme that prevents the need for trivial Image conversions.
#
# Revision 1.3  1993/11/17  18:39:17  thoth
# template reductions are now supported.
# forward convolutions are now supported.
#
# Revision 1.2  1993/09/21  11:44:15  thoth
# the convolution description files can now have arbitrary
# white space in the operation specifications.
#
# Revision 1.1  93/09/15  13:03:41  thoth
# Initial revision
# 
# Revision 1.2  93/05/27  11:46:09  thoth
# Copyright Notices
# 
# Revision 1.1  93/03/18  11:22:28  thoth
# Initial revision
# 

while (<>) {
    next if /^\s*$/;

    if (/^#/) {
	print "//", $';
	next;
    }

    print "// $_";

    @_ = split;

    $sort = shift(@_);

    if ($sort eq "convolution") {
	local($rtype, $name, $itype, $ttype, @blah) = @_;
	#unless ($ttype =~ m-/-) {die "template type must be of form image/base\n";}
	$titype = "IA_Image<IA_IntPoint,$ttype> ";

	@_ = @blah;

	local($zero);

	while (@_) {
	    $_ = shift(@_);

	    if (/^zero=/) {
		$zero = $';
	    } else {
		warn "Unknown option $_. ";
	    }
	}

	while ($_=<>) {
	    chop;
	    last if $_ eq "end";

	    die "unknown convolution field: $_\n"
		unless (/^(init|accum|accvar|final|forw_init|forw_accumvar):\s*/);
	}

	# backward template convolution
	print "friend ";
	print "IA_Image<IA_IntPoint,$rtype> $name(",
	"const IA_CoreImage<IA_IntPoint,$itype> &img,\n",
	"\t\tconst IA_DDTemplate<$titype> &templ,\n",
	"\t\tIA_Set<IA_IntPoint> dest_ps);\n";
	print "\n";

	print "inline friend ";
	print "IA_Image<IA_IntPoint,$rtype> $name(",
	"const IA_CoreImage<IA_IntPoint,$itype> &img,\n",
	"\t\tconst IA_DDTemplate<$titype> &templ) {\n",
	"    return $name(img, templ, img.domain());\n",
	"}\n";
	print "\n";

	# forward template convolution
	print "friend ";
	print "IA_Image<IA_IntPoint,$rtype> $name(",
	"const IA_DDTemplate<$titype> &templ,\n",
	"\t\tconst IA_CoreImage<IA_IntPoint,$itype> &img,\n",
	"\t\tIA_Set<IA_IntPoint> dest_ps);\n";
	print "\n";

	print "inline friend ";
	print "IA_Image<IA_IntPoint,$rtype> $name(",
	"const IA_DDTemplate<$titype> &templ,\n",
	"\t\tconst IA_CoreImage<IA_IntPoint,$itype> &img) {\n",
	"    return $name(templ, img, img.domain());\n",
	"}\n";
	print "\n";
    } elsif ($sort eq "reduction") {
	local($rtype, $name, $ttype, @blah) = @_;
	$titype = "IA_Image<IA_IntPoint,$ttype> ";

	@_ =  @blah;

	local($zero);

	while (@_) {
	    $_ = shift(@_);

	    if (/^zero=/) {
		$zero = $';
	    } else {
		warn "Unknown option $_. ";
	    }
	}

	while ($_ = <>) {
	    chop;
	    last if $_ eq "end";

	    if (/^accum:\s*/) {
		$accum = $';
	    } else {
		die "unknown reduction field: $_\n";
	    }
	}
	defined $accum || die "no accumulator for reduction $name\n";

	print "friend ";
	print "IA_Image<IA_IntPoint,$rtype> $name(\n",
	"\tIA_IntPointSet domain,\n",
	"\tIA_DDTemplate<$titype > templ,\n",
	"\tIA_IntPointSet dest_domain);\n\n";
    }
}
