// Emacs: -*- C++ -*-

//
//	Copyright 1993, Center for Computer Vision and Visualization,
//	University of Florida.  All rights reserved.
//

static char copyright[] = "Copyright 1993, Center for Computer Vision and Visualization,\nUniversity of Florida.  All rights reserved.\n";

static char ComplexDI_rcsid[] = "$Id: ComplexDI.c,v 1.2 1994/01/07 15:10:00 thoth Exp $";

//
// $Log: ComplexDI.c,v $
// Revision 1.2  1994/01/07  15:10:00  thoth
// Image class is now CoreImage and named image types are
// Image<P,T>.
//
// Revision 1.1  1993/11/29  22:20:39  thoth
// Initial revision
//
//


#include	<math.h>
#include	<fstream.h>
#include	"VectorI.h"
#include	"ConstI.h"
#include	"ClosureI.h"
#include	"ErrorI.h"
#include	"ImageIter.h"
#include	"PSIter.h"
#include	"ComplexDI.h"


//
//
//

#include "restrict.h"

IA_BaseImage<IA_Point<int>,complex> *restrict_toD(const IA_BaseImage<IA_Point<int>, complex> *im, const IA_Set<IA_Point<int> > &ips) {
    return restrictD_toD(im, ips);
}


//
//

template <class T>
inline T max(T a, T b)
{
    return (a<b)?b:a;
}

template <class T>
inline T min(T a, T b)
{
    return (a<b)?a:b;
}

template <class T>
inline T sqr(T v)
{
    return v*v;
}


IA_Image<IA_IntPoint,complex>::
IA_Image(const IA_CoreImage<IA_IntPoint,float> &re,
	 const IA_CoreImage<IA_IntPoint,float> &im)
{
    if(im.domain() != re.domain()) {
	ia_throw( IA::PSET_MISMATCH, __FILE__,__LINE__);
	return;
    }

    const unsigned      sz = re.domain().card();
    complex * const     vec = new complex[sz];
    complex *scan = vec;
    float   re_temp,im_temp;
    IA_IVIter<IA_IntPoint,float>       re_iter(re),im_iter(im);

    while(re_iter(re_temp) && im_iter(im_temp)) {
        *(scan++) = complex(re_temp,im_temp);
    }

    disassociate_image();
    set_and_reference_image(new IA_VectorI<IA_IntPoint,complex>
			    (re.domain(), vec, sz, 1));
}

#include "ComplexImageOps.c"

//
//
//

class blah : public IA_ClosureI<IA_IntPoint,complex> {
  public:
    blah() 
    :IA_ClosureI<IA_IntPoint,complex>(IA_IntPointSet()) {}
    ostream &print_this(ostream &o) const { return o;}
    complex operator()(const IA_IntPoint &) const { return 0; }
    IA_ClosureI<IA_IntPoint,complex>* clone_self() const { return 0; }
};
static void dummy001()
{
    IA_IntPoint		ip;
    IA_IntPointSet	ps;
    IA_Image<IA_IntPoint,complex>	i1;
    IA_Image<IA_IntPoint,complex>
	i2(i1),
	i3(ps,0.0),
	i4(ps, (complex*)0, 0, 1),
	i5(ps, (complex*)0, 0),
	i6(blah()),
	i7(ps, (complex(*)(const IA_IntPoint&))0),
	i10(IA_CoreImage<IA_IntPoint, complex>());
    i1 = i1.restrict(i2.range());
    i1 = i1.translate(ip);
    (IA_CoreImage<IA_IntPoint, complex>&)i1 = 2;
    (void)i1.type();
    i1[ip] = i1(ip);
    i1 = i1.restrict(i2.domain());
    (void)i1.extend(i2);
    (void)i1.reduce((complex (*)(const complex&,const complex&)) 0, 0);
    (void)i1.reduce((complex (*)( complex, complex)) 0, 0);
    cout << (IA_CoreImage<IA_IntPoint, complex>&)i1;

#if 0
    IA_Image<IA_IntPoint,complex>::read_IAA("");
    IA_Image<IA_IntPoint,complex>::read_IAA("","");

    i1.write_IAA("");
    i1.write_IAA("","");
#endif

    IA_IVIter<IA_IntPoint,complex>	iter1(i1), iter2;
    IA_IPIter<IA_IntPoint,complex>	iter3(i2), iter4;
    iter1 = iter2;
    iter3 = iter4;

    compose(i1, (IA_IntPoint(*)(const IA_IntPoint&))0);
    compose(i1, *(IA_Closure<IA_IntPoint, IA_IntPoint>*)0);
    compose((complex(*)(complex))0, i1);
    compose((complex(*)(complex))0, (IA_CoreImage<IA_IntPoint, complex>&)i1);
//    compose((u_char(*)(complex))0, i1, (u_char*)0);

    IA_ValueSet<complex>	vs(i1.range());
    // I shouldn\'t have to do the following two lines
    // vs.value_type_compare(0,0);
}

