// Emacs: -*- C++ -*-

//
//	Copyright 1993, Center for Computer Vision and Visualization,
//	University of Florida.  All rights reserved.
//


//
// $Log: ClosureI.h,v $
// Revision 1.3  1993/11/17  18:12:47  thoth
// extensivep is now extensive
//
// Revision 1.2  1993/10/05  19:33:08  thoth
// Move to new Closure naming convention.
//
// Revision 1.1  1993/09/15  12:56:25  thoth
// Initial revision
//

#ifndef ClosureI_h_
#define ClosureI_h_

#include "BaseI.h"

// This class is designed for a user to derive from.

// The user must provide an operator() that maps a point
// from the image\'s domain onto the value at that point.
// The user must also provide a clone_self method which
// is needed by the container class.

template < class P,class T>
class IA_ClosureI: public IA_BaseImage<P,T> {
 public:
    static char dummy;
 public:
    IA_ClosureI(IA_Set<P> ps_) :IA_BaseImage<P,T>(ps_) {}

    // most user-defined images will be non-extensive
    int extensive() const { return 0; }

    static IA_ImageType s_type() { return &dummy; }

    IA_ImageType type() const { return &dummy; }

    ostream &print_this(ostream&) const;

    // Return a pointer to a copy of yourself on the heap.
    // If you do this wrong, images implemented using the
    // derived class will NOT work.
    virtual IA_ClosureI<P,T>* clone_self() const = 0;

    ////////////////////////////////////////////////////////////////
    // derived class MUST provide:
    // T operator()(const P&) const;
    // IA_ClosureI<P,T>* clone_self() const;

    // recommended:
    // ostream &print_this(ostream&) const;

    // perhaps (if you can do them faster...):
    // IA_ValueSet<T> range() const;
    // IA_BaseImage<P,T>* clone_self_extensively() const;

    // and if you want to be extensive:
    // T &operator[](const P&);
    // int extensive() const { return 1; }
};

#endif
