// Emacs: -*- C++ -*-

//
//	Copyright 1994, Center for Computer Vision and Visualization,
//	University of Florida.  All rights reserved.
//


//
// $Log: RGBDI.h,v $
// Revision 1.3  1994/08/22  15:20:29  thoth
// DOS-inspired name rework.
//
// Revision 1.2  1994/07/25  17:26:39  thoth
// Name sanitization
//
// Revision 1.1  1994/03/02  14:01:28  jnw
// Initial revision
//
// 

#ifndef RGBDI_h_
#define RGBDI_h_

#include <sys/types.h>
#include "IntPoint.h"
#include "CoreImage.h"
#include "RGB.h"

#define SUPPRESS_INCLUDE
#include "Image.h"
#undef SUPPRESS_INCLUDE

class IA_Image<IA_Point<int>,IA_RGB>: public IA_CoreImage<IA_Point<int>,IA_RGB>
{
  public:
    IA_Image():IA_CoreImage<IA_Point<int>,IA_RGB>() {}

    IA_Image(const IA_Image<IA_Point<int>,IA_RGB>& im)
    :IA_CoreImage<IA_Point<int>,IA_RGB>(im) {}

    IA_Image(IA_Set<IA_Point<int> > ps, IA_RGB value)
    :IA_CoreImage<IA_Point<int>,IA_RGB>(ps,value) {}

    IA_Image(IA_Set<IA_Point<int> > ps, IA_RGB *vp, unsigned sz,
			int giveaway=0)
    :IA_CoreImage<IA_Point<int>,IA_RGB>(ps, vp, sz, giveaway) {}

    IA_Image(IA_Set<IA_Point<int> > ps, const IA_RGB *vp, unsigned sz)
    :IA_CoreImage<IA_Point<int>,IA_RGB>(ps, vp, sz) {}

    IA_Image(const IA_Point<int> *pp, unsigned plen, IA_RGB *vp, unsigned vlen,
	     int giveaway=0)
    :IA_CoreImage<IA_Point<int>,IA_RGB>(pp, plen, vp, vlen, giveaway) {}

    IA_Image(const IA_Point<int> *pp, unsigned plen, const IA_RGB *vp,
	     unsigned vlen)
    :IA_CoreImage<IA_Point<int>,IA_RGB>(pp, plen, vp, vlen) {}

    IA_Image(const IA_ClosureI<IA_Point<int>,IA_RGB> &img)
    :IA_CoreImage<IA_Point<int>,IA_RGB>(img) {}

    IA_Image(IA_Set<IA_Point<int> > ps, IA_RGB (*f)(const IA_Point<int>&))
    :IA_CoreImage<IA_Point<int>,IA_RGB>(ps,f) {}

    IA_Image( const IA_CoreImage<IA_Point<int>,IA_RGB> &d)
    :IA_CoreImage<IA_Point<int>,IA_RGB>(d) {}

    virtual ~IA_Image(){ }

    IA_Image& operator=(IA_RGB v) {
	(IA_CoreImage<IA_Point<int>,IA_RGB>&)*this = v;
	return *this;
    }

#include	"RGBIOps.h"

    static IA_Image read_PPM(istream &, int *maxval=0);
    static IA_Image read_PPM(const char *fname, int *maxval=0);

    ostream& write_PPM(ostream &, unsigned) const;
    ostream& write_PPM(ostream &) const;
    void write_PPM(const char *fname, unsigned) const;
    void write_PPM(const char *fname) const;
};

inline int operator!=(const IA_CoreImage<IA_Point<int>,IA_RGB> &lhs,
	       const IA_CoreImage<IA_Point<int>,IA_RGB> &rhs) {
    return ! (lhs == rhs);
}
inline int operator!=(const IA_CoreImage<IA_Point<int>,IA_RGB> &lhs, int rhs) {
    return ! (lhs == rhs);
}
inline int operator!=(int lhs, const IA_CoreImage<IA_Point<int>,IA_RGB> &rhs) {
    return ! (rhs == lhs);
}

//
//

inline ostream& write_PPM(const IA_CoreImage<IA_Point<int>,IA_RGB> &im, ostream &o, unsigned max) {
    return IA_Image<IA_Point<int>,IA_RGB>(im).write_PPM(o, max);
}

inline ostream& write_PPM(const IA_CoreImage<IA_Point<int>,IA_RGB> &im, ostream &o) {
    return IA_Image<IA_Point<int>,IA_RGB>(im).write_PPM(o);
}

inline void write_PPM(const IA_CoreImage<IA_Point<int>,IA_RGB> &im, const char *fname) {
    IA_Image<IA_Point<int>,IA_RGB>(im).write_PPM(fname);
}

inline void write_PPM(const IA_CoreImage<IA_Point<int>,IA_RGB> &im,
		      const char *fname, unsigned max) {
    IA_Image<IA_Point<int>,IA_RGB>(im).write_PPM(fname, max);
}

//
//

// compiler clue to allow inexact matches on a function template
ostream& operator <<(ostream&, const IA_CoreImage<IA_Point<int>,IA_RGB>&);


#endif
