// Emacs: -*- C++ -*-

//
//	Copyright 1993, Center for Computer Vision and Visualization,
//	University of Florida.  All rights reserved.
//


//
// $Log: FloatCI.h,v $
// Revision 1.6  1994/09/22  16:58:30  thoth
// Added a 0-argument constructor.
//
// Revision 1.5  1994/08/22  15:20:29  thoth
// DOS-inspired name rework.
//
// Revision 1.4  1994/07/25  17:26:39  thoth
// Name sanitization
//
// Revision 1.3  1994/01/31  15:44:34  thoth
// added new constructor from float(*)(IA_Point<double>).
// added operator=(FCI).
//
// Revision 1.2  1994/01/07  15:10:00  thoth
// Image class is now CoreImage and named image types are
// Image<P,T>.
//
// Revision 1.1  1993/10/20  18:58:47  thoth
// Initial revision
//

#ifndef FloatCI_h_
#define FloatCI_h_

#include "CoreImage.h"
#include "DblPS.h"

#define SUPPRESS_INCLUDE
#include "Image.h"
#undef SUPPRESS_INCLUDE

class IA_Image<IA_Point<double>,float>
: public IA_CoreImage<IA_Point<double>,float> {
public:
    IA_Image<IA_Point<double>,float>()
	:IA_CoreImage<IA_Point<double>,float>() { }
    IA_Image(const IA_Image<IA_Point<double>,float> &fci)
	:IA_CoreImage<IA_Point<double>,float>(fci) { }
    IA_Image(const IA_CoreImage<IA_Point<double>,float> &fci)
	:IA_CoreImage<IA_Point<double>,float>(fci) { }
    IA_Image(IA_Set<IA_Point<double> > ps, float value)
	:IA_CoreImage<IA_Point<double>,float>(ps,(float)value) {}
    IA_Image(IA_Set<IA_Point<double> > ps, float *vp, unsigned sz,
	     int giveaway=0)
	:IA_CoreImage<IA_Point<double>,float>(ps, vp, sz, giveaway) {}

    IA_Image(const IA_ClosureI<IA_Point<double>,float>& i)
	:IA_CoreImage<IA_Point<double>,float>(i) { }

    IA_Image(IA_Set<IA_Point<double> > ps, float (*f)(const IA_Point<double>&))
	:IA_CoreImage<IA_Point<double>,float>(ps,f) {}

    IA_Image(IA_Set<IA_Point<double> > ps, float (*f)(IA_Point<double>))
	:IA_CoreImage<IA_Point<double>,float>(ps,f) {}

    virtual ~IA_Image(){ }

    IA_Image& operator =(const IA_CoreImage<IA_Point<double>,float> &arg) {
	(IA_CoreImage<IA_Point<double>,float>&)*this = arg;
	return *this;
    }
    
    IA_Image<IA_Point<double>,float>& operator=(float v) {
	float	temp=v;		// workaround CFront problem
	(IA_CoreImage<IA_Point<double>,float>&)*this = temp;
	return *this;
    }
};

#endif
