// Emacs -*- C++ -*-

//
//	Copyright 1994, Center for Computer Vision and Visualization,
//	University of Florida.  All rights reserved.
//

//
// $Log: BSetIter.h,v $
// Revision 1.1  1994/10/03  21:01:43  thoth
// Initial revision
//

#ifndef BSetIter_h_
#define BSetIter_h_

#include "BaseSet.h"
#include <stdlib.h>

template <class T>
class IA_BaseSetIter {

private:			// I'll have none of this:
    IA_BaseSetIter<T>& operator=(const IA_BaseSetIter<T> &) {
	abort();
	return *this;
    }

protected:
    IA_BaseSet<T> * const	domain;

public:

    // this class may only be used with BaseSets that are allocated on
    // the heap and refcounted.

    IA_BaseSetIter(IA_BaseSet<T> *set);

    IA_BaseSetIter(const IA_BaseSetIter<T> &iter);

    virtual ~IA_BaseSetIter();

    virtual IA_BaseSetIter<T> * clone_self() const = 0;

    virtual int next( T &)=0;

    virtual void reset()=0;
    IA_BaseSet<T> *domain_() const { return this->domain; }
};

#endif // BSetIter_h_
