// closure-median-nbhd.c Section: 2.8  Median Filter
//      Copyright 1994, Center for Computer Vision and Visualization,
//      University of Florida.  All rights reserved.
// Force instantiantion of the median functions.


#include "median.h"
#include "median-gamma.h"
#include "shaped-pointset.h"


///////////////////////////////////////////////////////////////////

int main() {
    
    // Force the instantiation of the median_gamma() functions...
    u_char u[1]; u[0] = 0;
    int    i[1]; i[0] = 0;
    float  f[1]; f[0] = 0;

    u[0] = median_gamma( u, (unsigned int) 1 );
    i[0] = median_gamma( i, (unsigned int) 1 );
    f[0] = median_gamma( f, (unsigned int) 1 );


    // Force the instantiation of the median() functions ...
    IA_Image<IA_Point<int>,u_char>
	udi = read_uchar_PGM(cin);

    IA_Image<IA_Point<int>,int>   idi( udi );
    IA_Image<IA_Point<int>,float> fdi( udi );


    IA_Point<int>  origin( 0 );
    IA_Set<IA_Point<int> >
	median_ps( digital_disc( origin, (unsigned int) 0 ) );

    IA_Neighborhood<IA_Point<int>,IA_Point<int> >
	median_nbhd( 1, median_ps );

    median( udi, median_nbhd ).write_PGM(cout);
    median( idi, median_nbhd ).write_PGM(cout);

    udi = to_uchar( median( fdi, median_nbhd ) );
    udi.write_PGM(cout);

    return 0;
}
