// Emacs -*- C++ -*-

//
//	Copyright 1993, Center for Computer Vision and Visualization,
//	University of Florida.  All rights reserved.
//

//
// $Log: set_errors.h,v $
// Revision 1.1.1.1  1994/12/08  14:53:50  thoth
// Extra classes to pick up slack from throw conversion.
//
// Revision 1.1  1994/09/20  19:30:33  thoth
// Initial revision
//

#ifndef set_errors_h_
#define set_errors_h_

struct Set_Require_Extensive_Exception : public GenericException {
    Set_Require_Extensive_Exception(const char *fn, int l)
	:GenericException ("Set: operation requires an extensive set", fn, l)
	    {}
};

struct Set_Empty_Exception : public GenericException {
    Set_Empty_Exception(const char *fn, int l) 
	:GenericException("Set: attempt to pick element from empty set", fn, l)
	    {}
};

#endif // set_errors_h_
