// Emacs: -*- C++ -*-

//
//	Copyright 1993, Center for Computer Vision and Visualization,
//	University of Florida.  All rights reserved.
//

static char copyright[] = "Copyright 1993, Center for Computer Vision and Visualization,\nUniversity of Florida.  All rights reserved.\n";

static char closure_c_rcsid[] = "$Id: closure.c,v 1.13.1.2 1994/12/08 14:50:08 thoth Exp $";

//
// $Log: closure.c,v $
// Revision 1.13.1.2  1994/12/08  14:50:08  thoth
// individual comparators are gone from Valueset.
// throw of enumerated type is obsolete.
//
// Revision 1.13.1.1  1994/10/19  15:14:13  thoth
// Instantiate new Function and Closure sets.
// Instantiate iterators.
//
// Revision 1.13  1994/10/03  17:57:22  thoth
// Added iterators.
// removed the binary ops between Sets and scalars since they were
// inaccessible to users and unused by the IA_Set class.
//
// Revision 1.12  1994/08/22  15:10:59  thoth
// DOS-inspired name rework
//
// Revision 1.11  1994/07/25  16:45:35  thoth
// Name sanitization.
//
// Revision 1.10  1994/04/26  18:08:17  thoth
// Added compare function between Sets.
//
// Revision 1.9  1994/03/14  15:36:05  thoth
// Set is now the primary entity in this package.
//
// Revision 1.8  1994/01/31  16:35:07  thoth
// We now have ValueSets of IA_Bits.
//
// Revision 1.7  1993/11/17  17:58:49  thoth
// added complex, removed char and double for now.
// Pointcmp is now pointcmp.
//
// Revision 1.6  1993/09/15  12:28:54  thoth
// ValueSet<double>
//
// Revision 1.5  93/08/18  16:56:25  thoth
// added support for ValueSet<char> so that bit image work can continue.
// 
// Revision 1.4  93/06/10  17:10:05  thoth
// more placebos for 3.0.1
// 
// Revision 1.3  93/05/26  16:32:09  thoth
// Copyright Notices
// 
// Revision 1.2  93/05/26  13:49:04  thoth
// add the ValueSet<FloatPoint> for FloatPointSet
// 
// Revision 1.1  93/04/17  20:16:48  thoth
// Initial revision
// 
//

#include <sys/types.h>
#include <iostream.h>
#include <complex.h>
#include "DblPoint.h"
#include "Bit.h"
#include "RGB.h"
#define SUPPRESS_INCLUDE
#include "Set.h"
#include "SetIter.h"
#include "ValueSet.h"
#include "ClosureSet.h"

template <class T>
class spam: public IA_ClosureSet<T> {
public:
    IA_ClosureSet<T> *clone_self() const {
	return new spam<T>(*this);
    }
    int contains(T) const { return 0; }
    IA::Type type() const { return 0; }
};

#define exercise_Set(T)				\
static void nothing(T *)			\
{						\
  IA_Set<T>	vs0,vs1(1),vs2(1,2);		\
  IA_Set<T>	vs3(1,2,3),vs4(1,2,3,4);	\
  IA_Set<T>	vs5(1,2,3,4,5);			\
  IA_Set<T>	vs6((int(*)(T))0);		\
  IA_Set<T>	vs7((int(*)(const T&))0);	\
  IA_Set<T>	vs8(spam<T>());	\
  T	temp;					\
						\
  vs1=vs2;					\
  (void)vs1.contains(vs1.min());		\
  (void)vs2.contains(vs2.max());		\
  (void)vs2.empty();				\
						\
  (void)(vs1&vs2);				\
  (void)(vs1|vs2);				\
  (void)(vs1/vs2);				\
  (void)(vs1^vs2);				\
						\
  (void)(vs1&temp);				\
  (void)(vs1|temp);				\
  (void)(vs1/temp);				\
  (void)(vs1^temp);				\
						\
  (void)(temp&vs1);				\
  (void)(temp|vs1);				\
  (void)(temp/vs1);				\
  (void)(temp^vs1);				\
						\
  (void)compare(vs1,vs2);			\
						\
  (void) (vs1 <  vs2);				\
  (void) (vs1 <= vs2);				\
  (void) (vs1 == vs2);				\
  (void) (vs1 != vs2);				\
  (void) (vs1 >= vs2);				\
  (void) (vs1 >  vs2);				\
						\
  (void) (vs1 <  temp);				\
  (void) (vs1 <= temp);				\
  (void) (vs1 == temp);				\
  (void) (vs1 != temp);				\
  (void) (vs1 >= temp);				\
  (void) (vs1 >  temp);				\
						\
  (void) (temp <  vs2);				\
  (void) (temp <= vs2);				\
  (void) (temp == vs2);				\
  (void) (temp != vs2);				\
  (void) (temp >= vs2);				\
  (void) (temp >  vs2);				\
  /*cout << vs1;*/				\
						\
  IA_SetIter<T>	iter1, iter2(vs2), iter3(iter2);\
  iter1 = vs1;					\
  iter1 = iter2;				\
  iter1.domain();				\
  iter1(temp);					\
  iter1.reset();				\
}

#define exercise_VS(T)				\
static void nothing(T *)			\
{						\
  IA_ValueSet<T>	vs1,vs2(1,2,3,4,5);	\
  T	temp;					\
						\
  vs1=vs2;					\
  (void)vs1.contains(vs1.min());		\
  (void)vs2.contains(vs2.max());		\
  (void)vs2.empty();				\
  (void)vs2.iterator();				\
						\
  (void)(vs1&vs2);				\
  (void)(vs1|vs2);				\
  (void)(vs1/vs2);				\
  (void)(vs1^vs2);				\
				/*		\
  (void)(vs1&temp);				\
  (void)(vs1|temp);				\
  (void)(vs1/temp);				\
  (void)(vs1^temp);				\
						\
  (void)(temp&vs1);				\
  (void)(temp|vs1);				\
  (void)(temp/vs1);				\
  (void)(temp^vs1);		*/		\
						\
  (void)compare(vs1,vs2);			\
						\
  /*(void) (vs1 <  vs2);				\
  (void) (vs1 <= vs2);				\
  (void) (vs1 == vs2);				\
  (void) (vs1 != vs2);				\
  (void) (vs1 >= vs2);				\
  (void) (vs1 >  vs2);				\
						\
  (void) (vs1 <  temp);				\
  (void) (vs1 <= temp);				\
  (void) (vs1 == temp);				\
  (void) (vs1 != temp);				\
  (void) (vs1 >= temp);				\
  (void) (vs1 >  temp);				\
						\
  (void) (temp <  vs2);				\
  (void) (temp <= vs2);				\
  (void) (temp == vs2);				\
  (void) (temp != vs2);				\
  (void) (temp >= vs2);				\
  (void) (temp >  vs2);		*/		\
  cout << vs1;					\
}

exercise_Set(int)
exercise_Set(IA_Bit)
exercise_Set(u_char)
//exercise_Set(char)
exercise_Set(float)
//exercise_Set(double)
exercise_VS(IA_Point<double>)
exercise_Set(complex)
exercise_Set(IA_RGB)

void dummy()
{
  nothing((int*)0);
  nothing((IA_Bit*)0);
  nothing((u_char*)0);
//  nothing((char*)0);
  nothing((float*)0);
  nothing((IA_Point<double>*)0);
//  nothing((double*)0);
  nothing((complex*)0);
  nothing((IA_RGB*)0);
}

// pacify the cowardly template instantiator

ostream &operator<<(ostream&o,const IA_Point<double>&)
{
    return o;
}


IA_Point<double>::IA_Point(const IA_Point<double>&) { }


int pointcmp(const IA_Point<double>&, const IA_Point<double>&) {
  return 0;
}

int IA_Point<double>::operator< (const IA_Point<double>&) const { return 0; }
int IA_Point<double>::operator> (const IA_Point<double>&) const { return 0; }
IA_Point<double>& IA_Point<double>::operator= (const IA_Point<double>&) { return *this; }
int IA_Point<double>::operator!= (const IA_Point<double>&) const { return 0; }
int IA_Point<double>::operator== (const IA_Point<double>&) const { return 0; }

ostream & operator<<(ostream&o, complex) {
    return o;
}

//void ia_throw(IA::Error, char*, int) { }
void ia_throw(const IA::Exception&) { }
void IA::not_yet_implemented(char*, int) { }

ostream&
GenericException::diagnose ( ostream&o ) const { return o; }

int main()
{
    return 0;
}
