// Emacs -*- C++ -*-

//
//	Copyright 1994, Center for Computer Vision and Visualization,
//	University of Florida.  All rights reserved.
//

//
// $Log: VSIter.h,v $
// Revision 1.1  1994/10/03  21:01:43  thoth
// Initial revision
//

#ifndef VSIter_h_
#define VSIter_h_

#include "ValueSet.h"
#include "BSetIter.h"

template <class T>
class IA_ValueSetIter :
public IA_BaseSetIter<T> {

    // just to speed member accesses
    const IA_ValueSet<T> *vsp() const {
	return (const IA_ValueSet<T>*) domain;
    }

    int	idx;

public:
    IA_ValueSetIter(IA_ValueSet<T> *set)
	:IA_BaseSetIter<T>(set) { idx=0; }
    // default copy constructor is just fine

    IA_BaseSetIter<T> * clone_self() const ;

    int curr( T & ) const;
    int done() const;
    int next();
    int next( T & );
    void reset();
};

#endif // VSIter_h_
