// Emacs: -*- C++ -*-

//
//	Copyright 1993, Center for Computer Vision and Visualization,
//	University of Florida.  All rights reserved.
//

// 
// $Log: BoxyIPSIter.h,v $
// Revision 1.10  1994/07/25  16:58:52  thoth
// \Name sanitization
//
// Revision 1.9  1994/03/30  13:47:16  thoth
// Renamed files to BasePSIter.
//
// Revision 1.8  1993/07/15  11:39:38  thoth
// new BasePSIter implementation.
//
// Revision 1.7  93/05/26  16:41:07  thoth
// Copyright Notices.
// 
// Revision 1.6  92/12/16  14:48:01  thoth
// conversion to IA_ mostly complete
// 
// Revision 1.5  92/08/23  13:30:02  thoth
// CFrontified version
// 
// 

#ifndef BoxyIPSIter_h_
#define BoxyIPSIter_h_

#ifdef IA_PRII
#pragma interface
#endif

#include "BasePSIter.h"
#include "BoxyIPS.h"

/*
   Iterator for the BoxyPointSet class.
 */

class IA_BoxyIPSIter: public IA_BasePSIter<IA_Point<int> > {
    // This data member stores the current position of the iterator.
    // It is set to the minimum point in the BoxyIPS upon construction
    // and upon invocation of the reset() method.
    IA_Point<int> curr;
    // invariant:
    // While the iterator is still scanning the
    // point set: BoxyIPS.contains(curr).

    IA_BoxyIPS *box() const { return (IA_BoxyIPS*)domain; }

public:
    IA_BoxyIPSIter(IA_BoxyIPS *);
    IA_BoxyIPSIter(const IA_BoxyIPSIter &);
    ~IA_BoxyIPSIter() { }

    IA_BasePSIter<IA_Point<int> > *clone_self() { return new IA_BoxyIPSIter(*this); }
    int next(IA_Point<int>&);
    void reset() { this->curr = box()->start; }
};

#endif
