// Emacs -*- C++ -*-

//
//	Copyright 1993, Center for Computer Vision and Visualization,
//	University of Florida.  All rights reserved.
//

//
// $Log: image_errors.h,v $
// Revision 1.3.1.1  1994/12/28  17:24:53  thoth
// lots of errors to replace obsolete throw of enums.
//
// Revision 1.3  1994/03/30  14:01:31  thoth
// New exception for ErrorDT.
//
// Revision 1.2  1994/01/31  15:58:06  thoth
// New error class for bad transposes.
//
// Revision 1.1  1993/12/29  15:44:32  thoth
// Initial revision
//

#ifndef image_errors_h_
#define image_errors_h_

struct Image_Uninitialized_Exception : public GenericException {
  Image_Uninitialized_Exception(const char *fn, int l)
    :GenericException
      ("Image: operation attempted on uninitialized image", fn, l) {}
};

struct Image_DomainMismatch_Exception : public GenericException {
  Image_DomainMismatch_Exception(const char *fn, int l)
    :GenericException
      ("Image: domain(pointset) mismatch in arguments to binary operation", fn, l) {}
};

struct Image_RequireExtensive_Exception : public GenericException {
  Image_RequireExtensive_Exception(const char *fn, int l)
    :GenericException
      ("Image: operation requires extensive image", fn, l) {}
};

struct Image_PNMIO_Exception : public GenericException {
  Image_PNMIO_Exception(const char *fn, int l)
    :GenericException
      ("Image: Error during PNM I/O", fn, l) {}
};

struct Image_PointOutsideDomain_Exception : public GenericException {
  Image_PointOutsideDomain_Exception(const char *fn, int l)
    :GenericException
      ("Image: point outside image domain", fn, l) {}
};

struct Image_PointsetTooSmall_Exception : public GenericException {
  Image_PointsetTooSmall_Exception(const char *fn, int l)
    :GenericException
      ("Image: list of points is empty in dual vector constructor", fn, l) {}
};

struct Image_VectorConstructorSizeMismatch_Exception : public GenericException {
  Image_VectorConstructorSizeMismatch_Exception(const char *fn, int l)
    :GenericException
      ("Image: domain/valuearray size mismatch", fn, l) {}
};

#if 0
struct Image__Exception : public GenericException {
  Image__Exception(const char *fn, int l)
    :GenericException
      ("Image: ", fn, l) {}
};
#endif

struct Image_BadTranspose_Exception : public GenericException {
  Image_BadTranspose_Exception(const char *fn, int l)
    :GenericException
      ("Image: attempt to transpose a non-boxy or non-2-D image", fn, l) {}
};

//

struct ImageIter_Uninitialized_Exception : public GenericException {
  ImageIter_Uninitialized_Exception(const char *fn, int l)
    :GenericException
      ("ImageIter: operation attempted on uninitialized image", fn, l) {}
};

//

struct Template_Uninitialized_Exception : public GenericException {
  Template_Uninitialized_Exception(const char *fn, int l)
    :GenericException
      ("Template: attempt to perform operation on uninitialized object", fn, l) {}
};

struct Template_DimensionMismatch2_Exception : public GenericException {
  Template_DimensionMismatch2_Exception(const char *fn, int l)
    :GenericException
      ("Template: Dimension Mismatch in binary operation", fn, l) {}
};

//

struct Neighborhood_DimensionMismatch2_Exception : public GenericException {
  Neighborhood_DimensionMismatch2_Exception(const char *fn, int l)
    :GenericException
      ("Neighborhood: Dimension Mismatch in binary operation", fn, l) {}
};

#endif // image_errors_h_
