// Emacs -*- C++ -*-

// Machine generated include file, do not modify.


// 	Copyright 1993, Center for Computer Vision and Visualization,
// 	University of Florida.  All rights reserved.


//  $Log: int-operations.desc,v $
//  Revision 1.9.1.2  1995/01/31  16:02:40  thoth
//  Need to replace the upward conversions with something...

//  Revision 1.9.1.1  1994/12/28  17:56:27  thoth
//  Conversion to operations table.
//  image operations are now friendly with FBI.
//  new sgn() function.

//  Revision 1.9  1994/12/19  19:58:48  ljr
//  DOS-inspired name rework.

//  Revision 1.8  1994/05/17  12:54:56  thoth
//  Improved operations generation scheme.  Lines from the op.desc file can
//  be quoted into the .c file to allow inclusion of infrastructure.  Also
//  the op.desc output can be redirected to several files.  The prefix
//  directive allows common information (include files) to be included in
//  every generated source file.

//  Integer operations for the Int Discrete Image
#include "IntDI.h"
#include "VectorI.h"
#include "ConstI.h"
#include "ImageIter.h"
#include "FBI.h"
#include "../valueset/OpTable.h"
//////////////////////////////////////////////////////////////////////
//
// Begin operation support routines for :
// binary pointwise non-commutative operator- I(int) I(int) I(int)
//
#ifndef BOT_int_int_int_operatorIAOPmn
#define BOT_int_int_int_operatorIAOPmn
IA_BinaryOperationsTable<IA_BaseImage<IA_Point<int>, int>*,
	IA_BaseImage<IA_Point<int>, int>,
	IA_BaseImage<IA_Point<int>, int> >
	*IA_Image_IP_int_int_int_operatorIAOPmn_tbl;

void IA_fill_Image_IP_int_int_int_operatorIAOPmn_tbl();

#endif // BOT_int_int_int_operatorIAOPmn
IA_Image<IA_Point<int>, int>
operator- ( const IA_Image<IA_Point<int>, int> &lhs,
		const IA_Image<IA_Point<int>, int> &rhs)
{
    if (lhs.domain() != rhs.domain()) {
	 IA_Image<IA_Point<int>, int>	rval;
	ia_throw(Image_DomainMismatch_Exception(__FILE__,__LINE__));
	return rval;
    }

    if (!IA_Image_IP_int_int_int_operatorIAOPmn_tbl)
	IA_fill_Image_IP_int_int_int_operatorIAOPmn_tbl();

    IA_BaseImage<IA_Point<int>, int>*(*f)( IA_BaseImage<IA_Point<int>, int> &,
		IA_BaseImage<IA_Point<int>, int> &);
    f = IA_Image_IP_int_int_int_operatorIAOPmn_tbl->lookup_operation
	(lhs.type(), rhs.type());
    IA_BaseImage<IA_Point<int>,int>	&basel = *IA_FBI<IA_Point<int>,IA_Point<int>, int,int,int>
	    ::extract_baseptr(lhs);
    IA_BaseImage<IA_Point<int>,int>	&baser = *IA_FBI<IA_Point<int>,IA_Point<int>, int,int,int>
	    ::extract_baseptr(rhs);
    return IA_Image<IA_Point<int>,int>
	(IA_FBI<IA_Point<int>,IA_Point<int>, int,int,int>
	 ::make_Image(	 f(basel,baser)));
}

//
//
//

static IA_BaseImage<IA_Point<int>, int> *
vec_vec_bo_operatorIAOPmn(IA_BaseImage<IA_Point<int>, int> &lhs_,
	IA_BaseImage<IA_Point<int>, int> &rhs_)
{
    const IA_Set<IA_Point<int> > domain = lhs_.domain();
    const unsigned sz = domain.card();
    int *const vec = new int[sz];

    {
	int *ds = vec;
	IA_VectorI<IA_Point<int>, int> *lhs
		= (IA_VectorI<IA_Point<int>, int> *)&lhs_;
	const int *ls = lhs->vec;
	IA_VectorI<IA_Point<int>, int> *rhs
		= (IA_VectorI<IA_Point<int>, int> *)&rhs_;
	const int *rs = rhs->vec;
	for (unsigned i=0; i<sz; i++) {
	    *(ds++) = ( (*ls) - (*rs) );
	    ls++;
	    rs++;
	}
    }
    return new IA_VectorI<IA_Point<int>, int>(domain, vec, sz, 1);
}

#ifndef vec_scalar_int_int_int_operatorIAOPmn
#define vec_scalar_int_int_int_operatorIAOPmn
static IA_BaseImage<IA_Point<int>, int> *
vec_scalar_bo_operatorIAOPmn(IA_BaseImage<IA_Point<int>, int> &lhs_,
	IA_BaseImage<IA_Point<int>, int> &rhs_)
{
    const IA_Set<IA_Point<int> > domain = lhs_.domain();
    const unsigned sz = domain.card();
    int *const vec = new int[sz];

    {
	int *ds = vec;
	IA_VectorI<IA_Point<int>, int> *lhs
		= (IA_VectorI<IA_Point<int>, int> *)&lhs_;
	const int *ls = lhs->vec;
	IA_ConstI<IA_Point<int>, int> *rhs
		= (IA_ConstI<IA_Point<int>, int> *)&rhs_;
	for (unsigned i=0; i<sz; i++) {
	    *(ds++) = ( (*ls) - (rhs->value) );
	    ls++;
	}
    }
    return new IA_VectorI<IA_Point<int>, int>(domain, vec, sz, 1);
}
#endif // vec_scalar_int_int_int_operatorIAOPmn

static IA_BaseImage<IA_Point<int>, int> *
vec_iter_bo_operatorIAOPmn(IA_BaseImage<IA_Point<int>, int> &lhs_,
	IA_BaseImage<IA_Point<int>, int> &rhs_)
{
    const IA_Set<IA_Point<int> > domain = lhs_.domain();
    const unsigned sz = domain.card();
    int *const vec = new int[sz];

    {
	int *ds = vec;
	IA_VectorI<IA_Point<int>, int> *lhs
		= (IA_VectorI<IA_Point<int>, int> *)&lhs_;
	const int *ls = lhs->vec;
	int rtmp;
	IA_BaseIVIter<IA_Point<int>, int>	*riter = rhs_.value_iterator();
	for (unsigned i=0; i<sz; i++) {
	    riter->next(rtmp);
	    *(ds++) = ( (*ls) - (rtmp) );
	    ls++;
	}
	delete riter;
    }
    return new IA_VectorI<IA_Point<int>, int>(domain, vec, sz, 1);
}

#ifndef scalar_vec_int_int_int_operatorIAOPmn
#define scalar_vec_int_int_int_operatorIAOPmn
static IA_BaseImage<IA_Point<int>, int> *
scalar_vec_bo_operatorIAOPmn(IA_BaseImage<IA_Point<int>, int> &lhs_,
	IA_BaseImage<IA_Point<int>, int> &rhs_)
{
    const IA_Set<IA_Point<int> > domain = lhs_.domain();
    const unsigned sz = domain.card();
    int *const vec = new int[sz];

    {
	int *ds = vec;
	IA_ConstI<IA_Point<int>, int> *lhs
		= (IA_ConstI<IA_Point<int>, int> *)&lhs_;
	IA_VectorI<IA_Point<int>, int> *rhs
		= (IA_VectorI<IA_Point<int>, int> *)&rhs_;
	const int *rs = rhs->vec;
	for (unsigned i=0; i<sz; i++) {
	    *(ds++) = ( (lhs->value) - (*rs) );
	    rs++;
	}
    }
    return new IA_VectorI<IA_Point<int>, int>(domain, vec, sz, 1);
}
#endif // scalar_vec_int_int_int_operatorIAOPmn

#ifndef scalar_scalar_int_int_int_operatorIAOPmn
#define scalar_scalar_int_int_int_operatorIAOPmn
static IA_BaseImage<IA_Point<int>, int> *
scalar_scalar_bo_operatorIAOPmn(IA_BaseImage<IA_Point<int>, int> &lhs_,
	IA_BaseImage<IA_Point<int>, int> &rhs_)
{
    const IA_Set<IA_Point<int> > domain = lhs_.domain();
	IA_ConstI<IA_Point<int>, int> *lhs
		= (IA_ConstI<IA_Point<int>, int> *)&lhs_;
	IA_ConstI<IA_Point<int>, int> *rhs
		= (IA_ConstI<IA_Point<int>, int> *)&rhs_;
    int	aval = ( lhs->value - rhs->value );
    return new IA_ConstI<IA_Point<int>, int>(domain, aval);
}
#endif // scalar_scalar_int_int_int_operatorIAOPmn

#ifndef scalar_iter_int_int_int_operatorIAOPmn
#define scalar_iter_int_int_int_operatorIAOPmn
static IA_BaseImage<IA_Point<int>, int> *
scalar_iter_bo_operatorIAOPmn(IA_BaseImage<IA_Point<int>, int> &lhs_,
	IA_BaseImage<IA_Point<int>, int> &rhs_)
{
    const IA_Set<IA_Point<int> > domain = lhs_.domain();
    const unsigned sz = domain.card();
    int *const vec = new int[sz];

    {
	int *ds = vec;
	IA_ConstI<IA_Point<int>, int> *lhs
		= (IA_ConstI<IA_Point<int>, int> *)&lhs_;
	int rtmp;
	IA_BaseIVIter<IA_Point<int>, int>	*riter = rhs_.value_iterator();
	for (unsigned i=0; i<sz; i++) {
	    riter->next(rtmp);
	    *(ds++) = ( (lhs->value) - (rtmp) );
	}
	delete riter;
    }
    return new IA_VectorI<IA_Point<int>, int>(domain, vec, sz, 1);
}
#endif // scalar_iter_int_int_int_operatorIAOPmn

static IA_BaseImage<IA_Point<int>, int> *
iter_vec_bo_operatorIAOPmn(IA_BaseImage<IA_Point<int>, int> &lhs_,
	IA_BaseImage<IA_Point<int>, int> &rhs_)
{
    const IA_Set<IA_Point<int> > domain = lhs_.domain();
    const unsigned sz = domain.card();
    int *const vec = new int[sz];

    {
	int *ds = vec;
	int ltmp;
	IA_BaseIVIter<IA_Point<int>, int>	*liter = lhs_.value_iterator();
	IA_VectorI<IA_Point<int>, int> *rhs
		= (IA_VectorI<IA_Point<int>, int> *)&rhs_;
	const int *rs = rhs->vec;
	for (unsigned i=0; i<sz; i++) {
	    liter->next(ltmp);
	    *(ds++) = ( (ltmp) - (*rs) );
	    rs++;
	}
	delete liter;
    }
    return new IA_VectorI<IA_Point<int>, int>(domain, vec, sz, 1);
}

#ifndef iter_scalar_int_int_int_operatorIAOPmn
#define iter_scalar_int_int_int_operatorIAOPmn
static IA_BaseImage<IA_Point<int>, int> *
iter_scalar_bo_operatorIAOPmn(IA_BaseImage<IA_Point<int>, int> &lhs_,
	IA_BaseImage<IA_Point<int>, int> &rhs_)
{
    const IA_Set<IA_Point<int> > domain = lhs_.domain();
    const unsigned sz = domain.card();
    int *const vec = new int[sz];

    {
	int *ds = vec;
	int ltmp;
	IA_BaseIVIter<IA_Point<int>, int>	*liter = lhs_.value_iterator();
	IA_ConstI<IA_Point<int>, int> *rhs
		= (IA_ConstI<IA_Point<int>, int> *)&rhs_;
	for (unsigned i=0; i<sz; i++) {
	    liter->next(ltmp);
	    *(ds++) = ( (ltmp) - (rhs->value) );
	}
	delete liter;
    }
    return new IA_VectorI<IA_Point<int>, int>(domain, vec, sz, 1);
}
#endif // iter_scalar_int_int_int_operatorIAOPmn

static IA_BaseImage<IA_Point<int>, int> *
iter_iter_bo_operatorIAOPmn(IA_BaseImage<IA_Point<int>, int> &lhs_,
	IA_BaseImage<IA_Point<int>, int> &rhs_)
{
    const IA_Set<IA_Point<int> > domain = lhs_.domain();
    const unsigned sz = domain.card();
    int *const vec = new int[sz];

    {
	int *ds = vec;
	int ltmp;
	IA_BaseIVIter<IA_Point<int>, int>	*liter = lhs_.value_iterator();
	int rtmp;
	IA_BaseIVIter<IA_Point<int>, int>	*riter = rhs_.value_iterator();
	for (unsigned i=0; i<sz; i++) {
	    liter->next(ltmp);
	    riter->next(rtmp);
	    *(ds++) = ( (ltmp) - (rtmp) );
	}
	delete liter;
	delete riter;
    }
    return new IA_VectorI<IA_Point<int>, int>(domain, vec, sz, 1);
}

#ifndef FILL_BOT_int_int_int_operatorIAOPmn
#define FILL_BOT_int_int_int_operatorIAOPmn
void IA_fill_Image_IP_int_int_int_operatorIAOPmn_tbl()
{
    if (IA_Image_IP_int_int_int_operatorIAOPmn_tbl)
	return;

    IA_BinaryOperationsTable<IA_BaseImage<IA_Point<int>, int>*,
	IA_BaseImage<IA_Point<int>, int>,
	IA_BaseImage<IA_Point<int>, int> >::function f;
    f = iter_iter_bo_operatorIAOPmn;

    IA_Image_IP_int_int_int_operatorIAOPmn_tbl = new IA_BinaryOperationsTable<IA_BaseImage<IA_Point<int>, int>*,
	IA_BaseImage<IA_Point<int>, int>,
	IA_BaseImage<IA_Point<int>, int> >(iter_iter_bo_operatorIAOPmn);
    IA_Image_IP_int_int_int_operatorIAOPmn_tbl->add_operation
	(IA_VectorI<IA_Point<int>, int>::s_type(),
	 IA_VectorI<IA_Point<int>, int>::s_type(),
	 vec_vec_bo_operatorIAOPmn);
    IA_Image_IP_int_int_int_operatorIAOPmn_tbl->add_operation
	(IA_VectorI<IA_Point<int>, int>::s_type(),
	 IA_ConstI<IA_Point<int>, int>::s_type(),
	 vec_scalar_bo_operatorIAOPmn);
    IA_Image_IP_int_int_int_operatorIAOPmn_tbl->add_operation
	(IA_VectorI<IA_Point<int>, int>::s_type(),
	 0,
	 vec_iter_bo_operatorIAOPmn);

    IA_Image_IP_int_int_int_operatorIAOPmn_tbl->add_operation
	(IA_ConstI<IA_Point<int>, int>::s_type(),
	 IA_VectorI<IA_Point<int>, int>::s_type(),
	 scalar_vec_bo_operatorIAOPmn);
    IA_Image_IP_int_int_int_operatorIAOPmn_tbl->add_operation
	(IA_ConstI<IA_Point<int>, int>::s_type(),
	 IA_ConstI<IA_Point<int>, int>::s_type(),
	 scalar_scalar_bo_operatorIAOPmn);
    IA_Image_IP_int_int_int_operatorIAOPmn_tbl->add_operation
	(IA_ConstI<IA_Point<int>, int>::s_type(),
	 0,
	 scalar_iter_bo_operatorIAOPmn);

    IA_Image_IP_int_int_int_operatorIAOPmn_tbl->add_operation
	(0,
	 IA_VectorI<IA_Point<int>, int>::s_type(),
	 iter_vec_bo_operatorIAOPmn);
    IA_Image_IP_int_int_int_operatorIAOPmn_tbl->add_operation
	(0,
	 IA_ConstI<IA_Point<int>, int>::s_type(),
	 iter_scalar_bo_operatorIAOPmn);

}
#endif // BOT_int_int_int_operatorIAOPmn

//////////////////////////////////////////////////////////////////////
//
// Begin operation support routines for :
// binary pointwise non-commutative operator- I(int) I(int) int
//
#ifndef BOT_int_int_int_operatorIAOPmn
#define BOT_int_int_int_operatorIAOPmn
IA_BinaryOperationsTable<IA_BaseImage<IA_Point<int>, int>*,
	IA_BaseImage<IA_Point<int>, int>,
	IA_BaseImage<IA_Point<int>, int> >
	*IA_Image_IP_int_int_int_operatorIAOPmn_tbl;

void IA_fill_Image_IP_int_int_int_operatorIAOPmn_tbl();

#endif // BOT_int_int_int_operatorIAOPmn
IA_Image<IA_Point<int>, int>
operator- ( const IA_Image<IA_Point<int>, int> &lhs,
		int rhs)
{
    if (!IA_Image_IP_int_int_int_operatorIAOPmn_tbl)
	IA_fill_Image_IP_int_int_int_operatorIAOPmn_tbl();

    IA_BaseImage<IA_Point<int>, int>*(*f)( IA_BaseImage<IA_Point<int>, int> &,
		IA_BaseImage<IA_Point<int>, int> &);
    f = IA_Image_IP_int_int_int_operatorIAOPmn_tbl->lookup_operation
	(lhs.type(), IA_ConstI<IA_Point<int>, int>::s_type());
    IA_BaseImage<IA_Point<int>,int>	&basel = *IA_FBI<IA_Point<int>,IA_Point<int>, int,int,int>
	    ::extract_baseptr(lhs);
    IA_ConstI<IA_Point<int>,int>	baser(lhs.domain(), rhs);
    return IA_Image<IA_Point<int>,int>
	(IA_FBI<IA_Point<int>,IA_Point<int>, int,int,int>
	 ::make_Image(	 f(basel,baser)));
}

//
//
//

#ifndef vec_scalar_int_int_int_operatorIAOPmn
#define vec_scalar_int_int_int_operatorIAOPmn
static IA_BaseImage<IA_Point<int>, int> *
vec_scalar_bo_operatorIAOPmn(IA_BaseImage<IA_Point<int>, int> &lhs_,
	IA_BaseImage<IA_Point<int>, int> &rhs_)
{
    const IA_Set<IA_Point<int> > domain = lhs_.domain();
    const unsigned sz = domain.card();
    int *const vec = new int[sz];

    {
	int *ds = vec;
	IA_VectorI<IA_Point<int>, int> *lhs
		= (IA_VectorI<IA_Point<int>, int> *)&lhs_;
	const int *ls = lhs->vec;
	IA_ConstI<IA_Point<int>, int> *rhs
		= (IA_ConstI<IA_Point<int>, int> *)&rhs_;
	for (unsigned i=0; i<sz; i++) {
	    *(ds++) = ( (*ls) - (rhs->value) );
	    ls++;
	}
    }
    return new IA_VectorI<IA_Point<int>, int>(domain, vec, sz, 1);
}
#endif // vec_scalar_int_int_int_operatorIAOPmn

#ifndef scalar_scalar_int_int_int_operatorIAOPmn
#define scalar_scalar_int_int_int_operatorIAOPmn
static IA_BaseImage<IA_Point<int>, int> *
scalar_scalar_bo_operatorIAOPmn(IA_BaseImage<IA_Point<int>, int> &lhs_,
	IA_BaseImage<IA_Point<int>, int> &rhs_)
{
    const IA_Set<IA_Point<int> > domain = lhs_.domain();
	IA_ConstI<IA_Point<int>, int> *lhs
		= (IA_ConstI<IA_Point<int>, int> *)&lhs_;
	IA_ConstI<IA_Point<int>, int> *rhs
		= (IA_ConstI<IA_Point<int>, int> *)&rhs_;
    int	aval = ( lhs->value - rhs->value );
    return new IA_ConstI<IA_Point<int>, int>(domain, aval);
}
#endif // scalar_scalar_int_int_int_operatorIAOPmn

#ifndef iter_scalar_int_int_int_operatorIAOPmn
#define iter_scalar_int_int_int_operatorIAOPmn
static IA_BaseImage<IA_Point<int>, int> *
iter_scalar_bo_operatorIAOPmn(IA_BaseImage<IA_Point<int>, int> &lhs_,
	IA_BaseImage<IA_Point<int>, int> &rhs_)
{
    const IA_Set<IA_Point<int> > domain = lhs_.domain();
    const unsigned sz = domain.card();
    int *const vec = new int[sz];

    {
	int *ds = vec;
	int ltmp;
	IA_BaseIVIter<IA_Point<int>, int>	*liter = lhs_.value_iterator();
	IA_ConstI<IA_Point<int>, int> *rhs
		= (IA_ConstI<IA_Point<int>, int> *)&rhs_;
	for (unsigned i=0; i<sz; i++) {
	    liter->next(ltmp);
	    *(ds++) = ( (ltmp) - (rhs->value) );
	}
	delete liter;
    }
    return new IA_VectorI<IA_Point<int>, int>(domain, vec, sz, 1);
}
#endif // iter_scalar_int_int_int_operatorIAOPmn

#ifndef FILL_BOT_int_int_int_operatorIAOPmn
#define FILL_BOT_int_int_int_operatorIAOPmn
void IA_fill_Image_IP_int_int_int_operatorIAOPmn_tbl()
{
    if (IA_Image_IP_int_int_int_operatorIAOPmn_tbl)
	return;

    IA_BinaryOperationsTable<IA_BaseImage<IA_Point<int>, int>*,
	IA_BaseImage<IA_Point<int>, int>,
	IA_BaseImage<IA_Point<int>, int> >::function f;
    f = iter_iter_bo_operatorIAOPmn;

    IA_Image_IP_int_int_int_operatorIAOPmn_tbl = new IA_BinaryOperationsTable<IA_BaseImage<IA_Point<int>, int>*,
	IA_BaseImage<IA_Point<int>, int>,
	IA_BaseImage<IA_Point<int>, int> >(iter_iter_bo_operatorIAOPmn);
    IA_Image_IP_int_int_int_operatorIAOPmn_tbl->add_operation
	(IA_VectorI<IA_Point<int>, int>::s_type(),
	 IA_VectorI<IA_Point<int>, int>::s_type(),
	 vec_vec_bo_operatorIAOPmn);
    IA_Image_IP_int_int_int_operatorIAOPmn_tbl->add_operation
	(IA_VectorI<IA_Point<int>, int>::s_type(),
	 IA_ConstI<IA_Point<int>, int>::s_type(),
	 vec_scalar_bo_operatorIAOPmn);
    IA_Image_IP_int_int_int_operatorIAOPmn_tbl->add_operation
	(IA_VectorI<IA_Point<int>, int>::s_type(),
	 0,
	 vec_iter_bo_operatorIAOPmn);

    IA_Image_IP_int_int_int_operatorIAOPmn_tbl->add_operation
	(IA_ConstI<IA_Point<int>, int>::s_type(),
	 IA_VectorI<IA_Point<int>, int>::s_type(),
	 scalar_vec_bo_operatorIAOPmn);
    IA_Image_IP_int_int_int_operatorIAOPmn_tbl->add_operation
	(IA_ConstI<IA_Point<int>, int>::s_type(),
	 IA_ConstI<IA_Point<int>, int>::s_type(),
	 scalar_scalar_bo_operatorIAOPmn);
    IA_Image_IP_int_int_int_operatorIAOPmn_tbl->add_operation
	(IA_ConstI<IA_Point<int>, int>::s_type(),
	 0,
	 scalar_iter_bo_operatorIAOPmn);

    IA_Image_IP_int_int_int_operatorIAOPmn_tbl->add_operation
	(0,
	 IA_VectorI<IA_Point<int>, int>::s_type(),
	 iter_vec_bo_operatorIAOPmn);
    IA_Image_IP_int_int_int_operatorIAOPmn_tbl->add_operation
	(0,
	 IA_ConstI<IA_Point<int>, int>::s_type(),
	 iter_scalar_bo_operatorIAOPmn);

}
#endif // BOT_int_int_int_operatorIAOPmn

//////////////////////////////////////////////////////////////////////
//
// Begin operation support routines for :
// binary pointwise non-commutative operator- I(int) int I(int)
//
#ifndef BOT_int_int_int_operatorIAOPmn
#define BOT_int_int_int_operatorIAOPmn
IA_BinaryOperationsTable<IA_BaseImage<IA_Point<int>, int>*,
	IA_BaseImage<IA_Point<int>, int>,
	IA_BaseImage<IA_Point<int>, int> >
	*IA_Image_IP_int_int_int_operatorIAOPmn_tbl;

void IA_fill_Image_IP_int_int_int_operatorIAOPmn_tbl();

#endif // BOT_int_int_int_operatorIAOPmn
IA_Image<IA_Point<int>, int>
operator- ( int lhs,
		const IA_Image<IA_Point<int>, int> &rhs)
{
    if (!IA_Image_IP_int_int_int_operatorIAOPmn_tbl)
	IA_fill_Image_IP_int_int_int_operatorIAOPmn_tbl();

    IA_BaseImage<IA_Point<int>, int>*(*f)( IA_BaseImage<IA_Point<int>, int> &,
		IA_BaseImage<IA_Point<int>, int> &);
    f = IA_Image_IP_int_int_int_operatorIAOPmn_tbl->lookup_operation
	(IA_ConstI<IA_Point<int>, int>::s_type(), rhs.type());
    IA_ConstI<IA_Point<int>,int>	basel(rhs.domain(), lhs);
    IA_BaseImage<IA_Point<int>,int>	&baser = *IA_FBI<IA_Point<int>,IA_Point<int>, int,int,int>
	    ::extract_baseptr(rhs);
    return IA_Image<IA_Point<int>,int>
	(IA_FBI<IA_Point<int>,IA_Point<int>, int,int,int>
	 ::make_Image(	 f(basel,baser)));
}

//
//
//

#ifndef scalar_vec_int_int_int_operatorIAOPmn
#define scalar_vec_int_int_int_operatorIAOPmn
static IA_BaseImage<IA_Point<int>, int> *
scalar_vec_bo_operatorIAOPmn(IA_BaseImage<IA_Point<int>, int> &lhs_,
	IA_BaseImage<IA_Point<int>, int> &rhs_)
{
    const IA_Set<IA_Point<int> > domain = lhs_.domain();
    const unsigned sz = domain.card();
    int *const vec = new int[sz];

    {
	int *ds = vec;
	IA_ConstI<IA_Point<int>, int> *lhs
		= (IA_ConstI<IA_Point<int>, int> *)&lhs_;
	IA_VectorI<IA_Point<int>, int> *rhs
		= (IA_VectorI<IA_Point<int>, int> *)&rhs_;
	const int *rs = rhs->vec;
	for (unsigned i=0; i<sz; i++) {
	    *(ds++) = ( (lhs->value) - (*rs) );
	    rs++;
	}
    }
    return new IA_VectorI<IA_Point<int>, int>(domain, vec, sz, 1);
}
#endif // scalar_vec_int_int_int_operatorIAOPmn

#ifndef scalar_scalar_int_int_int_operatorIAOPmn
#define scalar_scalar_int_int_int_operatorIAOPmn
static IA_BaseImage<IA_Point<int>, int> *
scalar_scalar_bo_operatorIAOPmn(IA_BaseImage<IA_Point<int>, int> &lhs_,
	IA_BaseImage<IA_Point<int>, int> &rhs_)
{
    const IA_Set<IA_Point<int> > domain = lhs_.domain();
	IA_ConstI<IA_Point<int>, int> *lhs
		= (IA_ConstI<IA_Point<int>, int> *)&lhs_;
	IA_ConstI<IA_Point<int>, int> *rhs
		= (IA_ConstI<IA_Point<int>, int> *)&rhs_;
    int	aval = ( lhs->value - rhs->value );
    return new IA_ConstI<IA_Point<int>, int>(domain, aval);
}
#endif // scalar_scalar_int_int_int_operatorIAOPmn

#ifndef scalar_iter_int_int_int_operatorIAOPmn
#define scalar_iter_int_int_int_operatorIAOPmn
static IA_BaseImage<IA_Point<int>, int> *
scalar_iter_bo_operatorIAOPmn(IA_BaseImage<IA_Point<int>, int> &lhs_,
	IA_BaseImage<IA_Point<int>, int> &rhs_)
{
    const IA_Set<IA_Point<int> > domain = lhs_.domain();
    const unsigned sz = domain.card();
    int *const vec = new int[sz];

    {
	int *ds = vec;
	IA_ConstI<IA_Point<int>, int> *lhs
		= (IA_ConstI<IA_Point<int>, int> *)&lhs_;
	int rtmp;
	IA_BaseIVIter<IA_Point<int>, int>	*riter = rhs_.value_iterator();
	for (unsigned i=0; i<sz; i++) {
	    riter->next(rtmp);
	    *(ds++) = ( (lhs->value) - (rtmp) );
	}
	delete riter;
    }
    return new IA_VectorI<IA_Point<int>, int>(domain, vec, sz, 1);
}
#endif // scalar_iter_int_int_int_operatorIAOPmn

#ifndef FILL_BOT_int_int_int_operatorIAOPmn
#define FILL_BOT_int_int_int_operatorIAOPmn
void IA_fill_Image_IP_int_int_int_operatorIAOPmn_tbl()
{
    if (IA_Image_IP_int_int_int_operatorIAOPmn_tbl)
	return;

    IA_BinaryOperationsTable<IA_BaseImage<IA_Point<int>, int>*,
	IA_BaseImage<IA_Point<int>, int>,
	IA_BaseImage<IA_Point<int>, int> >::function f;
    f = iter_iter_bo_operatorIAOPmn;

    IA_Image_IP_int_int_int_operatorIAOPmn_tbl = new IA_BinaryOperationsTable<IA_BaseImage<IA_Point<int>, int>*,
	IA_BaseImage<IA_Point<int>, int>,
	IA_BaseImage<IA_Point<int>, int> >(iter_iter_bo_operatorIAOPmn);
    IA_Image_IP_int_int_int_operatorIAOPmn_tbl->add_operation
	(IA_VectorI<IA_Point<int>, int>::s_type(),
	 IA_VectorI<IA_Point<int>, int>::s_type(),
	 vec_vec_bo_operatorIAOPmn);
    IA_Image_IP_int_int_int_operatorIAOPmn_tbl->add_operation
	(IA_VectorI<IA_Point<int>, int>::s_type(),
	 IA_ConstI<IA_Point<int>, int>::s_type(),
	 vec_scalar_bo_operatorIAOPmn);
    IA_Image_IP_int_int_int_operatorIAOPmn_tbl->add_operation
	(IA_VectorI<IA_Point<int>, int>::s_type(),
	 0,
	 vec_iter_bo_operatorIAOPmn);

    IA_Image_IP_int_int_int_operatorIAOPmn_tbl->add_operation
	(IA_ConstI<IA_Point<int>, int>::s_type(),
	 IA_VectorI<IA_Point<int>, int>::s_type(),
	 scalar_vec_bo_operatorIAOPmn);
    IA_Image_IP_int_int_int_operatorIAOPmn_tbl->add_operation
	(IA_ConstI<IA_Point<int>, int>::s_type(),
	 IA_ConstI<IA_Point<int>, int>::s_type(),
	 scalar_scalar_bo_operatorIAOPmn);
    IA_Image_IP_int_int_int_operatorIAOPmn_tbl->add_operation
	(IA_ConstI<IA_Point<int>, int>::s_type(),
	 0,
	 scalar_iter_bo_operatorIAOPmn);

    IA_Image_IP_int_int_int_operatorIAOPmn_tbl->add_operation
	(0,
	 IA_VectorI<IA_Point<int>, int>::s_type(),
	 iter_vec_bo_operatorIAOPmn);
    IA_Image_IP_int_int_int_operatorIAOPmn_tbl->add_operation
	(0,
	 IA_ConstI<IA_Point<int>, int>::s_type(),
	 iter_scalar_bo_operatorIAOPmn);

}
#endif // BOT_int_int_int_operatorIAOPmn

//////////////////////////////////////////////////////////////////////
//
// Begin operation support routines for :
// unary pointwise operator- I(int) I(int)
//
// Emacs: -*- C++ -*-

//
//	Copyright 1993, Center for Computer Vision and Visualization,
//	University of Florida.  All rights reserved.
//


//
// $Log: unary-op.templ,v $
// Revision 1.4.1.2  1995/01/13  19:37:42  thoth
// CoreImage has been re-merged with Image.  All special stuff should be
// friends of FBI now.
//
// Revision 1.4.1.1  1994/12/28  17:22:11  thoth
// image operations are friends of FBI now.
//
// Revision 1.4  1994/07/25  17:26:39  thoth
// Name sanitization
//
// Revision 1.3  1994/01/07  15:15:14  thoth
// Image class is now CoreImage and named image types are
// Image<P,T>.
//
// Revision 1.2  1993/12/29  17:33:18  thoth
// New operator scheme that prevents the need for trivial Image conversions.
//
// Revision 1.1  1993/09/15  13:07:16  thoth
// Initial revision
//
// Revision 1.2  93/05/27  11:49:04  thoth
// Copyright Notices
// 
// Revision 1.1  93/03/10  13:50:00  thoth
// Initial revision
// 

#ifndef UOT_int_int_operatorIAOPmn
#define UOT_int_int_operatorIAOPmn
IA_UnaryOperationsTable<IA_BaseImage<IA_Point<int>, int>*,
	IA_BaseImage<IA_Point<int>, int> >
	*IA_Image_IP_int_int_operatorIAOPmn_tbl;

void IA_fill_Image_IP_int_int_operatorIAOPmn_tbl();
#endif


IA_Image<IA_Point<int>, int>
operator- ( const IA_Image<IA_Point<int>, int> &arg)
{
    if (!IA_Image_IP_int_int_operatorIAOPmn_tbl)
	IA_fill_Image_IP_int_int_operatorIAOPmn_tbl();

    IA_BaseImage<IA_Point<int>, int>*(*f)
	(IA_BaseImage<IA_Point<int>, int> &);
    f = IA_Image_IP_int_int_operatorIAOPmn_tbl->lookup_operation (arg.type());

    
    IA_BaseImage<IA_Point<int>, int>	&bip =
	*IA_FBI<IA_Point<int>,IA_Point<int>,int,int,int>
	    ::extract_baseptr(arg);

    return IA_FBI<IA_Point<int>,IA_Point<int>, int,int,int>
	 ::make_Image(f(bip));
}

#ifndef vec_uop_int_int_operatorIAOPmn
#define vec_uop_int_int_operatorIAOPmn
static IA_BaseImage<IA_Point<int>, int>*
vec_uo_operatorIAOPmn(IA_BaseImage<IA_Point<int>, int> &lhs_)
{
    const IA_VectorI<IA_Point<int>, int> *lhs =
	(IA_VectorI<IA_Point<int>, int> *) &lhs_;

    const IA_Set<IA_Point<int> > domain = lhs->domain();
    const unsigned sz = domain.card();
    int *const vec = new int[sz];

    {
	int *ds = vec;
	const int *ls = lhs->vec;
	for (unsigned i=0; i<sz; i++) {
	    *(ds++) = -(*(ls++));
	}
    }
    return new IA_VectorI<IA_Point<int>, int>(domain, vec, sz, 1);
}
#endif // vec_uop_int_int_operatorIAOPmn

#ifndef scalar_uop_int_int_operatorIAOPmn
#define scalar_uop_int_int_operatorIAOPmn
static IA_BaseImage<IA_Point<int>, int>*
scalar_uo_operatorIAOPmn(IA_BaseImage<IA_Point<int>, int> &lhs_)
{
    const IA_ConstI<IA_Point<int>, int> *lhs =
	(IA_ConstI<IA_Point<int>, int> *) &lhs_;

    const IA_Set<IA_Point<int> > domain = lhs->domain();

    return new IA_ConstI<IA_Point<int>, int>(domain, -(lhs->value));
}
#endif // scalar_uop_int_int_operatorIAOPmn

// scalar-scalar operation is trivial

#ifndef iter_uop_int_int_operatorIAOPmn
#define iter_uop_int_int_operatorIAOPmn
static IA_BaseImage<IA_Point<int>, int>*
iter_uo_operatorIAOPmn(IA_BaseImage<IA_Point<int>, int> &lhs)
{
    const IA_Set<IA_Point<int> > domain = lhs.domain();
    const unsigned sz = domain.card();
    int *const vec = new int[sz];

    {
	int *ds = vec;
	int ltmp;
	IA_BaseIVIter<IA_Point<int>, int>	*liter = lhs.value_iterator();
	for (unsigned i=0; i<sz; i++) {
	    liter->next(ltmp);
	    *(ds++) = -(ltmp);
	}
	delete liter;
    }
    return new IA_VectorI<IA_Point<int>, int>(domain, vec, sz, 1);
}
#endif // iter_uop_int_int_operatorIAOPmn

#ifndef FILL_UOT_int_int_operatorIAOPmn
#define FILL_UOT_int_int_operatorIAOPmn
void IA_fill_Image_IP_int_int_operatorIAOPmn_tbl()
{
    if (IA_Image_IP_int_int_operatorIAOPmn_tbl)
	return;

    IA_UnaryOperationsTable<IA_BaseImage<IA_Point<int>, int>*,
	IA_BaseImage<IA_Point<int>, int> >::function f;
    f = iter_uo_operatorIAOPmn;

    IA_Image_IP_int_int_operatorIAOPmn_tbl = new IA_UnaryOperationsTable<IA_BaseImage<IA_Point<int>, int>*,
	IA_BaseImage<IA_Point<int>, int> >(iter_uo_operatorIAOPmn);
    IA_Image_IP_int_int_operatorIAOPmn_tbl->add_operation
	(IA_VectorI<IA_Point<int>, int>::s_type(),
	 vec_uo_operatorIAOPmn);
    IA_Image_IP_int_int_operatorIAOPmn_tbl->add_operation
	(IA_ConstI<IA_Point<int>, int>::s_type(),
	 scalar_uo_operatorIAOPmn);

}
#endif // UOT_int_int_operatorIAOPmn

//////////////////////////////////////////////////////////////////////
//
// Begin operation support routines for :
// pointwise operator-= I(int) I(int)
//
// There are none (it's inline)

//////////////////////////////////////////////////////////////////////
//
// Begin operation support routines for :
// pointwise operator-= I(int) int
//
// There are none (it's inline)

//////////////////////////////////////////////////////////////////////
//
// Begin operation support routines for :
// filename IIO-__ml.c
//
