// Emacs -*- C++ -*-

// Machine generated include file, do not modify.


// 	Copyright 1993, Center for Computer Vision and Visualization,
// 	University of Florida.  All rights reserved.


//  $Log: int-operations.desc,v $
//  Revision 1.9.1.2  1995/01/31  16:02:40  thoth
//  Need to replace the upward conversions with something...

//  Revision 1.9.1.1  1994/12/28  17:56:27  thoth
//  Conversion to operations table.
//  image operations are now friendly with FBI.
//  new sgn() function.

//  Revision 1.9  1994/12/19  19:58:48  ljr
//  DOS-inspired name rework.

//  Revision 1.8  1994/05/17  12:54:56  thoth
//  Improved operations generation scheme.  Lines from the op.desc file can
//  be quoted into the .c file to allow inclusion of infrastructure.  Also
//  the op.desc output can be redirected to several files.  The prefix
//  directive allows common information (include files) to be included in
//  every generated source file.

//  Integer operations for the Int Discrete Image
#include "IntDI.h"
#include "VectorI.h"
#include "ConstI.h"
#include "ImageIter.h"
#include "FBI.h"
#include "../valueset/OpTable.h"
//////////////////////////////////////////////////////////////////////
//
// Begin operation support routines for :
// binary strictrel non-commutative operator>= int I(int) I(int)
//
#ifndef BOT_int_int_int_operatorIAOPge
#define BOT_int_int_int_operatorIAOPge
IA_BinaryOperationsTable<int,
	IA_BaseImage<IA_Point<int>, int>,
	IA_BaseImage<IA_Point<int>, int> >
	*IA_Image_IP_int_int_int_operatorIAOPge_tbl;

void IA_fill_Image_IP_int_int_int_operatorIAOPge_tbl();

#endif // BOT_int_int_int_operatorIAOPge
int operator>= ( const IA_Image<IA_Point<int>, int> &lhs,
		const IA_Image<IA_Point<int>, int> &rhs)
{
    if (lhs.domain() != rhs.domain()) {
	 int	rval;
	ia_throw(Image_DomainMismatch_Exception(__FILE__,__LINE__));
	return rval;
    }

    if (!IA_Image_IP_int_int_int_operatorIAOPge_tbl)
	IA_fill_Image_IP_int_int_int_operatorIAOPge_tbl();

    int(*f)( IA_BaseImage<IA_Point<int>, int> &,
		IA_BaseImage<IA_Point<int>, int> &);
    f = IA_Image_IP_int_int_int_operatorIAOPge_tbl->lookup_operation
	(lhs.type(), rhs.type());
    IA_BaseImage<IA_Point<int>,int>	&basel = *IA_FBI<IA_Point<int>,IA_Point<int>, int,int,int>
	    ::extract_baseptr(lhs);
    IA_BaseImage<IA_Point<int>,int>	&baser = *IA_FBI<IA_Point<int>,IA_Point<int>, int,int,int>
	    ::extract_baseptr(rhs);
    return 	 f(basel,baser);
}

//
//
//

static int vec_vec_bo_operatorIAOPge(IA_BaseImage<IA_Point<int>, int> &lhs_,
	IA_BaseImage<IA_Point<int>, int> &rhs_)
{
    const IA_Set<IA_Point<int> > domain = lhs_.domain();
    const unsigned sz = domain.card();
    int *const vec = new int[sz];

    {
	int *ds = vec;
	IA_VectorI<IA_Point<int>, int> *lhs
		= (IA_VectorI<IA_Point<int>, int> *)&lhs_;
	const int *ls = lhs->vec;
	IA_VectorI<IA_Point<int>, int> *rhs
		= (IA_VectorI<IA_Point<int>, int> *)&rhs_;
	const int *rs = rhs->vec;
	for (unsigned i=0; i<sz; i++) {
	    if (!( (*ls) >= (*rs) ))
		return 0;
	    ls++;
	    rs++;
	}
    }
    return 1;
}

#ifndef vec_scalar_int_int_int_operatorIAOPge
#define vec_scalar_int_int_int_operatorIAOPge
static int vec_scalar_bo_operatorIAOPge(IA_BaseImage<IA_Point<int>, int> &lhs_,
	IA_BaseImage<IA_Point<int>, int> &rhs_)
{
    const IA_Set<IA_Point<int> > domain = lhs_.domain();
    const unsigned sz = domain.card();
    int *const vec = new int[sz];

    {
	int *ds = vec;
	IA_VectorI<IA_Point<int>, int> *lhs
		= (IA_VectorI<IA_Point<int>, int> *)&lhs_;
	const int *ls = lhs->vec;
	IA_ConstI<IA_Point<int>, int> *rhs
		= (IA_ConstI<IA_Point<int>, int> *)&rhs_;
	for (unsigned i=0; i<sz; i++) {
	    if (!( (*ls) >= (rhs->value) ))
		return 0;
	    ls++;
	}
    }
    return 1;
}
#endif // vec_scalar_int_int_int_operatorIAOPge

static int vec_iter_bo_operatorIAOPge(IA_BaseImage<IA_Point<int>, int> &lhs_,
	IA_BaseImage<IA_Point<int>, int> &rhs_)
{
    const IA_Set<IA_Point<int> > domain = lhs_.domain();
    const unsigned sz = domain.card();
    int *const vec = new int[sz];

    {
	int *ds = vec;
	IA_VectorI<IA_Point<int>, int> *lhs
		= (IA_VectorI<IA_Point<int>, int> *)&lhs_;
	const int *ls = lhs->vec;
	int rtmp;
	IA_BaseIVIter<IA_Point<int>, int>	*riter = rhs_.value_iterator();
	for (unsigned i=0; i<sz; i++) {
	    riter->next(rtmp);
	    if (!( (*ls) >= (rtmp) ))
		return 0;
	    ls++;
	}
	delete riter;
    }
    return 1;
}

#ifndef scalar_vec_int_int_int_operatorIAOPge
#define scalar_vec_int_int_int_operatorIAOPge
static int scalar_vec_bo_operatorIAOPge(IA_BaseImage<IA_Point<int>, int> &lhs_,
	IA_BaseImage<IA_Point<int>, int> &rhs_)
{
    const IA_Set<IA_Point<int> > domain = lhs_.domain();
    const unsigned sz = domain.card();
    int *const vec = new int[sz];

    {
	int *ds = vec;
	IA_ConstI<IA_Point<int>, int> *lhs
		= (IA_ConstI<IA_Point<int>, int> *)&lhs_;
	IA_VectorI<IA_Point<int>, int> *rhs
		= (IA_VectorI<IA_Point<int>, int> *)&rhs_;
	const int *rs = rhs->vec;
	for (unsigned i=0; i<sz; i++) {
	    if (!( (lhs->value) >= (*rs) ))
		return 0;
	    rs++;
	}
    }
    return 1;
}
#endif // scalar_vec_int_int_int_operatorIAOPge

#ifndef scalar_scalar_int_int_int_operatorIAOPge
#define scalar_scalar_int_int_int_operatorIAOPge
static int scalar_scalar_bo_operatorIAOPge(IA_BaseImage<IA_Point<int>, int> &lhs_,
	IA_BaseImage<IA_Point<int>, int> &rhs_)
{
    const IA_Set<IA_Point<int> > domain = lhs_.domain();
	IA_ConstI<IA_Point<int>, int> *lhs
		= (IA_ConstI<IA_Point<int>, int> *)&lhs_;
	IA_ConstI<IA_Point<int>, int> *rhs
		= (IA_ConstI<IA_Point<int>, int> *)&rhs_;
    int	aval = ( lhs->value >= rhs->value );
    return aval;
}
#endif // scalar_scalar_int_int_int_operatorIAOPge

#ifndef scalar_iter_int_int_int_operatorIAOPge
#define scalar_iter_int_int_int_operatorIAOPge
static int scalar_iter_bo_operatorIAOPge(IA_BaseImage<IA_Point<int>, int> &lhs_,
	IA_BaseImage<IA_Point<int>, int> &rhs_)
{
    const IA_Set<IA_Point<int> > domain = lhs_.domain();
    const unsigned sz = domain.card();
    int *const vec = new int[sz];

    {
	int *ds = vec;
	IA_ConstI<IA_Point<int>, int> *lhs
		= (IA_ConstI<IA_Point<int>, int> *)&lhs_;
	int rtmp;
	IA_BaseIVIter<IA_Point<int>, int>	*riter = rhs_.value_iterator();
	for (unsigned i=0; i<sz; i++) {
	    riter->next(rtmp);
	    if (!( (lhs->value) >= (rtmp) ))
		return 0;
	}
	delete riter;
    }
    return 1;
}
#endif // scalar_iter_int_int_int_operatorIAOPge

static int iter_vec_bo_operatorIAOPge(IA_BaseImage<IA_Point<int>, int> &lhs_,
	IA_BaseImage<IA_Point<int>, int> &rhs_)
{
    const IA_Set<IA_Point<int> > domain = lhs_.domain();
    const unsigned sz = domain.card();
    int *const vec = new int[sz];

    {
	int *ds = vec;
	int ltmp;
	IA_BaseIVIter<IA_Point<int>, int>	*liter = lhs_.value_iterator();
	IA_VectorI<IA_Point<int>, int> *rhs
		= (IA_VectorI<IA_Point<int>, int> *)&rhs_;
	const int *rs = rhs->vec;
	for (unsigned i=0; i<sz; i++) {
	    liter->next(ltmp);
	    if (!( (ltmp) >= (*rs) ))
		return 0;
	    rs++;
	}
	delete liter;
    }
    return 1;
}

#ifndef iter_scalar_int_int_int_operatorIAOPge
#define iter_scalar_int_int_int_operatorIAOPge
static int iter_scalar_bo_operatorIAOPge(IA_BaseImage<IA_Point<int>, int> &lhs_,
	IA_BaseImage<IA_Point<int>, int> &rhs_)
{
    const IA_Set<IA_Point<int> > domain = lhs_.domain();
    const unsigned sz = domain.card();
    int *const vec = new int[sz];

    {
	int *ds = vec;
	int ltmp;
	IA_BaseIVIter<IA_Point<int>, int>	*liter = lhs_.value_iterator();
	IA_ConstI<IA_Point<int>, int> *rhs
		= (IA_ConstI<IA_Point<int>, int> *)&rhs_;
	for (unsigned i=0; i<sz; i++) {
	    liter->next(ltmp);
	    if (!( (ltmp) >= (rhs->value) ))
		return 0;
	}
	delete liter;
    }
    return 1;
}
#endif // iter_scalar_int_int_int_operatorIAOPge

static int iter_iter_bo_operatorIAOPge(IA_BaseImage<IA_Point<int>, int> &lhs_,
	IA_BaseImage<IA_Point<int>, int> &rhs_)
{
    const IA_Set<IA_Point<int> > domain = lhs_.domain();
    const unsigned sz = domain.card();
    int *const vec = new int[sz];

    {
	int *ds = vec;
	int ltmp;
	IA_BaseIVIter<IA_Point<int>, int>	*liter = lhs_.value_iterator();
	int rtmp;
	IA_BaseIVIter<IA_Point<int>, int>	*riter = rhs_.value_iterator();
	for (unsigned i=0; i<sz; i++) {
	    liter->next(ltmp);
	    riter->next(rtmp);
	    if (!( (ltmp) >= (rtmp) ))
		return 0;
	}
	delete liter;
	delete riter;
    }
    return 1;
}

#ifndef FILL_BOT_int_int_int_operatorIAOPge
#define FILL_BOT_int_int_int_operatorIAOPge
void IA_fill_Image_IP_int_int_int_operatorIAOPge_tbl()
{
    if (IA_Image_IP_int_int_int_operatorIAOPge_tbl)
	return;

    IA_BinaryOperationsTable<int,
	IA_BaseImage<IA_Point<int>, int>,
	IA_BaseImage<IA_Point<int>, int> >::function f;
    f = iter_iter_bo_operatorIAOPge;

    IA_Image_IP_int_int_int_operatorIAOPge_tbl = new IA_BinaryOperationsTable<int,
	IA_BaseImage<IA_Point<int>, int>,
	IA_BaseImage<IA_Point<int>, int> >(iter_iter_bo_operatorIAOPge);
    IA_Image_IP_int_int_int_operatorIAOPge_tbl->add_operation
	(IA_VectorI<IA_Point<int>, int>::s_type(),
	 IA_VectorI<IA_Point<int>, int>::s_type(),
	 vec_vec_bo_operatorIAOPge);
    IA_Image_IP_int_int_int_operatorIAOPge_tbl->add_operation
	(IA_VectorI<IA_Point<int>, int>::s_type(),
	 IA_ConstI<IA_Point<int>, int>::s_type(),
	 vec_scalar_bo_operatorIAOPge);
    IA_Image_IP_int_int_int_operatorIAOPge_tbl->add_operation
	(IA_VectorI<IA_Point<int>, int>::s_type(),
	 0,
	 vec_iter_bo_operatorIAOPge);

    IA_Image_IP_int_int_int_operatorIAOPge_tbl->add_operation
	(IA_ConstI<IA_Point<int>, int>::s_type(),
	 IA_VectorI<IA_Point<int>, int>::s_type(),
	 scalar_vec_bo_operatorIAOPge);
    IA_Image_IP_int_int_int_operatorIAOPge_tbl->add_operation
	(IA_ConstI<IA_Point<int>, int>::s_type(),
	 IA_ConstI<IA_Point<int>, int>::s_type(),
	 scalar_scalar_bo_operatorIAOPge);
    IA_Image_IP_int_int_int_operatorIAOPge_tbl->add_operation
	(IA_ConstI<IA_Point<int>, int>::s_type(),
	 0,
	 scalar_iter_bo_operatorIAOPge);

    IA_Image_IP_int_int_int_operatorIAOPge_tbl->add_operation
	(0,
	 IA_VectorI<IA_Point<int>, int>::s_type(),
	 iter_vec_bo_operatorIAOPge);
    IA_Image_IP_int_int_int_operatorIAOPge_tbl->add_operation
	(0,
	 IA_ConstI<IA_Point<int>, int>::s_type(),
	 iter_scalar_bo_operatorIAOPge);

}
#endif // BOT_int_int_int_operatorIAOPge

//////////////////////////////////////////////////////////////////////
//
// Begin operation support routines for :
// binary strictrel non-commutative operator>= int I(int) int
//
#ifndef BOT_int_int_int_operatorIAOPge
#define BOT_int_int_int_operatorIAOPge
IA_BinaryOperationsTable<int,
	IA_BaseImage<IA_Point<int>, int>,
	IA_BaseImage<IA_Point<int>, int> >
	*IA_Image_IP_int_int_int_operatorIAOPge_tbl;

void IA_fill_Image_IP_int_int_int_operatorIAOPge_tbl();

#endif // BOT_int_int_int_operatorIAOPge
int operator>= ( const IA_Image<IA_Point<int>, int> &lhs,
		int rhs)
{
    if (!IA_Image_IP_int_int_int_operatorIAOPge_tbl)
	IA_fill_Image_IP_int_int_int_operatorIAOPge_tbl();

    int(*f)( IA_BaseImage<IA_Point<int>, int> &,
		IA_BaseImage<IA_Point<int>, int> &);
    f = IA_Image_IP_int_int_int_operatorIAOPge_tbl->lookup_operation
	(lhs.type(), IA_ConstI<IA_Point<int>, int>::s_type());
    IA_BaseImage<IA_Point<int>,int>	&basel = *IA_FBI<IA_Point<int>,IA_Point<int>, int,int,int>
	    ::extract_baseptr(lhs);
    IA_ConstI<IA_Point<int>,int>	baser(lhs.domain(), rhs);
    return 	 f(basel,baser);
}

//
//
//

#ifndef vec_scalar_int_int_int_operatorIAOPge
#define vec_scalar_int_int_int_operatorIAOPge
static int vec_scalar_bo_operatorIAOPge(IA_BaseImage<IA_Point<int>, int> &lhs_,
	IA_BaseImage<IA_Point<int>, int> &rhs_)
{
    const IA_Set<IA_Point<int> > domain = lhs_.domain();
    const unsigned sz = domain.card();
    int *const vec = new int[sz];

    {
	int *ds = vec;
	IA_VectorI<IA_Point<int>, int> *lhs
		= (IA_VectorI<IA_Point<int>, int> *)&lhs_;
	const int *ls = lhs->vec;
	IA_ConstI<IA_Point<int>, int> *rhs
		= (IA_ConstI<IA_Point<int>, int> *)&rhs_;
	for (unsigned i=0; i<sz; i++) {
	    if (!( (*ls) >= (rhs->value) ))
		return 0;
	    ls++;
	}
    }
    return 1;
}
#endif // vec_scalar_int_int_int_operatorIAOPge

#ifndef scalar_scalar_int_int_int_operatorIAOPge
#define scalar_scalar_int_int_int_operatorIAOPge
static int scalar_scalar_bo_operatorIAOPge(IA_BaseImage<IA_Point<int>, int> &lhs_,
	IA_BaseImage<IA_Point<int>, int> &rhs_)
{
    const IA_Set<IA_Point<int> > domain = lhs_.domain();
	IA_ConstI<IA_Point<int>, int> *lhs
		= (IA_ConstI<IA_Point<int>, int> *)&lhs_;
	IA_ConstI<IA_Point<int>, int> *rhs
		= (IA_ConstI<IA_Point<int>, int> *)&rhs_;
    int	aval = ( lhs->value >= rhs->value );
    return aval;
}
#endif // scalar_scalar_int_int_int_operatorIAOPge

#ifndef iter_scalar_int_int_int_operatorIAOPge
#define iter_scalar_int_int_int_operatorIAOPge
static int iter_scalar_bo_operatorIAOPge(IA_BaseImage<IA_Point<int>, int> &lhs_,
	IA_BaseImage<IA_Point<int>, int> &rhs_)
{
    const IA_Set<IA_Point<int> > domain = lhs_.domain();
    const unsigned sz = domain.card();
    int *const vec = new int[sz];

    {
	int *ds = vec;
	int ltmp;
	IA_BaseIVIter<IA_Point<int>, int>	*liter = lhs_.value_iterator();
	IA_ConstI<IA_Point<int>, int> *rhs
		= (IA_ConstI<IA_Point<int>, int> *)&rhs_;
	for (unsigned i=0; i<sz; i++) {
	    liter->next(ltmp);
	    if (!( (ltmp) >= (rhs->value) ))
		return 0;
	}
	delete liter;
    }
    return 1;
}
#endif // iter_scalar_int_int_int_operatorIAOPge

#ifndef FILL_BOT_int_int_int_operatorIAOPge
#define FILL_BOT_int_int_int_operatorIAOPge
void IA_fill_Image_IP_int_int_int_operatorIAOPge_tbl()
{
    if (IA_Image_IP_int_int_int_operatorIAOPge_tbl)
	return;

    IA_BinaryOperationsTable<int,
	IA_BaseImage<IA_Point<int>, int>,
	IA_BaseImage<IA_Point<int>, int> >::function f;
    f = iter_iter_bo_operatorIAOPge;

    IA_Image_IP_int_int_int_operatorIAOPge_tbl = new IA_BinaryOperationsTable<int,
	IA_BaseImage<IA_Point<int>, int>,
	IA_BaseImage<IA_Point<int>, int> >(iter_iter_bo_operatorIAOPge);
    IA_Image_IP_int_int_int_operatorIAOPge_tbl->add_operation
	(IA_VectorI<IA_Point<int>, int>::s_type(),
	 IA_VectorI<IA_Point<int>, int>::s_type(),
	 vec_vec_bo_operatorIAOPge);
    IA_Image_IP_int_int_int_operatorIAOPge_tbl->add_operation
	(IA_VectorI<IA_Point<int>, int>::s_type(),
	 IA_ConstI<IA_Point<int>, int>::s_type(),
	 vec_scalar_bo_operatorIAOPge);
    IA_Image_IP_int_int_int_operatorIAOPge_tbl->add_operation
	(IA_VectorI<IA_Point<int>, int>::s_type(),
	 0,
	 vec_iter_bo_operatorIAOPge);

    IA_Image_IP_int_int_int_operatorIAOPge_tbl->add_operation
	(IA_ConstI<IA_Point<int>, int>::s_type(),
	 IA_VectorI<IA_Point<int>, int>::s_type(),
	 scalar_vec_bo_operatorIAOPge);
    IA_Image_IP_int_int_int_operatorIAOPge_tbl->add_operation
	(IA_ConstI<IA_Point<int>, int>::s_type(),
	 IA_ConstI<IA_Point<int>, int>::s_type(),
	 scalar_scalar_bo_operatorIAOPge);
    IA_Image_IP_int_int_int_operatorIAOPge_tbl->add_operation
	(IA_ConstI<IA_Point<int>, int>::s_type(),
	 0,
	 scalar_iter_bo_operatorIAOPge);

    IA_Image_IP_int_int_int_operatorIAOPge_tbl->add_operation
	(0,
	 IA_VectorI<IA_Point<int>, int>::s_type(),
	 iter_vec_bo_operatorIAOPge);
    IA_Image_IP_int_int_int_operatorIAOPge_tbl->add_operation
	(0,
	 IA_ConstI<IA_Point<int>, int>::s_type(),
	 iter_scalar_bo_operatorIAOPge);

}
#endif // BOT_int_int_int_operatorIAOPge

//////////////////////////////////////////////////////////////////////
//
// Begin operation support routines for :
// binary strictrel non-commutative operator>= int int I(int)
//
#ifndef BOT_int_int_int_operatorIAOPge
#define BOT_int_int_int_operatorIAOPge
IA_BinaryOperationsTable<int,
	IA_BaseImage<IA_Point<int>, int>,
	IA_BaseImage<IA_Point<int>, int> >
	*IA_Image_IP_int_int_int_operatorIAOPge_tbl;

void IA_fill_Image_IP_int_int_int_operatorIAOPge_tbl();

#endif // BOT_int_int_int_operatorIAOPge
int operator>= ( int lhs,
		const IA_Image<IA_Point<int>, int> &rhs)
{
    if (!IA_Image_IP_int_int_int_operatorIAOPge_tbl)
	IA_fill_Image_IP_int_int_int_operatorIAOPge_tbl();

    int(*f)( IA_BaseImage<IA_Point<int>, int> &,
		IA_BaseImage<IA_Point<int>, int> &);
    f = IA_Image_IP_int_int_int_operatorIAOPge_tbl->lookup_operation
	(IA_ConstI<IA_Point<int>, int>::s_type(), rhs.type());
    IA_ConstI<IA_Point<int>,int>	basel(rhs.domain(), lhs);
    IA_BaseImage<IA_Point<int>,int>	&baser = *IA_FBI<IA_Point<int>,IA_Point<int>, int,int,int>
	    ::extract_baseptr(rhs);
    return 	 f(basel,baser);
}

//
//
//

#ifndef scalar_vec_int_int_int_operatorIAOPge
#define scalar_vec_int_int_int_operatorIAOPge
static int scalar_vec_bo_operatorIAOPge(IA_BaseImage<IA_Point<int>, int> &lhs_,
	IA_BaseImage<IA_Point<int>, int> &rhs_)
{
    const IA_Set<IA_Point<int> > domain = lhs_.domain();
    const unsigned sz = domain.card();
    int *const vec = new int[sz];

    {
	int *ds = vec;
	IA_ConstI<IA_Point<int>, int> *lhs
		= (IA_ConstI<IA_Point<int>, int> *)&lhs_;
	IA_VectorI<IA_Point<int>, int> *rhs
		= (IA_VectorI<IA_Point<int>, int> *)&rhs_;
	const int *rs = rhs->vec;
	for (unsigned i=0; i<sz; i++) {
	    if (!( (lhs->value) >= (*rs) ))
		return 0;
	    rs++;
	}
    }
    return 1;
}
#endif // scalar_vec_int_int_int_operatorIAOPge

#ifndef scalar_scalar_int_int_int_operatorIAOPge
#define scalar_scalar_int_int_int_operatorIAOPge
static int scalar_scalar_bo_operatorIAOPge(IA_BaseImage<IA_Point<int>, int> &lhs_,
	IA_BaseImage<IA_Point<int>, int> &rhs_)
{
    const IA_Set<IA_Point<int> > domain = lhs_.domain();
	IA_ConstI<IA_Point<int>, int> *lhs
		= (IA_ConstI<IA_Point<int>, int> *)&lhs_;
	IA_ConstI<IA_Point<int>, int> *rhs
		= (IA_ConstI<IA_Point<int>, int> *)&rhs_;
    int	aval = ( lhs->value >= rhs->value );
    return aval;
}
#endif // scalar_scalar_int_int_int_operatorIAOPge

#ifndef scalar_iter_int_int_int_operatorIAOPge
#define scalar_iter_int_int_int_operatorIAOPge
static int scalar_iter_bo_operatorIAOPge(IA_BaseImage<IA_Point<int>, int> &lhs_,
	IA_BaseImage<IA_Point<int>, int> &rhs_)
{
    const IA_Set<IA_Point<int> > domain = lhs_.domain();
    const unsigned sz = domain.card();
    int *const vec = new int[sz];

    {
	int *ds = vec;
	IA_ConstI<IA_Point<int>, int> *lhs
		= (IA_ConstI<IA_Point<int>, int> *)&lhs_;
	int rtmp;
	IA_BaseIVIter<IA_Point<int>, int>	*riter = rhs_.value_iterator();
	for (unsigned i=0; i<sz; i++) {
	    riter->next(rtmp);
	    if (!( (lhs->value) >= (rtmp) ))
		return 0;
	}
	delete riter;
    }
    return 1;
}
#endif // scalar_iter_int_int_int_operatorIAOPge

#ifndef FILL_BOT_int_int_int_operatorIAOPge
#define FILL_BOT_int_int_int_operatorIAOPge
void IA_fill_Image_IP_int_int_int_operatorIAOPge_tbl()
{
    if (IA_Image_IP_int_int_int_operatorIAOPge_tbl)
	return;

    IA_BinaryOperationsTable<int,
	IA_BaseImage<IA_Point<int>, int>,
	IA_BaseImage<IA_Point<int>, int> >::function f;
    f = iter_iter_bo_operatorIAOPge;

    IA_Image_IP_int_int_int_operatorIAOPge_tbl = new IA_BinaryOperationsTable<int,
	IA_BaseImage<IA_Point<int>, int>,
	IA_BaseImage<IA_Point<int>, int> >(iter_iter_bo_operatorIAOPge);
    IA_Image_IP_int_int_int_operatorIAOPge_tbl->add_operation
	(IA_VectorI<IA_Point<int>, int>::s_type(),
	 IA_VectorI<IA_Point<int>, int>::s_type(),
	 vec_vec_bo_operatorIAOPge);
    IA_Image_IP_int_int_int_operatorIAOPge_tbl->add_operation
	(IA_VectorI<IA_Point<int>, int>::s_type(),
	 IA_ConstI<IA_Point<int>, int>::s_type(),
	 vec_scalar_bo_operatorIAOPge);
    IA_Image_IP_int_int_int_operatorIAOPge_tbl->add_operation
	(IA_VectorI<IA_Point<int>, int>::s_type(),
	 0,
	 vec_iter_bo_operatorIAOPge);

    IA_Image_IP_int_int_int_operatorIAOPge_tbl->add_operation
	(IA_ConstI<IA_Point<int>, int>::s_type(),
	 IA_VectorI<IA_Point<int>, int>::s_type(),
	 scalar_vec_bo_operatorIAOPge);
    IA_Image_IP_int_int_int_operatorIAOPge_tbl->add_operation
	(IA_ConstI<IA_Point<int>, int>::s_type(),
	 IA_ConstI<IA_Point<int>, int>::s_type(),
	 scalar_scalar_bo_operatorIAOPge);
    IA_Image_IP_int_int_int_operatorIAOPge_tbl->add_operation
	(IA_ConstI<IA_Point<int>, int>::s_type(),
	 0,
	 scalar_iter_bo_operatorIAOPge);

    IA_Image_IP_int_int_int_operatorIAOPge_tbl->add_operation
	(0,
	 IA_VectorI<IA_Point<int>, int>::s_type(),
	 iter_vec_bo_operatorIAOPge);
    IA_Image_IP_int_int_int_operatorIAOPge_tbl->add_operation
	(0,
	 IA_ConstI<IA_Point<int>, int>::s_type(),
	 iter_scalar_bo_operatorIAOPge);

}
#endif // BOT_int_int_int_operatorIAOPge

//////////////////////////////////////////////////////////////////////
//
// Begin operation support routines for :
// filename IIO-__gt.c
//
