// Emacs: -*- C++ -*-

//
//	Copyright 1994, Center for Computer Vision and Visualization,
//	University of Florida.  All rights reserved.
//


//
// $Log: FuncDT.h,v $

#ifndef FuncNbh_h_
#define FuncNbh_h_

#include "BaseNbh.h"

template <class P, class Q>
class IA_FunctionNbh :
public IA_BaseNbh<P,Q> {

    static char type_;

    IA_Set<P> (*f)(Q);		// variable named f (pointer to function)

public:

    IA_FunctionNbh(const IA_Set<Q> &s, IA_Set<P>(*f_)(Q))
	:IA_BaseNbh<P,Q>(s), f(f_) { }

    // default assignment, copy constructor, and destructor are just fine.

    IA_Set<P> operator()(const Q &q) const { return f(q); }

    IA::Type type() const { return &type_; }
    static IA::Type s_type() { return &type_; }

    ostream & print_this(ostream &) const
};

//

template <class P, class Q>
class IA_FunctionRefNbh :
public IA_BaseNbh<P,Q> {

    static char type_;

    IA_Set<P> (*f)(const Q&);		// variable named f (pointer to function)

public:

    IA_FunctionRefNbh(const IA_Set<Q> &s, IA_Set<P>(*f_)(const Q&))
	:IA_BaseNbh<P,Q>(s), f(f_) { }

    // default assignment, copy constructor, and destructor are just fine.

    IA_Set<P> operator()(const Q &q) const { return f(q); }

    IA::Type type() const { return &type_; }
    static IA::Type s_type() { return &type_; }

    ostream & print_this(ostream &) const
};

#endif // FuncNbh_h_
