// Emacs -*- C++ -*-

// Machine generated include file, do not modify.


// 	Copyright 1993, Center for Computer Vision and Visualization,
// 	University of Florida.  All rights reserved.


//  $Log: float-operations.desc,v $
//  Revision 1.11.1.2  1995/01/31  16:02:40  thoth
//  Need to replace the upward conversions with something...

//  Revision 1.11.1.1  1994/12/28  18:05:25  thoth
//  image operations are now friendly with FBI.
//  image ops now use operations table
//  new sgn() function.

//  Revision 1.11  1994/12/19  19:58:48  ljr
//  DOS-inspired name rework.

//  Revision 1.10  1994/10/14  20:43:19  thoth
//  The inline is much more useful in the header file.

//  Revision 1.9  1994/09/16  14:59:10  thoth
//  add fabs(image)

//  Revision 1.8  1994/07/08  16:14:11  thoth
//  fixed problems caused by returning floats instead of doubles.

//  Revision 1.7  1994/05/17  12:54:56  thoth
//  Improved operations generation scheme.  Lines from the op.desc file can
//  be quoted into the .c file to allow inclusion of infrastructure.  Also
//  the op.desc output can be redirected to several files.  The prefix
//  directive allows common information (include files) to be included in
//  every generated source file.

//  Float operations for the Float Discrete Image
#include "FloatDI.h"
#include "VectorI.h"
#include "ConstI.h"
#include "ImageIter.h"
#include "FBI.h"
#include "../valueset/OpTable.h"
template <class T>
inline T sqr(T v)
{
    return v*v;
}
//////////////////////////////////////////////////////////////////////
//
// Begin operation support routines for :
// unary pointwise sqrt I(float) I(float)
//
// Emacs: -*- C++ -*-

//
//	Copyright 1993, Center for Computer Vision and Visualization,
//	University of Florida.  All rights reserved.
//


//
// $Log: unary-op.templ,v $
// Revision 1.4.1.2  1995/01/13  19:37:42  thoth
// CoreImage has been re-merged with Image.  All special stuff should be
// friends of FBI now.
//
// Revision 1.4.1.1  1994/12/28  17:22:11  thoth
// image operations are friends of FBI now.
//
// Revision 1.4  1994/07/25  17:26:39  thoth
// Name sanitization
//
// Revision 1.3  1994/01/07  15:15:14  thoth
// Image class is now CoreImage and named image types are
// Image<P,T>.
//
// Revision 1.2  1993/12/29  17:33:18  thoth
// New operator scheme that prevents the need for trivial Image conversions.
//
// Revision 1.1  1993/09/15  13:07:16  thoth
// Initial revision
//
// Revision 1.2  93/05/27  11:49:04  thoth
// Copyright Notices
// 
// Revision 1.1  93/03/10  13:50:00  thoth
// Initial revision
// 

#ifndef UOT_float_float_sqrt
#define UOT_float_float_sqrt
IA_UnaryOperationsTable<IA_BaseImage<IA_Point<int>, float>*,
	IA_BaseImage<IA_Point<int>, float> >
	*IA_Image_IP_float_float_sqrt_tbl;

void IA_fill_Image_IP_float_float_sqrt_tbl();
#endif


IA_Image<IA_Point<int>, float>
sqrt ( const IA_Image<IA_Point<int>, float> &arg)
{
    if (!IA_Image_IP_float_float_sqrt_tbl)
	IA_fill_Image_IP_float_float_sqrt_tbl();

    IA_BaseImage<IA_Point<int>, float>*(*f)
	(IA_BaseImage<IA_Point<int>, float> &);
    f = IA_Image_IP_float_float_sqrt_tbl->lookup_operation (arg.type());

    
    IA_BaseImage<IA_Point<int>, float>	&bip =
	*IA_FBI<IA_Point<int>,IA_Point<int>,float,float,float>
	    ::extract_baseptr(arg);

    return IA_FBI<IA_Point<int>,IA_Point<int>, float,float,float>
	 ::make_Image(f(bip));
}

#ifndef vec_uop_float_float_sqrt
#define vec_uop_float_float_sqrt
static IA_BaseImage<IA_Point<int>, float>*
vec_uo_sqrt(IA_BaseImage<IA_Point<int>, float> &lhs_)
{
    const IA_VectorI<IA_Point<int>, float> *lhs =
	(IA_VectorI<IA_Point<int>, float> *) &lhs_;

    const IA_Set<IA_Point<int> > domain = lhs->domain();
    const unsigned sz = domain.card();
    float *const vec = new float[sz];

    {
	float *ds = vec;
	const float *ls = lhs->vec;
	for (unsigned i=0; i<sz; i++) {
	    *(ds++) = sqrt(*(ls++));
	}
    }
    return new IA_VectorI<IA_Point<int>, float>(domain, vec, sz, 1);
}
#endif // vec_uop_float_float_sqrt

#ifndef scalar_uop_float_float_sqrt
#define scalar_uop_float_float_sqrt
static IA_BaseImage<IA_Point<int>, float>*
scalar_uo_sqrt(IA_BaseImage<IA_Point<int>, float> &lhs_)
{
    const IA_ConstI<IA_Point<int>, float> *lhs =
	(IA_ConstI<IA_Point<int>, float> *) &lhs_;

    const IA_Set<IA_Point<int> > domain = lhs->domain();

    return new IA_ConstI<IA_Point<int>, float>(domain, sqrt(lhs->value));
}
#endif // scalar_uop_float_float_sqrt

// scalar-scalar operation is trivial

#ifndef iter_uop_float_float_sqrt
#define iter_uop_float_float_sqrt
static IA_BaseImage<IA_Point<int>, float>*
iter_uo_sqrt(IA_BaseImage<IA_Point<int>, float> &lhs)
{
    const IA_Set<IA_Point<int> > domain = lhs.domain();
    const unsigned sz = domain.card();
    float *const vec = new float[sz];

    {
	float *ds = vec;
	float ltmp;
	IA_BaseIVIter<IA_Point<int>, float>	*liter = lhs.value_iterator();
	for (unsigned i=0; i<sz; i++) {
	    liter->next(ltmp);
	    *(ds++) = sqrt(ltmp);
	}
	delete liter;
    }
    return new IA_VectorI<IA_Point<int>, float>(domain, vec, sz, 1);
}
#endif // iter_uop_float_float_sqrt

#ifndef FILL_UOT_float_float_sqrt
#define FILL_UOT_float_float_sqrt
void IA_fill_Image_IP_float_float_sqrt_tbl()
{
    if (IA_Image_IP_float_float_sqrt_tbl)
	return;

    IA_UnaryOperationsTable<IA_BaseImage<IA_Point<int>, float>*,
	IA_BaseImage<IA_Point<int>, float> >::function f;
    f = iter_uo_sqrt;

    IA_Image_IP_float_float_sqrt_tbl = new IA_UnaryOperationsTable<IA_BaseImage<IA_Point<int>, float>*,
	IA_BaseImage<IA_Point<int>, float> >(iter_uo_sqrt);
    IA_Image_IP_float_float_sqrt_tbl->add_operation
	(IA_VectorI<IA_Point<int>, float>::s_type(),
	 vec_uo_sqrt);
    IA_Image_IP_float_float_sqrt_tbl->add_operation
	(IA_ConstI<IA_Point<int>, float>::s_type(),
	 scalar_uo_sqrt);

}
#endif // UOT_float_float_sqrt

//////////////////////////////////////////////////////////////////////
//
// Begin operation support routines for :
// unary pointwise sqr I(float) I(float)
//
// Emacs: -*- C++ -*-

//
//	Copyright 1993, Center for Computer Vision and Visualization,
//	University of Florida.  All rights reserved.
//


//
// $Log: unary-op.templ,v $
// Revision 1.4.1.2  1995/01/13  19:37:42  thoth
// CoreImage has been re-merged with Image.  All special stuff should be
// friends of FBI now.
//
// Revision 1.4.1.1  1994/12/28  17:22:11  thoth
// image operations are friends of FBI now.
//
// Revision 1.4  1994/07/25  17:26:39  thoth
// Name sanitization
//
// Revision 1.3  1994/01/07  15:15:14  thoth
// Image class is now CoreImage and named image types are
// Image<P,T>.
//
// Revision 1.2  1993/12/29  17:33:18  thoth
// New operator scheme that prevents the need for trivial Image conversions.
//
// Revision 1.1  1993/09/15  13:07:16  thoth
// Initial revision
//
// Revision 1.2  93/05/27  11:49:04  thoth
// Copyright Notices
// 
// Revision 1.1  93/03/10  13:50:00  thoth
// Initial revision
// 

#ifndef UOT_float_float_sqr
#define UOT_float_float_sqr
IA_UnaryOperationsTable<IA_BaseImage<IA_Point<int>, float>*,
	IA_BaseImage<IA_Point<int>, float> >
	*IA_Image_IP_float_float_sqr_tbl;

void IA_fill_Image_IP_float_float_sqr_tbl();
#endif


IA_Image<IA_Point<int>, float>
sqr ( const IA_Image<IA_Point<int>, float> &arg)
{
    if (!IA_Image_IP_float_float_sqr_tbl)
	IA_fill_Image_IP_float_float_sqr_tbl();

    IA_BaseImage<IA_Point<int>, float>*(*f)
	(IA_BaseImage<IA_Point<int>, float> &);
    f = IA_Image_IP_float_float_sqr_tbl->lookup_operation (arg.type());

    
    IA_BaseImage<IA_Point<int>, float>	&bip =
	*IA_FBI<IA_Point<int>,IA_Point<int>,float,float,float>
	    ::extract_baseptr(arg);

    return IA_FBI<IA_Point<int>,IA_Point<int>, float,float,float>
	 ::make_Image(f(bip));
}

#ifndef vec_uop_float_float_sqr
#define vec_uop_float_float_sqr
static IA_BaseImage<IA_Point<int>, float>*
vec_uo_sqr(IA_BaseImage<IA_Point<int>, float> &lhs_)
{
    const IA_VectorI<IA_Point<int>, float> *lhs =
	(IA_VectorI<IA_Point<int>, float> *) &lhs_;

    const IA_Set<IA_Point<int> > domain = lhs->domain();
    const unsigned sz = domain.card();
    float *const vec = new float[sz];

    {
	float *ds = vec;
	const float *ls = lhs->vec;
	for (unsigned i=0; i<sz; i++) {
	    *(ds++) = sqr(*(ls++));
	}
    }
    return new IA_VectorI<IA_Point<int>, float>(domain, vec, sz, 1);
}
#endif // vec_uop_float_float_sqr

#ifndef scalar_uop_float_float_sqr
#define scalar_uop_float_float_sqr
static IA_BaseImage<IA_Point<int>, float>*
scalar_uo_sqr(IA_BaseImage<IA_Point<int>, float> &lhs_)
{
    const IA_ConstI<IA_Point<int>, float> *lhs =
	(IA_ConstI<IA_Point<int>, float> *) &lhs_;

    const IA_Set<IA_Point<int> > domain = lhs->domain();

    return new IA_ConstI<IA_Point<int>, float>(domain, sqr(lhs->value));
}
#endif // scalar_uop_float_float_sqr

// scalar-scalar operation is trivial

#ifndef iter_uop_float_float_sqr
#define iter_uop_float_float_sqr
static IA_BaseImage<IA_Point<int>, float>*
iter_uo_sqr(IA_BaseImage<IA_Point<int>, float> &lhs)
{
    const IA_Set<IA_Point<int> > domain = lhs.domain();
    const unsigned sz = domain.card();
    float *const vec = new float[sz];

    {
	float *ds = vec;
	float ltmp;
	IA_BaseIVIter<IA_Point<int>, float>	*liter = lhs.value_iterator();
	for (unsigned i=0; i<sz; i++) {
	    liter->next(ltmp);
	    *(ds++) = sqr(ltmp);
	}
	delete liter;
    }
    return new IA_VectorI<IA_Point<int>, float>(domain, vec, sz, 1);
}
#endif // iter_uop_float_float_sqr

#ifndef FILL_UOT_float_float_sqr
#define FILL_UOT_float_float_sqr
void IA_fill_Image_IP_float_float_sqr_tbl()
{
    if (IA_Image_IP_float_float_sqr_tbl)
	return;

    IA_UnaryOperationsTable<IA_BaseImage<IA_Point<int>, float>*,
	IA_BaseImage<IA_Point<int>, float> >::function f;
    f = iter_uo_sqr;

    IA_Image_IP_float_float_sqr_tbl = new IA_UnaryOperationsTable<IA_BaseImage<IA_Point<int>, float>*,
	IA_BaseImage<IA_Point<int>, float> >(iter_uo_sqr);
    IA_Image_IP_float_float_sqr_tbl->add_operation
	(IA_VectorI<IA_Point<int>, float>::s_type(),
	 vec_uo_sqr);
    IA_Image_IP_float_float_sqr_tbl->add_operation
	(IA_ConstI<IA_Point<int>, float>::s_type(),
	 scalar_uo_sqr);

}
#endif // UOT_float_float_sqr

//////////////////////////////////////////////////////////////////////
//
// Begin operation support routines for :
// unary pointwise fabs I(float) I(float)
//
// Emacs: -*- C++ -*-

//
//	Copyright 1993, Center for Computer Vision and Visualization,
//	University of Florida.  All rights reserved.
//


//
// $Log: unary-op.templ,v $
// Revision 1.4.1.2  1995/01/13  19:37:42  thoth
// CoreImage has been re-merged with Image.  All special stuff should be
// friends of FBI now.
//
// Revision 1.4.1.1  1994/12/28  17:22:11  thoth
// image operations are friends of FBI now.
//
// Revision 1.4  1994/07/25  17:26:39  thoth
// Name sanitization
//
// Revision 1.3  1994/01/07  15:15:14  thoth
// Image class is now CoreImage and named image types are
// Image<P,T>.
//
// Revision 1.2  1993/12/29  17:33:18  thoth
// New operator scheme that prevents the need for trivial Image conversions.
//
// Revision 1.1  1993/09/15  13:07:16  thoth
// Initial revision
//
// Revision 1.2  93/05/27  11:49:04  thoth
// Copyright Notices
// 
// Revision 1.1  93/03/10  13:50:00  thoth
// Initial revision
// 

#ifndef UOT_float_float_fabs
#define UOT_float_float_fabs
IA_UnaryOperationsTable<IA_BaseImage<IA_Point<int>, float>*,
	IA_BaseImage<IA_Point<int>, float> >
	*IA_Image_IP_float_float_fabs_tbl;

void IA_fill_Image_IP_float_float_fabs_tbl();
#endif


IA_Image<IA_Point<int>, float>
fabs ( const IA_Image<IA_Point<int>, float> &arg)
{
    if (!IA_Image_IP_float_float_fabs_tbl)
	IA_fill_Image_IP_float_float_fabs_tbl();

    IA_BaseImage<IA_Point<int>, float>*(*f)
	(IA_BaseImage<IA_Point<int>, float> &);
    f = IA_Image_IP_float_float_fabs_tbl->lookup_operation (arg.type());

    
    IA_BaseImage<IA_Point<int>, float>	&bip =
	*IA_FBI<IA_Point<int>,IA_Point<int>,float,float,float>
	    ::extract_baseptr(arg);

    return IA_FBI<IA_Point<int>,IA_Point<int>, float,float,float>
	 ::make_Image(f(bip));
}

#ifndef vec_uop_float_float_fabs
#define vec_uop_float_float_fabs
static IA_BaseImage<IA_Point<int>, float>*
vec_uo_fabs(IA_BaseImage<IA_Point<int>, float> &lhs_)
{
    const IA_VectorI<IA_Point<int>, float> *lhs =
	(IA_VectorI<IA_Point<int>, float> *) &lhs_;

    const IA_Set<IA_Point<int> > domain = lhs->domain();
    const unsigned sz = domain.card();
    float *const vec = new float[sz];

    {
	float *ds = vec;
	const float *ls = lhs->vec;
	for (unsigned i=0; i<sz; i++) {
	    *(ds++) = fabs(*(ls++));
	}
    }
    return new IA_VectorI<IA_Point<int>, float>(domain, vec, sz, 1);
}
#endif // vec_uop_float_float_fabs

#ifndef scalar_uop_float_float_fabs
#define scalar_uop_float_float_fabs
static IA_BaseImage<IA_Point<int>, float>*
scalar_uo_fabs(IA_BaseImage<IA_Point<int>, float> &lhs_)
{
    const IA_ConstI<IA_Point<int>, float> *lhs =
	(IA_ConstI<IA_Point<int>, float> *) &lhs_;

    const IA_Set<IA_Point<int> > domain = lhs->domain();

    return new IA_ConstI<IA_Point<int>, float>(domain, fabs(lhs->value));
}
#endif // scalar_uop_float_float_fabs

// scalar-scalar operation is trivial

#ifndef iter_uop_float_float_fabs
#define iter_uop_float_float_fabs
static IA_BaseImage<IA_Point<int>, float>*
iter_uo_fabs(IA_BaseImage<IA_Point<int>, float> &lhs)
{
    const IA_Set<IA_Point<int> > domain = lhs.domain();
    const unsigned sz = domain.card();
    float *const vec = new float[sz];

    {
	float *ds = vec;
	float ltmp;
	IA_BaseIVIter<IA_Point<int>, float>	*liter = lhs.value_iterator();
	for (unsigned i=0; i<sz; i++) {
	    liter->next(ltmp);
	    *(ds++) = fabs(ltmp);
	}
	delete liter;
    }
    return new IA_VectorI<IA_Point<int>, float>(domain, vec, sz, 1);
}
#endif // iter_uop_float_float_fabs

#ifndef FILL_UOT_float_float_fabs
#define FILL_UOT_float_float_fabs
void IA_fill_Image_IP_float_float_fabs_tbl()
{
    if (IA_Image_IP_float_float_fabs_tbl)
	return;

    IA_UnaryOperationsTable<IA_BaseImage<IA_Point<int>, float>*,
	IA_BaseImage<IA_Point<int>, float> >::function f;
    f = iter_uo_fabs;

    IA_Image_IP_float_float_fabs_tbl = new IA_UnaryOperationsTable<IA_BaseImage<IA_Point<int>, float>*,
	IA_BaseImage<IA_Point<int>, float> >(iter_uo_fabs);
    IA_Image_IP_float_float_fabs_tbl->add_operation
	(IA_VectorI<IA_Point<int>, float>::s_type(),
	 vec_uo_fabs);
    IA_Image_IP_float_float_fabs_tbl->add_operation
	(IA_ConstI<IA_Point<int>, float>::s_type(),
	 scalar_uo_fabs);

}
#endif // UOT_float_float_fabs

template <class T>
inline T sgn(T v)
{
    return (v>0)?1:(v<0)?-1:0;
}
//////////////////////////////////////////////////////////////////////
//
// Begin operation support routines for :
// unary pointwise sgn I(float) I(float)
//
// Emacs: -*- C++ -*-

//
//	Copyright 1993, Center for Computer Vision and Visualization,
//	University of Florida.  All rights reserved.
//


//
// $Log: unary-op.templ,v $
// Revision 1.4.1.2  1995/01/13  19:37:42  thoth
// CoreImage has been re-merged with Image.  All special stuff should be
// friends of FBI now.
//
// Revision 1.4.1.1  1994/12/28  17:22:11  thoth
// image operations are friends of FBI now.
//
// Revision 1.4  1994/07/25  17:26:39  thoth
// Name sanitization
//
// Revision 1.3  1994/01/07  15:15:14  thoth
// Image class is now CoreImage and named image types are
// Image<P,T>.
//
// Revision 1.2  1993/12/29  17:33:18  thoth
// New operator scheme that prevents the need for trivial Image conversions.
//
// Revision 1.1  1993/09/15  13:07:16  thoth
// Initial revision
//
// Revision 1.2  93/05/27  11:49:04  thoth
// Copyright Notices
// 
// Revision 1.1  93/03/10  13:50:00  thoth
// Initial revision
// 

#ifndef UOT_float_float_sgn
#define UOT_float_float_sgn
IA_UnaryOperationsTable<IA_BaseImage<IA_Point<int>, float>*,
	IA_BaseImage<IA_Point<int>, float> >
	*IA_Image_IP_float_float_sgn_tbl;

void IA_fill_Image_IP_float_float_sgn_tbl();
#endif


IA_Image<IA_Point<int>, float>
sgn ( const IA_Image<IA_Point<int>, float> &arg)
{
    if (!IA_Image_IP_float_float_sgn_tbl)
	IA_fill_Image_IP_float_float_sgn_tbl();

    IA_BaseImage<IA_Point<int>, float>*(*f)
	(IA_BaseImage<IA_Point<int>, float> &);
    f = IA_Image_IP_float_float_sgn_tbl->lookup_operation (arg.type());

    
    IA_BaseImage<IA_Point<int>, float>	&bip =
	*IA_FBI<IA_Point<int>,IA_Point<int>,float,float,float>
	    ::extract_baseptr(arg);

    return IA_FBI<IA_Point<int>,IA_Point<int>, float,float,float>
	 ::make_Image(f(bip));
}

#ifndef vec_uop_float_float_sgn
#define vec_uop_float_float_sgn
static IA_BaseImage<IA_Point<int>, float>*
vec_uo_sgn(IA_BaseImage<IA_Point<int>, float> &lhs_)
{
    const IA_VectorI<IA_Point<int>, float> *lhs =
	(IA_VectorI<IA_Point<int>, float> *) &lhs_;

    const IA_Set<IA_Point<int> > domain = lhs->domain();
    const unsigned sz = domain.card();
    float *const vec = new float[sz];

    {
	float *ds = vec;
	const float *ls = lhs->vec;
	for (unsigned i=0; i<sz; i++) {
	    *(ds++) = sgn(*(ls++));
	}
    }
    return new IA_VectorI<IA_Point<int>, float>(domain, vec, sz, 1);
}
#endif // vec_uop_float_float_sgn

#ifndef scalar_uop_float_float_sgn
#define scalar_uop_float_float_sgn
static IA_BaseImage<IA_Point<int>, float>*
scalar_uo_sgn(IA_BaseImage<IA_Point<int>, float> &lhs_)
{
    const IA_ConstI<IA_Point<int>, float> *lhs =
	(IA_ConstI<IA_Point<int>, float> *) &lhs_;

    const IA_Set<IA_Point<int> > domain = lhs->domain();

    return new IA_ConstI<IA_Point<int>, float>(domain, sgn(lhs->value));
}
#endif // scalar_uop_float_float_sgn

// scalar-scalar operation is trivial

#ifndef iter_uop_float_float_sgn
#define iter_uop_float_float_sgn
static IA_BaseImage<IA_Point<int>, float>*
iter_uo_sgn(IA_BaseImage<IA_Point<int>, float> &lhs)
{
    const IA_Set<IA_Point<int> > domain = lhs.domain();
    const unsigned sz = domain.card();
    float *const vec = new float[sz];

    {
	float *ds = vec;
	float ltmp;
	IA_BaseIVIter<IA_Point<int>, float>	*liter = lhs.value_iterator();
	for (unsigned i=0; i<sz; i++) {
	    liter->next(ltmp);
	    *(ds++) = sgn(ltmp);
	}
	delete liter;
    }
    return new IA_VectorI<IA_Point<int>, float>(domain, vec, sz, 1);
}
#endif // iter_uop_float_float_sgn

#ifndef FILL_UOT_float_float_sgn
#define FILL_UOT_float_float_sgn
void IA_fill_Image_IP_float_float_sgn_tbl()
{
    if (IA_Image_IP_float_float_sgn_tbl)
	return;

    IA_UnaryOperationsTable<IA_BaseImage<IA_Point<int>, float>*,
	IA_BaseImage<IA_Point<int>, float> >::function f;
    f = iter_uo_sgn;

    IA_Image_IP_float_float_sgn_tbl = new IA_UnaryOperationsTable<IA_BaseImage<IA_Point<int>, float>*,
	IA_BaseImage<IA_Point<int>, float> >(iter_uo_sgn);
    IA_Image_IP_float_float_sgn_tbl->add_operation
	(IA_VectorI<IA_Point<int>, float>::s_type(),
	 vec_uo_sgn);
    IA_Image_IP_float_float_sgn_tbl->add_operation
	(IA_ConstI<IA_Point<int>, float>::s_type(),
	 scalar_uo_sgn);

}
#endif // UOT_float_float_sgn

//////////////////////////////////////////////////////////////////////
//
// Begin operation support routines for :
// unary pointwise cos I(float) I(float)
//
// Emacs: -*- C++ -*-

//
//	Copyright 1993, Center for Computer Vision and Visualization,
//	University of Florida.  All rights reserved.
//


//
// $Log: unary-op.templ,v $
// Revision 1.4.1.2  1995/01/13  19:37:42  thoth
// CoreImage has been re-merged with Image.  All special stuff should be
// friends of FBI now.
//
// Revision 1.4.1.1  1994/12/28  17:22:11  thoth
// image operations are friends of FBI now.
//
// Revision 1.4  1994/07/25  17:26:39  thoth
// Name sanitization
//
// Revision 1.3  1994/01/07  15:15:14  thoth
// Image class is now CoreImage and named image types are
// Image<P,T>.
//
// Revision 1.2  1993/12/29  17:33:18  thoth
// New operator scheme that prevents the need for trivial Image conversions.
//
// Revision 1.1  1993/09/15  13:07:16  thoth
// Initial revision
//
// Revision 1.2  93/05/27  11:49:04  thoth
// Copyright Notices
// 
// Revision 1.1  93/03/10  13:50:00  thoth
// Initial revision
// 

#ifndef UOT_float_float_cos
#define UOT_float_float_cos
IA_UnaryOperationsTable<IA_BaseImage<IA_Point<int>, float>*,
	IA_BaseImage<IA_Point<int>, float> >
	*IA_Image_IP_float_float_cos_tbl;

void IA_fill_Image_IP_float_float_cos_tbl();
#endif


IA_Image<IA_Point<int>, float>
cos ( const IA_Image<IA_Point<int>, float> &arg)
{
    if (!IA_Image_IP_float_float_cos_tbl)
	IA_fill_Image_IP_float_float_cos_tbl();

    IA_BaseImage<IA_Point<int>, float>*(*f)
	(IA_BaseImage<IA_Point<int>, float> &);
    f = IA_Image_IP_float_float_cos_tbl->lookup_operation (arg.type());

    
    IA_BaseImage<IA_Point<int>, float>	&bip =
	*IA_FBI<IA_Point<int>,IA_Point<int>,float,float,float>
	    ::extract_baseptr(arg);

    return IA_FBI<IA_Point<int>,IA_Point<int>, float,float,float>
	 ::make_Image(f(bip));
}

#ifndef vec_uop_float_float_cos
#define vec_uop_float_float_cos
static IA_BaseImage<IA_Point<int>, float>*
vec_uo_cos(IA_BaseImage<IA_Point<int>, float> &lhs_)
{
    const IA_VectorI<IA_Point<int>, float> *lhs =
	(IA_VectorI<IA_Point<int>, float> *) &lhs_;

    const IA_Set<IA_Point<int> > domain = lhs->domain();
    const unsigned sz = domain.card();
    float *const vec = new float[sz];

    {
	float *ds = vec;
	const float *ls = lhs->vec;
	for (unsigned i=0; i<sz; i++) {
	    *(ds++) = cos(*(ls++));
	}
    }
    return new IA_VectorI<IA_Point<int>, float>(domain, vec, sz, 1);
}
#endif // vec_uop_float_float_cos

#ifndef scalar_uop_float_float_cos
#define scalar_uop_float_float_cos
static IA_BaseImage<IA_Point<int>, float>*
scalar_uo_cos(IA_BaseImage<IA_Point<int>, float> &lhs_)
{
    const IA_ConstI<IA_Point<int>, float> *lhs =
	(IA_ConstI<IA_Point<int>, float> *) &lhs_;

    const IA_Set<IA_Point<int> > domain = lhs->domain();

    return new IA_ConstI<IA_Point<int>, float>(domain, cos(lhs->value));
}
#endif // scalar_uop_float_float_cos

// scalar-scalar operation is trivial

#ifndef iter_uop_float_float_cos
#define iter_uop_float_float_cos
static IA_BaseImage<IA_Point<int>, float>*
iter_uo_cos(IA_BaseImage<IA_Point<int>, float> &lhs)
{
    const IA_Set<IA_Point<int> > domain = lhs.domain();
    const unsigned sz = domain.card();
    float *const vec = new float[sz];

    {
	float *ds = vec;
	float ltmp;
	IA_BaseIVIter<IA_Point<int>, float>	*liter = lhs.value_iterator();
	for (unsigned i=0; i<sz; i++) {
	    liter->next(ltmp);
	    *(ds++) = cos(ltmp);
	}
	delete liter;
    }
    return new IA_VectorI<IA_Point<int>, float>(domain, vec, sz, 1);
}
#endif // iter_uop_float_float_cos

#ifndef FILL_UOT_float_float_cos
#define FILL_UOT_float_float_cos
void IA_fill_Image_IP_float_float_cos_tbl()
{
    if (IA_Image_IP_float_float_cos_tbl)
	return;

    IA_UnaryOperationsTable<IA_BaseImage<IA_Point<int>, float>*,
	IA_BaseImage<IA_Point<int>, float> >::function f;
    f = iter_uo_cos;

    IA_Image_IP_float_float_cos_tbl = new IA_UnaryOperationsTable<IA_BaseImage<IA_Point<int>, float>*,
	IA_BaseImage<IA_Point<int>, float> >(iter_uo_cos);
    IA_Image_IP_float_float_cos_tbl->add_operation
	(IA_VectorI<IA_Point<int>, float>::s_type(),
	 vec_uo_cos);
    IA_Image_IP_float_float_cos_tbl->add_operation
	(IA_ConstI<IA_Point<int>, float>::s_type(),
	 scalar_uo_cos);

}
#endif // UOT_float_float_cos

//////////////////////////////////////////////////////////////////////
//
// Begin operation support routines for :
// unary pointwise sin I(float) I(float)
//
// Emacs: -*- C++ -*-

//
//	Copyright 1993, Center for Computer Vision and Visualization,
//	University of Florida.  All rights reserved.
//


//
// $Log: unary-op.templ,v $
// Revision 1.4.1.2  1995/01/13  19:37:42  thoth
// CoreImage has been re-merged with Image.  All special stuff should be
// friends of FBI now.
//
// Revision 1.4.1.1  1994/12/28  17:22:11  thoth
// image operations are friends of FBI now.
//
// Revision 1.4  1994/07/25  17:26:39  thoth
// Name sanitization
//
// Revision 1.3  1994/01/07  15:15:14  thoth
// Image class is now CoreImage and named image types are
// Image<P,T>.
//
// Revision 1.2  1993/12/29  17:33:18  thoth
// New operator scheme that prevents the need for trivial Image conversions.
//
// Revision 1.1  1993/09/15  13:07:16  thoth
// Initial revision
//
// Revision 1.2  93/05/27  11:49:04  thoth
// Copyright Notices
// 
// Revision 1.1  93/03/10  13:50:00  thoth
// Initial revision
// 

#ifndef UOT_float_float_sin
#define UOT_float_float_sin
IA_UnaryOperationsTable<IA_BaseImage<IA_Point<int>, float>*,
	IA_BaseImage<IA_Point<int>, float> >
	*IA_Image_IP_float_float_sin_tbl;

void IA_fill_Image_IP_float_float_sin_tbl();
#endif


IA_Image<IA_Point<int>, float>
sin ( const IA_Image<IA_Point<int>, float> &arg)
{
    if (!IA_Image_IP_float_float_sin_tbl)
	IA_fill_Image_IP_float_float_sin_tbl();

    IA_BaseImage<IA_Point<int>, float>*(*f)
	(IA_BaseImage<IA_Point<int>, float> &);
    f = IA_Image_IP_float_float_sin_tbl->lookup_operation (arg.type());

    
    IA_BaseImage<IA_Point<int>, float>	&bip =
	*IA_FBI<IA_Point<int>,IA_Point<int>,float,float,float>
	    ::extract_baseptr(arg);

    return IA_FBI<IA_Point<int>,IA_Point<int>, float,float,float>
	 ::make_Image(f(bip));
}

#ifndef vec_uop_float_float_sin
#define vec_uop_float_float_sin
static IA_BaseImage<IA_Point<int>, float>*
vec_uo_sin(IA_BaseImage<IA_Point<int>, float> &lhs_)
{
    const IA_VectorI<IA_Point<int>, float> *lhs =
	(IA_VectorI<IA_Point<int>, float> *) &lhs_;

    const IA_Set<IA_Point<int> > domain = lhs->domain();
    const unsigned sz = domain.card();
    float *const vec = new float[sz];

    {
	float *ds = vec;
	const float *ls = lhs->vec;
	for (unsigned i=0; i<sz; i++) {
	    *(ds++) = sin(*(ls++));
	}
    }
    return new IA_VectorI<IA_Point<int>, float>(domain, vec, sz, 1);
}
#endif // vec_uop_float_float_sin

#ifndef scalar_uop_float_float_sin
#define scalar_uop_float_float_sin
static IA_BaseImage<IA_Point<int>, float>*
scalar_uo_sin(IA_BaseImage<IA_Point<int>, float> &lhs_)
{
    const IA_ConstI<IA_Point<int>, float> *lhs =
	(IA_ConstI<IA_Point<int>, float> *) &lhs_;

    const IA_Set<IA_Point<int> > domain = lhs->domain();

    return new IA_ConstI<IA_Point<int>, float>(domain, sin(lhs->value));
}
#endif // scalar_uop_float_float_sin

// scalar-scalar operation is trivial

#ifndef iter_uop_float_float_sin
#define iter_uop_float_float_sin
static IA_BaseImage<IA_Point<int>, float>*
iter_uo_sin(IA_BaseImage<IA_Point<int>, float> &lhs)
{
    const IA_Set<IA_Point<int> > domain = lhs.domain();
    const unsigned sz = domain.card();
    float *const vec = new float[sz];

    {
	float *ds = vec;
	float ltmp;
	IA_BaseIVIter<IA_Point<int>, float>	*liter = lhs.value_iterator();
	for (unsigned i=0; i<sz; i++) {
	    liter->next(ltmp);
	    *(ds++) = sin(ltmp);
	}
	delete liter;
    }
    return new IA_VectorI<IA_Point<int>, float>(domain, vec, sz, 1);
}
#endif // iter_uop_float_float_sin

#ifndef FILL_UOT_float_float_sin
#define FILL_UOT_float_float_sin
void IA_fill_Image_IP_float_float_sin_tbl()
{
    if (IA_Image_IP_float_float_sin_tbl)
	return;

    IA_UnaryOperationsTable<IA_BaseImage<IA_Point<int>, float>*,
	IA_BaseImage<IA_Point<int>, float> >::function f;
    f = iter_uo_sin;

    IA_Image_IP_float_float_sin_tbl = new IA_UnaryOperationsTable<IA_BaseImage<IA_Point<int>, float>*,
	IA_BaseImage<IA_Point<int>, float> >(iter_uo_sin);
    IA_Image_IP_float_float_sin_tbl->add_operation
	(IA_VectorI<IA_Point<int>, float>::s_type(),
	 vec_uo_sin);
    IA_Image_IP_float_float_sin_tbl->add_operation
	(IA_ConstI<IA_Point<int>, float>::s_type(),
	 scalar_uo_sin);

}
#endif // UOT_float_float_sin

//////////////////////////////////////////////////////////////////////
//
// Begin operation support routines for :
// unary pointwise tan I(float) I(float)
//
// Emacs: -*- C++ -*-

//
//	Copyright 1993, Center for Computer Vision and Visualization,
//	University of Florida.  All rights reserved.
//


//
// $Log: unary-op.templ,v $
// Revision 1.4.1.2  1995/01/13  19:37:42  thoth
// CoreImage has been re-merged with Image.  All special stuff should be
// friends of FBI now.
//
// Revision 1.4.1.1  1994/12/28  17:22:11  thoth
// image operations are friends of FBI now.
//
// Revision 1.4  1994/07/25  17:26:39  thoth
// Name sanitization
//
// Revision 1.3  1994/01/07  15:15:14  thoth
// Image class is now CoreImage and named image types are
// Image<P,T>.
//
// Revision 1.2  1993/12/29  17:33:18  thoth
// New operator scheme that prevents the need for trivial Image conversions.
//
// Revision 1.1  1993/09/15  13:07:16  thoth
// Initial revision
//
// Revision 1.2  93/05/27  11:49:04  thoth
// Copyright Notices
// 
// Revision 1.1  93/03/10  13:50:00  thoth
// Initial revision
// 

#ifndef UOT_float_float_tan
#define UOT_float_float_tan
IA_UnaryOperationsTable<IA_BaseImage<IA_Point<int>, float>*,
	IA_BaseImage<IA_Point<int>, float> >
	*IA_Image_IP_float_float_tan_tbl;

void IA_fill_Image_IP_float_float_tan_tbl();
#endif


IA_Image<IA_Point<int>, float>
tan ( const IA_Image<IA_Point<int>, float> &arg)
{
    if (!IA_Image_IP_float_float_tan_tbl)
	IA_fill_Image_IP_float_float_tan_tbl();

    IA_BaseImage<IA_Point<int>, float>*(*f)
	(IA_BaseImage<IA_Point<int>, float> &);
    f = IA_Image_IP_float_float_tan_tbl->lookup_operation (arg.type());

    
    IA_BaseImage<IA_Point<int>, float>	&bip =
	*IA_FBI<IA_Point<int>,IA_Point<int>,float,float,float>
	    ::extract_baseptr(arg);

    return IA_FBI<IA_Point<int>,IA_Point<int>, float,float,float>
	 ::make_Image(f(bip));
}

#ifndef vec_uop_float_float_tan
#define vec_uop_float_float_tan
static IA_BaseImage<IA_Point<int>, float>*
vec_uo_tan(IA_BaseImage<IA_Point<int>, float> &lhs_)
{
    const IA_VectorI<IA_Point<int>, float> *lhs =
	(IA_VectorI<IA_Point<int>, float> *) &lhs_;

    const IA_Set<IA_Point<int> > domain = lhs->domain();
    const unsigned sz = domain.card();
    float *const vec = new float[sz];

    {
	float *ds = vec;
	const float *ls = lhs->vec;
	for (unsigned i=0; i<sz; i++) {
	    *(ds++) = tan(*(ls++));
	}
    }
    return new IA_VectorI<IA_Point<int>, float>(domain, vec, sz, 1);
}
#endif // vec_uop_float_float_tan

#ifndef scalar_uop_float_float_tan
#define scalar_uop_float_float_tan
static IA_BaseImage<IA_Point<int>, float>*
scalar_uo_tan(IA_BaseImage<IA_Point<int>, float> &lhs_)
{
    const IA_ConstI<IA_Point<int>, float> *lhs =
	(IA_ConstI<IA_Point<int>, float> *) &lhs_;

    const IA_Set<IA_Point<int> > domain = lhs->domain();

    return new IA_ConstI<IA_Point<int>, float>(domain, tan(lhs->value));
}
#endif // scalar_uop_float_float_tan

// scalar-scalar operation is trivial

#ifndef iter_uop_float_float_tan
#define iter_uop_float_float_tan
static IA_BaseImage<IA_Point<int>, float>*
iter_uo_tan(IA_BaseImage<IA_Point<int>, float> &lhs)
{
    const IA_Set<IA_Point<int> > domain = lhs.domain();
    const unsigned sz = domain.card();
    float *const vec = new float[sz];

    {
	float *ds = vec;
	float ltmp;
	IA_BaseIVIter<IA_Point<int>, float>	*liter = lhs.value_iterator();
	for (unsigned i=0; i<sz; i++) {
	    liter->next(ltmp);
	    *(ds++) = tan(ltmp);
	}
	delete liter;
    }
    return new IA_VectorI<IA_Point<int>, float>(domain, vec, sz, 1);
}
#endif // iter_uop_float_float_tan

#ifndef FILL_UOT_float_float_tan
#define FILL_UOT_float_float_tan
void IA_fill_Image_IP_float_float_tan_tbl()
{
    if (IA_Image_IP_float_float_tan_tbl)
	return;

    IA_UnaryOperationsTable<IA_BaseImage<IA_Point<int>, float>*,
	IA_BaseImage<IA_Point<int>, float> >::function f;
    f = iter_uo_tan;

    IA_Image_IP_float_float_tan_tbl = new IA_UnaryOperationsTable<IA_BaseImage<IA_Point<int>, float>*,
	IA_BaseImage<IA_Point<int>, float> >(iter_uo_tan);
    IA_Image_IP_float_float_tan_tbl->add_operation
	(IA_VectorI<IA_Point<int>, float>::s_type(),
	 vec_uo_tan);
    IA_Image_IP_float_float_tan_tbl->add_operation
	(IA_ConstI<IA_Point<int>, float>::s_type(),
	 scalar_uo_tan);

}
#endif // UOT_float_float_tan

//////////////////////////////////////////////////////////////////////
//
// Begin operation support routines for :
// unary pointwise exp I(float) I(float)
//
// Emacs: -*- C++ -*-

//
//	Copyright 1993, Center for Computer Vision and Visualization,
//	University of Florida.  All rights reserved.
//


//
// $Log: unary-op.templ,v $
// Revision 1.4.1.2  1995/01/13  19:37:42  thoth
// CoreImage has been re-merged with Image.  All special stuff should be
// friends of FBI now.
//
// Revision 1.4.1.1  1994/12/28  17:22:11  thoth
// image operations are friends of FBI now.
//
// Revision 1.4  1994/07/25  17:26:39  thoth
// Name sanitization
//
// Revision 1.3  1994/01/07  15:15:14  thoth
// Image class is now CoreImage and named image types are
// Image<P,T>.
//
// Revision 1.2  1993/12/29  17:33:18  thoth
// New operator scheme that prevents the need for trivial Image conversions.
//
// Revision 1.1  1993/09/15  13:07:16  thoth
// Initial revision
//
// Revision 1.2  93/05/27  11:49:04  thoth
// Copyright Notices
// 
// Revision 1.1  93/03/10  13:50:00  thoth
// Initial revision
// 

#ifndef UOT_float_float_exp
#define UOT_float_float_exp
IA_UnaryOperationsTable<IA_BaseImage<IA_Point<int>, float>*,
	IA_BaseImage<IA_Point<int>, float> >
	*IA_Image_IP_float_float_exp_tbl;

void IA_fill_Image_IP_float_float_exp_tbl();
#endif


IA_Image<IA_Point<int>, float>
exp ( const IA_Image<IA_Point<int>, float> &arg)
{
    if (!IA_Image_IP_float_float_exp_tbl)
	IA_fill_Image_IP_float_float_exp_tbl();

    IA_BaseImage<IA_Point<int>, float>*(*f)
	(IA_BaseImage<IA_Point<int>, float> &);
    f = IA_Image_IP_float_float_exp_tbl->lookup_operation (arg.type());

    
    IA_BaseImage<IA_Point<int>, float>	&bip =
	*IA_FBI<IA_Point<int>,IA_Point<int>,float,float,float>
	    ::extract_baseptr(arg);

    return IA_FBI<IA_Point<int>,IA_Point<int>, float,float,float>
	 ::make_Image(f(bip));
}

#ifndef vec_uop_float_float_exp
#define vec_uop_float_float_exp
static IA_BaseImage<IA_Point<int>, float>*
vec_uo_exp(IA_BaseImage<IA_Point<int>, float> &lhs_)
{
    const IA_VectorI<IA_Point<int>, float> *lhs =
	(IA_VectorI<IA_Point<int>, float> *) &lhs_;

    const IA_Set<IA_Point<int> > domain = lhs->domain();
    const unsigned sz = domain.card();
    float *const vec = new float[sz];

    {
	float *ds = vec;
	const float *ls = lhs->vec;
	for (unsigned i=0; i<sz; i++) {
	    *(ds++) = exp(*(ls++));
	}
    }
    return new IA_VectorI<IA_Point<int>, float>(domain, vec, sz, 1);
}
#endif // vec_uop_float_float_exp

#ifndef scalar_uop_float_float_exp
#define scalar_uop_float_float_exp
static IA_BaseImage<IA_Point<int>, float>*
scalar_uo_exp(IA_BaseImage<IA_Point<int>, float> &lhs_)
{
    const IA_ConstI<IA_Point<int>, float> *lhs =
	(IA_ConstI<IA_Point<int>, float> *) &lhs_;

    const IA_Set<IA_Point<int> > domain = lhs->domain();

    return new IA_ConstI<IA_Point<int>, float>(domain, exp(lhs->value));
}
#endif // scalar_uop_float_float_exp

// scalar-scalar operation is trivial

#ifndef iter_uop_float_float_exp
#define iter_uop_float_float_exp
static IA_BaseImage<IA_Point<int>, float>*
iter_uo_exp(IA_BaseImage<IA_Point<int>, float> &lhs)
{
    const IA_Set<IA_Point<int> > domain = lhs.domain();
    const unsigned sz = domain.card();
    float *const vec = new float[sz];

    {
	float *ds = vec;
	float ltmp;
	IA_BaseIVIter<IA_Point<int>, float>	*liter = lhs.value_iterator();
	for (unsigned i=0; i<sz; i++) {
	    liter->next(ltmp);
	    *(ds++) = exp(ltmp);
	}
	delete liter;
    }
    return new IA_VectorI<IA_Point<int>, float>(domain, vec, sz, 1);
}
#endif // iter_uop_float_float_exp

#ifndef FILL_UOT_float_float_exp
#define FILL_UOT_float_float_exp
void IA_fill_Image_IP_float_float_exp_tbl()
{
    if (IA_Image_IP_float_float_exp_tbl)
	return;

    IA_UnaryOperationsTable<IA_BaseImage<IA_Point<int>, float>*,
	IA_BaseImage<IA_Point<int>, float> >::function f;
    f = iter_uo_exp;

    IA_Image_IP_float_float_exp_tbl = new IA_UnaryOperationsTable<IA_BaseImage<IA_Point<int>, float>*,
	IA_BaseImage<IA_Point<int>, float> >(iter_uo_exp);
    IA_Image_IP_float_float_exp_tbl->add_operation
	(IA_VectorI<IA_Point<int>, float>::s_type(),
	 vec_uo_exp);
    IA_Image_IP_float_float_exp_tbl->add_operation
	(IA_ConstI<IA_Point<int>, float>::s_type(),
	 scalar_uo_exp);

}
#endif // UOT_float_float_exp

//////////////////////////////////////////////////////////////////////
//
// Begin operation support routines for :
// unary pointwise log I(float) I(float)
//
// Emacs: -*- C++ -*-

//
//	Copyright 1993, Center for Computer Vision and Visualization,
//	University of Florida.  All rights reserved.
//


//
// $Log: unary-op.templ,v $
// Revision 1.4.1.2  1995/01/13  19:37:42  thoth
// CoreImage has been re-merged with Image.  All special stuff should be
// friends of FBI now.
//
// Revision 1.4.1.1  1994/12/28  17:22:11  thoth
// image operations are friends of FBI now.
//
// Revision 1.4  1994/07/25  17:26:39  thoth
// Name sanitization
//
// Revision 1.3  1994/01/07  15:15:14  thoth
// Image class is now CoreImage and named image types are
// Image<P,T>.
//
// Revision 1.2  1993/12/29  17:33:18  thoth
// New operator scheme that prevents the need for trivial Image conversions.
//
// Revision 1.1  1993/09/15  13:07:16  thoth
// Initial revision
//
// Revision 1.2  93/05/27  11:49:04  thoth
// Copyright Notices
// 
// Revision 1.1  93/03/10  13:50:00  thoth
// Initial revision
// 

#ifndef UOT_float_float_log
#define UOT_float_float_log
IA_UnaryOperationsTable<IA_BaseImage<IA_Point<int>, float>*,
	IA_BaseImage<IA_Point<int>, float> >
	*IA_Image_IP_float_float_log_tbl;

void IA_fill_Image_IP_float_float_log_tbl();
#endif


IA_Image<IA_Point<int>, float>
log ( const IA_Image<IA_Point<int>, float> &arg)
{
    if (!IA_Image_IP_float_float_log_tbl)
	IA_fill_Image_IP_float_float_log_tbl();

    IA_BaseImage<IA_Point<int>, float>*(*f)
	(IA_BaseImage<IA_Point<int>, float> &);
    f = IA_Image_IP_float_float_log_tbl->lookup_operation (arg.type());

    
    IA_BaseImage<IA_Point<int>, float>	&bip =
	*IA_FBI<IA_Point<int>,IA_Point<int>,float,float,float>
	    ::extract_baseptr(arg);

    return IA_FBI<IA_Point<int>,IA_Point<int>, float,float,float>
	 ::make_Image(f(bip));
}

#ifndef vec_uop_float_float_log
#define vec_uop_float_float_log
static IA_BaseImage<IA_Point<int>, float>*
vec_uo_log(IA_BaseImage<IA_Point<int>, float> &lhs_)
{
    const IA_VectorI<IA_Point<int>, float> *lhs =
	(IA_VectorI<IA_Point<int>, float> *) &lhs_;

    const IA_Set<IA_Point<int> > domain = lhs->domain();
    const unsigned sz = domain.card();
    float *const vec = new float[sz];

    {
	float *ds = vec;
	const float *ls = lhs->vec;
	for (unsigned i=0; i<sz; i++) {
	    *(ds++) = log(*(ls++));
	}
    }
    return new IA_VectorI<IA_Point<int>, float>(domain, vec, sz, 1);
}
#endif // vec_uop_float_float_log

#ifndef scalar_uop_float_float_log
#define scalar_uop_float_float_log
static IA_BaseImage<IA_Point<int>, float>*
scalar_uo_log(IA_BaseImage<IA_Point<int>, float> &lhs_)
{
    const IA_ConstI<IA_Point<int>, float> *lhs =
	(IA_ConstI<IA_Point<int>, float> *) &lhs_;

    const IA_Set<IA_Point<int> > domain = lhs->domain();

    return new IA_ConstI<IA_Point<int>, float>(domain, log(lhs->value));
}
#endif // scalar_uop_float_float_log

// scalar-scalar operation is trivial

#ifndef iter_uop_float_float_log
#define iter_uop_float_float_log
static IA_BaseImage<IA_Point<int>, float>*
iter_uo_log(IA_BaseImage<IA_Point<int>, float> &lhs)
{
    const IA_Set<IA_Point<int> > domain = lhs.domain();
    const unsigned sz = domain.card();
    float *const vec = new float[sz];

    {
	float *ds = vec;
	float ltmp;
	IA_BaseIVIter<IA_Point<int>, float>	*liter = lhs.value_iterator();
	for (unsigned i=0; i<sz; i++) {
	    liter->next(ltmp);
	    *(ds++) = log(ltmp);
	}
	delete liter;
    }
    return new IA_VectorI<IA_Point<int>, float>(domain, vec, sz, 1);
}
#endif // iter_uop_float_float_log

#ifndef FILL_UOT_float_float_log
#define FILL_UOT_float_float_log
void IA_fill_Image_IP_float_float_log_tbl()
{
    if (IA_Image_IP_float_float_log_tbl)
	return;

    IA_UnaryOperationsTable<IA_BaseImage<IA_Point<int>, float>*,
	IA_BaseImage<IA_Point<int>, float> >::function f;
    f = iter_uo_log;

    IA_Image_IP_float_float_log_tbl = new IA_UnaryOperationsTable<IA_BaseImage<IA_Point<int>, float>*,
	IA_BaseImage<IA_Point<int>, float> >(iter_uo_log);
    IA_Image_IP_float_float_log_tbl->add_operation
	(IA_VectorI<IA_Point<int>, float>::s_type(),
	 vec_uo_log);
    IA_Image_IP_float_float_log_tbl->add_operation
	(IA_ConstI<IA_Point<int>, float>::s_type(),
	 scalar_uo_log);

}
#endif // UOT_float_float_log

//////////////////////////////////////////////////////////////////////
//
// Begin operation support routines for :
// unary pointwise ceil I(float) I(float)
//
// Emacs: -*- C++ -*-

//
//	Copyright 1993, Center for Computer Vision and Visualization,
//	University of Florida.  All rights reserved.
//


//
// $Log: unary-op.templ,v $
// Revision 1.4.1.2  1995/01/13  19:37:42  thoth
// CoreImage has been re-merged with Image.  All special stuff should be
// friends of FBI now.
//
// Revision 1.4.1.1  1994/12/28  17:22:11  thoth
// image operations are friends of FBI now.
//
// Revision 1.4  1994/07/25  17:26:39  thoth
// Name sanitization
//
// Revision 1.3  1994/01/07  15:15:14  thoth
// Image class is now CoreImage and named image types are
// Image<P,T>.
//
// Revision 1.2  1993/12/29  17:33:18  thoth
// New operator scheme that prevents the need for trivial Image conversions.
//
// Revision 1.1  1993/09/15  13:07:16  thoth
// Initial revision
//
// Revision 1.2  93/05/27  11:49:04  thoth
// Copyright Notices
// 
// Revision 1.1  93/03/10  13:50:00  thoth
// Initial revision
// 

#ifndef UOT_float_float_ceil
#define UOT_float_float_ceil
IA_UnaryOperationsTable<IA_BaseImage<IA_Point<int>, float>*,
	IA_BaseImage<IA_Point<int>, float> >
	*IA_Image_IP_float_float_ceil_tbl;

void IA_fill_Image_IP_float_float_ceil_tbl();
#endif


IA_Image<IA_Point<int>, float>
ceil ( const IA_Image<IA_Point<int>, float> &arg)
{
    if (!IA_Image_IP_float_float_ceil_tbl)
	IA_fill_Image_IP_float_float_ceil_tbl();

    IA_BaseImage<IA_Point<int>, float>*(*f)
	(IA_BaseImage<IA_Point<int>, float> &);
    f = IA_Image_IP_float_float_ceil_tbl->lookup_operation (arg.type());

    
    IA_BaseImage<IA_Point<int>, float>	&bip =
	*IA_FBI<IA_Point<int>,IA_Point<int>,float,float,float>
	    ::extract_baseptr(arg);

    return IA_FBI<IA_Point<int>,IA_Point<int>, float,float,float>
	 ::make_Image(f(bip));
}

#ifndef vec_uop_float_float_ceil
#define vec_uop_float_float_ceil
static IA_BaseImage<IA_Point<int>, float>*
vec_uo_ceil(IA_BaseImage<IA_Point<int>, float> &lhs_)
{
    const IA_VectorI<IA_Point<int>, float> *lhs =
	(IA_VectorI<IA_Point<int>, float> *) &lhs_;

    const IA_Set<IA_Point<int> > domain = lhs->domain();
    const unsigned sz = domain.card();
    float *const vec = new float[sz];

    {
	float *ds = vec;
	const float *ls = lhs->vec;
	for (unsigned i=0; i<sz; i++) {
	    *(ds++) = ceil(*(ls++));
	}
    }
    return new IA_VectorI<IA_Point<int>, float>(domain, vec, sz, 1);
}
#endif // vec_uop_float_float_ceil

#ifndef scalar_uop_float_float_ceil
#define scalar_uop_float_float_ceil
static IA_BaseImage<IA_Point<int>, float>*
scalar_uo_ceil(IA_BaseImage<IA_Point<int>, float> &lhs_)
{
    const IA_ConstI<IA_Point<int>, float> *lhs =
	(IA_ConstI<IA_Point<int>, float> *) &lhs_;

    const IA_Set<IA_Point<int> > domain = lhs->domain();

    return new IA_ConstI<IA_Point<int>, float>(domain, ceil(lhs->value));
}
#endif // scalar_uop_float_float_ceil

// scalar-scalar operation is trivial

#ifndef iter_uop_float_float_ceil
#define iter_uop_float_float_ceil
static IA_BaseImage<IA_Point<int>, float>*
iter_uo_ceil(IA_BaseImage<IA_Point<int>, float> &lhs)
{
    const IA_Set<IA_Point<int> > domain = lhs.domain();
    const unsigned sz = domain.card();
    float *const vec = new float[sz];

    {
	float *ds = vec;
	float ltmp;
	IA_BaseIVIter<IA_Point<int>, float>	*liter = lhs.value_iterator();
	for (unsigned i=0; i<sz; i++) {
	    liter->next(ltmp);
	    *(ds++) = ceil(ltmp);
	}
	delete liter;
    }
    return new IA_VectorI<IA_Point<int>, float>(domain, vec, sz, 1);
}
#endif // iter_uop_float_float_ceil

#ifndef FILL_UOT_float_float_ceil
#define FILL_UOT_float_float_ceil
void IA_fill_Image_IP_float_float_ceil_tbl()
{
    if (IA_Image_IP_float_float_ceil_tbl)
	return;

    IA_UnaryOperationsTable<IA_BaseImage<IA_Point<int>, float>*,
	IA_BaseImage<IA_Point<int>, float> >::function f;
    f = iter_uo_ceil;

    IA_Image_IP_float_float_ceil_tbl = new IA_UnaryOperationsTable<IA_BaseImage<IA_Point<int>, float>*,
	IA_BaseImage<IA_Point<int>, float> >(iter_uo_ceil);
    IA_Image_IP_float_float_ceil_tbl->add_operation
	(IA_VectorI<IA_Point<int>, float>::s_type(),
	 vec_uo_ceil);
    IA_Image_IP_float_float_ceil_tbl->add_operation
	(IA_ConstI<IA_Point<int>, float>::s_type(),
	 scalar_uo_ceil);

}
#endif // UOT_float_float_ceil

//////////////////////////////////////////////////////////////////////
//
// Begin operation support routines for :
// unary pointwise floor I(float) I(float)
//
// Emacs: -*- C++ -*-

//
//	Copyright 1993, Center for Computer Vision and Visualization,
//	University of Florida.  All rights reserved.
//


//
// $Log: unary-op.templ,v $
// Revision 1.4.1.2  1995/01/13  19:37:42  thoth
// CoreImage has been re-merged with Image.  All special stuff should be
// friends of FBI now.
//
// Revision 1.4.1.1  1994/12/28  17:22:11  thoth
// image operations are friends of FBI now.
//
// Revision 1.4  1994/07/25  17:26:39  thoth
// Name sanitization
//
// Revision 1.3  1994/01/07  15:15:14  thoth
// Image class is now CoreImage and named image types are
// Image<P,T>.
//
// Revision 1.2  1993/12/29  17:33:18  thoth
// New operator scheme that prevents the need for trivial Image conversions.
//
// Revision 1.1  1993/09/15  13:07:16  thoth
// Initial revision
//
// Revision 1.2  93/05/27  11:49:04  thoth
// Copyright Notices
// 
// Revision 1.1  93/03/10  13:50:00  thoth
// Initial revision
// 

#ifndef UOT_float_float_floor
#define UOT_float_float_floor
IA_UnaryOperationsTable<IA_BaseImage<IA_Point<int>, float>*,
	IA_BaseImage<IA_Point<int>, float> >
	*IA_Image_IP_float_float_floor_tbl;

void IA_fill_Image_IP_float_float_floor_tbl();
#endif


IA_Image<IA_Point<int>, float>
floor ( const IA_Image<IA_Point<int>, float> &arg)
{
    if (!IA_Image_IP_float_float_floor_tbl)
	IA_fill_Image_IP_float_float_floor_tbl();

    IA_BaseImage<IA_Point<int>, float>*(*f)
	(IA_BaseImage<IA_Point<int>, float> &);
    f = IA_Image_IP_float_float_floor_tbl->lookup_operation (arg.type());

    
    IA_BaseImage<IA_Point<int>, float>	&bip =
	*IA_FBI<IA_Point<int>,IA_Point<int>,float,float,float>
	    ::extract_baseptr(arg);

    return IA_FBI<IA_Point<int>,IA_Point<int>, float,float,float>
	 ::make_Image(f(bip));
}

#ifndef vec_uop_float_float_floor
#define vec_uop_float_float_floor
static IA_BaseImage<IA_Point<int>, float>*
vec_uo_floor(IA_BaseImage<IA_Point<int>, float> &lhs_)
{
    const IA_VectorI<IA_Point<int>, float> *lhs =
	(IA_VectorI<IA_Point<int>, float> *) &lhs_;

    const IA_Set<IA_Point<int> > domain = lhs->domain();
    const unsigned sz = domain.card();
    float *const vec = new float[sz];

    {
	float *ds = vec;
	const float *ls = lhs->vec;
	for (unsigned i=0; i<sz; i++) {
	    *(ds++) = floor(*(ls++));
	}
    }
    return new IA_VectorI<IA_Point<int>, float>(domain, vec, sz, 1);
}
#endif // vec_uop_float_float_floor

#ifndef scalar_uop_float_float_floor
#define scalar_uop_float_float_floor
static IA_BaseImage<IA_Point<int>, float>*
scalar_uo_floor(IA_BaseImage<IA_Point<int>, float> &lhs_)
{
    const IA_ConstI<IA_Point<int>, float> *lhs =
	(IA_ConstI<IA_Point<int>, float> *) &lhs_;

    const IA_Set<IA_Point<int> > domain = lhs->domain();

    return new IA_ConstI<IA_Point<int>, float>(domain, floor(lhs->value));
}
#endif // scalar_uop_float_float_floor

// scalar-scalar operation is trivial

#ifndef iter_uop_float_float_floor
#define iter_uop_float_float_floor
static IA_BaseImage<IA_Point<int>, float>*
iter_uo_floor(IA_BaseImage<IA_Point<int>, float> &lhs)
{
    const IA_Set<IA_Point<int> > domain = lhs.domain();
    const unsigned sz = domain.card();
    float *const vec = new float[sz];

    {
	float *ds = vec;
	float ltmp;
	IA_BaseIVIter<IA_Point<int>, float>	*liter = lhs.value_iterator();
	for (unsigned i=0; i<sz; i++) {
	    liter->next(ltmp);
	    *(ds++) = floor(ltmp);
	}
	delete liter;
    }
    return new IA_VectorI<IA_Point<int>, float>(domain, vec, sz, 1);
}
#endif // iter_uop_float_float_floor

#ifndef FILL_UOT_float_float_floor
#define FILL_UOT_float_float_floor
void IA_fill_Image_IP_float_float_floor_tbl()
{
    if (IA_Image_IP_float_float_floor_tbl)
	return;

    IA_UnaryOperationsTable<IA_BaseImage<IA_Point<int>, float>*,
	IA_BaseImage<IA_Point<int>, float> >::function f;
    f = iter_uo_floor;

    IA_Image_IP_float_float_floor_tbl = new IA_UnaryOperationsTable<IA_BaseImage<IA_Point<int>, float>*,
	IA_BaseImage<IA_Point<int>, float> >(iter_uo_floor);
    IA_Image_IP_float_float_floor_tbl->add_operation
	(IA_VectorI<IA_Point<int>, float>::s_type(),
	 vec_uo_floor);
    IA_Image_IP_float_float_floor_tbl->add_operation
	(IA_ConstI<IA_Point<int>, float>::s_type(),
	 scalar_uo_floor);

}
#endif // UOT_float_float_floor

//////////////////////////////////////////////////////////////////////
//
// Begin operation support routines for :
// filename FIO-minmax.c
//
