// Emacs: -*- C++ -*-

//
//	Copyright 1993, Center for Computer Vision and Visualization,
//	University of Florida.  All rights reserved.
//


//
// $Log: ConstImageIter.c,v $
// Revision 1.1  1993/09/15  12:51:20  thoth
// Initial revision
//

#include "ConstImageIter.h"

template < class P,class T>
IA_ConstIVIter<P,T>::IA_ConstIVIter(const IA_ConstI<P,T> *img)
: IA_BaseIVIter<P,T>(img)
{
    this->num_left = img->domain().card();
}

template < class P,class T>
IA_ConstIVIter<P,T>::IA_ConstIVIter(const IA_ConstIVIter<P,T> &iter)
: IA_BaseIVIter<P,T>(iter.domain)
{
    this->num_left = iter.num_left;
}

template < class P,class T>
int IA_ConstIVIter<P,T>::next(T& pixel_value)
{
    if (this->num_left--) {
	pixel_value = this->cip()->value;
	return 1;
    }
    return 0;
}


//
//


template < class P,class T>
IA_ConstIPIter<P,T>::IA_ConstIPIter(const IA_ConstI<P,T> *img)
: IA_BaseIPIter<P,T>(img), psiter(img->domain())
{
}

template < class P,class T>
IA_ConstIPIter<P,T>::IA_ConstIPIter(const IA_ConstIPIter<P,T> &iter)
: IA_BaseIPIter<P,T>(iter.domain), psiter(iter.psiter)
{
}

template < class P,class T>
int IA_ConstIPIter<P,T>::next(P& pixel_location, T& pixel_value)
{
    if (psiter(pixel_location)) {
	pixel_value = this->cip()->value;
	return 1;
    }
    return 0;
}





