// Emacs -*- C++ -*-

// 	Copyright 1993, Center for Computer Vision and Visualization,
// 	University of Florida.  All rights reserved.


//
//  $Log: Bit.h,v $
// Revision 1.1  1994/01/31  16:32:26  thoth
// Initial revision
//

#ifndef IA_Bit_h_
#define IA_Bit_h_

#include <iostream.h>

class IA_Bit {
    char	val;			/* always 0 or 1 */
public:
    IA_Bit() {}
    IA_Bit(int v) { val = (v!=0); }

    operator int () const { return val; }

    operator=(int v) { val = (v!=0); return *this; }

    friend int operator<=(IA_Bit lhs, IA_Bit rhs) { return lhs.val <= rhs.val;}
    friend int operator<(IA_Bit lhs, IA_Bit rhs) { return lhs.val < rhs.val; }
    friend operator==(IA_Bit lhs, IA_Bit rhs) { return lhs.val == rhs.val; }
    friend operator!=(IA_Bit lhs, IA_Bit rhs) { return lhs.val != rhs.val; }
    friend int operator>(IA_Bit lhs, IA_Bit rhs) { return lhs.val > rhs.val; }
    friend int operator>=(IA_Bit lhs, IA_Bit rhs) { return lhs.val >= rhs.val;}

    friend operator&(IA_Bit lhs, IA_Bit rhs) { return lhs.val & rhs.val; }
    friend operator|(IA_Bit lhs, IA_Bit rhs) { return lhs.val | rhs.val; }
    friend operator^(IA_Bit lhs, IA_Bit rhs) { return lhs.val ^ rhs.val; }
    IA_Bit & operator&=(IA_Bit arg) { val &= arg.val; return *this; }
    IA_Bit & operator|=(IA_Bit arg) { val |= arg.val; return *this; }
    IA_Bit & operator^=(IA_Bit arg) { val ^= arg.val; return *this; }
    operator!() const { return !val; }


    friend ostream & operator<<( ostream &o, IA_Bit b) {
	return o << (int)b.val;
    }
};

template <class T>
inline T operator*(IA_Bit b, T val) { return b ? val : 0; }

template <class T>
inline T operator*(T val, IA_Bit b) { return b ? val : 0; }

#endif // IA_Bit_h_
