#!/local/bin/perl

# Copyright 1994, Center for Computer Vision and Visualization,
#	University of Florida.  All rights reserved.

# $Log: genmactmplinst.perl,v $
# Revision 1.3  1994/08/26  19:27:04  gmt
# Added ability to drop closure file on icon to run script in the
# directory of the closure file.
#
# Revision 1.2  1994/08/26  19:00:10  gmt
# fixed the comment character. . .
#
# Revision 1.1  1994/08/17  01:45:57  gmt
# Initial revision
#

# $Id: genmactmplinst.perl,v 1.3 1994/08/26 19:27:04 gmt Exp $

#$path_prefix = 'instances:';
#$include_prefix = "";

$closure_file = shift( @ARGV );

open( IN, "<$closure_file" );

#print STDERR $closure_file, "\n";

$path_prefix = $closure_file;

$path_prefix =~ s/^(.*:)[^:]*$/$1/;

open( FILES, ">$path_prefix" . "tmpl.lst" );

#print STDERR $path_prefix;

while( <IN> )
{
    # Check on the "def" before removing any comments since it contains
    # the comment string.
    if( m,\s*//\s*def\s+(["<].*[">]), )
    {
	$def = $1;
	next;
    }

    # Remove comments.
    s,//.*$,,;

    if( /^\s*$/ )
    {
	next;
    }
    elsif( /^\s*#\s*include\s+.*$/ )
    {
	$includes .= $_;
    }
    elsif( /\s*template\s+class\s+(.*);/ )
    {
	# class instantiation
	print FILES "$path_prefix$1.c\n";
	open( OUT, ">$path_prefix$1.c" );
	print OUT $includes;
	print OUT "#include $def\n";
	print OUT "#pragma template_access public\n";
	print OUT "#pragma template $1\n";
	close( OUT );
    }
    elsif( /\s*template\s+\S+\s+(.*)::(.*);/ )
    {
	# Member function.
	print FILES "$path_prefix$1__$2.c\n";
	open( OUT, ">$path_prefix$1__$2.c" );
	print OUT $includes;
	print OUT "#include $def\n";
	print OUT "#pragma template_access public\n";
	print OUT "#pragma template $1::$2\n";
	close( OUT );
    }
    elsif( /\s*template\s+\S+\s+(.*);/ )
    {
	# Regular function
	print FILES "$path_prefix$1.c\n";
	open( OUT, ">$path_prefix$1.c" );
	print OUT $includes;
	print OUT "#include $def\n";
	print OUT "#pragma template_access public\n";
	print OUT "#pragma template $1\n";
	close( OUT );
    }
    else
    {
	print STDERR "Do not under stand the following line, ignoring:\n";
	print "$_\n";
    }
}

close( FILES );
