// point_example.05.c        Point member functions

#include "IntPoint.h"
#include "DblPoint.h"

int main()
{
    IA_Point<int> ipoint1(1,2,3), ipoint2;

    // dim() is a member function, so its syntax used the dot notation
    cout << "ipoint1 has value " << ipoint1 << "\n";
    cout << ipoint1.dim() << "\n";	// dimensionality of ipoint1 is 3

    // enorm() is not member function, so it uses normal C syntax
    cout << enorm( ipoint1 ) << "\n";
    // enorm in this case is sqrt(1*1 + 2*2 + 3*3 ) ~ 3.74166

    // derange() is a not member function
    ipoint2 = derange(ipoint1,2,1,2,0);
    // ipoint2 is now a 4D point with coordinate values
    // ipoint[2], ipoint[1], ipoint[2], ipoint[0]

    cout << "ipoint2 has value " << ipoint2 << "\n";

    // concat() is a friend function, and hence does *NOT*
    //    use dot notation
    // concat(ipoint1,ipoint2) == <1 2 3 3 2 3 1>
    cout << "concat(ipoint1,ipoint2) has value "
	 << concat(ipoint1,ipoint2)
	 << "\n";

    return 0;
}
