// point_example.02.c        Further point constructor examples

#include "IntPoint.h"
#include "DblPoint.h"

int iarray[] = { 0, 1, 2, 3 };

double farray[] = { 0.0, 1.1, 2.2, 3.3, 4.4, 5.5, 6.6, 7.7, 8.8, 9.9 };

int main()
{
    IA_Point<int> ipoint4(iarray, 4);
    // ipoint4 is 4D point initialized from the array iarray

    IA_Point<double> fpoint10(farray, 10);
    // fpoint10 is a 10D point initialized from the array farray
	
    cout << "ipoint4 has value " << ipoint4 << "\n";
    cout << "fpoint10 has value " << fpoint10 << "\n";

    IA_Point<int> ipoint;		// ipoint has no initial value
    ipoint = ipoint4;           // ipoint is assigned ipoint4\'s value

    IA_Point<double> fpoint(ipoint4);
    // fpoint is initialized with ipoint4\'s value

    cout << "ipoint has value " << ipoint << "\n";
    cout << "fpoint has value " << fpoint << "\n";

    return 0;
}
