// loop-ps.h
//      Copyright 1994, Center for Computer Vision and Visualization,
//      University of Florida.  All rights reserved.
//   Create a point set, where each point represents the possible
//   values of indices in nested for loops.
//   We assume that the nested loops have the following properties:
//
//   An over all range from:           start..end
//   The outmost loop starts at value: start
//   The inmost loop stops at value:   end
//   Each inner loop begins at a value 1 > the next most outer loop.
//   Each inner loop ends at a value   1 < the next most inner loop.
//
//   NOTE: a more flexible interface could pass the number of loops,
//         and two parallel arrays, one with loop starting values,
//         and one with loop ending values.


#ifndef IA_loop_ps_h_
#define IA_loop_ps_h_

#include "IntPointSet.h"

IA_Set<IA_Point<int> >
loop_ps( unsigned int d_loops, int start, int end );

#endif
