// Emacs: -*- C++ -*-

//
//	Copyright 1993, Center for Computer Vision and Visualization,
//	University of Florida.  All rights reserved.
//

static char copyright[] = "Copyright 1993, Center for Computer Vision and Visualization,\nUniversity of Florida.  All rights reserved.\n";

static char closure_c_rcsid[] = "$Id: closure.c,v 1.8 1994/01/31 16:35:07 thoth Exp $";

//
// $Log: closure.c,v $
// Revision 1.8  1994/01/31  16:35:07  thoth
// We now have ValueSets of IA_Bits.
//
// Revision 1.7  1993/11/17  17:58:49  thoth
// added complex, removed char and double for now.
// Pointcmp is now pointcmp.
//
// Revision 1.6  1993/09/15  12:28:54  thoth
// ValueSet<double>
//
// Revision 1.5  93/08/18  16:56:25  thoth
// added support for ValueSet<char> so that bit image work can continue.
// 
// Revision 1.4  93/06/10  17:10:05  thoth
// more placebos for 3.0.1
// 
// Revision 1.3  93/05/26  16:32:09  thoth
// Copyright Notices
// 
// Revision 1.2  93/05/26  13:49:04  thoth
// add the ValueSet<FloatPoint> for FloatPointSet
// 
// Revision 1.1  93/04/17  20:16:48  thoth
// Initial revision
// 
//

#include <iostream.h>
#include <complex.h>
#include "FloatPoint.h"
#include "Bit.h"
#include "ValueSet.h"

#define exercise_VS(T)				\
static void nothing(T *)			\
{						\
  IA_ValueSet<T>	vs1,vs2(1,2,3,4,5);	\
  T	temp;					\
						\
  vs1=vs2;					\
  (void)vs1.contains(vs1.min());		\
  (void)vs2.contains(vs2.max());		\
  (void)vs2.empty();				\
						\
  (void)(vs1&vs2);				\
  (void)(vs1|vs2);				\
  (void)(vs1/vs2);				\
  (void)(vs1^vs2);				\
						\
  (void)(vs1&temp);				\
  (void)(vs1|temp);				\
  (void)(vs1/temp);				\
  (void)(vs1^temp);				\
						\
  (void)(temp&vs1);				\
  (void)(temp|vs1);				\
  (void)(temp/vs1);				\
  (void)(temp^vs1);				\
						\
  (void)compare(vs1,vs2);			\
						\
  (void) (vs1 <  vs2);				\
  (void) (vs1 <= vs2);				\
  (void) (vs1 == vs2);				\
  (void) (vs1 != vs2);				\
  (void) (vs1 >= vs2);				\
  (void) (vs1 >  vs2);				\
						\
  (void) (vs1 <  temp);				\
  (void) (vs1 <= temp);				\
  (void) (vs1 == temp);				\
  (void) (vs1 != temp);				\
  (void) (vs1 >= temp);				\
  (void) (vs1 >  temp);				\
						\
  (void) (temp <  vs2);				\
  (void) (temp <= vs2);				\
  (void) (temp == vs2);				\
  (void) (temp != vs2);				\
  (void) (temp >= vs2);				\
  (void) (temp >  vs2);				\
  cout << vs1;					\
}

exercise_VS(int)
exercise_VS(IA_Bit)
exercise_VS(u_char)
//exercise_VS(char)
exercise_VS(float)
//exercise_VS(double)
exercise_VS(IA_FloatPoint)
exercise_VS(complex)

void dummy()
{
  nothing((int*)0);
  nothing((IA_Bit*)0);
  nothing((u_char*)0);
//  nothing((char*)0);
  nothing((float*)0);
  nothing((IA_FloatPoint*)0);
//  nothing((double*)0);
  nothing((complex*)0);
}

// pacify the cowardly template instantiator

ostream &operator<<(ostream&o,const IA_FloatPoint&)
{
    return o;
}

#define FP IA_Point<double>
#define PT IA_Point
// #define PT IA_FloatPoint

FP::PT(const FP&) { }


int pointcmp(const FP&, const FP&) {
  return 0;
}

int FP::operator< (const FP&) const { return 0; }
int FP::operator> (const FP&) const { return 0; }
FP& FP::operator= (const FP&) { return *this; }
int FP::operator!= (const FP&) const { return 0; }
int FP::operator== (const FP&) const { return 0; }

ostream & operator<<(ostream&o, complex) {
    return o;
}

void ia_throw(IA::Error, char*, int) { }
