// Emacs: -*- C++ -*-

//
//	Copyright 1993, Center for Computer Vision and Visualization,
//	University of Florida.  All rights reserved.
//

//static char copyright[] = "Copyright 1993, Center for Computer Vision and Visualization,\nUniversity of Florida.  All rights reserved.\n";

//static char rcsid[] = "$Id: YIPSIter.c,v 1.10 1994/10/06 17:39:00 fjsoria Exp $";

// 
// $Log: YIPSIter.c,v $
// Revision 1.10  1994/10/06  17:39:00  fjsoria
// commented rscid[] line
//
// Revision 1.9  1994/08/26  15:37:08  thoth
// DOS-inspired name rework (internal files)
//
// Revision 1.8  1994/07/25  16:58:52  thoth
// \Name sanitization
//
// Revision 1.7  1993/11/17  18:07:04  thoth
// IPSIter is now PSIter<IntPoint>
//
// Revision 1.6  1993/07/15  11:40:16  thoth
// new BasePSIter implementation.
//
// Revision 1.5  93/05/28  15:05:34  thoth
// removed dependency on with-ia-pointset*
// 
// Revision 1.4  93/05/26  16:57:53  thoth
// Copyright Notices
// 
// Revision 1.3  93/04/16  15:50:28  thoth
// use IA_IntPoint instead of IntPoint.
// 
// Revision 1.2  92/12/16  14:48:28  thoth
// conversion to IA_ mostly complete
// 
// Revision 1.1  92/08/23  13:30:21  thoth
// Initial revision
// 
// 

#include "PSIter.h"
#include "YIPSIter.h"

#ifdef IA_PRII
#pragma implementation
#endif

IA_YoderIPSIter::IA_YoderIPSIter(IA_YoderIPS *y)
:IA_BasePSIter<IA_Point<int> >(y)
{
    curr = yoder()->lastbefore+1;
    sliceidx = 0;
    subiter = 0;
}

IA_YoderIPSIter::IA_YoderIPSIter(const IA_YoderIPSIter &x)
:IA_BasePSIter<IA_Point<int> >(x.domain)
{
    curr = x.curr;
    sliceidx = x.sliceidx;
    subiter = x.subiter ? (new IA_PSIter<IA_Point<int> >(*x.subiter)) : 0;
}

int IA_YoderIPSIter::next(IA_Point<int>& ip)
{
    while (sliceidx < yoder()->nslices) {
	if (!subiter) {
	    // cout << "\n [" << yoder()->dimen << "]new slice at " << curr << " index " << sliceidx << ' ';
	    subiter = new IA_PSIter<IA_Point<int> >(yoder()->slices[sliceidx].shadow);
	}

	if ((*subiter)(ip)) {
	    ip = concat(curr,ip);
	    return 1;
	}

	// empty() optimization
	if (yoder()->slices[sliceidx].shadow.empty())
	    curr = 1+ yoder()->slices[sliceidx].last;
	else
	    curr++;
	
	if (curr<= yoder()->slices[sliceidx].last) {
	    // cout << "\n [" << yoder()->dimen << "]resetting slice iter for new curr" << curr << ' ';
	    subiter->reset();
	    continue;
	}

	delete subiter;
	subiter=0;

	sliceidx++;
    }
#if 0
    // gratuitous
    if (subiter) {
	delete subiter;
	subiter=0;
    }
#endif
    return 0;
}
