// Emacs: -*- C++ -*-

//
//	Copyright 1993, Center for Computer Vision and Visualization,
//	University of Florida.  All rights reserved.
//


// 
// $Log: ClosurePS.h,v $
// Revision 1.5  1993/11/17  18:02:03  thoth
// extensivep() is now extensive()
//
// Revision 1.4  1993/10/20  11:47:58  thoth
// New naming scheme.  Closures are named Closure.
//
// Revision 1.3  93/05/26  16:51:44  thoth
// Copyright Notices
//
// Revision 1.2  93/02/12  16:28:00  thoth
// more IA_ prefixes.
// 
// Revision 1.1  93/01/20  11:37:06  thoth
// Initial revision
// 
//

#ifndef PredicatePS_h_
#define PredicatePS_h_

#include "BasePS.h"

template <class P>
struct IA_ClosurePS: public IA_BasePS<P> {
private:
    static char type_;
public:
    IA_ClosurePS(unsigned dim)
    : IA_BasePS<P>(dim) {}
    virtual IA_ClosurePS<P> *clone_self() const=0;

    int equal(IA_BasePS<P>*other) const {
	return other->type()==this->type() &&
	    this == (IA_ClosurePS<P>*)other;
    }
    unsigned hash_self(unsigned mod) const {
	return mod-1;
    }
    static IA_PointSetType s_type() { return &type_; }
    virtual IA_PointSetType type() const { return &type_; }

    // this must be defined by the user
    // int contains (const P &ip) const;

    int extensive() const { return 0; }
    void output(ostream&, unsigned=0) const;
};

#endif
