// Emacs: -*- C++ -*-

//
//	Copyright 1993, Center for Computer Vision and Visualization,
//	University of Florida.  All rights reserved.
//


//
// $Log:	UcharDDTempl.h,v $
// Revision 1.3  93/05/27  11:22:41  thoth
// Copyright Notices
// 
// Revision 1.2  93/05/26  17:02:59  thoth
// constructors that specify pointsets aren't supported right now.
// 
// Revision 1.1  93/03/18  11:15:39  thoth
// Initial revision
// 

#ifndef UcharDDTempl_h_
#define UcharDDTempl_h_

#include "DDTempl.h"
#include "UcharDiscreteImage.h"

class IA_UcharDDTemplate: public IA_DDTemplate<IA_UcharDiscreteImage> {
  public:
//    IA_UcharDDTemplate(const IA_IntPointSet &ps,
//		       const IA_UcharDiscreteImage im)
//    :IA_DDTemplate<IA_UcharDiscreteImage>(ps, im) { }

    IA_UcharDDTemplate(unsigned dim, const IA_UcharDiscreteImage im)
    :IA_DDTemplate<IA_UcharDiscreteImage>(IA_WhiteHole(dim), im) { }

    IA_UcharDDTemplate(const IA_OtherDT< IA_UcharDiscreteImage > &o)
    :IA_DDTemplate<IA_UcharDiscreteImage>(o) { }

//    IA_UcharDDTemplate(const IA_IntPointSet &ps,
//		       IA_UcharDiscreteImage (*f)(const IA_IntPoint&))
//    :IA_DDTemplate<IA_UcharDiscreteImage>(ps, f) { }
    IA_UcharDDTemplate(unsigned dim,
		       IA_UcharDiscreteImage (*f)(const IA_IntPoint&))
    :IA_DDTemplate<IA_UcharDiscreteImage>(IA_WhiteHole(dim), f) { }
#include	"UcharConvolutions.h"
};

#endif
