// Emacs: -*- C++ -*-

//
//	Copyright 1993, Center for Computer Vision and Visualization,
//	University of Florida.  All rights reserved.
//


//
// $Log:	OtherCI.h,v $
// Revision 1.2  93/05/27  11:22:29  thoth
// Copyright Notices
// 
// Revision 1.1  93/05/26  17:18:22  thoth
// Initial revision
// 
// Revision 1.2  93/04/08  13:20:29  thoth
// *** empty log message ***
// 
// Revision 1.1  93/03/10  12:58:14  thoth
// Initial revision
// 

#ifndef OtherImage_h_
#define OtherImage_h_

#include "BaseCI.h"

// This class is designed for a user to derive from.

// The user must provide an operator() that maps a point
// from the image\'s domain onto the value at that point.
// The user must also provide a clone_self method which
// is needed by the container class.

template <class T>
class IA_OtherCI: public IA_BaseCI<T> {
 public:
    static char dummy;
 public:
    IA_OtherCI(IA_FloatPointSet ps_) :IA_BaseCI<T>(ps_) {}

    // most user-defined images will be non-extensive
    int extensivep() const { return 0; }

    static IA_ImageType s_type() { return &dummy; }

    IA_ImageType type() const { return &dummy; }

    ostream &print_this(ostream&) const;

    // Return a pointer to a copy of yourself on the heap.
    // If you do this wrong, images implemented using the
    // derived class will NOT work.
    virtual IA_OtherCI<T>* clone_self() const = 0;

    ////////////////////////////////////////////////////////////////
    // derived class MUST provide:
    // T operator()(const IA_FloatPoint&) const;
    // IA_OtherCI<T>* clone_self() const;

    // recommended:
    // ostream &print_this(ostream&) const;

    // perhaps (if you can do them faster...):
    // IA_ValueSet<T> range() const;
    // IA_BaseImage<T>* clone_self_extensively() const;

    // and if you want to be extensive:
    // T &operator[](const IA_FloatPoint&);
    // int extensivep() const { return 1; }
};

template <class T>
char IA_OtherCI<T>::dummy;


#endif
