// Emacs: -*- C++ -*-

// $Log:	FunctionDIPIter.h,v $
// Revision 1.2  93/01/19  14:54:44  jnw
// Modified to support IA_ naming convention
// 
// Revision 1.1  92/11/14  09:36:43  jnw
// Initial revision
// 

#ifndef FunctionDIPIter_h_
#define FunctionDIPIter_h_

#include <stdlib.h>
#include "IPSIter.h"
#include "BaseDIIter.h"
#include "FunctionDI.h"

template <class T>
class IA_FunctionDIPIter: public IA_BaseDIIter<T> {
protected:
    // curr stores the current point position of the iterator.
    IA_IntPoint curr;

    // bdip points at the base image over which we're iterating.
    IA_FunctionDI<T> *bdip;

    // psiter is an iterator over bdip's PointSet.
    IA_IPSIter psiter;

    // more is true if there are any points remaining to be returned
    // by next().
    int more;

public:

    IA_FunctionDIPIter(const IA_DiscreteImage<T> &, IA_FunctionDI<T> *);
    IA_FunctionDIPIter(const IA_FunctionDIPIter&);

    ~IA_FunctionDIPIter() {}

    IA_BaseDIIter<T> * clone_self() { return new IA_FunctionDIPIter(*this); }

    int next(IA_IntPoint&, T&);

    void reset() { psiter.reset(); this->more=psiter(curr);}

    IA_DiscreteImage<T> domain_() const { return this->domain; }
};

#endif
