// Emacs: -*- C++ -*-

// $Log:	FunctionDI.h,v $
// Revision 1.4  93/02/08  13:02:02  thoth
// static dummy member belongs in the .c file.
// 
// Revision 1.3  93/01/19  14:56:11  jnw
// Modified to support IA_ naming convention
// 
// Revision 1.2  92/11/14  09:37:29  jnw
// Modified to support new iterator classes
// 
// Revision 1.1  92/10/05  11:44:32  jnw
// Initial revision
// 

#ifndef FunctionDI_h_
#define FunctionDI_h_

#include <stream.h>
#include "IntPoint.h"
#include "IntPointSet.h"
#include "BaseDI.h"

template <class T> class IA_FunctionDIVIter;

template <class T> class IA_FunctionDIPIter;

template <class T>
class IA_FunctionDI: public IA_BaseDI<T>{
private:
    T (*func)(IA_IntPoint);

    static char dummy;
public:
    IA_FunctionDI(T (*fp)(IA_IntPoint), const IA_IntPointSet& p): IA_BaseDI<T>(p){
	this->func = fp;
    }

    int extensivep() const { return 0; }

    T operator ()(const IA_IntPoint&) const;

    static IA_DiscreteImageType s_type() { return &dummy; }
    IA_DiscreteImageType type() const { return &dummy; }

    int equal(const IA_BaseDI<T>* other) const;

    IA_BaseDI<T>* clone_self_extensively() const;

    ostream& print_this(ostream&) const;

    friend class IA_FunctionDIVIter<T>;
    friend class IA_FunctionDIPIter<T>;
};

#endif
