// Emacs: -*- C++ -*-

//
//	Copyright 1993, Center for Computer Vision and Visualization,
//	University of Florida.  All rights reserved.
//


// $Log:	DIVIter.h,v $
// Revision 1.5  93/05/27  11:19:38  thoth
// Copyright Notices
// 
// Revision 1.4  93/04/17  18:45:08  thoth
// Iterator support is no longer based on a switch statement.  We now
// use a virtual method.  The user can now provide faster iterators.
// 
// Revision 1.3  93/02/20  12:44:23  thoth
// There are now two sorts of BaseDIIters.
// ourDI data member seems useless.
// 
// Revision 1.2  93/01/19  14:56:00  jnw
// Modified to support IA_ naming convention
// 
// Revision 1.1  92/11/13  13:46:31  jnw
// Initial revision
// 
// Revision 1.1  92/10/05  11:46:34  jnw
// Initial revision
// 

#ifndef DIVIter_h_
#define DIVIter_h_

#ifdef IA_PRII
#pragma interface
#endif

#include "BaseDIIter.h"
#include "DiscreteImage.h"

template <class T>
class IA_DIVIter {
protected:
    IA_BaseDIVIter<T> *iter;
public:
    IA_DIVIter();
    IA_DIVIter(const IA_DiscreteImage<T> &image)
     { iter = image.bdip->value_iterator(); }

    IA_DIVIter(const IA_DIVIter &x) { this->iter = x.iter->clone_self(); }
    ~IA_DIVIter() { delete iter; }
    
    IA_DIVIter& operator=(const IA_DiscreteImage<T> &);
    IA_DIVIter& operator=(const IA_DIVIter &);
    
    IA_DiscreteImage<T> domain() { return iter->domain_(); }
    
    int operator() (T& pixel_value) {
	return this->iter->next(pixel_value);
    }

    void reset() { iter->reset(); }
};

#endif
