// Emacs: -*- C++ -*-

//
//	Copyright 1993, Center for Computer Vision and Visualization,
//	University of Florida.  All rights reserved.
//


// $Log:	DIPIter.h,v $
// Revision 1.5  93/05/27  11:19:36  thoth
// Copyright Notices
// 
// Revision 1.4  93/04/17  18:45:05  thoth
// Iterator support is no longer based on a switch statement.  We now
// use a virtual method.  The user can now provide faster iterators.
// 
// Revision 1.3  93/02/20  12:43:45  thoth
// There are now two sorts of BaseDIIters.
// ourDI data member seems useless.
// 
// Revision 1.2  93/01/19  14:55:56  jnw
// Modified to support IA_ naming convention
// 
// Revision 1.1  92/11/13  13:46:20  jnw
// Initial revision
// 

#ifndef DIPIter_h_
#define DIPIter_h_

#ifdef IA_PRII
#pragma interface
#endif

#include "BaseDIIter.h"
#include "DiscreteImage.h"

template <class T>
class IA_DIPIter {
protected:
    IA_BaseDIPIter<T> *iter;
    
public:
    IA_DIPIter();
    IA_DIPIter(const IA_DiscreteImage<T> &image)
    { iter = image.bdip->pixel_iterator(); }

    IA_DIPIter(const IA_DIPIter &x) { this->iter = x.iter->clone_self(); }
    ~IA_DIPIter() { if (iter) delete iter; }
    
    IA_DIPIter& operator=(const IA_DiscreteImage<T> &);
    IA_DIPIter& operator=(const IA_DIPIter &);
    
    IA_DiscreteImage<T> domain() { return iter->domain_(); }
    
    int operator() (IA_IntPoint& pixel_location, T& pixel_value) {
	return this->iter->next(pixel_location, pixel_value);
    }
    void reset() { iter->reset(); }
};

#endif
