// Emacs: -*- C++ -*-

//
//	Copyright 1993, Center for Computer Vision and Visualization,
//	University of Florida.  All rights reserved.
//

static char DIPIterrcsid[] = "$Id: DIPIter.c,v 1.8 93/05/27 11:28:19 thoth Exp $";

// 
// $Log:	DIPIter.c,v $
// Revision 1.8  93/05/27  11:28:19  thoth
// Copyright Notices
// 
// Revision 1.7  93/04/17  18:45:04  thoth
// Iterator support is no longer based on a switch statement.  We now
// use a virtual method.  The user can now provide faster iterators.
// 
// Revision 1.6  93/02/23  14:05:33  thoth
// We now have the OtherDI[VP]Iter.  All non-vector, non-const DIs will
// use this.  We may provide a way to override this in the future
// (virtual BaseDI[VP]Iter* BaseDI::iterator() const method?).
// 
// Revision 1.5  93/02/20  12:43:40  thoth
// There are now two sorts of BaseDIIters.
// 
// Revision 1.4  93/02/17  10:59:57  thoth
// fixed the make_x_iter invocations.
// 
// Revision 1.3  93/01/19  14:55:55  jnw
// Modified to support IA_ naming convention
// 
// Revision 1.2  92/11/14  09:39:18  jnw
// Modified to support new function image iterators
// 
// Revision 1.1  92/11/13  13:45:13  jnw
// Initial revision
// 
// Revision 1.1  92/10/05  11:46:31  jnw
// Initial revision
// 
//

#include "DIPIter.h"
#include "ConstDIPIter.h"
#include "VectorDIPIter.h"
#include "OtherDIIter.h"

template <class T>
class IA_errorDIPIter: public IA_BaseDIPIter<T> {
  public:
    IA_errorDIPIter() 
    :IA_BaseDIPIter<T>(0) {}

    virtual IA_BaseDIPIter<T> * clone_self() { 
	ia_throw( IA::IMAGE_REQUIRE_VALUE_ITER, __FILE__, __LINE__);
	return new IA_errorDIPIter;
    }

    virtual int next(IA_IntPoint&, T&) { 
	ia_throw( IA::IMAGE_REQUIRE_VALUE_ITER, __FILE__, __LINE__);
	return 0;
    }

    // this method resets the iterator to the beginning of the point set
    virtual void reset() { 
	ia_throw( IA::IMAGE_REQUIRE_VALUE_ITER, __FILE__, __LINE__);
    }

};

//
//
//

template <class T>
IA_DIPIter<T>::IA_DIPIter()
{
    iter = new IA_errorDIPIter<T>;
}

template <class T>
IA_DIPIter<T>& IA_DIPIter<T>::operator=(const IA_DiscreteImage<T> &image)
{
    delete this->iter;

    this->iter = image.bdip->pixel_iterator();

    return *this;
}

template <class T>
IA_DIPIter<T>& IA_DIPIter<T>::operator=(const IA_DIPIter<T> &x)
{
    if (x.iter==this->iter)
	return *this;

    delete this->iter;

    this->iter = x.iter->clone_self();

    return *this;
}
