// Emacs: -*- C++ -*-

//
//	Copyright 1993, Center for Computer Vision and Visualization,
//	University of Florida.  All rights reserved.
//


// $Log:	ConstDIVIter.h,v $
// Revision 1.6  93/05/27  11:19:31  thoth
// Copyright Notices
// 
// Revision 1.5  93/04/17  18:46:58  thoth
// Iterator support is no longer based on a switch statement.  We now
// use a virtual method.  The user can now provide faster iterators.
// 
// Revision 1.4  93/02/20  12:43:32  thoth
// There are now two sorts of BaseDIIters.
// 
// Revision 1.3  93/02/08  12:56:04  thoth
// order of arguments was confused.
// 
// Revision 1.2  93/01/19  14:55:53  jnw
// Modified to support IA_ naming convention
// 
// Revision 1.1  92/11/12  17:04:55  jnw
// Initial revision
// 
// Revision 1.1  92/10/05  11:45:54  jnw
// Initial revision
// 

#ifndef ConstDIVIter_h_
#define ConstDIVIter_h_

#include <stdlib.h>
#include "IPSIter.h"
#include "BaseDIIter.h"
#include "ConstDI.h"


template <class T>
class IA_ConstDIVIter: public IA_BaseDIVIter<T> {
protected:
    // num_left stores the number of elements in the image\'s pointset
    // over which we must still iterate
    int num_left;

    // bdip points at the base image over which we're iterating.
    IA_ConstDI<T> *cdip() const { return (IA_ConstDI<T> *)domain; }

public:

    IA_ConstDIVIter(const IA_ConstDI<T> *);
    IA_ConstDIVIter(const IA_ConstDIVIter&);

    ~IA_ConstDIVIter() {}

    IA_BaseDIVIter<T> * clone_self() { return new IA_ConstDIVIter(*this); }
    int next(T&);

    void reset() { this->num_left= this->domain->domain().card(); }

    IA_BaseDI<T> *domain_() const { return this->domain; }
};

#endif
