// Emacs: -*- C++ -*-

//
//	Copyright 1993, Center for Computer Vision and Visualization,
//	University of Florida.  All rights reserved.
//


// $Log:	ConstDIPIter.h,v $
// Revision 1.6  93/05/27  11:19:30  thoth
// Copyright Notices
// 
// Revision 1.5  93/04/17  18:46:53  thoth
// Iterator support is no longer based on a switch statement.  We now
// use a virtual method.  The user can now provide faster iterators.
// 
// Revision 1.4  93/02/20  12:43:28  thoth
// There are now two sorts of BaseDIIters.
// 
// Revision 1.3  93/01/19  14:55:50  jnw
// Modified to support IA_ naming convention
// 
// Revision 1.2  92/11/12  17:03:49  jnw
// Modified to match new pixel/value iter style
// 
// Revision 1.1  92/10/05  11:45:49  jnw
// Initial revision
// 

#ifndef ConstDIPIter_h_
#define ConstDIPIter_h_

#include <stdlib.h>
#include "IPSIter.h"
#include "BaseDIIter.h"
#include "ConstDI.h"


template <class T>
class IA_ConstDIPIter: public IA_BaseDIPIter<T> {
protected:
    // bdip points at the base image over which we're iterating.
    IA_ConstDI<T> *cdip() const { return (IA_ConstDI<T>*)domain; }
    
    // psiter is an iterator over bdip's PointSet.
    IA_IPSIter psiter;
    
public:
    
    IA_ConstDIPIter(const IA_ConstDI<T> *);
    IA_ConstDIPIter(const IA_ConstDIPIter&);
    
    ~IA_ConstDIPIter() {}
    
    IA_BaseDIPIter<T> * clone_self() { return new IA_ConstDIPIter(*this); }
    
    int next(IA_IntPoint&, T&);
    void reset() { psiter.reset(); }
    
    IA_BaseDI<T> *domain_() const { return this->domain; }
};

#endif
