#!/local/bin/perl

sub usage {
    print STDERR <<EOF
  Usage: $0 native-point native-type
Replaces instances of IA_Image<P,T> with IA_CoreImage<P,T> if
P!=native-point or T!=native-type.  This is necessary because CFront
does not yet allow forward declaration of template specializations and
because various IA_Image<P,T> specializations have intertwining
references.
EOF
;
    exit 1;
}

sub convert {
    local($P,$T) = @_;
    return ( ($P ne $point || $T ne $type) ? "IA_CoreImage" : "IA_Image" )
	. "<" . $P . ", " . $T . ">";
}


($point, $type, @rest) = @ARGV;
&usage if @ARGV != 2;

while (<STDIN>) {
    s/IA_Image\s*<\s*(\w+)\s*,\s*(\w+)\s*>/&convert($1,$2)/ge;
    print;
}
