// Emacs: -*- C++ -*-

//
//	Copyright 1993, Center for Computer Vision and Visualization,
//	University of Florida.  All rights reserved.
//


//
// $Log: chi_contains.c,v $
// Revision 1.2  1994/01/07  15:12:35  thoth
// Image class is now CoreImage and named image types are
// Image<P,T>.
//
// Revision 1.1  1993/12/29  15:44:32  thoth
// Initial revision
//

#include "CoreImage.h"
#include "VectorI.h"
#include "ConstI.h"

typedef int ATYPE;

template <class P, class T>
IA_CoreImage<P, ATYPE>
vec_chi_contains(const IA_VectorI<P, T> *lhs, const IA_ValueSet<T> &rhs)
{
    const IA_IntPointSet domain = lhs->domain();
    const unsigned sz = domain.card();
    ATYPE *const vec = new ATYPE[sz];

    {
	ATYPE *ds = vec;
	const T *ls = lhs->vec;
	for (unsigned i=0; i<sz; i++) {
	    *(ds++) = rhs.contains(*ls);
	    ls++;
	}
    }
    return IA_CoreImage<P, ATYPE>(domain, vec, sz, 1);
}


// scalar-scalar operation is trivial


template <class P, class T>
IA_CoreImage<P, ATYPE>
iter_chi_contains(IA_CoreImage<P, T> lhs, const IA_ValueSet<T> &rhs)
{
    const IA_IntPointSet domain = lhs.domain();
    const unsigned sz = domain.card();
    ATYPE *const vec = new ATYPE[sz];

    {
	ATYPE *ds = vec;
	T ltmp;
	IA_IVIter<P, T>	liter(lhs);
	for (unsigned i=0; i<sz; i++) {
	    liter(ltmp);
	    *(ds++) = rhs.contains(ltmp);
	}
    }
    return IA_CoreImage<P, ATYPE>(domain, vec, sz, 1);
}


template <class P, class T>
IA_CoreImage<P, ATYPE>
chi_contains ( const IA_CoreImage<P, T> &lhs, const IA_ValueSet<T> &rhs)
{
    if (lhs.type() == IA_VectorI<P, T>::s_type()) {
	return vec_chi_contains((IA_VectorI<P, T> *)lhs.bip,rhs);
    } else if (lhs.type() == IA_ConstI<P, T>::s_type()) {
	return IA_CoreImage<P, ATYPE> (lhs.domain(), rhs.contains(((IA_ConstI<P, T> *)lhs.bip)->value));
    } else {
	return iter_chi_contains(lhs,rhs);
    }
}
